/* valadbusclientmodule.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
*  Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;
typedef struct _ValaGErrorModulePrivate ValaGErrorModulePrivate;

#define VALA_TYPE_GTYPE_MODULE (vala_gtype_module_get_type ())
#define VALA_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModule))
#define VALA_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))
#define VALA_IS_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GTYPE_MODULE))
#define VALA_IS_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GTYPE_MODULE))
#define VALA_GTYPE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))

typedef struct _ValaGTypeModule ValaGTypeModule;
typedef struct _ValaGTypeModuleClass ValaGTypeModuleClass;
typedef struct _ValaGTypeModulePrivate ValaGTypeModulePrivate;

#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;

#define VALA_TYPE_GOBJECT_MODULE (vala_gobject_module_get_type ())
#define VALA_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule))
#define VALA_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))
#define VALA_IS_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GOBJECT_MODULE))
#define VALA_IS_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GOBJECT_MODULE))
#define VALA_GOBJECT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))

typedef struct _ValaGObjectModule ValaGObjectModule;
typedef struct _ValaGObjectModuleClass ValaGObjectModuleClass;
typedef struct _ValaGObjectModulePrivate ValaGObjectModulePrivate;

#define VALA_TYPE_GSIGNAL_MODULE (vala_gsignal_module_get_type ())
#define VALA_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule))
#define VALA_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))
#define VALA_IS_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_IS_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_GSIGNAL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))

typedef struct _ValaGSignalModule ValaGSignalModule;
typedef struct _ValaGSignalModuleClass ValaGSignalModuleClass;
typedef struct _ValaGSignalModulePrivate ValaGSignalModulePrivate;

#define VALA_TYPE_GASYNC_MODULE (vala_gasync_module_get_type ())
#define VALA_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModule))
#define VALA_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))
#define VALA_IS_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GASYNC_MODULE))
#define VALA_IS_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GASYNC_MODULE))
#define VALA_GASYNC_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))

typedef struct _ValaGAsyncModule ValaGAsyncModule;
typedef struct _ValaGAsyncModuleClass ValaGAsyncModuleClass;
typedef struct _ValaGAsyncModulePrivate ValaGAsyncModulePrivate;

#define VALA_TYPE_DBUS_MODULE (vala_dbus_module_get_type ())
#define VALA_DBUS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_MODULE, ValaDBusModule))
#define VALA_DBUS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_MODULE, ValaDBusModuleClass))
#define VALA_IS_DBUS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_MODULE))
#define VALA_IS_DBUS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_MODULE))
#define VALA_DBUS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_MODULE, ValaDBusModuleClass))

typedef struct _ValaDBusModule ValaDBusModule;
typedef struct _ValaDBusModuleClass ValaDBusModuleClass;
typedef struct _ValaDBusModulePrivate ValaDBusModulePrivate;

#define VALA_TYPE_DBUS_CLIENT_MODULE (vala_dbus_client_module_get_type ())
#define VALA_DBUS_CLIENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModule))
#define VALA_DBUS_CLIENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModuleClass))
#define VALA_IS_DBUS_CLIENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_CLIENT_MODULE))
#define VALA_IS_DBUS_CLIENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_CLIENT_MODULE))
#define VALA_DBUS_CLIENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModuleClass))

typedef struct _ValaDBusClientModule ValaDBusClientModule;
typedef struct _ValaDBusClientModuleClass ValaDBusClientModuleClass;
typedef struct _ValaDBusClientModulePrivate ValaDBusClientModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

#define VALA_TYPE_INTERFACE_REGISTER_FUNCTION (vala_interface_register_function_get_type ())
#define VALA_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunction))
#define VALA_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionClass))
#define VALA_IS_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION))
#define VALA_IS_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE_REGISTER_FUNCTION))
#define VALA_INTERFACE_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionClass))

typedef struct _ValaInterfaceRegisterFunction ValaInterfaceRegisterFunction;
typedef struct _ValaInterfaceRegisterFunctionClass ValaInterfaceRegisterFunctionClass;

#define VALA_TYPE_DBUS_INTERFACE_REGISTER_FUNCTION (vala_dbus_interface_register_function_get_type ())
#define VALA_DBUS_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DBUS_INTERFACE_REGISTER_FUNCTION, ValaDBusInterfaceRegisterFunction))
#define VALA_DBUS_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DBUS_INTERFACE_REGISTER_FUNCTION, ValaDBusInterfaceRegisterFunctionClass))
#define VALA_IS_DBUS_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DBUS_INTERFACE_REGISTER_FUNCTION))
#define VALA_IS_DBUS_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DBUS_INTERFACE_REGISTER_FUNCTION))
#define VALA_DBUS_INTERFACE_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DBUS_INTERFACE_REGISTER_FUNCTION, ValaDBusInterfaceRegisterFunctionClass))

typedef struct _ValaDBusInterfaceRegisterFunction ValaDBusInterfaceRegisterFunction;
typedef struct _ValaDBusInterfaceRegisterFunctionClass ValaDBusInterfaceRegisterFunctionClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	char* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
	gboolean (*variable_accessible_in_finally) (ValaCCodeBaseModule* self, ValaLocalVariable* local);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};

struct _ValaGErrorModule {
	ValaCCodeDelegateModule parent_instance;
	ValaGErrorModulePrivate * priv;
};

struct _ValaGErrorModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
	ValaCCodeStatement* (*return_with_exception) (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
};

struct _ValaGTypeModule {
	ValaGErrorModule parent_instance;
	ValaGTypeModulePrivate * priv;
};

struct _ValaGTypeModuleClass {
	ValaGErrorModuleClass parent_class;
	void (*generate_virtual_method_declaration) (ValaGTypeModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
	void (*generate_class_init) (ValaGTypeModule* self, ValaClass* cl, ValaCCodeBlock* init_block);
	ValaTypeRegisterFunction* (*create_interface_register_function) (ValaGTypeModule* self, ValaInterface* iface);
};

struct _ValaGObjectModule {
	ValaGTypeModule parent_instance;
	ValaGObjectModulePrivate * priv;
};

struct _ValaGObjectModuleClass {
	ValaGTypeModuleClass parent_class;
};

struct _ValaGSignalModule {
	ValaGObjectModule parent_instance;
	ValaGSignalModulePrivate * priv;
};

struct _ValaGSignalModuleClass {
	ValaGObjectModuleClass parent_class;
	ValaCCodeExpression* (*get_dbus_g_type) (ValaGSignalModule* self, ValaDataType* data_type);
};

struct _ValaGAsyncModule {
	ValaGSignalModule parent_instance;
	ValaGAsyncModulePrivate * priv;
};

struct _ValaGAsyncModuleClass {
	ValaGSignalModuleClass parent_class;
};

struct _ValaDBusModule {
	ValaGAsyncModule parent_instance;
	ValaDBusModulePrivate * priv;
};

struct _ValaDBusModuleClass {
	ValaGAsyncModuleClass parent_class;
};

/**
 * The link between a dynamic method and generated code.
 */
struct _ValaDBusClientModule {
	ValaDBusModule parent_instance;
	ValaDBusClientModulePrivate * priv;
};

struct _ValaDBusClientModuleClass {
	ValaDBusModuleClass parent_class;
};

struct _ValaDBusClientModulePrivate {
	gint dynamic_property_id;
};


static gpointer vala_dbus_client_module_parent_class = NULL;

gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
GType vala_ccode_delegate_module_get_type (void);
GType vala_gerror_module_get_type (void);
GType vala_gtype_module_get_type (void);
gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void);
GType vala_gobject_module_get_type (void);
GType vala_gsignal_module_get_type (void);
GType vala_gasync_module_get_type (void);
GType vala_dbus_module_get_type (void);
GType vala_dbus_client_module_get_type (void);
#define VALA_DBUS_CLIENT_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DBUS_CLIENT_MODULE, ValaDBusClientModulePrivate))
enum  {
	VALA_DBUS_CLIENT_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaDBusModule* vala_dbus_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaDBusModule* vala_dbus_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaDBusClientModule* vala_dbus_client_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaDBusClientModule* vala_dbus_client_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self);
static char* vala_dbus_client_module_get_dynamic_dbus_name (ValaDBusClientModule* self, const char* vala_name);
void vala_ccode_base_module_generate_cparameters (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
static void vala_dbus_client_module_generate_dbus_method_wrapper (ValaDBusClientModule* self, ValaMethod* method, ValaCCodeBlock* block);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_dbus_client_module_real_generate_dynamic_method_wrapper (ValaCCodeModule* base, ValaDynamicMethod* method);
gboolean vala_dbus_client_module_dbus_use_ptr_array (ValaDBusClientModule* self, ValaArrayType* array_type);
ValaCCodeExpression* vala_gsignal_module_get_dbus_g_type (ValaGSignalModule* self, ValaDataType* data_type);
gboolean vala_ccode_declaration_space_add_declaration (ValaCCodeDeclarationSpace* self, const char* name);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
void vala_ccode_declaration_space_add_include (ValaCCodeDeclarationSpace* self, const char* filename, gboolean local);
char* vala_dbus_module_get_type_signature (ValaDataType* datatype);
gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
ValaCCodeExpression* vala_ccode_base_module_default_value_for_type (ValaCCodeBaseModule* self, ValaDataType* type, gboolean initializer_expression);
static ValaCCodeExpression* vala_dbus_client_module_real_get_dbus_g_type (ValaGSignalModule* base, ValaDataType* data_type);
char* vala_ccode_module_get_dynamic_property_getter_cname (ValaCCodeModule* self, ValaDynamicProperty* node);
static void vala_dbus_client_module_generate_dbus_property_getter_wrapper (ValaDBusClientModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
static char* vala_dbus_client_module_real_get_dynamic_property_getter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop);
char* vala_ccode_module_get_dynamic_property_setter_cname (ValaCCodeModule* self, ValaDynamicProperty* node);
static void vala_dbus_client_module_generate_dbus_property_setter_wrapper (ValaDBusClientModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
static char* vala_dbus_client_module_real_get_dynamic_property_setter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop);
static void vala_dbus_client_module_create_dbus_property_proxy (ValaDBusClientModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
char* vala_ccode_module_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* self, ValaDynamicSignal* node);
char* vala_ccode_module_get_dynamic_signal_cname (ValaCCodeModule* self, ValaDynamicSignal* node);
static void vala_dbus_client_module_generate_dbus_connect_wrapper (ValaDBusClientModule* self, ValaDynamicSignal* sig, ValaCCodeBlock* block);
static char* vala_dbus_client_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* base, ValaDynamicSignal* sig);
char* vala_ccode_module_get_dynamic_signal_disconnect_wrapper_name (ValaCCodeModule* self, ValaDynamicSignal* node);
static void vala_dbus_client_module_generate_dbus_disconnect_wrapper (ValaDBusClientModule* self, ValaDynamicSignal* sig, ValaCCodeBlock* block);
static char* vala_dbus_client_module_real_get_dynamic_signal_disconnect_wrapper_name (ValaCCodeModule* base, ValaDynamicSignal* sig);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_module_generate_marshaller (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
char* vala_ccode_module_get_marshaller_function (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
void vala_ccode_module_visit_cast_expression (ValaCCodeModule* self, ValaCastExpression* expr);
static void vala_dbus_client_module_real_visit_cast_expression (ValaCCodeModule* base, ValaCastExpression* expr);
void vala_ccode_module_visit_interface (ValaCCodeModule* self, ValaInterface* iface);
void vala_ccode_declaration_space_add_type_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
void vala_ccode_declaration_space_add_type_definition (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_dbus_client_module_generate_proxy_filter_function (ValaDBusClientModule* self, ValaInterface* iface);
static char* vala_dbus_client_module_generate_dbus_proxy_method (ValaDBusClientModule* self, ValaInterface* iface, ValaMethod* m);
static char* vala_dbus_client_module_generate_async_dbus_proxy_method (ValaDBusClientModule* self, ValaInterface* iface, ValaMethod* m);
static char* vala_dbus_client_module_generate_finish_dbus_proxy_method (ValaDBusClientModule* self, ValaInterface* iface, ValaMethod* m);
static char* vala_dbus_client_module_generate_dbus_proxy_property_get (ValaDBusClientModule* self, ValaInterface* iface, ValaProperty* prop);
static char* vala_dbus_client_module_generate_dbus_proxy_property_set (ValaDBusClientModule* self, ValaInterface* iface, ValaProperty* prop);
static void vala_dbus_client_module_real_visit_interface (ValaCCodeModule* base, ValaInterface* iface);
ValaInterfaceRegisterFunction* vala_interface_register_function_new (ValaInterface* iface, ValaCodeContext* context);
ValaInterfaceRegisterFunction* vala_interface_register_function_construct (GType object_type, ValaInterface* iface, ValaCodeContext* context);
GType vala_interface_register_function_get_type (void);
ValaDBusInterfaceRegisterFunction* vala_dbus_interface_register_function_new (ValaInterface* iface, ValaCodeContext* context);
ValaDBusInterfaceRegisterFunction* vala_dbus_interface_register_function_construct (GType object_type, ValaInterface* iface, ValaCodeContext* context);
GType vala_dbus_interface_register_function_get_type (void);
static ValaTypeRegisterFunction* vala_dbus_client_module_real_create_interface_register_function (ValaGTypeModule* base, ValaInterface* iface);
void vala_ccode_module_visit_method_call (ValaCCodeModule* self, ValaMethodCall* expr);
static void vala_dbus_client_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr);
static void vala_dbus_client_module_handle_signals (ValaDBusClientModule* self, ValaInterface* iface, ValaCCodeBlock* block);
ValaCCodeExpression* vala_dbus_module_read_expression (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
static char* vala_dbus_client_module_generate_dbus_signal_handler (ValaDBusClientModule* self, ValaSignal* sig, ValaObjectTypeSymbol* sym);
static void vala_dbus_client_module_handle_signal (ValaDBusClientModule* self, const char* dbus_iface_name, const char* dbus_signal_name, const char* handler_name, ValaCCodeBlock* block, ValaCCodeIfStatement** clastif);
void vala_dbus_module_write_expression (ValaDBusModule* self, ValaCCodeFragment* fragment, ValaDataType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* expr);
static void vala_dbus_client_module_generate_marshalling (ValaDBusClientModule* self, ValaMethod* m, const char* dbus_iface_name, ValaCCodeFragment* prefragment, ValaCCodeFragment* postfragment);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
static void vala_dbus_client_module_finalize (ValaCCodeModule* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaDBusClientModule* vala_dbus_client_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaDBusClientModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaDBusClientModule*) vala_dbus_module_construct (object_type, codegen, next);
	return self;
}


ValaDBusClientModule* vala_dbus_client_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_dbus_client_module_construct (VALA_TYPE_DBUS_CLIENT_MODULE, codegen, next);
}


static char* vala_dbus_client_module_get_dynamic_dbus_name (ValaDBusClientModule* self, const char* vala_name) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (vala_name != NULL, NULL);
	/* TODO switch default to no transformation as soon as we have static D-Bus client support
	 keep transformation by default for static D-Bus client and server support*/
	if (vala_code_context_get_dbus_transformation (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self))) {
		result = vala_symbol_lower_case_to_camel_case (vala_name);
		return result;
	} else {
		const char* _tmp0_;
		_tmp0_ = NULL;
		result = (_tmp0_ = vala_name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
		return result;
	}
}


static void vala_dbus_client_module_real_generate_dynamic_method_wrapper (ValaCCodeModule* base, ValaDynamicMethod* method) {
	ValaDBusClientModule * self;
	ValaDynamicMethod* _tmp0_;
	ValaDynamicMethod* dynamic_method;
	char* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* func;
	GeeHashMap* cparam_map;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp5_;
	self = (ValaDBusClientModule*) base;
	g_return_if_fail (method != NULL);
	_tmp0_ = NULL;
	dynamic_method = (_tmp0_ = VALA_DYNAMIC_METHOD (method), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	func = (_tmp2_ = vala_ccode_function_new (_tmp1_ = vala_method_get_cname ((ValaMethod*) method), "void"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, (ValaMethod*) method, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, func, NULL, NULL, NULL, 3);
	block = vala_ccode_block_new ();
	if (vala_data_type_get_data_type (vala_dynamic_method_get_dynamic_type (dynamic_method)) == ((ValaCCodeBaseModule*) self)->dbus_object_type) {
		vala_dbus_client_module_generate_dbus_method_wrapper (self, (ValaMethod*) method, block);
	} else {
		char* _tmp4_;
		char* _tmp3_;
		_tmp4_ = NULL;
		_tmp3_ = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) method), _tmp4_ = g_strdup_printf ("dynamic methods are not supported for `%s'", _tmp3_ = vala_code_node_to_string ((ValaCodeNode*) vala_dynamic_method_get_dynamic_type (dynamic_method))));
		_tmp4_ = (g_free (_tmp4_), NULL);
		_tmp3_ = (g_free (_tmp3_), NULL);
	}
	/* append to C source file*/
	_tmp5_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp5_ = vala_ccode_function_copy (func)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
	(func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL));
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
}


static void vala_dbus_client_module_generate_dbus_method_wrapper (ValaDBusClientModule* self, ValaMethod* method, ValaCCodeBlock* block) {
	ValaDynamicMethod* _tmp0_;
	ValaDynamicMethod* dynamic_method;
	ValaMethodCall* _tmp1_;
	ValaMethodCall* expr;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp4_;
	gboolean found_out;
	ValaExpression* callback;
	gint callback_index;
	gint arg_index;
	ValaCCodeConstant* _tmp13_;
	char* _tmp12_;
	char* _tmp11_;
	ValaCCodeIdentifier* _tmp155_;
	ValaCCodeFragment* out_marshalling_fragment;
	g_return_if_fail (self != NULL);
	g_return_if_fail (method != NULL);
	g_return_if_fail (block != NULL);
	_tmp0_ = NULL;
	dynamic_method = (_tmp0_ = VALA_DYNAMIC_METHOD (method), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	_tmp1_ = NULL;
	expr = (_tmp1_ = vala_dynamic_method_get_invocation (dynamic_method), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	ccall = (_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("dbus_g_proxy_begin_call"))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL)), _tmp3_);
	_tmp4_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("self")));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	found_out = FALSE;
	callback = NULL;
	callback_index = -1;
	arg_index = 1;
	{
		GeeList* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _arg_it;
		_tmp5_ = NULL;
		_tmp6_ = NULL;
		_arg_it = (_tmp6_ = gee_iterable_iterator ((GeeIterable*) (_tmp5_ = vala_method_call_get_argument_list (expr))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (gee_collection_object_unref (_tmp5_), NULL)), _tmp6_);
		while (TRUE) {
			ValaExpression* arg;
			if (!gee_iterator_next (_arg_it)) {
				break;
			}
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			if (VALA_IS_METHOD (vala_expression_get_symbol_reference (arg))) {
				ValaExpression* _tmp8_;
				ValaExpression* _tmp7_;
				/* callback*/
				if (callback != NULL) {
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), "only one reply callback may be specified in invocation of DBus method");
					vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
					(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
					(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
					(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
					(callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL));
					return;
				} else {
					if (found_out) {
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), "out argument and reply callback conflict in invocation of DBus method");
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
						(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
						(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
						(callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL));
						return;
					}
				}
				_tmp8_ = NULL;
				_tmp7_ = NULL;
				callback = (_tmp8_ = (_tmp7_ = arg, (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_)), (callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL)), _tmp8_);
				callback_index = arg_index;
			} else {
				gboolean _tmp9_;
				_tmp9_ = FALSE;
				if (VALA_IS_UNARY_EXPRESSION (arg)) {
					_tmp9_ = vala_unary_expression_get_operator (VALA_UNARY_EXPRESSION (arg)) == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					/* out arg*/
					if (callback != NULL) {
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), "out argument and reply callback conflict in invocation of DBus method");
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
						(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
						(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
						(callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL));
						return;
					}
					found_out = TRUE;
				} else {
					gboolean _tmp10_;
					_tmp10_ = FALSE;
					if (callback != NULL) {
						_tmp10_ = TRUE;
					} else {
						_tmp10_ = found_out;
					}
					/* in arg*/
					if (_tmp10_) {
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), "in argument must not follow out argument or reply callback in invocation of DBus method");
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
						(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
						(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
						(callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL));
						return;
					}
				}
			}
			arg_index++;
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_constant_new (_tmp12_ = g_strdup_printf ("\"%s\"", _tmp11_ = vala_dbus_client_module_get_dynamic_dbus_name (self, vala_symbol_get_name ((ValaSymbol*) method))))));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	_tmp12_ = (g_free (_tmp12_), NULL);
	_tmp11_ = (g_free (_tmp11_), NULL);
	if (callback != NULL) {
		ValaMethod* _tmp14_;
		ValaMethod* reply_method;
		char* _tmp16_;
		char* _tmp15_;
		ValaCCodeFunction* _tmp17_;
		ValaCCodeFunction* cb_fun;
		ValaCCodeFormalParameter* _tmp18_;
		ValaCCodeFormalParameter* _tmp19_;
		ValaCCodeFormalParameter* _tmp20_;
		ValaCCodeBlock* _tmp21_;
		ValaCCodeDeclaration* cerrdecl;
		ValaCCodeVariableDeclarator* _tmp23_;
		ValaCCodeConstant* _tmp22_;
		ValaCCodeIdentifier* _tmp24_;
		ValaCCodeFunctionCall* _tmp25_;
		ValaCCodeFunctionCall* cend_call;
		ValaCCodeIdentifier* _tmp26_;
		ValaCCodeIdentifier* _tmp27_;
		ValaCCodeUnaryExpression* _tmp29_;
		ValaCCodeIdentifier* _tmp28_;
		ValaCCodeFunctionCall* creply_call;
		GeeList* _tmp31_;
		gint _tmp32_;
		gint param_count;
		gint i;
		ValaCCodeIdentifier* _tmp59_;
		ValaCCodeExpressionStatement* _tmp60_;
		ValaCCodeIdentifier* _tmp61_;
		ValaCCodeExpressionStatement* _tmp62_;
		ValaCCodeIdentifier* _tmp63_;
		ValaCCodeConstant* _tmp65_;
		char* _tmp64_;
		ValaCCodeConstant* _tmp66_;
		_tmp14_ = NULL;
		reply_method = (_tmp14_ = VALA_METHOD (vala_expression_get_symbol_reference (callback)), (_tmp14_ == NULL) ? NULL : vala_code_node_ref (_tmp14_));
		_tmp16_ = NULL;
		_tmp15_ = NULL;
		_tmp17_ = NULL;
		cb_fun = (_tmp17_ = vala_ccode_function_new (_tmp16_ = g_strdup_printf ("_%s_cb", _tmp15_ = vala_method_get_cname (reply_method)), "void"), _tmp16_ = (g_free (_tmp16_), NULL), _tmp15_ = (g_free (_tmp15_), NULL), _tmp17_);
		vala_ccode_function_set_modifiers (cb_fun, VALA_CCODE_MODIFIERS_STATIC);
		_tmp18_ = NULL;
		vala_ccode_function_add_parameter (cb_fun, _tmp18_ = vala_ccode_formal_parameter_new ("proxy", "DBusGProxy*"));
		(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
		_tmp19_ = NULL;
		vala_ccode_function_add_parameter (cb_fun, _tmp19_ = vala_ccode_formal_parameter_new ("call", "DBusGProxyCall*"));
		(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
		_tmp20_ = NULL;
		vala_ccode_function_add_parameter (cb_fun, _tmp20_ = vala_ccode_formal_parameter_new ("user_data", "void*"));
		(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
		_tmp21_ = NULL;
		vala_ccode_function_set_block (cb_fun, _tmp21_ = vala_ccode_block_new ());
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
		cerrdecl = vala_ccode_declaration_new ("GError*");
		_tmp23_ = NULL;
		_tmp22_ = NULL;
		vala_ccode_declaration_add_declarator (cerrdecl, (ValaCCodeDeclarator*) (_tmp23_ = vala_ccode_variable_declarator_new ("error", (ValaCCodeExpression*) (_tmp22_ = vala_ccode_constant_new ("NULL")), NULL)));
		(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), (ValaCCodeNode*) cerrdecl);
		_tmp24_ = NULL;
		_tmp25_ = NULL;
		cend_call = (_tmp25_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("dbus_g_proxy_end_call"))), (_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL)), _tmp25_);
		_tmp26_ = NULL;
		vala_ccode_function_call_add_argument (cend_call, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new ("proxy")));
		(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
		_tmp27_ = NULL;
		vala_ccode_function_call_add_argument (cend_call, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("call")));
		(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
		_tmp29_ = NULL;
		_tmp28_ = NULL;
		vala_ccode_function_call_add_argument (cend_call, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new ("error")))));
		(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
		(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
		creply_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) callback)));
		if (vala_method_get_binding (reply_method) != MEMBER_BINDING_STATIC) {
			ValaCCodeIdentifier* _tmp30_;
			_tmp30_ = NULL;
			vala_ccode_function_call_add_argument (creply_call, (ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("user_data")));
			(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
		}
		_tmp31_ = NULL;
		param_count = (_tmp32_ = gee_collection_get_size ((GeeCollection*) (_tmp31_ = vala_method_get_parameters (reply_method))), (_tmp31_ == NULL) ? NULL : (_tmp31_ = (gee_collection_object_unref (_tmp31_), NULL)), _tmp32_);
		i = 0;
		{
			GeeList* _tmp33_;
			GeeIterator* _tmp34_;
			GeeIterator* _param_it;
			_tmp33_ = NULL;
			_tmp34_ = NULL;
			_param_it = (_tmp34_ = gee_iterable_iterator ((GeeIterable*) (_tmp33_ = vala_method_get_parameters (reply_method))), (_tmp33_ == NULL) ? NULL : (_tmp33_ = (gee_collection_object_unref (_tmp33_), NULL)), _tmp34_);
			while (TRUE) {
				ValaFormalParameter* param;
				gboolean _tmp35_;
				if (!gee_iterator_next (_param_it)) {
					break;
				}
				param = (ValaFormalParameter*) gee_iterator_get (_param_it);
				if ((i = i + 1) == param_count) {
					if (!VALA_IS_ERROR_TYPE (vala_formal_parameter_get_parameter_type (param))) {
						vala_report_error (NULL, "DBus reply callbacks must end with GLib.Error argument");
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
						(reply_method == NULL) ? NULL : (reply_method = (vala_code_node_unref (reply_method), NULL));
						(cb_fun == NULL) ? NULL : (cb_fun = (vala_ccode_node_unref (cb_fun), NULL));
						(cerrdecl == NULL) ? NULL : (cerrdecl = (vala_ccode_node_unref (cerrdecl), NULL));
						(cend_call == NULL) ? NULL : (cend_call = (vala_ccode_node_unref (cend_call), NULL));
						(creply_call == NULL) ? NULL : (creply_call = (vala_ccode_node_unref (creply_call), NULL));
						(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
						(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
						(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
						(callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL));
						return;
					}
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					break;
				}
				_tmp35_ = FALSE;
				if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					_tmp35_ = vala_data_type_get_data_type (vala_array_type_get_element_type (VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)))) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					ValaArrayType* _tmp36_;
					ValaArrayType* array_type;
					ValaCCodeDeclaration* _cdecl_;
					ValaCCodeVariableDeclarator* _tmp39_;
					ValaCCodeExpression* _tmp40_;
					ValaCCodeUnaryExpression* _tmp42_;
					ValaCCodeIdentifier* _tmp41_;
					const char* _tmp43_;
					ValaCCodeMemberAccess* _tmp45_;
					ValaCCodeIdentifier* _tmp44_;
					ValaCCodeMemberAccess* _tmp47_;
					ValaCCodeIdentifier* _tmp46_;
					_tmp36_ = NULL;
					array_type = (_tmp36_ = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp36_ == NULL) ? NULL : vala_code_node_ref (_tmp36_));
					_cdecl_ = NULL;
					if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
						ValaCCodeDeclaration* _tmp37_;
						_tmp37_ = NULL;
						_cdecl_ = (_tmp37_ = vala_ccode_declaration_new ("GPtrArray*"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp37_);
					} else {
						ValaCCodeDeclaration* _tmp38_;
						_tmp38_ = NULL;
						_cdecl_ = (_tmp38_ = vala_ccode_declaration_new ("GArray*"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp38_);
					}
					_tmp39_ = NULL;
					vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp39_ = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) param), NULL, NULL)));
					(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
					vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), (ValaCCodeNode*) _cdecl_);
					_tmp40_ = NULL;
					vala_ccode_function_call_add_argument (cend_call, _tmp40_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, (ValaDataType*) array_type));
					(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
					_tmp42_ = NULL;
					_tmp41_ = NULL;
					vala_ccode_function_call_add_argument (cend_call, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))));
					(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
					(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
					_tmp43_ = NULL;
					if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
						_tmp43_ = "pdata";
					} else {
						_tmp43_ = "data";
					}
					_tmp45_ = NULL;
					_tmp44_ = NULL;
					vala_ccode_function_call_add_argument (creply_call, (ValaCCodeExpression*) (_tmp45_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp44_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))), _tmp43_)));
					(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
					(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
					_tmp47_ = NULL;
					_tmp46_ = NULL;
					vala_ccode_function_call_add_argument (creply_call, (ValaCCodeExpression*) (_tmp47_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp46_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))), "len")));
					(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
					(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
					(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
				} else {
					char* _tmp48_;
					ValaCCodeDeclaration* _tmp49_;
					ValaCCodeDeclaration* _cdecl_;
					ValaCCodeVariableDeclarator* _tmp50_;
					ValaCCodeExpression* _tmp51_;
					ValaCCodeUnaryExpression* _tmp53_;
					ValaCCodeIdentifier* _tmp52_;
					ValaCCodeIdentifier* _tmp54_;
					gboolean _tmp55_;
					_tmp48_ = NULL;
					_tmp49_ = NULL;
					_cdecl_ = (_tmp49_ = vala_ccode_declaration_new (_tmp48_ = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param))), _tmp48_ = (g_free (_tmp48_), NULL), _tmp49_);
					_tmp50_ = NULL;
					vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp50_ = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) param), NULL, NULL)));
					(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
					vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), (ValaCCodeNode*) _cdecl_);
					_tmp51_ = NULL;
					vala_ccode_function_call_add_argument (cend_call, _tmp51_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
					(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
					_tmp53_ = NULL;
					_tmp52_ = NULL;
					vala_ccode_function_call_add_argument (cend_call, (ValaCCodeExpression*) (_tmp53_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp52_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))));
					(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
					(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
					_tmp54_ = NULL;
					vala_ccode_function_call_add_argument (creply_call, (ValaCCodeExpression*) (_tmp54_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
					(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
					_tmp55_ = FALSE;
					if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
						_tmp55_ = vala_data_type_get_data_type (vala_array_type_get_element_type (VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
					} else {
						_tmp55_ = FALSE;
					}
					if (_tmp55_) {
						ValaCCodeIdentifier* _tmp56_;
						ValaCCodeFunctionCall* _tmp57_;
						ValaCCodeFunctionCall* cstrvlen;
						ValaCCodeIdentifier* _tmp58_;
						_tmp56_ = NULL;
						_tmp57_ = NULL;
						cstrvlen = (_tmp57_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp56_ = vala_ccode_identifier_new ("g_strv_length"))), (_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL)), _tmp57_);
						_tmp58_ = NULL;
						vala_ccode_function_call_add_argument (cstrvlen, (ValaCCodeExpression*) (_tmp58_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
						(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
						vala_ccode_function_call_add_argument (creply_call, (ValaCCodeExpression*) cstrvlen);
						(cstrvlen == NULL) ? NULL : (cstrvlen = (vala_ccode_node_unref (cstrvlen), NULL));
					}
					(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
				}
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			}
			(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
		}
		_tmp59_ = NULL;
		vala_ccode_function_call_add_argument (cend_call, (ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new ("G_TYPE_INVALID")));
		(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
		_tmp60_ = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), (ValaCCodeNode*) (_tmp60_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cend_call)));
		(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
		_tmp61_ = NULL;
		vala_ccode_function_call_add_argument (creply_call, (ValaCCodeExpression*) (_tmp61_ = vala_ccode_identifier_new ("error")));
		(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
		_tmp62_ = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (cb_fun), (ValaCCodeNode*) (_tmp62_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) creply_call)));
		(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
		if (!vala_ccode_declaration_space_add_declaration (((ValaCCodeBaseModule*) self)->source_declarations, vala_ccode_function_get_name (cb_fun))) {
			/* avoid duplicate function definition*/
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) cb_fun);
		}
		_tmp63_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp63_ = vala_ccode_identifier_new (vala_ccode_function_get_name (cb_fun))));
		(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
		_tmp65_ = NULL;
		_tmp64_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp65_ = vala_ccode_constant_new (_tmp64_ = g_strdup_printf ("param%d_target", callback_index))));
		(_tmp65_ == NULL) ? NULL : (_tmp65_ = (vala_ccode_node_unref (_tmp65_), NULL));
		_tmp64_ = (g_free (_tmp64_), NULL);
		_tmp66_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp66_ = vala_ccode_constant_new ("NULL")));
		(_tmp66_ == NULL) ? NULL : (_tmp66_ = (vala_ccode_node_unref (_tmp66_), NULL));
		(reply_method == NULL) ? NULL : (reply_method = (vala_code_node_unref (reply_method), NULL));
		(cb_fun == NULL) ? NULL : (cb_fun = (vala_ccode_node_unref (cb_fun), NULL));
		(cerrdecl == NULL) ? NULL : (cerrdecl = (vala_ccode_node_unref (cerrdecl), NULL));
		(cend_call == NULL) ? NULL : (cend_call = (vala_ccode_node_unref (cend_call), NULL));
		(creply_call == NULL) ? NULL : (creply_call = (vala_ccode_node_unref (creply_call), NULL));
	} else {
		ValaCCodeIdentifier* _tmp67_;
		ValaCCodeIdentifier* _tmp68_;
		_tmp67_ = NULL;
		vala_ccode_function_call_set_call (ccall, (ValaCCodeExpression*) (_tmp67_ = vala_ccode_identifier_new ("dbus_g_proxy_call")));
		(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
		_tmp68_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp68_ = vala_ccode_identifier_new ("error")));
		(_tmp68_ == NULL) ? NULL : (_tmp68_ = (vala_ccode_node_unref (_tmp68_), NULL));
	}
	{
		GeeList* _tmp69_;
		GeeIterator* _tmp70_;
		GeeIterator* _param_it;
		_tmp69_ = NULL;
		_tmp70_ = NULL;
		_param_it = (_tmp70_ = gee_iterable_iterator ((GeeIterable*) (_tmp69_ = vala_method_get_parameters (method))), (_tmp69_ == NULL) ? NULL : (_tmp69_ = (gee_collection_object_unref (_tmp69_), NULL)), _tmp70_);
		while (TRUE) {
			ValaFormalParameter* param;
			gboolean _tmp71_;
			ValaArrayType* _tmp73_;
			ValaDataType* _tmp72_;
			ValaArrayType* array_type;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp71_ = FALSE;
			if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
				_tmp71_ = TRUE;
			} else {
				_tmp71_ = VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param));
			}
			if (_tmp71_) {
				/* callback parameter*/
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				break;
			}
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				continue;
			}
			_tmp73_ = NULL;
			_tmp72_ = NULL;
			array_type = (_tmp73_ = (_tmp72_ = vala_formal_parameter_get_parameter_type (param), VALA_IS_ARRAY_TYPE (_tmp72_) ? ((ValaArrayType*) _tmp72_) : NULL), (_tmp73_ == NULL) ? NULL : vala_code_node_ref (_tmp73_));
			if (array_type != NULL) {
				/* array parameter*/
				if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
					ValaCCodeExpression* _tmp74_;
					ValaCCodeIdentifier* _tmp75_;
					ValaCCodeFunctionCall* _tmp76_;
					ValaCCodeFunctionCall* sizeof_call;
					ValaCCodeIdentifier* _tmp78_;
					char* _tmp77_;
					ValaCCodeDeclaration* _cdecl_;
					ValaCCodeFunctionCall* array_construct;
					ValaCCodeVariableDeclarator* _tmp90_;
					char* _tmp89_;
					ValaCCodeIdentifier* _tmp117_;
					char* _tmp116_;
					/* non-string arrays (use GArray)*/
					_tmp74_ = NULL;
					vala_ccode_function_call_add_argument (ccall, _tmp74_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, (ValaDataType*) array_type));
					(_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL));
					_tmp75_ = NULL;
					_tmp76_ = NULL;
					sizeof_call = (_tmp76_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp75_ = vala_ccode_identifier_new ("sizeof"))), (_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL)), _tmp76_);
					_tmp78_ = NULL;
					_tmp77_ = NULL;
					vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp78_ = vala_ccode_identifier_new (_tmp77_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
					(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
					_tmp77_ = (g_free (_tmp77_), NULL);
					_cdecl_ = NULL;
					array_construct = NULL;
					if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
						ValaCCodeDeclaration* _tmp79_;
						ValaCCodeFunctionCall* _tmp81_;
						ValaCCodeIdentifier* _tmp80_;
						ValaCCodeIdentifier* _tmp83_;
						char* _tmp82_;
						_tmp79_ = NULL;
						_cdecl_ = (_tmp79_ = vala_ccode_declaration_new ("GPtrArray*"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp79_);
						_tmp81_ = NULL;
						_tmp80_ = NULL;
						array_construct = (_tmp81_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp80_ = vala_ccode_identifier_new ("g_ptr_array_sized_new"))), (array_construct == NULL) ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL)), _tmp81_);
						(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
						_tmp83_ = NULL;
						_tmp82_ = NULL;
						vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) (_tmp83_ = vala_ccode_identifier_new (_tmp82_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), 1))));
						(_tmp83_ == NULL) ? NULL : (_tmp83_ = (vala_ccode_node_unref (_tmp83_), NULL));
						_tmp82_ = (g_free (_tmp82_), NULL);
					} else {
						ValaCCodeDeclaration* _tmp84_;
						ValaCCodeFunctionCall* _tmp86_;
						ValaCCodeIdentifier* _tmp85_;
						ValaCCodeConstant* _tmp87_;
						ValaCCodeConstant* _tmp88_;
						_tmp84_ = NULL;
						_cdecl_ = (_tmp84_ = vala_ccode_declaration_new ("GArray*"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp84_);
						_tmp86_ = NULL;
						_tmp85_ = NULL;
						array_construct = (_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp85_ = vala_ccode_identifier_new ("g_array_new"))), (array_construct == NULL) ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL)), _tmp86_);
						(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
						_tmp87_ = NULL;
						vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) (_tmp87_ = vala_ccode_constant_new ("TRUE")));
						(_tmp87_ == NULL) ? NULL : (_tmp87_ = (vala_ccode_node_unref (_tmp87_), NULL));
						_tmp88_ = NULL;
						vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) (_tmp88_ = vala_ccode_constant_new ("TRUE")));
						(_tmp88_ == NULL) ? NULL : (_tmp88_ = (vala_ccode_node_unref (_tmp88_), NULL));
						vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) sizeof_call);
					}
					_tmp90_ = NULL;
					_tmp89_ = NULL;
					vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp90_ = vala_ccode_variable_declarator_new (_tmp89_ = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)), (ValaCCodeExpression*) array_construct, NULL)));
					(_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_ccode_node_unref (_tmp90_), NULL));
					_tmp89_ = (g_free (_tmp89_), NULL);
					vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
					if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
						ValaCCodeIdentifier* _tmp91_;
						ValaCCodeFunctionCall* _tmp92_;
						ValaCCodeFunctionCall* memcpy_call;
						ValaCCodeMemberAccess* _tmp95_;
						ValaCCodeIdentifier* _tmp94_;
						char* _tmp93_;
						ValaCCodeIdentifier* _tmp96_;
						ValaCCodeBinaryExpression* _tmp99_;
						ValaCCodeIdentifier* _tmp98_;
						char* _tmp97_;
						ValaCCodeExpressionStatement* _tmp100_;
						ValaCCodeIdentifier* _tmp105_;
						char* _tmp104_;
						ValaCCodeMemberAccess* _tmp103_;
						ValaCCodeIdentifier* _tmp102_;
						char* _tmp101_;
						ValaCCodeAssignment* _tmp106_;
						ValaCCodeAssignment* len_assignment;
						ValaCCodeExpressionStatement* _tmp107_;
						vala_ccode_declaration_space_add_include (((ValaCCodeBaseModule*) self)->source_declarations, "string.h", FALSE);
						_tmp91_ = NULL;
						_tmp92_ = NULL;
						memcpy_call = (_tmp92_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp91_ = vala_ccode_identifier_new ("memcpy"))), (_tmp91_ == NULL) ? NULL : (_tmp91_ = (vala_ccode_node_unref (_tmp91_), NULL)), _tmp92_);
						_tmp95_ = NULL;
						_tmp94_ = NULL;
						_tmp93_ = NULL;
						vala_ccode_function_call_add_argument (memcpy_call, (ValaCCodeExpression*) (_tmp95_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp94_ = vala_ccode_identifier_new (_tmp93_ = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))), "pdata")));
						(_tmp95_ == NULL) ? NULL : (_tmp95_ = (vala_ccode_node_unref (_tmp95_), NULL));
						(_tmp94_ == NULL) ? NULL : (_tmp94_ = (vala_ccode_node_unref (_tmp94_), NULL));
						_tmp93_ = (g_free (_tmp93_), NULL);
						_tmp96_ = NULL;
						vala_ccode_function_call_add_argument (memcpy_call, (ValaCCodeExpression*) (_tmp96_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
						(_tmp96_ == NULL) ? NULL : (_tmp96_ = (vala_ccode_node_unref (_tmp96_), NULL));
						_tmp99_ = NULL;
						_tmp98_ = NULL;
						_tmp97_ = NULL;
						vala_ccode_function_call_add_argument (memcpy_call, (ValaCCodeExpression*) (_tmp99_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp98_ = vala_ccode_identifier_new (_tmp97_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), 1))), (ValaCCodeExpression*) sizeof_call)));
						(_tmp99_ == NULL) ? NULL : (_tmp99_ = (vala_ccode_node_unref (_tmp99_), NULL));
						(_tmp98_ == NULL) ? NULL : (_tmp98_ = (vala_ccode_node_unref (_tmp98_), NULL));
						_tmp97_ = (g_free (_tmp97_), NULL);
						_tmp100_ = NULL;
						vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp100_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) memcpy_call)));
						(_tmp100_ == NULL) ? NULL : (_tmp100_ = (vala_ccode_node_unref (_tmp100_), NULL));
						_tmp105_ = NULL;
						_tmp104_ = NULL;
						_tmp103_ = NULL;
						_tmp102_ = NULL;
						_tmp101_ = NULL;
						_tmp106_ = NULL;
						len_assignment = (_tmp106_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp103_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp102_ = vala_ccode_identifier_new (_tmp101_ = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))), "len")), (ValaCCodeExpression*) (_tmp105_ = vala_ccode_identifier_new (_tmp104_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), 1))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp105_ == NULL) ? NULL : (_tmp105_ = (vala_ccode_node_unref (_tmp105_), NULL)), _tmp104_ = (g_free (_tmp104_), NULL), (_tmp103_ == NULL) ? NULL : (_tmp103_ = (vala_ccode_node_unref (_tmp103_), NULL)), (_tmp102_ == NULL) ? NULL : (_tmp102_ = (vala_ccode_node_unref (_tmp102_), NULL)), _tmp101_ = (g_free (_tmp101_), NULL), _tmp106_);
						_tmp107_ = NULL;
						vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp107_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) len_assignment)));
						(_tmp107_ == NULL) ? NULL : (_tmp107_ = (vala_ccode_node_unref (_tmp107_), NULL));
						(memcpy_call == NULL) ? NULL : (memcpy_call = (vala_ccode_node_unref (memcpy_call), NULL));
						(len_assignment == NULL) ? NULL : (len_assignment = (vala_ccode_node_unref (len_assignment), NULL));
					} else {
						ValaCCodeIdentifier* _tmp108_;
						ValaCCodeFunctionCall* _tmp109_;
						ValaCCodeFunctionCall* cappend_call;
						ValaCCodeIdentifier* _tmp111_;
						char* _tmp110_;
						ValaCCodeIdentifier* _tmp112_;
						ValaCCodeIdentifier* _tmp114_;
						char* _tmp113_;
						ValaCCodeExpressionStatement* _tmp115_;
						_tmp108_ = NULL;
						_tmp109_ = NULL;
						cappend_call = (_tmp109_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp108_ = vala_ccode_identifier_new ("g_array_append_vals"))), (_tmp108_ == NULL) ? NULL : (_tmp108_ = (vala_ccode_node_unref (_tmp108_), NULL)), _tmp109_);
						_tmp111_ = NULL;
						_tmp110_ = NULL;
						vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) (_tmp111_ = vala_ccode_identifier_new (_tmp110_ = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))));
						(_tmp111_ == NULL) ? NULL : (_tmp111_ = (vala_ccode_node_unref (_tmp111_), NULL));
						_tmp110_ = (g_free (_tmp110_), NULL);
						_tmp112_ = NULL;
						vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) (_tmp112_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
						(_tmp112_ == NULL) ? NULL : (_tmp112_ = (vala_ccode_node_unref (_tmp112_), NULL));
						_tmp114_ = NULL;
						_tmp113_ = NULL;
						vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) (_tmp114_ = vala_ccode_identifier_new (_tmp113_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), 1))));
						(_tmp114_ == NULL) ? NULL : (_tmp114_ = (vala_ccode_node_unref (_tmp114_), NULL));
						_tmp113_ = (g_free (_tmp113_), NULL);
						_tmp115_ = NULL;
						vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp115_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cappend_call)));
						(_tmp115_ == NULL) ? NULL : (_tmp115_ = (vala_ccode_node_unref (_tmp115_), NULL));
						(cappend_call == NULL) ? NULL : (cappend_call = (vala_ccode_node_unref (cappend_call), NULL));
					}
					_tmp117_ = NULL;
					_tmp116_ = NULL;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp117_ = vala_ccode_identifier_new (_tmp116_ = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))));
					(_tmp117_ == NULL) ? NULL : (_tmp117_ = (vala_ccode_node_unref (_tmp117_), NULL));
					_tmp116_ = (g_free (_tmp116_), NULL);
					(sizeof_call == NULL) ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL));
					(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
					(array_construct == NULL) ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL));
				} else {
					ValaCCodeIdentifier* _tmp118_;
					ValaCCodeIdentifier* _tmp119_;
					/* string arrays*/
					_tmp118_ = NULL;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp118_ = vala_ccode_identifier_new ("G_TYPE_STRV")));
					(_tmp118_ == NULL) ? NULL : (_tmp118_ = (vala_ccode_node_unref (_tmp118_), NULL));
					_tmp119_ = NULL;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp119_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
					(_tmp119_ == NULL) ? NULL : (_tmp119_ = (vala_ccode_node_unref (_tmp119_), NULL));
				}
			} else {
				char* _tmp120_;
				gboolean _tmp121_;
				_tmp120_ = NULL;
				if ((_tmp121_ = g_str_has_prefix (_tmp120_ = vala_dbus_module_get_type_signature (vala_formal_parameter_get_parameter_type (param)), "("), _tmp120_ = (g_free (_tmp120_), NULL), _tmp121_)) {
					ValaStruct* _tmp122_;
					ValaStruct* st;
					ValaCCodeIdentifier* _tmp123_;
					ValaCCodeFunctionCall* _tmp124_;
					ValaCCodeFunctionCall* array_construct;
					ValaCCodeConstant* _tmp125_;
					ValaCCodeDeclaration* _cdecl_;
					ValaCCodeVariableDeclarator* _tmp127_;
					char* _tmp126_;
					ValaCCodeExpression* _tmp150_;
					ValaCCodeIdentifier* _tmp152_;
					char* _tmp151_;
					/* struct parameter*/
					_tmp122_ = NULL;
					st = (_tmp122_ = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp122_ == NULL) ? NULL : vala_code_node_ref (_tmp122_));
					_tmp123_ = NULL;
					_tmp124_ = NULL;
					array_construct = (_tmp124_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp123_ = vala_ccode_identifier_new ("g_value_array_new"))), (_tmp123_ == NULL) ? NULL : (_tmp123_ = (vala_ccode_node_unref (_tmp123_), NULL)), _tmp124_);
					_tmp125_ = NULL;
					vala_ccode_function_call_add_argument (array_construct, (ValaCCodeExpression*) (_tmp125_ = vala_ccode_constant_new ("0")));
					(_tmp125_ == NULL) ? NULL : (_tmp125_ = (vala_ccode_node_unref (_tmp125_), NULL));
					_cdecl_ = vala_ccode_declaration_new ("GValueArray*");
					_tmp127_ = NULL;
					_tmp126_ = NULL;
					vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp127_ = vala_ccode_variable_declarator_new (_tmp126_ = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)), (ValaCCodeExpression*) array_construct, NULL)));
					(_tmp127_ == NULL) ? NULL : (_tmp127_ = (vala_ccode_node_unref (_tmp127_), NULL));
					_tmp126_ = (g_free (_tmp126_), NULL);
					vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
					{
						GeeList* _tmp128_;
						GeeIterator* _tmp129_;
						GeeIterator* _f_it;
						_tmp128_ = NULL;
						_tmp129_ = NULL;
						_f_it = (_tmp129_ = gee_iterable_iterator ((GeeIterable*) (_tmp128_ = vala_struct_get_fields (st))), (_tmp128_ == NULL) ? NULL : (_tmp128_ = (gee_collection_object_unref (_tmp128_), NULL)), _tmp129_);
						while (TRUE) {
							ValaField* f;
							char* val_name;
							ValaCCodeInitializerList* cvalinit;
							ValaCCodeConstant* _tmp130_;
							ValaCCodeDeclaration* cval_decl;
							ValaCCodeVariableDeclarator* _tmp131_;
							ValaCCodeIdentifier* _tmp132_;
							ValaCCodeUnaryExpression* _tmp133_;
							ValaCCodeUnaryExpression* val_ptr;
							ValaCCodeIdentifier* _tmp134_;
							ValaCCodeFunctionCall* _tmp135_;
							ValaCCodeFunctionCall* cinit_call;
							ValaCCodeIdentifier* _tmp137_;
							char* _tmp136_;
							ValaCCodeExpressionStatement* _tmp138_;
							ValaCCodeIdentifier* _tmp140_;
							char* _tmp139_;
							ValaCCodeFunctionCall* _tmp141_;
							ValaCCodeFunctionCall* cset_call;
							ValaCCodeMemberAccess* _tmp143_;
							ValaCCodeIdentifier* _tmp142_;
							ValaCCodeExpressionStatement* _tmp144_;
							ValaCCodeIdentifier* _tmp145_;
							ValaCCodeFunctionCall* _tmp146_;
							ValaCCodeFunctionCall* cappend_call;
							ValaCCodeIdentifier* _tmp148_;
							char* _tmp147_;
							ValaCCodeExpressionStatement* _tmp149_;
							if (!gee_iterator_next (_f_it)) {
								break;
							}
							f = (ValaField*) gee_iterator_get (_f_it);
							if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
								(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
								continue;
							}
							val_name = g_strdup_printf ("val_%s_%s", vala_symbol_get_name ((ValaSymbol*) param), vala_symbol_get_name ((ValaSymbol*) f));
							/* 0-initialize struct with struct initializer { 0 }*/
							cvalinit = vala_ccode_initializer_list_new ();
							_tmp130_ = NULL;
							vala_ccode_initializer_list_append (cvalinit, (ValaCCodeExpression*) (_tmp130_ = vala_ccode_constant_new ("0")));
							(_tmp130_ == NULL) ? NULL : (_tmp130_ = (vala_ccode_node_unref (_tmp130_), NULL));
							cval_decl = vala_ccode_declaration_new ("GValue");
							_tmp131_ = NULL;
							vala_ccode_declaration_add_declarator (cval_decl, (ValaCCodeDeclarator*) (_tmp131_ = vala_ccode_variable_declarator_new (val_name, (ValaCCodeExpression*) cvalinit, NULL)));
							(_tmp131_ == NULL) ? NULL : (_tmp131_ = (vala_ccode_node_unref (_tmp131_), NULL));
							vala_ccode_block_add_statement (block, (ValaCCodeNode*) cval_decl);
							_tmp132_ = NULL;
							_tmp133_ = NULL;
							val_ptr = (_tmp133_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp132_ = vala_ccode_identifier_new (val_name))), (_tmp132_ == NULL) ? NULL : (_tmp132_ = (vala_ccode_node_unref (_tmp132_), NULL)), _tmp133_);
							_tmp134_ = NULL;
							_tmp135_ = NULL;
							cinit_call = (_tmp135_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp134_ = vala_ccode_identifier_new ("g_value_init"))), (_tmp134_ == NULL) ? NULL : (_tmp134_ = (vala_ccode_node_unref (_tmp134_), NULL)), _tmp135_);
							vala_ccode_function_call_add_argument (cinit_call, (ValaCCodeExpression*) val_ptr);
							_tmp137_ = NULL;
							_tmp136_ = NULL;
							vala_ccode_function_call_add_argument (cinit_call, (ValaCCodeExpression*) (_tmp137_ = vala_ccode_identifier_new (_tmp136_ = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f))))));
							(_tmp137_ == NULL) ? NULL : (_tmp137_ = (vala_ccode_node_unref (_tmp137_), NULL));
							_tmp136_ = (g_free (_tmp136_), NULL);
							_tmp138_ = NULL;
							vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp138_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinit_call)));
							(_tmp138_ == NULL) ? NULL : (_tmp138_ = (vala_ccode_node_unref (_tmp138_), NULL));
							_tmp140_ = NULL;
							_tmp139_ = NULL;
							_tmp141_ = NULL;
							cset_call = (_tmp141_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp140_ = vala_ccode_identifier_new (_tmp139_ = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)))))), (_tmp140_ == NULL) ? NULL : (_tmp140_ = (vala_ccode_node_unref (_tmp140_), NULL)), _tmp139_ = (g_free (_tmp139_), NULL), _tmp141_);
							vala_ccode_function_call_add_argument (cset_call, (ValaCCodeExpression*) val_ptr);
							_tmp143_ = NULL;
							_tmp142_ = NULL;
							vala_ccode_function_call_add_argument (cset_call, (ValaCCodeExpression*) (_tmp143_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp142_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))), vala_symbol_get_name ((ValaSymbol*) f))));
							(_tmp143_ == NULL) ? NULL : (_tmp143_ = (vala_ccode_node_unref (_tmp143_), NULL));
							(_tmp142_ == NULL) ? NULL : (_tmp142_ = (vala_ccode_node_unref (_tmp142_), NULL));
							_tmp144_ = NULL;
							vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp144_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cset_call)));
							(_tmp144_ == NULL) ? NULL : (_tmp144_ = (vala_ccode_node_unref (_tmp144_), NULL));
							_tmp145_ = NULL;
							_tmp146_ = NULL;
							cappend_call = (_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp145_ = vala_ccode_identifier_new ("g_value_array_append"))), (_tmp145_ == NULL) ? NULL : (_tmp145_ = (vala_ccode_node_unref (_tmp145_), NULL)), _tmp146_);
							_tmp148_ = NULL;
							_tmp147_ = NULL;
							vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) (_tmp148_ = vala_ccode_identifier_new (_tmp147_ = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))));
							(_tmp148_ == NULL) ? NULL : (_tmp148_ = (vala_ccode_node_unref (_tmp148_), NULL));
							_tmp147_ = (g_free (_tmp147_), NULL);
							vala_ccode_function_call_add_argument (cappend_call, (ValaCCodeExpression*) val_ptr);
							_tmp149_ = NULL;
							vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp149_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cappend_call)));
							(_tmp149_ == NULL) ? NULL : (_tmp149_ = (vala_ccode_node_unref (_tmp149_), NULL));
							(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
							val_name = (g_free (val_name), NULL);
							(cvalinit == NULL) ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL));
							(cval_decl == NULL) ? NULL : (cval_decl = (vala_ccode_node_unref (cval_decl), NULL));
							(val_ptr == NULL) ? NULL : (val_ptr = (vala_ccode_node_unref (val_ptr), NULL));
							(cinit_call == NULL) ? NULL : (cinit_call = (vala_ccode_node_unref (cinit_call), NULL));
							(cset_call == NULL) ? NULL : (cset_call = (vala_ccode_node_unref (cset_call), NULL));
							(cappend_call == NULL) ? NULL : (cappend_call = (vala_ccode_node_unref (cappend_call), NULL));
						}
						(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
					}
					_tmp150_ = NULL;
					vala_ccode_function_call_add_argument (ccall, _tmp150_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
					(_tmp150_ == NULL) ? NULL : (_tmp150_ = (vala_ccode_node_unref (_tmp150_), NULL));
					_tmp152_ = NULL;
					_tmp151_ = NULL;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp152_ = vala_ccode_identifier_new (_tmp151_ = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))));
					(_tmp152_ == NULL) ? NULL : (_tmp152_ = (vala_ccode_node_unref (_tmp152_), NULL));
					_tmp151_ = (g_free (_tmp151_), NULL);
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					(array_construct == NULL) ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL));
					(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
				} else {
					ValaCCodeExpression* _tmp153_;
					ValaCCodeIdentifier* _tmp154_;
					_tmp153_ = NULL;
					vala_ccode_function_call_add_argument (ccall, _tmp153_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
					(_tmp153_ == NULL) ? NULL : (_tmp153_ = (vala_ccode_node_unref (_tmp153_), NULL));
					_tmp154_ = NULL;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp154_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
					(_tmp154_ == NULL) ? NULL : (_tmp154_ = (vala_ccode_node_unref (_tmp154_), NULL));
				}
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp155_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp155_ = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp155_ == NULL) ? NULL : (_tmp155_ = (vala_ccode_node_unref (_tmp155_), NULL));
	out_marshalling_fragment = vala_ccode_fragment_new ();
	{
		GeeList* _tmp156_;
		GeeIterator* _tmp157_;
		GeeIterator* _param_it;
		_tmp156_ = NULL;
		_tmp157_ = NULL;
		_param_it = (_tmp157_ = gee_iterable_iterator ((GeeIterable*) (_tmp156_ = vala_method_get_parameters (method))), (_tmp156_ == NULL) ? NULL : (_tmp156_ = (gee_collection_object_unref (_tmp156_), NULL)), _tmp157_);
		while (TRUE) {
			ValaFormalParameter* param;
			char* _tmp158_;
			gboolean _tmp159_;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
				/* callback parameter*/
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				break;
			}
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				continue;
			}
			_tmp158_ = NULL;
			if ((_tmp159_ = g_str_has_prefix (_tmp158_ = vala_dbus_module_get_type_signature (vala_formal_parameter_get_parameter_type (param)), "("), _tmp158_ = (g_free (_tmp158_), NULL), _tmp159_)) {
				ValaStruct* _tmp160_;
				ValaStruct* st;
				ValaCCodeDeclaration* _cdecl_;
				ValaCCodeVariableDeclarator* _tmp162_;
				char* _tmp161_;
				gint i;
				ValaCCodeExpression* _tmp181_;
				ValaCCodeUnaryExpression* _tmp184_;
				ValaCCodeIdentifier* _tmp183_;
				char* _tmp182_;
				/* struct output parameter*/
				_tmp160_ = NULL;
				st = (_tmp160_ = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp160_ == NULL) ? NULL : vala_code_node_ref (_tmp160_));
				_cdecl_ = vala_ccode_declaration_new ("GValueArray*");
				_tmp162_ = NULL;
				_tmp161_ = NULL;
				vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp162_ = vala_ccode_variable_declarator_new (_tmp161_ = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)), NULL, NULL)));
				(_tmp162_ == NULL) ? NULL : (_tmp162_ = (vala_ccode_node_unref (_tmp162_), NULL));
				_tmp161_ = (g_free (_tmp161_), NULL);
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
				i = 0;
				{
					GeeList* _tmp163_;
					GeeIterator* _tmp164_;
					GeeIterator* _f_it;
					_tmp163_ = NULL;
					_tmp164_ = NULL;
					_f_it = (_tmp164_ = gee_iterable_iterator ((GeeIterable*) (_tmp163_ = vala_struct_get_fields (st))), (_tmp163_ == NULL) ? NULL : (_tmp163_ = (gee_collection_object_unref (_tmp163_), NULL)), _tmp164_);
					while (TRUE) {
						ValaField* f;
						ValaCCodeIdentifier* _tmp166_;
						char* _tmp165_;
						ValaCCodeFunctionCall* _tmp167_;
						ValaCCodeFunctionCall* cget_call;
						ValaCCodeUnaryExpression* _tmp174_;
						ValaCCodeElementAccess* _tmp173_;
						ValaCCodeConstant* _tmp172_;
						char* _tmp171_;
						ValaCCodeMemberAccess* _tmp170_;
						ValaCCodeIdentifier* _tmp169_;
						char* _tmp168_;
						ValaCCodeFunctionCall* _tmp175_;
						ValaCCodeFunctionCall* converted_value;
						ValaCCodeMemberAccess* _tmp178_;
						ValaCCodeIdentifier* _tmp177_;
						ValaCCodeAssignment* _tmp179_;
						ValaCCodeAssignment* assign;
						ValaCCodeExpressionStatement* _tmp180_;
						if (!gee_iterator_next (_f_it)) {
							break;
						}
						f = (ValaField*) gee_iterator_get (_f_it);
						if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
							(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
							continue;
						}
						_tmp166_ = NULL;
						_tmp165_ = NULL;
						_tmp167_ = NULL;
						cget_call = (_tmp167_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp166_ = vala_ccode_identifier_new (_tmp165_ = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)))))), (_tmp166_ == NULL) ? NULL : (_tmp166_ = (vala_ccode_node_unref (_tmp166_), NULL)), _tmp165_ = (g_free (_tmp165_), NULL), _tmp167_);
						_tmp174_ = NULL;
						_tmp173_ = NULL;
						_tmp172_ = NULL;
						_tmp171_ = NULL;
						_tmp170_ = NULL;
						_tmp169_ = NULL;
						_tmp168_ = NULL;
						vala_ccode_function_call_add_argument (cget_call, (ValaCCodeExpression*) (_tmp174_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp173_ = vala_ccode_element_access_new ((ValaCCodeExpression*) (_tmp170_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp169_ = vala_ccode_identifier_new (_tmp168_ = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))), "values")), (ValaCCodeExpression*) (_tmp172_ = vala_ccode_constant_new (_tmp171_ = g_strdup_printf ("%i", i))))))));
						(_tmp174_ == NULL) ? NULL : (_tmp174_ = (vala_ccode_node_unref (_tmp174_), NULL));
						(_tmp173_ == NULL) ? NULL : (_tmp173_ = (vala_ccode_node_unref (_tmp173_), NULL));
						(_tmp172_ == NULL) ? NULL : (_tmp172_ = (vala_ccode_node_unref (_tmp172_), NULL));
						_tmp171_ = (g_free (_tmp171_), NULL);
						(_tmp170_ == NULL) ? NULL : (_tmp170_ = (vala_ccode_node_unref (_tmp170_), NULL));
						(_tmp169_ == NULL) ? NULL : (_tmp169_ = (vala_ccode_node_unref (_tmp169_), NULL));
						_tmp168_ = (g_free (_tmp168_), NULL);
						_tmp175_ = NULL;
						converted_value = (_tmp175_ = cget_call, (_tmp175_ == NULL) ? NULL : vala_ccode_node_ref (_tmp175_));
						if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, vala_field_get_field_type (f))) {
							ValaCCodeExpression* dupexpr;
							ValaCCodeFunctionCall* _tmp176_;
							dupexpr = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, vala_field_get_field_type (f), vala_code_node_get_source_reference ((ValaCodeNode*) expr), FALSE);
							_tmp176_ = NULL;
							converted_value = (_tmp176_ = vala_ccode_function_call_new (dupexpr), (converted_value == NULL) ? NULL : (converted_value = (vala_ccode_node_unref (converted_value), NULL)), _tmp176_);
							vala_ccode_function_call_add_argument (converted_value, (ValaCCodeExpression*) cget_call);
							(dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL));
						}
						_tmp178_ = NULL;
						_tmp177_ = NULL;
						_tmp179_ = NULL;
						assign = (_tmp179_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp178_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp177_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))), vala_symbol_get_name ((ValaSymbol*) f))), (ValaCCodeExpression*) converted_value, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp178_ == NULL) ? NULL : (_tmp178_ = (vala_ccode_node_unref (_tmp178_), NULL)), (_tmp177_ == NULL) ? NULL : (_tmp177_ = (vala_ccode_node_unref (_tmp177_), NULL)), _tmp179_);
						_tmp180_ = NULL;
						vala_ccode_fragment_append (out_marshalling_fragment, (ValaCCodeNode*) (_tmp180_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
						(_tmp180_ == NULL) ? NULL : (_tmp180_ = (vala_ccode_node_unref (_tmp180_), NULL));
						i++;
						(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
						(cget_call == NULL) ? NULL : (cget_call = (vala_ccode_node_unref (cget_call), NULL));
						(converted_value == NULL) ? NULL : (converted_value = (vala_ccode_node_unref (converted_value), NULL));
						(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
					}
					(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
				}
				_tmp181_ = NULL;
				vala_ccode_function_call_add_argument (ccall, _tmp181_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
				(_tmp181_ == NULL) ? NULL : (_tmp181_ = (vala_ccode_node_unref (_tmp181_), NULL));
				_tmp184_ = NULL;
				_tmp183_ = NULL;
				_tmp182_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp184_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp183_ = vala_ccode_identifier_new (_tmp182_ = g_strdup_printf ("dbus_%s", vala_symbol_get_name ((ValaSymbol*) param)))))));
				(_tmp184_ == NULL) ? NULL : (_tmp184_ = (vala_ccode_node_unref (_tmp184_), NULL));
				(_tmp183_ == NULL) ? NULL : (_tmp183_ = (vala_ccode_node_unref (_tmp183_), NULL));
				_tmp182_ = (g_free (_tmp182_), NULL);
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
			} else {
				ValaCCodeExpression* _tmp185_;
				ValaCCodeIdentifier* _tmp186_;
				_tmp185_ = NULL;
				vala_ccode_function_call_add_argument (ccall, _tmp185_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
				(_tmp185_ == NULL) ? NULL : (_tmp185_ = (vala_ccode_node_unref (_tmp185_), NULL));
				_tmp186_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp186_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
				(_tmp186_ == NULL) ? NULL : (_tmp186_ = (vala_ccode_node_unref (_tmp186_), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (method))) {
		ValaArrayType* _tmp188_;
		ValaDataType* _tmp187_;
		ValaArrayType* array_type;
		gboolean _tmp189_;
		/* synchronous D-Bus method call with reply*/
		_tmp188_ = NULL;
		_tmp187_ = NULL;
		array_type = (_tmp188_ = (_tmp187_ = vala_method_get_return_type (method), VALA_IS_ARRAY_TYPE (_tmp187_) ? ((ValaArrayType*) _tmp187_) : NULL), (_tmp188_ == NULL) ? NULL : vala_code_node_ref (_tmp188_));
		_tmp189_ = FALSE;
		if (array_type != NULL) {
			_tmp189_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type);
		} else {
			_tmp189_ = FALSE;
		}
		if (_tmp189_) {
			ValaCCodeExpression* _tmp190_;
			ValaCCodeDeclaration* _cdecl_;
			ValaCCodeVariableDeclarator* _tmp193_;
			ValaCCodeUnaryExpression* _tmp195_;
			ValaCCodeIdentifier* _tmp194_;
			ValaCCodeIdentifier* _tmp196_;
			ValaCCodeExpressionStatement* _tmp197_;
			ValaCCodeBlock* creturnblock;
			ValaCCodeReturnStatement* _tmp199_;
			ValaCCodeExpression* _tmp198_;
			ValaCCodeUnaryExpression* _tmp201_;
			ValaCCodeIdentifier* _tmp200_;
			ValaCCodeIfStatement* _tmp202_;
			ValaCCodeIfStatement* cerrorif;
			ValaCCodeIdentifier* _tmp203_;
			ValaCCodeMemberAccess* _tmp204_;
			ValaCCodeMemberAccess* garray_length;
			ValaCCodeIdentifier* _tmp205_;
			ValaCCodeUnaryExpression* _tmp206_;
			ValaCCodeUnaryExpression* result_length;
			ValaCCodeAssignment* assign;
			ValaCCodeExpressionStatement* _tmp207_;
			const char* _tmp208_;
			ValaCCodeReturnStatement* _tmp213_;
			ValaCCodeCastExpression* _tmp212_;
			char* _tmp211_;
			ValaCCodeMemberAccess* _tmp210_;
			ValaCCodeIdentifier* _tmp209_;
			/* non-string arrays (use GArray)*/
			_tmp190_ = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp190_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, (ValaDataType*) array_type));
			(_tmp190_ == NULL) ? NULL : (_tmp190_ = (vala_ccode_node_unref (_tmp190_), NULL));
			_cdecl_ = NULL;
			if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
				ValaCCodeDeclaration* _tmp191_;
				_tmp191_ = NULL;
				_cdecl_ = (_tmp191_ = vala_ccode_declaration_new ("GPtrArray*"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp191_);
			} else {
				ValaCCodeDeclaration* _tmp192_;
				_tmp192_ = NULL;
				_cdecl_ = (_tmp192_ = vala_ccode_declaration_new ("GArray*"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp192_);
			}
			_tmp193_ = NULL;
			vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp193_ = vala_ccode_variable_declarator_new ("result", NULL, NULL)));
			(_tmp193_ == NULL) ? NULL : (_tmp193_ = (vala_ccode_node_unref (_tmp193_), NULL));
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
			_tmp195_ = NULL;
			_tmp194_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp195_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp194_ = vala_ccode_identifier_new ("result")))));
			(_tmp195_ == NULL) ? NULL : (_tmp195_ = (vala_ccode_node_unref (_tmp195_), NULL));
			(_tmp194_ == NULL) ? NULL : (_tmp194_ = (vala_ccode_node_unref (_tmp194_), NULL));
			_tmp196_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp196_ = vala_ccode_identifier_new ("G_TYPE_INVALID")));
			(_tmp196_ == NULL) ? NULL : (_tmp196_ = (vala_ccode_node_unref (_tmp196_), NULL));
			_tmp197_ = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp197_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
			(_tmp197_ == NULL) ? NULL : (_tmp197_ = (vala_ccode_node_unref (_tmp197_), NULL));
			/* don't access result when error occured*/
			creturnblock = vala_ccode_block_new ();
			_tmp199_ = NULL;
			_tmp198_ = NULL;
			vala_ccode_block_add_statement (creturnblock, (ValaCCodeNode*) (_tmp199_ = vala_ccode_return_statement_new (_tmp198_ = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, vala_method_get_return_type (method), FALSE))));
			(_tmp199_ == NULL) ? NULL : (_tmp199_ = (vala_ccode_node_unref (_tmp199_), NULL));
			(_tmp198_ == NULL) ? NULL : (_tmp198_ = (vala_ccode_node_unref (_tmp198_), NULL));
			_tmp201_ = NULL;
			_tmp200_ = NULL;
			_tmp202_ = NULL;
			cerrorif = (_tmp202_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp201_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp200_ = vala_ccode_identifier_new ("error")))), (ValaCCodeStatement*) creturnblock, NULL), (_tmp201_ == NULL) ? NULL : (_tmp201_ = (vala_ccode_node_unref (_tmp201_), NULL)), (_tmp200_ == NULL) ? NULL : (_tmp200_ = (vala_ccode_node_unref (_tmp200_), NULL)), _tmp202_);
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) cerrorif);
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) out_marshalling_fragment);
			/* *result_length1 = result->len;*/
			_tmp203_ = NULL;
			_tmp204_ = NULL;
			garray_length = (_tmp204_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp203_ = vala_ccode_identifier_new ("result")), "len"), (_tmp203_ == NULL) ? NULL : (_tmp203_ = (vala_ccode_node_unref (_tmp203_), NULL)), _tmp204_);
			_tmp205_ = NULL;
			_tmp206_ = NULL;
			result_length = (_tmp206_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp205_ = vala_ccode_identifier_new ("result_length1"))), (_tmp205_ == NULL) ? NULL : (_tmp205_ = (vala_ccode_node_unref (_tmp205_), NULL)), _tmp206_);
			assign = vala_ccode_assignment_new ((ValaCCodeExpression*) result_length, (ValaCCodeExpression*) garray_length, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_tmp207_ = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp207_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
			(_tmp207_ == NULL) ? NULL : (_tmp207_ = (vala_ccode_node_unref (_tmp207_), NULL));
			_tmp208_ = NULL;
			if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
				_tmp208_ = "pdata";
			} else {
				_tmp208_ = "data";
			}
			/* return result->data;*/
			_tmp213_ = NULL;
			_tmp212_ = NULL;
			_tmp211_ = NULL;
			_tmp210_ = NULL;
			_tmp209_ = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp213_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp212_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp210_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp209_ = vala_ccode_identifier_new ("result")), _tmp208_)), _tmp211_ = vala_data_type_get_cname (vala_method_get_return_type (method)))))));
			(_tmp213_ == NULL) ? NULL : (_tmp213_ = (vala_ccode_node_unref (_tmp213_), NULL));
			(_tmp212_ == NULL) ? NULL : (_tmp212_ = (vala_ccode_node_unref (_tmp212_), NULL));
			_tmp211_ = (g_free (_tmp211_), NULL);
			(_tmp210_ == NULL) ? NULL : (_tmp210_ = (vala_ccode_node_unref (_tmp210_), NULL));
			(_tmp209_ == NULL) ? NULL : (_tmp209_ = (vala_ccode_node_unref (_tmp209_), NULL));
			(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
			(creturnblock == NULL) ? NULL : (creturnblock = (vala_ccode_node_unref (creturnblock), NULL));
			(cerrorif == NULL) ? NULL : (cerrorif = (vala_ccode_node_unref (cerrorif), NULL));
			(garray_length == NULL) ? NULL : (garray_length = (vala_ccode_node_unref (garray_length), NULL));
			(result_length == NULL) ? NULL : (result_length = (vala_ccode_node_unref (result_length), NULL));
			(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
		} else {
			ValaCCodeExpression* _tmp214_;
			char* _tmp215_;
			ValaCCodeDeclaration* _tmp216_;
			ValaCCodeDeclaration* _cdecl_;
			ValaCCodeVariableDeclarator* _tmp217_;
			ValaCCodeUnaryExpression* _tmp219_;
			ValaCCodeIdentifier* _tmp218_;
			ValaCCodeIdentifier* _tmp220_;
			ValaCCodeExpressionStatement* _tmp221_;
			ValaCCodeBlock* creturnblock;
			ValaCCodeReturnStatement* _tmp223_;
			ValaCCodeExpression* _tmp222_;
			ValaCCodeUnaryExpression* _tmp225_;
			ValaCCodeIdentifier* _tmp224_;
			ValaCCodeIfStatement* _tmp226_;
			ValaCCodeIfStatement* cerrorif;
			ValaCCodeReturnStatement* _tmp234_;
			ValaCCodeIdentifier* _tmp233_;
			/* string arrays or other datatypes*/
			_tmp214_ = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp214_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_method_get_return_type (method)));
			(_tmp214_ == NULL) ? NULL : (_tmp214_ = (vala_ccode_node_unref (_tmp214_), NULL));
			_tmp215_ = NULL;
			_tmp216_ = NULL;
			_cdecl_ = (_tmp216_ = vala_ccode_declaration_new (_tmp215_ = vala_data_type_get_cname (vala_method_get_return_type (method))), _tmp215_ = (g_free (_tmp215_), NULL), _tmp216_);
			_tmp217_ = NULL;
			vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp217_ = vala_ccode_variable_declarator_new ("result", NULL, NULL)));
			(_tmp217_ == NULL) ? NULL : (_tmp217_ = (vala_ccode_node_unref (_tmp217_), NULL));
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
			_tmp219_ = NULL;
			_tmp218_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp219_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp218_ = vala_ccode_identifier_new ("result")))));
			(_tmp219_ == NULL) ? NULL : (_tmp219_ = (vala_ccode_node_unref (_tmp219_), NULL));
			(_tmp218_ == NULL) ? NULL : (_tmp218_ = (vala_ccode_node_unref (_tmp218_), NULL));
			_tmp220_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp220_ = vala_ccode_identifier_new ("G_TYPE_INVALID")));
			(_tmp220_ == NULL) ? NULL : (_tmp220_ = (vala_ccode_node_unref (_tmp220_), NULL));
			_tmp221_ = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp221_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
			(_tmp221_ == NULL) ? NULL : (_tmp221_ = (vala_ccode_node_unref (_tmp221_), NULL));
			/* don't access result when error occured*/
			creturnblock = vala_ccode_block_new ();
			_tmp223_ = NULL;
			_tmp222_ = NULL;
			vala_ccode_block_add_statement (creturnblock, (ValaCCodeNode*) (_tmp223_ = vala_ccode_return_statement_new (_tmp222_ = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, vala_method_get_return_type (method), FALSE))));
			(_tmp223_ == NULL) ? NULL : (_tmp223_ = (vala_ccode_node_unref (_tmp223_), NULL));
			(_tmp222_ == NULL) ? NULL : (_tmp222_ = (vala_ccode_node_unref (_tmp222_), NULL));
			_tmp225_ = NULL;
			_tmp224_ = NULL;
			_tmp226_ = NULL;
			cerrorif = (_tmp226_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp225_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp224_ = vala_ccode_identifier_new ("error")))), (ValaCCodeStatement*) creturnblock, NULL), (_tmp225_ == NULL) ? NULL : (_tmp225_ = (vala_ccode_node_unref (_tmp225_), NULL)), (_tmp224_ == NULL) ? NULL : (_tmp224_ = (vala_ccode_node_unref (_tmp224_), NULL)), _tmp226_);
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) cerrorif);
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) out_marshalling_fragment);
			if (array_type != NULL) {
				ValaCCodeIdentifier* _tmp227_;
				ValaCCodeFunctionCall* _tmp228_;
				ValaCCodeFunctionCall* cstrvlen;
				ValaCCodeIdentifier* _tmp229_;
				ValaCCodeIdentifier* _tmp230_;
				ValaCCodeUnaryExpression* _tmp231_;
				ValaCCodeUnaryExpression* result_length;
				ValaCCodeAssignment* assign;
				ValaCCodeExpressionStatement* _tmp232_;
				/* special case string array
				 *result_length1 = g_strv_length (result);*/
				_tmp227_ = NULL;
				_tmp228_ = NULL;
				cstrvlen = (_tmp228_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp227_ = vala_ccode_identifier_new ("g_strv_length"))), (_tmp227_ == NULL) ? NULL : (_tmp227_ = (vala_ccode_node_unref (_tmp227_), NULL)), _tmp228_);
				_tmp229_ = NULL;
				vala_ccode_function_call_add_argument (cstrvlen, (ValaCCodeExpression*) (_tmp229_ = vala_ccode_identifier_new ("result")));
				(_tmp229_ == NULL) ? NULL : (_tmp229_ = (vala_ccode_node_unref (_tmp229_), NULL));
				_tmp230_ = NULL;
				_tmp231_ = NULL;
				result_length = (_tmp231_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp230_ = vala_ccode_identifier_new ("result_length1"))), (_tmp230_ == NULL) ? NULL : (_tmp230_ = (vala_ccode_node_unref (_tmp230_), NULL)), _tmp231_);
				assign = vala_ccode_assignment_new ((ValaCCodeExpression*) result_length, (ValaCCodeExpression*) cstrvlen, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
				_tmp232_ = NULL;
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp232_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
				(_tmp232_ == NULL) ? NULL : (_tmp232_ = (vala_ccode_node_unref (_tmp232_), NULL));
				(cstrvlen == NULL) ? NULL : (cstrvlen = (vala_ccode_node_unref (cstrvlen), NULL));
				(result_length == NULL) ? NULL : (result_length = (vala_ccode_node_unref (result_length), NULL));
				(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
			}
			_tmp234_ = NULL;
			_tmp233_ = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp234_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp233_ = vala_ccode_identifier_new ("result")))));
			(_tmp234_ == NULL) ? NULL : (_tmp234_ = (vala_ccode_node_unref (_tmp234_), NULL));
			(_tmp233_ == NULL) ? NULL : (_tmp233_ = (vala_ccode_node_unref (_tmp233_), NULL));
			(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
			(creturnblock == NULL) ? NULL : (creturnblock = (vala_ccode_node_unref (creturnblock), NULL));
			(cerrorif == NULL) ? NULL : (cerrorif = (vala_ccode_node_unref (cerrorif), NULL));
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		ValaCCodeIdentifier* _tmp235_;
		ValaCCodeExpressionStatement* _tmp236_;
		ValaCCodeBlock* creturnblock;
		ValaCCodeReturnStatement* _tmp237_;
		ValaCCodeUnaryExpression* _tmp239_;
		ValaCCodeIdentifier* _tmp238_;
		ValaCCodeIfStatement* _tmp240_;
		ValaCCodeIfStatement* cerrorif;
		_tmp235_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp235_ = vala_ccode_identifier_new ("G_TYPE_INVALID")));
		(_tmp235_ == NULL) ? NULL : (_tmp235_ = (vala_ccode_node_unref (_tmp235_), NULL));
		_tmp236_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp236_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp236_ == NULL) ? NULL : (_tmp236_ = (vala_ccode_node_unref (_tmp236_), NULL));
		/* don't access result when error occured*/
		creturnblock = vala_ccode_block_new ();
		_tmp237_ = NULL;
		vala_ccode_block_add_statement (creturnblock, (ValaCCodeNode*) (_tmp237_ = vala_ccode_return_statement_new (NULL)));
		(_tmp237_ == NULL) ? NULL : (_tmp237_ = (vala_ccode_node_unref (_tmp237_), NULL));
		_tmp239_ = NULL;
		_tmp238_ = NULL;
		_tmp240_ = NULL;
		cerrorif = (_tmp240_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp239_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp238_ = vala_ccode_identifier_new ("error")))), (ValaCCodeStatement*) creturnblock, NULL), (_tmp239_ == NULL) ? NULL : (_tmp239_ = (vala_ccode_node_unref (_tmp239_), NULL)), (_tmp238_ == NULL) ? NULL : (_tmp238_ = (vala_ccode_node_unref (_tmp238_), NULL)), _tmp240_);
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cerrorif);
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) out_marshalling_fragment);
		(creturnblock == NULL) ? NULL : (creturnblock = (vala_ccode_node_unref (creturnblock), NULL));
		(cerrorif == NULL) ? NULL : (cerrorif = (vala_ccode_node_unref (cerrorif), NULL));
	}
	(dynamic_method == NULL) ? NULL : (dynamic_method = (vala_code_node_unref (dynamic_method), NULL));
	(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(callback == NULL) ? NULL : (callback = (vala_code_node_unref (callback), NULL));
	(out_marshalling_fragment == NULL) ? NULL : (out_marshalling_fragment = (vala_ccode_node_unref (out_marshalling_fragment), NULL));
}


static ValaCCodeExpression* vala_dbus_client_module_real_get_dbus_g_type (ValaGSignalModule* base, ValaDataType* data_type) {
	ValaDBusClientModule * self;
	ValaCCodeExpression* result;
	self = (ValaDBusClientModule*) base;
	g_return_val_if_fail (data_type != NULL, NULL);
	if (VALA_IS_ARRAY_TYPE (data_type)) {
		ValaArrayType* _tmp1_;
		ValaDataType* _tmp0_;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp2_;
		ValaCCodeFunctionCall* _tmp3_;
		ValaCCodeFunctionCall* carray_type;
		ValaCCodeExpression* _tmp6_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		array_type = (_tmp1_ = (_tmp0_ = data_type, VALA_IS_ARRAY_TYPE (_tmp0_) ? ((ValaArrayType*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
		if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
			result = (ValaCCodeExpression*) vala_ccode_identifier_new ("G_TYPE_STRV");
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			return result;
		}
		_tmp2_ = NULL;
		_tmp3_ = NULL;
		carray_type = (_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("dbus_g_type_get_collection"))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL)), _tmp3_);
		if (vala_dbus_client_module_dbus_use_ptr_array (self, array_type)) {
			ValaCCodeConstant* _tmp4_;
			_tmp4_ = NULL;
			vala_ccode_function_call_add_argument (carray_type, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_constant_new ("\"GPtrArray\"")));
			(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
		} else {
			ValaCCodeConstant* _tmp5_;
			_tmp5_ = NULL;
			vala_ccode_function_call_add_argument (carray_type, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_constant_new ("\"GArray\"")));
			(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
		}
		_tmp6_ = NULL;
		vala_ccode_function_call_add_argument (carray_type, _tmp6_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_array_type_get_element_type (array_type)));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
		result = (ValaCCodeExpression*) carray_type;
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		return result;
	} else {
		if (VALA_IS_ENUM (vala_data_type_get_data_type (data_type))) {
			ValaEnum* _tmp7_;
			ValaEnum* en;
			_tmp7_ = NULL;
			en = (_tmp7_ = VALA_ENUM (vala_data_type_get_data_type (data_type)), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
			if (vala_enum_get_is_flags (en)) {
				result = (ValaCCodeExpression*) vala_ccode_identifier_new ("G_TYPE_UINT");
				(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
				return result;
			} else {
				result = (ValaCCodeExpression*) vala_ccode_identifier_new ("G_TYPE_INT");
				(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
				return result;
			}
			(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
		} else {
			if (vala_data_type_get_data_type (data_type) == NULL) {
				char* _tmp8_;
				_tmp8_ = NULL;
				g_critical ("valadbusclientmodule.vala:479: Internal error during DBus type generation with: %s", _tmp8_ = vala_code_node_to_string ((ValaCodeNode*) data_type));
				_tmp8_ = (g_free (_tmp8_), NULL);
				result = (ValaCCodeExpression*) vala_ccode_identifier_new ("G_TYPE_NONE");
				return result;
			} else {
				char* _tmp9_;
				gboolean _tmp10_;
				_tmp9_ = NULL;
				if ((_tmp10_ = _vala_strcmp0 (_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (data_type)), "GLib.HashTable") == 0, _tmp9_ = (g_free (_tmp9_), NULL), _tmp10_)) {
					ValaCCodeIdentifier* _tmp11_;
					ValaCCodeFunctionCall* _tmp12_;
					ValaCCodeFunctionCall* cmap_type;
					GeeList* type_args;
					ValaCCodeConstant* _tmp13_;
					_tmp11_ = NULL;
					_tmp12_ = NULL;
					cmap_type = (_tmp12_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new ("dbus_g_type_get_map"))), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL)), _tmp12_);
					type_args = vala_data_type_get_type_arguments (data_type);
					_tmp13_ = NULL;
					vala_ccode_function_call_add_argument (cmap_type, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_constant_new ("\"GHashTable\"")));
					(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
					{
						GeeIterator* _type_arg_it;
						_type_arg_it = gee_iterable_iterator ((GeeIterable*) type_args);
						while (TRUE) {
							ValaDataType* type_arg;
							ValaCCodeExpression* _tmp14_;
							if (!gee_iterator_next (_type_arg_it)) {
								break;
							}
							type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
							_tmp14_ = NULL;
							vala_ccode_function_call_add_argument (cmap_type, _tmp14_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, type_arg));
							(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
							(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
						}
						(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
					}
					result = (ValaCCodeExpression*) cmap_type;
					(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
					return result;
				} else {
					char* _tmp15_;
					gboolean _tmp16_;
					_tmp15_ = NULL;
					if ((_tmp16_ = g_str_has_prefix (_tmp15_ = vala_dbus_module_get_type_signature (data_type), "("), _tmp15_ = (g_free (_tmp15_), NULL), _tmp16_)) {
						ValaStruct* _tmp17_;
						ValaStruct* st;
						ValaCCodeIdentifier* _tmp18_;
						ValaCCodeFunctionCall* _tmp19_;
						ValaCCodeFunctionCall* type_call;
						ValaCCodeConstant* _tmp20_;
						ValaCCodeConstant* _tmp24_;
						/* struct parameter*/
						_tmp17_ = NULL;
						st = (_tmp17_ = VALA_STRUCT (vala_data_type_get_data_type (data_type)), (_tmp17_ == NULL) ? NULL : vala_code_node_ref (_tmp17_));
						_tmp18_ = NULL;
						_tmp19_ = NULL;
						type_call = (_tmp19_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("dbus_g_type_get_struct"))), (_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL)), _tmp19_);
						_tmp20_ = NULL;
						vala_ccode_function_call_add_argument (type_call, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_constant_new ("\"GValueArray\"")));
						(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
						{
							GeeList* _tmp21_;
							GeeIterator* _tmp22_;
							GeeIterator* _f_it;
							_tmp21_ = NULL;
							_tmp22_ = NULL;
							_f_it = (_tmp22_ = gee_iterable_iterator ((GeeIterable*) (_tmp21_ = vala_struct_get_fields (st))), (_tmp21_ == NULL) ? NULL : (_tmp21_ = (gee_collection_object_unref (_tmp21_), NULL)), _tmp22_);
							while (TRUE) {
								ValaField* f;
								ValaCCodeExpression* _tmp23_;
								if (!gee_iterator_next (_f_it)) {
									break;
								}
								f = (ValaField*) gee_iterator_get (_f_it);
								if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
									(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
									continue;
								}
								_tmp23_ = NULL;
								vala_ccode_function_call_add_argument (type_call, _tmp23_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_field_get_field_type (f)));
								(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
								(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
							}
							(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
						}
						_tmp24_ = NULL;
						vala_ccode_function_call_add_argument (type_call, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_constant_new ("G_TYPE_INVALID")));
						(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
						result = (ValaCCodeExpression*) type_call;
						(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
						return result;
					} else {
						char* _tmp25_;
						ValaCCodeExpression* _tmp26_;
						_tmp25_ = NULL;
						_tmp26_ = NULL;
						result = (_tmp26_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp25_ = vala_typesymbol_get_type_id (vala_data_type_get_data_type (data_type))), _tmp25_ = (g_free (_tmp25_), NULL), _tmp26_);
						return result;
					}
				}
			}
		}
	}
}


gboolean vala_dbus_client_module_dbus_use_ptr_array (ValaDBusClientModule* self, ValaArrayType* array_type) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (array_type != NULL, FALSE);
	if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
		/* use char***/
		result = FALSE;
		return result;
	} else {
		gboolean _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp0_ = FALSE;
		_tmp1_ = FALSE;
		_tmp2_ = FALSE;
		_tmp3_ = FALSE;
		_tmp4_ = FALSE;
		_tmp5_ = FALSE;
		_tmp6_ = FALSE;
		_tmp7_ = FALSE;
		_tmp8_ = FALSE;
		_tmp9_ = FALSE;
		_tmp10_ = FALSE;
		_tmp11_ = FALSE;
		_tmp12_ = FALSE;
		if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->bool_type)) {
			_tmp12_ = TRUE;
		} else {
			_tmp12_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->char_type);
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->uchar_type);
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			_tmp10_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->int_type);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->uint_type);
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->long_type);
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->ulong_type);
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->int8_type);
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->uint8_type);
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->int32_type);
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->uint32_type);
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->int64_type);
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->uint64_type);
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->double_type);
		}
		if (_tmp0_) {
			/* use GArray*/
			result = FALSE;
			return result;
		} else {
			/* use GPtrArray*/
			result = TRUE;
			return result;
		}
	}
}


static char* vala_dbus_client_module_real_get_dynamic_property_getter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop) {
	ValaDBusClientModule * self;
	char* result;
	char* getter_cname;
	char* _tmp0_;
	gboolean _tmp1_;
	char* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp7_;
	char* _tmp6_;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp8_;
	self = (ValaDBusClientModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (prop)) != ((ValaCCodeBaseModule*) self)->dbus_object_type) {
		result = VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->get_dynamic_property_getter_cname ((ValaCCodeModule*) VALA_DBUS_MODULE (self), prop);
		return result;
	}
	getter_cname = g_strdup_printf ("_dynamic_get_%s%d", vala_symbol_get_name ((ValaSymbol*) prop), self->priv->dynamic_property_id++);
	_tmp0_ = NULL;
	if ((_tmp1_ = (_tmp0_ = vala_dbus_module_get_type_signature (vala_property_get_property_type ((ValaProperty*) prop))) == NULL, _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		char* _tmp3_;
		char* _tmp2_;
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) vala_property_get_property_type ((ValaProperty*) prop)), _tmp3_ = g_strdup_printf ("D-Bus serialization of type `%s' is not supported", _tmp2_ = vala_code_node_to_string ((ValaCodeNode*) vala_property_get_property_type ((ValaProperty*) prop))));
		_tmp3_ = (g_free (_tmp3_), NULL);
		_tmp2_ = (g_free (_tmp2_), NULL);
		result = getter_cname;
		return result;
	}
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	func = (_tmp5_ = vala_ccode_function_new (getter_cname, _tmp4_ = vala_data_type_get_cname (vala_property_get_property_type ((ValaProperty*) prop))), _tmp4_ = (g_free (_tmp4_), NULL), _tmp5_);
	vala_ccode_function_set_modifiers (func, vala_ccode_function_get_modifiers (func) | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp7_ = vala_ccode_formal_parameter_new ("obj", _tmp6_ = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (prop))));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp6_ = (g_free (_tmp6_), NULL);
	block = vala_ccode_block_new ();
	vala_dbus_client_module_generate_dbus_property_getter_wrapper (self, prop, block);
	/* append to C source file*/
	_tmp8_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp8_ = vala_ccode_function_copy (func)));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	result = getter_cname;
	(func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	return result;
}


static char* vala_dbus_client_module_real_get_dynamic_property_setter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop) {
	ValaDBusClientModule * self;
	char* result;
	char* setter_cname;
	char* _tmp0_;
	gboolean _tmp1_;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp5_;
	char* _tmp4_;
	ValaCCodeFormalParameter* _tmp7_;
	char* _tmp6_;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp8_;
	self = (ValaDBusClientModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (prop)) != ((ValaCCodeBaseModule*) self)->dbus_object_type) {
		result = VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->get_dynamic_property_setter_cname ((ValaCCodeModule*) VALA_DBUS_MODULE (self), prop);
		return result;
	}
	setter_cname = g_strdup_printf ("_dynamic_set_%s%d", vala_symbol_get_name ((ValaSymbol*) prop), self->priv->dynamic_property_id++);
	_tmp0_ = NULL;
	if ((_tmp1_ = (_tmp0_ = vala_dbus_module_get_type_signature (vala_property_get_property_type ((ValaProperty*) prop))) == NULL, _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		char* _tmp3_;
		char* _tmp2_;
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) vala_property_get_property_type ((ValaProperty*) prop)), _tmp3_ = g_strdup_printf ("D-Bus serialization of type `%s' is not supported", _tmp2_ = vala_code_node_to_string ((ValaCodeNode*) vala_property_get_property_type ((ValaProperty*) prop))));
		_tmp3_ = (g_free (_tmp3_), NULL);
		_tmp2_ = (g_free (_tmp2_), NULL);
		result = setter_cname;
		return result;
	}
	func = vala_ccode_function_new (setter_cname, "void");
	vala_ccode_function_set_modifiers (func, vala_ccode_function_get_modifiers (func) | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp5_ = vala_ccode_formal_parameter_new ("obj", _tmp4_ = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (prop))));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp7_ = vala_ccode_formal_parameter_new ("value", _tmp6_ = vala_data_type_get_cname (vala_property_get_property_type ((ValaProperty*) prop))));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp6_ = (g_free (_tmp6_), NULL);
	block = vala_ccode_block_new ();
	vala_dbus_client_module_generate_dbus_property_setter_wrapper (self, prop, block);
	/* append to C source file*/
	_tmp8_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp8_ = vala_ccode_function_copy (func)));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	result = setter_cname;
	(func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	return result;
}


static void vala_dbus_client_module_create_dbus_property_proxy (ValaDBusClientModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* prop_proxy_call;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeConstant* _tmp3_;
	ValaCCodeConstant* _tmp4_;
	ValaCCodeDeclaration* prop_proxy_decl;
	ValaCCodeVariableDeclarator* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	prop_proxy_call = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("dbus_g_proxy_new_from_proxy"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_call, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("obj")));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_call, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_constant_new ("DBUS_INTERFACE_PROPERTIES")));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_call, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_constant_new ("NULL")));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	prop_proxy_decl = vala_ccode_declaration_new ("DBusGProxy*");
	_tmp5_ = NULL;
	vala_ccode_declaration_add_declarator (prop_proxy_decl, (ValaCCodeDeclarator*) (_tmp5_ = vala_ccode_variable_declarator_new ("property_proxy", (ValaCCodeExpression*) prop_proxy_call, NULL)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prop_proxy_decl);
	(prop_proxy_call == NULL) ? NULL : (prop_proxy_call = (vala_ccode_node_unref (prop_proxy_call), NULL));
	(prop_proxy_decl == NULL) ? NULL : (prop_proxy_decl = (vala_ccode_node_unref (prop_proxy_decl), NULL));
}


static void vala_dbus_client_module_generate_dbus_property_getter_wrapper (ValaDBusClientModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	ValaCCodeInitializerList* cvalinit;
	ValaCCodeConstant* _tmp0_;
	ValaCCodeDeclaration* cval_decl;
	ValaCCodeVariableDeclarator* _tmp1_;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeUnaryExpression* _tmp3_;
	ValaCCodeUnaryExpression* val_ptr;
	char* _tmp4_;
	ValaCCodeDeclaration* _tmp5_;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeFunctionCall* _tmp8_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeConstant* _tmp10_;
	ValaCCodeConstant* _tmp11_;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* get_iface;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeConstant* _tmp19_;
	char* _tmp18_;
	char* _tmp17_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeExpressionStatement* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeFunctionCall* prop_proxy_unref;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeExpressionStatement* _tmp27_;
	ValaCCodeIdentifier* _tmp29_;
	char* _tmp28_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeFunctionCall* cget_call;
	ValaCCodeIdentifier* _tmp31_;
	ValaCCodeAssignment* _tmp32_;
	ValaCCodeAssignment* assign;
	ValaCCodeExpressionStatement* _tmp33_;
	ValaCCodeReturnStatement* _tmp35_;
	ValaCCodeIdentifier* _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	vala_dbus_client_module_create_dbus_property_proxy (self, node, block);
	/* initialize GValue*/
	cvalinit = vala_ccode_initializer_list_new ();
	_tmp0_ = NULL;
	vala_ccode_initializer_list_append (cvalinit, (ValaCCodeExpression*) (_tmp0_ = vala_ccode_constant_new ("0")));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	cval_decl = vala_ccode_declaration_new ("GValue");
	_tmp1_ = NULL;
	vala_ccode_declaration_add_declarator (cval_decl, (ValaCCodeDeclarator*) (_tmp1_ = vala_ccode_variable_declarator_new ("gvalue", (ValaCCodeExpression*) cvalinit, NULL)));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cval_decl);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	val_ptr = (_tmp3_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("gvalue"))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL)), _tmp3_);
	/* call Get method on property proxy*/
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	_cdecl_ = (_tmp5_ = vala_ccode_declaration_new (_tmp4_ = vala_data_type_get_cname (vala_property_get_property_type ((ValaProperty*) node))), _tmp4_ = (g_free (_tmp4_), NULL), _tmp5_);
	_tmp6_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp6_ = vala_ccode_variable_declarator_new ("result", NULL, NULL)));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp7_ = NULL;
	_tmp8_ = NULL;
	ccall = (_tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("dbus_g_proxy_call"))), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL)), _tmp8_);
	_tmp9_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("property_proxy")));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp10_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_constant_new ("\"Get\"")));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp11_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_constant_new ("NULL")));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	_tmp12_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("G_TYPE_STRING")));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	_tmp13_ = NULL;
	_tmp14_ = NULL;
	get_iface = (_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("dbus_g_proxy_get_interface"))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp14_);
	_tmp15_ = NULL;
	vala_ccode_function_call_add_argument (get_iface, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("obj")));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) get_iface);
	_tmp16_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("G_TYPE_STRING")));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	_tmp17_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp19_ = vala_ccode_constant_new (_tmp18_ = g_strdup_printf ("\"%s\"", _tmp17_ = vala_dbus_client_module_get_dynamic_dbus_name (self, vala_symbol_get_name ((ValaSymbol*) node))))));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	_tmp18_ = (g_free (_tmp18_), NULL);
	_tmp17_ = (g_free (_tmp17_), NULL);
	_tmp20_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	_tmp21_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("G_TYPE_VALUE")));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) val_ptr);
	_tmp22_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	_tmp23_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp23_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	/* unref property proxy*/
	_tmp24_ = NULL;
	_tmp25_ = NULL;
	prop_proxy_unref = (_tmp25_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("g_object_unref"))), (_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL)), _tmp25_);
	_tmp26_ = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_unref, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new ("property_proxy")));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	_tmp27_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp27_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) prop_proxy_unref)));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	/* assign value to result variable*/
	_tmp29_ = NULL;
	_tmp28_ = NULL;
	_tmp30_ = NULL;
	cget_call = (_tmp30_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new (_tmp28_ = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_property_get_property_type ((ValaProperty*) node)))))), (_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL)), _tmp28_ = (g_free (_tmp28_), NULL), _tmp30_);
	vala_ccode_function_call_add_argument (cget_call, (ValaCCodeExpression*) val_ptr);
	_tmp31_ = NULL;
	_tmp32_ = NULL;
	assign = (_tmp32_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new ("result")), (ValaCCodeExpression*) cget_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL)), _tmp32_);
	_tmp33_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp33_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	/* return result*/
	_tmp35_ = NULL;
	_tmp34_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp35_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp34_ = vala_ccode_identifier_new ("result")))));
	(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
	(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
	(cvalinit == NULL) ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL));
	(cval_decl == NULL) ? NULL : (cval_decl = (vala_ccode_node_unref (cval_decl), NULL));
	(val_ptr == NULL) ? NULL : (val_ptr = (vala_ccode_node_unref (val_ptr), NULL));
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(get_iface == NULL) ? NULL : (get_iface = (vala_ccode_node_unref (get_iface), NULL));
	(prop_proxy_unref == NULL) ? NULL : (prop_proxy_unref = (vala_ccode_node_unref (prop_proxy_unref), NULL));
	(cget_call == NULL) ? NULL : (cget_call = (vala_ccode_node_unref (cget_call), NULL));
	(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
}


static void vala_dbus_client_module_generate_dbus_property_setter_wrapper (ValaDBusClientModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	ValaCCodeInitializerList* cvalinit;
	ValaCCodeConstant* _tmp0_;
	ValaCCodeDeclaration* cval_decl;
	ValaCCodeVariableDeclarator* _tmp1_;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeUnaryExpression* _tmp3_;
	ValaCCodeUnaryExpression* val_ptr;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* cinit_call;
	ValaCCodeIdentifier* _tmp7_;
	char* _tmp6_;
	ValaCCodeExpressionStatement* _tmp8_;
	ValaCCodeIdentifier* _tmp10_;
	char* _tmp9_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeFunctionCall* cset_call;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeExpressionStatement* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeFunctionCall* _tmp21_;
	ValaCCodeFunctionCall* get_iface;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeConstant* _tmp26_;
	char* _tmp25_;
	char* _tmp24_;
	ValaCCodeIdentifier* _tmp27_;
	ValaCCodeIdentifier* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeExpressionStatement* _tmp30_;
	ValaCCodeIdentifier* _tmp31_;
	ValaCCodeFunctionCall* _tmp32_;
	ValaCCodeFunctionCall* prop_proxy_unref;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeExpressionStatement* _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	vala_dbus_client_module_create_dbus_property_proxy (self, node, block);
	/* initialize GValue*/
	cvalinit = vala_ccode_initializer_list_new ();
	_tmp0_ = NULL;
	vala_ccode_initializer_list_append (cvalinit, (ValaCCodeExpression*) (_tmp0_ = vala_ccode_constant_new ("0")));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	cval_decl = vala_ccode_declaration_new ("GValue");
	_tmp1_ = NULL;
	vala_ccode_declaration_add_declarator (cval_decl, (ValaCCodeDeclarator*) (_tmp1_ = vala_ccode_variable_declarator_new ("gvalue", (ValaCCodeExpression*) cvalinit, NULL)));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cval_decl);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	val_ptr = (_tmp3_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("gvalue"))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL)), _tmp3_);
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	cinit_call = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("g_value_init"))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp5_);
	vala_ccode_function_call_add_argument (cinit_call, (ValaCCodeExpression*) val_ptr);
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	vala_ccode_function_call_add_argument (cinit_call, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new (_tmp6_ = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_property_get_property_type ((ValaProperty*) node))))));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp8_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp8_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinit_call)));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	_tmp11_ = NULL;
	cset_call = (_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new (_tmp9_ = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (vala_property_get_property_type ((ValaProperty*) node)))))), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), _tmp9_ = (g_free (_tmp9_), NULL), _tmp11_);
	vala_ccode_function_call_add_argument (cset_call, (ValaCCodeExpression*) val_ptr);
	_tmp12_ = NULL;
	vala_ccode_function_call_add_argument (cset_call, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("value")));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	_tmp13_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp13_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cset_call)));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	/* call Set method on property proxy*/
	_tmp14_ = NULL;
	_tmp15_ = NULL;
	ccall = (_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("dbus_g_proxy_call"))), (_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL)), _tmp15_);
	_tmp16_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("property_proxy")));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp17_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_constant_new ("\"Set\"")));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	_tmp18_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_constant_new ("NULL")));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	_tmp19_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("G_TYPE_STRING")));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	_tmp20_ = NULL;
	_tmp21_ = NULL;
	get_iface = (_tmp21_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("dbus_g_proxy_get_interface"))), (_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL)), _tmp21_);
	_tmp22_ = NULL;
	vala_ccode_function_call_add_argument (get_iface, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("obj")));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) get_iface);
	_tmp23_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new ("G_TYPE_STRING")));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	_tmp26_ = NULL;
	_tmp25_ = NULL;
	_tmp24_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_constant_new (_tmp25_ = g_strdup_printf ("\"%s\"", _tmp24_ = vala_dbus_client_module_get_dynamic_dbus_name (self, vala_symbol_get_name ((ValaSymbol*) node))))));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	_tmp25_ = (g_free (_tmp25_), NULL);
	_tmp24_ = (g_free (_tmp24_), NULL);
	_tmp27_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("G_TYPE_VALUE")));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) val_ptr);
	_tmp28_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	_tmp29_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	_tmp30_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp30_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
	/* unref property proxy*/
	_tmp31_ = NULL;
	_tmp32_ = NULL;
	prop_proxy_unref = (_tmp32_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new ("g_object_unref"))), (_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL)), _tmp32_);
	_tmp33_ = NULL;
	vala_ccode_function_call_add_argument (prop_proxy_unref, (ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new ("property_proxy")));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	_tmp34_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp34_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) prop_proxy_unref)));
	(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
	(cvalinit == NULL) ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL));
	(cval_decl == NULL) ? NULL : (cval_decl = (vala_ccode_node_unref (cval_decl), NULL));
	(val_ptr == NULL) ? NULL : (val_ptr = (vala_ccode_node_unref (val_ptr), NULL));
	(cinit_call == NULL) ? NULL : (cinit_call = (vala_ccode_node_unref (cinit_call), NULL));
	(cset_call == NULL) ? NULL : (cset_call = (vala_ccode_node_unref (cset_call), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(get_iface == NULL) ? NULL : (get_iface = (vala_ccode_node_unref (get_iface), NULL));
	(prop_proxy_unref == NULL) ? NULL : (prop_proxy_unref = (vala_ccode_node_unref (prop_proxy_unref), NULL));
}


static char* vala_dbus_client_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* base, ValaDynamicSignal* sig) {
	ValaDBusClientModule * self;
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	char* connect_wrapper_name;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp2_;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeFormalParameter* _tmp5_;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp6_;
	self = (ValaDBusClientModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	if (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (sig)) != ((ValaCCodeBaseModule*) self)->dbus_object_type) {
		result = VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeModule*) VALA_DBUS_MODULE (self), sig);
		return result;
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	connect_wrapper_name = (_tmp1_ = g_strdup_printf ("_%sconnect", _tmp0_ = vala_ccode_module_get_dynamic_signal_cname ((ValaCCodeModule*) self, sig)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	func = vala_ccode_function_new (connect_wrapper_name, "void");
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp2_ = vala_ccode_formal_parameter_new ("obj", "gpointer"));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp3_ = vala_ccode_formal_parameter_new ("signal_name", "const char *"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp4_ = vala_ccode_formal_parameter_new ("handler", "GCallback"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp5_ = vala_ccode_formal_parameter_new ("data", "gpointer"));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	block = vala_ccode_block_new ();
	vala_dbus_client_module_generate_dbus_connect_wrapper (self, sig, block);
	/* append to C source file*/
	_tmp6_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp6_ = vala_ccode_function_copy (func)));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	result = connect_wrapper_name;
	(func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	return result;
}


static char* vala_dbus_client_module_real_get_dynamic_signal_disconnect_wrapper_name (ValaCCodeModule* base, ValaDynamicSignal* sig) {
	ValaDBusClientModule * self;
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	char* disconnect_wrapper_name;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp2_;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeFormalParameter* _tmp5_;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp6_;
	self = (ValaDBusClientModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	if (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (sig)) != ((ValaCCodeBaseModule*) self)->dbus_object_type) {
		result = VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->get_dynamic_signal_disconnect_wrapper_name ((ValaCCodeModule*) VALA_DBUS_MODULE (self), sig);
		return result;
	}
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	disconnect_wrapper_name = (_tmp1_ = g_strdup_printf ("_%sdisconnect", _tmp0_ = vala_ccode_module_get_dynamic_signal_cname ((ValaCCodeModule*) self, sig)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	func = vala_ccode_function_new (disconnect_wrapper_name, "void");
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp2_ = vala_ccode_formal_parameter_new ("obj", "gpointer"));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp3_ = vala_ccode_formal_parameter_new ("signal_name", "const char *"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp4_ = vala_ccode_formal_parameter_new ("handler", "GCallback"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp5_ = vala_ccode_formal_parameter_new ("data", "gpointer"));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	block = vala_ccode_block_new ();
	vala_dbus_client_module_generate_dbus_disconnect_wrapper (self, sig, block);
	/* append to C source file*/
	_tmp6_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp6_ = vala_ccode_function_copy (func)));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	result = disconnect_wrapper_name;
	(func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	return result;
}


static void vala_dbus_client_module_generate_dbus_connect_wrapper (ValaDBusClientModule* self, ValaDynamicSignal* sig, ValaCCodeBlock* block) {
	ValaMethod* _tmp0_;
	ValaMethod* m;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* register_call;
	GeeList* _tmp3_;
	ValaCCodeIdentifier* _tmp6_;
	char* _tmp5_;
	GeeList* _tmp4_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeFunctionCall* _tmp9_;
	ValaCCodeFunctionCall* add_call;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeConstant* _tmp13_;
	char* _tmp12_;
	char* _tmp11_;
	gboolean first;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeExpressionStatement* _tmp20_;
	ValaCCodeExpressionStatement* _tmp21_;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeIdentifier* _tmp27_;
	ValaCCodeConstant* _tmp28_;
	ValaCCodeExpressionStatement* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (block != NULL);
	_tmp0_ = NULL;
	m = (_tmp0_ = VALA_METHOD (vala_expression_get_symbol_reference (vala_dynamic_signal_get_handler (sig))), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	vala_code_node_accept ((ValaCodeNode*) sig, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	/* FIXME should only be done once per marshaller*/
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	register_call = (_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1_ = vala_ccode_identifier_new ("dbus_g_object_register_marshaller"))), (_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL)), _tmp2_);
	_tmp3_ = NULL;
	vala_ccode_module_generate_marshaller (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp3_ = vala_signal_get_parameters ((ValaSignal*) sig), vala_signal_get_return_type ((ValaSignal*) sig), TRUE);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (gee_collection_object_unref (_tmp3_), NULL));
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new (_tmp5_ = vala_ccode_module_get_marshaller_function (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp4_ = vala_signal_get_parameters ((ValaSignal*) sig), vala_signal_get_return_type ((ValaSignal*) sig), NULL, TRUE))));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp5_ = (g_free (_tmp5_), NULL);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (gee_collection_object_unref (_tmp4_), NULL));
	_tmp7_ = NULL;
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("G_TYPE_NONE")));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp8_ = NULL;
	_tmp9_ = NULL;
	add_call = (_tmp9_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("dbus_g_proxy_add_signal"))), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), _tmp9_);
	_tmp10_ = NULL;
	vala_ccode_function_call_add_argument (add_call, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("obj")));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	vala_ccode_function_call_add_argument (add_call, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_constant_new (_tmp12_ = g_strdup_printf ("\"%s\"", _tmp11_ = vala_dbus_client_module_get_dynamic_dbus_name (self, vala_symbol_get_name ((ValaSymbol*) sig))))));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	_tmp12_ = (g_free (_tmp12_), NULL);
	_tmp11_ = (g_free (_tmp11_), NULL);
	first = TRUE;
	{
		GeeList* _tmp14_;
		GeeIterator* _tmp15_;
		GeeIterator* _param_it;
		_tmp14_ = NULL;
		_tmp15_ = NULL;
		_param_it = (_tmp15_ = gee_iterable_iterator ((GeeIterable*) (_tmp14_ = vala_method_get_parameters (m))), (_tmp14_ == NULL) ? NULL : (_tmp14_ = (gee_collection_object_unref (_tmp14_), NULL)), _tmp15_);
		while (TRUE) {
			ValaFormalParameter* param;
			ValaCCodeExpression* _tmp16_;
			ValaCCodeExpression* _tmp17_;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (first) {
				/* skip sender parameter*/
				first = FALSE;
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				continue;
			}
			_tmp16_ = NULL;
			vala_ccode_function_call_add_argument (register_call, _tmp16_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
			(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
			_tmp17_ = NULL;
			vala_ccode_function_call_add_argument (add_call, _tmp17_ = vala_gsignal_module_get_dbus_g_type ((ValaGSignalModule*) self, vala_formal_parameter_get_parameter_type (param)));
			(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp18_ = NULL;
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	_tmp19_ = NULL;
	vala_ccode_function_call_add_argument (add_call, (ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("G_TYPE_INVALID")));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	_tmp20_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp20_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) register_call)));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	_tmp21_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp21_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) add_call)));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	_tmp22_ = NULL;
	_tmp23_ = NULL;
	call = (_tmp23_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("dbus_g_proxy_connect_signal"))), (_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL)), _tmp23_);
	_tmp24_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("obj")));
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	_tmp25_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new ("signal_name")));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	_tmp26_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new ("handler")));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	_tmp27_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("data")));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	_tmp28_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_constant_new ("NULL")));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	_tmp29_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp29_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) call)));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	(register_call == NULL) ? NULL : (register_call = (vala_ccode_node_unref (register_call), NULL));
	(add_call == NULL) ? NULL : (add_call = (vala_ccode_node_unref (add_call), NULL));
	(call == NULL) ? NULL : (call = (vala_ccode_node_unref (call), NULL));
}


static void vala_dbus_client_module_generate_dbus_disconnect_wrapper (ValaDBusClientModule* self, ValaDynamicSignal* sig, ValaCCodeBlock* block) {
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeExpressionStatement* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (block != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	call = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("dbus_g_proxy_disconnect_signal"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("obj")));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("signal_name")));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("handler")));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("data")));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp6_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) call)));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	(call == NULL) ? NULL : (call = (vala_ccode_node_unref (call), NULL));
}


static void vala_dbus_client_module_real_visit_cast_expression (ValaCCodeModule* base, ValaCastExpression* expr) {
	ValaDBusClientModule * self;
	ValaObjectType* _tmp1_;
	ValaDataType* _tmp0_;
	ValaObjectType* type;
	ValaMethodCall* _tmp3_;
	ValaExpression* _tmp2_;
	ValaMethodCall* call;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	ValaMethodType* _tmp9_;
	ValaDataType* _tmp8_;
	ValaMethodType* mtype;
	gboolean _tmp10_;
	GeeList* args;
	ValaExpression* _tmp12_;
	ValaExpression* connection;
	ValaExpression* bus_name;
	ValaExpression* object_path;
	ValaCCodeIdentifier* _tmp15_;
	char* _tmp14_;
	char* _tmp13_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeFunctionCall* ccall;
	self = (ValaDBusClientModule*) base;
	g_return_if_fail (expr != NULL);
	/* handles casting DBus.Object instances to DBus interfaces*/
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	type = (_tmp1_ = (_tmp0_ = vala_cast_expression_get_type_reference (expr), VALA_IS_OBJECT_TYPE (_tmp0_) ? ((ValaObjectType*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	call = (_tmp3_ = (_tmp2_ = vala_cast_expression_get_inner (expr), VALA_IS_METHOD_CALL (_tmp2_) ? ((ValaMethodCall*) _tmp2_) : NULL), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
	_tmp4_ = FALSE;
	_tmp5_ = FALSE;
	_tmp6_ = FALSE;
	if (type == NULL) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = !VALA_IS_INTERFACE (vala_object_type_get_type_symbol (type));
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		ValaAttribute* _tmp7_;
		_tmp7_ = NULL;
		_tmp5_ = (_tmp7_ = vala_code_node_get_attribute ((ValaCodeNode*) vala_object_type_get_type_symbol (type), "DBus")) == NULL;
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_code_node_unref (_tmp7_), NULL));
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = call == NULL;
	}
	if (_tmp4_) {
		VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->visit_cast_expression ((ValaCCodeModule*) VALA_DBUS_MODULE (self), expr);
		(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
		(call == NULL) ? NULL : (call = (vala_code_node_unref (call), NULL));
		return;
	}
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	mtype = (_tmp9_ = (_tmp8_ = vala_expression_get_value_type (vala_method_call_get_call (call)), VALA_IS_METHOD_TYPE (_tmp8_) ? ((ValaMethodType*) _tmp8_) : NULL), (_tmp9_ == NULL) ? NULL : vala_code_node_ref (_tmp9_));
	_tmp10_ = FALSE;
	if (mtype == NULL) {
		_tmp10_ = TRUE;
	} else {
		char* _tmp11_;
		_tmp11_ = NULL;
		_tmp10_ = _vala_strcmp0 (_tmp11_ = vala_method_get_cname (vala_method_type_get_method_symbol (mtype)), "dbus_g_proxy_new_for_name") != 0;
		_tmp11_ = (g_free (_tmp11_), NULL);
	}
	if (_tmp10_) {
		VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->visit_cast_expression ((ValaCCodeModule*) VALA_DBUS_MODULE (self), expr);
		(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
		(call == NULL) ? NULL : (call = (vala_code_node_unref (call), NULL));
		(mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL));
		return;
	}
	args = vala_method_call_get_argument_list (call);
	_tmp12_ = NULL;
	connection = (_tmp12_ = vala_member_access_get_inner (VALA_MEMBER_ACCESS (vala_method_call_get_call (call))), (_tmp12_ == NULL) ? NULL : vala_code_node_ref (_tmp12_));
	bus_name = (ValaExpression*) gee_list_get (args, 0);
	object_path = (ValaExpression*) gee_list_get (args, 1);
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	_tmp16_ = NULL;
	ccall = (_tmp16_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new (_tmp14_ = g_strconcat (_tmp13_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) vala_object_type_get_type_symbol (type)), "dbus_proxy_new", NULL)))), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL)), _tmp14_ = (g_free (_tmp14_), NULL), _tmp13_ = (g_free (_tmp13_), NULL), _tmp16_);
	vala_code_node_accept ((ValaCodeNode*) connection, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) connection)));
	vala_code_node_accept ((ValaCodeNode*) bus_name, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) bus_name)));
	vala_code_node_accept ((ValaCodeNode*) object_path, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) object_path)));
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
	(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
	(call == NULL) ? NULL : (call = (vala_code_node_unref (call), NULL));
	(mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL));
	(args == NULL) ? NULL : (args = (gee_collection_object_unref (args), NULL));
	(connection == NULL) ? NULL : (connection = (vala_code_node_unref (connection), NULL));
	(bus_name == NULL) ? NULL : (bus_name = (vala_code_node_unref (bus_name), NULL));
	(object_path == NULL) ? NULL : (object_path = (vala_code_node_unref (object_path), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_dbus_client_module_real_visit_interface (ValaCCodeModule* base, ValaInterface* iface) {
	ValaDBusClientModule * self;
	ValaAttribute* dbus;
	char* dbus_iface_name;
	char* _tmp0_;
	char* _tmp1_;
	char* cname;
	char* _tmp2_;
	char* _tmp3_;
	char* lower_cname;
	ValaCCodeTypeDefinition* _tmp6_;
	ValaCCodeVariableDeclarator* _tmp5_;
	char* _tmp4_;
	ValaCCodeTypeDefinition* _tmp9_;
	ValaCCodeVariableDeclarator* _tmp8_;
	char* _tmp7_;
	char* _tmp10_;
	ValaCCodeStruct* _tmp11_;
	ValaCCodeStruct* instance_struct;
	ValaCCodeFunction* _tmp13_;
	char* _tmp12_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* implement;
	ValaCCodeIdentifier* _tmp17_;
	char* _tmp16_;
	ValaCCodeIdentifier* _tmp19_;
	char* _tmp18_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeFunctionCall* _tmp21_;
	ValaCCodeFunctionCall* define_type;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeConstant* _tmp25_;
	ValaCCodeExpressionStatement* _tmp26_;
	char* _tmp29_;
	char* _tmp28_;
	char* _tmp27_;
	ValaCCodeFunction* _tmp30_;
	ValaCCodeFunction* proxy_new;
	ValaCCodeFormalParameter* _tmp31_;
	ValaCCodeFormalParameter* _tmp32_;
	ValaCCodeFormalParameter* _tmp33_;
	ValaCCodeBlock* new_block;
	ValaCCodeIdentifier* _tmp34_;
	ValaCCodeFunctionCall* _tmp35_;
	ValaCCodeFunctionCall* new_call;
	ValaCCodeFunctionCall* _tmp38_;
	ValaCCodeIdentifier* _tmp37_;
	char* _tmp36_;
	ValaCCodeConstant* _tmp39_;
	ValaCCodeIdentifier* _tmp40_;
	ValaCCodeConstant* _tmp41_;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeIdentifier* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeConstant* _tmp47_;
	char* _tmp46_;
	ValaCCodeConstant* _tmp48_;
	char* _tmp50_;
	char* _tmp49_;
	ValaCCodeDeclaration* _tmp51_;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp52_;
	ValaCCodeReturnStatement* _tmp54_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeFunction* _tmp55_;
	char* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	ValaCCodeFunction* proxy_construct;
	ValaCCodeFormalParameter* _tmp58_;
	ValaCCodeFormalParameter* _tmp59_;
	ValaCCodeFormalParameter* _tmp60_;
	ValaCCodeBlock* _tmp61_;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeFunctionCall* _tmp63_;
	ValaCCodeFunctionCall* parent_class;
	ValaCCodeIdentifier* _tmp65_;
	char* _tmp64_;
	ValaCCodeMemberAccess* _tmp66_;
	ValaCCodeFunctionCall* _tmp67_;
	ValaCCodeFunctionCall* chainup;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeIdentifier* _tmp69_;
	ValaCCodeIdentifier* _tmp70_;
	ValaCCodeDeclaration* _tmp71_;
	ValaCCodeVariableDeclarator* _tmp72_;
	ValaCCodeDeclaration* _tmp73_;
	ValaCCodeVariableDeclarator* _tmp74_;
	ValaCCodeIdentifier* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* gconnection;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeConstant* _tmp78_;
	ValaCCodeUnaryExpression* _tmp80_;
	ValaCCodeIdentifier* _tmp79_;
	ValaCCodeConstant* _tmp81_;
	ValaCCodeExpressionStatement* _tmp82_;
	ValaCCodeDeclaration* _tmp83_;
	ValaCCodeVariableDeclarator* _tmp84_;
	ValaCCodeIdentifier* _tmp85_;
	ValaCCodeFunctionCall* _tmp86_;
	ValaCCodeFunctionCall* path;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeConstant* _tmp88_;
	ValaCCodeUnaryExpression* _tmp90_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeConstant* _tmp91_;
	ValaCCodeExpressionStatement* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeFunctionCall* _tmp94_;
	ValaCCodeFunctionCall* raw_connection;
	ValaCCodeIdentifier* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeFunctionCall* _tmp97_;
	ValaCCodeFunctionCall* filter_call;
	ValaCCodeIdentifier* _tmp99_;
	char* _tmp98_;
	ValaCCodeIdentifier* _tmp100_;
	ValaCCodeConstant* _tmp101_;
	ValaCCodeExpressionStatement* _tmp102_;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeFunctionCall* filter_printf;
	ValaCCodeConstant* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeDeclaration* _tmp107_;
	ValaCCodeVariableDeclarator* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeFunctionCall* match_call;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeConstant* _tmp112_;
	ValaCCodeExpressionStatement* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeFunctionCall* _tmp115_;
	ValaCCodeFunctionCall* connection_free;
	ValaCCodeIdentifier* _tmp116_;
	ValaCCodeExpressionStatement* _tmp117_;
	ValaCCodeIdentifier* _tmp118_;
	ValaCCodeFunctionCall* _tmp119_;
	ValaCCodeFunctionCall* path_free;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeExpressionStatement* _tmp121_;
	ValaCCodeIdentifier* _tmp122_;
	ValaCCodeFunctionCall* _tmp123_;
	ValaCCodeFunctionCall* filter_free;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeExpressionStatement* _tmp125_;
	ValaCCodeReturnStatement* _tmp127_;
	ValaCCodeIdentifier* _tmp126_;
	char* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeFunction* proxy_dispose;
	ValaCCodeFormalParameter* _tmp130_;
	ValaCCodeBlock* _tmp131_;
	ValaCCodeDeclaration* _tmp132_;
	ValaCCodeVariableDeclarator* _tmp133_;
	ValaCCodeBlock* dispose_return_block;
	ValaCCodeReturnStatement* _tmp134_;
	ValaCCodeIfStatement* _tmp139_;
	ValaCCodeMemberAccess* _tmp138_;
	ValaCCodeCastExpression* _tmp137_;
	char* _tmp136_;
	ValaCCodeIdentifier* _tmp135_;
	ValaCCodeExpressionStatement* _tmp146_;
	ValaCCodeAssignment* _tmp145_;
	ValaCCodeConstant* _tmp144_;
	ValaCCodeMemberAccess* _tmp143_;
	ValaCCodeCastExpression* _tmp142_;
	char* _tmp141_;
	ValaCCodeIdentifier* _tmp140_;
	ValaCCodeFunctionCall* _tmp148_;
	ValaCCodeIdentifier* _tmp147_;
	ValaCCodeIdentifier* _tmp149_;
	ValaCCodeConstant* _tmp150_;
	ValaCCodeUnaryExpression* _tmp152_;
	ValaCCodeIdentifier* _tmp151_;
	ValaCCodeConstant* _tmp153_;
	ValaCCodeExpressionStatement* _tmp154_;
	ValaCCodeFunctionCall* _tmp156_;
	ValaCCodeIdentifier* _tmp155_;
	ValaCCodeIdentifier* _tmp158_;
	char* _tmp157_;
	ValaCCodeIdentifier* _tmp159_;
	ValaCCodeExpressionStatement* _tmp160_;
	ValaCCodeFunctionCall* _tmp162_;
	ValaCCodeIdentifier* _tmp161_;
	ValaCCodeIdentifier* _tmp164_;
	char* _tmp163_;
	ValaCCodeFunctionCall* _tmp166_;
	ValaCCodeMemberAccess* _tmp165_;
	ValaCCodeIdentifier* _tmp167_;
	ValaCCodeExpressionStatement* _tmp168_;
	char* _tmp169_;
	ValaCCodeFunction* _tmp170_;
	ValaCCodeFunction* proxy_class_init;
	ValaCCodeFormalParameter* _tmp172_;
	char* _tmp171_;
	ValaCCodeBlock* _tmp173_;
	ValaCCodeIdentifier* _tmp174_;
	ValaCCodeFunctionCall* _tmp175_;
	ValaCCodeFunctionCall* gobject_class;
	ValaCCodeIdentifier* _tmp176_;
	ValaCCodeExpressionStatement* _tmp181_;
	ValaCCodeAssignment* _tmp180_;
	ValaCCodeIdentifier* _tmp179_;
	char* _tmp178_;
	ValaCCodeMemberAccess* _tmp177_;
	ValaCCodeExpressionStatement* _tmp186_;
	ValaCCodeAssignment* _tmp185_;
	ValaCCodeIdentifier* _tmp184_;
	char* _tmp183_;
	ValaCCodeMemberAccess* _tmp182_;
	ValaCCodeExpressionStatement* _tmp191_;
	ValaCCodeAssignment* _tmp190_;
	ValaCCodeIdentifier* _tmp189_;
	char* _tmp188_;
	ValaCCodeMemberAccess* _tmp187_;
	ValaCCodeExpressionStatement* _tmp196_;
	ValaCCodeAssignment* _tmp195_;
	ValaCCodeIdentifier* _tmp194_;
	char* _tmp193_;
	ValaCCodeMemberAccess* _tmp192_;
	ValaCCodeEnum* _tmp197_;
	ValaCCodeEnumValue* _tmp200_;
	char* _tmp199_;
	char* _tmp198_;
	char* _tmp211_;
	ValaCCodeFunction* _tmp212_;
	ValaCCodeFunction* proxy_instance_init;
	ValaCCodeFormalParameter* _tmp214_;
	char* _tmp213_;
	ValaCCodeBlock* _tmp215_;
	char* _tmp216_;
	ValaCCodeFunction* _tmp217_;
	ValaCCodeFunction* proxy_iface_init;
	ValaCCodeFormalParameter* _tmp220_;
	char* _tmp219_;
	char* _tmp218_;
	ValaCCodeBlock* iface_block;
	ValaCCodeFunction* _tmp259_;
	char* _tmp260_;
	ValaCCodeFunction* _tmp261_;
	ValaCCodeFunction* get_prop;
	ValaCCodeFormalParameter* _tmp262_;
	ValaCCodeFormalParameter* _tmp263_;
	ValaCCodeFormalParameter* _tmp264_;
	ValaCCodeFormalParameter* _tmp265_;
	ValaCCodeFunction* _tmp266_;
	ValaCCodeBlock* _tmp267_;
	char* _tmp268_;
	ValaCCodeFunction* _tmp269_;
	ValaCCodeFunction* set_prop;
	ValaCCodeFormalParameter* _tmp270_;
	ValaCCodeFormalParameter* _tmp271_;
	ValaCCodeFormalParameter* _tmp272_;
	ValaCCodeFormalParameter* _tmp273_;
	ValaCCodeFunction* _tmp274_;
	ValaCCodeBlock* _tmp275_;
	self = (ValaDBusClientModule*) base;
	g_return_if_fail (iface != NULL);
	VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->visit_interface ((ValaCCodeModule*) VALA_DBUS_MODULE (self), iface);
	dbus = vala_code_node_get_attribute ((ValaCodeNode*) iface, "DBus");
	if (dbus == NULL) {
		(dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL));
		return;
	}
	dbus_iface_name = vala_attribute_get_string (dbus, "name");
	if (dbus_iface_name == NULL) {
		(dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL));
		dbus_iface_name = (g_free (dbus_iface_name), NULL);
		return;
	}
	/* create proxy class*/
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	cname = (_tmp1_ = g_strconcat (_tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), "DBusProxy", NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	lower_cname = (_tmp3_ = g_strconcat (_tmp2_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), "dbus_proxy", NULL), _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_);
	if (vala_symbol_get_access ((ValaSymbol*) iface) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		((ValaCCodeBaseModule*) self)->dbus_glib_h_needed_in_header = TRUE;
	} else {
		((ValaCCodeBaseModule*) self)->dbus_glib_h_needed = TRUE;
	}
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp6_ = vala_ccode_type_definition_new (_tmp4_ = g_strdup_printf ("struct _%s", cname), (ValaCCodeDeclarator*) (_tmp5_ = vala_ccode_variable_declarator_new (cname, NULL, NULL)))));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp9_ = vala_ccode_type_definition_new ("DBusGProxyClass", (ValaCCodeDeclarator*) (_tmp8_ = vala_ccode_variable_declarator_new (_tmp7_ = g_strconcat (cname, "Class", NULL), NULL, NULL)))));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp10_ = NULL;
	_tmp11_ = NULL;
	instance_struct = (_tmp11_ = vala_ccode_struct_new (_tmp10_ = g_strdup_printf ("_%s", cname)), _tmp10_ = (g_free (_tmp10_), NULL), _tmp11_);
	vala_ccode_struct_add_field (instance_struct, "DBusGProxy", "parent_instance");
	vala_ccode_struct_add_field (instance_struct, "gboolean", "disposed");
	vala_ccode_declaration_space_add_type_definition (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) instance_struct);
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp13_ = vala_ccode_function_new (_tmp12_ = g_strconcat (lower_cname, "_get_type", NULL), "GType")));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	_tmp12_ = (g_free (_tmp12_), NULL);
	_tmp14_ = NULL;
	_tmp15_ = NULL;
	implement = (_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("G_IMPLEMENT_INTERFACE"))), (_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL)), _tmp15_);
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	vala_ccode_function_call_add_argument (implement, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new (_tmp16_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, "TYPE_"))));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	_tmp16_ = (g_free (_tmp16_), NULL);
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	vala_ccode_function_call_add_argument (implement, (ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new (_tmp18_ = g_strconcat (lower_cname, "_interface_init", NULL))));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	_tmp18_ = (g_free (_tmp18_), NULL);
	_tmp20_ = NULL;
	_tmp21_ = NULL;
	define_type = (_tmp21_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("G_DEFINE_TYPE_EXTENDED"))), (_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL)), _tmp21_);
	_tmp22_ = NULL;
	vala_ccode_function_call_add_argument (define_type, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new (cname)));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	_tmp23_ = NULL;
	vala_ccode_function_call_add_argument (define_type, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new (lower_cname)));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	_tmp24_ = NULL;
	vala_ccode_function_call_add_argument (define_type, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("DBUS_TYPE_G_PROXY")));
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	_tmp25_ = NULL;
	vala_ccode_function_call_add_argument (define_type, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_constant_new ("0")));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	vala_ccode_function_call_add_argument (define_type, (ValaCCodeExpression*) implement);
	_tmp26_ = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp26_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) define_type)));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	/* generate proxy_new function*/
	_tmp29_ = NULL;
	_tmp28_ = NULL;
	_tmp27_ = NULL;
	_tmp30_ = NULL;
	proxy_new = (_tmp30_ = vala_ccode_function_new (_tmp27_ = g_strconcat (lower_cname, "_new", NULL), _tmp29_ = g_strconcat (_tmp28_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), "*", NULL)), _tmp29_ = (g_free (_tmp29_), NULL), _tmp28_ = (g_free (_tmp28_), NULL), _tmp27_ = (g_free (_tmp27_), NULL), _tmp30_);
	_tmp31_ = NULL;
	vala_ccode_function_add_parameter (proxy_new, _tmp31_ = vala_ccode_formal_parameter_new ("connection", "DBusGConnection*"));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	_tmp32_ = NULL;
	vala_ccode_function_add_parameter (proxy_new, _tmp32_ = vala_ccode_formal_parameter_new ("name", "const char*"));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	_tmp33_ = NULL;
	vala_ccode_function_add_parameter (proxy_new, _tmp33_ = vala_ccode_formal_parameter_new ("path", "const char*"));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	new_block = vala_ccode_block_new ();
	/* create proxy object*/
	_tmp34_ = NULL;
	_tmp35_ = NULL;
	new_call = (_tmp35_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp34_ = vala_ccode_identifier_new ("g_object_new"))), (_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL)), _tmp35_);
	_tmp38_ = NULL;
	_tmp37_ = NULL;
	_tmp36_ = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new (_tmp36_ = g_strconcat (lower_cname, "_get_type", NULL))))));
	(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
	(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
	_tmp36_ = (g_free (_tmp36_), NULL);
	_tmp39_ = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_constant_new ("\"connection\"")));
	(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
	_tmp40_ = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new ("connection")));
	(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
	_tmp41_ = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_constant_new ("\"name\"")));
	(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
	_tmp42_ = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_identifier_new ("name")));
	(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
	_tmp43_ = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp43_ = vala_ccode_constant_new ("\"path\"")));
	(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
	_tmp44_ = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp44_ = vala_ccode_identifier_new ("path")));
	(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
	_tmp45_ = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp45_ = vala_ccode_constant_new ("\"interface\"")));
	(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
	_tmp47_ = NULL;
	_tmp46_ = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp47_ = vala_ccode_constant_new (_tmp46_ = g_strdup_printf ("\"%s\"", dbus_iface_name))));
	(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
	_tmp46_ = (g_free (_tmp46_), NULL);
	_tmp48_ = NULL;
	vala_ccode_function_call_add_argument (new_call, (ValaCCodeExpression*) (_tmp48_ = vala_ccode_constant_new ("NULL")));
	(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
	_tmp50_ = NULL;
	_tmp49_ = NULL;
	_tmp51_ = NULL;
	_cdecl_ = (_tmp51_ = vala_ccode_declaration_new (_tmp50_ = g_strconcat (_tmp49_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), "*", NULL)), _tmp50_ = (g_free (_tmp50_), NULL), _tmp49_ = (g_free (_tmp49_), NULL), _tmp51_);
	_tmp52_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp52_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) new_call, NULL)));
	(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
	vala_ccode_block_add_statement (new_block, (ValaCCodeNode*) _cdecl_);
	_tmp54_ = NULL;
	_tmp53_ = NULL;
	vala_ccode_block_add_statement (new_block, (ValaCCodeNode*) (_tmp54_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp53_ = vala_ccode_identifier_new ("self")))));
	(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
	(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
	_tmp55_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp55_ = vala_ccode_function_copy (proxy_new)));
	(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
	vala_ccode_function_set_block (proxy_new, new_block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) proxy_new);
	/* dbus proxy construct*/
	_tmp56_ = NULL;
	_tmp57_ = NULL;
	proxy_construct = (_tmp57_ = vala_ccode_function_new (_tmp56_ = g_strconcat (lower_cname, "_construct", NULL), "GObject*"), _tmp56_ = (g_free (_tmp56_), NULL), _tmp57_);
	_tmp58_ = NULL;
	vala_ccode_function_add_parameter (proxy_construct, _tmp58_ = vala_ccode_formal_parameter_new ("gtype", "GType"));
	(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
	_tmp59_ = NULL;
	vala_ccode_function_add_parameter (proxy_construct, _tmp59_ = vala_ccode_formal_parameter_new ("n_properties", "guint"));
	(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
	_tmp60_ = NULL;
	vala_ccode_function_add_parameter (proxy_construct, _tmp60_ = vala_ccode_formal_parameter_new ("properties", "GObjectConstructParam*"));
	(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
	vala_ccode_function_set_modifiers (proxy_construct, VALA_CCODE_MODIFIERS_STATIC);
	_tmp61_ = NULL;
	vala_ccode_function_set_block (proxy_construct, _tmp61_ = vala_ccode_block_new ());
	(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
	/* chain up*/
	_tmp62_ = NULL;
	_tmp63_ = NULL;
	parent_class = (_tmp63_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp62_ = vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL)), _tmp63_);
	_tmp65_ = NULL;
	_tmp64_ = NULL;
	vala_ccode_function_call_add_argument (parent_class, (ValaCCodeExpression*) (_tmp65_ = vala_ccode_identifier_new (_tmp64_ = g_strconcat (lower_cname, "_parent_class", NULL))));
	(_tmp65_ == NULL) ? NULL : (_tmp65_ = (vala_ccode_node_unref (_tmp65_), NULL));
	_tmp64_ = (g_free (_tmp64_), NULL);
	_tmp66_ = NULL;
	_tmp67_ = NULL;
	chainup = (_tmp67_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp66_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) parent_class, "constructor"))), (_tmp66_ == NULL) ? NULL : (_tmp66_ = (vala_ccode_node_unref (_tmp66_), NULL)), _tmp67_);
	_tmp68_ = NULL;
	vala_ccode_function_call_add_argument (chainup, (ValaCCodeExpression*) (_tmp68_ = vala_ccode_identifier_new ("gtype")));
	(_tmp68_ == NULL) ? NULL : (_tmp68_ = (vala_ccode_node_unref (_tmp68_), NULL));
	_tmp69_ = NULL;
	vala_ccode_function_call_add_argument (chainup, (ValaCCodeExpression*) (_tmp69_ = vala_ccode_identifier_new ("n_properties")));
	(_tmp69_ == NULL) ? NULL : (_tmp69_ = (vala_ccode_node_unref (_tmp69_), NULL));
	_tmp70_ = NULL;
	vala_ccode_function_call_add_argument (chainup, (ValaCCodeExpression*) (_tmp70_ = vala_ccode_identifier_new ("properties")));
	(_tmp70_ == NULL) ? NULL : (_tmp70_ = (vala_ccode_node_unref (_tmp70_), NULL));
	_tmp71_ = NULL;
	_cdecl_ = (_tmp71_ = vala_ccode_declaration_new ("GObject*"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp71_);
	_tmp72_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp72_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) chainup, NULL)));
	(_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_construct), (ValaCCodeNode*) _cdecl_);
	_tmp73_ = NULL;
	_cdecl_ = (_tmp73_ = vala_ccode_declaration_new ("DBusGConnection"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp73_);
	_tmp74_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp74_ = vala_ccode_variable_declarator_new ("*connection", NULL, NULL)));
	(_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_construct), (ValaCCodeNode*) _cdecl_);
	_tmp75_ = NULL;
	_tmp76_ = NULL;
	gconnection = (_tmp76_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp75_ = vala_ccode_identifier_new ("g_object_get"))), (_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL)), _tmp76_);
	_tmp77_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp77_ = vala_ccode_identifier_new ("self")));
	(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
	_tmp78_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp78_ = vala_ccode_constant_new ("\"connection\"")));
	(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
	_tmp80_ = NULL;
	_tmp79_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp80_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp79_ = vala_ccode_identifier_new ("connection")))));
	(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
	(_tmp79_ == NULL) ? NULL : (_tmp79_ = (vala_ccode_node_unref (_tmp79_), NULL));
	_tmp81_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp81_ = vala_ccode_constant_new ("NULL")));
	(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_ccode_node_unref (_tmp81_), NULL));
	_tmp82_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_construct), (ValaCCodeNode*) (_tmp82_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) gconnection)));
	(_tmp82_ == NULL) ? NULL : (_tmp82_ = (vala_ccode_node_unref (_tmp82_), NULL));
	_tmp83_ = NULL;
	_cdecl_ = (_tmp83_ = vala_ccode_declaration_new ("char*"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp83_);
	_tmp84_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp84_ = vala_ccode_variable_declarator_new ("path", NULL, NULL)));
	(_tmp84_ == NULL) ? NULL : (_tmp84_ = (vala_ccode_node_unref (_tmp84_), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_construct), (ValaCCodeNode*) _cdecl_);
	_tmp85_ = NULL;
	_tmp86_ = NULL;
	path = (_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp85_ = vala_ccode_identifier_new ("g_object_get"))), (_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL)), _tmp86_);
	_tmp87_ = NULL;
	vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp87_ = vala_ccode_identifier_new ("self")));
	(_tmp87_ == NULL) ? NULL : (_tmp87_ = (vala_ccode_node_unref (_tmp87_), NULL));
	_tmp88_ = NULL;
	vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp88_ = vala_ccode_constant_new ("\"path\"")));
	(_tmp88_ == NULL) ? NULL : (_tmp88_ = (vala_ccode_node_unref (_tmp88_), NULL));
	_tmp90_ = NULL;
	_tmp89_ = NULL;
	vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp90_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp89_ = vala_ccode_identifier_new ("path")))));
	(_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_ccode_node_unref (_tmp90_), NULL));
	(_tmp89_ == NULL) ? NULL : (_tmp89_ = (vala_ccode_node_unref (_tmp89_), NULL));
	_tmp91_ = NULL;
	vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp91_ = vala_ccode_constant_new ("NULL")));
	(_tmp91_ == NULL) ? NULL : (_tmp91_ = (vala_ccode_node_unref (_tmp91_), NULL));
	_tmp92_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_construct), (ValaCCodeNode*) (_tmp92_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) path)));
	(_tmp92_ == NULL) ? NULL : (_tmp92_ = (vala_ccode_node_unref (_tmp92_), NULL));
	_tmp93_ = NULL;
	_tmp94_ = NULL;
	raw_connection = (_tmp94_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp93_ = vala_ccode_identifier_new ("dbus_g_connection_get_connection"))), (_tmp93_ == NULL) ? NULL : (_tmp93_ = (vala_ccode_node_unref (_tmp93_), NULL)), _tmp94_);
	_tmp95_ = NULL;
	vala_ccode_function_call_add_argument (raw_connection, (ValaCCodeExpression*) (_tmp95_ = vala_ccode_identifier_new ("connection")));
	(_tmp95_ == NULL) ? NULL : (_tmp95_ = (vala_ccode_node_unref (_tmp95_), NULL));
	/* add filter to handle signals from the remote object*/
	_tmp96_ = NULL;
	_tmp97_ = NULL;
	filter_call = (_tmp97_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp96_ = vala_ccode_identifier_new ("dbus_connection_add_filter"))), (_tmp96_ == NULL) ? NULL : (_tmp96_ = (vala_ccode_node_unref (_tmp96_), NULL)), _tmp97_);
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) raw_connection);
	_tmp99_ = NULL;
	_tmp98_ = NULL;
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) (_tmp99_ = vala_ccode_identifier_new (_tmp98_ = g_strconcat (lower_cname, "_filter", NULL))));
	(_tmp99_ == NULL) ? NULL : (_tmp99_ = (vala_ccode_node_unref (_tmp99_), NULL));
	_tmp98_ = (g_free (_tmp98_), NULL);
	_tmp100_ = NULL;
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) (_tmp100_ = vala_ccode_identifier_new ("self")));
	(_tmp100_ == NULL) ? NULL : (_tmp100_ = (vala_ccode_node_unref (_tmp100_), NULL));
	_tmp101_ = NULL;
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) (_tmp101_ = vala_ccode_constant_new ("NULL")));
	(_tmp101_ == NULL) ? NULL : (_tmp101_ = (vala_ccode_node_unref (_tmp101_), NULL));
	_tmp102_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_construct), (ValaCCodeNode*) (_tmp102_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) filter_call)));
	(_tmp102_ == NULL) ? NULL : (_tmp102_ = (vala_ccode_node_unref (_tmp102_), NULL));
	_tmp103_ = NULL;
	_tmp104_ = NULL;
	filter_printf = (_tmp104_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp103_ = vala_ccode_identifier_new ("g_strdup_printf"))), (_tmp103_ == NULL) ? NULL : (_tmp103_ = (vala_ccode_node_unref (_tmp103_), NULL)), _tmp104_);
	_tmp105_ = NULL;
	vala_ccode_function_call_add_argument (filter_printf, (ValaCCodeExpression*) (_tmp105_ = vala_ccode_constant_new ("\"type='signal',path='%s'\"")));
	(_tmp105_ == NULL) ? NULL : (_tmp105_ = (vala_ccode_node_unref (_tmp105_), NULL));
	_tmp106_ = NULL;
	vala_ccode_function_call_add_argument (filter_printf, (ValaCCodeExpression*) (_tmp106_ = vala_ccode_identifier_new ("path")));
	(_tmp106_ == NULL) ? NULL : (_tmp106_ = (vala_ccode_node_unref (_tmp106_), NULL));
	_tmp107_ = NULL;
	_cdecl_ = (_tmp107_ = vala_ccode_declaration_new ("char*"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp107_);
	_tmp108_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp108_ = vala_ccode_variable_declarator_new ("filter", (ValaCCodeExpression*) filter_printf, NULL)));
	(_tmp108_ == NULL) ? NULL : (_tmp108_ = (vala_ccode_node_unref (_tmp108_), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_construct), (ValaCCodeNode*) _cdecl_);
	/* ensure we receive signals from the remote object*/
	_tmp109_ = NULL;
	_tmp110_ = NULL;
	match_call = (_tmp110_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp109_ = vala_ccode_identifier_new ("dbus_bus_add_match"))), (_tmp109_ == NULL) ? NULL : (_tmp109_ = (vala_ccode_node_unref (_tmp109_), NULL)), _tmp110_);
	vala_ccode_function_call_add_argument (match_call, (ValaCCodeExpression*) raw_connection);
	_tmp111_ = NULL;
	vala_ccode_function_call_add_argument (match_call, (ValaCCodeExpression*) (_tmp111_ = vala_ccode_identifier_new ("filter")));
	(_tmp111_ == NULL) ? NULL : (_tmp111_ = (vala_ccode_node_unref (_tmp111_), NULL));
	_tmp112_ = NULL;
	vala_ccode_function_call_add_argument (match_call, (ValaCCodeExpression*) (_tmp112_ = vala_ccode_constant_new ("NULL")));
	(_tmp112_ == NULL) ? NULL : (_tmp112_ = (vala_ccode_node_unref (_tmp112_), NULL));
	_tmp113_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_construct), (ValaCCodeNode*) (_tmp113_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) match_call)));
	(_tmp113_ == NULL) ? NULL : (_tmp113_ = (vala_ccode_node_unref (_tmp113_), NULL));
	_tmp114_ = NULL;
	_tmp115_ = NULL;
	connection_free = (_tmp115_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp114_ = vala_ccode_identifier_new ("dbus_g_connection_unref"))), (_tmp114_ == NULL) ? NULL : (_tmp114_ = (vala_ccode_node_unref (_tmp114_), NULL)), _tmp115_);
	_tmp116_ = NULL;
	vala_ccode_function_call_add_argument (connection_free, (ValaCCodeExpression*) (_tmp116_ = vala_ccode_identifier_new ("connection")));
	(_tmp116_ == NULL) ? NULL : (_tmp116_ = (vala_ccode_node_unref (_tmp116_), NULL));
	_tmp117_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_construct), (ValaCCodeNode*) (_tmp117_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) connection_free)));
	(_tmp117_ == NULL) ? NULL : (_tmp117_ = (vala_ccode_node_unref (_tmp117_), NULL));
	_tmp118_ = NULL;
	_tmp119_ = NULL;
	path_free = (_tmp119_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp118_ = vala_ccode_identifier_new ("g_free"))), (_tmp118_ == NULL) ? NULL : (_tmp118_ = (vala_ccode_node_unref (_tmp118_), NULL)), _tmp119_);
	_tmp120_ = NULL;
	vala_ccode_function_call_add_argument (path_free, (ValaCCodeExpression*) (_tmp120_ = vala_ccode_identifier_new ("path")));
	(_tmp120_ == NULL) ? NULL : (_tmp120_ = (vala_ccode_node_unref (_tmp120_), NULL));
	_tmp121_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_construct), (ValaCCodeNode*) (_tmp121_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) path_free)));
	(_tmp121_ == NULL) ? NULL : (_tmp121_ = (vala_ccode_node_unref (_tmp121_), NULL));
	_tmp122_ = NULL;
	_tmp123_ = NULL;
	filter_free = (_tmp123_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp122_ = vala_ccode_identifier_new ("g_free"))), (_tmp122_ == NULL) ? NULL : (_tmp122_ = (vala_ccode_node_unref (_tmp122_), NULL)), _tmp123_);
	_tmp124_ = NULL;
	vala_ccode_function_call_add_argument (filter_free, (ValaCCodeExpression*) (_tmp124_ = vala_ccode_identifier_new ("filter")));
	(_tmp124_ == NULL) ? NULL : (_tmp124_ = (vala_ccode_node_unref (_tmp124_), NULL));
	_tmp125_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_construct), (ValaCCodeNode*) (_tmp125_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) filter_free)));
	(_tmp125_ == NULL) ? NULL : (_tmp125_ = (vala_ccode_node_unref (_tmp125_), NULL));
	_tmp127_ = NULL;
	_tmp126_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_construct), (ValaCCodeNode*) (_tmp127_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp126_ = vala_ccode_identifier_new ("self")))));
	(_tmp127_ == NULL) ? NULL : (_tmp127_ = (vala_ccode_node_unref (_tmp127_), NULL));
	(_tmp126_ == NULL) ? NULL : (_tmp126_ = (vala_ccode_node_unref (_tmp126_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) proxy_construct);
	/* dbus proxy filter function*/
	vala_dbus_client_module_generate_proxy_filter_function (self, iface);
	/* dbus proxy dispose*/
	_tmp128_ = NULL;
	_tmp129_ = NULL;
	proxy_dispose = (_tmp129_ = vala_ccode_function_new (_tmp128_ = g_strconcat (lower_cname, "_dispose", NULL), "void"), _tmp128_ = (g_free (_tmp128_), NULL), _tmp129_);
	_tmp130_ = NULL;
	vala_ccode_function_add_parameter (proxy_dispose, _tmp130_ = vala_ccode_formal_parameter_new ("self", "GObject*"));
	(_tmp130_ == NULL) ? NULL : (_tmp130_ = (vala_ccode_node_unref (_tmp130_), NULL));
	vala_ccode_function_set_modifiers (proxy_dispose, VALA_CCODE_MODIFIERS_STATIC);
	_tmp131_ = NULL;
	vala_ccode_function_set_block (proxy_dispose, _tmp131_ = vala_ccode_block_new ());
	(_tmp131_ == NULL) ? NULL : (_tmp131_ = (vala_ccode_node_unref (_tmp131_), NULL));
	_tmp132_ = NULL;
	_cdecl_ = (_tmp132_ = vala_ccode_declaration_new ("DBusGConnection"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp132_);
	_tmp133_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp133_ = vala_ccode_variable_declarator_new ("*connection", NULL, NULL)));
	(_tmp133_ == NULL) ? NULL : (_tmp133_ = (vala_ccode_node_unref (_tmp133_), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_dispose), (ValaCCodeNode*) _cdecl_);
	/* return if proxy is already disposed*/
	dispose_return_block = vala_ccode_block_new ();
	_tmp134_ = NULL;
	vala_ccode_block_add_statement (dispose_return_block, (ValaCCodeNode*) (_tmp134_ = vala_ccode_return_statement_new (NULL)));
	(_tmp134_ == NULL) ? NULL : (_tmp134_ = (vala_ccode_node_unref (_tmp134_), NULL));
	_tmp139_ = NULL;
	_tmp138_ = NULL;
	_tmp137_ = NULL;
	_tmp136_ = NULL;
	_tmp135_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_dispose), (ValaCCodeNode*) (_tmp139_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp138_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp137_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp135_ = vala_ccode_identifier_new ("self")), _tmp136_ = g_strconcat (cname, "*", NULL))), "disposed")), (ValaCCodeStatement*) dispose_return_block, NULL)));
	(_tmp139_ == NULL) ? NULL : (_tmp139_ = (vala_ccode_node_unref (_tmp139_), NULL));
	(_tmp138_ == NULL) ? NULL : (_tmp138_ = (vala_ccode_node_unref (_tmp138_), NULL));
	(_tmp137_ == NULL) ? NULL : (_tmp137_ = (vala_ccode_node_unref (_tmp137_), NULL));
	_tmp136_ = (g_free (_tmp136_), NULL);
	(_tmp135_ == NULL) ? NULL : (_tmp135_ = (vala_ccode_node_unref (_tmp135_), NULL));
	/* mark proxy as disposed*/
	_tmp146_ = NULL;
	_tmp145_ = NULL;
	_tmp144_ = NULL;
	_tmp143_ = NULL;
	_tmp142_ = NULL;
	_tmp141_ = NULL;
	_tmp140_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_dispose), (ValaCCodeNode*) (_tmp146_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp145_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp143_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp142_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp140_ = vala_ccode_identifier_new ("self")), _tmp141_ = g_strconcat (cname, "*", NULL))), "disposed")), (ValaCCodeExpression*) (_tmp144_ = vala_ccode_constant_new ("TRUE")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp146_ == NULL) ? NULL : (_tmp146_ = (vala_ccode_node_unref (_tmp146_), NULL));
	(_tmp145_ == NULL) ? NULL : (_tmp145_ = (vala_ccode_node_unref (_tmp145_), NULL));
	(_tmp144_ == NULL) ? NULL : (_tmp144_ = (vala_ccode_node_unref (_tmp144_), NULL));
	(_tmp143_ == NULL) ? NULL : (_tmp143_ = (vala_ccode_node_unref (_tmp143_), NULL));
	(_tmp142_ == NULL) ? NULL : (_tmp142_ = (vala_ccode_node_unref (_tmp142_), NULL));
	_tmp141_ = (g_free (_tmp141_), NULL);
	(_tmp140_ == NULL) ? NULL : (_tmp140_ = (vala_ccode_node_unref (_tmp140_), NULL));
	_tmp148_ = NULL;
	_tmp147_ = NULL;
	gconnection = (_tmp148_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp147_ = vala_ccode_identifier_new ("g_object_get"))), (gconnection == NULL) ? NULL : (gconnection = (vala_ccode_node_unref (gconnection), NULL)), _tmp148_);
	(_tmp147_ == NULL) ? NULL : (_tmp147_ = (vala_ccode_node_unref (_tmp147_), NULL));
	_tmp149_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp149_ = vala_ccode_identifier_new ("self")));
	(_tmp149_ == NULL) ? NULL : (_tmp149_ = (vala_ccode_node_unref (_tmp149_), NULL));
	_tmp150_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp150_ = vala_ccode_constant_new ("\"connection\"")));
	(_tmp150_ == NULL) ? NULL : (_tmp150_ = (vala_ccode_node_unref (_tmp150_), NULL));
	_tmp152_ = NULL;
	_tmp151_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp152_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp151_ = vala_ccode_identifier_new ("connection")))));
	(_tmp152_ == NULL) ? NULL : (_tmp152_ = (vala_ccode_node_unref (_tmp152_), NULL));
	(_tmp151_ == NULL) ? NULL : (_tmp151_ = (vala_ccode_node_unref (_tmp151_), NULL));
	_tmp153_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp153_ = vala_ccode_constant_new ("NULL")));
	(_tmp153_ == NULL) ? NULL : (_tmp153_ = (vala_ccode_node_unref (_tmp153_), NULL));
	_tmp154_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_dispose), (ValaCCodeNode*) (_tmp154_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) gconnection)));
	(_tmp154_ == NULL) ? NULL : (_tmp154_ = (vala_ccode_node_unref (_tmp154_), NULL));
	/* remove filter*/
	_tmp156_ = NULL;
	_tmp155_ = NULL;
	filter_call = (_tmp156_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp155_ = vala_ccode_identifier_new ("dbus_connection_remove_filter"))), (filter_call == NULL) ? NULL : (filter_call = (vala_ccode_node_unref (filter_call), NULL)), _tmp156_);
	(_tmp155_ == NULL) ? NULL : (_tmp155_ = (vala_ccode_node_unref (_tmp155_), NULL));
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) raw_connection);
	_tmp158_ = NULL;
	_tmp157_ = NULL;
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) (_tmp158_ = vala_ccode_identifier_new (_tmp157_ = g_strconcat (lower_cname, "_filter", NULL))));
	(_tmp158_ == NULL) ? NULL : (_tmp158_ = (vala_ccode_node_unref (_tmp158_), NULL));
	_tmp157_ = (g_free (_tmp157_), NULL);
	_tmp159_ = NULL;
	vala_ccode_function_call_add_argument (filter_call, (ValaCCodeExpression*) (_tmp159_ = vala_ccode_identifier_new ("self")));
	(_tmp159_ == NULL) ? NULL : (_tmp159_ = (vala_ccode_node_unref (_tmp159_), NULL));
	_tmp160_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_dispose), (ValaCCodeNode*) (_tmp160_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) filter_call)));
	(_tmp160_ == NULL) ? NULL : (_tmp160_ = (vala_ccode_node_unref (_tmp160_), NULL));
	/* chain up*/
	_tmp162_ = NULL;
	_tmp161_ = NULL;
	parent_class = (_tmp162_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp161_ = vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (parent_class == NULL) ? NULL : (parent_class = (vala_ccode_node_unref (parent_class), NULL)), _tmp162_);
	(_tmp161_ == NULL) ? NULL : (_tmp161_ = (vala_ccode_node_unref (_tmp161_), NULL));
	_tmp164_ = NULL;
	_tmp163_ = NULL;
	vala_ccode_function_call_add_argument (parent_class, (ValaCCodeExpression*) (_tmp164_ = vala_ccode_identifier_new (_tmp163_ = g_strconcat (lower_cname, "_parent_class", NULL))));
	(_tmp164_ == NULL) ? NULL : (_tmp164_ = (vala_ccode_node_unref (_tmp164_), NULL));
	_tmp163_ = (g_free (_tmp163_), NULL);
	_tmp166_ = NULL;
	_tmp165_ = NULL;
	chainup = (_tmp166_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp165_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) parent_class, "dispose"))), (chainup == NULL) ? NULL : (chainup = (vala_ccode_node_unref (chainup), NULL)), _tmp166_);
	(_tmp165_ == NULL) ? NULL : (_tmp165_ = (vala_ccode_node_unref (_tmp165_), NULL));
	_tmp167_ = NULL;
	vala_ccode_function_call_add_argument (chainup, (ValaCCodeExpression*) (_tmp167_ = vala_ccode_identifier_new ("self")));
	(_tmp167_ == NULL) ? NULL : (_tmp167_ = (vala_ccode_node_unref (_tmp167_), NULL));
	_tmp168_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_dispose), (ValaCCodeNode*) (_tmp168_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) chainup)));
	(_tmp168_ == NULL) ? NULL : (_tmp168_ = (vala_ccode_node_unref (_tmp168_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) proxy_dispose);
	_tmp169_ = NULL;
	_tmp170_ = NULL;
	proxy_class_init = (_tmp170_ = vala_ccode_function_new (_tmp169_ = g_strconcat (lower_cname, "_class_init", NULL), "void"), _tmp169_ = (g_free (_tmp169_), NULL), _tmp170_);
	_tmp172_ = NULL;
	_tmp171_ = NULL;
	vala_ccode_function_add_parameter (proxy_class_init, _tmp172_ = vala_ccode_formal_parameter_new ("klass", _tmp171_ = g_strconcat (cname, "Class*", NULL)));
	(_tmp172_ == NULL) ? NULL : (_tmp172_ = (vala_ccode_node_unref (_tmp172_), NULL));
	_tmp171_ = (g_free (_tmp171_), NULL);
	vala_ccode_function_set_modifiers (proxy_class_init, VALA_CCODE_MODIFIERS_STATIC);
	_tmp173_ = NULL;
	vala_ccode_function_set_block (proxy_class_init, _tmp173_ = vala_ccode_block_new ());
	(_tmp173_ == NULL) ? NULL : (_tmp173_ = (vala_ccode_node_unref (_tmp173_), NULL));
	_tmp174_ = NULL;
	_tmp175_ = NULL;
	gobject_class = (_tmp175_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp174_ = vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (_tmp174_ == NULL) ? NULL : (_tmp174_ = (vala_ccode_node_unref (_tmp174_), NULL)), _tmp175_);
	_tmp176_ = NULL;
	vala_ccode_function_call_add_argument (gobject_class, (ValaCCodeExpression*) (_tmp176_ = vala_ccode_identifier_new ("klass")));
	(_tmp176_ == NULL) ? NULL : (_tmp176_ = (vala_ccode_node_unref (_tmp176_), NULL));
	_tmp181_ = NULL;
	_tmp180_ = NULL;
	_tmp179_ = NULL;
	_tmp178_ = NULL;
	_tmp177_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_class_init), (ValaCCodeNode*) (_tmp181_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp180_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp177_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) gobject_class, "constructor")), (ValaCCodeExpression*) (_tmp179_ = vala_ccode_identifier_new (_tmp178_ = g_strconcat (lower_cname, "_construct", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp181_ == NULL) ? NULL : (_tmp181_ = (vala_ccode_node_unref (_tmp181_), NULL));
	(_tmp180_ == NULL) ? NULL : (_tmp180_ = (vala_ccode_node_unref (_tmp180_), NULL));
	(_tmp179_ == NULL) ? NULL : (_tmp179_ = (vala_ccode_node_unref (_tmp179_), NULL));
	_tmp178_ = (g_free (_tmp178_), NULL);
	(_tmp177_ == NULL) ? NULL : (_tmp177_ = (vala_ccode_node_unref (_tmp177_), NULL));
	_tmp186_ = NULL;
	_tmp185_ = NULL;
	_tmp184_ = NULL;
	_tmp183_ = NULL;
	_tmp182_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_class_init), (ValaCCodeNode*) (_tmp186_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp185_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp182_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) gobject_class, "dispose")), (ValaCCodeExpression*) (_tmp184_ = vala_ccode_identifier_new (_tmp183_ = g_strconcat (lower_cname, "_dispose", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp186_ == NULL) ? NULL : (_tmp186_ = (vala_ccode_node_unref (_tmp186_), NULL));
	(_tmp185_ == NULL) ? NULL : (_tmp185_ = (vala_ccode_node_unref (_tmp185_), NULL));
	(_tmp184_ == NULL) ? NULL : (_tmp184_ = (vala_ccode_node_unref (_tmp184_), NULL));
	_tmp183_ = (g_free (_tmp183_), NULL);
	(_tmp182_ == NULL) ? NULL : (_tmp182_ = (vala_ccode_node_unref (_tmp182_), NULL));
	_tmp191_ = NULL;
	_tmp190_ = NULL;
	_tmp189_ = NULL;
	_tmp188_ = NULL;
	_tmp187_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_class_init), (ValaCCodeNode*) (_tmp191_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp190_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp187_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) gobject_class, "get_property")), (ValaCCodeExpression*) (_tmp189_ = vala_ccode_identifier_new (_tmp188_ = g_strconcat (lower_cname, "_get_property", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp191_ == NULL) ? NULL : (_tmp191_ = (vala_ccode_node_unref (_tmp191_), NULL));
	(_tmp190_ == NULL) ? NULL : (_tmp190_ = (vala_ccode_node_unref (_tmp190_), NULL));
	(_tmp189_ == NULL) ? NULL : (_tmp189_ = (vala_ccode_node_unref (_tmp189_), NULL));
	_tmp188_ = (g_free (_tmp188_), NULL);
	(_tmp187_ == NULL) ? NULL : (_tmp187_ = (vala_ccode_node_unref (_tmp187_), NULL));
	_tmp196_ = NULL;
	_tmp195_ = NULL;
	_tmp194_ = NULL;
	_tmp193_ = NULL;
	_tmp192_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_class_init), (ValaCCodeNode*) (_tmp196_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp195_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp192_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) gobject_class, "set_property")), (ValaCCodeExpression*) (_tmp194_ = vala_ccode_identifier_new (_tmp193_ = g_strconcat (lower_cname, "_set_property", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp196_ == NULL) ? NULL : (_tmp196_ = (vala_ccode_node_unref (_tmp196_), NULL));
	(_tmp195_ == NULL) ? NULL : (_tmp195_ = (vala_ccode_node_unref (_tmp195_), NULL));
	(_tmp194_ == NULL) ? NULL : (_tmp194_ = (vala_ccode_node_unref (_tmp194_), NULL));
	_tmp193_ = (g_free (_tmp193_), NULL);
	(_tmp192_ == NULL) ? NULL : (_tmp192_ = (vala_ccode_node_unref (_tmp192_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) proxy_class_init);
	_tmp197_ = NULL;
	((ValaCCodeBaseModule*) self)->prop_enum = (_tmp197_ = vala_ccode_enum_new (NULL), (((ValaCCodeBaseModule*) self)->prop_enum == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->prop_enum = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->prop_enum), NULL)), _tmp197_);
	_tmp200_ = NULL;
	_tmp199_ = NULL;
	_tmp198_ = NULL;
	vala_ccode_enum_add_value (((ValaCCodeBaseModule*) self)->prop_enum, _tmp200_ = vala_ccode_enum_value_new (_tmp199_ = g_strdup_printf ("%s_DUMMY_PROPERTY", _tmp198_ = g_utf8_strup (lower_cname, -1)), NULL));
	(_tmp200_ == NULL) ? NULL : (_tmp200_ = (vala_ccode_node_unref (_tmp200_), NULL));
	_tmp199_ = (g_free (_tmp199_), NULL);
	_tmp198_ = (g_free (_tmp198_), NULL);
	{
		GeeList* _tmp201_;
		GeeIterator* _tmp202_;
		GeeIterator* _prop_it;
		_tmp201_ = NULL;
		_tmp202_ = NULL;
		_prop_it = (_tmp202_ = gee_iterable_iterator ((GeeIterable*) (_tmp201_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface))), (_tmp201_ == NULL) ? NULL : (_tmp201_ = (gee_collection_object_unref (_tmp201_), NULL)), _tmp202_);
		while (TRUE) {
			ValaProperty* prop;
			ValaCCodeIdentifier* _tmp203_;
			ValaCCodeFunctionCall* _tmp204_;
			ValaCCodeFunctionCall* cinst;
			ValaCCodeConstant* _tmp206_;
			char* _tmp205_;
			ValaCCodeConstant* _tmp207_;
			ValaCCodeExpressionStatement* _tmp208_;
			ValaCCodeEnumValue* _tmp210_;
			char* _tmp209_;
			if (!gee_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			if (!vala_property_get_is_abstract (prop)) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (VALA_IS_ARRAY_TYPE (vala_property_get_property_type (prop))) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			_tmp203_ = NULL;
			_tmp204_ = NULL;
			cinst = (_tmp204_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp203_ = vala_ccode_identifier_new ("g_object_class_override_property"))), (_tmp203_ == NULL) ? NULL : (_tmp203_ = (vala_ccode_node_unref (_tmp203_), NULL)), _tmp204_);
			vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) gobject_class);
			_tmp206_ = NULL;
			_tmp205_ = NULL;
			vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp206_ = vala_ccode_constant_new (_tmp205_ = vala_property_get_upper_case_cname (prop))));
			(_tmp206_ == NULL) ? NULL : (_tmp206_ = (vala_ccode_node_unref (_tmp206_), NULL));
			_tmp205_ = (g_free (_tmp205_), NULL);
			_tmp207_ = NULL;
			vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp207_ = vala_property_get_canonical_cconstant (prop)));
			(_tmp207_ == NULL) ? NULL : (_tmp207_ = (vala_ccode_node_unref (_tmp207_), NULL));
			_tmp208_ = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (proxy_class_init), (ValaCCodeNode*) (_tmp208_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
			(_tmp208_ == NULL) ? NULL : (_tmp208_ = (vala_ccode_node_unref (_tmp208_), NULL));
			_tmp210_ = NULL;
			_tmp209_ = NULL;
			vala_ccode_enum_add_value (((ValaCCodeBaseModule*) self)->prop_enum, _tmp210_ = vala_ccode_enum_value_new (_tmp209_ = vala_property_get_upper_case_cname (prop), NULL));
			(_tmp210_ == NULL) ? NULL : (_tmp210_ = (vala_ccode_node_unref (_tmp210_), NULL));
			_tmp209_ = (g_free (_tmp209_), NULL);
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			(cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->prop_enum);
	_tmp211_ = NULL;
	_tmp212_ = NULL;
	proxy_instance_init = (_tmp212_ = vala_ccode_function_new (_tmp211_ = g_strconcat (lower_cname, "_init", NULL), "void"), _tmp211_ = (g_free (_tmp211_), NULL), _tmp212_);
	_tmp214_ = NULL;
	_tmp213_ = NULL;
	vala_ccode_function_add_parameter (proxy_instance_init, _tmp214_ = vala_ccode_formal_parameter_new ("self", _tmp213_ = g_strconcat (cname, "*", NULL)));
	(_tmp214_ == NULL) ? NULL : (_tmp214_ = (vala_ccode_node_unref (_tmp214_), NULL));
	_tmp213_ = (g_free (_tmp213_), NULL);
	vala_ccode_function_set_modifiers (proxy_instance_init, VALA_CCODE_MODIFIERS_STATIC);
	_tmp215_ = NULL;
	vala_ccode_function_set_block (proxy_instance_init, _tmp215_ = vala_ccode_block_new ());
	(_tmp215_ == NULL) ? NULL : (_tmp215_ = (vala_ccode_node_unref (_tmp215_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) proxy_instance_init);
	_tmp216_ = NULL;
	_tmp217_ = NULL;
	proxy_iface_init = (_tmp217_ = vala_ccode_function_new (_tmp216_ = g_strconcat (lower_cname, "_interface_init", NULL), "void"), _tmp216_ = (g_free (_tmp216_), NULL), _tmp217_);
	_tmp220_ = NULL;
	_tmp219_ = NULL;
	_tmp218_ = NULL;
	vala_ccode_function_add_parameter (proxy_iface_init, _tmp220_ = vala_ccode_formal_parameter_new ("iface", _tmp219_ = g_strconcat (_tmp218_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), "Iface*", NULL)));
	(_tmp220_ == NULL) ? NULL : (_tmp220_ = (vala_ccode_node_unref (_tmp220_), NULL));
	_tmp219_ = (g_free (_tmp219_), NULL);
	_tmp218_ = (g_free (_tmp218_), NULL);
	iface_block = vala_ccode_block_new ();
	{
		GeeList* _tmp221_;
		GeeIterator* _tmp222_;
		GeeIterator* _m_it;
		_tmp221_ = NULL;
		_tmp222_ = NULL;
		_m_it = (_tmp222_ = gee_iterable_iterator ((GeeIterable*) (_tmp221_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface))), (_tmp221_ == NULL) ? NULL : (_tmp221_ = (gee_collection_object_unref (_tmp221_), NULL)), _tmp222_);
		while (TRUE) {
			ValaMethod* m;
			ValaCCodeIdentifier* _tmp223_;
			ValaCCodeMemberAccess* _tmp224_;
			ValaCCodeMemberAccess* vfunc_entry;
			ValaCCodeExpressionStatement* _tmp228_;
			ValaCCodeAssignment* _tmp227_;
			ValaCCodeIdentifier* _tmp226_;
			char* _tmp225_;
			if (!gee_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) gee_iterator_get (_m_it);
			_tmp223_ = NULL;
			_tmp224_ = NULL;
			vfunc_entry = (_tmp224_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp223_ = vala_ccode_identifier_new ("iface")), vala_method_get_vfunc_name (m)), (_tmp223_ == NULL) ? NULL : (_tmp223_ = (vala_ccode_node_unref (_tmp223_), NULL)), _tmp224_);
			_tmp228_ = NULL;
			_tmp227_ = NULL;
			_tmp226_ = NULL;
			_tmp225_ = NULL;
			vala_ccode_block_add_statement (iface_block, (ValaCCodeNode*) (_tmp228_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp227_ = vala_ccode_assignment_new ((ValaCCodeExpression*) vfunc_entry, (ValaCCodeExpression*) (_tmp226_ = vala_ccode_identifier_new (_tmp225_ = vala_dbus_client_module_generate_dbus_proxy_method (self, iface, m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp228_ == NULL) ? NULL : (_tmp228_ = (vala_ccode_node_unref (_tmp228_), NULL));
			(_tmp227_ == NULL) ? NULL : (_tmp227_ = (vala_ccode_node_unref (_tmp227_), NULL));
			(_tmp226_ == NULL) ? NULL : (_tmp226_ = (vala_ccode_node_unref (_tmp226_), NULL));
			_tmp225_ = (g_free (_tmp225_), NULL);
			if (vala_method_get_coroutine (m)) {
				ValaCCodeMemberAccess* _tmp231_;
				char* _tmp230_;
				ValaCCodeIdentifier* _tmp229_;
				ValaCCodeExpressionStatement* _tmp235_;
				ValaCCodeAssignment* _tmp234_;
				ValaCCodeIdentifier* _tmp233_;
				char* _tmp232_;
				ValaCCodeMemberAccess* _tmp238_;
				char* _tmp237_;
				ValaCCodeIdentifier* _tmp236_;
				ValaCCodeExpressionStatement* _tmp242_;
				ValaCCodeAssignment* _tmp241_;
				ValaCCodeIdentifier* _tmp240_;
				char* _tmp239_;
				_tmp231_ = NULL;
				_tmp230_ = NULL;
				_tmp229_ = NULL;
				vfunc_entry = (_tmp231_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp229_ = vala_ccode_identifier_new ("iface")), _tmp230_ = g_strconcat (vala_method_get_vfunc_name (m), "_async", NULL)), (vfunc_entry == NULL) ? NULL : (vfunc_entry = (vala_ccode_node_unref (vfunc_entry), NULL)), _tmp231_);
				_tmp230_ = (g_free (_tmp230_), NULL);
				(_tmp229_ == NULL) ? NULL : (_tmp229_ = (vala_ccode_node_unref (_tmp229_), NULL));
				_tmp235_ = NULL;
				_tmp234_ = NULL;
				_tmp233_ = NULL;
				_tmp232_ = NULL;
				vala_ccode_block_add_statement (iface_block, (ValaCCodeNode*) (_tmp235_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp234_ = vala_ccode_assignment_new ((ValaCCodeExpression*) vfunc_entry, (ValaCCodeExpression*) (_tmp233_ = vala_ccode_identifier_new (_tmp232_ = vala_dbus_client_module_generate_async_dbus_proxy_method (self, iface, m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp235_ == NULL) ? NULL : (_tmp235_ = (vala_ccode_node_unref (_tmp235_), NULL));
				(_tmp234_ == NULL) ? NULL : (_tmp234_ = (vala_ccode_node_unref (_tmp234_), NULL));
				(_tmp233_ == NULL) ? NULL : (_tmp233_ = (vala_ccode_node_unref (_tmp233_), NULL));
				_tmp232_ = (g_free (_tmp232_), NULL);
				_tmp238_ = NULL;
				_tmp237_ = NULL;
				_tmp236_ = NULL;
				vfunc_entry = (_tmp238_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp236_ = vala_ccode_identifier_new ("iface")), _tmp237_ = g_strconcat (vala_method_get_vfunc_name (m), "_finish", NULL)), (vfunc_entry == NULL) ? NULL : (vfunc_entry = (vala_ccode_node_unref (vfunc_entry), NULL)), _tmp238_);
				_tmp237_ = (g_free (_tmp237_), NULL);
				(_tmp236_ == NULL) ? NULL : (_tmp236_ = (vala_ccode_node_unref (_tmp236_), NULL));
				_tmp242_ = NULL;
				_tmp241_ = NULL;
				_tmp240_ = NULL;
				_tmp239_ = NULL;
				vala_ccode_block_add_statement (iface_block, (ValaCCodeNode*) (_tmp242_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp241_ = vala_ccode_assignment_new ((ValaCCodeExpression*) vfunc_entry, (ValaCCodeExpression*) (_tmp240_ = vala_ccode_identifier_new (_tmp239_ = vala_dbus_client_module_generate_finish_dbus_proxy_method (self, iface, m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp242_ == NULL) ? NULL : (_tmp242_ = (vala_ccode_node_unref (_tmp242_), NULL));
				(_tmp241_ == NULL) ? NULL : (_tmp241_ = (vala_ccode_node_unref (_tmp241_), NULL));
				(_tmp240_ == NULL) ? NULL : (_tmp240_ = (vala_ccode_node_unref (_tmp240_), NULL));
				_tmp239_ = (g_free (_tmp239_), NULL);
			}
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(vfunc_entry == NULL) ? NULL : (vfunc_entry = (vala_ccode_node_unref (vfunc_entry), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	{
		GeeList* _tmp243_;
		GeeIterator* _tmp244_;
		GeeIterator* _prop_it;
		_tmp243_ = NULL;
		_tmp244_ = NULL;
		_prop_it = (_tmp244_ = gee_iterable_iterator ((GeeIterable*) (_tmp243_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface))), (_tmp243_ == NULL) ? NULL : (_tmp243_ = (gee_collection_object_unref (_tmp243_), NULL)), _tmp244_);
		while (TRUE) {
			ValaProperty* prop;
			if (!gee_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			if (vala_property_get_get_accessor (prop) != NULL) {
				char* _tmp246_;
				ValaCCodeIdentifier* _tmp245_;
				ValaCCodeMemberAccess* _tmp247_;
				ValaCCodeMemberAccess* vfunc_entry;
				ValaCCodeExpressionStatement* _tmp251_;
				ValaCCodeAssignment* _tmp250_;
				ValaCCodeIdentifier* _tmp249_;
				char* _tmp248_;
				_tmp246_ = NULL;
				_tmp245_ = NULL;
				_tmp247_ = NULL;
				vfunc_entry = (_tmp247_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp245_ = vala_ccode_identifier_new ("iface")), _tmp246_ = g_strconcat ("get_", vala_symbol_get_name ((ValaSymbol*) prop), NULL)), _tmp246_ = (g_free (_tmp246_), NULL), (_tmp245_ == NULL) ? NULL : (_tmp245_ = (vala_ccode_node_unref (_tmp245_), NULL)), _tmp247_);
				_tmp251_ = NULL;
				_tmp250_ = NULL;
				_tmp249_ = NULL;
				_tmp248_ = NULL;
				vala_ccode_block_add_statement (iface_block, (ValaCCodeNode*) (_tmp251_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp250_ = vala_ccode_assignment_new ((ValaCCodeExpression*) vfunc_entry, (ValaCCodeExpression*) (_tmp249_ = vala_ccode_identifier_new (_tmp248_ = vala_dbus_client_module_generate_dbus_proxy_property_get (self, iface, prop))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp251_ == NULL) ? NULL : (_tmp251_ = (vala_ccode_node_unref (_tmp251_), NULL));
				(_tmp250_ == NULL) ? NULL : (_tmp250_ = (vala_ccode_node_unref (_tmp250_), NULL));
				(_tmp249_ == NULL) ? NULL : (_tmp249_ = (vala_ccode_node_unref (_tmp249_), NULL));
				_tmp248_ = (g_free (_tmp248_), NULL);
				(vfunc_entry == NULL) ? NULL : (vfunc_entry = (vala_ccode_node_unref (vfunc_entry), NULL));
			}
			if (vala_property_get_set_accessor (prop) != NULL) {
				char* _tmp253_;
				ValaCCodeIdentifier* _tmp252_;
				ValaCCodeMemberAccess* _tmp254_;
				ValaCCodeMemberAccess* vfunc_entry;
				ValaCCodeExpressionStatement* _tmp258_;
				ValaCCodeAssignment* _tmp257_;
				ValaCCodeIdentifier* _tmp256_;
				char* _tmp255_;
				_tmp253_ = NULL;
				_tmp252_ = NULL;
				_tmp254_ = NULL;
				vfunc_entry = (_tmp254_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp252_ = vala_ccode_identifier_new ("iface")), _tmp253_ = g_strconcat ("set_", vala_symbol_get_name ((ValaSymbol*) prop), NULL)), _tmp253_ = (g_free (_tmp253_), NULL), (_tmp252_ == NULL) ? NULL : (_tmp252_ = (vala_ccode_node_unref (_tmp252_), NULL)), _tmp254_);
				_tmp258_ = NULL;
				_tmp257_ = NULL;
				_tmp256_ = NULL;
				_tmp255_ = NULL;
				vala_ccode_block_add_statement (iface_block, (ValaCCodeNode*) (_tmp258_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp257_ = vala_ccode_assignment_new ((ValaCCodeExpression*) vfunc_entry, (ValaCCodeExpression*) (_tmp256_ = vala_ccode_identifier_new (_tmp255_ = vala_dbus_client_module_generate_dbus_proxy_property_set (self, iface, prop))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp258_ == NULL) ? NULL : (_tmp258_ = (vala_ccode_node_unref (_tmp258_), NULL));
				(_tmp257_ == NULL) ? NULL : (_tmp257_ = (vala_ccode_node_unref (_tmp257_), NULL));
				(_tmp256_ == NULL) ? NULL : (_tmp256_ = (vala_ccode_node_unref (_tmp256_), NULL));
				_tmp255_ = (g_free (_tmp255_), NULL);
				(vfunc_entry == NULL) ? NULL : (vfunc_entry = (vala_ccode_node_unref (vfunc_entry), NULL));
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	vala_ccode_function_set_modifiers (proxy_iface_init, VALA_CCODE_MODIFIERS_STATIC);
	_tmp259_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp259_ = vala_ccode_function_copy (proxy_iface_init)));
	(_tmp259_ == NULL) ? NULL : (_tmp259_ = (vala_ccode_node_unref (_tmp259_), NULL));
	vala_ccode_function_set_block (proxy_iface_init, iface_block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) proxy_iface_init);
	/* dbus proxy get/set_property stubs
	 TODO add actual implementation*/
	_tmp260_ = NULL;
	_tmp261_ = NULL;
	get_prop = (_tmp261_ = vala_ccode_function_new (_tmp260_ = g_strdup_printf ("%s_get_property", lower_cname), "void"), _tmp260_ = (g_free (_tmp260_), NULL), _tmp261_);
	vala_ccode_function_set_modifiers (get_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp262_ = NULL;
	vala_ccode_function_add_parameter (get_prop, _tmp262_ = vala_ccode_formal_parameter_new ("object", "GObject *"));
	(_tmp262_ == NULL) ? NULL : (_tmp262_ = (vala_ccode_node_unref (_tmp262_), NULL));
	_tmp263_ = NULL;
	vala_ccode_function_add_parameter (get_prop, _tmp263_ = vala_ccode_formal_parameter_new ("property_id", "guint"));
	(_tmp263_ == NULL) ? NULL : (_tmp263_ = (vala_ccode_node_unref (_tmp263_), NULL));
	_tmp264_ = NULL;
	vala_ccode_function_add_parameter (get_prop, _tmp264_ = vala_ccode_formal_parameter_new ("value", "GValue *"));
	(_tmp264_ == NULL) ? NULL : (_tmp264_ = (vala_ccode_node_unref (_tmp264_), NULL));
	_tmp265_ = NULL;
	vala_ccode_function_add_parameter (get_prop, _tmp265_ = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *"));
	(_tmp265_ == NULL) ? NULL : (_tmp265_ = (vala_ccode_node_unref (_tmp265_), NULL));
	_tmp266_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp266_ = vala_ccode_function_copy (get_prop)));
	(_tmp266_ == NULL) ? NULL : (_tmp266_ = (vala_ccode_node_unref (_tmp266_), NULL));
	_tmp267_ = NULL;
	vala_ccode_function_set_block (get_prop, _tmp267_ = vala_ccode_block_new ());
	(_tmp267_ == NULL) ? NULL : (_tmp267_ = (vala_ccode_node_unref (_tmp267_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) get_prop);
	_tmp268_ = NULL;
	_tmp269_ = NULL;
	set_prop = (_tmp269_ = vala_ccode_function_new (_tmp268_ = g_strdup_printf ("%s_set_property", lower_cname), "void"), _tmp268_ = (g_free (_tmp268_), NULL), _tmp269_);
	vala_ccode_function_set_modifiers (set_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp270_ = NULL;
	vala_ccode_function_add_parameter (set_prop, _tmp270_ = vala_ccode_formal_parameter_new ("object", "GObject *"));
	(_tmp270_ == NULL) ? NULL : (_tmp270_ = (vala_ccode_node_unref (_tmp270_), NULL));
	_tmp271_ = NULL;
	vala_ccode_function_add_parameter (set_prop, _tmp271_ = vala_ccode_formal_parameter_new ("property_id", "guint"));
	(_tmp271_ == NULL) ? NULL : (_tmp271_ = (vala_ccode_node_unref (_tmp271_), NULL));
	_tmp272_ = NULL;
	vala_ccode_function_add_parameter (set_prop, _tmp272_ = vala_ccode_formal_parameter_new ("value", "const GValue *"));
	(_tmp272_ == NULL) ? NULL : (_tmp272_ = (vala_ccode_node_unref (_tmp272_), NULL));
	_tmp273_ = NULL;
	vala_ccode_function_add_parameter (set_prop, _tmp273_ = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *"));
	(_tmp273_ == NULL) ? NULL : (_tmp273_ = (vala_ccode_node_unref (_tmp273_), NULL));
	_tmp274_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp274_ = vala_ccode_function_copy (set_prop)));
	(_tmp274_ == NULL) ? NULL : (_tmp274_ = (vala_ccode_node_unref (_tmp274_), NULL));
	_tmp275_ = NULL;
	vala_ccode_function_set_block (set_prop, _tmp275_ = vala_ccode_block_new ());
	(_tmp275_ == NULL) ? NULL : (_tmp275_ = (vala_ccode_node_unref (_tmp275_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) set_prop);
	(dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL));
	dbus_iface_name = (g_free (dbus_iface_name), NULL);
	cname = (g_free (cname), NULL);
	lower_cname = (g_free (lower_cname), NULL);
	(instance_struct == NULL) ? NULL : (instance_struct = (vala_ccode_node_unref (instance_struct), NULL));
	(implement == NULL) ? NULL : (implement = (vala_ccode_node_unref (implement), NULL));
	(define_type == NULL) ? NULL : (define_type = (vala_ccode_node_unref (define_type), NULL));
	(proxy_new == NULL) ? NULL : (proxy_new = (vala_ccode_node_unref (proxy_new), NULL));
	(new_block == NULL) ? NULL : (new_block = (vala_ccode_node_unref (new_block), NULL));
	(new_call == NULL) ? NULL : (new_call = (vala_ccode_node_unref (new_call), NULL));
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(proxy_construct == NULL) ? NULL : (proxy_construct = (vala_ccode_node_unref (proxy_construct), NULL));
	(parent_class == NULL) ? NULL : (parent_class = (vala_ccode_node_unref (parent_class), NULL));
	(chainup == NULL) ? NULL : (chainup = (vala_ccode_node_unref (chainup), NULL));
	(gconnection == NULL) ? NULL : (gconnection = (vala_ccode_node_unref (gconnection), NULL));
	(path == NULL) ? NULL : (path = (vala_ccode_node_unref (path), NULL));
	(raw_connection == NULL) ? NULL : (raw_connection = (vala_ccode_node_unref (raw_connection), NULL));
	(filter_call == NULL) ? NULL : (filter_call = (vala_ccode_node_unref (filter_call), NULL));
	(filter_printf == NULL) ? NULL : (filter_printf = (vala_ccode_node_unref (filter_printf), NULL));
	(match_call == NULL) ? NULL : (match_call = (vala_ccode_node_unref (match_call), NULL));
	(connection_free == NULL) ? NULL : (connection_free = (vala_ccode_node_unref (connection_free), NULL));
	(path_free == NULL) ? NULL : (path_free = (vala_ccode_node_unref (path_free), NULL));
	(filter_free == NULL) ? NULL : (filter_free = (vala_ccode_node_unref (filter_free), NULL));
	(proxy_dispose == NULL) ? NULL : (proxy_dispose = (vala_ccode_node_unref (proxy_dispose), NULL));
	(dispose_return_block == NULL) ? NULL : (dispose_return_block = (vala_ccode_node_unref (dispose_return_block), NULL));
	(proxy_class_init == NULL) ? NULL : (proxy_class_init = (vala_ccode_node_unref (proxy_class_init), NULL));
	(gobject_class == NULL) ? NULL : (gobject_class = (vala_ccode_node_unref (gobject_class), NULL));
	(proxy_instance_init == NULL) ? NULL : (proxy_instance_init = (vala_ccode_node_unref (proxy_instance_init), NULL));
	(proxy_iface_init == NULL) ? NULL : (proxy_iface_init = (vala_ccode_node_unref (proxy_iface_init), NULL));
	(iface_block == NULL) ? NULL : (iface_block = (vala_ccode_node_unref (iface_block), NULL));
	(get_prop == NULL) ? NULL : (get_prop = (vala_ccode_node_unref (get_prop), NULL));
	(set_prop == NULL) ? NULL : (set_prop = (vala_ccode_node_unref (set_prop), NULL));
}


static ValaTypeRegisterFunction* vala_dbus_client_module_real_create_interface_register_function (ValaGTypeModule* base, ValaInterface* iface) {
	ValaDBusClientModule * self;
	ValaTypeRegisterFunction* result;
	ValaAttribute* dbus;
	char* dbus_iface_name;
	self = (ValaDBusClientModule*) base;
	g_return_val_if_fail (iface != NULL, NULL);
	dbus = vala_code_node_get_attribute ((ValaCodeNode*) iface, "DBus");
	if (dbus == NULL) {
		result = (ValaTypeRegisterFunction*) vala_interface_register_function_new (iface, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
		(dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL));
		return result;
	}
	dbus_iface_name = vala_attribute_get_string (dbus, "name");
	if (dbus_iface_name == NULL) {
		result = (ValaTypeRegisterFunction*) vala_interface_register_function_new (iface, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
		(dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL));
		dbus_iface_name = (g_free (dbus_iface_name), NULL);
		return result;
	}
	result = (ValaTypeRegisterFunction*) vala_dbus_interface_register_function_new (iface, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
	(dbus == NULL) ? NULL : (dbus = (vala_code_node_unref (dbus), NULL));
	dbus_iface_name = (g_free (dbus_iface_name), NULL);
	return result;
}


static void vala_dbus_client_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr) {
	ValaDBusClientModule * self;
	ValaMethodType* _tmp1_;
	ValaDataType* _tmp0_;
	ValaMethodType* mtype;
	gboolean _tmp2_;
	GeeList* args;
	ValaExpression* _tmp4_;
	ValaExpression* connection;
	ValaExpression* bus_name;
	ValaExpression* object_path;
	ValaExpression* interface_name;
	ValaExpression* type;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeFunctionCall* _tmp6_;
	ValaCCodeFunctionCall* quark_call;
	ValaCCodeConstant* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeFunctionCall* _tmp9_;
	ValaCCodeFunctionCall* qdata_call;
	ValaCCodeCastExpression* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeFunctionCall* get_type_call;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeFunctionCall* _tmp13_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeConstant* _tmp14_;
	ValaCCodeConstant* _tmp15_;
	ValaCCodeConstant* _tmp16_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	self = (ValaDBusClientModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	mtype = (_tmp1_ = (_tmp0_ = vala_expression_get_value_type (vala_method_call_get_call (expr)), VALA_IS_METHOD_TYPE (_tmp0_) ? ((ValaMethodType*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (mtype == NULL) {
		_tmp2_ = TRUE;
	} else {
		char* _tmp3_;
		_tmp3_ = NULL;
		_tmp2_ = _vala_strcmp0 (_tmp3_ = vala_method_get_cname (vala_method_type_get_method_symbol (mtype)), "dbus_g_proxy_new_from_type") != 0;
		_tmp3_ = (g_free (_tmp3_), NULL);
	}
	if (_tmp2_) {
		VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->visit_method_call ((ValaCCodeModule*) VALA_DBUS_MODULE (self), expr);
		(mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL));
		return;
	}
	args = vala_method_call_get_argument_list (expr);
	_tmp4_ = NULL;
	connection = (_tmp4_ = vala_member_access_get_inner (VALA_MEMBER_ACCESS (vala_method_call_get_call (expr))), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
	bus_name = (ValaExpression*) gee_list_get (args, 0);
	object_path = (ValaExpression*) gee_list_get (args, 1);
	interface_name = (ValaExpression*) gee_list_get (args, 2);
	type = (ValaExpression*) gee_list_get (args, 3);
	_tmp5_ = NULL;
	_tmp6_ = NULL;
	quark_call = (_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("g_quark_from_string"))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), _tmp6_);
	_tmp7_ = NULL;
	vala_ccode_function_call_add_argument (quark_call, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_constant_new ("\"ValaDBusInterfaceProxyType\"")));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp8_ = NULL;
	_tmp9_ = NULL;
	qdata_call = (_tmp9_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("g_type_get_qdata"))), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), _tmp9_);
	vala_code_node_accept ((ValaCodeNode*) type, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_function_call_add_argument (qdata_call, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) type)));
	vala_ccode_function_call_add_argument (qdata_call, (ValaCCodeExpression*) quark_call);
	_tmp10_ = NULL;
	_tmp11_ = NULL;
	get_type_call = (_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) qdata_call, "GType (*)(void)"))), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), _tmp11_);
	_tmp12_ = NULL;
	_tmp13_ = NULL;
	ccall = (_tmp13_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("g_object_new"))), (_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL)), _tmp13_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) get_type_call);
	_tmp14_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_constant_new ("\"connection\"")));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	vala_code_node_accept ((ValaCodeNode*) connection, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) connection)));
	_tmp15_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_constant_new ("\"name\"")));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	vala_code_node_accept ((ValaCodeNode*) bus_name, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) bus_name)));
	_tmp16_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp16_ = vala_ccode_constant_new ("\"path\"")));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	vala_code_node_accept ((ValaCodeNode*) object_path, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) object_path)));
	_tmp17_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_constant_new ("\"interface\"")));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	vala_code_node_accept ((ValaCodeNode*) interface_name, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) interface_name)));
	_tmp18_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_constant_new ("NULL")));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
	(mtype == NULL) ? NULL : (mtype = (vala_code_node_unref (mtype), NULL));
	(args == NULL) ? NULL : (args = (gee_collection_object_unref (args), NULL));
	(connection == NULL) ? NULL : (connection = (vala_code_node_unref (connection), NULL));
	(bus_name == NULL) ? NULL : (bus_name = (vala_code_node_unref (bus_name), NULL));
	(object_path == NULL) ? NULL : (object_path = (vala_code_node_unref (object_path), NULL));
	(interface_name == NULL) ? NULL : (interface_name = (vala_code_node_unref (interface_name), NULL));
	(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
	(quark_call == NULL) ? NULL : (quark_call = (vala_ccode_node_unref (quark_call), NULL));
	(qdata_call == NULL) ? NULL : (qdata_call = (vala_ccode_node_unref (qdata_call), NULL));
	(get_type_call == NULL) ? NULL : (get_type_call = (vala_ccode_node_unref (get_type_call), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_dbus_client_module_generate_proxy_filter_function (ValaDBusClientModule* self, ValaInterface* iface) {
	char* _tmp0_;
	char* _tmp1_;
	char* lower_cname;
	char* _tmp2_;
	ValaCCodeFunction* _tmp3_;
	ValaCCodeFunction* proxy_filter;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeFormalParameter* _tmp5_;
	ValaCCodeFormalParameter* _tmp6_;
	ValaCCodeBlock* filter_block;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeFunctionCall* _tmp8_;
	ValaCCodeFunctionCall* path;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeBlock* object_filter_block;
	ValaCCodeIfStatement* _tmp13_;
	ValaCCodeReturnStatement* _tmp15_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeFunction* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	lower_cname = (_tmp1_ = g_strconcat (_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), "dbus_proxy", NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	proxy_filter = (_tmp3_ = vala_ccode_function_new (_tmp2_ = g_strconcat (lower_cname, "_filter", NULL), "DBusHandlerResult"), _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_);
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (proxy_filter, _tmp4_ = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_add_parameter (proxy_filter, _tmp5_ = vala_ccode_formal_parameter_new ("message", "DBusMessage*"));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (proxy_filter, _tmp6_ = vala_ccode_formal_parameter_new ("user_data", "void*"));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	filter_block = vala_ccode_block_new ();
	/* only handle signals concering the object path*/
	_tmp7_ = NULL;
	_tmp8_ = NULL;
	path = (_tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("dbus_g_proxy_get_path"))), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL)), _tmp8_);
	_tmp9_ = NULL;
	vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("user_data")));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp10_ = NULL;
	_tmp11_ = NULL;
	ccheck = (_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("dbus_message_has_path"))), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), _tmp11_);
	_tmp12_ = NULL;
	vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("message")));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) path);
	object_filter_block = vala_ccode_block_new ();
	_tmp13_ = NULL;
	vala_ccode_block_add_statement (filter_block, (ValaCCodeNode*) (_tmp13_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccheck, (ValaCCodeStatement*) object_filter_block, NULL)));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	vala_dbus_client_module_handle_signals (self, iface, object_filter_block);
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	vala_ccode_block_add_statement (filter_block, (ValaCCodeNode*) (_tmp15_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("DBUS_HANDLER_RESULT_NOT_YET_HANDLED")))));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	_tmp16_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp16_ = vala_ccode_function_copy (proxy_filter)));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	vala_ccode_function_set_block (proxy_filter, filter_block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) proxy_filter);
	lower_cname = (g_free (lower_cname), NULL);
	(proxy_filter == NULL) ? NULL : (proxy_filter = (vala_ccode_node_unref (proxy_filter), NULL));
	(filter_block == NULL) ? NULL : (filter_block = (vala_ccode_node_unref (filter_block), NULL));
	(path == NULL) ? NULL : (path = (vala_ccode_node_unref (path), NULL));
	(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
	(object_filter_block == NULL) ? NULL : (object_filter_block = (vala_ccode_node_unref (object_filter_block), NULL));
}


static char* vala_dbus_client_module_generate_dbus_signal_handler (ValaDBusClientModule* self, ValaSignal* sig, ValaObjectTypeSymbol* sym) {
	char* result;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	char* wrapper_name;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp5_;
	char* _tmp4_;
	char* _tmp3_;
	ValaCCodeFormalParameter* _tmp6_;
	ValaCCodeFormalParameter* _tmp7_;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeDeclaration* _tmp8_;
	ValaCCodeVariableDeclarator* _tmp9_;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeFunctionCall* message_signature;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* signature_check;
	ValaCCodeBlock* signature_error_block;
	ValaCCodeReturnStatement* _tmp15_;
	ValaCCodeIfStatement* _tmp16_;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeFunctionCall* _tmp18_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeUnaryExpression* _tmp21_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeExpressionStatement* _tmp22_;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeFunctionCall* _tmp24_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeConstant* _tmp26_;
	char* type_signature;
	ValaCCodeConstant* _tmp56_;
	char* _tmp55_;
	ValaCCodeExpressionStatement* _tmp57_;
	ValaCCodeDeclaration* _tmp58_;
	ValaCCodeVariableDeclarator* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	wrapper_name = (_tmp2_ = g_strdup_printf ("_dbus_handle_%s_%s", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) sym, NULL), _tmp1_ = vala_signal_get_cname (sig)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	/* declaration*/
	_cdecl_ = NULL;
	function = vala_ccode_function_new (wrapper_name, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp5_ = vala_ccode_formal_parameter_new ("self", _tmp4_ = g_strconcat (_tmp3_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) sym, FALSE), "*", NULL)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp6_ = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp7_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp7_ = vala_ccode_formal_parameter_new ("message", "DBusMessage*"));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	_tmp8_ = NULL;
	_cdecl_ = (_tmp8_ = vala_ccode_declaration_new ("DBusMessageIter"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp8_);
	_tmp9_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp9_ = vala_ccode_variable_declarator_new ("iter", NULL, NULL)));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prefragment);
	_tmp10_ = NULL;
	_tmp11_ = NULL;
	message_signature = (_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("dbus_message_get_signature"))), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), _tmp11_);
	_tmp12_ = NULL;
	vala_ccode_function_call_add_argument (message_signature, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("message")));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	_tmp13_ = NULL;
	_tmp14_ = NULL;
	signature_check = (_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("strcmp"))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp14_);
	vala_ccode_function_call_add_argument (signature_check, (ValaCCodeExpression*) message_signature);
	signature_error_block = vala_ccode_block_new ();
	_tmp15_ = NULL;
	vala_ccode_block_add_statement (signature_error_block, (ValaCCodeNode*) (_tmp15_ = vala_ccode_return_statement_new (NULL)));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	_tmp16_ = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp16_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) signature_check, (ValaCCodeStatement*) signature_error_block, NULL)));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp17_ = NULL;
	_tmp18_ = NULL;
	iter_call = (_tmp18_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new ("dbus_message_iter_init"))), (_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL)), _tmp18_);
	_tmp19_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("message")));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	_tmp21_ = NULL;
	_tmp20_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("iter")))));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	_tmp22_ = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp22_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	_tmp23_ = NULL;
	_tmp24_ = NULL;
	ccall = (_tmp24_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new ("g_signal_emit_by_name"))), (_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL)), _tmp24_);
	_tmp25_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new ("self")));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	_tmp26_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp26_ = vala_signal_get_canonical_cconstant (sig, NULL)));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	/* expected type signature for input parameters*/
	type_signature = g_strdup ("");
	{
		GeeList* _tmp27_;
		GeeIterator* _tmp28_;
		GeeIterator* _param_it;
		_tmp27_ = NULL;
		_tmp28_ = NULL;
		_param_it = (_tmp28_ = gee_iterable_iterator ((GeeIterable*) (_tmp27_ = vala_signal_get_parameters (sig))), (_tmp27_ == NULL) ? NULL : (_tmp27_ = (gee_collection_object_unref (_tmp27_), NULL)), _tmp28_);
		while (TRUE) {
			ValaFormalParameter* param;
			ValaCCodeDeclaration* _tmp30_;
			char* _tmp29_;
			ValaCCodeVariableDeclarator* _tmp32_;
			ValaCCodeExpression* _tmp31_;
			char* _tmp33_;
			gboolean _tmp34_;
			ValaStruct* _tmp38_;
			ValaTypeSymbol* _tmp37_;
			ValaStruct* st;
			gboolean _tmp39_;
			char* _tmp50_;
			char* _tmp49_;
			ValaCCodeIdentifier* target;
			ValaCCodeIdentifier* _tmp51_;
			ValaCCodeExpression* _tmp52_;
			ValaCCodeExpression* expr;
			ValaCCodeExpressionStatement* _tmp54_;
			ValaCCodeAssignment* _tmp53_;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp30_ = NULL;
			_tmp29_ = NULL;
			_cdecl_ = (_tmp30_ = vala_ccode_declaration_new (_tmp29_ = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param))), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp30_);
			_tmp29_ = (g_free (_tmp29_), NULL);
			_tmp32_ = NULL;
			_tmp31_ = NULL;
			vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp32_ = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) param), _tmp31_ = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (param), TRUE), NULL)));
			(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
			(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
			vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) _cdecl_);
			_tmp33_ = NULL;
			if ((_tmp34_ = (_tmp33_ = vala_dbus_module_get_type_signature (vala_formal_parameter_get_parameter_type (param))) == NULL, _tmp33_ = (g_free (_tmp33_), NULL), _tmp34_)) {
				char* _tmp36_;
				char* _tmp35_;
				_tmp36_ = NULL;
				_tmp35_ = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) vala_formal_parameter_get_parameter_type (param)), _tmp36_ = g_strdup_printf ("D-Bus serialization of type `%s' is not supported", _tmp35_ = vala_code_node_to_string ((ValaCodeNode*) vala_formal_parameter_get_parameter_type (param))));
				_tmp36_ = (g_free (_tmp36_), NULL);
				_tmp35_ = (g_free (_tmp35_), NULL);
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				continue;
			}
			_tmp38_ = NULL;
			_tmp37_ = NULL;
			st = (_tmp38_ = (_tmp37_ = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)), VALA_IS_STRUCT (_tmp37_) ? ((ValaStruct*) _tmp37_) : NULL), (_tmp38_ == NULL) ? NULL : vala_code_node_ref (_tmp38_));
			_tmp39_ = FALSE;
			if (st != NULL) {
				_tmp39_ = !vala_struct_is_simple_type (st);
			} else {
				_tmp39_ = FALSE;
			}
			if (_tmp39_) {
				ValaCCodeUnaryExpression* _tmp41_;
				ValaCCodeIdentifier* _tmp40_;
				_tmp41_ = NULL;
				_tmp40_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))));
				(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
				(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
			} else {
				ValaCCodeIdentifier* _tmp42_;
				_tmp42_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
				(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
			}
			if (VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
				ValaArrayType* _tmp43_;
				ValaArrayType* array_type;
				_tmp43_ = NULL;
				array_type = (_tmp43_ = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp43_ == NULL) ? NULL : vala_code_node_ref (_tmp43_));
				{
					gint dim;
					dim = 1;
					{
						gboolean _tmp44_;
						_tmp44_ = TRUE;
						while (TRUE) {
							char* length_cname;
							ValaCCodeDeclaration* _tmp45_;
							ValaCCodeVariableDeclarator* _tmp47_;
							ValaCCodeConstant* _tmp46_;
							ValaCCodeIdentifier* _tmp48_;
							if (!_tmp44_) {
								dim++;
							}
							_tmp44_ = FALSE;
							if (!(dim <= vala_array_type_get_rank (array_type))) {
								break;
							}
							length_cname = vala_ccode_module_get_array_length_cname ((ValaCCodeModule*) self, vala_symbol_get_name ((ValaSymbol*) param), dim);
							_tmp45_ = NULL;
							_cdecl_ = (_tmp45_ = vala_ccode_declaration_new ("int"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp45_);
							_tmp47_ = NULL;
							_tmp46_ = NULL;
							vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp47_ = vala_ccode_variable_declarator_new (length_cname, (ValaCCodeExpression*) (_tmp46_ = vala_ccode_constant_new ("0")), NULL)));
							(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
							(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
							vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) _cdecl_);
							_tmp48_ = NULL;
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp48_ = vala_ccode_identifier_new (length_cname)));
							(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
							length_cname = (g_free (length_cname), NULL);
						}
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			}
			_tmp50_ = NULL;
			_tmp49_ = NULL;
			type_signature = (_tmp50_ = g_strconcat (type_signature, _tmp49_ = vala_dbus_module_get_type_signature (vala_formal_parameter_get_parameter_type (param)), NULL), type_signature = (g_free (type_signature), NULL), _tmp50_);
			_tmp49_ = (g_free (_tmp49_), NULL);
			target = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param));
			_tmp51_ = NULL;
			_tmp52_ = NULL;
			expr = (_tmp52_ = vala_dbus_module_read_expression ((ValaDBusModule*) self, prefragment, vala_formal_parameter_get_parameter_type (param), (ValaCCodeExpression*) (_tmp51_ = vala_ccode_identifier_new ("iter")), (ValaCCodeExpression*) target), (_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL)), _tmp52_);
			_tmp54_ = NULL;
			_tmp53_ = NULL;
			vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp54_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp53_ = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
			(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			(target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL));
			(expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp56_ = NULL;
	_tmp55_ = NULL;
	vala_ccode_function_call_add_argument (signature_check, (ValaCCodeExpression*) (_tmp56_ = vala_ccode_constant_new (_tmp55_ = g_strdup_printf ("\"%s\"", type_signature))));
	(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
	_tmp55_ = (g_free (_tmp55_), NULL);
	_tmp57_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp57_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
	_tmp58_ = NULL;
	_cdecl_ = (_tmp58_ = vala_ccode_declaration_new ("DBusMessage*"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp58_);
	_tmp59_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp59_ = vala_ccode_variable_declarator_new ("reply", NULL, NULL)));
	(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp60_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp60_ = vala_ccode_function_copy (function)));
	(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	result = wrapper_name;
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL));
	(message_signature == NULL) ? NULL : (message_signature = (vala_ccode_node_unref (message_signature), NULL));
	(signature_check == NULL) ? NULL : (signature_check = (vala_ccode_node_unref (signature_check), NULL));
	(signature_error_block == NULL) ? NULL : (signature_error_block = (vala_ccode_node_unref (signature_error_block), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	type_signature = (g_free (type_signature), NULL);
	return result;
}


static void vala_dbus_client_module_handle_signal (ValaDBusClientModule* self, const char* dbus_iface_name, const char* dbus_signal_name, const char* handler_name, ValaCCodeBlock* block, ValaCCodeIfStatement** clastif) {
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeConstant* _tmp4_;
	char* _tmp3_;
	ValaCCodeConstant* _tmp6_;
	char* _tmp5_;
	ValaCCodeBlock* callblock;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeFunctionCall* _tmp8_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeIdentifier* _tmp11_;
	ValaCCodeExpressionStatement* _tmp12_;
	ValaCCodeIfStatement* cif;
	ValaCCodeIfStatement* _tmp14_;
	ValaCCodeIfStatement* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_iface_name != NULL);
	g_return_if_fail (dbus_signal_name != NULL);
	g_return_if_fail (handler_name != NULL);
	g_return_if_fail (block != NULL);
	g_return_if_fail (clastif != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	ccheck = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("dbus_message_is_signal"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("message")));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_constant_new (_tmp3_ = g_strdup_printf ("\"%s\"", dbus_iface_name))));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_constant_new (_tmp5_ = g_strdup_printf ("\"%s\"", dbus_signal_name))));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp5_ = (g_free (_tmp5_), NULL);
	callblock = vala_ccode_block_new ();
	_tmp7_ = NULL;
	_tmp8_ = NULL;
	ccall = (_tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new (handler_name))), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL)), _tmp8_);
	_tmp9_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("user_data")));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp10_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("connection")));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp11_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new ("message")));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	_tmp12_ = NULL;
	vala_ccode_block_add_statement (callblock, (ValaCCodeNode*) (_tmp12_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccheck, (ValaCCodeStatement*) callblock, NULL);
	if ((*clastif) == NULL) {
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) cif);
	} else {
		vala_ccode_if_statement_set_false_statement ((*clastif), (ValaCCodeStatement*) cif);
	}
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	(*clastif) = (_tmp14_ = (_tmp13_ = cif, (_tmp13_ == NULL) ? NULL : vala_ccode_node_ref (_tmp13_)), ((*clastif) == NULL) ? NULL : ((*clastif) = (vala_ccode_node_unref ((*clastif)), NULL)), _tmp14_);
	(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
	(callblock == NULL) ? NULL : (callblock = (vala_ccode_node_unref (callblock), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
}


static void vala_dbus_client_module_handle_signals (ValaDBusClientModule* self, ValaInterface* iface, ValaCCodeBlock* block) {
	ValaAttribute* _tmp0_;
	char* _tmp1_;
	char* dbus_iface_name;
	ValaCCodeIfStatement* clastif;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (block != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	dbus_iface_name = (_tmp1_ = vala_attribute_get_string (_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) iface, "DBus"), "name"), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_code_node_unref (_tmp0_), NULL)), _tmp1_);
	clastif = NULL;
	{
		GeeList* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _sig_it;
		_tmp2_ = NULL;
		_tmp3_ = NULL;
		_sig_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) iface))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (gee_collection_object_unref (_tmp2_), NULL)), _tmp3_);
		while (TRUE) {
			ValaSignal* sig;
			char* _tmp5_;
			char* _tmp4_;
			if (!gee_iterator_next (_sig_it)) {
				break;
			}
			sig = (ValaSignal*) gee_iterator_get (_sig_it);
			if (vala_symbol_get_access ((ValaSymbol*) sig) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
				(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
				continue;
			}
			_tmp5_ = NULL;
			_tmp4_ = NULL;
			vala_dbus_client_module_handle_signal (self, dbus_iface_name, _tmp4_ = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) sig)), _tmp5_ = vala_dbus_client_module_generate_dbus_signal_handler (self, sig, (ValaObjectTypeSymbol*) iface), block, &clastif);
			_tmp5_ = (g_free (_tmp5_), NULL);
			_tmp4_ = (g_free (_tmp4_), NULL);
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		}
		(_sig_it == NULL) ? NULL : (_sig_it = (gee_collection_object_unref (_sig_it), NULL));
	}
	dbus_iface_name = (g_free (dbus_iface_name), NULL);
	(clastif == NULL) ? NULL : (clastif = (vala_ccode_node_unref (clastif), NULL));
}


static void vala_dbus_client_module_generate_marshalling (ValaDBusClientModule* self, ValaMethod* m, const char* dbus_iface_name, ValaCCodeFragment* prefragment, ValaCCodeFragment* postfragment) {
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* destination;
	ValaCCodeCastExpression* _tmp3_;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* path;
	ValaCCodeCastExpression* _tmp7_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeFunctionCall* _tmp9_;
	ValaCCodeFunctionCall* msgcall;
	ValaCCodeConstant* _tmp11_;
	char* _tmp10_;
	ValaCCodeConstant* _tmp14_;
	char* _tmp13_;
	char* _tmp12_;
	ValaCCodeExpressionStatement* _tmp17_;
	ValaCCodeAssignment* _tmp16_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeUnaryExpression* _tmp22_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeExpressionStatement* _tmp23_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeUnaryExpression* _tmp28_;
	ValaCCodeIdentifier* _tmp27_;
	ValaCCodeExpressionStatement* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (dbus_iface_name != NULL);
	g_return_if_fail (prefragment != NULL);
	g_return_if_fail (postfragment != NULL);
	_cdecl_ = NULL;
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	destination = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("dbus_g_proxy_get_bus_name"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (destination, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("self")), "DBusGProxy*")));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	path = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("dbus_g_proxy_get_path"))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp5_);
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("self")), "DBusGProxy*")));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp8_ = NULL;
	_tmp9_ = NULL;
	msgcall = (_tmp9_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("dbus_message_new_method_call"))), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), _tmp9_);
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) destination);
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) path);
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_constant_new (_tmp10_ = g_strdup_printf ("\"%s\"", dbus_iface_name))));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	_tmp10_ = (g_free (_tmp10_), NULL);
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_constant_new (_tmp13_ = g_strdup_printf ("\"%s\"", _tmp12_ = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) m))))));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	_tmp13_ = (g_free (_tmp13_), NULL);
	_tmp12_ = (g_free (_tmp12_), NULL);
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	_tmp15_ = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp17_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("_message")), (ValaCCodeExpression*) msgcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	_tmp18_ = NULL;
	_tmp19_ = NULL;
	iter_call = (_tmp19_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("dbus_message_iter_init_append"))), (_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL)), _tmp19_);
	_tmp20_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("_message")));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	_tmp22_ = NULL;
	_tmp21_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("_iter")))));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	_tmp23_ = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp23_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	_tmp25_ = NULL;
	_tmp24_ = NULL;
	iter_call = (_tmp25_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("dbus_message_iter_init"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp25_);
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	_tmp26_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new ("_reply")));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	_tmp28_ = NULL;
	_tmp27_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("_iter")))));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	_tmp29_ = NULL;
	vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp29_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	{
		GeeList* _tmp30_;
		GeeIterator* _tmp31_;
		GeeIterator* _param_it;
		_tmp30_ = NULL;
		_tmp31_ = NULL;
		_param_it = (_tmp31_ = gee_iterable_iterator ((GeeIterable*) (_tmp30_ = vala_method_get_parameters (m))), (_tmp30_ == NULL) ? NULL : (_tmp30_ = (gee_collection_object_unref (_tmp30_), NULL)), _tmp31_);
		while (TRUE) {
			ValaFormalParameter* param;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
				gboolean _tmp32_;
				ValaCCodeExpression* expr;
				ValaCCodeIdentifier* _tmp35_;
				_tmp32_ = FALSE;
				if (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)) != NULL) {
					char* _tmp33_;
					_tmp33_ = NULL;
					_tmp32_ = _vala_strcmp0 (_tmp33_ = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), "DBus.BusName") == 0;
					_tmp33_ = (g_free (_tmp33_), NULL);
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					/* ignore BusName sender parameters*/
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					continue;
				}
				expr = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param));
				if (vala_data_type_is_real_struct_type (vala_formal_parameter_get_parameter_type (param))) {
					ValaCCodeExpression* _tmp34_;
					_tmp34_ = NULL;
					expr = (_tmp34_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, expr), (expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL)), _tmp34_);
				}
				_tmp35_ = NULL;
				vala_dbus_module_write_expression ((ValaDBusModule*) self, prefragment, vala_formal_parameter_get_parameter_type (param), (ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new ("_iter")), expr);
				(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
				(expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL));
			} else {
				ValaCCodeDeclaration* _tmp37_;
				char* _tmp36_;
				ValaCCodeVariableDeclarator* _tmp39_;
				char* _tmp38_;
				ValaArrayType* _tmp41_;
				ValaDataType* _tmp40_;
				ValaArrayType* array_type;
				char* _tmp47_;
				ValaCCodeIdentifier* _tmp48_;
				ValaCCodeIdentifier* target;
				ValaCCodeIdentifier* _tmp49_;
				ValaCCodeExpression* _tmp50_;
				ValaCCodeExpression* expr;
				ValaCCodeExpressionStatement* _tmp52_;
				ValaCCodeAssignment* _tmp51_;
				ValaCCodeExpressionStatement* _tmp56_;
				ValaCCodeAssignment* _tmp55_;
				ValaCCodeUnaryExpression* _tmp54_;
				ValaCCodeIdentifier* _tmp53_;
				_tmp37_ = NULL;
				_tmp36_ = NULL;
				_cdecl_ = (_tmp37_ = vala_ccode_declaration_new (_tmp36_ = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param))), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp37_);
				_tmp36_ = (g_free (_tmp36_), NULL);
				_tmp39_ = NULL;
				_tmp38_ = NULL;
				vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp39_ = vala_ccode_variable_declarator_new (_tmp38_ = g_strconcat ("_", vala_symbol_get_name ((ValaSymbol*) param), NULL), NULL, NULL)));
				(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
				_tmp38_ = (g_free (_tmp38_), NULL);
				vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) _cdecl_);
				_tmp41_ = NULL;
				_tmp40_ = NULL;
				array_type = (_tmp41_ = (_tmp40_ = vala_formal_parameter_get_parameter_type (param), VALA_IS_ARRAY_TYPE (_tmp40_) ? ((ValaArrayType*) _tmp40_) : NULL), (_tmp41_ == NULL) ? NULL : vala_code_node_ref (_tmp41_));
				if (array_type != NULL) {
					{
						gint dim;
						dim = 1;
						{
							gboolean _tmp42_;
							_tmp42_ = TRUE;
							while (TRUE) {
								ValaCCodeDeclaration* _tmp43_;
								ValaCCodeVariableDeclarator* _tmp46_;
								ValaCCodeConstant* _tmp45_;
								char* _tmp44_;
								if (!_tmp42_) {
									dim++;
								}
								_tmp42_ = FALSE;
								if (!(dim <= vala_array_type_get_rank (array_type))) {
									break;
								}
								_tmp43_ = NULL;
								_cdecl_ = (_tmp43_ = vala_ccode_declaration_new ("int"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp43_);
								_tmp46_ = NULL;
								_tmp45_ = NULL;
								_tmp44_ = NULL;
								vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp46_ = vala_ccode_variable_declarator_new (_tmp44_ = g_strdup_printf ("_%s_length%d", vala_symbol_get_name ((ValaSymbol*) param), dim), (ValaCCodeExpression*) (_tmp45_ = vala_ccode_constant_new ("0")), NULL)));
								(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
								(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
								_tmp44_ = (g_free (_tmp44_), NULL);
								vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) _cdecl_);
							}
						}
					}
				}
				_tmp47_ = NULL;
				_tmp48_ = NULL;
				target = (_tmp48_ = vala_ccode_identifier_new (_tmp47_ = g_strconcat ("_", vala_symbol_get_name ((ValaSymbol*) param), NULL)), _tmp47_ = (g_free (_tmp47_), NULL), _tmp48_);
				_tmp49_ = NULL;
				_tmp50_ = NULL;
				expr = (_tmp50_ = vala_dbus_module_read_expression ((ValaDBusModule*) self, postfragment, vala_formal_parameter_get_parameter_type (param), (ValaCCodeExpression*) (_tmp49_ = vala_ccode_identifier_new ("_iter")), (ValaCCodeExpression*) target), (_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL)), _tmp50_);
				_tmp52_ = NULL;
				_tmp51_ = NULL;
				vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp52_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp51_ = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
				(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
				/* TODO check that parameter is not NULL (out parameters are optional)
				 free value if parameter is NULL*/
				_tmp56_ = NULL;
				_tmp55_ = NULL;
				_tmp54_ = NULL;
				_tmp53_ = NULL;
				vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp56_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp55_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp54_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp53_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))), (ValaCCodeExpression*) target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
				(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
				(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
				(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
				if (array_type != NULL) {
					{
						gint dim;
						dim = 1;
						{
							gboolean _tmp57_;
							_tmp57_ = TRUE;
							while (TRUE) {
								ValaCCodeExpressionStatement* _tmp64_;
								ValaCCodeAssignment* _tmp63_;
								ValaCCodeIdentifier* _tmp62_;
								char* _tmp61_;
								ValaCCodeUnaryExpression* _tmp60_;
								ValaCCodeIdentifier* _tmp59_;
								char* _tmp58_;
								if (!_tmp57_) {
									dim++;
								}
								_tmp57_ = FALSE;
								if (!(dim <= vala_array_type_get_rank (array_type))) {
									break;
								}
								/* TODO check that parameter is not NULL (out parameters are optional)*/
								_tmp64_ = NULL;
								_tmp63_ = NULL;
								_tmp62_ = NULL;
								_tmp61_ = NULL;
								_tmp60_ = NULL;
								_tmp59_ = NULL;
								_tmp58_ = NULL;
								vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp64_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp63_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp60_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new (_tmp58_ = g_strdup_printf ("%s_length%d", vala_symbol_get_name ((ValaSymbol*) param), dim))))), (ValaCCodeExpression*) (_tmp62_ = vala_ccode_identifier_new (_tmp61_ = g_strdup_printf ("_%s_length%d", vala_symbol_get_name ((ValaSymbol*) param), dim))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
								(_tmp64_ == NULL) ? NULL : (_tmp64_ = (vala_ccode_node_unref (_tmp64_), NULL));
								(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
								(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
								_tmp61_ = (g_free (_tmp61_), NULL);
								(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
								(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
								_tmp58_ = (g_free (_tmp58_), NULL);
							}
						}
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				(target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL));
				(expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeDeclaration* _tmp66_;
		char* _tmp65_;
		ValaCCodeVariableDeclarator* _tmp67_;
		ValaArrayType* _tmp69_;
		ValaDataType* _tmp68_;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* target;
		ValaCCodeIdentifier* _tmp75_;
		ValaCCodeExpression* _tmp76_;
		ValaCCodeExpression* expr;
		ValaCCodeExpressionStatement* _tmp78_;
		ValaCCodeAssignment* _tmp77_;
		_tmp66_ = NULL;
		_tmp65_ = NULL;
		_cdecl_ = (_tmp66_ = vala_ccode_declaration_new (_tmp65_ = vala_data_type_get_cname (vala_method_get_return_type (m))), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp66_);
		_tmp65_ = (g_free (_tmp65_), NULL);
		_tmp67_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp67_ = vala_ccode_variable_declarator_new ("_result", NULL, NULL)));
		(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
		vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) _cdecl_);
		_tmp69_ = NULL;
		_tmp68_ = NULL;
		array_type = (_tmp69_ = (_tmp68_ = vala_method_get_return_type (m), VALA_IS_ARRAY_TYPE (_tmp68_) ? ((ValaArrayType*) _tmp68_) : NULL), (_tmp69_ == NULL) ? NULL : vala_code_node_ref (_tmp69_));
		if (array_type != NULL) {
			{
				gint dim;
				dim = 1;
				{
					gboolean _tmp70_;
					_tmp70_ = TRUE;
					while (TRUE) {
						ValaCCodeDeclaration* _tmp71_;
						ValaCCodeVariableDeclarator* _tmp74_;
						ValaCCodeConstant* _tmp73_;
						char* _tmp72_;
						if (!_tmp70_) {
							dim++;
						}
						_tmp70_ = FALSE;
						if (!(dim <= vala_array_type_get_rank (array_type))) {
							break;
						}
						_tmp71_ = NULL;
						_cdecl_ = (_tmp71_ = vala_ccode_declaration_new ("int"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp71_);
						_tmp74_ = NULL;
						_tmp73_ = NULL;
						_tmp72_ = NULL;
						vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp74_ = vala_ccode_variable_declarator_new (_tmp72_ = g_strdup_printf ("_result_length%d", dim), (ValaCCodeExpression*) (_tmp73_ = vala_ccode_constant_new ("0")), NULL)));
						(_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL));
						(_tmp73_ == NULL) ? NULL : (_tmp73_ = (vala_ccode_node_unref (_tmp73_), NULL));
						_tmp72_ = (g_free (_tmp72_), NULL);
						vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) _cdecl_);
					}
				}
			}
		}
		target = vala_ccode_identifier_new ("_result");
		_tmp75_ = NULL;
		_tmp76_ = NULL;
		expr = (_tmp76_ = vala_dbus_module_read_expression ((ValaDBusModule*) self, postfragment, vala_method_get_return_type (m), (ValaCCodeExpression*) (_tmp75_ = vala_ccode_identifier_new ("_iter")), (ValaCCodeExpression*) target), (_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL)), _tmp76_);
		_tmp78_ = NULL;
		_tmp77_ = NULL;
		vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp78_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp77_ = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
		(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
		if (array_type != NULL) {
			{
				gint dim;
				dim = 1;
				{
					gboolean _tmp79_;
					_tmp79_ = TRUE;
					while (TRUE) {
						ValaCCodeExpressionStatement* _tmp86_;
						ValaCCodeAssignment* _tmp85_;
						ValaCCodeIdentifier* _tmp84_;
						char* _tmp83_;
						ValaCCodeUnaryExpression* _tmp82_;
						ValaCCodeIdentifier* _tmp81_;
						char* _tmp80_;
						if (!_tmp79_) {
							dim++;
						}
						_tmp79_ = FALSE;
						if (!(dim <= vala_array_type_get_rank (array_type))) {
							break;
						}
						/* TODO check that parameter is not NULL (out parameters are optional)*/
						_tmp86_ = NULL;
						_tmp85_ = NULL;
						_tmp84_ = NULL;
						_tmp83_ = NULL;
						_tmp82_ = NULL;
						_tmp81_ = NULL;
						_tmp80_ = NULL;
						vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp86_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp85_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp82_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp81_ = vala_ccode_identifier_new (_tmp80_ = g_strdup_printf ("result_length%d", dim))))), (ValaCCodeExpression*) (_tmp84_ = vala_ccode_identifier_new (_tmp83_ = g_strdup_printf ("_result_length%d", dim))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
						(_tmp86_ == NULL) ? NULL : (_tmp86_ = (vala_ccode_node_unref (_tmp86_), NULL));
						(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
						(_tmp84_ == NULL) ? NULL : (_tmp84_ = (vala_ccode_node_unref (_tmp84_), NULL));
						_tmp83_ = (g_free (_tmp83_), NULL);
						(_tmp82_ == NULL) ? NULL : (_tmp82_ = (vala_ccode_node_unref (_tmp82_), NULL));
						(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_ccode_node_unref (_tmp81_), NULL));
						_tmp80_ = (g_free (_tmp80_), NULL);
					}
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL));
		(expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL));
	}
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(destination == NULL) ? NULL : (destination = (vala_ccode_node_unref (destination), NULL));
	(path == NULL) ? NULL : (path = (vala_ccode_node_unref (path), NULL));
	(msgcall == NULL) ? NULL : (msgcall = (vala_ccode_node_unref (msgcall), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
}


static char* vala_dbus_client_module_generate_dbus_proxy_method (ValaDBusClientModule* self, ValaInterface* iface, ValaMethod* m) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	char* proxy_name;
	ValaAttribute* _tmp2_;
	char* _tmp3_;
	char* dbus_iface_name;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeFragment* postfragment;
	ValaCCodeBlock* dispose_return_block;
	GeeList* _tmp4_;
	gboolean _tmp5_;
	ValaCCodeIfStatement* _tmp21_;
	ValaCCodeMemberAccess* _tmp20_;
	ValaCCodeCastExpression* _tmp19_;
	char* _tmp18_;
	char* _tmp17_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeDeclaration* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeDeclaration* _tmp24_;
	ValaCCodeVariableDeclarator* _tmp25_;
	ValaCCodeVariableDeclarator* _tmp26_;
	ValaCCodeDeclaration* _tmp27_;
	ValaCCodeVariableDeclarator* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeFunctionCall* gconnection;
	ValaCCodeIdentifier* _tmp31_;
	ValaCCodeConstant* _tmp32_;
	ValaCCodeUnaryExpression* _tmp34_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeConstant* _tmp35_;
	ValaCCodeExpressionStatement* _tmp36_;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeFunctionCall* _tmp38_;
	ValaCCodeFunctionCall* connection;
	ValaCCodeIdentifier* _tmp39_;
	ValaCCodeIdentifier* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeConstant* _tmp44_;
	ValaCCodeExpressionStatement* _tmp47_;
	ValaCCodeAssignment* _tmp46_;
	ValaCCodeIdentifier* _tmp45_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeFunctionCall* conn_unref;
	ValaCCodeIdentifier* _tmp50_;
	ValaCCodeExpressionStatement* _tmp51_;
	ValaCCodeIdentifier* _tmp52_;
	ValaCCodeFunctionCall* _tmp53_;
	ValaCCodeFunctionCall* message_unref;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeExpressionStatement* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeFunctionCall* reply_unref;
	ValaCCodeIdentifier* _tmp58_;
	ValaCCodeExpressionStatement* _tmp59_;
	ValaCCodeFunction* _tmp62_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iface != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	proxy_name = (_tmp1_ = g_strdup_printf ("%sdbus_proxy_%s", _tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) m)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	dbus_iface_name = (_tmp3_ = vala_attribute_get_string (_tmp2_ = vala_code_node_get_attribute ((ValaCodeNode*) iface, "DBus"), "name"), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL)), _tmp3_);
	_cdecl_ = NULL;
	function = vala_ccode_function_new (proxy_name, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, function, NULL, NULL, NULL, 3);
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	postfragment = vala_ccode_fragment_new ();
	/* throw error and return if proxy is disposed*/
	dispose_return_block = vala_ccode_block_new ();
	_tmp4_ = NULL;
	if ((_tmp5_ = gee_collection_get_size ((GeeCollection*) (_tmp4_ = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, (_tmp4_ == NULL) ? NULL : (_tmp4_ = (gee_collection_object_unref (_tmp4_), NULL)), _tmp5_)) {
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeFunctionCall* _tmp7_;
		ValaCCodeFunctionCall* set_error_call;
		ValaCCodeIdentifier* _tmp8_;
		ValaCCodeIdentifier* _tmp9_;
		ValaCCodeIdentifier* _tmp10_;
		ValaCCodeConstant* _tmp11_;
		ValaCCodeExpressionStatement* _tmp12_;
		_tmp6_ = NULL;
		_tmp7_ = NULL;
		set_error_call = (_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("g_set_error_literal"))), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL)), _tmp7_);
		_tmp8_ = NULL;
		vala_ccode_function_call_add_argument (set_error_call, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("error")));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		_tmp9_ = NULL;
		vala_ccode_function_call_add_argument (set_error_call, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("DBUS_GERROR")));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		_tmp10_ = NULL;
		vala_ccode_function_call_add_argument (set_error_call, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("DBUS_GERROR_DISCONNECTED")));
		(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
		_tmp11_ = NULL;
		vala_ccode_function_call_add_argument (set_error_call, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_constant_new ("\"Connection is closed\"")));
		(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
		_tmp12_ = NULL;
		vala_ccode_block_add_statement (dispose_return_block, (ValaCCodeNode*) (_tmp12_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) set_error_call)));
		(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
		(set_error_call == NULL) ? NULL : (set_error_call = (vala_ccode_node_unref (set_error_call), NULL));
	}
	if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeReturnStatement* _tmp13_;
		_tmp13_ = NULL;
		vala_ccode_block_add_statement (dispose_return_block, (ValaCCodeNode*) (_tmp13_ = vala_ccode_return_statement_new (NULL)));
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	} else {
		ValaCCodeReturnStatement* _tmp15_;
		ValaCCodeExpression* _tmp14_;
		_tmp15_ = NULL;
		_tmp14_ = NULL;
		vala_ccode_block_add_statement (dispose_return_block, (ValaCCodeNode*) (_tmp15_ = vala_ccode_return_statement_new (_tmp14_ = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, vala_method_get_return_type (m), FALSE))));
		(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
		(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	}
	_tmp21_ = NULL;
	_tmp20_ = NULL;
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp21_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("self")), _tmp18_ = g_strconcat (_tmp17_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), "DBusProxy*", NULL))), "disposed")), (ValaCCodeStatement*) dispose_return_block, NULL)));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	_tmp18_ = (g_free (_tmp18_), NULL);
	_tmp17_ = (g_free (_tmp17_), NULL);
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp22_ = NULL;
	_cdecl_ = (_tmp22_ = vala_ccode_declaration_new ("DBusGConnection"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp22_);
	_tmp23_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp23_ = vala_ccode_variable_declarator_new ("*_connection", NULL, NULL)));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp24_ = NULL;
	_cdecl_ = (_tmp24_ = vala_ccode_declaration_new ("DBusMessage"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp24_);
	_tmp25_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp25_ = vala_ccode_variable_declarator_new ("*_message", NULL, NULL)));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	_tmp26_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp26_ = vala_ccode_variable_declarator_new ("*_reply", NULL, NULL)));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp27_ = NULL;
	_cdecl_ = (_tmp27_ = vala_ccode_declaration_new ("DBusMessageIter"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp27_);
	_tmp28_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp28_ = vala_ccode_variable_declarator_new ("_iter", NULL, NULL)));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prefragment);
	vala_dbus_client_module_generate_marshalling (self, m, dbus_iface_name, prefragment, postfragment);
	_tmp29_ = NULL;
	_tmp30_ = NULL;
	gconnection = (_tmp30_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("g_object_get"))), (_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL)), _tmp30_);
	_tmp31_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new ("self")));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	_tmp32_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp32_ = vala_ccode_constant_new ("\"connection\"")));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	_tmp34_ = NULL;
	_tmp33_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp34_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new ("_connection")))));
	(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	_tmp35_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp35_ = vala_ccode_constant_new ("NULL")));
	(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
	_tmp36_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp36_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) gconnection)));
	(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
	_tmp37_ = NULL;
	_tmp38_ = NULL;
	connection = (_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new ("dbus_g_connection_get_connection"))), (_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL)), _tmp38_);
	_tmp39_ = NULL;
	vala_ccode_function_call_add_argument (connection, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_identifier_new ("_connection")));
	(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
	_tmp40_ = NULL;
	_tmp41_ = NULL;
	ccall = (_tmp41_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new ("dbus_connection_send_with_reply_and_block"))), (_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL)), _tmp41_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) connection);
	_tmp42_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_identifier_new ("_message")));
	(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
	_tmp43_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp43_ = vala_ccode_constant_new ("-1")));
	(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
	_tmp44_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp44_ = vala_ccode_constant_new ("NULL")));
	(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
	_tmp47_ = NULL;
	_tmp46_ = NULL;
	_tmp45_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp47_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp46_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp45_ = vala_ccode_identifier_new ("_reply")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
	(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
	(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
	_tmp48_ = NULL;
	_tmp49_ = NULL;
	conn_unref = (_tmp49_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp48_ = vala_ccode_identifier_new ("dbus_g_connection_unref"))), (_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL)), _tmp49_);
	_tmp50_ = NULL;
	vala_ccode_function_call_add_argument (conn_unref, (ValaCCodeExpression*) (_tmp50_ = vala_ccode_identifier_new ("_connection")));
	(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
	_tmp51_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp51_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) conn_unref)));
	(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
	_tmp52_ = NULL;
	_tmp53_ = NULL;
	message_unref = (_tmp53_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp52_ = vala_ccode_identifier_new ("dbus_message_unref"))), (_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL)), _tmp53_);
	_tmp54_ = NULL;
	vala_ccode_function_call_add_argument (message_unref, (ValaCCodeExpression*) (_tmp54_ = vala_ccode_identifier_new ("_message")));
	(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
	_tmp55_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp55_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) message_unref)));
	(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) postfragment);
	_tmp56_ = NULL;
	_tmp57_ = NULL;
	reply_unref = (_tmp57_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp56_ = vala_ccode_identifier_new ("dbus_message_unref"))), (_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL)), _tmp57_);
	_tmp58_ = NULL;
	vala_ccode_function_call_add_argument (reply_unref, (ValaCCodeExpression*) (_tmp58_ = vala_ccode_identifier_new ("_reply")));
	(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
	_tmp59_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp59_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) reply_unref)));
	(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeReturnStatement* _tmp61_;
		ValaCCodeIdentifier* _tmp60_;
		_tmp61_ = NULL;
		_tmp60_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp61_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp60_ = vala_ccode_identifier_new ("_result")))));
		(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
		(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
	}
	_tmp62_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp62_ = vala_ccode_function_copy (function)));
	(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	result = proxy_name;
	dbus_iface_name = (g_free (dbus_iface_name), NULL);
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL));
	(postfragment == NULL) ? NULL : (postfragment = (vala_ccode_node_unref (postfragment), NULL));
	(dispose_return_block == NULL) ? NULL : (dispose_return_block = (vala_ccode_node_unref (dispose_return_block), NULL));
	(gconnection == NULL) ? NULL : (gconnection = (vala_ccode_node_unref (gconnection), NULL));
	(connection == NULL) ? NULL : (connection = (vala_ccode_node_unref (connection), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(conn_unref == NULL) ? NULL : (conn_unref = (vala_ccode_node_unref (conn_unref), NULL));
	(message_unref == NULL) ? NULL : (message_unref = (vala_ccode_node_unref (message_unref), NULL));
	(reply_unref == NULL) ? NULL : (reply_unref = (vala_ccode_node_unref (reply_unref), NULL));
	return result;
}


static char* vala_dbus_client_module_generate_async_dbus_proxy_method (ValaDBusClientModule* self, ValaInterface* iface, ValaMethod* m) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	char* proxy_name;
	ValaAttribute* _tmp2_;
	char* _tmp3_;
	char* dbus_iface_name;
	ValaCCodeDeclaration* _cdecl_;
	char* _tmp5_;
	char* _tmp4_;
	char* _tmp6_;
	char* dataname;
	char* _tmp7_;
	ValaCCodeStruct* _tmp8_;
	ValaCCodeStruct* datastruct;
	ValaCCodeTypeDefinition* _tmp11_;
	ValaCCodeVariableDeclarator* _tmp10_;
	char* _tmp9_;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	ValaCCodeFormalParameter* _tmp12_;
	ValaCCodeFormalParameter* _tmp13_;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeFragment* postfragment;
	ValaCCodeDeclaration* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeDeclaration* _tmp16_;
	ValaCCodeVariableDeclarator* _tmp17_;
	ValaCCodeDeclaration* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeDeclaration* _tmp20_;
	ValaCCodeVariableDeclarator* _tmp21_;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunctionCall* gconnection;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeConstant* _tmp25_;
	ValaCCodeUnaryExpression* _tmp27_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeConstant* _tmp28_;
	ValaCCodeExpressionStatement* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeFunctionCall* connection;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunctionCall* _tmp34_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeUnaryExpression* _tmp37_;
	ValaCCodeIdentifier* _tmp36_;
	ValaCCodeConstant* _tmp38_;
	ValaCCodeExpressionStatement* _tmp39_;
	ValaCCodeIdentifier* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeFunctionCall* conn_unref;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeExpressionStatement* _tmp43_;
	ValaCCodeIdentifier* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* message_unref;
	ValaCCodeIdentifier* _tmp46_;
	ValaCCodeExpressionStatement* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeFunctionCall* dataalloc;
	ValaCCodeIdentifier* _tmp50_;
	char* _tmp51_;
	ValaCCodeDeclaration* _tmp52_;
	ValaCCodeDeclaration* datadecl;
	ValaCCodeVariableDeclarator* _tmp53_;
	ValaCCodeExpressionStatement* _tmp56_;
	ValaCCodeAssignment* _tmp55_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeExpressionStatement* _tmp61_;
	ValaCCodeAssignment* _tmp60_;
	ValaCCodeIdentifier* _tmp59_;
	ValaCCodeMemberAccess* _tmp58_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeExpressionStatement* _tmp66_;
	ValaCCodeAssignment* _tmp65_;
	ValaCCodeIdentifier* _tmp64_;
	ValaCCodeMemberAccess* _tmp63_;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeExpressionStatement* _tmp71_;
	ValaCCodeAssignment* _tmp70_;
	ValaCCodeIdentifier* _tmp69_;
	ValaCCodeMemberAccess* _tmp68_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeFunctionCall* _tmp73_;
	ValaCCodeFunctionCall* pending;
	ValaCCodeIdentifier* _tmp74_;
	ValaCCodeIdentifier* _tmp77_;
	char* _tmp76_;
	char* _tmp75_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeConstant* _tmp79_;
	ValaCCodeExpressionStatement* _tmp80_;
	ValaCCodeFunction* _tmp81_;
	ValaCCodeFunction* _tmp84_;
	char* _tmp83_;
	char* _tmp82_;
	ValaCCodeFormalParameter* _tmp85_;
	ValaCCodeFormalParameter* _tmp86_;
	ValaCCodeBlock* _tmp87_;
	ValaCCodeDeclaration* _tmp89_;
	char* _tmp88_;
	ValaCCodeVariableDeclarator* _tmp90_;
	ValaCCodeExpressionStatement* _tmp94_;
	ValaCCodeAssignment* _tmp93_;
	ValaCCodeIdentifier* _tmp92_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeIdentifier* _tmp95_;
	ValaCCodeFunctionCall* _tmp96_;
	ValaCCodeFunctionCall* object_creation;
	ValaCCodeConstant* _tmp97_;
	ValaCCodeConstant* _tmp98_;
	ValaCCodeConstant* _tmp99_;
	ValaCCodeIdentifier* _tmp100_;
	ValaCCodeFunctionCall* _tmp101_;
	ValaCCodeFunctionCall* async_result_creation;
	ValaCCodeMemberAccess* _tmp103_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeMemberAccess* _tmp105_;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeIdentifier* _tmp107_;
	ValaCCodeFunctionCall* _tmp108_;
	ValaCCodeFunctionCall* completecall;
	ValaCCodeExpressionStatement* _tmp109_;
	ValaCCodeFunction* _tmp110_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iface != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	proxy_name = (_tmp1_ = g_strdup_printf ("%sdbus_proxy_%s_async", _tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) m)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	dbus_iface_name = (_tmp3_ = vala_attribute_get_string (_tmp2_ = vala_code_node_get_attribute ((ValaCodeNode*) iface, "DBus"), "name"), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL)), _tmp3_);
	_cdecl_ = NULL;
	/* generate data struct*/
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp6_ = NULL;
	dataname = (_tmp6_ = g_strdup_printf ("%sDBusProxy%sData", _tmp4_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), _tmp5_ = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) m))), _tmp5_ = (g_free (_tmp5_), NULL), _tmp4_ = (g_free (_tmp4_), NULL), _tmp6_);
	_tmp7_ = NULL;
	_tmp8_ = NULL;
	datastruct = (_tmp8_ = vala_ccode_struct_new (_tmp7_ = g_strconcat ("_", dataname, NULL)), _tmp7_ = (g_free (_tmp7_), NULL), _tmp8_);
	vala_ccode_struct_add_field (datastruct, "GAsyncReadyCallback", "callback");
	vala_ccode_struct_add_field (datastruct, "gpointer", "user_data");
	vala_ccode_struct_add_field (datastruct, "DBusPendingCall*", "pending");
	vala_ccode_declaration_space_add_type_definition (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) datastruct);
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp11_ = vala_ccode_type_definition_new (_tmp9_ = g_strconcat ("struct _", dataname, NULL), (ValaCCodeDeclarator*) (_tmp10_ = vala_ccode_variable_declarator_new (dataname, NULL, NULL)))));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp9_ = (g_free (_tmp9_), NULL);
	/* generate async function*/
	function = vala_ccode_function_new (proxy_name, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp12_ = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), _tmp12_ = vala_ccode_formal_parameter_new ("callback", "GAsyncReadyCallback"));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	_tmp13_ = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), _tmp13_ = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, function, NULL, NULL, NULL, 1);
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	postfragment = vala_ccode_fragment_new ();
	_tmp14_ = NULL;
	_cdecl_ = (_tmp14_ = vala_ccode_declaration_new ("DBusGConnection"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp14_);
	_tmp15_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp15_ = vala_ccode_variable_declarator_new ("*_connection", NULL, NULL)));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp16_ = NULL;
	_cdecl_ = (_tmp16_ = vala_ccode_declaration_new ("DBusMessage"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp16_);
	_tmp17_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp17_ = vala_ccode_variable_declarator_new ("*_message", NULL, NULL)));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp18_ = NULL;
	_cdecl_ = (_tmp18_ = vala_ccode_declaration_new ("DBusPendingCall"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp18_);
	_tmp19_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp19_ = vala_ccode_variable_declarator_new ("*_pending", NULL, NULL)));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp20_ = NULL;
	_cdecl_ = (_tmp20_ = vala_ccode_declaration_new ("DBusMessageIter"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp20_);
	_tmp21_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp21_ = vala_ccode_variable_declarator_new ("_iter", NULL, NULL)));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prefragment);
	vala_dbus_client_module_generate_marshalling (self, m, dbus_iface_name, prefragment, postfragment);
	_tmp22_ = NULL;
	_tmp23_ = NULL;
	gconnection = (_tmp23_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("g_object_get"))), (_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL)), _tmp23_);
	_tmp24_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("self")));
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	_tmp25_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_constant_new ("\"connection\"")));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	_tmp27_ = NULL;
	_tmp26_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new ("_connection")))));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	_tmp28_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_constant_new ("NULL")));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	_tmp29_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp29_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) gconnection)));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	_tmp30_ = NULL;
	_tmp31_ = NULL;
	connection = (_tmp31_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("dbus_g_connection_get_connection"))), (_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL)), _tmp31_);
	_tmp32_ = NULL;
	vala_ccode_function_call_add_argument (connection, (ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new ("_connection")));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	_tmp33_ = NULL;
	_tmp34_ = NULL;
	ccall = (_tmp34_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new ("dbus_connection_send_with_reply"))), (_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL)), _tmp34_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) connection);
	_tmp35_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new ("_message")));
	(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
	_tmp37_ = NULL;
	_tmp36_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp37_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp36_ = vala_ccode_identifier_new ("_pending")))));
	(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
	(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
	_tmp38_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp38_ = vala_ccode_constant_new ("-1")));
	(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
	_tmp39_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp39_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
	_tmp40_ = NULL;
	_tmp41_ = NULL;
	conn_unref = (_tmp41_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new ("dbus_g_connection_unref"))), (_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL)), _tmp41_);
	_tmp42_ = NULL;
	vala_ccode_function_call_add_argument (conn_unref, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_identifier_new ("_connection")));
	(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
	_tmp43_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp43_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) conn_unref)));
	(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
	_tmp44_ = NULL;
	_tmp45_ = NULL;
	message_unref = (_tmp45_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp44_ = vala_ccode_identifier_new ("dbus_message_unref"))), (_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL)), _tmp45_);
	_tmp46_ = NULL;
	vala_ccode_function_call_add_argument (message_unref, (ValaCCodeExpression*) (_tmp46_ = vala_ccode_identifier_new ("_message")));
	(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
	_tmp47_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp47_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) message_unref)));
	(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
	_tmp48_ = NULL;
	_tmp49_ = NULL;
	dataalloc = (_tmp49_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp48_ = vala_ccode_identifier_new ("g_slice_new0"))), (_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL)), _tmp49_);
	_tmp50_ = NULL;
	vala_ccode_function_call_add_argument (dataalloc, (ValaCCodeExpression*) (_tmp50_ = vala_ccode_identifier_new (dataname)));
	(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
	_tmp51_ = NULL;
	_tmp52_ = NULL;
	datadecl = (_tmp52_ = vala_ccode_declaration_new (_tmp51_ = g_strconcat (dataname, "*", NULL)), _tmp51_ = (g_free (_tmp51_), NULL), _tmp52_);
	_tmp53_ = NULL;
	vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp53_ = vala_ccode_variable_declarator_new ("data", NULL, NULL)));
	(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) datadecl);
	_tmp56_ = NULL;
	_tmp55_ = NULL;
	_tmp54_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp56_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp55_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp54_ = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) dataalloc, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
	(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
	(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
	_tmp61_ = NULL;
	_tmp60_ = NULL;
	_tmp59_ = NULL;
	_tmp58_ = NULL;
	_tmp57_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp61_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp60_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp58_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp57_ = vala_ccode_identifier_new ("data")), "callback")), (ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new ("callback")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
	(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
	(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
	(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
	(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
	_tmp66_ = NULL;
	_tmp65_ = NULL;
	_tmp64_ = NULL;
	_tmp63_ = NULL;
	_tmp62_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp66_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp65_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp63_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp62_ = vala_ccode_identifier_new ("data")), "user_data")), (ValaCCodeExpression*) (_tmp64_ = vala_ccode_identifier_new ("user_data")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp66_ == NULL) ? NULL : (_tmp66_ = (vala_ccode_node_unref (_tmp66_), NULL));
	(_tmp65_ == NULL) ? NULL : (_tmp65_ = (vala_ccode_node_unref (_tmp65_), NULL));
	(_tmp64_ == NULL) ? NULL : (_tmp64_ = (vala_ccode_node_unref (_tmp64_), NULL));
	(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
	(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
	_tmp71_ = NULL;
	_tmp70_ = NULL;
	_tmp69_ = NULL;
	_tmp68_ = NULL;
	_tmp67_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp71_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp70_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp68_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp67_ = vala_ccode_identifier_new ("data")), "pending")), (ValaCCodeExpression*) (_tmp69_ = vala_ccode_identifier_new ("_pending")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
	(_tmp70_ == NULL) ? NULL : (_tmp70_ = (vala_ccode_node_unref (_tmp70_), NULL));
	(_tmp69_ == NULL) ? NULL : (_tmp69_ = (vala_ccode_node_unref (_tmp69_), NULL));
	(_tmp68_ == NULL) ? NULL : (_tmp68_ = (vala_ccode_node_unref (_tmp68_), NULL));
	(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
	_tmp72_ = NULL;
	_tmp73_ = NULL;
	pending = (_tmp73_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp72_ = vala_ccode_identifier_new ("dbus_pending_call_set_notify"))), (_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL)), _tmp73_);
	_tmp74_ = NULL;
	vala_ccode_function_call_add_argument (pending, (ValaCCodeExpression*) (_tmp74_ = vala_ccode_identifier_new ("_pending")));
	(_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL));
	_tmp77_ = NULL;
	_tmp76_ = NULL;
	_tmp75_ = NULL;
	vala_ccode_function_call_add_argument (pending, (ValaCCodeExpression*) (_tmp77_ = vala_ccode_identifier_new (_tmp76_ = g_strdup_printf ("%sdbus_proxy_%s_ready", _tmp75_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) m)))));
	(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
	_tmp76_ = (g_free (_tmp76_), NULL);
	_tmp75_ = (g_free (_tmp75_), NULL);
	_tmp78_ = NULL;
	vala_ccode_function_call_add_argument (pending, (ValaCCodeExpression*) (_tmp78_ = vala_ccode_identifier_new ("data")));
	(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
	_tmp79_ = NULL;
	vala_ccode_function_call_add_argument (pending, (ValaCCodeExpression*) (_tmp79_ = vala_ccode_constant_new ("NULL")));
	(_tmp79_ == NULL) ? NULL : (_tmp79_ = (vala_ccode_node_unref (_tmp79_), NULL));
	_tmp80_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp80_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) pending)));
	(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
	_tmp81_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp81_ = vala_ccode_function_copy (function)));
	(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_ccode_node_unref (_tmp81_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	/* generate ready function*/
	_tmp84_ = NULL;
	_tmp83_ = NULL;
	_tmp82_ = NULL;
	function = (_tmp84_ = vala_ccode_function_new (_tmp83_ = g_strdup_printf ("%sdbus_proxy_%s_ready", _tmp82_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) m)), "void"), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), _tmp84_);
	_tmp83_ = (g_free (_tmp83_), NULL);
	_tmp82_ = (g_free (_tmp82_), NULL);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp85_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp85_ = vala_ccode_formal_parameter_new ("pending", "DBusPendingCall*"));
	(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
	_tmp86_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp86_ = vala_ccode_formal_parameter_new ("user_data", "void*"));
	(_tmp86_ == NULL) ? NULL : (_tmp86_ = (vala_ccode_node_unref (_tmp86_), NULL));
	_tmp87_ = NULL;
	block = (_tmp87_ = vala_ccode_block_new (), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp87_);
	_tmp89_ = NULL;
	_tmp88_ = NULL;
	datadecl = (_tmp89_ = vala_ccode_declaration_new (_tmp88_ = g_strconcat (dataname, "*", NULL)), (datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL)), _tmp89_);
	_tmp88_ = (g_free (_tmp88_), NULL);
	_tmp90_ = NULL;
	vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp90_ = vala_ccode_variable_declarator_new ("data", NULL, NULL)));
	(_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_ccode_node_unref (_tmp90_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) datadecl);
	_tmp94_ = NULL;
	_tmp93_ = NULL;
	_tmp92_ = NULL;
	_tmp91_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp94_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp93_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp91_ = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) (_tmp92_ = vala_ccode_identifier_new ("user_data")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp94_ == NULL) ? NULL : (_tmp94_ = (vala_ccode_node_unref (_tmp94_), NULL));
	(_tmp93_ == NULL) ? NULL : (_tmp93_ = (vala_ccode_node_unref (_tmp93_), NULL));
	(_tmp92_ == NULL) ? NULL : (_tmp92_ = (vala_ccode_node_unref (_tmp92_), NULL));
	(_tmp91_ == NULL) ? NULL : (_tmp91_ = (vala_ccode_node_unref (_tmp91_), NULL));
	/* complete async call by invoking callback*/
	_tmp95_ = NULL;
	_tmp96_ = NULL;
	object_creation = (_tmp96_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp95_ = vala_ccode_identifier_new ("g_object_newv"))), (_tmp95_ == NULL) ? NULL : (_tmp95_ = (vala_ccode_node_unref (_tmp95_), NULL)), _tmp96_);
	_tmp97_ = NULL;
	vala_ccode_function_call_add_argument (object_creation, (ValaCCodeExpression*) (_tmp97_ = vala_ccode_constant_new ("G_TYPE_OBJECT")));
	(_tmp97_ == NULL) ? NULL : (_tmp97_ = (vala_ccode_node_unref (_tmp97_), NULL));
	_tmp98_ = NULL;
	vala_ccode_function_call_add_argument (object_creation, (ValaCCodeExpression*) (_tmp98_ = vala_ccode_constant_new ("0")));
	(_tmp98_ == NULL) ? NULL : (_tmp98_ = (vala_ccode_node_unref (_tmp98_), NULL));
	_tmp99_ = NULL;
	vala_ccode_function_call_add_argument (object_creation, (ValaCCodeExpression*) (_tmp99_ = vala_ccode_constant_new ("NULL")));
	(_tmp99_ == NULL) ? NULL : (_tmp99_ = (vala_ccode_node_unref (_tmp99_), NULL));
	_tmp100_ = NULL;
	_tmp101_ = NULL;
	async_result_creation = (_tmp101_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp100_ = vala_ccode_identifier_new ("g_simple_async_result_new"))), (_tmp100_ == NULL) ? NULL : (_tmp100_ = (vala_ccode_node_unref (_tmp100_), NULL)), _tmp101_);
	vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) object_creation);
	_tmp103_ = NULL;
	_tmp102_ = NULL;
	vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) (_tmp103_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp102_ = vala_ccode_identifier_new ("data")), "callback")));
	(_tmp103_ == NULL) ? NULL : (_tmp103_ = (vala_ccode_node_unref (_tmp103_), NULL));
	(_tmp102_ == NULL) ? NULL : (_tmp102_ = (vala_ccode_node_unref (_tmp102_), NULL));
	_tmp105_ = NULL;
	_tmp104_ = NULL;
	vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) (_tmp105_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp104_ = vala_ccode_identifier_new ("data")), "user_data")));
	(_tmp105_ == NULL) ? NULL : (_tmp105_ = (vala_ccode_node_unref (_tmp105_), NULL));
	(_tmp104_ == NULL) ? NULL : (_tmp104_ = (vala_ccode_node_unref (_tmp104_), NULL));
	_tmp106_ = NULL;
	vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) (_tmp106_ = vala_ccode_identifier_new ("data")));
	(_tmp106_ == NULL) ? NULL : (_tmp106_ = (vala_ccode_node_unref (_tmp106_), NULL));
	_tmp107_ = NULL;
	_tmp108_ = NULL;
	completecall = (_tmp108_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp107_ = vala_ccode_identifier_new ("g_simple_async_result_complete"))), (_tmp107_ == NULL) ? NULL : (_tmp107_ = (vala_ccode_node_unref (_tmp107_), NULL)), _tmp108_);
	vala_ccode_function_call_add_argument (completecall, (ValaCCodeExpression*) async_result_creation);
	_tmp109_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp109_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) completecall)));
	(_tmp109_ == NULL) ? NULL : (_tmp109_ = (vala_ccode_node_unref (_tmp109_), NULL));
	_tmp110_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp110_ = vala_ccode_function_copy (function)));
	(_tmp110_ == NULL) ? NULL : (_tmp110_ = (vala_ccode_node_unref (_tmp110_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	result = proxy_name;
	dbus_iface_name = (g_free (dbus_iface_name), NULL);
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	dataname = (g_free (dataname), NULL);
	(datastruct == NULL) ? NULL : (datastruct = (vala_ccode_node_unref (datastruct), NULL));
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL));
	(postfragment == NULL) ? NULL : (postfragment = (vala_ccode_node_unref (postfragment), NULL));
	(gconnection == NULL) ? NULL : (gconnection = (vala_ccode_node_unref (gconnection), NULL));
	(connection == NULL) ? NULL : (connection = (vala_ccode_node_unref (connection), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(conn_unref == NULL) ? NULL : (conn_unref = (vala_ccode_node_unref (conn_unref), NULL));
	(message_unref == NULL) ? NULL : (message_unref = (vala_ccode_node_unref (message_unref), NULL));
	(dataalloc == NULL) ? NULL : (dataalloc = (vala_ccode_node_unref (dataalloc), NULL));
	(datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL));
	(pending == NULL) ? NULL : (pending = (vala_ccode_node_unref (pending), NULL));
	(object_creation == NULL) ? NULL : (object_creation = (vala_ccode_node_unref (object_creation), NULL));
	(async_result_creation == NULL) ? NULL : (async_result_creation = (vala_ccode_node_unref (async_result_creation), NULL));
	(completecall == NULL) ? NULL : (completecall = (vala_ccode_node_unref (completecall), NULL));
	return result;
}


static char* vala_dbus_client_module_generate_finish_dbus_proxy_method (ValaDBusClientModule* self, ValaInterface* iface, ValaMethod* m) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	char* proxy_name;
	ValaAttribute* _tmp2_;
	char* _tmp3_;
	char* dbus_iface_name;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeFragment* postfragment;
	char* _tmp6_;
	char* _tmp5_;
	char* _tmp7_;
	char* dataname;
	ValaCCodeDeclaration* _tmp9_;
	char* _tmp8_;
	ValaCCodeVariableDeclarator* _tmp10_;
	ValaCCodeDeclaration* _tmp11_;
	ValaCCodeVariableDeclarator* _tmp12_;
	ValaCCodeDeclaration* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeFunctionCall* get_source_tag;
	ValaCCodeCastExpression* _tmp18_;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeExpressionStatement* _tmp21_;
	ValaCCodeAssignment* _tmp20_;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeMemberAccess* _tmp25_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeExpressionStatement* _tmp28_;
	ValaCCodeAssignment* _tmp27_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeFunctionCall* reply_unref;
	ValaCCodeIdentifier* _tmp31_;
	ValaCCodeExpressionStatement* _tmp32_;
	ValaCCodeFunction* _tmp35_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iface != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	proxy_name = (_tmp1_ = g_strdup_printf ("%sdbus_proxy_%s_finish", _tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) m)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	dbus_iface_name = (_tmp3_ = vala_attribute_get_string (_tmp2_ = vala_code_node_get_attribute ((ValaCodeNode*) iface, "DBus"), "name"), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL)), _tmp3_);
	_cdecl_ = NULL;
	function = vala_ccode_function_new (proxy_name, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp4_ = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), _tmp4_ = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, function, NULL, NULL, NULL, 2);
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	postfragment = vala_ccode_fragment_new ();
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	_tmp7_ = NULL;
	dataname = (_tmp7_ = g_strdup_printf ("%sDBusProxy%sData", _tmp5_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), _tmp6_ = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) m))), _tmp6_ = (g_free (_tmp6_), NULL), _tmp5_ = (g_free (_tmp5_), NULL), _tmp7_);
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_cdecl_ = (_tmp9_ = vala_ccode_declaration_new (_tmp8_ = g_strconcat (dataname, "*", NULL)), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp9_);
	_tmp8_ = (g_free (_tmp8_), NULL);
	_tmp10_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp10_ = vala_ccode_variable_declarator_new ("data", NULL, NULL)));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp11_ = NULL;
	_cdecl_ = (_tmp11_ = vala_ccode_declaration_new ("DBusMessage"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp11_);
	_tmp12_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp12_ = vala_ccode_variable_declarator_new ("*_reply", NULL, NULL)));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp13_ = NULL;
	_cdecl_ = (_tmp13_ = vala_ccode_declaration_new ("DBusMessageIter"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp13_);
	_tmp14_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp14_ = vala_ccode_variable_declarator_new ("_iter", NULL, NULL)));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp15_ = NULL;
	_tmp16_ = NULL;
	get_source_tag = (_tmp16_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("g_simple_async_result_get_source_tag"))), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL)), _tmp16_);
	_tmp18_ = NULL;
	_tmp17_ = NULL;
	vala_ccode_function_call_add_argument (get_source_tag, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new ("res")), "GSimpleAsyncResult *")));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	_tmp21_ = NULL;
	_tmp20_ = NULL;
	_tmp19_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp21_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) get_source_tag, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	_tmp22_ = NULL;
	_tmp23_ = NULL;
	ccall = (_tmp23_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("dbus_pending_call_steal_reply"))), (_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL)), _tmp23_);
	_tmp25_ = NULL;
	_tmp24_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("data")), "pending")));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	_tmp28_ = NULL;
	_tmp27_ = NULL;
	_tmp26_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp28_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp27_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new ("_reply")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	vala_dbus_client_module_generate_marshalling (self, m, dbus_iface_name, prefragment, postfragment);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) postfragment);
	_tmp29_ = NULL;
	_tmp30_ = NULL;
	reply_unref = (_tmp30_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("dbus_message_unref"))), (_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL)), _tmp30_);
	_tmp31_ = NULL;
	vala_ccode_function_call_add_argument (reply_unref, (ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new ("_reply")));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	_tmp32_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp32_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) reply_unref)));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeReturnStatement* _tmp34_;
		ValaCCodeIdentifier* _tmp33_;
		_tmp34_ = NULL;
		_tmp33_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp34_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new ("_result")))));
		(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
		(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	}
	_tmp35_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp35_ = vala_ccode_function_copy (function)));
	(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	result = proxy_name;
	dbus_iface_name = (g_free (dbus_iface_name), NULL);
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL));
	(postfragment == NULL) ? NULL : (postfragment = (vala_ccode_node_unref (postfragment), NULL));
	dataname = (g_free (dataname), NULL);
	(get_source_tag == NULL) ? NULL : (get_source_tag = (vala_ccode_node_unref (get_source_tag), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(reply_unref == NULL) ? NULL : (reply_unref = (vala_ccode_node_unref (reply_unref), NULL));
	return result;
}


static char* vala_dbus_client_module_generate_dbus_proxy_property_get (ValaDBusClientModule* self, ValaInterface* iface, ValaProperty* prop) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	char* proxy_name;
	ValaAttribute* _tmp2_;
	char* _tmp3_;
	char* dbus_iface_name;
	ValaDataType* owned_type;
	gboolean _tmp4_;
	ValaArrayType* _tmp6_;
	ValaDataType* _tmp5_;
	ValaArrayType* array_type;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp9_;
	char* _tmp8_;
	char* _tmp7_;
	char* _tmp13_;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeFragment* postfragment;
	ValaCCodeBlock* dispose_return_block;
	ValaCCodeReturnStatement* _tmp15_;
	ValaCCodeExpression* _tmp14_;
	ValaCCodeIfStatement* _tmp21_;
	ValaCCodeMemberAccess* _tmp20_;
	ValaCCodeCastExpression* _tmp19_;
	char* _tmp18_;
	char* _tmp17_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeDeclaration* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeDeclaration* _tmp24_;
	ValaCCodeVariableDeclarator* _tmp25_;
	ValaCCodeVariableDeclarator* _tmp26_;
	ValaCCodeDeclaration* _tmp27_;
	ValaCCodeVariableDeclarator* _tmp28_;
	ValaCCodeVariableDeclarator* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeFunctionCall* destination;
	ValaCCodeCastExpression* _tmp33_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp34_;
	ValaCCodeFunctionCall* _tmp35_;
	ValaCCodeFunctionCall* path;
	ValaCCodeCastExpression* _tmp37_;
	ValaCCodeIdentifier* _tmp36_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* msgcall;
	ValaCCodeConstant* _tmp40_;
	ValaCCodeConstant* _tmp41_;
	ValaCCodeExpressionStatement* _tmp44_;
	ValaCCodeAssignment* _tmp43_;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeUnaryExpression* _tmp49_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeExpressionStatement* _tmp50_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeUnaryExpression* _tmp55_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeExpressionStatement* _tmp56_;
	ValaCCodeConstant* _tmp59_;
	char* _tmp58_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeConstant* _tmp63_;
	char* _tmp62_;
	char* _tmp61_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeDeclaration* _tmp65_;
	char* _tmp64_;
	ValaCCodeVariableDeclarator* _tmp66_;
	ValaCCodeFunctionCall* _tmp73_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeUnaryExpression* _tmp75_;
	ValaCCodeIdentifier* _tmp74_;
	ValaCCodeUnaryExpression* _tmp77_;
	ValaCCodeIdentifier* _tmp76_;
	ValaCCodeExpressionStatement* _tmp78_;
	ValaCCodeIdentifier* target;
	ValaCCodeIdentifier* _tmp79_;
	ValaCCodeExpression* _tmp80_;
	ValaCCodeExpression* expr;
	ValaCCodeExpressionStatement* _tmp82_;
	ValaCCodeAssignment* _tmp81_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeFunctionCall* gconnection;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeConstant* _tmp94_;
	ValaCCodeUnaryExpression* _tmp96_;
	ValaCCodeIdentifier* _tmp95_;
	ValaCCodeConstant* _tmp97_;
	ValaCCodeExpressionStatement* _tmp98_;
	ValaCCodeIdentifier* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeFunctionCall* connection;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeConstant* _tmp105_;
	ValaCCodeConstant* _tmp106_;
	ValaCCodeExpressionStatement* _tmp109_;
	ValaCCodeAssignment* _tmp108_;
	ValaCCodeIdentifier* _tmp107_;
	ValaCCodeIdentifier* _tmp110_;
	ValaCCodeFunctionCall* _tmp111_;
	ValaCCodeFunctionCall* conn_unref;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeExpressionStatement* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeFunctionCall* _tmp115_;
	ValaCCodeFunctionCall* message_unref;
	ValaCCodeIdentifier* _tmp116_;
	ValaCCodeExpressionStatement* _tmp117_;
	ValaCCodeIdentifier* _tmp118_;
	ValaCCodeFunctionCall* _tmp119_;
	ValaCCodeFunctionCall* reply_unref;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeExpressionStatement* _tmp121_;
	ValaCCodeReturnStatement* _tmp123_;
	ValaCCodeIdentifier* _tmp122_;
	ValaCCodeFunction* _tmp124_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iface != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	proxy_name = (_tmp1_ = g_strdup_printf ("%sdbus_proxy_get_%s", _tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) prop)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	dbus_iface_name = (_tmp3_ = vala_attribute_get_string (_tmp2_ = vala_code_node_get_attribute ((ValaCodeNode*) iface, "DBus"), "name"), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL)), _tmp3_);
	owned_type = vala_data_type_copy (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)));
	vala_data_type_set_value_owned (owned_type, TRUE);
	_tmp4_ = FALSE;
	if (vala_data_type_is_disposable (owned_type)) {
		_tmp4_ = !vala_data_type_get_value_owned (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)));
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop))), "Properties used in D-Bus clients require owned get accessor");
	}
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	array_type = (_tmp6_ = (_tmp5_ = vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)), VALA_IS_ARRAY_TYPE (_tmp5_) ? ((ValaArrayType*) _tmp5_) : NULL), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_));
	_cdecl_ = NULL;
	function = vala_ccode_function_new (proxy_name, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp9_ = vala_ccode_formal_parameter_new ("self", _tmp8_ = g_strdup_printf ("%s*", _tmp7_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE))));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp8_ = (g_free (_tmp8_), NULL);
	_tmp7_ = (g_free (_tmp7_), NULL);
	if (array_type != NULL) {
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp10_;
				_tmp10_ = TRUE;
				while (TRUE) {
					ValaCCodeFormalParameter* _tmp12_;
					char* _tmp11_;
					if (!_tmp10_) {
						dim++;
					}
					_tmp10_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					_tmp12_ = NULL;
					_tmp11_ = NULL;
					vala_ccode_function_add_parameter (function, _tmp12_ = vala_ccode_formal_parameter_new (_tmp11_ = g_strdup_printf ("result_length%d", dim), "int*"));
					(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
					_tmp11_ = (g_free (_tmp11_), NULL);
				}
			}
		}
	}
	_tmp13_ = NULL;
	vala_ccode_function_set_return_type (function, _tmp13_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop))));
	_tmp13_ = (g_free (_tmp13_), NULL);
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	postfragment = vala_ccode_fragment_new ();
	dispose_return_block = vala_ccode_block_new ();
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	vala_ccode_block_add_statement (dispose_return_block, (ValaCCodeNode*) (_tmp15_ = vala_ccode_return_statement_new (_tmp14_ = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, vala_property_get_property_type (prop), FALSE))));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	_tmp21_ = NULL;
	_tmp20_ = NULL;
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp21_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("self")), _tmp18_ = g_strconcat (_tmp17_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), "DBusProxy*", NULL))), "disposed")), (ValaCCodeStatement*) dispose_return_block, NULL)));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	_tmp18_ = (g_free (_tmp18_), NULL);
	_tmp17_ = (g_free (_tmp17_), NULL);
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp22_ = NULL;
	_cdecl_ = (_tmp22_ = vala_ccode_declaration_new ("DBusGConnection"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp22_);
	_tmp23_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp23_ = vala_ccode_variable_declarator_new ("*_connection", NULL, NULL)));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp24_ = NULL;
	_cdecl_ = (_tmp24_ = vala_ccode_declaration_new ("DBusMessage"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp24_);
	_tmp25_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp25_ = vala_ccode_variable_declarator_new ("*_message", NULL, NULL)));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	_tmp26_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp26_ = vala_ccode_variable_declarator_new ("*_reply", NULL, NULL)));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp27_ = NULL;
	_cdecl_ = (_tmp27_ = vala_ccode_declaration_new ("DBusMessageIter"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp27_);
	_tmp28_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp28_ = vala_ccode_variable_declarator_new ("_iter", NULL, NULL)));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	_tmp29_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp29_ = vala_ccode_variable_declarator_new ("_subiter", NULL, NULL)));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prefragment);
	_tmp30_ = NULL;
	_tmp31_ = NULL;
	destination = (_tmp31_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("dbus_g_proxy_get_bus_name"))), (_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL)), _tmp31_);
	_tmp33_ = NULL;
	_tmp32_ = NULL;
	vala_ccode_function_call_add_argument (destination, (ValaCCodeExpression*) (_tmp33_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new ("self")), "DBusGProxy*")));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	_tmp34_ = NULL;
	_tmp35_ = NULL;
	path = (_tmp35_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp34_ = vala_ccode_identifier_new ("dbus_g_proxy_get_path"))), (_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL)), _tmp35_);
	_tmp37_ = NULL;
	_tmp36_ = NULL;
	vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp37_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp36_ = vala_ccode_identifier_new ("self")), "DBusGProxy*")));
	(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
	(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
	_tmp38_ = NULL;
	_tmp39_ = NULL;
	msgcall = (_tmp39_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp38_ = vala_ccode_identifier_new ("dbus_message_new_method_call"))), (_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL)), _tmp39_);
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) destination);
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) path);
	_tmp40_ = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp40_ = vala_ccode_constant_new ("\"org.freedesktop.DBus.Properties\"")));
	(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
	_tmp41_ = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_constant_new ("\"Get\"")));
	(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
	_tmp44_ = NULL;
	_tmp43_ = NULL;
	_tmp42_ = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp44_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp43_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp42_ = vala_ccode_identifier_new ("_message")), (ValaCCodeExpression*) msgcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
	(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
	(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
	_tmp45_ = NULL;
	_tmp46_ = NULL;
	iter_call = (_tmp46_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp45_ = vala_ccode_identifier_new ("dbus_message_iter_init_append"))), (_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL)), _tmp46_);
	_tmp47_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp47_ = vala_ccode_identifier_new ("_message")));
	(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
	_tmp49_ = NULL;
	_tmp48_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp49_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp48_ = vala_ccode_identifier_new ("_iter")))));
	(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
	(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
	_tmp50_ = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp50_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
	_tmp52_ = NULL;
	_tmp51_ = NULL;
	iter_call = (_tmp52_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp51_ = vala_ccode_identifier_new ("dbus_message_iter_init"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp52_);
	(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
	_tmp53_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp53_ = vala_ccode_identifier_new ("_reply")));
	(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
	_tmp55_ = NULL;
	_tmp54_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp55_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp54_ = vala_ccode_identifier_new ("_iter")))));
	(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
	(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
	_tmp56_ = NULL;
	vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp56_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
	/* interface name*/
	_tmp59_ = NULL;
	_tmp58_ = NULL;
	_tmp57_ = NULL;
	vala_dbus_module_write_expression ((ValaDBusModule*) self, prefragment, ((ValaCCodeBaseModule*) self)->string_type, (ValaCCodeExpression*) (_tmp57_ = vala_ccode_identifier_new ("_iter")), (ValaCCodeExpression*) (_tmp59_ = vala_ccode_constant_new (_tmp58_ = g_strdup_printf ("\"%s\"", dbus_iface_name))));
	(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
	_tmp58_ = (g_free (_tmp58_), NULL);
	(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
	/* property name*/
	_tmp63_ = NULL;
	_tmp62_ = NULL;
	_tmp61_ = NULL;
	_tmp60_ = NULL;
	vala_dbus_module_write_expression ((ValaDBusModule*) self, prefragment, ((ValaCCodeBaseModule*) self)->string_type, (ValaCCodeExpression*) (_tmp60_ = vala_ccode_identifier_new ("_iter")), (ValaCCodeExpression*) (_tmp63_ = vala_ccode_constant_new (_tmp62_ = g_strdup_printf ("\"%s\"", _tmp61_ = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) prop))))));
	(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
	_tmp62_ = (g_free (_tmp62_), NULL);
	_tmp61_ = (g_free (_tmp61_), NULL);
	(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
	_tmp65_ = NULL;
	_tmp64_ = NULL;
	_cdecl_ = (_tmp65_ = vala_ccode_declaration_new (_tmp64_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)))), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp65_);
	_tmp64_ = (g_free (_tmp64_), NULL);
	_tmp66_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp66_ = vala_ccode_variable_declarator_new ("_result", NULL, NULL)));
	(_tmp66_ == NULL) ? NULL : (_tmp66_ = (vala_ccode_node_unref (_tmp66_), NULL));
	vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) _cdecl_);
	if (array_type != NULL) {
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp67_;
				_tmp67_ = TRUE;
				while (TRUE) {
					ValaCCodeDeclaration* _tmp68_;
					ValaCCodeVariableDeclarator* _tmp71_;
					ValaCCodeConstant* _tmp70_;
					char* _tmp69_;
					if (!_tmp67_) {
						dim++;
					}
					_tmp67_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					_tmp68_ = NULL;
					_cdecl_ = (_tmp68_ = vala_ccode_declaration_new ("int"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp68_);
					_tmp71_ = NULL;
					_tmp70_ = NULL;
					_tmp69_ = NULL;
					vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp71_ = vala_ccode_variable_declarator_new (_tmp69_ = g_strdup_printf ("_result_length%d", dim), (ValaCCodeExpression*) (_tmp70_ = vala_ccode_constant_new ("0")), NULL)));
					(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
					(_tmp70_ == NULL) ? NULL : (_tmp70_ = (vala_ccode_node_unref (_tmp70_), NULL));
					_tmp69_ = (g_free (_tmp69_), NULL);
					vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) _cdecl_);
				}
			}
		}
	}
	_tmp73_ = NULL;
	_tmp72_ = NULL;
	iter_call = (_tmp73_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp72_ = vala_ccode_identifier_new ("dbus_message_iter_recurse"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp73_);
	(_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL));
	_tmp75_ = NULL;
	_tmp74_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp75_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp74_ = vala_ccode_identifier_new ("_iter")))));
	(_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL));
	(_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL));
	_tmp77_ = NULL;
	_tmp76_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp77_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp76_ = vala_ccode_identifier_new ("_subiter")))));
	(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
	(_tmp76_ == NULL) ? NULL : (_tmp76_ = (vala_ccode_node_unref (_tmp76_), NULL));
	_tmp78_ = NULL;
	vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp78_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
	target = vala_ccode_identifier_new ("_result");
	_tmp79_ = NULL;
	_tmp80_ = NULL;
	expr = (_tmp80_ = vala_dbus_module_read_expression ((ValaDBusModule*) self, postfragment, vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop)), (ValaCCodeExpression*) (_tmp79_ = vala_ccode_identifier_new ("_subiter")), (ValaCCodeExpression*) target), (_tmp79_ == NULL) ? NULL : (_tmp79_ = (vala_ccode_node_unref (_tmp79_), NULL)), _tmp80_);
	_tmp82_ = NULL;
	_tmp81_ = NULL;
	vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp82_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp81_ = vala_ccode_assignment_new ((ValaCCodeExpression*) target, expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp82_ == NULL) ? NULL : (_tmp82_ = (vala_ccode_node_unref (_tmp82_), NULL));
	(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_ccode_node_unref (_tmp81_), NULL));
	if (array_type != NULL) {
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp83_;
				_tmp83_ = TRUE;
				while (TRUE) {
					ValaCCodeExpressionStatement* _tmp90_;
					ValaCCodeAssignment* _tmp89_;
					ValaCCodeIdentifier* _tmp88_;
					char* _tmp87_;
					ValaCCodeUnaryExpression* _tmp86_;
					ValaCCodeIdentifier* _tmp85_;
					char* _tmp84_;
					if (!_tmp83_) {
						dim++;
					}
					_tmp83_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					/* TODO check that parameter is not NULL (out parameters are optional)*/
					_tmp90_ = NULL;
					_tmp89_ = NULL;
					_tmp88_ = NULL;
					_tmp87_ = NULL;
					_tmp86_ = NULL;
					_tmp85_ = NULL;
					_tmp84_ = NULL;
					vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp90_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp89_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp86_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp85_ = vala_ccode_identifier_new (_tmp84_ = g_strdup_printf ("result_length%d", dim))))), (ValaCCodeExpression*) (_tmp88_ = vala_ccode_identifier_new (_tmp87_ = g_strdup_printf ("_result_length%d", dim))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_ccode_node_unref (_tmp90_), NULL));
					(_tmp89_ == NULL) ? NULL : (_tmp89_ = (vala_ccode_node_unref (_tmp89_), NULL));
					(_tmp88_ == NULL) ? NULL : (_tmp88_ = (vala_ccode_node_unref (_tmp88_), NULL));
					_tmp87_ = (g_free (_tmp87_), NULL);
					(_tmp86_ == NULL) ? NULL : (_tmp86_ = (vala_ccode_node_unref (_tmp86_), NULL));
					(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
					_tmp84_ = (g_free (_tmp84_), NULL);
				}
			}
		}
	}
	_tmp91_ = NULL;
	_tmp92_ = NULL;
	gconnection = (_tmp92_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp91_ = vala_ccode_identifier_new ("g_object_get"))), (_tmp91_ == NULL) ? NULL : (_tmp91_ = (vala_ccode_node_unref (_tmp91_), NULL)), _tmp92_);
	_tmp93_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp93_ = vala_ccode_identifier_new ("self")));
	(_tmp93_ == NULL) ? NULL : (_tmp93_ = (vala_ccode_node_unref (_tmp93_), NULL));
	_tmp94_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp94_ = vala_ccode_constant_new ("\"connection\"")));
	(_tmp94_ == NULL) ? NULL : (_tmp94_ = (vala_ccode_node_unref (_tmp94_), NULL));
	_tmp96_ = NULL;
	_tmp95_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp96_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp95_ = vala_ccode_identifier_new ("_connection")))));
	(_tmp96_ == NULL) ? NULL : (_tmp96_ = (vala_ccode_node_unref (_tmp96_), NULL));
	(_tmp95_ == NULL) ? NULL : (_tmp95_ = (vala_ccode_node_unref (_tmp95_), NULL));
	_tmp97_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp97_ = vala_ccode_constant_new ("NULL")));
	(_tmp97_ == NULL) ? NULL : (_tmp97_ = (vala_ccode_node_unref (_tmp97_), NULL));
	_tmp98_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp98_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) gconnection)));
	(_tmp98_ == NULL) ? NULL : (_tmp98_ = (vala_ccode_node_unref (_tmp98_), NULL));
	_tmp99_ = NULL;
	_tmp100_ = NULL;
	connection = (_tmp100_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp99_ = vala_ccode_identifier_new ("dbus_g_connection_get_connection"))), (_tmp99_ == NULL) ? NULL : (_tmp99_ = (vala_ccode_node_unref (_tmp99_), NULL)), _tmp100_);
	_tmp101_ = NULL;
	vala_ccode_function_call_add_argument (connection, (ValaCCodeExpression*) (_tmp101_ = vala_ccode_identifier_new ("_connection")));
	(_tmp101_ == NULL) ? NULL : (_tmp101_ = (vala_ccode_node_unref (_tmp101_), NULL));
	_tmp102_ = NULL;
	_tmp103_ = NULL;
	ccall = (_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp102_ = vala_ccode_identifier_new ("dbus_connection_send_with_reply_and_block"))), (_tmp102_ == NULL) ? NULL : (_tmp102_ = (vala_ccode_node_unref (_tmp102_), NULL)), _tmp103_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) connection);
	_tmp104_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp104_ = vala_ccode_identifier_new ("_message")));
	(_tmp104_ == NULL) ? NULL : (_tmp104_ = (vala_ccode_node_unref (_tmp104_), NULL));
	_tmp105_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp105_ = vala_ccode_constant_new ("-1")));
	(_tmp105_ == NULL) ? NULL : (_tmp105_ = (vala_ccode_node_unref (_tmp105_), NULL));
	_tmp106_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp106_ = vala_ccode_constant_new ("NULL")));
	(_tmp106_ == NULL) ? NULL : (_tmp106_ = (vala_ccode_node_unref (_tmp106_), NULL));
	_tmp109_ = NULL;
	_tmp108_ = NULL;
	_tmp107_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp109_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp108_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp107_ = vala_ccode_identifier_new ("_reply")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp109_ == NULL) ? NULL : (_tmp109_ = (vala_ccode_node_unref (_tmp109_), NULL));
	(_tmp108_ == NULL) ? NULL : (_tmp108_ = (vala_ccode_node_unref (_tmp108_), NULL));
	(_tmp107_ == NULL) ? NULL : (_tmp107_ = (vala_ccode_node_unref (_tmp107_), NULL));
	_tmp110_ = NULL;
	_tmp111_ = NULL;
	conn_unref = (_tmp111_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp110_ = vala_ccode_identifier_new ("dbus_g_connection_unref"))), (_tmp110_ == NULL) ? NULL : (_tmp110_ = (vala_ccode_node_unref (_tmp110_), NULL)), _tmp111_);
	_tmp112_ = NULL;
	vala_ccode_function_call_add_argument (conn_unref, (ValaCCodeExpression*) (_tmp112_ = vala_ccode_identifier_new ("_connection")));
	(_tmp112_ == NULL) ? NULL : (_tmp112_ = (vala_ccode_node_unref (_tmp112_), NULL));
	_tmp113_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp113_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) conn_unref)));
	(_tmp113_ == NULL) ? NULL : (_tmp113_ = (vala_ccode_node_unref (_tmp113_), NULL));
	_tmp114_ = NULL;
	_tmp115_ = NULL;
	message_unref = (_tmp115_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp114_ = vala_ccode_identifier_new ("dbus_message_unref"))), (_tmp114_ == NULL) ? NULL : (_tmp114_ = (vala_ccode_node_unref (_tmp114_), NULL)), _tmp115_);
	_tmp116_ = NULL;
	vala_ccode_function_call_add_argument (message_unref, (ValaCCodeExpression*) (_tmp116_ = vala_ccode_identifier_new ("_message")));
	(_tmp116_ == NULL) ? NULL : (_tmp116_ = (vala_ccode_node_unref (_tmp116_), NULL));
	_tmp117_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp117_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) message_unref)));
	(_tmp117_ == NULL) ? NULL : (_tmp117_ = (vala_ccode_node_unref (_tmp117_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) postfragment);
	_tmp118_ = NULL;
	_tmp119_ = NULL;
	reply_unref = (_tmp119_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp118_ = vala_ccode_identifier_new ("dbus_message_unref"))), (_tmp118_ == NULL) ? NULL : (_tmp118_ = (vala_ccode_node_unref (_tmp118_), NULL)), _tmp119_);
	_tmp120_ = NULL;
	vala_ccode_function_call_add_argument (reply_unref, (ValaCCodeExpression*) (_tmp120_ = vala_ccode_identifier_new ("_reply")));
	(_tmp120_ == NULL) ? NULL : (_tmp120_ = (vala_ccode_node_unref (_tmp120_), NULL));
	_tmp121_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp121_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) reply_unref)));
	(_tmp121_ == NULL) ? NULL : (_tmp121_ = (vala_ccode_node_unref (_tmp121_), NULL));
	_tmp123_ = NULL;
	_tmp122_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp123_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp122_ = vala_ccode_identifier_new ("_result")))));
	(_tmp123_ == NULL) ? NULL : (_tmp123_ = (vala_ccode_node_unref (_tmp123_), NULL));
	(_tmp122_ == NULL) ? NULL : (_tmp122_ = (vala_ccode_node_unref (_tmp122_), NULL));
	_tmp124_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp124_ = vala_ccode_function_copy (function)));
	(_tmp124_ == NULL) ? NULL : (_tmp124_ = (vala_ccode_node_unref (_tmp124_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	result = proxy_name;
	dbus_iface_name = (g_free (dbus_iface_name), NULL);
	(owned_type == NULL) ? NULL : (owned_type = (vala_code_node_unref (owned_type), NULL));
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL));
	(postfragment == NULL) ? NULL : (postfragment = (vala_ccode_node_unref (postfragment), NULL));
	(dispose_return_block == NULL) ? NULL : (dispose_return_block = (vala_ccode_node_unref (dispose_return_block), NULL));
	(destination == NULL) ? NULL : (destination = (vala_ccode_node_unref (destination), NULL));
	(path == NULL) ? NULL : (path = (vala_ccode_node_unref (path), NULL));
	(msgcall == NULL) ? NULL : (msgcall = (vala_ccode_node_unref (msgcall), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
	(target == NULL) ? NULL : (target = (vala_ccode_node_unref (target), NULL));
	(expr == NULL) ? NULL : (expr = (vala_ccode_node_unref (expr), NULL));
	(gconnection == NULL) ? NULL : (gconnection = (vala_ccode_node_unref (gconnection), NULL));
	(connection == NULL) ? NULL : (connection = (vala_ccode_node_unref (connection), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(conn_unref == NULL) ? NULL : (conn_unref = (vala_ccode_node_unref (conn_unref), NULL));
	(message_unref == NULL) ? NULL : (message_unref = (vala_ccode_node_unref (message_unref), NULL));
	(reply_unref == NULL) ? NULL : (reply_unref = (vala_ccode_node_unref (reply_unref), NULL));
	return result;
}


static char* vala_dbus_client_module_generate_dbus_proxy_property_set (ValaDBusClientModule* self, ValaInterface* iface, ValaProperty* prop) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	char* proxy_name;
	ValaAttribute* _tmp2_;
	char* _tmp3_;
	char* dbus_iface_name;
	ValaArrayType* _tmp5_;
	ValaDataType* _tmp4_;
	ValaArrayType* array_type;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp8_;
	char* _tmp7_;
	char* _tmp6_;
	ValaCCodeFormalParameter* _tmp10_;
	char* _tmp9_;
	ValaCCodeBlock* block;
	ValaCCodeFragment* prefragment;
	ValaCCodeFragment* postfragment;
	ValaCCodeBlock* dispose_return_block;
	ValaCCodeReturnStatement* _tmp14_;
	ValaCCodeIfStatement* _tmp20_;
	ValaCCodeMemberAccess* _tmp19_;
	ValaCCodeCastExpression* _tmp18_;
	char* _tmp17_;
	char* _tmp16_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeDeclaration* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeDeclaration* _tmp23_;
	ValaCCodeVariableDeclarator* _tmp24_;
	ValaCCodeVariableDeclarator* _tmp25_;
	ValaCCodeDeclaration* _tmp26_;
	ValaCCodeVariableDeclarator* _tmp27_;
	ValaCCodeVariableDeclarator* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeFunctionCall* destination;
	ValaCCodeCastExpression* _tmp32_;
	ValaCCodeIdentifier* _tmp31_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunctionCall* _tmp34_;
	ValaCCodeFunctionCall* path;
	ValaCCodeCastExpression* _tmp36_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeFunctionCall* _tmp38_;
	ValaCCodeFunctionCall* msgcall;
	ValaCCodeConstant* _tmp39_;
	ValaCCodeConstant* _tmp40_;
	ValaCCodeExpressionStatement* _tmp43_;
	ValaCCodeAssignment* _tmp42_;
	ValaCCodeIdentifier* _tmp41_;
	ValaCCodeIdentifier* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* iter_call;
	ValaCCodeIdentifier* _tmp46_;
	ValaCCodeUnaryExpression* _tmp48_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeExpressionStatement* _tmp49_;
	ValaCCodeFunctionCall* _tmp51_;
	ValaCCodeIdentifier* _tmp50_;
	ValaCCodeIdentifier* _tmp52_;
	ValaCCodeUnaryExpression* _tmp54_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeExpressionStatement* _tmp55_;
	ValaCCodeConstant* _tmp58_;
	char* _tmp57_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeConstant* _tmp62_;
	char* _tmp61_;
	char* _tmp60_;
	ValaCCodeIdentifier* _tmp59_;
	ValaCCodeFunctionCall* _tmp64_;
	ValaCCodeIdentifier* _tmp63_;
	ValaCCodeUnaryExpression* _tmp66_;
	ValaCCodeIdentifier* _tmp65_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeConstant* _tmp70_;
	char* _tmp69_;
	char* _tmp68_;
	ValaCCodeUnaryExpression* _tmp72_;
	ValaCCodeIdentifier* _tmp71_;
	ValaCCodeExpressionStatement* _tmp73_;
	ValaCCodeIdentifier* _tmp75_;
	ValaCCodeIdentifier* _tmp74_;
	ValaCCodeFunctionCall* _tmp77_;
	ValaCCodeIdentifier* _tmp76_;
	ValaCCodeUnaryExpression* _tmp79_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeUnaryExpression* _tmp81_;
	ValaCCodeIdentifier* _tmp80_;
	ValaCCodeExpressionStatement* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunctionCall* _tmp84_;
	ValaCCodeFunctionCall* gconnection;
	ValaCCodeIdentifier* _tmp85_;
	ValaCCodeConstant* _tmp86_;
	ValaCCodeUnaryExpression* _tmp88_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeConstant* _tmp89_;
	ValaCCodeExpressionStatement* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeFunctionCall* connection;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeConstant* _tmp97_;
	ValaCCodeConstant* _tmp98_;
	ValaCCodeExpressionStatement* _tmp101_;
	ValaCCodeAssignment* _tmp100_;
	ValaCCodeIdentifier* _tmp99_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* conn_unref;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeExpressionStatement* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeFunctionCall* message_unref;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeExpressionStatement* _tmp109_;
	ValaCCodeIdentifier* _tmp110_;
	ValaCCodeFunctionCall* _tmp111_;
	ValaCCodeFunctionCall* reply_unref;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeExpressionStatement* _tmp113_;
	ValaCCodeFunction* _tmp114_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iface != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	proxy_name = (_tmp1_ = g_strdup_printf ("%sdbus_proxy_set_%s", _tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) iface), vala_symbol_get_name ((ValaSymbol*) prop)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	dbus_iface_name = (_tmp3_ = vala_attribute_get_string (_tmp2_ = vala_code_node_get_attribute ((ValaCodeNode*) iface, "DBus"), "name"), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL)), _tmp3_);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	array_type = (_tmp5_ = (_tmp4_ = vala_property_accessor_get_value_type (vala_property_get_set_accessor (prop)), VALA_IS_ARRAY_TYPE (_tmp4_) ? ((ValaArrayType*) _tmp4_) : NULL), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_));
	_cdecl_ = NULL;
	function = vala_ccode_function_new (proxy_name, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp8_ = vala_ccode_formal_parameter_new ("self", _tmp7_ = g_strdup_printf ("%s*", _tmp6_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE))));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp10_ = vala_ccode_formal_parameter_new ("value", _tmp9_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (vala_property_get_set_accessor (prop)))));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp9_ = (g_free (_tmp9_), NULL);
	if (array_type != NULL) {
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp11_;
				_tmp11_ = TRUE;
				while (TRUE) {
					ValaCCodeFormalParameter* _tmp13_;
					char* _tmp12_;
					if (!_tmp11_) {
						dim++;
					}
					_tmp11_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					_tmp13_ = NULL;
					_tmp12_ = NULL;
					vala_ccode_function_add_parameter (function, _tmp13_ = vala_ccode_formal_parameter_new (_tmp12_ = g_strdup_printf ("value_length%d", dim), "int"));
					(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
					_tmp12_ = (g_free (_tmp12_), NULL);
				}
			}
		}
	}
	block = vala_ccode_block_new ();
	prefragment = vala_ccode_fragment_new ();
	postfragment = vala_ccode_fragment_new ();
	dispose_return_block = vala_ccode_block_new ();
	_tmp14_ = NULL;
	vala_ccode_block_add_statement (dispose_return_block, (ValaCCodeNode*) (_tmp14_ = vala_ccode_return_statement_new (NULL)));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	_tmp20_ = NULL;
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	_tmp15_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp20_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("self")), _tmp17_ = g_strconcat (_tmp16_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), "DBusProxy*", NULL))), "disposed")), (ValaCCodeStatement*) dispose_return_block, NULL)));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	_tmp17_ = (g_free (_tmp17_), NULL);
	_tmp16_ = (g_free (_tmp16_), NULL);
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	_tmp21_ = NULL;
	_cdecl_ = (_tmp21_ = vala_ccode_declaration_new ("DBusGConnection"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp21_);
	_tmp22_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp22_ = vala_ccode_variable_declarator_new ("*_connection", NULL, NULL)));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp23_ = NULL;
	_cdecl_ = (_tmp23_ = vala_ccode_declaration_new ("DBusMessage"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp23_);
	_tmp24_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp24_ = vala_ccode_variable_declarator_new ("*_message", NULL, NULL)));
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	_tmp25_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp25_ = vala_ccode_variable_declarator_new ("*_reply", NULL, NULL)));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp26_ = NULL;
	_cdecl_ = (_tmp26_ = vala_ccode_declaration_new ("DBusMessageIter"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp26_);
	_tmp27_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp27_ = vala_ccode_variable_declarator_new ("_iter", NULL, NULL)));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	_tmp28_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp28_ = vala_ccode_variable_declarator_new ("_subiter", NULL, NULL)));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) prefragment);
	_tmp29_ = NULL;
	_tmp30_ = NULL;
	destination = (_tmp30_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("dbus_g_proxy_get_bus_name"))), (_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL)), _tmp30_);
	_tmp32_ = NULL;
	_tmp31_ = NULL;
	vala_ccode_function_call_add_argument (destination, (ValaCCodeExpression*) (_tmp32_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new ("self")), "DBusGProxy*")));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	_tmp33_ = NULL;
	_tmp34_ = NULL;
	path = (_tmp34_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new ("dbus_g_proxy_get_path"))), (_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL)), _tmp34_);
	_tmp36_ = NULL;
	_tmp35_ = NULL;
	vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp36_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new ("self")), "DBusGProxy*")));
	(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
	(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
	_tmp37_ = NULL;
	_tmp38_ = NULL;
	msgcall = (_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new ("dbus_message_new_method_call"))), (_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL)), _tmp38_);
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) destination);
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) path);
	_tmp39_ = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_constant_new ("\"org.freedesktop.DBus.Properties\"")));
	(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
	_tmp40_ = NULL;
	vala_ccode_function_call_add_argument (msgcall, (ValaCCodeExpression*) (_tmp40_ = vala_ccode_constant_new ("\"Set\"")));
	(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
	_tmp43_ = NULL;
	_tmp42_ = NULL;
	_tmp41_ = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp43_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp42_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp41_ = vala_ccode_identifier_new ("_message")), (ValaCCodeExpression*) msgcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
	(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
	(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
	_tmp44_ = NULL;
	_tmp45_ = NULL;
	iter_call = (_tmp45_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp44_ = vala_ccode_identifier_new ("dbus_message_iter_init_append"))), (_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL)), _tmp45_);
	_tmp46_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp46_ = vala_ccode_identifier_new ("_message")));
	(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
	_tmp48_ = NULL;
	_tmp47_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp48_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp47_ = vala_ccode_identifier_new ("_iter")))));
	(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
	(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
	_tmp49_ = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp49_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
	_tmp51_ = NULL;
	_tmp50_ = NULL;
	iter_call = (_tmp51_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp50_ = vala_ccode_identifier_new ("dbus_message_iter_init"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp51_);
	(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
	_tmp52_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp52_ = vala_ccode_identifier_new ("_reply")));
	(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
	_tmp54_ = NULL;
	_tmp53_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp54_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp53_ = vala_ccode_identifier_new ("_iter")))));
	(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
	(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
	_tmp55_ = NULL;
	vala_ccode_fragment_append (postfragment, (ValaCCodeNode*) (_tmp55_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
	/* interface name*/
	_tmp58_ = NULL;
	_tmp57_ = NULL;
	_tmp56_ = NULL;
	vala_dbus_module_write_expression ((ValaDBusModule*) self, prefragment, ((ValaCCodeBaseModule*) self)->string_type, (ValaCCodeExpression*) (_tmp56_ = vala_ccode_identifier_new ("_iter")), (ValaCCodeExpression*) (_tmp58_ = vala_ccode_constant_new (_tmp57_ = g_strdup_printf ("\"%s\"", dbus_iface_name))));
	(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
	_tmp57_ = (g_free (_tmp57_), NULL);
	(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
	/* property name*/
	_tmp62_ = NULL;
	_tmp61_ = NULL;
	_tmp60_ = NULL;
	_tmp59_ = NULL;
	vala_dbus_module_write_expression ((ValaDBusModule*) self, prefragment, ((ValaCCodeBaseModule*) self)->string_type, (ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new ("_iter")), (ValaCCodeExpression*) (_tmp62_ = vala_ccode_constant_new (_tmp61_ = g_strdup_printf ("\"%s\"", _tmp60_ = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name ((ValaSymbol*) prop))))));
	(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
	_tmp61_ = (g_free (_tmp61_), NULL);
	_tmp60_ = (g_free (_tmp60_), NULL);
	(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
	/* property value (as variant)*/
	_tmp64_ = NULL;
	_tmp63_ = NULL;
	iter_call = (_tmp64_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp63_ = vala_ccode_identifier_new ("dbus_message_iter_open_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp64_);
	(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
	_tmp66_ = NULL;
	_tmp65_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp66_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp65_ = vala_ccode_identifier_new ("_iter")))));
	(_tmp66_ == NULL) ? NULL : (_tmp66_ = (vala_ccode_node_unref (_tmp66_), NULL));
	(_tmp65_ == NULL) ? NULL : (_tmp65_ = (vala_ccode_node_unref (_tmp65_), NULL));
	_tmp67_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp67_ = vala_ccode_identifier_new ("DBUS_TYPE_VARIANT")));
	(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
	_tmp70_ = NULL;
	_tmp69_ = NULL;
	_tmp68_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp70_ = vala_ccode_constant_new (_tmp69_ = g_strdup_printf ("\"%s\"", _tmp68_ = vala_data_type_get_type_signature (vala_property_get_property_type (prop))))));
	(_tmp70_ == NULL) ? NULL : (_tmp70_ = (vala_ccode_node_unref (_tmp70_), NULL));
	_tmp69_ = (g_free (_tmp69_), NULL);
	_tmp68_ = (g_free (_tmp68_), NULL);
	_tmp72_ = NULL;
	_tmp71_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp72_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp71_ = vala_ccode_identifier_new ("_subiter")))));
	(_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL));
	(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
	_tmp73_ = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp73_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp73_ == NULL) ? NULL : (_tmp73_ = (vala_ccode_node_unref (_tmp73_), NULL));
	_tmp75_ = NULL;
	_tmp74_ = NULL;
	vala_dbus_module_write_expression ((ValaDBusModule*) self, prefragment, vala_property_accessor_get_value_type (vala_property_get_set_accessor (prop)), (ValaCCodeExpression*) (_tmp74_ = vala_ccode_identifier_new ("_subiter")), (ValaCCodeExpression*) (_tmp75_ = vala_ccode_identifier_new ("value")));
	(_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL));
	(_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL));
	_tmp77_ = NULL;
	_tmp76_ = NULL;
	iter_call = (_tmp77_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp76_ = vala_ccode_identifier_new ("dbus_message_iter_close_container"))), (iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL)), _tmp77_);
	(_tmp76_ == NULL) ? NULL : (_tmp76_ = (vala_ccode_node_unref (_tmp76_), NULL));
	_tmp79_ = NULL;
	_tmp78_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp79_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp78_ = vala_ccode_identifier_new ("_iter")))));
	(_tmp79_ == NULL) ? NULL : (_tmp79_ = (vala_ccode_node_unref (_tmp79_), NULL));
	(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
	_tmp81_ = NULL;
	_tmp80_ = NULL;
	vala_ccode_function_call_add_argument (iter_call, (ValaCCodeExpression*) (_tmp81_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp80_ = vala_ccode_identifier_new ("_subiter")))));
	(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_ccode_node_unref (_tmp81_), NULL));
	(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
	_tmp82_ = NULL;
	vala_ccode_fragment_append (prefragment, (ValaCCodeNode*) (_tmp82_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) iter_call)));
	(_tmp82_ == NULL) ? NULL : (_tmp82_ = (vala_ccode_node_unref (_tmp82_), NULL));
	_tmp83_ = NULL;
	_tmp84_ = NULL;
	gconnection = (_tmp84_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp83_ = vala_ccode_identifier_new ("g_object_get"))), (_tmp83_ == NULL) ? NULL : (_tmp83_ = (vala_ccode_node_unref (_tmp83_), NULL)), _tmp84_);
	_tmp85_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp85_ = vala_ccode_identifier_new ("self")));
	(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
	_tmp86_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp86_ = vala_ccode_constant_new ("\"connection\"")));
	(_tmp86_ == NULL) ? NULL : (_tmp86_ = (vala_ccode_node_unref (_tmp86_), NULL));
	_tmp88_ = NULL;
	_tmp87_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp88_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp87_ = vala_ccode_identifier_new ("_connection")))));
	(_tmp88_ == NULL) ? NULL : (_tmp88_ = (vala_ccode_node_unref (_tmp88_), NULL));
	(_tmp87_ == NULL) ? NULL : (_tmp87_ = (vala_ccode_node_unref (_tmp87_), NULL));
	_tmp89_ = NULL;
	vala_ccode_function_call_add_argument (gconnection, (ValaCCodeExpression*) (_tmp89_ = vala_ccode_constant_new ("NULL")));
	(_tmp89_ == NULL) ? NULL : (_tmp89_ = (vala_ccode_node_unref (_tmp89_), NULL));
	_tmp90_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp90_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) gconnection)));
	(_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_ccode_node_unref (_tmp90_), NULL));
	_tmp91_ = NULL;
	_tmp92_ = NULL;
	connection = (_tmp92_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp91_ = vala_ccode_identifier_new ("dbus_g_connection_get_connection"))), (_tmp91_ == NULL) ? NULL : (_tmp91_ = (vala_ccode_node_unref (_tmp91_), NULL)), _tmp92_);
	_tmp93_ = NULL;
	vala_ccode_function_call_add_argument (connection, (ValaCCodeExpression*) (_tmp93_ = vala_ccode_identifier_new ("_connection")));
	(_tmp93_ == NULL) ? NULL : (_tmp93_ = (vala_ccode_node_unref (_tmp93_), NULL));
	_tmp94_ = NULL;
	_tmp95_ = NULL;
	ccall = (_tmp95_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp94_ = vala_ccode_identifier_new ("dbus_connection_send_with_reply_and_block"))), (_tmp94_ == NULL) ? NULL : (_tmp94_ = (vala_ccode_node_unref (_tmp94_), NULL)), _tmp95_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) connection);
	_tmp96_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp96_ = vala_ccode_identifier_new ("_message")));
	(_tmp96_ == NULL) ? NULL : (_tmp96_ = (vala_ccode_node_unref (_tmp96_), NULL));
	_tmp97_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp97_ = vala_ccode_constant_new ("-1")));
	(_tmp97_ == NULL) ? NULL : (_tmp97_ = (vala_ccode_node_unref (_tmp97_), NULL));
	_tmp98_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp98_ = vala_ccode_constant_new ("NULL")));
	(_tmp98_ == NULL) ? NULL : (_tmp98_ = (vala_ccode_node_unref (_tmp98_), NULL));
	_tmp101_ = NULL;
	_tmp100_ = NULL;
	_tmp99_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp101_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp100_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp99_ = vala_ccode_identifier_new ("_reply")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp101_ == NULL) ? NULL : (_tmp101_ = (vala_ccode_node_unref (_tmp101_), NULL));
	(_tmp100_ == NULL) ? NULL : (_tmp100_ = (vala_ccode_node_unref (_tmp100_), NULL));
	(_tmp99_ == NULL) ? NULL : (_tmp99_ = (vala_ccode_node_unref (_tmp99_), NULL));
	_tmp102_ = NULL;
	_tmp103_ = NULL;
	conn_unref = (_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp102_ = vala_ccode_identifier_new ("dbus_g_connection_unref"))), (_tmp102_ == NULL) ? NULL : (_tmp102_ = (vala_ccode_node_unref (_tmp102_), NULL)), _tmp103_);
	_tmp104_ = NULL;
	vala_ccode_function_call_add_argument (conn_unref, (ValaCCodeExpression*) (_tmp104_ = vala_ccode_identifier_new ("_connection")));
	(_tmp104_ == NULL) ? NULL : (_tmp104_ = (vala_ccode_node_unref (_tmp104_), NULL));
	_tmp105_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp105_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) conn_unref)));
	(_tmp105_ == NULL) ? NULL : (_tmp105_ = (vala_ccode_node_unref (_tmp105_), NULL));
	_tmp106_ = NULL;
	_tmp107_ = NULL;
	message_unref = (_tmp107_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp106_ = vala_ccode_identifier_new ("dbus_message_unref"))), (_tmp106_ == NULL) ? NULL : (_tmp106_ = (vala_ccode_node_unref (_tmp106_), NULL)), _tmp107_);
	_tmp108_ = NULL;
	vala_ccode_function_call_add_argument (message_unref, (ValaCCodeExpression*) (_tmp108_ = vala_ccode_identifier_new ("_message")));
	(_tmp108_ == NULL) ? NULL : (_tmp108_ = (vala_ccode_node_unref (_tmp108_), NULL));
	_tmp109_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp109_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) message_unref)));
	(_tmp109_ == NULL) ? NULL : (_tmp109_ = (vala_ccode_node_unref (_tmp109_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) postfragment);
	_tmp110_ = NULL;
	_tmp111_ = NULL;
	reply_unref = (_tmp111_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp110_ = vala_ccode_identifier_new ("dbus_message_unref"))), (_tmp110_ == NULL) ? NULL : (_tmp110_ = (vala_ccode_node_unref (_tmp110_), NULL)), _tmp111_);
	_tmp112_ = NULL;
	vala_ccode_function_call_add_argument (reply_unref, (ValaCCodeExpression*) (_tmp112_ = vala_ccode_identifier_new ("_reply")));
	(_tmp112_ == NULL) ? NULL : (_tmp112_ = (vala_ccode_node_unref (_tmp112_), NULL));
	_tmp113_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp113_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) reply_unref)));
	(_tmp113_ == NULL) ? NULL : (_tmp113_ = (vala_ccode_node_unref (_tmp113_), NULL));
	_tmp114_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp114_ = vala_ccode_function_copy (function)));
	(_tmp114_ == NULL) ? NULL : (_tmp114_ = (vala_ccode_node_unref (_tmp114_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	result = proxy_name;
	dbus_iface_name = (g_free (dbus_iface_name), NULL);
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(prefragment == NULL) ? NULL : (prefragment = (vala_ccode_node_unref (prefragment), NULL));
	(postfragment == NULL) ? NULL : (postfragment = (vala_ccode_node_unref (postfragment), NULL));
	(dispose_return_block == NULL) ? NULL : (dispose_return_block = (vala_ccode_node_unref (dispose_return_block), NULL));
	(destination == NULL) ? NULL : (destination = (vala_ccode_node_unref (destination), NULL));
	(path == NULL) ? NULL : (path = (vala_ccode_node_unref (path), NULL));
	(msgcall == NULL) ? NULL : (msgcall = (vala_ccode_node_unref (msgcall), NULL));
	(iter_call == NULL) ? NULL : (iter_call = (vala_ccode_node_unref (iter_call), NULL));
	(gconnection == NULL) ? NULL : (gconnection = (vala_ccode_node_unref (gconnection), NULL));
	(connection == NULL) ? NULL : (connection = (vala_ccode_node_unref (connection), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(conn_unref == NULL) ? NULL : (conn_unref = (vala_ccode_node_unref (conn_unref), NULL));
	(message_unref == NULL) ? NULL : (message_unref = (vala_ccode_node_unref (message_unref), NULL));
	(reply_unref == NULL) ? NULL : (reply_unref = (vala_ccode_node_unref (reply_unref), NULL));
	return result;
}


static void vala_dbus_client_module_class_init (ValaDBusClientModuleClass * klass) {
	vala_dbus_client_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->finalize = vala_dbus_client_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaDBusClientModulePrivate));
	VALA_CCODE_MODULE_CLASS (klass)->generate_dynamic_method_wrapper = vala_dbus_client_module_real_generate_dynamic_method_wrapper;
	VALA_GSIGNAL_MODULE_CLASS (klass)->get_dbus_g_type = vala_dbus_client_module_real_get_dbus_g_type;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_property_getter_cname = vala_dbus_client_module_real_get_dynamic_property_getter_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_property_setter_cname = vala_dbus_client_module_real_get_dynamic_property_setter_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_signal_connect_wrapper_name = vala_dbus_client_module_real_get_dynamic_signal_connect_wrapper_name;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_signal_disconnect_wrapper_name = vala_dbus_client_module_real_get_dynamic_signal_disconnect_wrapper_name;
	VALA_CCODE_MODULE_CLASS (klass)->visit_cast_expression = vala_dbus_client_module_real_visit_cast_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_interface = vala_dbus_client_module_real_visit_interface;
	VALA_GTYPE_MODULE_CLASS (klass)->create_interface_register_function = vala_dbus_client_module_real_create_interface_register_function;
	VALA_CCODE_MODULE_CLASS (klass)->visit_method_call = vala_dbus_client_module_real_visit_method_call;
}


static void vala_dbus_client_module_instance_init (ValaDBusClientModule * self) {
	self->priv = VALA_DBUS_CLIENT_MODULE_GET_PRIVATE (self);
}


static void vala_dbus_client_module_finalize (ValaCCodeModule* obj) {
	ValaDBusClientModule * self;
	self = VALA_DBUS_CLIENT_MODULE (obj);
	VALA_CCODE_MODULE_CLASS (vala_dbus_client_module_parent_class)->finalize (obj);
}


GType vala_dbus_client_module_get_type (void) {
	static GType vala_dbus_client_module_type_id = 0;
	if (vala_dbus_client_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDBusClientModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dbus_client_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDBusClientModule), 0, (GInstanceInitFunc) vala_dbus_client_module_instance_init, NULL };
		vala_dbus_client_module_type_id = g_type_register_static (VALA_TYPE_DBUS_MODULE, "ValaDBusClientModule", &g_define_type_info, 0);
	}
	return vala_dbus_client_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




