/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaExpressionPrivate ValaExpressionPrivate;

#define VALA_TYPE_OBJECT_CREATION_EXPRESSION (vala_object_creation_expression_get_type ())
#define VALA_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression))
#define VALA_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))
#define VALA_IS_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_IS_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_OBJECT_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))

typedef struct _ValaObjectCreationExpression ValaObjectCreationExpression;
typedef struct _ValaObjectCreationExpressionClass ValaObjectCreationExpressionClass;
typedef struct _ValaObjectCreationExpressionPrivate ValaObjectCreationExpressionPrivate;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_MEMBER_INITIALIZER (vala_member_initializer_get_type ())
#define VALA_MEMBER_INITIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer))
#define VALA_MEMBER_INITIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializerClass))
#define VALA_IS_MEMBER_INITIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_INITIALIZER))
#define VALA_IS_MEMBER_INITIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_INITIALIZER))
#define VALA_MEMBER_INITIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializerClass))

typedef struct _ValaMemberInitializer ValaMemberInitializer;
typedef struct _ValaMemberInitializerClass ValaMemberInitializerClass;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_OBJECT_TYPE (vala_object_type_get_type ())
#define VALA_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectType))
#define VALA_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))
#define VALA_IS_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE))
#define VALA_IS_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE))
#define VALA_OBJECT_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))

typedef struct _ValaObjectType ValaObjectType;
typedef struct _ValaObjectTypeClass ValaObjectTypeClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_STRUCT_VALUE_TYPE (vala_struct_value_type_get_type ())
#define VALA_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType))
#define VALA_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))
#define VALA_IS_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_IS_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_STRUCT_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))

typedef struct _ValaStructValueType ValaStructValueType;
typedef struct _ValaStructValueTypeClass ValaStructValueTypeClass;

#define VALA_TYPE_ERROR_CODE (vala_error_code_get_type ())
#define VALA_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCode))
#define VALA_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))
#define VALA_IS_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_CODE))
#define VALA_IS_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_CODE))
#define VALA_ERROR_CODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))

typedef struct _ValaErrorCode ValaErrorCode;
typedef struct _ValaErrorCodeClass ValaErrorCodeClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_ERROR_TYPE (vala_error_type_get_type ())
#define VALA_ERROR_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_TYPE, ValaErrorType))
#define VALA_ERROR_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_TYPE, ValaErrorTypeClass))
#define VALA_IS_ERROR_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_TYPE))
#define VALA_IS_ERROR_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_TYPE))
#define VALA_ERROR_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_TYPE, ValaErrorTypeClass))

typedef struct _ValaErrorType ValaErrorType;
typedef struct _ValaErrorTypeClass ValaErrorTypeClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_METHOD_TYPE (vala_method_type_get_type ())
#define VALA_METHOD_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_TYPE, ValaMethodType))
#define VALA_METHOD_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_TYPE, ValaMethodTypeClass))
#define VALA_IS_METHOD_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_TYPE))
#define VALA_IS_METHOD_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_TYPE))
#define VALA_METHOD_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_TYPE, ValaMethodTypeClass))

typedef struct _ValaMethodType ValaMethodType;
typedef struct _ValaMethodTypeClass ValaMethodTypeClass;
typedef struct _ValaCodeVisitorPrivate ValaCodeVisitorPrivate;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ENUM_VALUE (vala_enum_value_get_type ())
#define VALA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValue))
#define VALA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))
#define VALA_IS_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE))
#define VALA_IS_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE))
#define VALA_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))

typedef struct _ValaEnumValue ValaEnumValue;
typedef struct _ValaEnumValueClass ValaEnumValueClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

#define VALA_TYPE_EMPTY_STATEMENT (vala_empty_statement_get_type ())
#define VALA_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatement))
#define VALA_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))
#define VALA_IS_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_IS_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_EMPTY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))

typedef struct _ValaEmptyStatement ValaEmptyStatement;
typedef struct _ValaEmptyStatementClass ValaEmptyStatementClass;

#define VALA_TYPE_DECLARATION_STATEMENT (vala_declaration_statement_get_type ())
#define VALA_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatement))
#define VALA_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))
#define VALA_IS_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_IS_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_DECLARATION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))

typedef struct _ValaDeclarationStatement ValaDeclarationStatement;
typedef struct _ValaDeclarationStatementClass ValaDeclarationStatementClass;

#define VALA_TYPE_INITIALIZER_LIST (vala_initializer_list_get_type ())
#define VALA_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerList))
#define VALA_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))
#define VALA_IS_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INITIALIZER_LIST))
#define VALA_IS_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INITIALIZER_LIST))
#define VALA_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))

typedef struct _ValaInitializerList ValaInitializerList;
typedef struct _ValaInitializerListClass ValaInitializerListClass;

#define VALA_TYPE_EXPRESSION_STATEMENT (vala_expression_statement_get_type ())
#define VALA_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatement))
#define VALA_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))
#define VALA_IS_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_IS_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_EXPRESSION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))

typedef struct _ValaExpressionStatement ValaExpressionStatement;
typedef struct _ValaExpressionStatementClass ValaExpressionStatementClass;

#define VALA_TYPE_IF_STATEMENT (vala_if_statement_get_type ())
#define VALA_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatement))
#define VALA_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))
#define VALA_IS_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_IF_STATEMENT))
#define VALA_IS_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_IF_STATEMENT))
#define VALA_IF_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))

typedef struct _ValaIfStatement ValaIfStatement;
typedef struct _ValaIfStatementClass ValaIfStatementClass;

#define VALA_TYPE_SWITCH_STATEMENT (vala_switch_statement_get_type ())
#define VALA_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatement))
#define VALA_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))
#define VALA_IS_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_IS_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_SWITCH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))

typedef struct _ValaSwitchStatement ValaSwitchStatement;
typedef struct _ValaSwitchStatementClass ValaSwitchStatementClass;

#define VALA_TYPE_SWITCH_SECTION (vala_switch_section_get_type ())
#define VALA_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSection))
#define VALA_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))
#define VALA_IS_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_SECTION))
#define VALA_IS_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_SECTION))
#define VALA_SWITCH_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))

typedef struct _ValaSwitchSection ValaSwitchSection;
typedef struct _ValaSwitchSectionClass ValaSwitchSectionClass;

#define VALA_TYPE_SWITCH_LABEL (vala_switch_label_get_type ())
#define VALA_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabel))
#define VALA_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))
#define VALA_IS_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_LABEL))
#define VALA_IS_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_LABEL))
#define VALA_SWITCH_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))

typedef struct _ValaSwitchLabel ValaSwitchLabel;
typedef struct _ValaSwitchLabelClass ValaSwitchLabelClass;

#define VALA_TYPE_LOOP (vala_loop_get_type ())
#define VALA_LOOP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOOP, ValaLoop))
#define VALA_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOOP, ValaLoopClass))
#define VALA_IS_LOOP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOOP))
#define VALA_IS_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOOP))
#define VALA_LOOP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOOP, ValaLoopClass))

typedef struct _ValaLoop ValaLoop;
typedef struct _ValaLoopClass ValaLoopClass;

#define VALA_TYPE_WHILE_STATEMENT (vala_while_statement_get_type ())
#define VALA_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatement))
#define VALA_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))
#define VALA_IS_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_WHILE_STATEMENT))
#define VALA_IS_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_WHILE_STATEMENT))
#define VALA_WHILE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))

typedef struct _ValaWhileStatement ValaWhileStatement;
typedef struct _ValaWhileStatementClass ValaWhileStatementClass;

#define VALA_TYPE_DO_STATEMENT (vala_do_statement_get_type ())
#define VALA_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatement))
#define VALA_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))
#define VALA_IS_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DO_STATEMENT))
#define VALA_IS_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DO_STATEMENT))
#define VALA_DO_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))

typedef struct _ValaDoStatement ValaDoStatement;
typedef struct _ValaDoStatementClass ValaDoStatementClass;

#define VALA_TYPE_FOR_STATEMENT (vala_for_statement_get_type ())
#define VALA_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatement))
#define VALA_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))
#define VALA_IS_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOR_STATEMENT))
#define VALA_IS_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOR_STATEMENT))
#define VALA_FOR_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))

typedef struct _ValaForStatement ValaForStatement;
typedef struct _ValaForStatementClass ValaForStatementClass;

#define VALA_TYPE_FOREACH_STATEMENT (vala_foreach_statement_get_type ())
#define VALA_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatement))
#define VALA_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))
#define VALA_IS_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_IS_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_FOREACH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))

typedef struct _ValaForeachStatement ValaForeachStatement;
typedef struct _ValaForeachStatementClass ValaForeachStatementClass;

#define VALA_TYPE_BREAK_STATEMENT (vala_break_statement_get_type ())
#define VALA_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatement))
#define VALA_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))
#define VALA_IS_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BREAK_STATEMENT))
#define VALA_IS_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BREAK_STATEMENT))
#define VALA_BREAK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))

typedef struct _ValaBreakStatement ValaBreakStatement;
typedef struct _ValaBreakStatementClass ValaBreakStatementClass;

#define VALA_TYPE_CONTINUE_STATEMENT (vala_continue_statement_get_type ())
#define VALA_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatement))
#define VALA_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))
#define VALA_IS_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_IS_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_CONTINUE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))

typedef struct _ValaContinueStatement ValaContinueStatement;
typedef struct _ValaContinueStatementClass ValaContinueStatementClass;

#define VALA_TYPE_RETURN_STATEMENT (vala_return_statement_get_type ())
#define VALA_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatement))
#define VALA_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))
#define VALA_IS_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_RETURN_STATEMENT))
#define VALA_IS_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_RETURN_STATEMENT))
#define VALA_RETURN_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))

typedef struct _ValaReturnStatement ValaReturnStatement;
typedef struct _ValaReturnStatementClass ValaReturnStatementClass;

#define VALA_TYPE_YIELD_STATEMENT (vala_yield_statement_get_type ())
#define VALA_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatement))
#define VALA_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))
#define VALA_IS_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_YIELD_STATEMENT))
#define VALA_IS_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_YIELD_STATEMENT))
#define VALA_YIELD_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))

typedef struct _ValaYieldStatement ValaYieldStatement;
typedef struct _ValaYieldStatementClass ValaYieldStatementClass;

#define VALA_TYPE_THROW_STATEMENT (vala_throw_statement_get_type ())
#define VALA_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatement))
#define VALA_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))
#define VALA_IS_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_THROW_STATEMENT))
#define VALA_IS_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_THROW_STATEMENT))
#define VALA_THROW_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))

typedef struct _ValaThrowStatement ValaThrowStatement;
typedef struct _ValaThrowStatementClass ValaThrowStatementClass;

#define VALA_TYPE_TRY_STATEMENT (vala_try_statement_get_type ())
#define VALA_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatement))
#define VALA_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))
#define VALA_IS_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TRY_STATEMENT))
#define VALA_IS_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TRY_STATEMENT))
#define VALA_TRY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))

typedef struct _ValaTryStatement ValaTryStatement;
typedef struct _ValaTryStatementClass ValaTryStatementClass;

#define VALA_TYPE_CATCH_CLAUSE (vala_catch_clause_get_type ())
#define VALA_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClause))
#define VALA_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))
#define VALA_IS_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CATCH_CLAUSE))
#define VALA_IS_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CATCH_CLAUSE))
#define VALA_CATCH_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))

typedef struct _ValaCatchClause ValaCatchClause;
typedef struct _ValaCatchClauseClass ValaCatchClauseClass;

#define VALA_TYPE_LOCK_STATEMENT (vala_lock_statement_get_type ())
#define VALA_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatement))
#define VALA_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))
#define VALA_IS_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCK_STATEMENT))
#define VALA_IS_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCK_STATEMENT))
#define VALA_LOCK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))

typedef struct _ValaLockStatement ValaLockStatement;
typedef struct _ValaLockStatementClass ValaLockStatementClass;

#define VALA_TYPE_DELETE_STATEMENT (vala_delete_statement_get_type ())
#define VALA_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatement))
#define VALA_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))
#define VALA_IS_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELETE_STATEMENT))
#define VALA_IS_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELETE_STATEMENT))
#define VALA_DELETE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))

typedef struct _ValaDeleteStatement ValaDeleteStatement;
typedef struct _ValaDeleteStatementClass ValaDeleteStatementClass;

#define VALA_TYPE_ARRAY_CREATION_EXPRESSION (vala_array_creation_expression_get_type ())
#define VALA_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression))
#define VALA_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))
#define VALA_IS_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_IS_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_ARRAY_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))

typedef struct _ValaArrayCreationExpression ValaArrayCreationExpression;
typedef struct _ValaArrayCreationExpressionClass ValaArrayCreationExpressionClass;

#define VALA_TYPE_LITERAL (vala_literal_get_type ())
#define VALA_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL, ValaLiteral))
#define VALA_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL, ValaLiteralClass))
#define VALA_IS_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL))
#define VALA_IS_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL))
#define VALA_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL, ValaLiteralClass))

typedef struct _ValaLiteral ValaLiteral;
typedef struct _ValaLiteralClass ValaLiteralClass;

#define VALA_TYPE_BOOLEAN_LITERAL (vala_boolean_literal_get_type ())
#define VALA_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral))
#define VALA_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))
#define VALA_IS_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_IS_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_BOOLEAN_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))

typedef struct _ValaBooleanLiteral ValaBooleanLiteral;
typedef struct _ValaBooleanLiteralClass ValaBooleanLiteralClass;

#define VALA_TYPE_CHARACTER_LITERAL (vala_character_literal_get_type ())
#define VALA_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral))
#define VALA_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))
#define VALA_IS_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_IS_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_CHARACTER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))

typedef struct _ValaCharacterLiteral ValaCharacterLiteral;
typedef struct _ValaCharacterLiteralClass ValaCharacterLiteralClass;

#define VALA_TYPE_INTEGER_LITERAL (vala_integer_literal_get_type ())
#define VALA_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral))
#define VALA_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))
#define VALA_IS_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_LITERAL))
#define VALA_IS_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_LITERAL))
#define VALA_INTEGER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))

typedef struct _ValaIntegerLiteral ValaIntegerLiteral;
typedef struct _ValaIntegerLiteralClass ValaIntegerLiteralClass;

#define VALA_TYPE_REAL_LITERAL (vala_real_literal_get_type ())
#define VALA_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteral))
#define VALA_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))
#define VALA_IS_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REAL_LITERAL))
#define VALA_IS_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REAL_LITERAL))
#define VALA_REAL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))

typedef struct _ValaRealLiteral ValaRealLiteral;
typedef struct _ValaRealLiteralClass ValaRealLiteralClass;

#define VALA_TYPE_STRING_LITERAL (vala_string_literal_get_type ())
#define VALA_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteral))
#define VALA_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))
#define VALA_IS_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRING_LITERAL))
#define VALA_IS_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRING_LITERAL))
#define VALA_STRING_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))

typedef struct _ValaStringLiteral ValaStringLiteral;
typedef struct _ValaStringLiteralClass ValaStringLiteralClass;

#define VALA_TYPE_NULL_LITERAL (vala_null_literal_get_type ())
#define VALA_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteral))
#define VALA_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))
#define VALA_IS_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_LITERAL))
#define VALA_IS_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_LITERAL))
#define VALA_NULL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))

typedef struct _ValaNullLiteral ValaNullLiteral;
typedef struct _ValaNullLiteralClass ValaNullLiteralClass;

#define VALA_TYPE_METHOD_CALL (vala_method_call_get_type ())
#define VALA_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCall))
#define VALA_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))
#define VALA_IS_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_CALL))
#define VALA_IS_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_CALL))
#define VALA_METHOD_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))

typedef struct _ValaMethodCall ValaMethodCall;
typedef struct _ValaMethodCallClass ValaMethodCallClass;

#define VALA_TYPE_ELEMENT_ACCESS (vala_element_access_get_type ())
#define VALA_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess))
#define VALA_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))
#define VALA_IS_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_IS_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_ELEMENT_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))

typedef struct _ValaElementAccess ValaElementAccess;
typedef struct _ValaElementAccessClass ValaElementAccessClass;

#define VALA_TYPE_BASE_ACCESS (vala_base_access_get_type ())
#define VALA_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccess))
#define VALA_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))
#define VALA_IS_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BASE_ACCESS))
#define VALA_IS_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BASE_ACCESS))
#define VALA_BASE_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))

typedef struct _ValaBaseAccess ValaBaseAccess;
typedef struct _ValaBaseAccessClass ValaBaseAccessClass;

#define VALA_TYPE_POSTFIX_EXPRESSION (vala_postfix_expression_get_type ())
#define VALA_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpression))
#define VALA_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))
#define VALA_IS_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_IS_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_POSTFIX_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))

typedef struct _ValaPostfixExpression ValaPostfixExpression;
typedef struct _ValaPostfixExpressionClass ValaPostfixExpressionClass;

#define VALA_TYPE_SIZEOF_EXPRESSION (vala_sizeof_expression_get_type ())
#define VALA_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpression))
#define VALA_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))
#define VALA_IS_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_IS_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_SIZEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))

typedef struct _ValaSizeofExpression ValaSizeofExpression;
typedef struct _ValaSizeofExpressionClass ValaSizeofExpressionClass;

#define VALA_TYPE_TYPEOF_EXPRESSION (vala_typeof_expression_get_type ())
#define VALA_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpression))
#define VALA_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))
#define VALA_IS_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_IS_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_TYPEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))

typedef struct _ValaTypeofExpression ValaTypeofExpression;
typedef struct _ValaTypeofExpressionClass ValaTypeofExpressionClass;

#define VALA_TYPE_UNARY_EXPRESSION (vala_unary_expression_get_type ())
#define VALA_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression))
#define VALA_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))
#define VALA_IS_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_IS_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_UNARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))

typedef struct _ValaUnaryExpression ValaUnaryExpression;
typedef struct _ValaUnaryExpressionClass ValaUnaryExpressionClass;

#define VALA_TYPE_CAST_EXPRESSION (vala_cast_expression_get_type ())
#define VALA_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpression))
#define VALA_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))
#define VALA_IS_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CAST_EXPRESSION))
#define VALA_IS_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CAST_EXPRESSION))
#define VALA_CAST_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))

typedef struct _ValaCastExpression ValaCastExpression;
typedef struct _ValaCastExpressionClass ValaCastExpressionClass;

#define VALA_TYPE_POINTER_INDIRECTION (vala_pointer_indirection_get_type ())
#define VALA_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection))
#define VALA_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))
#define VALA_IS_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_IS_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_POINTER_INDIRECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))

typedef struct _ValaPointerIndirection ValaPointerIndirection;
typedef struct _ValaPointerIndirectionClass ValaPointerIndirectionClass;

#define VALA_TYPE_ADDRESSOF_EXPRESSION (vala_addressof_expression_get_type ())
#define VALA_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpression))
#define VALA_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))
#define VALA_IS_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_IS_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_ADDRESSOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))

typedef struct _ValaAddressofExpression ValaAddressofExpression;
typedef struct _ValaAddressofExpressionClass ValaAddressofExpressionClass;

#define VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION (vala_reference_transfer_expression_get_type ())
#define VALA_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpression))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))

typedef struct _ValaReferenceTransferExpression ValaReferenceTransferExpression;
typedef struct _ValaReferenceTransferExpressionClass ValaReferenceTransferExpressionClass;

#define VALA_TYPE_BINARY_EXPRESSION (vala_binary_expression_get_type ())
#define VALA_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression))
#define VALA_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))
#define VALA_IS_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_IS_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_BINARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))

typedef struct _ValaBinaryExpression ValaBinaryExpression;
typedef struct _ValaBinaryExpressionClass ValaBinaryExpressionClass;

#define VALA_TYPE_TYPECHECK (vala_typecheck_get_type ())
#define VALA_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheck))
#define VALA_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))
#define VALA_IS_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPECHECK))
#define VALA_IS_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPECHECK))
#define VALA_TYPECHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))

typedef struct _ValaTypeCheck ValaTypeCheck;
typedef struct _ValaTypeCheckClass ValaTypeCheckClass;

#define VALA_TYPE_CONDITIONAL_EXPRESSION (vala_conditional_expression_get_type ())
#define VALA_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpression))
#define VALA_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))
#define VALA_IS_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_IS_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_CONDITIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))

typedef struct _ValaConditionalExpression ValaConditionalExpression;
typedef struct _ValaConditionalExpressionClass ValaConditionalExpressionClass;

#define VALA_TYPE_LAMBDA_EXPRESSION (vala_lambda_expression_get_type ())
#define VALA_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression))
#define VALA_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))
#define VALA_IS_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_IS_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_LAMBDA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))

typedef struct _ValaLambdaExpression ValaLambdaExpression;
typedef struct _ValaLambdaExpressionClass ValaLambdaExpressionClass;

#define VALA_TYPE_ASSIGNMENT (vala_assignment_get_type ())
#define VALA_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignment))
#define VALA_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))
#define VALA_IS_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ASSIGNMENT))
#define VALA_IS_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ASSIGNMENT))
#define VALA_ASSIGNMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))

typedef struct _ValaAssignment ValaAssignment;
typedef struct _ValaAssignmentClass ValaAssignmentClass;
typedef struct _ValaSemanticAnalyzerPrivate ValaSemanticAnalyzerPrivate;

#define VALA_TYPE_STATEMENT (vala_statement_get_type ())
#define VALA_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STATEMENT, ValaStatement))
#define VALA_IS_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STATEMENT))
#define VALA_STATEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_STATEMENT, ValaStatementIface))

typedef struct _ValaStatement ValaStatement;
typedef struct _ValaStatementIface ValaStatementIface;

/**
 * Represents a part of the parsed source code.
 *
 * Code nodes get created by the parser and are used throughout the whole
 * compilation process.
 */
struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, GeeCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, GeeCollection* collection);
};

/**
 * Base class for all code nodes that might be used as an expression.
 */
struct _ValaExpression {
	ValaCodeNode parent_instance;
	ValaExpressionPrivate * priv;
	GeeArrayList* temp_vars;
};

struct _ValaExpressionClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_constant) (ValaExpression* self);
	gboolean (*is_pure) (ValaExpression* self);
	gboolean (*is_non_null) (ValaExpression* self);
};

/**
 * Represents an object creation expression in the source code.
 */
struct _ValaObjectCreationExpression {
	ValaExpression parent_instance;
	ValaObjectCreationExpressionPrivate * priv;
};

struct _ValaObjectCreationExpressionClass {
	ValaExpressionClass parent_class;
};

struct _ValaObjectCreationExpressionPrivate {
	ValaMethod* _constructor;
	ValaMemberAccess* _member_name;
	gboolean _struct_creation;
	GeeList* argument_list;
	GeeList* object_initializer;
	ValaDataType* _data_type;
};

/**
 * Abstract code node visitor for traversing source code tree.
 */
struct _ValaCodeVisitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeVisitorPrivate * priv;
};

struct _ValaCodeVisitorClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeVisitor *self);
	void (*visit_source_file) (ValaCodeVisitor* self, ValaSourceFile* source_file);
	void (*visit_namespace) (ValaCodeVisitor* self, ValaNamespace* ns);
	void (*visit_class) (ValaCodeVisitor* self, ValaClass* cl);
	void (*visit_struct) (ValaCodeVisitor* self, ValaStruct* st);
	void (*visit_interface) (ValaCodeVisitor* self, ValaInterface* iface);
	void (*visit_enum) (ValaCodeVisitor* self, ValaEnum* en);
	void (*visit_enum_value) (ValaCodeVisitor* self, ValaEnumValue* ev);
	void (*visit_error_domain) (ValaCodeVisitor* self, ValaErrorDomain* edomain);
	void (*visit_error_code) (ValaCodeVisitor* self, ValaErrorCode* ecode);
	void (*visit_delegate) (ValaCodeVisitor* self, ValaDelegate* d);
	void (*visit_member) (ValaCodeVisitor* self, ValaMember* m);
	void (*visit_constant) (ValaCodeVisitor* self, ValaConstant* c);
	void (*visit_field) (ValaCodeVisitor* self, ValaField* f);
	void (*visit_method) (ValaCodeVisitor* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCodeVisitor* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCodeVisitor* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCodeVisitor* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCodeVisitor* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCodeVisitor* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCodeVisitor* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCodeVisitor* self, ValaDestructor* d);
	void (*visit_type_parameter) (ValaCodeVisitor* self, ValaTypeParameter* p);
	void (*visit_using_directive) (ValaCodeVisitor* self, ValaUsingDirective* ns);
	void (*visit_data_type) (ValaCodeVisitor* self, ValaDataType* type);
	void (*visit_block) (ValaCodeVisitor* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCodeVisitor* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCodeVisitor* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCodeVisitor* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCodeVisitor* self, ValaInitializerList* list);
	void (*visit_expression_statement) (ValaCodeVisitor* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCodeVisitor* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCodeVisitor* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCodeVisitor* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCodeVisitor* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCodeVisitor* self, ValaLoop* stmt);
	void (*visit_while_statement) (ValaCodeVisitor* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCodeVisitor* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCodeVisitor* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCodeVisitor* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCodeVisitor* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCodeVisitor* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCodeVisitor* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCodeVisitor* self, ValaYieldStatement* y);
	void (*visit_throw_statement) (ValaCodeVisitor* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCodeVisitor* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCodeVisitor* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCodeVisitor* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCodeVisitor* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCodeVisitor* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCodeVisitor* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCodeVisitor* self, ValaBooleanLiteral* lit);
	void (*visit_character_literal) (ValaCodeVisitor* self, ValaCharacterLiteral* lit);
	void (*visit_integer_literal) (ValaCodeVisitor* self, ValaIntegerLiteral* lit);
	void (*visit_real_literal) (ValaCodeVisitor* self, ValaRealLiteral* lit);
	void (*visit_string_literal) (ValaCodeVisitor* self, ValaStringLiteral* lit);
	void (*visit_null_literal) (ValaCodeVisitor* self, ValaNullLiteral* lit);
	void (*visit_member_access) (ValaCodeVisitor* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCodeVisitor* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCodeVisitor* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCodeVisitor* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCodeVisitor* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCodeVisitor* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCodeVisitor* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCodeVisitor* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCodeVisitor* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCodeVisitor* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCodeVisitor* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCodeVisitor* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCodeVisitor* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCodeVisitor* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCodeVisitor* self, ValaTypeCheck* expr);
	void (*visit_conditional_expression) (ValaCodeVisitor* self, ValaConditionalExpression* expr);
	void (*visit_lambda_expression) (ValaCodeVisitor* self, ValaLambdaExpression* expr);
	void (*visit_assignment) (ValaCodeVisitor* self, ValaAssignment* a);
	void (*visit_end_full_expression) (ValaCodeVisitor* self, ValaExpression* expr);
};

/**
 * Code visitor analyzing and checking code.
 */
struct _ValaSemanticAnalyzer {
	ValaCodeVisitor parent_instance;
	ValaSemanticAnalyzerPrivate * priv;
	ValaSymbol* root_symbol;
	ValaDataType* current_return_type;
	ValaClass* current_class;
	ValaStruct* current_struct;
	ValaBlock* insert_block;
	ValaDataType* bool_type;
	ValaDataType* string_type;
	ValaDataType* uchar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* size_t_type;
	ValaDataType* ssize_t_type;
	ValaDataType* int8_type;
	ValaDataType* unichar_type;
	ValaDataType* double_type;
	ValaDataType* type_type;
	ValaClass* object_type;
	ValaStructValueType* gvalue_type;
	ValaDataType* glist_type;
	ValaDataType* gslist_type;
	ValaDataType* garray_type;
	ValaDataType* gvaluearray_type;
	ValaClass* gerror_type;
	gint next_lambda_id;
	GeeList* replaced_nodes;
};

struct _ValaSemanticAnalyzerClass {
	ValaCodeVisitorClass parent_class;
};

/**
 * Interface for all statement types.
 */
struct _ValaStatementIface {
	GTypeInterface parent_iface;
};


static gpointer vala_object_creation_expression_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_semantic_analyzer_get_type (void);
GType vala_data_type_get_type (void);
GType vala_expression_get_type (void);
GType vala_symbol_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_attribute_get_type (void);
GType vala_object_creation_expression_get_type (void);
GType vala_member_get_type (void);
GType vala_method_get_type (void);
GType vala_member_access_get_type (void);
GType vala_member_initializer_get_type (void);
#define VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionPrivate))
enum  {
	VALA_OBJECT_CREATION_EXPRESSION_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self, ValaMemberAccess* value);
ValaObjectCreationExpression* vala_object_creation_expression_new (ValaMemberAccess* member_name, ValaSourceReference* source_reference);
ValaObjectCreationExpression* vala_object_creation_expression_construct (GType object_type, ValaMemberAccess* member_name, ValaSourceReference* source_reference);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self, ValaExpression* arg);
GeeList* vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self);
void vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self, ValaMemberInitializer* init);
GeeList* vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self);
void vala_code_visitor_visit_object_creation_expression (ValaCodeVisitor* self, ValaObjectCreationExpression* expr);
void vala_code_visitor_visit_expression (ValaCodeVisitor* self, ValaExpression* expr);
static void vala_object_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaDataType* vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaMemberAccess* vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaCodeNode* vala_code_node_get_parent_node (ValaCodeNode* self);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self, ValaDataType* value);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
GType vala_typesymbol_get_type (void);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const char* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaSymbol* vala_expression_get_symbol_reference (ValaExpression* self);
GeeList* vala_member_access_get_type_arguments (ValaMemberAccess* self);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
GType vala_creation_method_get_type (void);
char* vala_symbol_get_full_name (ValaSymbol* self);
void vala_expression_set_symbol_reference (ValaExpression* self, ValaSymbol* value);
ValaExpression* vala_member_access_get_inner (ValaMemberAccess* self);
GType vala_object_type_symbol_get_type (void);
GType vala_class_get_type (void);
ValaObjectType* vala_object_type_new (ValaObjectTypeSymbol* type_symbol);
ValaObjectType* vala_object_type_construct (GType object_type, ValaObjectTypeSymbol* type_symbol);
GType vala_reference_type_get_type (void);
GType vala_object_type_get_type (void);
GType vala_struct_get_type (void);
ValaStructValueType* vala_struct_value_type_new (ValaStruct* type_symbol);
ValaStructValueType* vala_struct_value_type_construct (GType object_type, ValaStruct* type_symbol);
GType vala_value_type_get_type (void);
GType vala_struct_value_type_get_type (void);
GType vala_error_code_get_type (void);
GType vala_error_domain_get_type (void);
ValaErrorType* vala_error_type_new (ValaErrorDomain* error_domain, ValaErrorCode* error_code, ValaSourceReference* source_reference);
ValaErrorType* vala_error_type_construct (GType object_type, ValaErrorDomain* error_domain, ValaErrorCode* error_code, ValaSourceReference* source_reference);
GType vala_error_type_get_type (void);
void vala_data_type_add_type_argument (ValaDataType* self, ValaDataType* arg);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
void vala_expression_set_value_type (ValaExpression* self, ValaDataType* value);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
GeeList* vala_data_type_get_type_arguments (ValaDataType* self);
GType vala_typeparameter_get_type (void);
GeeList* vala_object_type_symbol_get_type_parameters (ValaObjectTypeSymbol* self);
gboolean vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self);
gboolean vala_class_get_is_abstract (ValaClass* self);
ValaMethod* vala_class_get_default_construction_method (ValaClass* self);
void vala_symbol_set_used (ValaSymbol* self, gboolean value);
char* vala_typesymbol_get_ref_sink_function (ValaTypeSymbol* self);
void vala_data_type_set_floating_reference (ValaDataType* self, gboolean value);
ValaClass* vala_class_get_base_class (ValaClass* self);
GeeList* vala_struct_get_type_parameters (ValaStruct* self);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void);
ValaCodeContext* vala_semantic_analyzer_get_context (ValaSemanticAnalyzer* self);
gboolean vala_code_context_get_deprecated (ValaCodeContext* self);
void vala_report_warning (ValaSourceReference* source, const char* message);
ValaMethod* vala_struct_get_default_construction_method (ValaStruct* self);
GType vala_formal_parameter_get_type (void);
GeeList* vala_method_get_parameters (ValaMethod* self);
gboolean vala_formal_parameter_get_ellipsis (ValaFormalParameter* self);
ValaDataType* vala_formal_parameter_get_parameter_type (ValaFormalParameter* self);
void vala_expression_set_formal_target_type (ValaExpression* self, ValaDataType* value);
ValaDataType* vala_expression_get_formal_target_type (ValaExpression* self);
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
gboolean vala_semantic_analyzer_check_arguments (ValaSemanticAnalyzer* self, ValaExpression* expr, ValaDataType* mtype, GeeList* params, GeeList* args);
ValaMethodType* vala_method_type_new (ValaMethod* method_symbol);
ValaMethodType* vala_method_type_construct (GType object_type, ValaMethod* method_symbol);
GType vala_method_type_get_type (void);
GeeList* vala_code_node_get_error_types (ValaCodeNode* self);
void vala_code_node_add_error_type (ValaCodeNode* self, ValaDataType* error_type);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
GType vala_namespace_get_type (void);
GType vala_interface_get_type (void);
GType vala_enum_get_type (void);
GType vala_enum_value_get_type (void);
GType vala_delegate_get_type (void);
GType vala_constant_get_type (void);
GType vala_field_get_type (void);
GType vala_property_get_type (void);
GType vala_property_accessor_get_type (void);
GType vala_signal_get_type (void);
GType vala_constructor_get_type (void);
GType vala_destructor_get_type (void);
GType vala_using_directive_get_type (void);
GType vala_block_get_type (void);
GType vala_empty_statement_get_type (void);
GType vala_declaration_statement_get_type (void);
GType vala_initializer_list_get_type (void);
GType vala_expression_statement_get_type (void);
GType vala_if_statement_get_type (void);
GType vala_switch_statement_get_type (void);
GType vala_switch_section_get_type (void);
GType vala_switch_label_get_type (void);
GType vala_loop_get_type (void);
GType vala_while_statement_get_type (void);
GType vala_do_statement_get_type (void);
GType vala_for_statement_get_type (void);
GType vala_foreach_statement_get_type (void);
GType vala_break_statement_get_type (void);
GType vala_continue_statement_get_type (void);
GType vala_return_statement_get_type (void);
GType vala_yield_statement_get_type (void);
GType vala_throw_statement_get_type (void);
GType vala_try_statement_get_type (void);
GType vala_catch_clause_get_type (void);
GType vala_lock_statement_get_type (void);
GType vala_delete_statement_get_type (void);
GType vala_array_creation_expression_get_type (void);
GType vala_literal_get_type (void);
GType vala_boolean_literal_get_type (void);
GType vala_character_literal_get_type (void);
GType vala_integer_literal_get_type (void);
GType vala_real_literal_get_type (void);
GType vala_string_literal_get_type (void);
GType vala_null_literal_get_type (void);
GType vala_method_call_get_type (void);
GType vala_element_access_get_type (void);
GType vala_base_access_get_type (void);
GType vala_postfix_expression_get_type (void);
GType vala_sizeof_expression_get_type (void);
GType vala_typeof_expression_get_type (void);
GType vala_unary_expression_get_type (void);
GType vala_cast_expression_get_type (void);
GType vala_pointer_indirection_get_type (void);
GType vala_addressof_expression_get_type (void);
GType vala_reference_transfer_expression_get_type (void);
GType vala_binary_expression_get_type (void);
GType vala_typecheck_get_type (void);
GType vala_conditional_expression_get_type (void);
GType vala_lambda_expression_get_type (void);
GType vala_assignment_get_type (void);
void vala_semantic_analyzer_visit_member_initializer (ValaSemanticAnalyzer* self, ValaMemberInitializer* init, ValaDataType* type);
char* vala_code_node_get_temp_name (ValaCodeNode* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_local_variable_set_floating (ValaLocalVariable* self, gboolean value);
ValaDeclarationStatement* vala_declaration_statement_new (ValaSymbol* declaration, ValaSourceReference* source_reference);
ValaDeclarationStatement* vala_declaration_statement_construct (GType object_type, ValaSymbol* declaration, ValaSourceReference* source_reference);
GType vala_statement_get_type (void);
void vala_expression_insert_statement (ValaExpression* self, ValaBlock* block, ValaStatement* stmt);
ValaMemberAccess* vala_member_access_new_simple (const char* member_name, ValaSourceReference* source_reference);
ValaMemberAccess* vala_member_access_construct_simple (GType object_type, const char* member_name, ValaSourceReference* source_reference);
const char* vala_symbol_get_name (ValaSymbol* self);
ValaDataType* vala_expression_get_target_type (ValaExpression* self);
void vala_local_variable_set_initializer (ValaLocalVariable* self, ValaExpression* value);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
void vala_block_remove_local_variable (ValaBlock* self, ValaLocalVariable* local);
void vala_block_add_local_variable (ValaBlock* self, ValaLocalVariable* local);
void vala_code_node_replace_expression (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
void vala_code_node_get_defined_variables (ValaCodeNode* self, GeeCollection* collection);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection);
void vala_code_node_get_used_variables (ValaCodeNode* self, GeeCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection);
ValaMethod* vala_object_creation_expression_get_constructor (ValaObjectCreationExpression* self);
void vala_object_creation_expression_set_constructor (ValaObjectCreationExpression* self, ValaMethod* value);
void vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self, gboolean value);
static void vala_object_creation_expression_finalize (ValaCodeNode* obj);



/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression* vala_object_creation_expression_construct (GType object_type, ValaMemberAccess* member_name, ValaSourceReference* source_reference) {
	ValaObjectCreationExpression* self;
	g_return_val_if_fail (member_name != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaObjectCreationExpression*) g_type_create_instance (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}


ValaObjectCreationExpression* vala_object_creation_expression_new (ValaMemberAccess* member_name, ValaSourceReference* source_reference) {
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self, ValaExpression* arg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	gee_collection_add ((GeeCollection*) self->priv->argument_list, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
GeeList* vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->argument_list);
	return result;
}


/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self, ValaMemberInitializer* init) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	gee_collection_add ((GeeCollection*) self->priv->object_initializer, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}


/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
GeeList* vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->object_initializer);
	return result;
}


static void vala_object_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	if (vala_object_creation_expression_get_type_reference (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_object_creation_expression_get_type_reference (self), visitor);
	}
	if (self->priv->_member_name != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_member_name, visitor);
	}
	{
		GeeIterator* _arg_it;
		_arg_it = gee_iterable_iterator ((GeeIterable*) self->priv->argument_list);
		while (TRUE) {
			ValaExpression* arg;
			if (!gee_iterator_next (_arg_it)) {
				break;
			}
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			vala_code_node_accept ((ValaCodeNode*) arg, visitor);
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	{
		GeeIterator* _init_it;
		_init_it = gee_iterable_iterator ((GeeIterable*) self->priv->object_initializer);
		while (TRUE) {
			ValaMemberInitializer* init;
			if (!gee_iterator_next (_init_it)) {
				break;
			}
			init = (ValaMemberInitializer*) gee_iterator_get (_init_it);
			vala_code_node_accept ((ValaCodeNode*) init, visitor);
			(init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL));
		}
		(_init_it == NULL) ? NULL : (_init_it = (gee_collection_object_unref (_init_it), NULL));
	}
}


static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaObjectCreationExpression * self;
	gint index;
	gboolean _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	index = gee_list_index_of (self->priv->argument_list, old_node);
	_tmp0_ = FALSE;
	if (index >= 0) {
		_tmp0_ = vala_code_node_get_parent_node ((ValaCodeNode*) new_node) == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gee_list_set (self->priv->argument_list, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base) {
	ValaObjectCreationExpression * self;
	gboolean result;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}


static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_object_creation_expression_get_type_reference (self) == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}


static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaObjectCreationExpression * self;
	gboolean result;
	ValaTypeSymbol* type;
	ValaDataType* _tmp21_;
	gboolean may_throw;
	GeeList* _tmp22_;
	gint _tmp23_;
	gint given_num_type_args;
	gint expected_num_type_args;
	gboolean _tmp35_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		result = !vala_code_node_get_error ((ValaCodeNode*) self);
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	if (self->priv->_member_name != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_member_name, analyzer);
	}
	type = NULL;
	if (vala_object_creation_expression_get_type_reference (self) == NULL) {
		ValaSymbol* _tmp0_;
		ValaSymbol* constructor_sym;
		ValaSymbol* _tmp1_;
		ValaSymbol* type_sym;
		GeeList* type_args;
		if (self->priv->_member_name == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Incomplete object creation expression");
			result = FALSE;
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return result;
		}
		if (vala_expression_get_symbol_reference ((ValaExpression*) self->priv->_member_name) == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return result;
		}
		_tmp0_ = NULL;
		constructor_sym = (_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self->priv->_member_name), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		_tmp1_ = NULL;
		type_sym = (_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self->priv->_member_name), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
		type_args = vala_member_access_get_type_arguments (self->priv->_member_name);
		if (VALA_IS_METHOD (constructor_sym)) {
			ValaSymbol* _tmp3_;
			ValaSymbol* _tmp2_;
			ValaMethod* _tmp4_;
			ValaMethod* constructor;
			ValaMemberAccess* _tmp8_;
			ValaExpression* _tmp7_;
			ValaMemberAccess* ma;
			_tmp3_ = NULL;
			_tmp2_ = NULL;
			type_sym = (_tmp3_ = (_tmp2_ = vala_symbol_get_parent_symbol (constructor_sym), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_)), (type_sym == NULL) ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL)), _tmp3_);
			_tmp4_ = NULL;
			constructor = (_tmp4_ = VALA_METHOD (constructor_sym), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
			if (!VALA_IS_CREATION_METHOD (constructor_sym)) {
				char* _tmp6_;
				char* _tmp5_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp6_ = NULL;
				_tmp5_ = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp6_ = g_strdup_printf ("`%s' is not a creation method", _tmp5_ = vala_symbol_get_full_name ((ValaSymbol*) constructor)));
				_tmp6_ = (g_free (_tmp6_), NULL);
				_tmp5_ = (g_free (_tmp5_), NULL);
				result = FALSE;
				(constructor == NULL) ? NULL : (constructor = (vala_code_node_unref (constructor), NULL));
				(constructor_sym == NULL) ? NULL : (constructor_sym = (vala_code_node_unref (constructor_sym), NULL));
				(type_sym == NULL) ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL));
				(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				return result;
			}
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) constructor);
			/* inner expression can also be base access when chaining constructors*/
			_tmp8_ = NULL;
			_tmp7_ = NULL;
			ma = (_tmp8_ = (_tmp7_ = vala_member_access_get_inner (self->priv->_member_name), VALA_IS_MEMBER_ACCESS (_tmp7_) ? ((ValaMemberAccess*) _tmp7_) : NULL), (_tmp8_ == NULL) ? NULL : vala_code_node_ref (_tmp8_));
			if (ma != NULL) {
				GeeList* _tmp9_;
				_tmp9_ = NULL;
				type_args = (_tmp9_ = vala_member_access_get_type_arguments (ma), (type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL)), _tmp9_);
			}
			(constructor == NULL) ? NULL : (constructor = (vala_code_node_unref (constructor), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
		if (VALA_IS_CLASS (type_sym)) {
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp10_;
			ValaObjectType* _tmp12_;
			_tmp11_ = NULL;
			_tmp10_ = NULL;
			type = (_tmp11_ = (_tmp10_ = VALA_TYPESYMBOL (type_sym), (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp11_);
			_tmp12_ = NULL;
			vala_object_creation_expression_set_type_reference (self, (ValaDataType*) (_tmp12_ = vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (type))));
			(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_code_node_unref (_tmp12_), NULL));
		} else {
			if (VALA_IS_STRUCT (type_sym)) {
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp13_;
				ValaStructValueType* _tmp15_;
				_tmp14_ = NULL;
				_tmp13_ = NULL;
				type = (_tmp14_ = (_tmp13_ = VALA_TYPESYMBOL (type_sym), (_tmp13_ == NULL) ? NULL : vala_code_node_ref (_tmp13_)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp14_);
				_tmp15_ = NULL;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) (_tmp15_ = vala_struct_value_type_new (VALA_STRUCT (type))));
				(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_code_node_unref (_tmp15_), NULL));
			} else {
				if (VALA_IS_ERROR_CODE (type_sym)) {
					ValaErrorType* _tmp16_;
					_tmp16_ = NULL;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) (_tmp16_ = vala_error_type_new (VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol (type_sym)), VALA_ERROR_CODE (type_sym), vala_code_node_get_source_reference ((ValaCodeNode*) self))));
					(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_code_node_unref (_tmp16_), NULL));
					vala_expression_set_symbol_reference ((ValaExpression*) self, type_sym);
				} else {
					char* _tmp18_;
					char* _tmp17_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp18_ = NULL;
					_tmp17_ = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp18_ = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp17_ = vala_symbol_get_full_name (type_sym)));
					_tmp18_ = (g_free (_tmp18_), NULL);
					_tmp17_ = (g_free (_tmp17_), NULL);
					result = FALSE;
					(constructor_sym == NULL) ? NULL : (constructor_sym = (vala_code_node_unref (constructor_sym), NULL));
					(type_sym == NULL) ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL));
					(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
					(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
					return result;
				}
			}
		}
		{
			GeeIterator* _type_arg_it;
			_type_arg_it = gee_iterable_iterator ((GeeIterable*) type_args);
			while (TRUE) {
				ValaDataType* type_arg;
				if (!gee_iterator_next (_type_arg_it)) {
					break;
				}
				type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
				vala_data_type_add_type_argument (vala_object_creation_expression_get_type_reference (self), type_arg);
				(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
			}
			(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
		}
		(constructor_sym == NULL) ? NULL : (constructor_sym = (vala_code_node_unref (constructor_sym), NULL));
		(type_sym == NULL) ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL));
		(type_args == NULL) ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL));
	} else {
		ValaTypeSymbol* _tmp20_;
		ValaTypeSymbol* _tmp19_;
		_tmp20_ = NULL;
		_tmp19_ = NULL;
		type = (_tmp20_ = (_tmp19_ = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (self)), (_tmp19_ == NULL) ? NULL : vala_code_node_ref (_tmp19_)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp20_);
	}
	_tmp21_ = NULL;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp21_ = vala_data_type_copy (vala_object_creation_expression_get_type_reference (self)));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_code_node_unref (_tmp21_), NULL));
	vala_data_type_set_value_owned (vala_expression_get_value_type ((ValaExpression*) self), TRUE);
	may_throw = FALSE;
	_tmp22_ = NULL;
	given_num_type_args = (_tmp23_ = gee_collection_get_size ((GeeCollection*) (_tmp22_ = vala_data_type_get_type_arguments (vala_object_creation_expression_get_type_reference (self)))), (_tmp22_ == NULL) ? NULL : (_tmp22_ = (gee_collection_object_unref (_tmp22_), NULL)), _tmp23_);
	expected_num_type_args = 0;
	if (VALA_IS_CLASS (type)) {
		ValaClass* _tmp24_;
		ValaClass* cl;
		GeeList* _tmp25_;
		_tmp24_ = NULL;
		cl = (_tmp24_ = VALA_CLASS (type), (_tmp24_ == NULL) ? NULL : vala_code_node_ref (_tmp24_));
		_tmp25_ = NULL;
		expected_num_type_args = gee_collection_get_size ((GeeCollection*) (_tmp25_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl)));
		(_tmp25_ == NULL) ? NULL : (_tmp25_ = (gee_collection_object_unref (_tmp25_), NULL));
		if (self->priv->_struct_creation) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "syntax error, use `new' to create new objects");
			result = FALSE;
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return result;
		}
		if (vala_class_get_is_abstract (cl)) {
			char* _tmp27_;
			char* _tmp26_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp27_ = NULL;
			_tmp26_ = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp27_ = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp26_ = vala_symbol_get_full_name ((ValaSymbol*) cl)));
			_tmp27_ = (g_free (_tmp27_), NULL);
			_tmp26_ = (g_free (_tmp26_), NULL);
			result = FALSE;
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return result;
		}
		if (vala_expression_get_symbol_reference ((ValaExpression*) self) == NULL) {
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) vala_class_get_default_construction_method (cl));
			if (vala_expression_get_symbol_reference ((ValaExpression*) self) != NULL) {
				/* track usage for flow analyzer*/
				vala_symbol_set_used (vala_expression_get_symbol_reference ((ValaExpression*) self), TRUE);
			}
		}
		while (TRUE) {
			char* _tmp28_;
			gboolean _tmp29_;
			ValaClass* _tmp31_;
			ValaClass* _tmp30_;
			if (!(cl != NULL)) {
				break;
			}
			_tmp28_ = NULL;
			if ((_tmp29_ = (_tmp28_ = vala_typesymbol_get_ref_sink_function ((ValaTypeSymbol*) cl)) != NULL, _tmp28_ = (g_free (_tmp28_), NULL), _tmp29_)) {
				vala_data_type_set_floating_reference (vala_expression_get_value_type ((ValaExpression*) self), TRUE);
				break;
			}
			_tmp31_ = NULL;
			_tmp30_ = NULL;
			cl = (_tmp31_ = (_tmp30_ = vala_class_get_base_class (cl), (_tmp30_ == NULL) ? NULL : vala_code_node_ref (_tmp30_)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp31_);
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	} else {
		if (VALA_IS_STRUCT (type)) {
			ValaStruct* _tmp32_;
			ValaStruct* st;
			GeeList* _tmp33_;
			gboolean _tmp34_;
			_tmp32_ = NULL;
			st = (_tmp32_ = VALA_STRUCT (type), (_tmp32_ == NULL) ? NULL : vala_code_node_ref (_tmp32_));
			_tmp33_ = NULL;
			expected_num_type_args = gee_collection_get_size ((GeeCollection*) (_tmp33_ = vala_struct_get_type_parameters (st)));
			(_tmp33_ == NULL) ? NULL : (_tmp33_ = (gee_collection_object_unref (_tmp33_), NULL));
			_tmp34_ = FALSE;
			if (!self->priv->_struct_creation) {
				_tmp34_ = !vala_code_context_get_deprecated (vala_semantic_analyzer_get_context (analyzer));
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				vala_report_warning (vala_code_node_get_source_reference ((ValaCodeNode*) self), "deprecated syntax, don't use `new' to initialize structs");
			}
			if (vala_expression_get_symbol_reference ((ValaExpression*) self) == NULL) {
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) vala_struct_get_default_construction_method (st));
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		}
	}
	if (expected_num_type_args > given_num_type_args) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "too few type arguments");
		result = FALSE;
		(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
		return result;
	} else {
		if (expected_num_type_args < given_num_type_args) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "too many type arguments");
			result = FALSE;
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
			return result;
		}
	}
	_tmp35_ = FALSE;
	if (vala_expression_get_symbol_reference ((ValaExpression*) self) == NULL) {
		GeeList* _tmp36_;
		_tmp36_ = NULL;
		_tmp35_ = gee_collection_get_size ((GeeCollection*) (_tmp36_ = vala_object_creation_expression_get_argument_list (self))) != 0;
		(_tmp36_ == NULL) ? NULL : (_tmp36_ = (gee_collection_object_unref (_tmp36_), NULL));
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		char* _tmp38_;
		char* _tmp37_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp38_ = NULL;
		_tmp37_ = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp38_ = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp37_ = vala_symbol_get_full_name ((ValaSymbol*) type)));
		_tmp38_ = (g_free (_tmp38_), NULL);
		_tmp37_ = (g_free (_tmp37_), NULL);
		result = FALSE;
		(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
		return result;
	}
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) self))) {
		ValaMethod* _tmp39_;
		ValaMethod* m;
		GeeList* args;
		GeeIterator* arg_it;
		GeeList* _tmp44_;
		ValaMethodType* _tmp43_;
		_tmp39_ = NULL;
		m = (_tmp39_ = VALA_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) self)), (_tmp39_ == NULL) ? NULL : vala_code_node_ref (_tmp39_));
		args = vala_object_creation_expression_get_argument_list (self);
		arg_it = gee_iterable_iterator ((GeeIterable*) args);
		{
			GeeList* _tmp40_;
			GeeIterator* _tmp41_;
			GeeIterator* _param_it;
			_tmp40_ = NULL;
			_tmp41_ = NULL;
			_param_it = (_tmp41_ = gee_iterable_iterator ((GeeIterable*) (_tmp40_ = vala_method_get_parameters (m))), (_tmp40_ == NULL) ? NULL : (_tmp40_ = (gee_collection_object_unref (_tmp40_), NULL)), _tmp41_);
			while (TRUE) {
				ValaFormalParameter* param;
				if (!gee_iterator_next (_param_it)) {
					break;
				}
				param = (ValaFormalParameter*) gee_iterator_get (_param_it);
				if (vala_formal_parameter_get_ellipsis (param)) {
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					break;
				}
				if (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					ValaDataType* _tmp42_;
					arg = (ValaExpression*) gee_iterator_get (arg_it);
					/* store expected type for callback parameters */
					vala_expression_set_formal_target_type (arg, vala_formal_parameter_get_parameter_type (param));
					_tmp42_ = NULL;
					vala_expression_set_target_type (arg, _tmp42_ = vala_data_type_get_actual_type (vala_expression_get_formal_target_type (arg), vala_expression_get_value_type ((ValaExpression*) self), NULL, (ValaCodeNode*) self));
					(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_code_node_unref (_tmp42_), NULL));
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
				}
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			}
			(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
		}
		{
			GeeIterator* _arg_it;
			_arg_it = gee_iterable_iterator ((GeeIterable*) args);
			while (TRUE) {
				ValaExpression* arg;
				if (!gee_iterator_next (_arg_it)) {
					break;
				}
				arg = (ValaExpression*) gee_iterator_get (_arg_it);
				vala_code_node_check ((ValaCodeNode*) arg, analyzer);
				(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			}
			(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
		}
		_tmp44_ = NULL;
		_tmp43_ = NULL;
		vala_semantic_analyzer_check_arguments (analyzer, (ValaExpression*) self, (ValaDataType*) (_tmp43_ = vala_method_type_new (m)), _tmp44_ = vala_method_get_parameters (m), args);
		(_tmp44_ == NULL) ? NULL : (_tmp44_ = (gee_collection_object_unref (_tmp44_), NULL));
		(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_code_node_unref (_tmp43_), NULL));
		{
			GeeList* _tmp45_;
			GeeIterator* _tmp46_;
			GeeIterator* _error_type_it;
			_tmp45_ = NULL;
			_tmp46_ = NULL;
			_error_type_it = (_tmp46_ = gee_iterable_iterator ((GeeIterable*) (_tmp45_ = vala_code_node_get_error_types ((ValaCodeNode*) m))), (_tmp45_ == NULL) ? NULL : (_tmp45_ = (gee_collection_object_unref (_tmp45_), NULL)), _tmp46_);
			while (TRUE) {
				ValaDataType* error_type;
				ValaDataType* call_error_type;
				if (!gee_iterator_next (_error_type_it)) {
					break;
				}
				error_type = (ValaDataType*) gee_iterator_get (_error_type_it);
				may_throw = TRUE;
				/* ensure we can trace back which expression may throw errors of this type*/
				call_error_type = vala_data_type_copy (error_type);
				vala_code_node_set_source_reference ((ValaCodeNode*) call_error_type, vala_code_node_get_source_reference ((ValaCodeNode*) self));
				vala_code_node_add_error_type ((ValaCodeNode*) self, call_error_type);
				(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
				(call_error_type == NULL) ? NULL : (call_error_type = (vala_code_node_unref (call_error_type), NULL));
			}
			(_error_type_it == NULL) ? NULL : (_error_type_it = (gee_collection_object_unref (_error_type_it), NULL));
		}
		(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		(args == NULL) ? NULL : (args = (gee_collection_object_unref (args), NULL));
		(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
	} else {
		if (VALA_IS_ERROR_TYPE (vala_object_creation_expression_get_type_reference (self))) {
			GeeList* _tmp47_;
			gboolean _tmp48_;
			if (vala_object_creation_expression_get_type_reference (self) != NULL) {
				vala_code_node_check ((ValaCodeNode*) vala_object_creation_expression_get_type_reference (self), analyzer);
			}
			if (self->priv->_member_name != NULL) {
				vala_code_node_check ((ValaCodeNode*) self->priv->_member_name, analyzer);
			}
			{
				GeeIterator* _arg_it;
				_arg_it = gee_iterable_iterator ((GeeIterable*) self->priv->argument_list);
				while (TRUE) {
					ValaExpression* arg;
					if (!gee_iterator_next (_arg_it)) {
						break;
					}
					arg = (ValaExpression*) gee_iterator_get (_arg_it);
					vala_code_node_check ((ValaCodeNode*) arg, analyzer);
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
				}
				(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
			}
			{
				GeeIterator* _init_it;
				_init_it = gee_iterable_iterator ((GeeIterable*) self->priv->object_initializer);
				while (TRUE) {
					ValaMemberInitializer* init;
					if (!gee_iterator_next (_init_it)) {
						break;
					}
					init = (ValaMemberInitializer*) gee_iterator_get (_init_it);
					vala_code_node_check ((ValaCodeNode*) init, analyzer);
					(init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL));
				}
				(_init_it == NULL) ? NULL : (_init_it = (gee_collection_object_unref (_init_it), NULL));
			}
			_tmp47_ = NULL;
			if ((_tmp48_ = gee_collection_get_size ((GeeCollection*) (_tmp47_ = vala_object_creation_expression_get_argument_list (self))) == 0, (_tmp47_ == NULL) ? NULL : (_tmp47_ = (gee_collection_object_unref (_tmp47_), NULL)), _tmp48_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Too few arguments, errors need at least 1 argument");
			} else {
				GeeList* _tmp49_;
				GeeIterator* _tmp50_;
				GeeIterator* arg_it;
				ValaExpression* ex;
				gboolean _tmp51_;
				_tmp49_ = NULL;
				_tmp50_ = NULL;
				arg_it = (_tmp50_ = gee_iterable_iterator ((GeeIterable*) (_tmp49_ = vala_object_creation_expression_get_argument_list (self))), (_tmp49_ == NULL) ? NULL : (_tmp49_ = (gee_collection_object_unref (_tmp49_), NULL)), _tmp50_);
				gee_iterator_next (arg_it);
				ex = (ValaExpression*) gee_iterator_get (arg_it);
				_tmp51_ = FALSE;
				if (vala_expression_get_value_type (ex) == NULL) {
					_tmp51_ = TRUE;
				} else {
					_tmp51_ = !vala_data_type_compatible (vala_expression_get_value_type (ex), analyzer->string_type);
				}
				if (_tmp51_) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Invalid type for argument 1");
				}
				(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
				(ex == NULL) ? NULL : (ex = (vala_code_node_unref (ex), NULL));
			}
		}
	}
	{
		GeeList* _tmp52_;
		GeeIterator* _tmp53_;
		GeeIterator* _init_it;
		_tmp52_ = NULL;
		_tmp53_ = NULL;
		_init_it = (_tmp53_ = gee_iterable_iterator ((GeeIterable*) (_tmp52_ = vala_object_creation_expression_get_object_initializer (self))), (_tmp52_ == NULL) ? NULL : (_tmp52_ = (gee_collection_object_unref (_tmp52_), NULL)), _tmp53_);
		while (TRUE) {
			ValaMemberInitializer* init;
			if (!gee_iterator_next (_init_it)) {
				break;
			}
			init = (ValaMemberInitializer*) gee_iterator_get (_init_it);
			vala_semantic_analyzer_visit_member_initializer (analyzer, init, vala_object_creation_expression_get_type_reference (self));
			(init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL));
		}
		(_init_it == NULL) ? NULL : (_init_it = (gee_collection_object_unref (_init_it), NULL));
	}
	if (may_throw) {
		gboolean _tmp54_;
		_tmp54_ = FALSE;
		if (VALA_IS_LOCAL_VARIABLE (vala_code_node_get_parent_node ((ValaCodeNode*) self))) {
			_tmp54_ = TRUE;
		} else {
			_tmp54_ = VALA_IS_EXPRESSION_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) self));
		}
		if (_tmp54_) {
		} else {
			ValaCodeNode* _tmp55_;
			ValaCodeNode* old_parent_node;
			char* _tmp56_;
			ValaLocalVariable* _tmp57_;
			ValaLocalVariable* local;
			ValaDeclarationStatement* decl;
			ValaExpression* temp_access;
			ValaBlock* _tmp58_;
			ValaBlock* block;
			/* simple statements, no side effects after method call
			 store parent_node as we need to replace the expression in the old parent node later on*/
			_tmp55_ = NULL;
			old_parent_node = (_tmp55_ = vala_code_node_get_parent_node ((ValaCodeNode*) self), (_tmp55_ == NULL) ? NULL : vala_code_node_ref (_tmp55_));
			_tmp56_ = NULL;
			_tmp57_ = NULL;
			local = (_tmp57_ = vala_local_variable_new (vala_expression_get_value_type ((ValaExpression*) self), _tmp56_ = vala_code_node_get_temp_name ((ValaCodeNode*) self), NULL, vala_code_node_get_source_reference ((ValaCodeNode*) self)), _tmp56_ = (g_free (_tmp56_), NULL), _tmp57_);
			/* use floating variable to avoid unnecessary (and sometimes impossible) copies*/
			vala_local_variable_set_floating (local, TRUE);
			decl = vala_declaration_statement_new ((ValaSymbol*) local, vala_code_node_get_source_reference ((ValaCodeNode*) self));
			vala_expression_insert_statement ((ValaExpression*) self, analyzer->insert_block, (ValaStatement*) decl);
			temp_access = (ValaExpression*) vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), vala_code_node_get_source_reference ((ValaCodeNode*) self));
			vala_expression_set_target_type (temp_access, vala_expression_get_target_type ((ValaExpression*) self));
			/* don't set initializer earlier as this changes parent_node and parent_statement*/
			vala_local_variable_set_initializer (local, (ValaExpression*) self);
			vala_code_node_check ((ValaCodeNode*) decl, analyzer);
			vala_code_node_check ((ValaCodeNode*) temp_access, analyzer);
			/* move temp variable to insert block to ensure the
			 variable is in the same block as the declaration
			 otherwise there will be scoping issues in the generated code*/
			_tmp58_ = NULL;
			block = (_tmp58_ = VALA_BLOCK (vala_semantic_analyzer_get_current_symbol (analyzer)), (_tmp58_ == NULL) ? NULL : vala_code_node_ref (_tmp58_));
			vala_block_remove_local_variable (block, local);
			vala_block_add_local_variable (analyzer->insert_block, local);
			vala_code_node_replace_expression (old_parent_node, (ValaExpression*) self, temp_access);
			(old_parent_node == NULL) ? NULL : (old_parent_node = (vala_code_node_unref (old_parent_node), NULL));
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
			(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
			(temp_access == NULL) ? NULL : (temp_access = (vala_code_node_unref (temp_access), NULL));
			(block == NULL) ? NULL : (block = (vala_code_node_unref (block), NULL));
		}
	}
	result = !vala_code_node_get_error ((ValaCodeNode*) self);
	(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
	return result;
}


static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		GeeIterator* _arg_it;
		_arg_it = gee_iterable_iterator ((GeeIterable*) self->priv->argument_list);
		while (TRUE) {
			ValaExpression* arg;
			if (!gee_iterator_next (_arg_it)) {
				break;
			}
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			vala_code_node_get_defined_variables ((ValaCodeNode*) arg, collection);
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
}


static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		GeeIterator* _arg_it;
		_arg_it = gee_iterable_iterator ((GeeIterable*) self->priv->argument_list);
		while (TRUE) {
			ValaExpression* arg;
			if (!gee_iterator_next (_arg_it)) {
				break;
			}
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			vala_code_node_get_used_variables ((ValaCodeNode*) arg, collection);
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
}


ValaDataType* vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_data_type;
	return result;
}


void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self, ValaDataType* value) {
	ValaDataType* _tmp1_;
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_data_type = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_data_type == NULL) ? NULL : (self->priv->_data_type = (vala_code_node_unref (self->priv->_data_type), NULL)), _tmp1_);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_data_type, (ValaCodeNode*) self);
}


ValaMethod* vala_object_creation_expression_get_constructor (ValaObjectCreationExpression* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_constructor;
	return result;
}


void vala_object_creation_expression_set_constructor (ValaObjectCreationExpression* self, ValaMethod* value) {
	ValaMethod* _tmp1_;
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_constructor = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_constructor == NULL) ? NULL : (self->priv->_constructor = (vala_code_node_unref (self->priv->_constructor), NULL)), _tmp1_);
}


ValaMemberAccess* vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self) {
	ValaMemberAccess* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_member_name;
	return result;
}


void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self, ValaMemberAccess* value) {
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_member_name = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_member_name == NULL) ? NULL : (self->priv->_member_name = (vala_code_node_unref (self->priv->_member_name), NULL)), _tmp1_);
}


gboolean vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_struct_creation;
	return result;
}


void vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}


static void vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass) {
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaObjectCreationExpressionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_object_creation_expression_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_object_creation_expression_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_object_creation_expression_real_replace_expression;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_object_creation_expression_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_object_creation_expression_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_object_creation_expression_real_check;
	VALA_CODE_NODE_CLASS (klass)->get_defined_variables = vala_object_creation_expression_real_get_defined_variables;
	VALA_CODE_NODE_CLASS (klass)->get_used_variables = vala_object_creation_expression_real_get_used_variables;
}


static void vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self) {
	self->priv = VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE (self);
	self->priv->argument_list = (GeeList*) gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->object_initializer = (GeeList*) gee_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_object_creation_expression_finalize (ValaCodeNode* obj) {
	ValaObjectCreationExpression * self;
	self = VALA_OBJECT_CREATION_EXPRESSION (obj);
	(self->priv->_constructor == NULL) ? NULL : (self->priv->_constructor = (vala_code_node_unref (self->priv->_constructor), NULL));
	(self->priv->_member_name == NULL) ? NULL : (self->priv->_member_name = (vala_code_node_unref (self->priv->_member_name), NULL));
	(self->priv->argument_list == NULL) ? NULL : (self->priv->argument_list = (gee_collection_object_unref (self->priv->argument_list), NULL));
	(self->priv->object_initializer == NULL) ? NULL : (self->priv->object_initializer = (gee_collection_object_unref (self->priv->object_initializer), NULL));
	(self->priv->_data_type == NULL) ? NULL : (self->priv->_data_type = (vala_code_node_unref (self->priv->_data_type), NULL));
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}


GType vala_object_creation_expression_get_type (void) {
	static GType vala_object_creation_expression_type_id = 0;
	if (vala_object_creation_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
		vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
	}
	return vala_object_creation_expression_type_id;
}




