/* valagobjectmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;
typedef struct _ValaGErrorModulePrivate ValaGErrorModulePrivate;

#define VALA_TYPE_GTYPE_MODULE (vala_gtype_module_get_type ())
#define VALA_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModule))
#define VALA_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))
#define VALA_IS_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GTYPE_MODULE))
#define VALA_IS_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GTYPE_MODULE))
#define VALA_GTYPE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))

typedef struct _ValaGTypeModule ValaGTypeModule;
typedef struct _ValaGTypeModuleClass ValaGTypeModuleClass;
typedef struct _ValaGTypeModulePrivate ValaGTypeModulePrivate;

#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;

#define VALA_TYPE_GOBJECT_MODULE (vala_gobject_module_get_type ())
#define VALA_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule))
#define VALA_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))
#define VALA_IS_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GOBJECT_MODULE))
#define VALA_IS_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GOBJECT_MODULE))
#define VALA_GOBJECT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))

typedef struct _ValaGObjectModule ValaGObjectModule;
typedef struct _ValaGObjectModuleClass ValaGObjectModuleClass;
typedef struct _ValaGObjectModulePrivate ValaGObjectModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	char* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
	gboolean (*variable_accessible_in_finally) (ValaCCodeBaseModule* self, ValaLocalVariable* local);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};

struct _ValaGErrorModule {
	ValaCCodeDelegateModule parent_instance;
	ValaGErrorModulePrivate * priv;
};

struct _ValaGErrorModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
	ValaCCodeStatement* (*return_with_exception) (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
};

struct _ValaGTypeModule {
	ValaGErrorModule parent_instance;
	ValaGTypeModulePrivate * priv;
};

struct _ValaGTypeModuleClass {
	ValaGErrorModuleClass parent_class;
	void (*generate_virtual_method_declaration) (ValaGTypeModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
	void (*generate_class_init) (ValaGTypeModule* self, ValaClass* cl, ValaCCodeBlock* init_block);
	ValaTypeRegisterFunction* (*create_interface_register_function) (ValaGTypeModule* self, ValaInterface* iface);
};

struct _ValaGObjectModule {
	ValaGTypeModule parent_instance;
	ValaGObjectModulePrivate * priv;
};

struct _ValaGObjectModuleClass {
	ValaGTypeModuleClass parent_class;
};

struct _ValaGObjectModulePrivate {
	gint dynamic_property_id;
	gint signal_wrapper_id;
};


static gpointer vala_gobject_module_parent_class = NULL;

gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
GType vala_ccode_delegate_module_get_type (void);
GType vala_gerror_module_get_type (void);
GType vala_gtype_module_get_type (void);
gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void);
GType vala_gobject_module_get_type (void);
#define VALA_GOBJECT_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModulePrivate))
enum  {
	VALA_GOBJECT_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaGTypeModule* vala_gtype_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGTypeModule* vala_gtype_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGObjectModule* vala_gobject_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGObjectModule* vala_gobject_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
void vala_ccode_module_visit_class (ValaCCodeModule* self, ValaClass* cl);
static gboolean vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_get_property_function (ValaGObjectModule* self, ValaClass* cl);
static gboolean vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_set_property_function (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_real_visit_class (ValaCCodeModule* base, ValaClass* cl);
gboolean vala_ccode_base_module_is_gobject_property (ValaCCodeBaseModule* self, ValaProperty* prop);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
ValaCCodeFunctionCall* vala_ccode_module_get_param_spec (ValaCCodeModule* self, ValaProperty* prop);
static void vala_gobject_module_real_generate_class_init (ValaGTypeModule* base, ValaClass* cl, ValaCCodeBlock* init_block);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
ValaCCodeIdentifier* vala_ccode_module_get_value_setter_function (ValaCCodeModule* self, ValaDataType* type_reference);
static ValaCCodeStatement* vala_gobject_module_get_invalid_property_id_warn_statement (ValaGObjectModule* self);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static ValaCCodeExpression* vala_gobject_module_real_get_construct_property_assignment (ValaCCodeModule* base, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
static void vala_gobject_module_real_visit_constructor (ValaCCodeModule* base, ValaConstructor* c);
char* vala_ccode_module_get_dynamic_property_getter_cname (ValaCCodeModule* self, ValaDynamicProperty* node);
static void vala_gobject_module_generate_gobject_property_getter_wrapper (ValaGObjectModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
static char* vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop);
char* vala_ccode_module_get_dynamic_property_setter_cname (ValaCCodeModule* self, ValaDynamicProperty* node);
static void vala_gobject_module_generate_gobject_property_setter_wrapper (ValaGObjectModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
static char* vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop);
static char* vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeModule* base, ValaDynamicSignal* node);
char* vala_ccode_module_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* self, ValaDynamicSignal* node);
char* vala_ccode_module_get_dynamic_signal_cname (ValaCCodeModule* self, ValaDynamicSignal* node);
static void vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self, ValaDynamicSignal* sig, ValaCCodeBlock* block);
static char* vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* base, ValaDynamicSignal* sig);
void vala_ccode_module_visit_property (ValaCCodeModule* self, ValaProperty* prop);
static void vala_gobject_module_real_visit_property (ValaCCodeModule* base, ValaProperty* prop);
static gboolean vala_gobject_module_real_is_gobject_property (ValaCCodeBaseModule* base, ValaProperty* prop);
static void vala_gobject_module_finalize (ValaCCodeModule* obj);



ValaGObjectModule* vala_gobject_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGObjectModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaGObjectModule*) vala_gtype_module_construct (object_type, codegen, next);
	return self;
}


ValaGObjectModule* vala_gobject_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gobject_module_construct (VALA_TYPE_GOBJECT_MODULE, codegen, next);
}


static void vala_gobject_module_real_visit_class (ValaCCodeModule* base, ValaClass* cl) {
	ValaGObjectModule * self;
	gboolean _tmp0_;
	gboolean _tmp2_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (cl != NULL);
	VALA_CCODE_MODULE_CLASS (vala_gobject_module_parent_class)->visit_class ((ValaCCodeModule*) VALA_GTYPE_MODULE (self), cl);
	if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type)) {
		return;
	}
	_tmp0_ = FALSE;
	if (vala_gobject_module_class_has_readable_properties (self, cl)) {
		_tmp0_ = TRUE;
	} else {
		GeeList* _tmp1_;
		_tmp1_ = NULL;
		_tmp0_ = gee_collection_get_size ((GeeCollection*) (_tmp1_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (gee_collection_object_unref (_tmp1_), NULL));
	}
	if (_tmp0_) {
		vala_gobject_module_add_get_property_function (self, cl);
	}
	_tmp2_ = FALSE;
	if (vala_gobject_module_class_has_writable_properties (self, cl)) {
		_tmp2_ = TRUE;
	} else {
		GeeList* _tmp3_;
		_tmp3_ = NULL;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) (_tmp3_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
		(_tmp3_ == NULL) ? NULL : (_tmp3_ = (gee_collection_object_unref (_tmp3_), NULL));
	}
	if (_tmp2_) {
		vala_gobject_module_add_set_property_function (self, cl);
	}
}


static void vala_gobject_module_real_generate_class_init (ValaGTypeModule* base, ValaClass* cl, ValaCCodeBlock* init_block) {
	ValaGObjectModule * self;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp11_;
	gboolean _tmp28_;
	GeeList* _tmp29_;
	gboolean _tmp30_;
	GeeList* props;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (cl != NULL);
	g_return_if_fail (init_block != NULL);
	if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type)) {
		return;
	}
	/* set property handlers */
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	ccall = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("klass")));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = FALSE;
	if (vala_gobject_module_class_has_readable_properties (self, cl)) {
		_tmp3_ = TRUE;
	} else {
		GeeList* _tmp4_;
		_tmp4_ = NULL;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) (_tmp4_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (gee_collection_object_unref (_tmp4_), NULL));
	}
	if (_tmp3_) {
		ValaCCodeExpressionStatement* _tmp10_;
		ValaCCodeAssignment* _tmp9_;
		ValaCCodeIdentifier* _tmp8_;
		char* _tmp7_;
		char* _tmp6_;
		ValaCCodeMemberAccess* _tmp5_;
		_tmp10_ = NULL;
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp10_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp9_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccall, "get_property")), (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new (_tmp7_ = g_strdup_printf ("%s_get_property", _tmp6_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		_tmp7_ = (g_free (_tmp7_), NULL);
		_tmp6_ = (g_free (_tmp6_), NULL);
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	}
	_tmp11_ = FALSE;
	if (vala_gobject_module_class_has_writable_properties (self, cl)) {
		_tmp11_ = TRUE;
	} else {
		GeeList* _tmp12_;
		_tmp12_ = NULL;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) (_tmp12_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
		(_tmp12_ == NULL) ? NULL : (_tmp12_ = (gee_collection_object_unref (_tmp12_), NULL));
	}
	if (_tmp11_) {
		ValaCCodeExpressionStatement* _tmp18_;
		ValaCCodeAssignment* _tmp17_;
		ValaCCodeIdentifier* _tmp16_;
		char* _tmp15_;
		char* _tmp14_;
		ValaCCodeMemberAccess* _tmp13_;
		_tmp18_ = NULL;
		_tmp17_ = NULL;
		_tmp16_ = NULL;
		_tmp15_ = NULL;
		_tmp14_ = NULL;
		_tmp13_ = NULL;
		vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp18_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccall, "set_property")), (ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new (_tmp15_ = g_strdup_printf ("%s_set_property", _tmp14_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
		(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
		(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
		_tmp15_ = (g_free (_tmp15_), NULL);
		_tmp14_ = (g_free (_tmp14_), NULL);
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	}
	/* set constructor */
	if (vala_class_get_constructor (cl) != NULL) {
		ValaCCodeIdentifier* _tmp19_;
		ValaCCodeFunctionCall* _tmp20_;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeIdentifier* _tmp21_;
		ValaCCodeExpressionStatement* _tmp27_;
		ValaCCodeAssignment* _tmp26_;
		ValaCCodeIdentifier* _tmp25_;
		char* _tmp24_;
		char* _tmp23_;
		ValaCCodeMemberAccess* _tmp22_;
		_tmp19_ = NULL;
		_tmp20_ = NULL;
		ccast = (_tmp20_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL)), _tmp20_);
		_tmp21_ = NULL;
		vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("klass")));
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
		_tmp27_ = NULL;
		_tmp26_ = NULL;
		_tmp25_ = NULL;
		_tmp24_ = NULL;
		_tmp23_ = NULL;
		_tmp22_ = NULL;
		vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp27_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp26_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp22_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, "constructor")), (ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new (_tmp24_ = g_strdup_printf ("%s_constructor", _tmp23_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
		(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
		(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
		_tmp24_ = (g_free (_tmp24_), NULL);
		_tmp23_ = (g_free (_tmp23_), NULL);
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
		(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
	}
	_tmp28_ = FALSE;
	_tmp29_ = NULL;
	if ((_tmp30_ = gee_collection_get_size ((GeeCollection*) (_tmp29_ = vala_class_get_fields (cl))) > 0, (_tmp29_ == NULL) ? NULL : (_tmp29_ = (gee_collection_object_unref (_tmp29_), NULL)), _tmp30_)) {
		_tmp28_ = TRUE;
	} else {
		_tmp28_ = vala_class_get_destructor (cl) != NULL;
	}
	/* set finalize function */
	if (_tmp28_) {
		ValaCCodeIdentifier* _tmp31_;
		ValaCCodeFunctionCall* _tmp32_;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeIdentifier* _tmp33_;
		ValaCCodeExpressionStatement* _tmp39_;
		ValaCCodeAssignment* _tmp38_;
		ValaCCodeIdentifier* _tmp37_;
		char* _tmp36_;
		char* _tmp35_;
		ValaCCodeMemberAccess* _tmp34_;
		_tmp31_ = NULL;
		_tmp32_ = NULL;
		ccast = (_tmp32_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL)), _tmp32_);
		_tmp33_ = NULL;
		vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new ("klass")));
		(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
		_tmp39_ = NULL;
		_tmp38_ = NULL;
		_tmp37_ = NULL;
		_tmp36_ = NULL;
		_tmp35_ = NULL;
		_tmp34_ = NULL;
		vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp39_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp38_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp34_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, "finalize")), (ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new (_tmp36_ = g_strdup_printf ("%s_finalize", _tmp35_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
		(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
		(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
		_tmp36_ = (g_free (_tmp36_), NULL);
		_tmp35_ = (g_free (_tmp35_), NULL);
		(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
		(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
	}
	/* create type, dup_func, and destroy_func properties for generic types */
	{
		GeeList* _tmp40_;
		GeeIterator* _tmp41_;
		GeeIterator* _type_param_it;
		/* create type, dup_func, and destroy_func properties for generic types */
		_tmp40_ = NULL;
		_tmp41_ = NULL;
		_type_param_it = (_tmp41_ = gee_iterable_iterator ((GeeIterable*) (_tmp40_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))), (_tmp40_ == NULL) ? NULL : (_tmp40_ = (gee_collection_object_unref (_tmp40_), NULL)), _tmp41_);
		/* create type, dup_func, and destroy_func properties for generic types */
		while (TRUE) {
			ValaTypeParameter* type_param;
			char* func_name;
			char* enum_value;
			ValaCCodeConstant* func_name_constant;
			ValaCCodeFunctionCall* cinst;
			ValaCCodeFunctionCall* cspec;
			char* _tmp43_;
			char* _tmp42_;
			ValaCCodeConstant* _tmp46_;
			char* _tmp45_;
			char* _tmp44_;
			char* _tmp49_;
			char* _tmp48_;
			char* _tmp47_;
			ValaCCodeFunctionCall* _tmp51_;
			ValaCCodeIdentifier* _tmp50_;
			ValaCCodeConstant* _tmp52_;
			ValaCCodeFunctionCall* _tmp54_;
			ValaCCodeIdentifier* _tmp53_;
			ValaCCodeConstant* _tmp55_;
			ValaCCodeConstant* _tmp56_;
			ValaCCodeIdentifier* _tmp57_;
			ValaCCodeConstant* _tmp58_;
			ValaCCodeExpressionStatement* _tmp59_;
			ValaCCodeEnumValue* _tmp60_;
			char* _tmp62_;
			char* _tmp61_;
			ValaCCodeConstant* _tmp65_;
			char* _tmp64_;
			char* _tmp63_;
			char* _tmp68_;
			char* _tmp67_;
			char* _tmp66_;
			ValaCCodeFunctionCall* _tmp70_;
			ValaCCodeIdentifier* _tmp69_;
			ValaCCodeConstant* _tmp71_;
			ValaCCodeFunctionCall* _tmp73_;
			ValaCCodeIdentifier* _tmp72_;
			ValaCCodeConstant* _tmp74_;
			ValaCCodeConstant* _tmp75_;
			ValaCCodeConstant* _tmp76_;
			ValaCCodeExpressionStatement* _tmp77_;
			ValaCCodeEnumValue* _tmp78_;
			char* _tmp80_;
			char* _tmp79_;
			ValaCCodeConstant* _tmp83_;
			char* _tmp82_;
			char* _tmp81_;
			char* _tmp86_;
			char* _tmp85_;
			char* _tmp84_;
			ValaCCodeFunctionCall* _tmp88_;
			ValaCCodeIdentifier* _tmp87_;
			ValaCCodeConstant* _tmp89_;
			ValaCCodeFunctionCall* _tmp91_;
			ValaCCodeIdentifier* _tmp90_;
			ValaCCodeConstant* _tmp92_;
			ValaCCodeConstant* _tmp93_;
			ValaCCodeConstant* _tmp94_;
			ValaCCodeExpressionStatement* _tmp95_;
			ValaCCodeEnumValue* _tmp96_;
			/* create type, dup_func, and destroy_func properties for generic types */
			if (!gee_iterator_next (_type_param_it)) {
				/* create type, dup_func, and destroy_func properties for generic types */
				break;
			}
			/* create type, dup_func, and destroy_func properties for generic types */
			type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
			func_name = NULL;
			enum_value = NULL;
			func_name_constant = NULL;
			cinst = NULL;
			cspec = NULL;
			_tmp43_ = NULL;
			_tmp42_ = NULL;
			func_name = (_tmp43_ = g_strdup_printf ("%s_type", _tmp42_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp43_);
			_tmp42_ = (g_free (_tmp42_), NULL);
			_tmp46_ = NULL;
			_tmp45_ = NULL;
			_tmp44_ = NULL;
			func_name_constant = (_tmp46_ = vala_ccode_constant_new (_tmp45_ = g_strdup_printf ("\"%s-type\"", _tmp44_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (func_name_constant == NULL) ? NULL : (func_name_constant = (vala_ccode_node_unref (func_name_constant), NULL)), _tmp46_);
			_tmp45_ = (g_free (_tmp45_), NULL);
			_tmp44_ = (g_free (_tmp44_), NULL);
			_tmp49_ = NULL;
			_tmp48_ = NULL;
			_tmp47_ = NULL;
			enum_value = (_tmp49_ = g_utf8_strup (_tmp48_ = g_strdup_printf ("%s_%s", _tmp47_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), func_name), -1), enum_value = (g_free (enum_value), NULL), _tmp49_);
			_tmp48_ = (g_free (_tmp48_), NULL);
			_tmp47_ = (g_free (_tmp47_), NULL);
			_tmp51_ = NULL;
			_tmp50_ = NULL;
			cinst = (_tmp51_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp50_ = vala_ccode_identifier_new ("g_object_class_install_property"))), (cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL)), _tmp51_);
			(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
			vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) ccall);
			_tmp52_ = NULL;
			vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp52_ = vala_ccode_constant_new (enum_value)));
			(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
			_tmp54_ = NULL;
			_tmp53_ = NULL;
			cspec = (_tmp54_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp53_ = vala_ccode_identifier_new ("g_param_spec_gtype"))), (cspec == NULL) ? NULL : (cspec = (vala_ccode_node_unref (cspec), NULL)), _tmp54_);
			(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) func_name_constant);
			_tmp55_ = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp55_ = vala_ccode_constant_new ("\"type\"")));
			(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
			_tmp56_ = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp56_ = vala_ccode_constant_new ("\"type\"")));
			(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
			_tmp57_ = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp57_ = vala_ccode_identifier_new ("G_TYPE_NONE")));
			(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
			_tmp58_ = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp58_ = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY")));
			(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
			vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) cspec);
			_tmp59_ = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp59_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
			(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
			_tmp60_ = NULL;
			vala_ccode_enum_add_value (((ValaCCodeBaseModule*) self)->prop_enum, _tmp60_ = vala_ccode_enum_value_new (enum_value, NULL));
			(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
			_tmp62_ = NULL;
			_tmp61_ = NULL;
			func_name = (_tmp62_ = g_strdup_printf ("%s_dup_func", _tmp61_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp62_);
			_tmp61_ = (g_free (_tmp61_), NULL);
			_tmp65_ = NULL;
			_tmp64_ = NULL;
			_tmp63_ = NULL;
			func_name_constant = (_tmp65_ = vala_ccode_constant_new (_tmp64_ = g_strdup_printf ("\"%s-dup-func\"", _tmp63_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (func_name_constant == NULL) ? NULL : (func_name_constant = (vala_ccode_node_unref (func_name_constant), NULL)), _tmp65_);
			_tmp64_ = (g_free (_tmp64_), NULL);
			_tmp63_ = (g_free (_tmp63_), NULL);
			_tmp68_ = NULL;
			_tmp67_ = NULL;
			_tmp66_ = NULL;
			enum_value = (_tmp68_ = g_utf8_strup (_tmp67_ = g_strdup_printf ("%s_%s", _tmp66_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), func_name), -1), enum_value = (g_free (enum_value), NULL), _tmp68_);
			_tmp67_ = (g_free (_tmp67_), NULL);
			_tmp66_ = (g_free (_tmp66_), NULL);
			_tmp70_ = NULL;
			_tmp69_ = NULL;
			cinst = (_tmp70_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp69_ = vala_ccode_identifier_new ("g_object_class_install_property"))), (cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL)), _tmp70_);
			(_tmp69_ == NULL) ? NULL : (_tmp69_ = (vala_ccode_node_unref (_tmp69_), NULL));
			vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) ccall);
			_tmp71_ = NULL;
			vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp71_ = vala_ccode_constant_new (enum_value)));
			(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
			_tmp73_ = NULL;
			_tmp72_ = NULL;
			cspec = (_tmp73_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp72_ = vala_ccode_identifier_new ("g_param_spec_pointer"))), (cspec == NULL) ? NULL : (cspec = (vala_ccode_node_unref (cspec), NULL)), _tmp73_);
			(_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL));
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) func_name_constant);
			_tmp74_ = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp74_ = vala_ccode_constant_new ("\"dup func\"")));
			(_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL));
			_tmp75_ = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp75_ = vala_ccode_constant_new ("\"dup func\"")));
			(_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL));
			_tmp76_ = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp76_ = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY")));
			(_tmp76_ == NULL) ? NULL : (_tmp76_ = (vala_ccode_node_unref (_tmp76_), NULL));
			vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) cspec);
			_tmp77_ = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp77_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
			(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
			_tmp78_ = NULL;
			vala_ccode_enum_add_value (((ValaCCodeBaseModule*) self)->prop_enum, _tmp78_ = vala_ccode_enum_value_new (enum_value, NULL));
			(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
			_tmp80_ = NULL;
			_tmp79_ = NULL;
			func_name = (_tmp80_ = g_strdup_printf ("%s_destroy_func", _tmp79_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp80_);
			_tmp79_ = (g_free (_tmp79_), NULL);
			_tmp83_ = NULL;
			_tmp82_ = NULL;
			_tmp81_ = NULL;
			func_name_constant = (_tmp83_ = vala_ccode_constant_new (_tmp82_ = g_strdup_printf ("\"%s-destroy-func\"", _tmp81_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (func_name_constant == NULL) ? NULL : (func_name_constant = (vala_ccode_node_unref (func_name_constant), NULL)), _tmp83_);
			_tmp82_ = (g_free (_tmp82_), NULL);
			_tmp81_ = (g_free (_tmp81_), NULL);
			_tmp86_ = NULL;
			_tmp85_ = NULL;
			_tmp84_ = NULL;
			enum_value = (_tmp86_ = g_utf8_strup (_tmp85_ = g_strdup_printf ("%s_%s", _tmp84_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), func_name), -1), enum_value = (g_free (enum_value), NULL), _tmp86_);
			_tmp85_ = (g_free (_tmp85_), NULL);
			_tmp84_ = (g_free (_tmp84_), NULL);
			_tmp88_ = NULL;
			_tmp87_ = NULL;
			cinst = (_tmp88_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp87_ = vala_ccode_identifier_new ("g_object_class_install_property"))), (cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL)), _tmp88_);
			(_tmp87_ == NULL) ? NULL : (_tmp87_ = (vala_ccode_node_unref (_tmp87_), NULL));
			vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) ccall);
			_tmp89_ = NULL;
			vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp89_ = vala_ccode_constant_new (enum_value)));
			(_tmp89_ == NULL) ? NULL : (_tmp89_ = (vala_ccode_node_unref (_tmp89_), NULL));
			_tmp91_ = NULL;
			_tmp90_ = NULL;
			cspec = (_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp90_ = vala_ccode_identifier_new ("g_param_spec_pointer"))), (cspec == NULL) ? NULL : (cspec = (vala_ccode_node_unref (cspec), NULL)), _tmp91_);
			(_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_ccode_node_unref (_tmp90_), NULL));
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) func_name_constant);
			_tmp92_ = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp92_ = vala_ccode_constant_new ("\"destroy func\"")));
			(_tmp92_ == NULL) ? NULL : (_tmp92_ = (vala_ccode_node_unref (_tmp92_), NULL));
			_tmp93_ = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp93_ = vala_ccode_constant_new ("\"destroy func\"")));
			(_tmp93_ == NULL) ? NULL : (_tmp93_ = (vala_ccode_node_unref (_tmp93_), NULL));
			_tmp94_ = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp94_ = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY")));
			(_tmp94_ == NULL) ? NULL : (_tmp94_ = (vala_ccode_node_unref (_tmp94_), NULL));
			vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) cspec);
			_tmp95_ = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp95_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
			(_tmp95_ == NULL) ? NULL : (_tmp95_ = (vala_ccode_node_unref (_tmp95_), NULL));
			_tmp96_ = NULL;
			vala_ccode_enum_add_value (((ValaCCodeBaseModule*) self)->prop_enum, _tmp96_ = vala_ccode_enum_value_new (enum_value, NULL));
			(_tmp96_ == NULL) ? NULL : (_tmp96_ = (vala_ccode_node_unref (_tmp96_), NULL));
			(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
			func_name = (g_free (func_name), NULL);
			enum_value = (g_free (enum_value), NULL);
			(func_name_constant == NULL) ? NULL : (func_name_constant = (vala_ccode_node_unref (func_name_constant), NULL));
			(cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL));
			(cspec == NULL) ? NULL : (cspec = (vala_ccode_node_unref (cspec), NULL));
		}
		(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
	}
	/* create properties */
	props = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	{
		GeeIterator* _prop_it;
		_prop_it = gee_iterable_iterator ((GeeIterable*) props);
		while (TRUE) {
			ValaProperty* prop;
			gboolean _tmp97_;
			if (!gee_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			if (!vala_ccode_base_module_is_gobject_property ((ValaCCodeBaseModule*) self, prop)) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			_tmp97_ = FALSE;
			if (vala_property_get_overrides (prop)) {
				_tmp97_ = TRUE;
			} else {
				_tmp97_ = vala_property_get_base_interface_property (prop) != NULL;
			}
			if (_tmp97_) {
				ValaCCodeIdentifier* _tmp98_;
				ValaCCodeFunctionCall* _tmp99_;
				ValaCCodeFunctionCall* cinst;
				ValaCCodeConstant* _tmp101_;
				char* _tmp100_;
				ValaCCodeConstant* _tmp102_;
				ValaCCodeExpressionStatement* _tmp103_;
				_tmp98_ = NULL;
				_tmp99_ = NULL;
				cinst = (_tmp99_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp98_ = vala_ccode_identifier_new ("g_object_class_override_property"))), (_tmp98_ == NULL) ? NULL : (_tmp98_ = (vala_ccode_node_unref (_tmp98_), NULL)), _tmp99_);
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) ccall);
				_tmp101_ = NULL;
				_tmp100_ = NULL;
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp101_ = vala_ccode_constant_new (_tmp100_ = vala_property_get_upper_case_cname (prop))));
				(_tmp101_ == NULL) ? NULL : (_tmp101_ = (vala_ccode_node_unref (_tmp101_), NULL));
				_tmp100_ = (g_free (_tmp100_), NULL);
				_tmp102_ = NULL;
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp102_ = vala_property_get_canonical_cconstant (prop)));
				(_tmp102_ == NULL) ? NULL : (_tmp102_ = (vala_ccode_node_unref (_tmp102_), NULL));
				_tmp103_ = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp103_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
				(_tmp103_ == NULL) ? NULL : (_tmp103_ = (vala_ccode_node_unref (_tmp103_), NULL));
				(cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL));
			} else {
				ValaCCodeIdentifier* _tmp104_;
				ValaCCodeFunctionCall* _tmp105_;
				ValaCCodeFunctionCall* cinst;
				ValaCCodeConstant* _tmp107_;
				char* _tmp106_;
				ValaCCodeFunctionCall* _tmp108_;
				ValaCCodeExpressionStatement* _tmp109_;
				_tmp104_ = NULL;
				_tmp105_ = NULL;
				cinst = (_tmp105_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp104_ = vala_ccode_identifier_new ("g_object_class_install_property"))), (_tmp104_ == NULL) ? NULL : (_tmp104_ = (vala_ccode_node_unref (_tmp104_), NULL)), _tmp105_);
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) ccall);
				_tmp107_ = NULL;
				_tmp106_ = NULL;
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp107_ = vala_ccode_constant_new (_tmp106_ = vala_property_get_upper_case_cname (prop))));
				(_tmp107_ == NULL) ? NULL : (_tmp107_ = (vala_ccode_node_unref (_tmp107_), NULL));
				_tmp106_ = (g_free (_tmp106_), NULL);
				_tmp108_ = NULL;
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp108_ = vala_ccode_module_get_param_spec (vala_ccode_module_get_head ((ValaCCodeModule*) self), prop)));
				(_tmp108_ == NULL) ? NULL : (_tmp108_ = (vala_ccode_node_unref (_tmp108_), NULL));
				_tmp109_ = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp109_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
				(_tmp109_ == NULL) ? NULL : (_tmp109_ = (vala_ccode_node_unref (_tmp109_), NULL));
				(cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL));
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(props == NULL) ? NULL : (props = (gee_collection_object_unref (props), NULL));
}


static gboolean vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self, ValaClass* cl) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _prop_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_prop_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (TRUE) {
			ValaProperty* prop;
			if (!gee_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			if (vala_property_get_get_accessor (prop) != NULL) {
				result = TRUE;
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
				return result;
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	result = FALSE;
	return result;
}


static gboolean vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self, ValaClass* cl) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _prop_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_prop_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (TRUE) {
			ValaProperty* prop;
			if (!gee_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			if (vala_property_get_set_accessor (prop) != NULL) {
				result = TRUE;
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
				return result;
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	result = FALSE;
	return result;
}


static void vala_gobject_module_add_get_property_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* get_prop;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeFormalParameter* _tmp5_;
	ValaCCodeFormalParameter* _tmp6_;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeFunctionCall* _tmp8_;
	ValaCCodeFunctionCall* ccall;
	char* _tmp10_;
	char* _tmp9_;
	ValaCCodeDeclaration* _tmp11_;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp12_;
	ValaCCodeDeclaration* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeSwitchStatement* _tmp16_;
	ValaCCodeSwitchStatement* cswitch;
	GeeList* props;
	ValaCCodeLabel* _tmp57_;
	ValaCCodeStatement* _tmp58_;
	ValaCCodeBreakStatement* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	get_prop = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_get_property", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	vala_ccode_function_set_modifiers (get_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (get_prop, _tmp3_ = vala_ccode_formal_parameter_new ("object", "GObject *"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (get_prop, _tmp4_ = vala_ccode_formal_parameter_new ("property_id", "guint"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_add_parameter (get_prop, _tmp5_ = vala_ccode_formal_parameter_new ("value", "GValue *"));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (get_prop, _tmp6_ = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *"));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	block = vala_ccode_block_new ();
	_tmp7_ = NULL;
	_tmp8_ = NULL;
	ccall = (_tmp8_ = (ValaCCodeFunctionCall*) vala_instance_cast_new ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("object")), (ValaTypeSymbol*) cl), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL)), _tmp8_);
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	_tmp11_ = NULL;
	_cdecl_ = (_tmp11_ = vala_ccode_declaration_new (_tmp10_ = g_strdup_printf ("%s *", _tmp9_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp10_ = (g_free (_tmp10_), NULL), _tmp9_ = (g_free (_tmp9_), NULL), _tmp11_);
	_tmp12_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp12_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) ccall, NULL)));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp13_ = NULL;
	_cdecl_ = (_tmp13_ = vala_ccode_declaration_new ("gpointer"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp13_);
	_tmp14_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp14_ = vala_ccode_variable_declarator_new ("boxed", NULL, NULL)));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp15_ = NULL;
	_tmp16_ = NULL;
	cswitch = (_tmp16_ = vala_ccode_switch_statement_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("property_id"))), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL)), _tmp16_);
	props = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	{
		GeeIterator* _prop_it;
		_prop_it = gee_iterable_iterator ((GeeIterable*) props);
		while (TRUE) {
			ValaProperty* prop;
			gboolean _tmp17_;
			char* prefix;
			ValaCCodeExpression* cself;
			ValaCCodeCaseStatement* _tmp30_;
			ValaCCodeIdentifier* _tmp29_;
			char* _tmp28_;
			ValaCCodeBreakStatement* _tmp56_;
			if (!gee_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			_tmp17_ = FALSE;
			if (vala_property_get_get_accessor (prop) == NULL) {
				_tmp17_ = TRUE;
			} else {
				_tmp17_ = vala_property_get_is_abstract (prop);
			}
			if (_tmp17_) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (!vala_ccode_base_module_is_gobject_property ((ValaCCodeBaseModule*) self, prop)) {
				/* don't register private properties*/
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			prefix = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL);
			cself = (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
			if (vala_property_get_base_property (prop) != NULL) {
				ValaClass* _tmp18_;
				ValaClass* base_type;
				char* _tmp19_;
				ValaCCodeExpression* _tmp22_;
				ValaObjectType* _tmp21_;
				ValaObjectType* _tmp20_;
				_tmp18_ = NULL;
				base_type = (_tmp18_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop))), (_tmp18_ == NULL) ? NULL : vala_code_node_ref (_tmp18_));
				_tmp19_ = NULL;
				prefix = (_tmp19_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_type, NULL), prefix = (g_free (prefix), NULL), _tmp19_);
				_tmp22_ = NULL;
				_tmp21_ = NULL;
				_tmp20_ = NULL;
				cself = (_tmp22_ = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, cself, (ValaDataType*) (_tmp20_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl)), (ValaDataType*) (_tmp21_ = vala_object_type_new ((ValaObjectTypeSymbol*) base_type)), NULL), (cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL)), _tmp22_);
				(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_code_node_unref (_tmp21_), NULL));
				(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_code_node_unref (_tmp20_), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			} else {
				if (vala_property_get_base_interface_property (prop) != NULL) {
					ValaInterface* _tmp23_;
					ValaInterface* base_type;
					char* _tmp24_;
					ValaCCodeExpression* _tmp27_;
					ValaObjectType* _tmp26_;
					ValaObjectType* _tmp25_;
					_tmp23_ = NULL;
					base_type = (_tmp23_ = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop))), (_tmp23_ == NULL) ? NULL : vala_code_node_ref (_tmp23_));
					_tmp24_ = NULL;
					prefix = (_tmp24_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_type, NULL), prefix = (g_free (prefix), NULL), _tmp24_);
					_tmp27_ = NULL;
					_tmp26_ = NULL;
					_tmp25_ = NULL;
					cself = (_tmp27_ = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, cself, (ValaDataType*) (_tmp25_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl)), (ValaDataType*) (_tmp26_ = vala_object_type_new ((ValaObjectTypeSymbol*) base_type)), NULL), (cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL)), _tmp27_);
					(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_code_node_unref (_tmp26_), NULL));
					(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_code_node_unref (_tmp25_), NULL));
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				}
			}
			_tmp30_ = NULL;
			_tmp29_ = NULL;
			_tmp28_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp30_ = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new (_tmp28_ = vala_property_get_upper_case_cname (prop))))));
			(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
			(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
			_tmp28_ = (g_free (_tmp28_), NULL);
			if (vala_data_type_is_real_struct_type (vala_property_get_property_type (prop))) {
				ValaStruct* _tmp32_;
				ValaTypeSymbol* _tmp31_;
				ValaStruct* st;
				ValaCCodeIdentifier* _tmp33_;
				ValaCCodeFunctionCall* _tmp34_;
				ValaCCodeFunctionCall* struct_creation;
				ValaCCodeIdentifier* _tmp36_;
				char* _tmp35_;
				ValaCCodeConstant* _tmp37_;
				ValaCCodeExpressionStatement* _tmp40_;
				ValaCCodeAssignment* _tmp39_;
				ValaCCodeIdentifier* _tmp38_;
				ValaCCodeFunctionCall* _tmp43_;
				ValaCCodeIdentifier* _tmp42_;
				char* _tmp41_;
				ValaCCodeIdentifier* _tmp44_;
				ValaCCodeIdentifier* _tmp45_;
				ValaCCodeFunctionCall* _tmp46_;
				ValaCCodeFunctionCall* csetcall;
				ValaCCodeIdentifier* _tmp47_;
				ValaCCodeIdentifier* _tmp48_;
				ValaCCodeExpressionStatement* _tmp49_;
				_tmp32_ = NULL;
				_tmp31_ = NULL;
				st = (_tmp32_ = (_tmp31_ = vala_data_type_get_data_type (vala_property_get_property_type (prop)), VALA_IS_STRUCT (_tmp31_) ? ((ValaStruct*) _tmp31_) : NULL), (_tmp32_ == NULL) ? NULL : vala_code_node_ref (_tmp32_));
				_tmp33_ = NULL;
				_tmp34_ = NULL;
				struct_creation = (_tmp34_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new ("g_new0"))), (_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL)), _tmp34_);
				_tmp36_ = NULL;
				_tmp35_ = NULL;
				vala_ccode_function_call_add_argument (struct_creation, (ValaCCodeExpression*) (_tmp36_ = vala_ccode_identifier_new (_tmp35_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE))));
				(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
				_tmp35_ = (g_free (_tmp35_), NULL);
				_tmp37_ = NULL;
				vala_ccode_function_call_add_argument (struct_creation, (ValaCCodeExpression*) (_tmp37_ = vala_ccode_constant_new ("1")));
				(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
				_tmp40_ = NULL;
				_tmp39_ = NULL;
				_tmp38_ = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp40_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp39_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp38_ = vala_ccode_identifier_new ("boxed")), (ValaCCodeExpression*) struct_creation, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
				(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
				(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
				_tmp43_ = NULL;
				_tmp42_ = NULL;
				_tmp41_ = NULL;
				ccall = (_tmp43_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp42_ = vala_ccode_identifier_new (_tmp41_ = g_strdup_printf ("%s_get_%s", prefix, vala_symbol_get_name ((ValaSymbol*) prop))))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp43_);
				(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
				_tmp41_ = (g_free (_tmp41_), NULL);
				vala_ccode_function_call_add_argument (ccall, cself);
				_tmp44_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp44_ = vala_ccode_identifier_new ("boxed")));
				(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
				_tmp45_ = NULL;
				_tmp46_ = NULL;
				csetcall = (_tmp46_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp45_ = vala_ccode_identifier_new ("g_value_take_boxed"))), (_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL)), _tmp46_);
				_tmp47_ = NULL;
				vala_ccode_function_call_add_argument (csetcall, (ValaCCodeExpression*) (_tmp47_ = vala_ccode_identifier_new ("value")));
				(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
				_tmp48_ = NULL;
				vala_ccode_function_call_add_argument (csetcall, (ValaCCodeExpression*) (_tmp48_ = vala_ccode_identifier_new ("boxed")));
				(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
				_tmp49_ = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp49_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) csetcall)));
				(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				(struct_creation == NULL) ? NULL : (struct_creation = (vala_ccode_node_unref (struct_creation), NULL));
				(csetcall == NULL) ? NULL : (csetcall = (vala_ccode_node_unref (csetcall), NULL));
			} else {
				ValaCCodeFunctionCall* _tmp52_;
				ValaCCodeIdentifier* _tmp51_;
				char* _tmp50_;
				ValaCCodeFunctionCall* csetcall;
				ValaCCodeIdentifier* _tmp53_;
				ValaCCodeIdentifier* _tmp54_;
				ValaCCodeExpressionStatement* _tmp55_;
				_tmp52_ = NULL;
				_tmp51_ = NULL;
				_tmp50_ = NULL;
				ccall = (_tmp52_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp51_ = vala_ccode_identifier_new (_tmp50_ = g_strdup_printf ("%s_get_%s", prefix, vala_symbol_get_name ((ValaSymbol*) prop))))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp52_);
				(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
				_tmp50_ = (g_free (_tmp50_), NULL);
				vala_ccode_function_call_add_argument (ccall, cself);
				csetcall = vala_ccode_function_call_new (NULL);
				_tmp53_ = NULL;
				vala_ccode_function_call_set_call (csetcall, (ValaCCodeExpression*) (_tmp53_ = vala_ccode_module_get_value_setter_function (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_property_get_property_type (prop))));
				(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
				_tmp54_ = NULL;
				vala_ccode_function_call_add_argument (csetcall, (ValaCCodeExpression*) (_tmp54_ = vala_ccode_identifier_new ("value")));
				(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
				vala_ccode_function_call_add_argument (csetcall, (ValaCCodeExpression*) ccall);
				_tmp55_ = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp55_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) csetcall)));
				(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
				(csetcall == NULL) ? NULL : (csetcall = (vala_ccode_node_unref (csetcall), NULL));
			}
			_tmp56_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp56_ = vala_ccode_break_statement_new ()));
			(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			prefix = (g_free (prefix), NULL);
			(cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	_tmp57_ = NULL;
	vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp57_ = vala_ccode_label_new ("default")));
	(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
	_tmp58_ = NULL;
	vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp58_ = vala_gobject_module_get_invalid_property_id_warn_statement (self)));
	(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
	_tmp59_ = NULL;
	vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp59_ = vala_ccode_break_statement_new ()));
	(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cswitch);
	_tmp60_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp60_ = vala_ccode_function_copy (get_prop)));
	(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
	vala_ccode_function_set_block (get_prop, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) get_prop);
	(get_prop == NULL) ? NULL : (get_prop = (vala_ccode_node_unref (get_prop), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(cswitch == NULL) ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL));
	(props == NULL) ? NULL : (props = (gee_collection_object_unref (props), NULL));
}


static void vala_gobject_module_add_set_property_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* set_prop;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeFormalParameter* _tmp5_;
	ValaCCodeFormalParameter* _tmp6_;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeFunctionCall* _tmp8_;
	ValaCCodeFunctionCall* ccall;
	char* _tmp10_;
	char* _tmp9_;
	ValaCCodeDeclaration* _tmp11_;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeSwitchStatement* _tmp14_;
	ValaCCodeSwitchStatement* cswitch;
	GeeList* props;
	ValaCCodeLabel* _tmp38_;
	ValaCCodeStatement* _tmp39_;
	ValaCCodeBreakStatement* _tmp40_;
	ValaCCodeFunction* _tmp91_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	set_prop = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_set_property", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	vala_ccode_function_set_modifiers (set_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (set_prop, _tmp3_ = vala_ccode_formal_parameter_new ("object", "GObject *"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (set_prop, _tmp4_ = vala_ccode_formal_parameter_new ("property_id", "guint"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_add_parameter (set_prop, _tmp5_ = vala_ccode_formal_parameter_new ("value", "const GValue *"));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (set_prop, _tmp6_ = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *"));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	block = vala_ccode_block_new ();
	_tmp7_ = NULL;
	_tmp8_ = NULL;
	ccall = (_tmp8_ = (ValaCCodeFunctionCall*) vala_instance_cast_new ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("object")), (ValaTypeSymbol*) cl), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL)), _tmp8_);
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	_tmp11_ = NULL;
	_cdecl_ = (_tmp11_ = vala_ccode_declaration_new (_tmp10_ = g_strdup_printf ("%s *", _tmp9_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp10_ = (g_free (_tmp10_), NULL), _tmp9_ = (g_free (_tmp9_), NULL), _tmp11_);
	_tmp12_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp12_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) ccall, NULL)));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp13_ = NULL;
	_tmp14_ = NULL;
	cswitch = (_tmp14_ = vala_ccode_switch_statement_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("property_id"))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp14_);
	props = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	{
		GeeIterator* _prop_it;
		_prop_it = gee_iterable_iterator ((GeeIterable*) props);
		while (TRUE) {
			ValaProperty* prop;
			gboolean _tmp15_;
			char* prefix;
			ValaCCodeExpression* cself;
			ValaCCodeCaseStatement* _tmp28_;
			ValaCCodeIdentifier* _tmp27_;
			char* _tmp26_;
			ValaCCodeFunctionCall* _tmp31_;
			ValaCCodeIdentifier* _tmp30_;
			char* _tmp29_;
			ValaCCodeFunctionCall* cgetcall;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeExpressionStatement* _tmp36_;
			ValaCCodeBreakStatement* _tmp37_;
			if (!gee_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			_tmp15_ = FALSE;
			if (vala_property_get_set_accessor (prop) == NULL) {
				_tmp15_ = TRUE;
			} else {
				_tmp15_ = vala_property_get_is_abstract (prop);
			}
			if (_tmp15_) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (!vala_ccode_base_module_is_gobject_property ((ValaCCodeBaseModule*) self, prop)) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			prefix = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL);
			cself = (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
			if (vala_property_get_base_property (prop) != NULL) {
				ValaClass* _tmp16_;
				ValaClass* base_type;
				char* _tmp17_;
				ValaCCodeExpression* _tmp20_;
				ValaObjectType* _tmp19_;
				ValaObjectType* _tmp18_;
				_tmp16_ = NULL;
				base_type = (_tmp16_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop))), (_tmp16_ == NULL) ? NULL : vala_code_node_ref (_tmp16_));
				_tmp17_ = NULL;
				prefix = (_tmp17_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_type, NULL), prefix = (g_free (prefix), NULL), _tmp17_);
				_tmp20_ = NULL;
				_tmp19_ = NULL;
				_tmp18_ = NULL;
				cself = (_tmp20_ = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, cself, (ValaDataType*) (_tmp18_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl)), (ValaDataType*) (_tmp19_ = vala_object_type_new ((ValaObjectTypeSymbol*) base_type)), NULL), (cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL)), _tmp20_);
				(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_code_node_unref (_tmp19_), NULL));
				(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_code_node_unref (_tmp18_), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			} else {
				if (vala_property_get_base_interface_property (prop) != NULL) {
					ValaInterface* _tmp21_;
					ValaInterface* base_type;
					char* _tmp22_;
					ValaCCodeExpression* _tmp25_;
					ValaObjectType* _tmp24_;
					ValaObjectType* _tmp23_;
					_tmp21_ = NULL;
					base_type = (_tmp21_ = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop))), (_tmp21_ == NULL) ? NULL : vala_code_node_ref (_tmp21_));
					_tmp22_ = NULL;
					prefix = (_tmp22_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_type, NULL), prefix = (g_free (prefix), NULL), _tmp22_);
					_tmp25_ = NULL;
					_tmp24_ = NULL;
					_tmp23_ = NULL;
					cself = (_tmp25_ = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, cself, (ValaDataType*) (_tmp23_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl)), (ValaDataType*) (_tmp24_ = vala_object_type_new ((ValaObjectTypeSymbol*) base_type)), NULL), (cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL)), _tmp25_);
					(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_code_node_unref (_tmp24_), NULL));
					(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_code_node_unref (_tmp23_), NULL));
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				}
			}
			_tmp28_ = NULL;
			_tmp27_ = NULL;
			_tmp26_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp28_ = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new (_tmp26_ = vala_property_get_upper_case_cname (prop))))));
			(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
			(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
			_tmp26_ = (g_free (_tmp26_), NULL);
			_tmp31_ = NULL;
			_tmp30_ = NULL;
			_tmp29_ = NULL;
			ccall = (_tmp31_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new (_tmp29_ = g_strdup_printf ("%s_set_%s", prefix, vala_symbol_get_name ((ValaSymbol*) prop))))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp31_);
			(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
			_tmp29_ = (g_free (_tmp29_), NULL);
			vala_ccode_function_call_add_argument (ccall, cself);
			cgetcall = vala_ccode_function_call_new (NULL);
			if (vala_data_type_get_data_type (vala_property_get_property_type (prop)) != NULL) {
				ValaCCodeIdentifier* _tmp33_;
				char* _tmp32_;
				_tmp33_ = NULL;
				_tmp32_ = NULL;
				vala_ccode_function_call_set_call (cgetcall, (ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new (_tmp32_ = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_property_get_property_type (prop))))));
				(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
				_tmp32_ = (g_free (_tmp32_), NULL);
			} else {
				ValaCCodeIdentifier* _tmp34_;
				_tmp34_ = NULL;
				vala_ccode_function_call_set_call (cgetcall, (ValaCCodeExpression*) (_tmp34_ = vala_ccode_identifier_new ("g_value_get_pointer")));
				(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
			}
			_tmp35_ = NULL;
			vala_ccode_function_call_add_argument (cgetcall, (ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new ("value")));
			(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) cgetcall);
			_tmp36_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp36_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
			(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
			_tmp37_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp37_ = vala_ccode_break_statement_new ()));
			(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			prefix = (g_free (prefix), NULL);
			(cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL));
			(cgetcall == NULL) ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	_tmp38_ = NULL;
	vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp38_ = vala_ccode_label_new ("default")));
	(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
	_tmp39_ = NULL;
	vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp39_ = vala_gobject_module_get_invalid_property_id_warn_statement (self)));
	(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
	_tmp40_ = NULL;
	vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp40_ = vala_ccode_break_statement_new ()));
	(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cswitch);
	/* type, dup func, and destroy func properties for generic types */
	{
		GeeList* _tmp41_;
		GeeIterator* _tmp42_;
		GeeIterator* _type_param_it;
		/* type, dup func, and destroy func properties for generic types */
		_tmp41_ = NULL;
		_tmp42_ = NULL;
		_type_param_it = (_tmp42_ = gee_iterable_iterator ((GeeIterable*) (_tmp41_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))), (_tmp41_ == NULL) ? NULL : (_tmp41_ = (gee_collection_object_unref (_tmp41_), NULL)), _tmp42_);
		/* type, dup func, and destroy func properties for generic types */
		while (TRUE) {
			ValaTypeParameter* type_param;
			char* func_name;
			char* enum_value;
			ValaCCodeMemberAccess* cfield;
			ValaCCodeFunctionCall* cgetcall;
			char* _tmp44_;
			char* _tmp43_;
			char* _tmp47_;
			char* _tmp46_;
			char* _tmp45_;
			ValaCCodeCaseStatement* _tmp49_;
			ValaCCodeIdentifier* _tmp48_;
			ValaCCodeMemberAccess* _tmp52_;
			ValaCCodeMemberAccess* _tmp51_;
			ValaCCodeIdentifier* _tmp50_;
			ValaCCodeFunctionCall* _tmp54_;
			ValaCCodeIdentifier* _tmp53_;
			ValaCCodeIdentifier* _tmp55_;
			ValaCCodeExpressionStatement* _tmp57_;
			ValaCCodeAssignment* _tmp56_;
			ValaCCodeBreakStatement* _tmp58_;
			char* _tmp60_;
			char* _tmp59_;
			char* _tmp63_;
			char* _tmp62_;
			char* _tmp61_;
			ValaCCodeCaseStatement* _tmp65_;
			ValaCCodeIdentifier* _tmp64_;
			ValaCCodeMemberAccess* _tmp68_;
			ValaCCodeMemberAccess* _tmp67_;
			ValaCCodeIdentifier* _tmp66_;
			ValaCCodeFunctionCall* _tmp70_;
			ValaCCodeIdentifier* _tmp69_;
			ValaCCodeIdentifier* _tmp71_;
			ValaCCodeExpressionStatement* _tmp73_;
			ValaCCodeAssignment* _tmp72_;
			ValaCCodeBreakStatement* _tmp74_;
			char* _tmp76_;
			char* _tmp75_;
			char* _tmp79_;
			char* _tmp78_;
			char* _tmp77_;
			ValaCCodeCaseStatement* _tmp81_;
			ValaCCodeIdentifier* _tmp80_;
			ValaCCodeMemberAccess* _tmp84_;
			ValaCCodeMemberAccess* _tmp83_;
			ValaCCodeIdentifier* _tmp82_;
			ValaCCodeFunctionCall* _tmp86_;
			ValaCCodeIdentifier* _tmp85_;
			ValaCCodeIdentifier* _tmp87_;
			ValaCCodeExpressionStatement* _tmp89_;
			ValaCCodeAssignment* _tmp88_;
			ValaCCodeBreakStatement* _tmp90_;
			/* type, dup func, and destroy func properties for generic types */
			if (!gee_iterator_next (_type_param_it)) {
				/* type, dup func, and destroy func properties for generic types */
				break;
			}
			/* type, dup func, and destroy func properties for generic types */
			type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
			func_name = NULL;
			enum_value = NULL;
			cfield = NULL;
			cgetcall = NULL;
			_tmp44_ = NULL;
			_tmp43_ = NULL;
			func_name = (_tmp44_ = g_strdup_printf ("%s_type", _tmp43_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp44_);
			_tmp43_ = (g_free (_tmp43_), NULL);
			_tmp47_ = NULL;
			_tmp46_ = NULL;
			_tmp45_ = NULL;
			enum_value = (_tmp47_ = g_utf8_strup (_tmp46_ = g_strdup_printf ("%s_%s", _tmp45_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), func_name), -1), enum_value = (g_free (enum_value), NULL), _tmp47_);
			_tmp46_ = (g_free (_tmp46_), NULL);
			_tmp45_ = (g_free (_tmp45_), NULL);
			_tmp49_ = NULL;
			_tmp48_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp49_ = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp48_ = vala_ccode_identifier_new (enum_value)))));
			(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
			(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
			_tmp52_ = NULL;
			_tmp51_ = NULL;
			_tmp50_ = NULL;
			cfield = (_tmp52_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp51_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp50_ = vala_ccode_identifier_new ("self")), "priv")), func_name), (cfield == NULL) ? NULL : (cfield = (vala_ccode_node_unref (cfield), NULL)), _tmp52_);
			(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
			(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
			_tmp54_ = NULL;
			_tmp53_ = NULL;
			cgetcall = (_tmp54_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp53_ = vala_ccode_identifier_new ("g_value_get_gtype"))), (cgetcall == NULL) ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL)), _tmp54_);
			(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
			_tmp55_ = NULL;
			vala_ccode_function_call_add_argument (cgetcall, (ValaCCodeExpression*) (_tmp55_ = vala_ccode_identifier_new ("value")));
			(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
			_tmp57_ = NULL;
			_tmp56_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp57_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp56_ = vala_ccode_assignment_new ((ValaCCodeExpression*) cfield, (ValaCCodeExpression*) cgetcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
			(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
			_tmp58_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp58_ = vala_ccode_break_statement_new ()));
			(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
			_tmp60_ = NULL;
			_tmp59_ = NULL;
			func_name = (_tmp60_ = g_strdup_printf ("%s_dup_func", _tmp59_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp60_);
			_tmp59_ = (g_free (_tmp59_), NULL);
			_tmp63_ = NULL;
			_tmp62_ = NULL;
			_tmp61_ = NULL;
			enum_value = (_tmp63_ = g_utf8_strup (_tmp62_ = g_strdup_printf ("%s_%s", _tmp61_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), func_name), -1), enum_value = (g_free (enum_value), NULL), _tmp63_);
			_tmp62_ = (g_free (_tmp62_), NULL);
			_tmp61_ = (g_free (_tmp61_), NULL);
			_tmp65_ = NULL;
			_tmp64_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp65_ = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp64_ = vala_ccode_identifier_new (enum_value)))));
			(_tmp65_ == NULL) ? NULL : (_tmp65_ = (vala_ccode_node_unref (_tmp65_), NULL));
			(_tmp64_ == NULL) ? NULL : (_tmp64_ = (vala_ccode_node_unref (_tmp64_), NULL));
			_tmp68_ = NULL;
			_tmp67_ = NULL;
			_tmp66_ = NULL;
			cfield = (_tmp68_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp67_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp66_ = vala_ccode_identifier_new ("self")), "priv")), func_name), (cfield == NULL) ? NULL : (cfield = (vala_ccode_node_unref (cfield), NULL)), _tmp68_);
			(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
			(_tmp66_ == NULL) ? NULL : (_tmp66_ = (vala_ccode_node_unref (_tmp66_), NULL));
			_tmp70_ = NULL;
			_tmp69_ = NULL;
			cgetcall = (_tmp70_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp69_ = vala_ccode_identifier_new ("g_value_get_pointer"))), (cgetcall == NULL) ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL)), _tmp70_);
			(_tmp69_ == NULL) ? NULL : (_tmp69_ = (vala_ccode_node_unref (_tmp69_), NULL));
			_tmp71_ = NULL;
			vala_ccode_function_call_add_argument (cgetcall, (ValaCCodeExpression*) (_tmp71_ = vala_ccode_identifier_new ("value")));
			(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
			_tmp73_ = NULL;
			_tmp72_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp73_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp72_ = vala_ccode_assignment_new ((ValaCCodeExpression*) cfield, (ValaCCodeExpression*) cgetcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp73_ == NULL) ? NULL : (_tmp73_ = (vala_ccode_node_unref (_tmp73_), NULL));
			(_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL));
			_tmp74_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp74_ = vala_ccode_break_statement_new ()));
			(_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL));
			_tmp76_ = NULL;
			_tmp75_ = NULL;
			func_name = (_tmp76_ = g_strdup_printf ("%s_destroy_func", _tmp75_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp76_);
			_tmp75_ = (g_free (_tmp75_), NULL);
			_tmp79_ = NULL;
			_tmp78_ = NULL;
			_tmp77_ = NULL;
			enum_value = (_tmp79_ = g_utf8_strup (_tmp78_ = g_strdup_printf ("%s_%s", _tmp77_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), func_name), -1), enum_value = (g_free (enum_value), NULL), _tmp79_);
			_tmp78_ = (g_free (_tmp78_), NULL);
			_tmp77_ = (g_free (_tmp77_), NULL);
			_tmp81_ = NULL;
			_tmp80_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp81_ = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp80_ = vala_ccode_identifier_new (enum_value)))));
			(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_ccode_node_unref (_tmp81_), NULL));
			(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
			_tmp84_ = NULL;
			_tmp83_ = NULL;
			_tmp82_ = NULL;
			cfield = (_tmp84_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp83_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp82_ = vala_ccode_identifier_new ("self")), "priv")), func_name), (cfield == NULL) ? NULL : (cfield = (vala_ccode_node_unref (cfield), NULL)), _tmp84_);
			(_tmp83_ == NULL) ? NULL : (_tmp83_ = (vala_ccode_node_unref (_tmp83_), NULL));
			(_tmp82_ == NULL) ? NULL : (_tmp82_ = (vala_ccode_node_unref (_tmp82_), NULL));
			_tmp86_ = NULL;
			_tmp85_ = NULL;
			cgetcall = (_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp85_ = vala_ccode_identifier_new ("g_value_get_pointer"))), (cgetcall == NULL) ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL)), _tmp86_);
			(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
			_tmp87_ = NULL;
			vala_ccode_function_call_add_argument (cgetcall, (ValaCCodeExpression*) (_tmp87_ = vala_ccode_identifier_new ("value")));
			(_tmp87_ == NULL) ? NULL : (_tmp87_ = (vala_ccode_node_unref (_tmp87_), NULL));
			_tmp89_ = NULL;
			_tmp88_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp89_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp88_ = vala_ccode_assignment_new ((ValaCCodeExpression*) cfield, (ValaCCodeExpression*) cgetcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp89_ == NULL) ? NULL : (_tmp89_ = (vala_ccode_node_unref (_tmp89_), NULL));
			(_tmp88_ == NULL) ? NULL : (_tmp88_ = (vala_ccode_node_unref (_tmp88_), NULL));
			_tmp90_ = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp90_ = vala_ccode_break_statement_new ()));
			(_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_ccode_node_unref (_tmp90_), NULL));
			(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
			func_name = (g_free (func_name), NULL);
			enum_value = (g_free (enum_value), NULL);
			(cfield == NULL) ? NULL : (cfield = (vala_ccode_node_unref (cfield), NULL));
			(cgetcall == NULL) ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL));
		}
		(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
	}
	_tmp91_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp91_ = vala_ccode_function_copy (set_prop)));
	(_tmp91_ == NULL) ? NULL : (_tmp91_ = (vala_ccode_node_unref (_tmp91_), NULL));
	vala_ccode_function_set_block (set_prop, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) set_prop);
	(set_prop == NULL) ? NULL : (set_prop = (vala_ccode_node_unref (set_prop), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(cswitch == NULL) ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL));
	(props == NULL) ? NULL : (props = (gee_collection_object_unref (props), NULL));
}


static ValaCCodeStatement* vala_gobject_module_get_invalid_property_id_warn_statement (ValaGObjectModule* self) {
	ValaCCodeStatement* result;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* cwarn;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	/* warn on invalid property id*/
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	cwarn = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("G_OBJECT_WARN_INVALID_PROPERTY_ID"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("object")));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("property_id")));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("pspec")));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	result = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) cwarn);
	(cwarn == NULL) ? NULL : (cwarn = (vala_ccode_node_unref (cwarn), NULL));
	return result;
}


static ValaCCodeExpression* vala_gobject_module_real_get_construct_property_assignment (ValaCCodeModule* base, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value) {
	ValaGObjectModule * self;
	ValaCCodeExpression* result;
	ValaCCodeIdentifier* cpointer;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeMemberAccess* cnamemember;
	ValaCCodeAssignment* cnameassign;
	ValaCCodeMemberAccess* _tmp0_;
	ValaCCodeUnaryExpression* _tmp1_;
	ValaCCodeUnaryExpression* gvaluearg;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* cvalueinit;
	ValaCCodeIdentifier* _tmp5_;
	char* _tmp4_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeFunctionCall* _tmp7_;
	ValaCCodeFunctionCall* cvalueset;
	ValaCCodeUnaryExpression* _tmp9_;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (canonical_cconstant != NULL, NULL);
	g_return_val_if_fail (property_type != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	/* this property is used as a construction parameter*/
	cpointer = vala_ccode_identifier_new ("__params_it");
	ccomma = vala_ccode_comma_expression_new ();
	/* set name in array for current parameter*/
	cnamemember = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) cpointer, "name");
	cnameassign = vala_ccode_assignment_new ((ValaCCodeExpression*) cnamemember, (ValaCCodeExpression*) canonical_cconstant, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) cnameassign);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	gvaluearg = (_tmp1_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp0_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) cpointer, "value"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	/* initialize GValue in array for current parameter*/
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	cvalueinit = (_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("g_value_init"))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL)), _tmp3_);
	vala_ccode_function_call_add_argument (cvalueinit, (ValaCCodeExpression*) gvaluearg);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	vala_ccode_function_call_add_argument (cvalueinit, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new (_tmp4_ = vala_data_type_get_type_id (property_type))));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp4_ = (g_free (_tmp4_), NULL);
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) cvalueinit);
	/* set GValue for current parameter*/
	_tmp6_ = NULL;
	_tmp7_ = NULL;
	cvalueset = (_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_module_get_value_setter_function ((ValaCCodeModule*) self, property_type))), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL)), _tmp7_);
	vala_ccode_function_call_add_argument (cvalueset, (ValaCCodeExpression*) gvaluearg);
	if (vala_data_type_is_real_struct_type (property_type)) {
		ValaCCodeUnaryExpression* _tmp8_;
		_tmp8_ = NULL;
		vala_ccode_function_call_add_argument (cvalueset, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, value)));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	} else {
		vala_ccode_function_call_add_argument (cvalueset, value);
	}
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) cvalueset);
	/* move pointer to next parameter in array*/
	_tmp9_ = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) cpointer)));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	result = (ValaCCodeExpression*) ccomma;
	(cpointer == NULL) ? NULL : (cpointer = (vala_ccode_node_unref (cpointer), NULL));
	(cnamemember == NULL) ? NULL : (cnamemember = (vala_ccode_node_unref (cnamemember), NULL));
	(cnameassign == NULL) ? NULL : (cnameassign = (vala_ccode_node_unref (cnameassign), NULL));
	(gvaluearg == NULL) ? NULL : (gvaluearg = (vala_ccode_node_unref (gvaluearg), NULL));
	(cvalueinit == NULL) ? NULL : (cvalueinit = (vala_ccode_node_unref (cvalueinit), NULL));
	(cvalueset == NULL) ? NULL : (cvalueset = (vala_ccode_node_unref (cvalueset), NULL));
	return result;
}


static void vala_gobject_module_real_visit_constructor (ValaCCodeModule* base, ValaConstructor* c) {
	ValaGObjectModule * self;
	gboolean old_method_inner_error;
	gboolean _tmp0_;
	ValaClass* _tmp1_;
	ValaClass* cl;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (c != NULL);
	old_method_inner_error = ((ValaCCodeBaseModule*) self)->current_method_inner_error;
	((ValaCCodeBaseModule*) self)->current_method_inner_error = FALSE;
	((ValaCCodeBaseModule*) self)->in_constructor = TRUE;
	_tmp0_ = FALSE;
	if (vala_constructor_get_binding (c) == MEMBER_BINDING_CLASS) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_constructor_get_binding (c) == MEMBER_BINDING_STATIC;
	}
	if (_tmp0_) {
		((ValaCCodeBaseModule*) self)->in_static_or_class_ctor = TRUE;
	}
	vala_code_node_accept_children ((ValaCodeNode*) c, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	((ValaCCodeBaseModule*) self)->in_static_or_class_ctor = FALSE;
	((ValaCCodeBaseModule*) self)->in_constructor = FALSE;
	_tmp1_ = NULL;
	cl = (_tmp1_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) c)), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	if (vala_constructor_get_binding (c) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeFunction* _tmp4_;
		char* _tmp3_;
		char* _tmp2_;
		ValaCCodeFormalParameter* _tmp5_;
		ValaCCodeFormalParameter* _tmp6_;
		ValaCCodeFormalParameter* _tmp7_;
		ValaCCodeFunction* _tmp8_;
		ValaCCodeBlock* cblock;
		ValaCCodeDeclaration* _cdecl_;
		ValaCCodeVariableDeclarator* _tmp9_;
		ValaCCodeDeclaration* _tmp12_;
		char* _tmp11_;
		char* _tmp10_;
		ValaCCodeVariableDeclarator* _tmp13_;
		ValaCCodeDeclaration* _tmp14_;
		ValaCCodeVariableDeclarator* _tmp15_;
		ValaCCodeIdentifier* _tmp16_;
		ValaCCodeFunctionCall* _tmp17_;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp19_;
		char* _tmp18_;
		ValaCCodeIdentifier* _tmp22_;
		char* _tmp21_;
		char* _tmp20_;
		ValaCCodeFunctionCall* _tmp23_;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeExpressionStatement* _tmp26_;
		ValaCCodeAssignment* _tmp25_;
		ValaCCodeIdentifier* _tmp24_;
		ValaCCodeFunctionCall* _tmp28_;
		ValaCCodeIdentifier* _tmp27_;
		ValaCCodeIdentifier* _tmp29_;
		ValaCCodeFunctionCall* _tmp31_;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeExpressionStatement* _tmp34_;
		ValaCCodeAssignment* _tmp33_;
		ValaCCodeIdentifier* _tmp32_;
		ValaCCodeFunctionCall* _tmp37_;
		ValaCCodeMemberAccess* _tmp36_;
		ValaCCodeIdentifier* _tmp35_;
		ValaCCodeIdentifier* _tmp38_;
		ValaCCodeIdentifier* _tmp39_;
		ValaCCodeIdentifier* _tmp40_;
		ValaCCodeExpressionStatement* _tmp43_;
		ValaCCodeAssignment* _tmp42_;
		ValaCCodeIdentifier* _tmp41_;
		ValaCCodeFunctionCall* _tmp45_;
		ValaCCodeIdentifier* _tmp44_;
		ValaCCodeDeclaration* _tmp48_;
		char* _tmp47_;
		char* _tmp46_;
		ValaCCodeVariableDeclarator* _tmp49_;
		ValaCCodeReturnStatement* _tmp54_;
		ValaCCodeIdentifier* _tmp53_;
		if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type)) {
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) c), "construct blocks require GLib.Object");
			vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			return;
		}
		_tmp4_ = NULL;
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		((ValaCCodeBaseModule*) self)->function = (_tmp4_ = vala_ccode_function_new (_tmp3_ = g_strdup_printf ("%s_constructor", _tmp2_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "GObject *"), (((ValaCCodeBaseModule*) self)->function == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->function = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->function), NULL)), _tmp4_);
		_tmp3_ = (g_free (_tmp3_), NULL);
		_tmp2_ = (g_free (_tmp2_), NULL);
		vala_ccode_function_set_modifiers (((ValaCCodeBaseModule*) self)->function, VALA_CCODE_MODIFIERS_STATIC);
		_tmp5_ = NULL;
		vala_ccode_function_add_parameter (((ValaCCodeBaseModule*) self)->function, _tmp5_ = vala_ccode_formal_parameter_new ("type", "GType"));
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
		_tmp6_ = NULL;
		vala_ccode_function_add_parameter (((ValaCCodeBaseModule*) self)->function, _tmp6_ = vala_ccode_formal_parameter_new ("n_construct_properties", "guint"));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
		_tmp7_ = NULL;
		vala_ccode_function_add_parameter (((ValaCCodeBaseModule*) self)->function, _tmp7_ = vala_ccode_formal_parameter_new ("construct_properties", "GObjectConstructParam *"));
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
		_tmp8_ = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp8_ = vala_ccode_function_copy (((ValaCCodeBaseModule*) self)->function)));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		cblock = vala_ccode_block_new ();
		_cdecl_ = vala_ccode_declaration_new ("GObject *");
		_tmp9_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp9_ = vala_ccode_variable_declarator_new ("obj", NULL, NULL)));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) _cdecl_);
		_tmp12_ = NULL;
		_tmp11_ = NULL;
		_tmp10_ = NULL;
		_cdecl_ = (_tmp12_ = vala_ccode_declaration_new (_tmp11_ = g_strdup_printf ("%sClass *", _tmp10_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp12_);
		_tmp11_ = (g_free (_tmp11_), NULL);
		_tmp10_ = (g_free (_tmp10_), NULL);
		_tmp13_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp13_ = vala_ccode_variable_declarator_new ("klass", NULL, NULL)));
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) _cdecl_);
		_tmp14_ = NULL;
		_cdecl_ = (_tmp14_ = vala_ccode_declaration_new ("GObjectClass *"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp14_);
		_tmp15_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp15_ = vala_ccode_variable_declarator_new ("parent_class", NULL, NULL)));
		(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) _cdecl_);
		_tmp16_ = NULL;
		_tmp17_ = NULL;
		ccall = (_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("g_type_class_peek"))), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL)), _tmp17_);
		_tmp19_ = NULL;
		_tmp18_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new (_tmp18_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl))));
		(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
		_tmp18_ = (g_free (_tmp18_), NULL);
		_tmp22_ = NULL;
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		_tmp23_ = NULL;
		ccast = (_tmp23_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new (_tmp21_ = g_strdup_printf ("%s_CLASS", _tmp20_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL)), _tmp21_ = (g_free (_tmp21_), NULL), _tmp20_ = (g_free (_tmp20_), NULL), _tmp23_);
		vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) ccall);
		_tmp26_ = NULL;
		_tmp25_ = NULL;
		_tmp24_ = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp26_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp25_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("klass")), (ValaCCodeExpression*) ccast, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
		(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
		(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
		_tmp28_ = NULL;
		_tmp27_ = NULL;
		ccall = (_tmp28_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("g_type_class_peek_parent"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp28_);
		(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
		_tmp29_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("klass")));
		(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
		_tmp31_ = NULL;
		_tmp30_ = NULL;
		ccast = (_tmp31_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)), _tmp31_);
		(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
		vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) ccall);
		_tmp34_ = NULL;
		_tmp33_ = NULL;
		_tmp32_ = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp34_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp33_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new ("parent_class")), (ValaCCodeExpression*) ccast, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
		(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
		(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
		_tmp37_ = NULL;
		_tmp36_ = NULL;
		_tmp35_ = NULL;
		ccall = (_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp36_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new ("parent_class")), "constructor"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp37_);
		(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
		(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
		_tmp38_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp38_ = vala_ccode_identifier_new ("type")));
		(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
		_tmp39_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_identifier_new ("n_construct_properties")));
		(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
		_tmp40_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new ("construct_properties")));
		(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
		_tmp43_ = NULL;
		_tmp42_ = NULL;
		_tmp41_ = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp43_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp42_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp41_ = vala_ccode_identifier_new ("obj")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
		(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
		(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
		_tmp45_ = NULL;
		_tmp44_ = NULL;
		ccall = (_tmp45_ = (ValaCCodeFunctionCall*) vala_instance_cast_new ((ValaCCodeExpression*) (_tmp44_ = vala_ccode_identifier_new ("obj")), (ValaTypeSymbol*) cl), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp45_);
		(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
		_tmp48_ = NULL;
		_tmp47_ = NULL;
		_tmp46_ = NULL;
		_cdecl_ = (_tmp48_ = vala_ccode_declaration_new (_tmp47_ = g_strdup_printf ("%s *", _tmp46_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp48_);
		_tmp47_ = (g_free (_tmp47_), NULL);
		_tmp46_ = (g_free (_tmp46_), NULL);
		_tmp49_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp49_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) ccall, NULL)));
		(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) _cdecl_);
		if (((ValaCCodeBaseModule*) self)->current_method_inner_error) {
			ValaCCodeDeclaration* _tmp50_;
			ValaCCodeVariableDeclarator* _tmp52_;
			ValaCCodeConstant* _tmp51_;
			/* always separate error parameter and inner_error local variable
			 * as error may be set to NULL but we're always interested in inner errors
			 */
			_tmp50_ = NULL;
			_cdecl_ = (_tmp50_ = vala_ccode_declaration_new ("GError *"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp50_);
			_tmp52_ = NULL;
			_tmp51_ = NULL;
			vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp52_ = vala_ccode_variable_declarator_new ("_inner_error_", (ValaCCodeExpression*) (_tmp51_ = vala_ccode_constant_new ("NULL")), NULL)));
			(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
			(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) _cdecl_);
		}
		vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_constructor_get_body (c)));
		_tmp54_ = NULL;
		_tmp53_ = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp54_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp53_ = vala_ccode_identifier_new ("obj")))));
		(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
		(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
		vala_ccode_function_set_block (((ValaCCodeBaseModule*) self)->function, cblock);
		if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) c)) != NULL) {
			ValaCCodeComment* _tmp55_;
			_tmp55_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp55_ = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) c)))));
			(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
		}
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
		(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
		(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
	} else {
		if (vala_constructor_get_binding (c) == MEMBER_BINDING_CLASS) {
			/* class constructor*/
			if (vala_class_get_is_compact (cl)) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) c), "class constructors are not supported in compact classes");
				vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
				return;
			}
			if (((ValaCCodeBaseModule*) self)->current_method_inner_error) {
				ValaCCodeDeclaration* _cdecl_;
				ValaCCodeVariableDeclarator* _tmp57_;
				ValaCCodeConstant* _tmp56_;
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				_cdecl_ = vala_ccode_declaration_new ("GError *");
				_tmp57_ = NULL;
				_tmp56_ = NULL;
				vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp57_ = vala_ccode_variable_declarator_new ("_inner_error_", (ValaCCodeExpression*) (_tmp56_ = vala_ccode_constant_new ("NULL")), NULL)));
				(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
				(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->base_init_fragment, (ValaCCodeNode*) _cdecl_);
				(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
			}
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->base_init_fragment, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_constructor_get_body (c)));
		} else {
			if (vala_constructor_get_binding (c) == MEMBER_BINDING_STATIC) {
				/* static class constructor
				 add to class_init*/
				if (vala_class_get_is_compact (cl)) {
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) c), "static constructors are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
					(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
					return;
				}
				if (((ValaCCodeBaseModule*) self)->current_method_inner_error) {
					ValaCCodeDeclaration* _cdecl_;
					ValaCCodeVariableDeclarator* _tmp59_;
					ValaCCodeConstant* _tmp58_;
					/* always separate error parameter and inner_error local variable
					 * as error may be set to NULL but we're always interested in inner errors
					 */
					_cdecl_ = vala_ccode_declaration_new ("GError *");
					_tmp59_ = NULL;
					_tmp58_ = NULL;
					vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp59_ = vala_ccode_variable_declarator_new ("_inner_error_", (ValaCCodeExpression*) (_tmp58_ = vala_ccode_constant_new ("NULL")), NULL)));
					(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
					(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
					vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->class_init_fragment, (ValaCCodeNode*) _cdecl_);
					(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
				}
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->class_init_fragment, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_constructor_get_body (c)));
			} else {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) c), "internal error: constructors must have instance, class, or static binding");
			}
		}
	}
	((ValaCCodeBaseModule*) self)->current_method_inner_error = old_method_inner_error;
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


static char* vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop) {
	ValaGObjectModule * self;
	char* result;
	gboolean _tmp0_;
	char* getter_cname;
	char* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp4_;
	char* _tmp3_;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp5_;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = FALSE;
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (prop)) == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (prop)), ((ValaCCodeBaseModule*) self)->gobject_type);
	}
	if (_tmp0_) {
		result = VALA_CCODE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_getter_cname ((ValaCCodeModule*) VALA_GTYPE_MODULE (self), prop);
		return result;
	}
	getter_cname = g_strdup_printf ("_dynamic_get_%s%d", vala_symbol_get_name ((ValaSymbol*) prop), self->priv->dynamic_property_id++);
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	func = (_tmp2_ = vala_ccode_function_new (getter_cname, _tmp1_ = vala_data_type_get_cname (vala_property_get_property_type ((ValaProperty*) prop))), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
	vala_ccode_function_set_modifiers (func, vala_ccode_function_get_modifiers (func) | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp4_ = vala_ccode_formal_parameter_new ("obj", _tmp3_ = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (prop))));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp3_ = (g_free (_tmp3_), NULL);
	block = vala_ccode_block_new ();
	vala_gobject_module_generate_gobject_property_getter_wrapper (self, prop, block);
	/* append to C source file*/
	_tmp5_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp5_ = vala_ccode_function_copy (func)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	result = getter_cname;
	(func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	return result;
}


static char* vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop) {
	ValaGObjectModule * self;
	char* result;
	gboolean _tmp0_;
	char* setter_cname;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp2_;
	char* _tmp1_;
	ValaCCodeFormalParameter* _tmp4_;
	char* _tmp3_;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp5_;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = FALSE;
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (prop)) == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (prop)), ((ValaCCodeBaseModule*) self)->gobject_type);
	}
	if (_tmp0_) {
		result = VALA_CCODE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_setter_cname ((ValaCCodeModule*) VALA_GTYPE_MODULE (self), prop);
		return result;
	}
	setter_cname = g_strdup_printf ("_dynamic_set_%s%d", vala_symbol_get_name ((ValaSymbol*) prop), self->priv->dynamic_property_id++);
	func = vala_ccode_function_new (setter_cname, "void");
	vala_ccode_function_set_modifiers (func, vala_ccode_function_get_modifiers (func) | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp2_ = vala_ccode_formal_parameter_new ("obj", _tmp1_ = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (prop))));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp1_ = (g_free (_tmp1_), NULL);
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp4_ = vala_ccode_formal_parameter_new ("value", _tmp3_ = vala_data_type_get_cname (vala_property_get_property_type ((ValaProperty*) prop))));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp3_ = (g_free (_tmp3_), NULL);
	block = vala_ccode_block_new ();
	vala_gobject_module_generate_gobject_property_setter_wrapper (self, prop, block);
	/* append to C source file*/
	_tmp5_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp5_ = vala_ccode_function_copy (func)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	result = setter_cname;
	(func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	return result;
}


static void vala_gobject_module_generate_gobject_property_getter_wrapper (ValaGObjectModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	char* _tmp0_;
	ValaCCodeDeclaration* _tmp1_;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp2_;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeConstant* _tmp6_;
	ValaCCodeUnaryExpression* _tmp8_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeExpressionStatement* _tmp10_;
	ValaCCodeReturnStatement* _tmp12_;
	ValaCCodeIdentifier* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	_cdecl_ = (_tmp1_ = vala_ccode_declaration_new (_tmp0_ = vala_data_type_get_cname (vala_property_get_property_type ((ValaProperty*) node))), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp2_ = vala_ccode_variable_declarator_new ("result", NULL, NULL)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
	_tmp3_ = NULL;
	_tmp4_ = NULL;
	call = (_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("g_object_get"))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL)), _tmp4_);
	_tmp5_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("obj")));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp6_ = vala_property_get_canonical_cconstant ((ValaProperty*) node)));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("result")))));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp9_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_constant_new ("NULL")));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp10_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp10_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) call)));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp12_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new ("result")))));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(call == NULL) ? NULL : (call = (vala_ccode_node_unref (call), NULL));
}


static void vala_gobject_module_generate_gobject_property_setter_wrapper (ValaGObjectModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeConstant* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeConstant* _tmp5_;
	ValaCCodeExpressionStatement* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	call = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("g_object_set"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("obj")));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp3_ = vala_property_get_canonical_cconstant ((ValaProperty*) node)));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("value")));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_constant_new ("NULL")));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp6_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) call)));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	(call == NULL) ? NULL : (call = (vala_ccode_node_unref (call), NULL));
}


static char* vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeModule* base, ValaDynamicSignal* node) {
	ValaGObjectModule * self;
	char* result;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (node != NULL, NULL);
	result = g_strdup_printf ("dynamic_%s%d_", vala_symbol_get_name ((ValaSymbol*) node), self->priv->signal_wrapper_id++);
	return result;
}


static char* vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* base, ValaDynamicSignal* sig) {
	ValaGObjectModule * self;
	char* result;
	gboolean _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* connect_wrapper_name;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeFormalParameter* _tmp5_;
	ValaCCodeFormalParameter* _tmp6_;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp7_;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp0_ = FALSE;
	if (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (sig)) == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (sig)), ((ValaCCodeBaseModule*) self)->gobject_type);
	}
	if (_tmp0_) {
		result = VALA_CCODE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeModule*) VALA_GTYPE_MODULE (self), sig);
		return result;
	}
	_tmp1_ = NULL;
	_tmp2_ = NULL;
	connect_wrapper_name = (_tmp2_ = g_strdup_printf ("_%sconnect", _tmp1_ = vala_ccode_module_get_dynamic_signal_cname ((ValaCCodeModule*) self, sig)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
	func = vala_ccode_function_new (connect_wrapper_name, "void");
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp3_ = vala_ccode_formal_parameter_new ("obj", "gpointer"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp4_ = vala_ccode_formal_parameter_new ("signal_name", "const char *"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp5_ = vala_ccode_formal_parameter_new ("handler", "GCallback"));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (func, _tmp6_ = vala_ccode_formal_parameter_new ("data", "gpointer"));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	block = vala_ccode_block_new ();
	vala_gobject_module_generate_gobject_connect_wrapper (self, sig, block);
	/* append to C source file*/
	_tmp7_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp7_ = vala_ccode_function_copy (func)));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	result = connect_wrapper_name;
	(func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	return result;
}


static void vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self, ValaDynamicSignal* sig, ValaCCodeBlock* block) {
	ValaMethod* _tmp0_;
	ValaMethod* m;
	char* connect_func;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeExpressionStatement* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (block != NULL);
	_tmp0_ = NULL;
	m = (_tmp0_ = VALA_METHOD (vala_expression_get_symbol_reference (vala_dynamic_signal_get_handler (sig))), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	vala_code_node_accept ((ValaCodeNode*) sig, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	connect_func = g_strdup ("g_signal_connect_object");
	if (vala_method_get_binding (m) != MEMBER_BINDING_INSTANCE) {
		char* _tmp1_;
		_tmp1_ = NULL;
		connect_func = (_tmp1_ = g_strdup ("g_signal_connect"), connect_func = (g_free (connect_func), NULL), _tmp1_);
	}
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	call = (_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new (connect_func))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL)), _tmp3_);
	_tmp4_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("obj")));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("signal_name")));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("handler")));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp7_ = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("data")));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeConstant* _tmp8_;
		_tmp8_ = NULL;
		vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_constant_new ("0")));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	}
	_tmp9_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp9_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) call)));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	connect_func = (g_free (connect_func), NULL);
	(call == NULL) ? NULL : (call = (vala_ccode_node_unref (call), NULL));
}


static void vala_gobject_module_real_visit_property (ValaCCodeModule* base, ValaProperty* prop) {
	ValaGObjectModule * self;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (prop != NULL);
	VALA_CCODE_MODULE_CLASS (vala_gobject_module_parent_class)->visit_property ((ValaCCodeModule*) VALA_GTYPE_MODULE (self), prop);
	if (vala_ccode_base_module_is_gobject_property ((ValaCCodeBaseModule*) self, prop)) {
		ValaCCodeEnumValue* _tmp1_;
		char* _tmp0_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		vala_ccode_enum_add_value (((ValaCCodeBaseModule*) self)->prop_enum, _tmp1_ = vala_ccode_enum_value_new (_tmp0_ = vala_property_get_upper_case_cname (prop), NULL));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
		_tmp0_ = (g_free (_tmp0_), NULL);
	}
}


static gboolean vala_gobject_module_real_is_gobject_property (ValaCCodeBaseModule* base, ValaProperty* prop) {
	ValaGObjectModule * self;
	gboolean result;
	ValaClass* _tmp1_;
	ValaSymbol* _tmp0_;
	ValaClass* cl;
	gboolean _tmp2_;
	ValaStruct* _tmp4_;
	ValaTypeSymbol* _tmp3_;
	ValaStruct* st;
	gboolean _tmp5_;
	ValaDelegateType* _tmp7_;
	ValaDataType* _tmp6_;
	ValaDelegateType* d;
	gboolean _tmp8_;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, FALSE);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	cl = (_tmp1_ = (_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) prop), VALA_IS_CLASS (_tmp0_) ? ((ValaClass*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (cl == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type);
	}
	if (_tmp2_) {
		result = FALSE;
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		return result;
	}
	if (vala_property_get_binding (prop) != MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		return result;
	}
	if (vala_symbol_get_access ((ValaSymbol*) prop) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		result = FALSE;
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		return result;
	}
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	st = (_tmp4_ = (_tmp3_ = vala_data_type_get_data_type (vala_property_get_property_type (prop)), VALA_IS_STRUCT (_tmp3_) ? ((ValaStruct*) _tmp3_) : NULL), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
	_tmp5_ = FALSE;
	if (st != NULL) {
		_tmp5_ = !vala_struct_get_has_type_id (st);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = FALSE;
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		return result;
	}
	if (VALA_IS_ARRAY_TYPE (vala_property_get_property_type (prop))) {
		result = FALSE;
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		return result;
	}
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	d = (_tmp7_ = (_tmp6_ = vala_property_get_property_type (prop), VALA_IS_DELEGATE_TYPE (_tmp6_) ? ((ValaDelegateType*) _tmp6_) : NULL), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
	_tmp8_ = FALSE;
	if (d != NULL) {
		_tmp8_ = vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (d));
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		result = FALSE;
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		return result;
	}
	if (vala_property_get_base_interface_property (prop) != NULL) {
		ValaInterface* _tmp9_;
		ValaInterface* iface;
		_tmp9_ = NULL;
		iface = (_tmp9_ = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop))), (_tmp9_ == NULL) ? NULL : vala_code_node_ref (_tmp9_));
		if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) iface, ((ValaCCodeBaseModule*) self)->gobject_type)) {
			/* implementing non-GObject property*/
			result = FALSE;
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
			return result;
		}
		(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
	}
	if (!g_unichar_isalpha (g_utf8_get_char (g_utf8_offset_to_pointer (vala_symbol_get_name ((ValaSymbol*) prop), 0)))) {
		/* GObject requires properties to start with a letter*/
		result = FALSE;
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		return result;
	}
	result = TRUE;
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
	return result;
}


static void vala_gobject_module_class_init (ValaGObjectModuleClass * klass) {
	vala_gobject_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->finalize = vala_gobject_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaGObjectModulePrivate));
	VALA_CCODE_MODULE_CLASS (klass)->visit_class = vala_gobject_module_real_visit_class;
	VALA_GTYPE_MODULE_CLASS (klass)->generate_class_init = vala_gobject_module_real_generate_class_init;
	VALA_CCODE_MODULE_CLASS (klass)->get_construct_property_assignment = vala_gobject_module_real_get_construct_property_assignment;
	VALA_CCODE_MODULE_CLASS (klass)->visit_constructor = vala_gobject_module_real_visit_constructor;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_property_getter_cname = vala_gobject_module_real_get_dynamic_property_getter_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_property_setter_cname = vala_gobject_module_real_get_dynamic_property_setter_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_signal_cname = vala_gobject_module_real_get_dynamic_signal_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_signal_connect_wrapper_name = vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name;
	VALA_CCODE_MODULE_CLASS (klass)->visit_property = vala_gobject_module_real_visit_property;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->is_gobject_property = vala_gobject_module_real_is_gobject_property;
}


static void vala_gobject_module_instance_init (ValaGObjectModule * self) {
	self->priv = VALA_GOBJECT_MODULE_GET_PRIVATE (self);
}


static void vala_gobject_module_finalize (ValaCCodeModule* obj) {
	ValaGObjectModule * self;
	self = VALA_GOBJECT_MODULE (obj);
	VALA_CCODE_MODULE_CLASS (vala_gobject_module_parent_class)->finalize (obj);
}


GType vala_gobject_module_get_type (void) {
	static GType vala_gobject_module_type_id = 0;
	if (vala_gobject_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGObjectModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gobject_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGObjectModule), 0, (GInstanceInitFunc) vala_gobject_module_instance_init, NULL };
		vala_gobject_module_type_id = g_type_register_static (VALA_TYPE_GTYPE_MODULE, "ValaGObjectModule", &g_define_type_info, 0);
	}
	return vala_gobject_module_type_id;
}




