/* gnome-vfs-2.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "GnomeVFS", lower_case_cprefix = "gnome_vfs_")]
namespace GnomeVFS {
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ACE : GLib.Object {
		[CCode (has_construct_function = false)]
		public ACE (GnomeVFS.ACLKind kind, string id, GnomeVFS.ACLPerm perms);
		public void add_perm (GnomeVFS.ACLPerm perm);
		public bool check_perm (GnomeVFS.ACLPerm perm);
		public void copy_perms (GnomeVFS.ACE dest);
		public void del_perm (GnomeVFS.ACLPerm perm);
		public bool equal (GnomeVFS.ACE entry_b);
		public unowned string get_id ();
		public bool get_inherit ();
		public unowned GnomeVFS.ACLKind get_kind ();
		public bool get_negative ();
		public unowned GnomeVFS.ACLPerm get_perms ();
		[NoWrapper]
		public virtual void reserved1 ();
		[NoWrapper]
		public virtual void reserved2 ();
		[NoWrapper]
		public virtual void reserved3 ();
		[NoWrapper]
		public virtual void reserved4 ();
		public void set_id (string id);
		public void set_inherit (bool inherit);
		public void set_kind (GnomeVFS.ACLKind kind);
		public void set_negative (bool negative);
		public void set_perms (GnomeVFS.ACLPerm perms);
		public string id { get; set construct; }
		public bool inherit { get; set; }
		public uint kind { get; set construct; }
		public bool negative { get; set; }
		[NoAccessorMethod]
		public void* permissions { get; set construct; }
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ACL : GLib.Object {
		[CCode (has_construct_function = false)]
		public ACL ();
		public void clear ();
		public static void free_ace_list (GLib.List ace_list);
		public unowned GLib.List get_ace_list ();
		public void @set (GnomeVFS.ACE ace);
		public void unset (GnomeVFS.ACE ace);
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ACLKind {
		public unowned string to_string ();
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ACLPerm {
		public unowned string to_string ();
	}
	[Compact]
	[CCode (type_id = "GNOME_VFS_TYPE_ADDRESS", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class Address {
		public unowned GnomeVFS.Address dup ();
		public bool equal (GnomeVFS.Address b);
		[CCode (has_construct_function = false)]
		public Address.from_ipv4 (uint32 ipv4_address);
		[CCode (has_construct_function = false)]
		public Address.from_string (string address);
		public int get_family_type ();
		public uint32 get_ipv4 ();
		public void* get_sockaddr (uint16 port, int len);
		public bool match (GnomeVFS.Address b, uint prefix);
		public unowned string to_string ();
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class AsyncHandle {
	}
	[Compact]
	[CCode (free_function = "gnome_vfs_cancellation_destroy", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class Cancellation {
		[CCode (has_construct_function = false)]
		public Cancellation ();
		public void ack ();
		public void cancel ();
		public bool check ();
		public int get_fd ();
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class Context {
		[CCode (has_construct_function = false)]
		public Context ();
		public static bool check_cancellation_current ();
		public unowned GnomeVFS.Cancellation get_cancellation ();
		public static unowned GnomeVFS.Context peek_current ();
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class DNSSDBrowseHandle {
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class DNSSDResolveHandle {
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class DNSSDService {
		public weak string domain;
		public weak string name;
		public weak string type;
		[CCode (cname = "gnome_vfs_dns_sd_service_list_free")]
		public void list_free (int n_services);
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class DirectoryHandle {
	}
	[CCode (type_check_function = "GNOME_IS_VFS_DRIVE", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class Drive : GLib.Object {
		public int compare (GnomeVFS.Drive b);
		public void eject (GnomeVFS.VolumeOpCallback callback);
		public unowned string get_activation_uri ();
		public unowned string get_device_path ();
		public GnomeVFS.DeviceType get_device_type ();
		public unowned string get_display_name ();
		public unowned string get_hal_udi ();
		public unowned string get_icon ();
		public ulong get_id ();
		public unowned GnomeVFS.Volume get_mounted_volume ();
		public unowned GLib.List get_mounted_volumes ();
		public bool is_connected ();
		public bool is_mounted ();
		public bool is_user_visible ();
		public void mount (GnomeVFS.VolumeOpCallback callback);
		public bool needs_eject ();
		public unowned GnomeVFS.Drive @ref ();
		public void unmount (GnomeVFS.VolumeOpCallback callback);
		public void unref ();
		public static void volume_list_free (GLib.List volumes);
		public virtual signal void volume_mounted (GnomeVFS.Volume volume);
		public virtual signal void volume_pre_unmount (GnomeVFS.Volume volume);
		public virtual signal void volume_unmounted (GnomeVFS.Volume volume);
	}
	[Compact]
	[CCode (ref_function = "gnome_vfs_file_info_ref", ref_function_void = true, unref_function = "gnome_vfs_file_info_unref", type_id = "GNOME_VFS_TYPE_FILE_INFO", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class FileInfo {
		public weak GnomeVFS.ACL acl;
		public ulong atime;
		public GnomeVFS.FileSize block_count;
		public ulong ctime;
		public GnomeVFS.FileFlags flags;
		public uint gid;
		public weak GnomeVFS.InodeNumber inode;
		public uint io_block_size;
		public uint link_count;
		public weak string mime_type;
		public ulong mtime;
		public weak string name;
		public GnomeVFS.FilePermissions permissions;
		public uint refcount;
		public void* reserved1;
		public void* reserved2;
		public void* reserved3;
		public weak string selinux_context;
		public GnomeVFS.FileSize size;
		public weak string symlink_name;
		public GnomeVFS.FileType type;
		public uint uid;
		public GnomeVFS.FileInfoFields valid_fields;
		[CCode (has_construct_function = false)]
		public FileInfo ();
		public void clear ();
		public void copy (GnomeVFS.FileInfo src);
		public unowned GnomeVFS.FileInfo dup ();
		public unowned string get_mime_type ();
		public static unowned GLib.List list_copy (GLib.List list);
		public static void list_free (GLib.List list);
		public static unowned GLib.List list_ref (GLib.List list);
		public static unowned GLib.List list_unref (GLib.List list);
		public bool matches (GnomeVFS.FileInfo b);
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class FileOffset {
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class FindDirectoryResult {
		public void* reserved1;
		public void* reserved2;
		public GnomeVFS.Result result;
		public weak GnomeVFS.URI uri;
		public unowned GnomeVFS.FindDirectoryResult dup ();
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class GetFileInfoResult {
		public weak GnomeVFS.FileInfo file_info;
		public GnomeVFS.Result result;
		public weak GnomeVFS.URI uri;
		public unowned GnomeVFS.GetFileInfoResult dup ();
	}
	[Compact]
	[CCode (type_id = "GNOME_VFS_TYPE_GNOME_VFS_FIND_DIRECTORY_RESULT", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class GnomeVfsFindDirectoryResult {
	}
	[Compact]
	[CCode (type_id = "GNOME_VFS_TYPE_GNOME_VFS_GET_FILE_INFO_RESULT", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class GnomeVfsGetFileInfoResult {
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class Handle {
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class InodeNumber {
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class MIMEMonitor : GLib.Object {
		public static unowned GnomeVFS.MIMEMonitor @get ();
		public virtual signal void data_changed ();
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class MethodHandle {
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class MimeAction {
		public void* action;
		public GnomeVFS.MimeActionType action_type;
		public void* reserved1;
		public GnomeVFS.Result launch (GLib.List uris);
		public GnomeVFS.Result launch_with_env (GLib.List uris, out unowned string envp);
	}
	[Compact]
	[CCode (copy_function = "gnome_vfs_mime_application_copy", cheader_filename = "libgnomevfs/gnome-vfs-mime-handlers.h")]
	public class MimeApplication {
		public bool can_open_multiple_files;
		public weak string command;
		public GnomeVFS.MimeApplicationArgumentType expects_uris;
		public weak string id;
		public weak string name;
		public void* reserved1;
		public weak GLib.List supported_uri_schemes;
		public GnomeVFS.MimeApplication copy ();
		public bool equal (GnomeVFS.MimeApplication app_b);
		[CCode (has_construct_function = false)]
		public MimeApplication.from_desktop_id (string id);
		[CCode (has_construct_function = false)]
		public MimeApplication.from_id (string id);
		public unowned string get_binary_name ();
		public unowned string get_desktop_file_path ();
		public unowned string get_desktop_id ();
		public unowned string get_exec ();
		public unowned string get_generic_name ();
		public unowned string get_icon ();
		public unowned string get_name ();
		public unowned string get_startup_wm_class ();
		public GnomeVFS.Result launch (GLib.List uris);
		public GnomeVFS.Result launch_with_env (GLib.List uris, out unowned string envp);
		public static void list_free (GLib.List list);
		public bool requires_terminal ();
		public bool supports_startup_notification ();
		public bool supports_uris ();
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackAdditionalHeadersIn {
		public void* reserved1;
		public void* reserved2;
		public weak GnomeVFS.URI uri;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackAdditionalHeadersOut {
		public weak GLib.List headers;
		public void* reserved1;
		public void* reserved2;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackAuthenticationIn {
		public GnomeVFS.ModuleCallbackAuthenticationAuthType auth_type;
		public bool previous_attempt_failed;
		public weak string realm;
		public void* reserved1;
		public void* reserved2;
		public weak string uri;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackAuthenticationOut {
		public weak string password;
		public void* reserved1;
		public void* reserved2;
		public weak string username;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackFillAuthenticationIn {
		public weak string authtype;
		public weak string domain;
		public weak string object;
		public int port;
		public weak string protocol;
		public void* reserved1;
		public void* reserved2;
		public weak string server;
		public weak string uri;
		public weak string username;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackFillAuthenticationOut {
		public weak string domain;
		public weak string password;
		public void* reserved1;
		public void* reserved2;
		public weak string username;
		public bool valid;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackFullAuthenticationIn {
		public weak string authtype;
		public weak string default_domain;
		public weak string default_user;
		public weak string domain;
		public GnomeVFS.ModuleCallbackFullAuthenticationFlags flags;
		public weak string object;
		public int port;
		public weak string protocol;
		public void* reserved1;
		public void* reserved2;
		public weak string server;
		public weak string uri;
		public weak string username;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackFullAuthenticationOut {
		public bool abort_auth;
		public weak string domain;
		public weak string keyring;
		public size_t out_flags;
		public weak string password;
		public void* reserved2;
		public bool save_password;
		public weak string username;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackQuestionIn {
		public weak string choices;
		public weak string primary_message;
		public void* reserved1;
		public void* reserved2;
		public weak string secondary_message;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackQuestionOut {
		public int answer;
		public void* reserved1;
		public void* reserved2;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackReceivedHeadersIn {
		public weak GLib.List headers;
		public void* reserved1;
		public void* reserved2;
		public weak GnomeVFS.URI uri;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackReceivedHeadersOut {
		public int dummy;
		public void* reserved1;
		public void* reserved2;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackSaveAuthenticationIn {
		public weak string authtype;
		public weak string domain;
		public weak string keyring;
		public weak string object;
		public weak string password;
		public int port;
		public weak string protocol;
		public void* reserved1;
		public void* reserved2;
		public weak string server;
		public weak string uri;
		public weak string username;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackSaveAuthenticationOut {
		public void* reserved1;
		public void* reserved2;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackStatusMessageIn {
		public weak string message;
		public int percentage;
		public void* reserved1;
		public void* reserved2;
		public weak string uri;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ModuleCallbackStatusMessageOut {
		public int dummy;
		public void* reserved1;
		public void* reserved2;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class MonitorHandle {
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ProgressCallbackState {
		public void* async_job_data;
		public int64 next_text_update_callback_time;
		public int64 next_update_callback_time;
		public weak GnomeVFS.XferProgressInfo progress_info;
		public void* reserved1;
		public void* reserved2;
		public weak GnomeVFS.XferProgressCallback sync_callback;
		public weak GnomeVFS.XferProgressCallback update_callback;
		public int64 update_callback_period;
		public void* user_data;
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ResolveHandle {
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class ToplevelURI {
		public weak string host_name;
		public uint host_port;
		public weak string password;
		public void* reserved1;
		public void* reserved2;
		public weak GnomeVFS.URI uri;
		public weak string urn;
		public weak string user_name;
	}
	[Compact]
	[CCode (ref_function = "gnome_vfs_uri_ref", unref_function = "gnome_vfs_uri_unref", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class URI {
		public weak string fragment_id;
		public void* method;
		public weak string method_string;
		public void* parent;
		public uint ref_count;
		public void* reserved1;
		public void* reserved2;
		public weak string text;
		[CCode (has_construct_function = false)]
		public URI (string text_uri);
		public unowned GnomeVFS.URI append_file_name (string filename);
		public unowned GnomeVFS.URI append_path (string path);
		public unowned GnomeVFS.URI append_string (string uri_fragment);
		public unowned GnomeVFS.URI dup ();
		public bool equal (GnomeVFS.URI b);
		public bool exists ();
		public unowned string extract_dirname ();
		public unowned string extract_short_name ();
		public unowned string extract_short_path_name ();
		public unowned string get_fragment_identifier ();
		public unowned string get_host_name ();
		public uint get_host_port ();
		public unowned GnomeVFS.URI get_parent ();
		public unowned string get_password ();
		public unowned string get_path ();
		public unowned string get_scheme ();
		public unowned GnomeVFS.ToplevelURI get_toplevel ();
		public unowned string get_user_name ();
		public bool has_parent ();
		public static uint hash (void* p);
		public static int hequal (void* a, void* b);
		public bool is_local ();
		public bool is_parent (GnomeVFS.URI possible_child, bool recursive);
		public static unowned GLib.List list_copy (GLib.List list);
		public static void list_free (GLib.List list);
		public static unowned GLib.List list_parse (string uri_list);
		public static unowned GLib.List list_ref (GLib.List list);
		public static unowned GLib.List list_unref (GLib.List list);
		public static unowned string make_full_from_relative (string base_uri, string relative_uri);
		public unowned GnomeVFS.URI resolve_relative (string relative_reference);
		public unowned GnomeVFS.URI resolve_symbolic_link (string relative_reference);
		public void set_host_name (string host_name);
		public void set_host_port (uint host_port);
		public void set_password (string password);
		public void set_user_name (string user_name);
		public unowned string to_string (GnomeVFS.URIHideOptions hide_options);
	}
	[CCode (type_check_function = "GNOME_IS_VFS_VOLUME", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class Volume : GLib.Object {
		public int compare (GnomeVFS.Volume b);
		public void eject (GnomeVFS.VolumeOpCallback callback);
		public unowned string get_activation_uri ();
		public unowned string get_device_path ();
		public GnomeVFS.DeviceType get_device_type ();
		public unowned string get_display_name ();
		public unowned GnomeVFS.Drive get_drive ();
		public unowned string get_filesystem_type ();
		public unowned string get_hal_udi ();
		public unowned string get_icon ();
		public ulong get_id ();
		public GnomeVFS.VolumeType get_volume_type ();
		public bool handles_trash ();
		public bool is_mounted ();
		public bool is_read_only ();
		public bool is_user_visible ();
		public unowned GnomeVFS.Volume @ref ();
		public void unmount (GnomeVFS.VolumeOpCallback callback);
		public void unref ();
	}
	[CCode (type_check_function = "GNOME_IS_VFS_VOLUME_MONITOR", cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class VolumeMonitor : GLib.Object {
		public unowned GLib.List get_connected_drives ();
		public unowned GnomeVFS.Drive get_drive_by_id (ulong id);
		public unowned GLib.List get_mounted_volumes ();
		public unowned GnomeVFS.Volume get_volume_by_id (ulong id);
		public unowned GnomeVFS.Volume get_volume_for_path (string path);
		public unowned GnomeVFS.VolumeMonitor @ref ();
		public void unref ();
		public virtual signal void drive_connected (GnomeVFS.Drive drive);
		public virtual signal void drive_disconnected (GnomeVFS.Drive drive);
		public virtual signal void volume_mounted (GnomeVFS.Volume volume);
		public virtual signal void volume_pre_unmount (GnomeVFS.Volume volume);
		public virtual signal void volume_unmounted (GnomeVFS.Volume volume);
	}
	[Compact]
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public class XferProgressInfo {
		public GnomeVFS.FileSize bytes_copied;
		public GnomeVFS.FileSize bytes_total;
		public int duplicate_count;
		public weak string duplicate_name;
		public ulong file_index;
		public GnomeVFS.FileSize file_size;
		public ulong files_total;
		public GnomeVFS.XferPhase phase;
		public void* reserved1;
		public void* reserved2;
		public weak string source_name;
		public GnomeVFS.XferProgressStatus status;
		public weak string target_name;
		public bool top_level_item;
		public GnomeVFS.FileSize total_bytes_copied;
		public GnomeVFS.Result vfs_status;
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[SimpleType]
	[IntegerType (rank = 0)]
	public struct FileSize : uint64 {
	}
	[CCode (cprefix = "GNOME_VFS_DNS_SD_SERVICE_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum DNSSDServiceStatus {
		ADDED,
		REMOVED
	}
	[CCode (cprefix = "GNOME_VFS_DEVICE_TYPE_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum DeviceType {
		UNKNOWN,
		AUDIO_CD,
		VIDEO_DVD,
		HARDDRIVE,
		CDROM,
		FLOPPY,
		ZIP,
		JAZ,
		NFS,
		AUTOFS,
		CAMERA,
		MEMORY_STICK,
		SMB,
		APPLE,
		MUSIC_PLAYER,
		WINDOWS,
		LOOPBACK,
		NETWORK
	}
	[CCode (cprefix = "GNOME_VFS_DIRECTORY_VISIT_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum DirectoryVisitOptions {
		DEFAULT,
		SAMEFS,
		LOOPCHECK,
		IGNORE_RECURSE_ERROR
	}
	[CCode (cprefix = "GNOME_VFS_FILE_FLAGS_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum FileFlags {
		NONE,
		SYMLINK,
		LOCAL
	}
	[CCode (cprefix = "GNOME_VFS_FILE_INFO_FIELDS_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum FileInfoFields {
		NONE,
		TYPE,
		PERMISSIONS,
		FLAGS,
		DEVICE,
		INODE,
		LINK_COUNT,
		SIZE,
		BLOCK_COUNT,
		IO_BLOCK_SIZE,
		ATIME,
		MTIME,
		CTIME,
		SYMLINK_NAME,
		MIME_TYPE,
		ACCESS,
		IDS,
		ACL,
		SELINUX_CONTEXT
	}
	[CCode (cprefix = "GNOME_VFS_FILE_INFO_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum FileInfoOptions {
		DEFAULT,
		GET_MIME_TYPE,
		FORCE_FAST_MIME_TYPE,
		FORCE_SLOW_MIME_TYPE,
		FOLLOW_LINKS,
		GET_ACCESS_RIGHTS,
		NAME_ONLY,
		GET_ACL,
		GET_SELINUX_CONTEXT
	}
	[CCode (cprefix = "GNOME_VFS_PERM_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum FilePermissions {
		SUID,
		SGID,
		STICKY,
		USER_READ,
		USER_WRITE,
		USER_EXEC,
		USER_ALL,
		GROUP_READ,
		GROUP_WRITE,
		GROUP_EXEC,
		GROUP_ALL,
		OTHER_READ,
		OTHER_WRITE,
		OTHER_EXEC,
		OTHER_ALL,
		ACCESS_READABLE,
		ACCESS_WRITABLE,
		ACCESS_EXECUTABLE
	}
	[CCode (cprefix = "GNOME_VFS_FILE_TYPE_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum FileType {
		UNKNOWN,
		REGULAR,
		DIRECTORY,
		FIFO,
		SOCKET,
		CHARACTER_DEVICE,
		BLOCK_DEVICE,
		SYMBOLIC_LINK
	}
	[CCode (cprefix = "GNOME_VFS_DIRECTORY_KIND_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum FindDirectoryKind {
		DESKTOP,
		TRASH
	}
	[CCode (cprefix = "GNOME_VFS_MAKE_URI_DIR_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum MakeURIDirs {
		NONE,
		HOMEDIR,
		CURRENT
	}
	[CCode (cprefix = "GNOME_VFS_MIME_ACTION_TYPE_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum MimeActionType {
		NONE,
		APPLICATION,
		COMPONENT
	}
	[CCode (cprefix = "GNOME_VFS_MIME_APPLICATION_ARGUMENT_TYPE_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum MimeApplicationArgumentType {
		URIS,
		PATHS,
		URIS_FOR_NON_FILES
	}
	[CCode (cprefix = "GNOME_VFS_MIME_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum MimeEquivalence {
		UNRELATED,
		IDENTICAL,
		PARENT
	}
	[CCode (cprefix = "", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum ModuleCallbackAuthenticationAuthType {
		AuthTypeBasic,
		AuthTypeDigest
	}
	[CCode (cprefix = "GNOME_VFS_MODULE_CALLBACK_FULL_AUTHENTICATION_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum ModuleCallbackFullAuthenticationFlags {
		PREVIOUS_ATTEMPT_FAILED,
		NEED_PASSWORD,
		NEED_USERNAME,
		NEED_DOMAIN,
		SAVING_SUPPORTED,
		ANON_SUPPORTED
	}
	[CCode (cprefix = "GNOME_VFS_MODULE_CALLBACK_FULL_AUTHENTICATION_OUT_ANON_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum ModuleCallbackFullAuthenticationOutFlags {
		SELECTED
	}
	[CCode (cprefix = "GNOME_VFS_MONITOR_EVENT_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum MonitorEventType {
		CHANGED,
		DELETED,
		STARTEXECUTING,
		STOPEXECUTING,
		CREATED,
		METADATA_CHANGED
	}
	[CCode (cprefix = "GNOME_VFS_MONITOR_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum MonitorType {
		FILE,
		DIRECTORY
	}
	[CCode (cprefix = "GNOME_VFS_OPEN_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum OpenMode {
		NONE,
		READ,
		WRITE,
		RANDOM,
		TRUNCATE
	}
	[CCode (cprefix = "GNOME_VFS_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum Result {
		OK,
		ERROR_NOT_FOUND,
		ERROR_GENERIC,
		ERROR_INTERNAL,
		ERROR_BAD_PARAMETERS,
		ERROR_NOT_SUPPORTED,
		ERROR_IO,
		ERROR_CORRUPTED_DATA,
		ERROR_WRONG_FORMAT,
		ERROR_BAD_FILE,
		ERROR_TOO_BIG,
		ERROR_NO_SPACE,
		ERROR_READ_ONLY,
		ERROR_INVALID_URI,
		ERROR_NOT_OPEN,
		ERROR_INVALID_OPEN_MODE,
		ERROR_ACCESS_DENIED,
		ERROR_TOO_MANY_OPEN_FILES,
		ERROR_EOF,
		ERROR_NOT_A_DIRECTORY,
		ERROR_IN_PROGRESS,
		ERROR_INTERRUPTED,
		ERROR_FILE_EXISTS,
		ERROR_LOOP,
		ERROR_NOT_PERMITTED,
		ERROR_IS_DIRECTORY,
		ERROR_NO_MEMORY,
		ERROR_HOST_NOT_FOUND,
		ERROR_INVALID_HOST_NAME,
		ERROR_HOST_HAS_NO_ADDRESS,
		ERROR_LOGIN_FAILED,
		ERROR_CANCELLED,
		ERROR_DIRECTORY_BUSY,
		ERROR_DIRECTORY_NOT_EMPTY,
		ERROR_TOO_MANY_LINKS,
		ERROR_READ_ONLY_FILE_SYSTEM,
		ERROR_NOT_SAME_FILE_SYSTEM,
		ERROR_NAME_TOO_LONG,
		ERROR_SERVICE_NOT_AVAILABLE,
		ERROR_SERVICE_OBSOLETE,
		ERROR_PROTOCOL_ERROR,
		ERROR_NO_MASTER_BROWSER,
		ERROR_NO_DEFAULT,
		ERROR_NO_HANDLER,
		ERROR_PARSE,
		ERROR_LAUNCH,
		ERROR_TIMEOUT,
		ERROR_NAMESERVER,
		ERROR_LOCKED,
		ERROR_DEPRECATED_FUNCTION,
		ERROR_INVALID_FILENAME,
		ERROR_NOT_A_SYMBOLIC_LINK,
		NUM_ERRORS
	}
	[CCode (cprefix = "GNOME_VFS_SEEK_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum SeekPosition {
		START,
		CURRENT,
		END
	}
	[CCode (cprefix = "GNOME_VFS_SET_FILE_INFO_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum SetFileInfoMask {
		NONE,
		NAME,
		PERMISSIONS,
		OWNER,
		TIME,
		ACL,
		SELINUX_CONTEXT,
		SYMLINK_NAME
	}
	[CCode (cprefix = "GNOME_VFS_URI_HIDE_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum URIHideOptions {
		NONE,
		USER_NAME,
		PASSWORD,
		HOST_NAME,
		HOST_PORT,
		TOPLEVEL_METHOD,
		FRAGMENT_IDENTIFIER
	}
	[CCode (cprefix = "GNOME_VFS_VOLUME_TYPE_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum VolumeType {
		MOUNTPOINT,
		VFS_MOUNT,
		CONNECTED_SERVER
	}
	[CCode (cprefix = "GNOME_VFS_XFER_ERROR_ACTION_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum XferErrorAction {
		ABORT,
		RETRY,
		SKIP
	}
	[CCode (cprefix = "GNOME_VFS_XFER_ERROR_MODE_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum XferErrorMode {
		ABORT,
		QUERY
	}
	[CCode (cprefix = "GNOME_VFS_XFER_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	[Flags]
	public enum XferOptions {
		DEFAULT,
		UNUSED_1,
		FOLLOW_LINKS,
		UNUSED_2,
		RECURSIVE,
		SAMEFS,
		DELETE_ITEMS,
		EMPTY_DIRECTORIES,
		NEW_UNIQUE_DIRECTORY,
		REMOVESOURCE,
		USE_UNIQUE_NAMES,
		LINK_ITEMS,
		FOLLOW_LINKS_RECURSIVE,
		TARGET_DEFAULT_PERMS
	}
	[CCode (cprefix = "GNOME_VFS_XFER_OVERWRITE_ACTION_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum XferOverwriteAction {
		ABORT,
		REPLACE,
		REPLACE_ALL,
		SKIP,
		SKIP_ALL
	}
	[CCode (cprefix = "GNOME_VFS_XFER_OVERWRITE_MODE_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum XferOverwriteMode {
		ABORT,
		QUERY,
		REPLACE,
		SKIP
	}
	[CCode (cprefix = "GNOME_VFS_XFER_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum XferPhase {
		PHASE_INITIAL,
		CHECKING_DESTINATION,
		PHASE_COLLECTING,
		PHASE_READYTOGO,
		PHASE_OPENSOURCE,
		PHASE_OPENTARGET,
		PHASE_COPYING,
		PHASE_MOVING,
		PHASE_READSOURCE,
		PHASE_WRITETARGET,
		PHASE_CLOSESOURCE,
		PHASE_CLOSETARGET,
		PHASE_DELETESOURCE,
		PHASE_SETATTRIBUTES,
		PHASE_FILECOMPLETED,
		PHASE_CLEANUP,
		PHASE_COMPLETED,
		NUM_PHASES
	}
	[CCode (cprefix = "GNOME_VFS_XFER_PROGRESS_STATUS_", has_type_id = false, cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public enum XferProgressStatus {
		OK,
		VFSERROR,
		OVERWRITE,
		DUPLICATE
	}
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncCloseCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncCreateAsChannelCallback (GnomeVFS.AsyncHandle handle, GLib.IOChannel channel, GnomeVFS.Result result, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncCreateCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncDirectoryLoadCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, GLib.List list, uint entries_read, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncFileControlCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, void* operation_data, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public delegate void AsyncFindDirectoryCallback (GnomeVFS.AsyncHandle handle, GLib.List results);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncGetFileInfoCallback (GnomeVFS.AsyncHandle handle, GLib.List results, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncModuleCallback (void* @in, size_t in_size, void* @out, size_t out_size, void* callback_data, GnomeVFS.ModuleCallbackResponse response, void* response_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncOpenAsChannelCallback (GnomeVFS.AsyncHandle handle, GLib.IOChannel channel, GnomeVFS.Result result, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncOpenCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncReadCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, void* buffer, GnomeVFS.FileSize bytes_requested, GnomeVFS.FileSize bytes_read, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncSeekCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncSetFileInfoCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, GnomeVFS.FileInfo file_info, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void AsyncWriteCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.Result result, void* buffer, GnomeVFS.FileSize bytes_requested, GnomeVFS.FileSize bytes_written, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public delegate int AsyncXferProgressCallback (GnomeVFS.AsyncHandle handle, GnomeVFS.XferProgressInfo info);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void DNSSDBrowseCallback (GnomeVFS.DNSSDBrowseHandle handle, GnomeVFS.DNSSDServiceStatus status, GnomeVFS.DNSSDService service, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void DNSSDResolveCallback (GnomeVFS.DNSSDResolveHandle handle, GnomeVFS.Result result, GnomeVFS.DNSSDService service, string host, int port, GLib.HashTable text, int text_raw_len, string text_raw, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate bool DirectoryVisitFunc (string rel_path, GnomeVFS.FileInfo info, bool recursing_will_loop, void* user_data, bool recurse);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void ModuleCallback (void* @in, size_t in_size, void* @out, size_t out_size, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h", has_target = false)]
	public delegate void ModuleCallbackResponse (void* response_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public delegate void MonitorCallback (GnomeVFS.MonitorHandle handle, string monitor_uri, string info_uri, GnomeVFS.MonitorEventType event_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public delegate void VolumeOpCallback (bool succeeded, string error, string detailed_error);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public delegate int XferProgressCallback (GnomeVFS.XferProgressInfo info);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string DESKTOP_ENTRY_GROUP;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_APPLICATION_REGISTRY_CAN_OPEN_MULTIPLE_FILES;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_APPLICATION_REGISTRY_COMMAND;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_APPLICATION_REGISTRY_NAME;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_APPLICATION_REGISTRY_REQUIRES_TERMINAL;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_APPLICATION_REGISTRY_STARTUP_NOTIFY;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_APPLICATION_REGISTRY_USES_GNOMEVFS;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int GNOME_VFS_MAJOR_VERSION;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int GNOME_VFS_MICRO_VERSION;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_MIME_TYPE_UNKNOWN;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int GNOME_VFS_MINOR_VERSION;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_MODULE_CALLBACK_AUTHENTICATION;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_MODULE_CALLBACK_FILL_AUTHENTICATION;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_MODULE_CALLBACK_FULL_AUTHENTICATION;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_MODULE_CALLBACK_HTTP_PROXY_AUTHENTICATION;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_MODULE_CALLBACK_HTTP_RECEIVED_HEADERS;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_MODULE_CALLBACK_HTTP_SEND_ADDITIONAL_HEADERS;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_MODULE_CALLBACK_QUESTION;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_MODULE_CALLBACK_SAVE_AUTHENTICATION;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_MODULE_CALLBACK_STATUS_MESSAGE;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int GNOME_VFS_PRIORITY_DEFAULT;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int GNOME_VFS_PRIORITY_MAX;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int GNOME_VFS_PRIORITY_MIN;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_URI_MAGIC_STR;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const string GNOME_VFS_URI_PATH_STR;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int S_IRGRP;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int S_IROTH;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int S_ISGID;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int S_ISUID;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int S_IWGRP;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int S_IWOTH;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int S_IXGRP;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public const int S_IXOTH;
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool application_is_user_owned_application (GnomeVFS.MimeApplication application);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_add_mime_type (string app_id, string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_clear_mime_types (string app_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool application_registry_exists (string app_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List application_registry_get_applications (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool application_registry_get_bool_value (string app_id, string key, bool got_key);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List application_registry_get_keys (string app_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GnomeVFS.MimeApplication application_registry_get_mime_application (string app_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List application_registry_get_mime_types (string app_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string application_registry_peek_value (string app_id, string key);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_reload ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_remove_application (string app_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_remove_mime_type (string app_id, string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_save_mime_application (GnomeVFS.MimeApplication application);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_set_bool_value (string app_id, string key, bool value);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_set_value (string app_id, string key, string value);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_shutdown ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool application_registry_supports_mime_type (string app_id, string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool application_registry_supports_uri_scheme (string app_id, string uri_scheme);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result application_registry_sync ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void application_registry_unset_key (string app_id, string key);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_cancel (GnomeVFS.AsyncHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_close (GnomeVFS.AsyncHandle handle, GnomeVFS.AsyncCloseCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_create (out unowned GnomeVFS.AsyncHandle handle_return, string text_uri, GnomeVFS.OpenMode open_mode, bool exclusive, uint perm, int priority, GnomeVFS.AsyncOpenCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_create_as_channel (out unowned GnomeVFS.AsyncHandle handle_return, string text_uri, GnomeVFS.OpenMode open_mode, bool exclusive, uint perm, int priority, GnomeVFS.AsyncCreateAsChannelCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_create_symbolic_link (out unowned GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, string uri_reference, int priority, GnomeVFS.AsyncOpenCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_create_uri (out unowned GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, GnomeVFS.OpenMode open_mode, bool exclusive, uint perm, int priority, GnomeVFS.AsyncOpenCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_create_uri_as_channel (out unowned GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, GnomeVFS.OpenMode open_mode, bool exclusive, uint perm, int priority, GnomeVFS.AsyncCreateAsChannelCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_file_control (GnomeVFS.AsyncHandle handle, string operation, void* operation_data, GLib.DestroyNotify operation_data_destroy_func, GnomeVFS.AsyncFileControlCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_find_directory (out unowned GnomeVFS.AsyncHandle handle_return, GLib.List near_uri_list, GnomeVFS.FindDirectoryKind kind, bool create_if_needed, bool find_if_needed, uint permissions, int priority, GnomeVFS.AsyncFindDirectoryCallback callback);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_get_file_info (out unowned GnomeVFS.AsyncHandle handle_return, GLib.List uri_list, GnomeVFS.FileInfoOptions options, int priority, GnomeVFS.AsyncGetFileInfoCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static int async_get_job_limit ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_load_directory (out unowned GnomeVFS.AsyncHandle handle_return, string text_uri, GnomeVFS.FileInfoOptions options, uint items_per_notification, int priority, GnomeVFS.AsyncDirectoryLoadCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_load_directory_uri (out unowned GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, GnomeVFS.FileInfoOptions options, uint items_per_notification, int priority, GnomeVFS.AsyncDirectoryLoadCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_module_callback_pop (string callback_name);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_module_callback_push (string callback_name, GnomeVFS.AsyncModuleCallback callback, void* callback_data, GLib.DestroyNotify destroy_notify);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_module_callback_set_default (string callback_name, GnomeVFS.AsyncModuleCallback callback, void* callback_data, GLib.DestroyNotify destroy_notify);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_open (out unowned GnomeVFS.AsyncHandle handle_return, string text_uri, GnomeVFS.OpenMode open_mode, int priority, GnomeVFS.AsyncOpenCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_open_as_channel (out unowned GnomeVFS.AsyncHandle handle_return, string text_uri, GnomeVFS.OpenMode open_mode, uint advised_block_size, int priority, GnomeVFS.AsyncOpenAsChannelCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_open_uri (out unowned GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, GnomeVFS.OpenMode open_mode, int priority, GnomeVFS.AsyncOpenCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_open_uri_as_channel (out unowned GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, GnomeVFS.OpenMode open_mode, uint advised_block_size, int priority, GnomeVFS.AsyncOpenAsChannelCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_read (GnomeVFS.AsyncHandle handle, void* buffer, uint bytes, GnomeVFS.AsyncReadCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_seek (GnomeVFS.AsyncHandle handle, GnomeVFS.SeekPosition whence, GnomeVFS.FileOffset offset, GnomeVFS.AsyncSeekCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_set_file_info (out unowned GnomeVFS.AsyncHandle handle_return, GnomeVFS.URI uri, GnomeVFS.FileInfo info, GnomeVFS.SetFileInfoMask mask, GnomeVFS.FileInfoOptions options, int priority, GnomeVFS.AsyncSetFileInfoCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_set_job_limit (int limit);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void async_write (GnomeVFS.AsyncHandle handle, void* buffer, uint bytes, GnomeVFS.AsyncWriteCallback callback, void* callback_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result async_xfer (out unowned GnomeVFS.AsyncHandle handle_return, GLib.List source_uri_list, GLib.List target_uri_list, GnomeVFS.XferOptions xfer_options, GnomeVFS.XferErrorMode error_mode, GnomeVFS.XferOverwriteMode overwrite_mode, int priority, GnomeVFS.AsyncXferProgressCallback progress_update_callback, GnomeVFS.XferProgressCallback? progress_sync_callback);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result check_same_fs (string source, string target, bool same_fs_return);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result check_same_fs_uris (GnomeVFS.URI source_uri, GnomeVFS.URI target_uri, bool same_fs_return);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result close (GnomeVFS.Handle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void connect_to_server (string uri, string display_name, string icon);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result create (out unowned GnomeVFS.Handle handle, string text_uri, GnomeVFS.OpenMode open_mode, bool exclusive, uint perm);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result create_symbolic_link (GnomeVFS.URI uri, string target_reference);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result create_uri (out unowned GnomeVFS.Handle handle, GnomeVFS.URI uri, GnomeVFS.OpenMode open_mode, bool exclusive, uint perm);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_close (GnomeVFS.DirectoryHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_list_load (GLib.List list, string text_uri, GnomeVFS.FileInfoOptions options);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_open (out unowned GnomeVFS.DirectoryHandle handle, string text_uri, GnomeVFS.FileInfoOptions options);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_open_from_uri (out unowned GnomeVFS.DirectoryHandle handle, GnomeVFS.URI uri, GnomeVFS.FileInfoOptions options);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_read_next (GnomeVFS.DirectoryHandle handle, GnomeVFS.FileInfo file_info);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_visit (string text_uri, GnomeVFS.FileInfoOptions info_options, GnomeVFS.DirectoryVisitOptions visit_options, GnomeVFS.DirectoryVisitFunc callback, void* data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_visit_files (string text_uri, GLib.List file_list, GnomeVFS.FileInfoOptions info_options, GnomeVFS.DirectoryVisitOptions visit_options, GnomeVFS.DirectoryVisitFunc callback, void* data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_visit_files_at_uri (GnomeVFS.URI uri, GLib.List file_list, GnomeVFS.FileInfoOptions info_options, GnomeVFS.DirectoryVisitOptions visit_options, GnomeVFS.DirectoryVisitFunc callback, void* data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result directory_visit_uri (GnomeVFS.URI uri, GnomeVFS.FileInfoOptions info_options, GnomeVFS.DirectoryVisitOptions visit_options, GnomeVFS.DirectoryVisitFunc callback, void* data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_browse (out unowned GnomeVFS.DNSSDBrowseHandle handle, string domain, string type, GnomeVFS.DNSSDBrowseCallback callback, void* callback_data, GLib.DestroyNotify callback_data_destroy_func);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_browse_sync (string domain, string type, int timeout_msec, int n_services, out unowned GnomeVFS.DNSSDService services);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_cancel_resolve (GnomeVFS.DNSSDResolveHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_list_browse_domains_sync (string domain, int timeout_msec, GLib.List domains);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_resolve (out unowned GnomeVFS.DNSSDResolveHandle handle, string name, string type, string domain, int timeout, GnomeVFS.DNSSDResolveCallback callback, void* callback_data, GLib.DestroyNotify callback_data_destroy_func);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_resolve_sync (string name, string type, string domain, int timeout_msec, out unowned string host, int port, GLib.HashTable text, int text_raw_len_out, out unowned string text_raw_out);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result dns_sd_stop_browse (GnomeVFS.DNSSDBrowseHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string escape_host_and_path_string (string path);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string escape_path_string (string path);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string escape_set (string str, string match_set);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string escape_slashes (string str);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string escape_string (string str);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string expand_initial_tilde (string path);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result file_control (GnomeVFS.Handle handle, string operation, void* operation_data);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result find_directory (GnomeVFS.URI near_uri, GnomeVFS.FindDirectoryKind kind, out unowned GnomeVFS.URI _result, bool create_if_needed, bool find_if_needed, uint permissions);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result forget_cache (GnomeVFS.Handle handle, GnomeVFS.FileOffset offset, GnomeVFS.FileSize size);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string format_file_size_for_display (GnomeVFS.FileSize size);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string format_uri_for_display (string uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List get_default_browse_domains ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result get_file_info (string text_uri, GnomeVFS.FileInfo info, GnomeVFS.FileInfoOptions options);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result get_file_info_from_handle (GnomeVFS.Handle handle, GnomeVFS.FileInfo info, GnomeVFS.FileInfoOptions options);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result get_file_info_uri (GnomeVFS.URI uri, GnomeVFS.FileInfo info, GnomeVFS.FileInfoOptions options);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_file_mime_type (string path, void* optional_stat_info, bool suffix_only);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_file_mime_type_fast (string path, void* optional_stat_info);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_local_path_from_uri (string uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_mime_type (string text_uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_mime_type_common (GnomeVFS.URI uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_mime_type_for_data (void* data, int data_size);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_mime_type_for_name (string filename);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_mime_type_for_name_and_data (string filename, void* data, ssize_t data_size);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_mime_type_from_file_data (GnomeVFS.URI uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_mime_type_from_uri (GnomeVFS.URI uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_slow_mime_type (string text_uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_supertype_from_mime_type (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_uri_from_local_path (string local_full_path);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string get_uri_scheme (string uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result get_volume_free_space (GnomeVFS.URI vfs_uri, GnomeVFS.FileSize size);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GnomeVFS.VolumeMonitor get_volume_monitor ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string icon_path_from_filename (string filename);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool init ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool initialized ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool is_executable_command_string (string command_string);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool is_primary_thread ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void list_deep_free (GLib.List list);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void loadinit (void* app, void* modinfo);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result make_directory (string text_uri, uint perm);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result make_directory_for_uri (GnomeVFS.URI uri, uint perm);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string make_path_name_canonical (string path);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string make_uri_canonical (string uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string make_uri_canonical_strip_fragment (string uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string make_uri_from_input (string location);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string make_uri_from_input_with_dirs (string location, GnomeVFS.MakeURIDirs dirs);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string make_uri_from_input_with_trailing_ws (string location);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string make_uri_from_shell_arg (string uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string make_uri_full_from_relative (string base_uri, string relative_uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_add_application_to_short_list (string mime_type, string application_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_add_component_to_short_list (string mime_type, string iid);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_add_extension (string mime_type, string extension);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool mime_can_be_executable (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void mime_component_list_free (GLib.List list);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_extend_all_applications (string mime_type, GLib.List application_ids);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List mime_get_all_applications (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List mime_get_all_applications_for_uri (string uri, string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List mime_get_all_components (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List mime_get_all_desktop_entries (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GnomeVFS.MimeAction mime_get_default_action (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.MimeActionType mime_get_default_action_type (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GnomeVFS.MimeApplication mime_get_default_application (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GnomeVFS.MimeApplication mime_get_default_application_for_uri (string uri, string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void* mime_get_default_component (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string mime_get_default_desktop_entry (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string mime_get_description (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string mime_get_icon (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List mime_get_short_list_applications (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List mime_get_short_list_components (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool mime_id_in_application_list (string id, GLib.List applications);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool mime_id_in_component_list (string iid, GLib.List components);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List mime_id_list_from_application_list (GLib.List applications);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List mime_id_list_from_component_list (GLib.List components);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void mime_info_cache_reload (string dir);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void mime_reload ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List mime_remove_application_from_list (GLib.List applications, string application_id, bool did_remove);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_remove_application_from_short_list (string mime_type, string application_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned GLib.List mime_remove_component_from_list (GLib.List components, string iid, bool did_remove);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_remove_component_from_short_list (string mime_type, string iid);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_remove_extension (string mime_type, string extension);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_remove_from_all_applications (string mime_type, GLib.List application_ids);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_can_be_executable (string mime_type, bool new_value);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_default_action_type (string mime_type, GnomeVFS.MimeActionType action_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_default_application (string mime_type, string application_id);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_default_component (string mime_type, string component_iid);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_description (string mime_type, string description);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_icon (string mime_type, string filename);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_short_list_applications (string mime_type, GLib.List application_ids);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result mime_set_short_list_components (string mime_type, GLib.List component_iids);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void mime_shutdown ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string mime_type_from_name (string filename);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string mime_type_from_name_or_default (string filename, string defaultv);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.MimeEquivalence mime_type_get_equivalence (string mime_type, string base_mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool mime_type_is_equal (string a, string b);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool mime_type_is_supertype (string mime_type);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void module_callback_pop (string callback_name);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void module_callback_push (string callback_name, GnomeVFS.ModuleCallback callback, void* callback_data, GLib.DestroyNotify destroy_notify);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void module_callback_set_default (string callback_name, GnomeVFS.ModuleCallback callback, void* callback_data, GLib.DestroyNotify destroy_notify);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result monitor_add (out unowned GnomeVFS.MonitorHandle handle, string text_uri, GnomeVFS.MonitorType monitor_type, GnomeVFS.MonitorCallback callback);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result monitor_cancel (GnomeVFS.MonitorHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result move (string old_text_uri, string new_text_uri, bool force_replace);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result move_uri (GnomeVFS.URI old_uri, GnomeVFS.URI new_uri, bool force_replace);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result open (out unowned GnomeVFS.Handle handle, string text_uri, GnomeVFS.OpenMode open_mode);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result open_fd (out unowned GnomeVFS.Handle handle, int filedes);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result open_uri (out unowned GnomeVFS.Handle handle, GnomeVFS.URI uri, GnomeVFS.OpenMode open_mode);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void postinit (void* app, void* modinfo);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void preinit (void* app, void* modinfo);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result read (GnomeVFS.Handle handle, void* buffer, GnomeVFS.FileSize bytes, out GnomeVFS.FileSize bytes_read);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result read_entire_file (string uri, int file_size, out unowned string file_contents);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result remove_directory (string text_uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result remove_directory_from_uri (GnomeVFS.URI uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result resolve (string hostname, out unowned GnomeVFS.ResolveHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void resolve_free (GnomeVFS.ResolveHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool resolve_next_address (GnomeVFS.ResolveHandle handle, out unowned GnomeVFS.Address address);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void resolve_reset_to_beginning (GnomeVFS.ResolveHandle handle);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result result_from_errno ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result result_from_errno_code (int errno_code);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result result_from_h_errno ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result result_from_h_errno_val (int h_errno_code);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string result_to_string (GnomeVFS.Result _result);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result seek (GnomeVFS.Handle handle, GnomeVFS.SeekPosition whence, GnomeVFS.FileOffset offset);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result set_file_info (string text_uri, GnomeVFS.FileInfo info, GnomeVFS.SetFileInfoMask mask);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result set_file_info_uri (GnomeVFS.URI uri, GnomeVFS.FileInfo info, GnomeVFS.SetFileInfoMask mask);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static void shutdown ();
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result tell (GnomeVFS.Handle handle, GnomeVFS.FileSize offset_return);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result truncate (string text_uri, GnomeVFS.FileSize length);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result truncate_handle (GnomeVFS.Handle handle, GnomeVFS.FileSize length);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result truncate_uri (GnomeVFS.URI uri, GnomeVFS.FileSize length);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string unescape_string (string escaped_string, string illegal_characters);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static unowned string unescape_string_for_display (string escaped);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result unlink (string text_uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result unlink_from_uri (GnomeVFS.URI uri);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static bool uris_match (string uri_1, string uri_2);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result url_show (string url);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result url_show_with_env (string url, out unowned string envp);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result write (GnomeVFS.Handle handle, void* buffer, GnomeVFS.FileSize bytes, out GnomeVFS.FileSize bytes_written);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result xfer_delete_list (GLib.List source_uri_list, GnomeVFS.XferErrorMode error_mode, GnomeVFS.XferOptions xfer_options, GnomeVFS.XferProgressCallback? progress_callback);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result xfer_uri (GnomeVFS.URI source_uri, GnomeVFS.URI target_uri, GnomeVFS.XferOptions xfer_options, GnomeVFS.XferErrorMode error_mode, GnomeVFS.XferOverwriteMode overwrite_mode, GnomeVFS.XferProgressCallback? progress_callback);
	[CCode (cheader_filename = "libgnomevfs/gnome-vfs.h")]
	public static GnomeVFS.Result xfer_uri_list (GLib.List source_uri_list, GLib.List target_uri_list, GnomeVFS.XferOptions xfer_options, GnomeVFS.XferErrorMode error_mode, GnomeVFS.XferOverwriteMode overwrite_mode, GnomeVFS.XferProgressCallback? progress_callback);
}
