/* valanamespace.c generated by valac, the Vala compiler
 * generated from valanamespace.vala, do not modify */

/* valanamespace.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;
typedef struct _ValaNamespacePrivate ValaNamespacePrivate;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_PROFILE (vala_profile_get_type ())
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*process_deprecated_attribute) (ValaSymbol* self, ValaAttribute* attr);
};

struct _ValaNamespace {
	ValaSymbol parent_instance;
	ValaNamespacePrivate * priv;
};

struct _ValaNamespaceClass {
	ValaSymbolClass parent_class;
};

struct _ValaNamespacePrivate {
	ValaList* classes;
	ValaList* interfaces;
	ValaList* structs;
	ValaList* enums;
	ValaList* error_domains;
	ValaList* delegates;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* comments;
	ValaList* cprefixes;
	char* lower_case_cprefix;
	ValaList* cheader_filenames;
	ValaList* namespaces;
	ValaList* using_directives;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;

typedef enum  {
	VALA_PROFILE_POSIX,
	VALA_PROFILE_GOBJECT,
	VALA_PROFILE_DOVA
} ValaProfile;


static gpointer vala_namespace_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_local_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_member_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
GType vala_using_directive_get_type (void) G_GNUC_CONST;
#define VALA_NAMESPACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_NAMESPACE, ValaNamespacePrivate))
enum  {
	VALA_NAMESPACE_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaSymbol* vala_symbol_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
GType vala_symbol_accessibility_get_type (void) G_GNUC_CONST;
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
ValaNamespace* vala_namespace_new (const char* name, ValaSourceReference* source_reference);
ValaNamespace* vala_namespace_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
void vala_namespace_add_using_directive (ValaNamespace* self, ValaUsingDirective* ns);
void vala_namespace_add_comment (ValaNamespace* self, ValaComment* comment);
ValaList* vala_namespace_get_comments (ValaNamespace* self);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
const char* vala_symbol_get_name (ValaSymbol* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
ValaList* vala_namespace_get_namespaces (ValaNamespace* self);
void vala_namespace_add_namespace (ValaNamespace* self, ValaNamespace* ns);
ValaList* vala_namespace_get_classes (ValaNamespace* self);
void vala_namespace_add_class (ValaNamespace* self, ValaClass* cl);
ValaList* vala_namespace_get_structs (ValaNamespace* self);
void vala_namespace_add_struct (ValaNamespace* self, ValaStruct* st);
ValaList* vala_namespace_get_interfaces (ValaNamespace* self);
void vala_namespace_add_interface (ValaNamespace* self, ValaInterface* iface);
ValaList* vala_namespace_get_delegates (ValaNamespace* self);
void vala_namespace_add_delegate (ValaNamespace* self, ValaDelegate* d);
ValaList* vala_namespace_get_enums (ValaNamespace* self);
void vala_namespace_add_enum (ValaNamespace* self, ValaEnum* en);
ValaList* vala_namespace_get_error_domains (ValaNamespace* self);
void vala_namespace_add_error_domain (ValaNamespace* self, ValaErrorDomain* edomain);
ValaList* vala_namespace_get_constants (ValaNamespace* self);
void vala_namespace_add_constant (ValaNamespace* self, ValaConstant* constant);
ValaList* vala_namespace_get_fields (ValaNamespace* self);
void vala_namespace_add_field (ValaNamespace* self, ValaField* f);
ValaList* vala_namespace_get_methods (ValaNamespace* self);
void vala_namespace_add_method (ValaNamespace* self, ValaMethod* m);
void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym);
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
void vala_scope_remove (ValaScope* self, const char* name);
void vala_namespace_remove_struct (ValaNamespace* self, ValaStruct* st);
GType member_binding_get_type (void) G_GNUC_CONST;
MemberBinding vala_field_get_binding (ValaField* self);
void vala_report_error (ValaSourceReference* source, const char* message);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
GType vala_creation_method_get_type (void) G_GNUC_CONST;
MemberBinding vala_method_get_binding (ValaMethod* self);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
GType vala_void_type_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_code_context_get (void);
GType vala_profile_get_type (void) G_GNUC_CONST;
ValaProfile vala_code_context_get_profile (ValaCodeContext* self);
ValaList* vala_method_get_postconditions (ValaMethod* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_method_set_result_var (ValaMethod* self, ValaLocalVariable* value);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
ValaLocalVariable* vala_method_get_result_var (ValaMethod* self);
void vala_code_visitor_visit_namespace (ValaCodeVisitor* self, ValaNamespace* ns);
static void vala_namespace_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_namespace_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
char* vala_symbol_get_cprefix (ValaSymbol* self);
static char* vala_namespace_real_get_cprefix (ValaSymbol* base);
ValaList* vala_namespace_get_cprefixes (ValaNamespace* self);
void vala_namespace_add_cprefix (ValaNamespace* self, const char* cprefix);
char* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
char* vala_symbol_camel_case_to_lower_case (const char* camel_case);
static char* vala_namespace_real_get_lower_case_cprefix (ValaSymbol* base);
void vala_namespace_set_lower_case_cprefix (ValaNamespace* self, const char* cprefix);
static ValaList* vala_namespace_real_get_cheader_filenames (ValaSymbol* base);
void vala_namespace_set_cheader_filename (ValaNamespace* self, const char* cheader_filename);
void vala_namespace_add_cheader_filename (ValaNamespace* self, const char* cheader_filename);
gboolean vala_attribute_has_argument (ValaAttribute* self, const char* name);
char* vala_attribute_get_string (ValaAttribute* self, const char* name);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
void vala_source_file_set_gir_namespace (ValaSourceFile* self, const char* value);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_source_file_set_gir_version (ValaSourceFile* self, const char* value);
static void vala_namespace_process_ccode_attribute (ValaNamespace* self, ValaAttribute* a);
const char* vala_attribute_get_name (ValaAttribute* self);
void vala_namespace_process_attributes (ValaNamespace* self);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
static gboolean vala_namespace_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static void vala_namespace_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaNamespace* vala_namespace_construct (GType object_type, const char* name, ValaSourceReference* source_reference) {
	ValaNamespace* self;
	self = (ValaNamespace*) vala_symbol_construct (object_type, name, source_reference);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaNamespace* vala_namespace_new (const char* name, ValaSourceReference* source_reference) {
	return vala_namespace_construct (VALA_TYPE_NAMESPACE, name, source_reference);
}


void vala_namespace_add_using_directive (ValaNamespace* self, ValaUsingDirective* ns) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	vala_collection_add ((ValaCollection*) self->priv->using_directives, ns);
}


void vala_namespace_add_comment (ValaNamespace* self, ValaComment* comment) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	vala_collection_add ((ValaCollection*) self->priv->comments, comment);
}


static gpointer _vala_collection_object_ref0 (gpointer self) {
	return self ? vala_collection_object_ref (self) : NULL;
}


ValaList* vala_namespace_get_comments (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->comments);
	return result;
}


void vala_namespace_add_namespace (ValaNamespace* self, ValaNamespace* ns) {
	ValaSymbol* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	if ((_tmp1_ = VALA_IS_NAMESPACE (_tmp0_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) ns))), _vala_code_node_unref0 (_tmp0_), _tmp1_)) {
		ValaNamespace* old_ns;
		gboolean _tmp2_ = FALSE;
		old_ns = VALA_NAMESPACE (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) ns)));
		if (vala_symbol_get_external_package ((ValaSymbol*) old_ns)) {
			_tmp2_ = !vala_symbol_get_external_package ((ValaSymbol*) ns);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			vala_code_node_set_source_reference ((ValaCodeNode*) old_ns, vala_code_node_get_source_reference ((ValaCodeNode*) ns));
		}
		{
			ValaIterator* _using_directive_it;
			_using_directive_it = vala_iterable_iterator ((ValaIterable*) ns->priv->using_directives);
			while (TRUE) {
				ValaUsingDirective* using_directive;
				if (!vala_iterator_next (_using_directive_it)) {
					break;
				}
				using_directive = (ValaUsingDirective*) vala_iterator_get (_using_directive_it);
				vala_namespace_add_using_directive (old_ns, using_directive);
				_vala_code_node_unref0 (using_directive);
			}
			_vala_collection_object_unref0 (_using_directive_it);
		}
		{
			ValaList* _tmp3_;
			ValaIterator* _tmp4_;
			ValaIterator* _sub_ns_it;
			_sub_ns_it = (_tmp4_ = vala_iterable_iterator ((ValaIterable*) (_tmp3_ = vala_namespace_get_namespaces (ns))), _vala_collection_object_unref0 (_tmp3_), _tmp4_);
			while (TRUE) {
				ValaNamespace* sub_ns;
				if (!vala_iterator_next (_sub_ns_it)) {
					break;
				}
				sub_ns = (ValaNamespace*) vala_iterator_get (_sub_ns_it);
				vala_namespace_add_namespace (old_ns, sub_ns);
				_vala_code_node_unref0 (sub_ns);
			}
			_vala_collection_object_unref0 (_sub_ns_it);
		}
		{
			ValaList* _tmp5_;
			ValaIterator* _tmp6_;
			ValaIterator* _cl_it;
			_cl_it = (_tmp6_ = vala_iterable_iterator ((ValaIterable*) (_tmp5_ = vala_namespace_get_classes (ns))), _vala_collection_object_unref0 (_tmp5_), _tmp6_);
			while (TRUE) {
				ValaClass* cl;
				if (!vala_iterator_next (_cl_it)) {
					break;
				}
				cl = (ValaClass*) vala_iterator_get (_cl_it);
				vala_namespace_add_class (old_ns, cl);
				_vala_code_node_unref0 (cl);
			}
			_vala_collection_object_unref0 (_cl_it);
		}
		{
			ValaList* _tmp7_;
			ValaIterator* _tmp8_;
			ValaIterator* _st_it;
			_st_it = (_tmp8_ = vala_iterable_iterator ((ValaIterable*) (_tmp7_ = vala_namespace_get_structs (ns))), _vala_collection_object_unref0 (_tmp7_), _tmp8_);
			while (TRUE) {
				ValaStruct* st;
				if (!vala_iterator_next (_st_it)) {
					break;
				}
				st = (ValaStruct*) vala_iterator_get (_st_it);
				vala_namespace_add_struct (old_ns, st);
				_vala_code_node_unref0 (st);
			}
			_vala_collection_object_unref0 (_st_it);
		}
		{
			ValaList* _tmp9_;
			ValaIterator* _tmp10_;
			ValaIterator* _iface_it;
			_iface_it = (_tmp10_ = vala_iterable_iterator ((ValaIterable*) (_tmp9_ = vala_namespace_get_interfaces (ns))), _vala_collection_object_unref0 (_tmp9_), _tmp10_);
			while (TRUE) {
				ValaInterface* iface;
				if (!vala_iterator_next (_iface_it)) {
					break;
				}
				iface = (ValaInterface*) vala_iterator_get (_iface_it);
				vala_namespace_add_interface (old_ns, iface);
				_vala_code_node_unref0 (iface);
			}
			_vala_collection_object_unref0 (_iface_it);
		}
		{
			ValaList* _tmp11_;
			ValaIterator* _tmp12_;
			ValaIterator* _d_it;
			_d_it = (_tmp12_ = vala_iterable_iterator ((ValaIterable*) (_tmp11_ = vala_namespace_get_delegates (ns))), _vala_collection_object_unref0 (_tmp11_), _tmp12_);
			while (TRUE) {
				ValaDelegate* d;
				if (!vala_iterator_next (_d_it)) {
					break;
				}
				d = (ValaDelegate*) vala_iterator_get (_d_it);
				vala_namespace_add_delegate (old_ns, d);
				_vala_code_node_unref0 (d);
			}
			_vala_collection_object_unref0 (_d_it);
		}
		{
			ValaList* _tmp13_;
			ValaIterator* _tmp14_;
			ValaIterator* _en_it;
			_en_it = (_tmp14_ = vala_iterable_iterator ((ValaIterable*) (_tmp13_ = vala_namespace_get_enums (ns))), _vala_collection_object_unref0 (_tmp13_), _tmp14_);
			while (TRUE) {
				ValaEnum* en;
				if (!vala_iterator_next (_en_it)) {
					break;
				}
				en = (ValaEnum*) vala_iterator_get (_en_it);
				vala_namespace_add_enum (old_ns, en);
				_vala_code_node_unref0 (en);
			}
			_vala_collection_object_unref0 (_en_it);
		}
		{
			ValaList* _tmp15_;
			ValaIterator* _tmp16_;
			ValaIterator* _ed_it;
			_ed_it = (_tmp16_ = vala_iterable_iterator ((ValaIterable*) (_tmp15_ = vala_namespace_get_error_domains (ns))), _vala_collection_object_unref0 (_tmp15_), _tmp16_);
			while (TRUE) {
				ValaErrorDomain* ed;
				if (!vala_iterator_next (_ed_it)) {
					break;
				}
				ed = (ValaErrorDomain*) vala_iterator_get (_ed_it);
				vala_namespace_add_error_domain (old_ns, ed);
				_vala_code_node_unref0 (ed);
			}
			_vala_collection_object_unref0 (_ed_it);
		}
		{
			ValaList* _tmp17_;
			ValaIterator* _tmp18_;
			ValaIterator* _c_it;
			_c_it = (_tmp18_ = vala_iterable_iterator ((ValaIterable*) (_tmp17_ = vala_namespace_get_constants (ns))), _vala_collection_object_unref0 (_tmp17_), _tmp18_);
			while (TRUE) {
				ValaConstant* c;
				if (!vala_iterator_next (_c_it)) {
					break;
				}
				c = (ValaConstant*) vala_iterator_get (_c_it);
				vala_namespace_add_constant (old_ns, c);
				_vala_code_node_unref0 (c);
			}
			_vala_collection_object_unref0 (_c_it);
		}
		{
			ValaList* _tmp19_;
			ValaIterator* _tmp20_;
			ValaIterator* _f_it;
			_f_it = (_tmp20_ = vala_iterable_iterator ((ValaIterable*) (_tmp19_ = vala_namespace_get_fields (ns))), _vala_collection_object_unref0 (_tmp19_), _tmp20_);
			while (TRUE) {
				ValaField* f;
				if (!vala_iterator_next (_f_it)) {
					break;
				}
				f = (ValaField*) vala_iterator_get (_f_it);
				vala_namespace_add_field (old_ns, f);
				_vala_code_node_unref0 (f);
			}
			_vala_collection_object_unref0 (_f_it);
		}
		{
			ValaList* _tmp21_;
			ValaIterator* _tmp22_;
			ValaIterator* _m_it;
			_m_it = (_tmp22_ = vala_iterable_iterator ((ValaIterable*) (_tmp21_ = vala_namespace_get_methods (ns))), _vala_collection_object_unref0 (_tmp21_), _tmp22_);
			while (TRUE) {
				ValaMethod* m;
				if (!vala_iterator_next (_m_it)) {
					break;
				}
				m = (ValaMethod*) vala_iterator_get (_m_it);
				vala_namespace_add_method (old_ns, m);
				_vala_code_node_unref0 (m);
			}
			_vala_collection_object_unref0 (_m_it);
		}
		{
			ValaList* _tmp23_;
			ValaIterator* _tmp24_;
			ValaIterator* _c_it;
			_c_it = (_tmp24_ = vala_iterable_iterator ((ValaIterable*) (_tmp23_ = vala_namespace_get_comments (ns))), _vala_collection_object_unref0 (_tmp23_), _tmp24_);
			while (TRUE) {
				ValaComment* c;
				if (!vala_iterator_next (_c_it)) {
					break;
				}
				c = (ValaComment*) vala_iterator_get (_c_it);
				vala_namespace_add_comment (old_ns, c);
				_vala_comment_unref0 (c);
			}
			_vala_collection_object_unref0 (_c_it);
		}
		_vala_code_node_unref0 (old_ns);
	} else {
		vala_collection_add ((ValaCollection*) self->priv->namespaces, ns);
		vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) ns), (ValaSymbol*) ns);
	}
}


ValaList* vala_namespace_get_namespaces (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->namespaces);
	return result;
}


void vala_namespace_add_class (ValaNamespace* self, ValaClass* cl) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	vala_collection_add ((ValaCollection*) self->priv->classes, cl);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) cl), (ValaSymbol*) cl);
}


void vala_namespace_add_interface (ValaNamespace* self, ValaInterface* iface) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) iface) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) iface, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	vala_collection_add ((ValaCollection*) self->priv->interfaces, iface);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) iface), (ValaSymbol*) iface);
}


void vala_namespace_add_struct (ValaNamespace* self, ValaStruct* st) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) st) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	vala_collection_add ((ValaCollection*) self->priv->structs, st);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) st), (ValaSymbol*) st);
}


void vala_namespace_remove_struct (ValaNamespace* self, ValaStruct* st) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->structs, st);
	vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) st));
}


void vala_namespace_add_enum (ValaNamespace* self, ValaEnum* en) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (en != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) en) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	vala_collection_add ((ValaCollection*) self->priv->enums, en);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) en), (ValaSymbol*) en);
}


void vala_namespace_add_error_domain (ValaNamespace* self, ValaErrorDomain* edomain) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (edomain != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) edomain) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) edomain, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	vala_collection_add ((ValaCollection*) self->priv->error_domains, edomain);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) edomain), (ValaSymbol*) edomain);
}


void vala_namespace_add_delegate (ValaNamespace* self, ValaDelegate* d) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (d != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) d) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) d, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	vala_collection_add ((ValaCollection*) self->priv->delegates, d);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) d), (ValaSymbol*) d);
}


ValaList* vala_namespace_get_structs (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->structs);
	return result;
}


ValaList* vala_namespace_get_classes (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->classes);
	return result;
}


ValaList* vala_namespace_get_interfaces (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->interfaces);
	return result;
}


ValaList* vala_namespace_get_enums (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->enums);
	return result;
}


ValaList* vala_namespace_get_error_domains (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->error_domains);
	return result;
}


ValaList* vala_namespace_get_fields (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->fields);
	return result;
}


ValaList* vala_namespace_get_constants (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->constants);
	return result;
}


ValaList* vala_namespace_get_delegates (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->delegates);
	return result;
}


ValaList* vala_namespace_get_methods (ValaNamespace* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->methods);
	return result;
}


void vala_namespace_add_constant (ValaNamespace* self, ValaConstant* constant) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (constant != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) constant) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) constant, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	vala_collection_add ((ValaCollection*) self->priv->constants, constant);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) constant), (ValaSymbol*) constant);
}


void vala_namespace_add_field (ValaNamespace* self, ValaField* f) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) f, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) f), "instance members are not allowed outside of data types");
		vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
		return;
	} else {
		if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) f), "class members are not allowed outside of classes");
			vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
			return;
		}
	}
	vala_collection_add ((ValaCollection*) self->priv->fields, f);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) f), (ValaSymbol*) f);
}


void vala_namespace_add_method (ValaNamespace* self, ValaMethod* m) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	if (vala_symbol_get_access ((ValaSymbol*) m) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) m), "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) m), "instance members are not allowed outside of data types");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	} else {
		if (vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) m), "class members are not allowed outside of classes");
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
	}
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		gboolean _tmp1_ = FALSE;
		ValaCodeContext* _tmp2_;
		gboolean _tmp3_;
		if ((_tmp3_ = vala_code_context_get_profile (_tmp2_ = vala_code_context_get ()) == VALA_PROFILE_DOVA, _vala_code_context_unref0 (_tmp2_), _tmp3_)) {
			_tmp1_ = TRUE;
		} else {
			ValaList* _tmp4_;
			_tmp1_ = vala_collection_get_size ((ValaCollection*) (_tmp4_ = vala_method_get_postconditions (m))) > 0;
			_vala_collection_object_unref0 (_tmp4_);
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaLocalVariable* _tmp6_;
		ValaDataType* _tmp5_;
		vala_method_set_result_var (m, _tmp6_ = vala_local_variable_new (_tmp5_ = vala_data_type_copy (vala_method_get_return_type (m)), "result", NULL, vala_code_node_get_source_reference ((ValaCodeNode*) self)));
		_vala_code_node_unref0 (_tmp6_);
		_vala_code_node_unref0 (_tmp5_);
		vala_local_variable_set_is_result (vala_method_get_result_var (m), TRUE);
	}
	vala_collection_add ((ValaCollection*) self->priv->methods, m);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) m), (ValaSymbol*) m);
}


static void vala_namespace_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_namespace (visitor, self);
}


static void vala_namespace_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaIterator* _ns_ref_it;
		_ns_ref_it = vala_iterable_iterator ((ValaIterable*) self->priv->using_directives);
		while (TRUE) {
			ValaUsingDirective* ns_ref;
			if (!vala_iterator_next (_ns_ref_it)) {
				break;
			}
			ns_ref = (ValaUsingDirective*) vala_iterator_get (_ns_ref_it);
			vala_code_node_accept ((ValaCodeNode*) ns_ref, visitor);
			_vala_code_node_unref0 (ns_ref);
		}
		_vala_collection_object_unref0 (_ns_ref_it);
	}
	{
		ValaIterator* _ns_it;
		_ns_it = vala_iterable_iterator ((ValaIterable*) self->priv->namespaces);
		while (TRUE) {
			ValaNamespace* ns;
			if (!vala_iterator_next (_ns_it)) {
				break;
			}
			ns = (ValaNamespace*) vala_iterator_get (_ns_it);
			vala_code_node_accept ((ValaCodeNode*) ns, visitor);
			_vala_code_node_unref0 (ns);
		}
		_vala_collection_object_unref0 (_ns_it);
	}
	{
		ValaIterator* _en_it;
		_en_it = vala_iterable_iterator ((ValaIterable*) self->priv->enums);
		while (TRUE) {
			ValaEnum* en;
			if (!vala_iterator_next (_en_it)) {
				break;
			}
			en = (ValaEnum*) vala_iterator_get (_en_it);
			vala_code_node_accept ((ValaCodeNode*) en, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_collection_object_unref0 (_en_it);
	}
	{
		ValaIterator* _edomain_it;
		_edomain_it = vala_iterable_iterator ((ValaIterable*) self->priv->error_domains);
		while (TRUE) {
			ValaErrorDomain* edomain;
			if (!vala_iterator_next (_edomain_it)) {
				break;
			}
			edomain = (ValaErrorDomain*) vala_iterator_get (_edomain_it);
			vala_code_node_accept ((ValaCodeNode*) edomain, visitor);
			_vala_code_node_unref0 (edomain);
		}
		_vala_collection_object_unref0 (_edomain_it);
	}
	{
		ValaIterator* _cl_it;
		_cl_it = vala_iterable_iterator ((ValaIterable*) self->priv->classes);
		while (TRUE) {
			ValaClass* cl;
			if (!vala_iterator_next (_cl_it)) {
				break;
			}
			cl = (ValaClass*) vala_iterator_get (_cl_it);
			vala_code_node_accept ((ValaCodeNode*) cl, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_collection_object_unref0 (_cl_it);
	}
	{
		ValaIterator* _iface_it;
		_iface_it = vala_iterable_iterator ((ValaIterable*) self->priv->interfaces);
		while (TRUE) {
			ValaInterface* iface;
			if (!vala_iterator_next (_iface_it)) {
				break;
			}
			iface = (ValaInterface*) vala_iterator_get (_iface_it);
			vala_code_node_accept ((ValaCodeNode*) iface, visitor);
			_vala_code_node_unref0 (iface);
		}
		_vala_collection_object_unref0 (_iface_it);
	}
	{
		ValaIterator* _st_it;
		_st_it = vala_iterable_iterator ((ValaIterable*) self->priv->structs);
		while (TRUE) {
			ValaStruct* st;
			if (!vala_iterator_next (_st_it)) {
				break;
			}
			st = (ValaStruct*) vala_iterator_get (_st_it);
			vala_code_node_accept ((ValaCodeNode*) st, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_collection_object_unref0 (_st_it);
	}
	{
		ValaIterator* _d_it;
		_d_it = vala_iterable_iterator ((ValaIterable*) self->priv->delegates);
		while (TRUE) {
			ValaDelegate* d;
			if (!vala_iterator_next (_d_it)) {
				break;
			}
			d = (ValaDelegate*) vala_iterator_get (_d_it);
			vala_code_node_accept ((ValaCodeNode*) d, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_collection_object_unref0 (_d_it);
	}
	{
		ValaIterator* _c_it;
		_c_it = vala_iterable_iterator ((ValaIterable*) self->priv->constants);
		while (TRUE) {
			ValaConstant* c;
			if (!vala_iterator_next (_c_it)) {
				break;
			}
			c = (ValaConstant*) vala_iterator_get (_c_it);
			vala_code_node_accept ((ValaCodeNode*) c, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_collection_object_unref0 (_c_it);
	}
	{
		ValaIterator* _f_it;
		_f_it = vala_iterable_iterator ((ValaIterable*) self->priv->fields);
		while (TRUE) {
			ValaField* f;
			if (!vala_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) vala_iterator_get (_f_it);
			vala_code_node_accept ((ValaCodeNode*) f, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_collection_object_unref0 (_f_it);
	}
	{
		ValaIterator* _m_it;
		_m_it = vala_iterable_iterator ((ValaIterable*) self->priv->methods);
		while (TRUE) {
			ValaMethod* m;
			if (!vala_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) vala_iterator_get (_m_it);
			vala_code_node_accept ((ValaCodeNode*) m, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_collection_object_unref0 (_m_it);
	}
}


static char* vala_namespace_real_get_cprefix (ValaSymbol* base) {
	ValaNamespace * self;
	char* result = NULL;
	self = (ValaNamespace*) base;
	if (vala_collection_get_size ((ValaCollection*) self->priv->cprefixes) > 0) {
		result = (char*) vala_list_get (self->priv->cprefixes, 0);
		return result;
	} else {
		if (NULL != vala_symbol_get_name ((ValaSymbol*) self)) {
			char* parent_prefix;
			parent_prefix = NULL;
			if (vala_symbol_get_parent_symbol ((ValaSymbol*) self) == NULL) {
				char* _tmp0_;
				parent_prefix = (_tmp0_ = g_strdup (""), _g_free0 (parent_prefix), _tmp0_);
			} else {
				char* _tmp1_;
				parent_prefix = (_tmp1_ = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), _g_free0 (parent_prefix), _tmp1_);
			}
			result = g_strconcat (parent_prefix, vala_symbol_get_name ((ValaSymbol*) self), NULL);
			_g_free0 (parent_prefix);
			return result;
		} else {
			result = g_strdup ("");
			return result;
		}
	}
}


ValaList* vala_namespace_get_cprefixes (ValaNamespace* self) {
	ValaList* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	if (0 == vala_collection_get_size ((ValaCollection*) self->priv->cprefixes)) {
		_tmp0_ = NULL != vala_symbol_get_name ((ValaSymbol*) self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_collection_add ((ValaCollection*) self->priv->cprefixes, vala_symbol_get_name ((ValaSymbol*) self));
	}
	result = _vala_collection_object_ref0 (self->priv->cprefixes);
	return result;
}


void vala_namespace_add_cprefix (ValaNamespace* self, const char* cprefix) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cprefix != NULL);
	vala_collection_add ((ValaCollection*) self->priv->cprefixes, cprefix);
}


static char* vala_namespace_real_get_lower_case_cprefix (ValaSymbol* base) {
	ValaNamespace * self;
	char* result = NULL;
	self = (ValaNamespace*) base;
	if (self->priv->lower_case_cprefix == NULL) {
		if (vala_symbol_get_name ((ValaSymbol*) self) == NULL) {
			char* _tmp0_;
			self->priv->lower_case_cprefix = (_tmp0_ = g_strdup (""), _g_free0 (self->priv->lower_case_cprefix), _tmp0_);
		} else {
			char* parent_prefix;
			char* _tmp4_;
			char* _tmp3_;
			parent_prefix = NULL;
			if (vala_symbol_get_parent_symbol ((ValaSymbol*) self) == NULL) {
				char* _tmp1_;
				parent_prefix = (_tmp1_ = g_strdup (""), _g_free0 (parent_prefix), _tmp1_);
			} else {
				char* _tmp2_;
				parent_prefix = (_tmp2_ = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), _g_free0 (parent_prefix), _tmp2_);
			}
			self->priv->lower_case_cprefix = (_tmp4_ = g_strdup_printf ("%s%s_", parent_prefix, _tmp3_ = vala_symbol_camel_case_to_lower_case (vala_symbol_get_name ((ValaSymbol*) self))), _g_free0 (self->priv->lower_case_cprefix), _tmp4_);
			_g_free0 (_tmp3_);
			_g_free0 (parent_prefix);
		}
	}
	result = g_strdup (self->priv->lower_case_cprefix);
	return result;
}


void vala_namespace_set_lower_case_cprefix (ValaNamespace* self, const char* cprefix) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cprefix != NULL);
	self->priv->lower_case_cprefix = (_tmp0_ = g_strdup (cprefix), _g_free0 (self->priv->lower_case_cprefix), _tmp0_);
}


static ValaList* vala_namespace_real_get_cheader_filenames (ValaSymbol* base) {
	ValaNamespace * self;
	ValaList* result = NULL;
	self = (ValaNamespace*) base;
	result = _vala_collection_object_ref0 (self->priv->cheader_filenames);
	return result;
}


void vala_namespace_set_cheader_filename (ValaNamespace* self, const char* cheader_filename) {
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cheader_filename != NULL);
	self->priv->cheader_filenames = (_tmp0_ = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal), _vala_collection_object_unref0 (self->priv->cheader_filenames), _tmp0_);
	vala_collection_add ((ValaCollection*) self->priv->cheader_filenames, cheader_filename);
}


void vala_namespace_add_cheader_filename (ValaNamespace* self, const char* cheader_filename) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cheader_filename != NULL);
	vala_collection_add ((ValaCollection*) self->priv->cheader_filenames, cheader_filename);
}


static void vala_namespace_process_ccode_attribute (ValaNamespace* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	if (vala_attribute_has_argument (a, "cprefix")) {
		char* value;
		value = vala_attribute_get_string (a, "cprefix");
		if (_vala_strcmp0 (value, "") == 0) {
			vala_namespace_add_cprefix (self, "");
		} else {
			{
				char** _tmp0_;
				char** name_collection;
				int name_collection_length1;
				int name_it;
				name_collection = _tmp0_ = g_strsplit (value, ",", 0);
				name_collection_length1 = _vala_array_length (_tmp0_);
				for (name_it = 0; name_it < _vala_array_length (_tmp0_); name_it = name_it + 1) {
					char* name;
					name = g_strdup (name_collection[name_it]);
					{
						vala_namespace_add_cprefix (self, name);
						_g_free0 (name);
					}
				}
				name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		_g_free0 (value);
	}
	if (vala_attribute_has_argument (a, "lower_case_cprefix")) {
		char* _tmp1_;
		vala_namespace_set_lower_case_cprefix (self, _tmp1_ = vala_attribute_get_string (a, "lower_case_cprefix"));
		_g_free0 (_tmp1_);
	}
	if (vala_attribute_has_argument (a, "cheader_filename")) {
		char* val;
		val = vala_attribute_get_string (a, "cheader_filename");
		{
			char** _tmp2_;
			char** filename_collection;
			int filename_collection_length1;
			int filename_it;
			filename_collection = _tmp2_ = g_strsplit (val, ",", 0);
			filename_collection_length1 = _vala_array_length (_tmp2_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp2_); filename_it = filename_it + 1) {
				char* filename;
				filename = g_strdup (filename_collection[filename_it]);
				{
					vala_collection_add ((ValaCollection*) self->priv->cheader_filenames, filename);
					_g_free0 (filename);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (val);
	}
	if (vala_attribute_has_argument (a, "gir_namespace")) {
		char* _tmp3_;
		vala_source_file_set_gir_namespace (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)), _tmp3_ = vala_attribute_get_string (a, "gir_namespace"));
		_g_free0 (_tmp3_);
	}
	if (vala_attribute_has_argument (a, "gir_version")) {
		char* _tmp4_;
		vala_source_file_set_gir_version (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)), _tmp4_ = vala_attribute_get_string (a, "gir_version"));
		_g_free0 (_tmp4_);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_namespace_process_attributes (ValaNamespace* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* a;
			a = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			{
				if (_vala_strcmp0 (vala_attribute_get_name (a), "CCode") == 0) {
					vala_namespace_process_ccode_attribute (self, a);
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


static gboolean vala_namespace_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaNamespace * self;
	gboolean result = FALSE;
	self = (ValaNamespace*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		result = !vala_code_node_get_error ((ValaCodeNode*) self);
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_namespace_process_attributes (self);
	{
		ValaIterator* _ns_it;
		_ns_it = vala_iterable_iterator ((ValaIterable*) self->priv->namespaces);
		while (TRUE) {
			ValaNamespace* ns;
			if (!vala_iterator_next (_ns_it)) {
				break;
			}
			ns = (ValaNamespace*) vala_iterator_get (_ns_it);
			vala_code_node_check ((ValaCodeNode*) ns, analyzer);
			_vala_code_node_unref0 (ns);
		}
		_vala_collection_object_unref0 (_ns_it);
	}
	result = !vala_code_node_get_error ((ValaCodeNode*) self);
	return result;
}


static void vala_namespace_class_init (ValaNamespaceClass * klass) {
	vala_namespace_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_namespace_finalize;
	g_type_class_add_private (klass, sizeof (ValaNamespacePrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_namespace_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_namespace_real_accept_children;
	VALA_SYMBOL_CLASS (klass)->get_cprefix = vala_namespace_real_get_cprefix;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cprefix = vala_namespace_real_get_lower_case_cprefix;
	VALA_SYMBOL_CLASS (klass)->get_cheader_filenames = vala_namespace_real_get_cheader_filenames;
	VALA_CODE_NODE_CLASS (klass)->check = vala_namespace_real_check;
}


static void vala_namespace_instance_init (ValaNamespace * self) {
	self->priv = VALA_NAMESPACE_GET_PRIVATE (self);
	self->priv->classes = (ValaList*) vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->interfaces = (ValaList*) vala_array_list_new (VALA_TYPE_INTERFACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->structs = (ValaList*) vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->enums = (ValaList*) vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->error_domains = (ValaList*) vala_array_list_new (VALA_TYPE_ERROR_DOMAIN, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->delegates = (ValaList*) vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->constants = (ValaList*) vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->fields = (ValaList*) vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->methods = (ValaList*) vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->comments = (ValaList*) vala_array_list_new (VALA_TYPE_COMMENT, (GBoxedCopyFunc) vala_comment_ref, vala_comment_unref, g_direct_equal);
	self->priv->cprefixes = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	self->priv->cheader_filenames = (ValaList*) vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	self->priv->namespaces = (ValaList*) vala_array_list_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->using_directives = (ValaList*) vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_namespace_finalize (ValaCodeNode* obj) {
	ValaNamespace * self;
	self = VALA_NAMESPACE (obj);
	_vala_collection_object_unref0 (self->priv->classes);
	_vala_collection_object_unref0 (self->priv->interfaces);
	_vala_collection_object_unref0 (self->priv->structs);
	_vala_collection_object_unref0 (self->priv->enums);
	_vala_collection_object_unref0 (self->priv->error_domains);
	_vala_collection_object_unref0 (self->priv->delegates);
	_vala_collection_object_unref0 (self->priv->constants);
	_vala_collection_object_unref0 (self->priv->fields);
	_vala_collection_object_unref0 (self->priv->methods);
	_vala_collection_object_unref0 (self->priv->comments);
	_vala_collection_object_unref0 (self->priv->cprefixes);
	_g_free0 (self->priv->lower_case_cprefix);
	_vala_collection_object_unref0 (self->priv->cheader_filenames);
	_vala_collection_object_unref0 (self->priv->namespaces);
	_vala_collection_object_unref0 (self->priv->using_directives);
	VALA_CODE_NODE_CLASS (vala_namespace_parent_class)->finalize (obj);
}


GType vala_namespace_get_type (void) {
	static volatile gsize vala_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&vala_namespace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaNamespaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_namespace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNamespace), 0, (GInstanceInitFunc) vala_namespace_instance_init, NULL };
		GType vala_namespace_type_id;
		vala_namespace_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaNamespace", &g_define_type_info, 0);
		g_once_init_leave (&vala_namespace_type_id__volatile, vala_namespace_type_id);
	}
	return vala_namespace_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




