/* valascope.c generated by valac, the Vala compiler
 * generated from valascope.vala, do not modify */

/* valascope.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;
typedef struct _ValaScopePrivate ValaScopePrivate;

#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValaParamSpecScope ValaParamSpecScope;

struct _ValaScope {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaScopePrivate * priv;
};

struct _ValaScopeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaScope *self);
};

struct _ValaScopePrivate {
	ValaSymbol* _owner;
	ValaScope* _parent_scope;
	ValaMap* symbol_table;
	ValaList* anonymous_members;
};

struct _ValaParamSpecScope {
	GParamSpec parent_instance;
};


static gpointer vala_scope_parent_class = NULL;

gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
void vala_value_take_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void) G_GNUC_CONST;
gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
#define VALA_SCOPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SCOPE, ValaScopePrivate))
enum  {
	VALA_SCOPE_DUMMY_PROPERTY
};
void vala_scope_set_owner (ValaScope* self, ValaSymbol* value);
ValaScope* vala_scope_new (ValaSymbol* owner);
ValaScope* vala_scope_construct (GType object_type, ValaSymbol* owner);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
ValaSymbol* vala_scope_get_owner (ValaScope* self);
const char* vala_symbol_get_name (ValaSymbol* self);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const char* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
char* vala_symbol_get_full_name (ValaSymbol* self);
void vala_report_notice (ValaSourceReference* source, const char* message);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym);
void vala_scope_remove (ValaScope* self, const char* name);
gboolean vala_symbol_get_active (ValaSymbol* self);
ValaScope* vala_scope_get_parent_scope (ValaScope* self);
gboolean vala_scope_is_subscope_of (ValaScope* self, ValaScope* scope);
ValaMap* vala_scope_get_symbol_table (ValaScope* self);
void vala_scope_set_parent_scope (ValaScope* self, ValaScope* value);
static void vala_scope_finalize (ValaScope* obj);



ValaScope* vala_scope_construct (GType object_type, ValaSymbol* owner) {
	ValaScope* self;
	self = (ValaScope*) g_type_create_instance (object_type);
	vala_scope_set_owner (self, owner);
	return self;
}


ValaScope* vala_scope_new (ValaSymbol* owner) {
	return vala_scope_construct (VALA_TYPE_SCOPE, owner);
}


void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	if (name != NULL) {
		if (self->priv->symbol_table == NULL) {
			ValaMap* _tmp0_;
			self->priv->symbol_table = (_tmp0_ = (ValaMap*) vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_str_hash, g_str_equal, g_direct_equal), _vala_collection_object_unref0 (self->priv->symbol_table), _tmp0_);
		} else {
			ValaSymbol* _tmp1_;
			gboolean _tmp2_;
			if ((_tmp2_ = (_tmp1_ = vala_scope_lookup (self, name)) != NULL, _vala_code_node_unref0 (_tmp1_), _tmp2_)) {
				gboolean _tmp3_ = FALSE;
				char* _tmp8_;
				ValaSymbol* _tmp7_;
				vala_code_node_set_error ((ValaCodeNode*) self->priv->_owner, TRUE);
				if (vala_symbol_get_name (self->priv->_owner) == NULL) {
					_tmp3_ = vala_symbol_get_parent_symbol (self->priv->_owner) == NULL;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					char* _tmp4_;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) sym), _tmp4_ = g_strdup_printf ("The root namespace already contains a definition for `%s'", name));
					_g_free0 (_tmp4_);
				} else {
					char* _tmp6_;
					char* _tmp5_;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) sym), _tmp6_ = g_strdup_printf ("`%s' already contains a definition for `%s'", _tmp5_ = vala_symbol_get_full_name (self->priv->_owner), name));
					_g_free0 (_tmp6_);
					_g_free0 (_tmp5_);
				}
				vala_report_notice (vala_code_node_get_source_reference ((ValaCodeNode*) (_tmp7_ = vala_scope_lookup (self, name))), _tmp8_ = g_strdup_printf ("previous definition of `%s' was here", name));
				_g_free0 (_tmp8_);
				_vala_code_node_unref0 (_tmp7_);
				return;
			}
		}
		vala_map_set (self->priv->symbol_table, (const char*) name, sym);
	} else {
		if (self->priv->anonymous_members == NULL) {
			ValaList* _tmp9_;
			self->priv->anonymous_members = (_tmp9_ = (ValaList*) vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), _vala_collection_object_unref0 (self->priv->anonymous_members), _tmp9_);
		}
		vala_collection_add ((ValaCollection*) self->priv->anonymous_members, sym);
	}
	vala_symbol_set_owner (sym, self);
}


void vala_scope_remove (ValaScope* self, const char* name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	vala_map_remove (self->priv->symbol_table, name);
}


ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name) {
	ValaSymbol* result = NULL;
	ValaSymbol* sym;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (self->priv->symbol_table == NULL) {
		result = NULL;
		return result;
	}
	sym = (ValaSymbol*) vala_map_get (self->priv->symbol_table, name);
	if (sym != NULL) {
		_tmp0_ = !vala_symbol_get_active (sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaSymbol* _tmp1_;
		sym = (_tmp1_ = NULL, _vala_code_node_unref0 (sym), _tmp1_);
	}
	result = sym;
	return result;
}


gboolean vala_scope_is_subscope_of (ValaScope* self, ValaScope* scope) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (scope == self) {
		result = TRUE;
		return result;
	}
	if (scope == NULL) {
		result = TRUE;
		return result;
	}
	if (self->priv->_parent_scope != NULL) {
		result = vala_scope_is_subscope_of (self->priv->_parent_scope, scope);
		return result;
	}
	result = FALSE;
	return result;
}


static gpointer _vala_collection_object_ref0 (gpointer self) {
	return self ? vala_collection_object_ref (self) : NULL;
}


ValaMap* vala_scope_get_symbol_table (ValaScope* self) {
	ValaMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->symbol_table);
	return result;
}


ValaSymbol* vala_scope_get_owner (ValaScope* self) {
	ValaSymbol* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_owner;
	return result;
}


void vala_scope_set_owner (ValaScope* self, ValaSymbol* value) {
	g_return_if_fail (self != NULL);
	self->priv->_owner = value;
}


ValaScope* vala_scope_get_parent_scope (ValaScope* self) {
	ValaScope* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_parent_scope;
	return result;
}


void vala_scope_set_parent_scope (ValaScope* self, ValaScope* value) {
	g_return_if_fail (self != NULL);
	self->priv->_parent_scope = value;
}


static void vala_value_scope_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_scope_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_scope_unref (value->data[0].v_pointer);
	}
}


static void vala_value_scope_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_scope_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_scope_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_scope_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaScope* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_scope_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_scope_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaScope** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_scope_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecScope* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SCOPE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_scope (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCOPE), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_scope (GValue* value, gpointer v_object) {
	ValaScope* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCOPE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCOPE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_scope_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scope_unref (old);
	}
}


void vala_value_take_scope (GValue* value, gpointer v_object) {
	ValaScope* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCOPE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCOPE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scope_unref (old);
	}
}


static void vala_scope_class_init (ValaScopeClass * klass) {
	vala_scope_parent_class = g_type_class_peek_parent (klass);
	VALA_SCOPE_CLASS (klass)->finalize = vala_scope_finalize;
	g_type_class_add_private (klass, sizeof (ValaScopePrivate));
}


static void vala_scope_instance_init (ValaScope * self) {
	self->priv = VALA_SCOPE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_scope_finalize (ValaScope* obj) {
	ValaScope * self;
	self = VALA_SCOPE (obj);
	_vala_collection_object_unref0 (self->priv->symbol_table);
	_vala_collection_object_unref0 (self->priv->anonymous_members);
}


GType vala_scope_get_type (void) {
	static volatile gsize vala_scope_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scope_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_scope_init, vala_value_scope_free_value, vala_value_scope_copy_value, vala_value_scope_peek_pointer, "p", vala_value_scope_collect_value, "p", vala_value_scope_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaScopeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_scope_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaScope), 0, (GInstanceInitFunc) vala_scope_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_scope_type_id;
		vala_scope_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaScope", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_scope_type_id__volatile, vala_scope_type_id);
	}
	return vala_scope_type_id__volatile;
}


gpointer vala_scope_ref (gpointer instance) {
	ValaScope* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_scope_unref (gpointer instance) {
	ValaScope* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SCOPE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




