/* app.c generated by valac 0.28.1, the Vala compiler
 * generated from app.vala, do not modify */

/*
 * Copyright © 2001,2002 Red Hat, Inc.
 * Copyright © 2014 Christian Persch
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "vte/vte.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <sys/types.h>
#include <unistd.h>
#include "config.h"


#define TEST_TYPE_WINDOW (test_window_get_type ())
#define TEST_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TEST_TYPE_WINDOW, TestWindow))
#define TEST_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TEST_TYPE_WINDOW, TestWindowClass))
#define TEST_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TEST_TYPE_WINDOW))
#define TEST_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TEST_TYPE_WINDOW))
#define TEST_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TEST_TYPE_WINDOW, TestWindowClass))

typedef struct _TestWindow TestWindow;
typedef struct _TestWindowClass TestWindowClass;
typedef struct _TestWindowPrivate TestWindowPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TEST_TYPE_APP (test_app_get_type ())
#define TEST_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TEST_TYPE_APP, TestApp))
#define TEST_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TEST_TYPE_APP, TestAppClass))
#define TEST_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TEST_TYPE_APP))
#define TEST_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TEST_TYPE_APP))
#define TEST_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TEST_TYPE_APP, TestAppClass))

typedef struct _TestApp TestApp;
typedef struct _TestAppClass TestAppClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _TestAppPrivate TestAppPrivate;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

#define TEST_APP_TYPE_OPTIONS (test_app_options_get_type ())
typedef struct _TestAppOptions TestAppOptions;
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TestWindow {
	GtkApplicationWindow parent_instance;
	TestWindowPrivate * priv;
};

struct _TestWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _TestWindowPrivate {
	VteTerminal* terminal;
	GtkScrollbar* scrollbar;
	GtkClipboard* clipboard;
	GPid child_pid;
	gchar** builtin_dingus;
	gint builtin_dingus_length1;
	gint _builtin_dingus_size_;
};

struct _TestApp {
	GtkApplication parent_instance;
	TestAppPrivate * priv;
};

struct _TestAppClass {
	GtkApplicationClass parent_class;
};

struct _TestAppPrivate {
	TestWindow* window;
};

struct _TestAppOptions {
};


static gpointer test_window_parent_class = NULL;
extern gint test_app_options_transparency_percent;
extern gboolean test_app_options_no_argb_visual;
extern gboolean test_app_options_no_toolbar;
extern gboolean test_app_options_object_notifications;
extern gboolean test_app_options_no_double_buffer;
extern gchar* test_app_options_encoding;
extern gchar* test_app_options_word_char_exceptions;
extern gboolean test_app_options_audible;
extern gboolean test_app_options_no_rewrap;
extern gint test_app_options_scrollback_lines;
extern gchar* test_app_options_font_string;
extern gboolean test_app_options_no_builtin_dingus;
extern gchar** test_app_options_dingus;
extern gint test_app_options_dingus_length1;
extern gchar* test_app_options_geometry;
extern gchar* test_app_options_working_directory;
extern gchar** test_app_options_environment;
extern gint test_app_options_environment_length1;
extern gchar* test_app_options_command;
extern gboolean test_app_options_no_shell;
extern gboolean test_app_options_no_geometry_hints;
extern gboolean test_app_options_no_context_menu;
extern gchar* test_app_options_output_filename;
extern gboolean test_app_options_keep;
static gpointer test_app_parent_class = NULL;
extern gchar* test_app_options_cjk_ambiguous_width_string;
extern gchar* test_app_options_cursor_blink_mode_string;
extern gchar* test_app_options_cursor_color_string;
extern gchar* test_app_options_cursor_shape_string;
extern gboolean test_app_options_debug;
extern gchar* test_app_options_hl_bg_color_string;
extern gchar* test_app_options_hl_fg_color_string;
extern gchar* test_app_options_icon_title;
extern gchar* test_app_options_pty_flags_string;
extern gboolean test_app_options_reverse;
extern gboolean test_app_options_version;
gboolean test_app_options_audible = FALSE;
gchar* test_app_options_command = NULL;
gchar* test_app_options_cjk_ambiguous_width_string = NULL;
gchar* test_app_options_cursor_blink_mode_string = NULL;
gchar* test_app_options_cursor_color_string = NULL;
gchar* test_app_options_cursor_shape_string = NULL;
gchar** test_app_options_dingus = NULL;
gint test_app_options_dingus_length1 = 0;
static gint _test_app_options_dingus_size_ = 0;
gboolean test_app_options_debug = FALSE;
gchar* test_app_options_encoding = NULL;
gchar** test_app_options_environment = NULL;
gint test_app_options_environment_length1 = 0;
static gint _test_app_options_environment_size_ = 0;
gchar* test_app_options_font_string = NULL;
gchar* test_app_options_geometry = NULL;
gchar* test_app_options_hl_bg_color_string = NULL;
gchar* test_app_options_hl_fg_color_string = NULL;
gchar* test_app_options_icon_title = NULL;
gboolean test_app_options_keep = FALSE;
gboolean test_app_options_no_argb_visual = FALSE;
gboolean test_app_options_no_builtin_dingus = FALSE;
gboolean test_app_options_no_context_menu = FALSE;
gboolean test_app_options_no_double_buffer = FALSE;
gboolean test_app_options_no_geometry_hints = FALSE;
gboolean test_app_options_no_rewrap = FALSE;
gboolean test_app_options_no_shell = FALSE;
gboolean test_app_options_no_toolbar = FALSE;
gboolean test_app_options_object_notifications = FALSE;
gchar* test_app_options_output_filename = NULL;
gchar* test_app_options_pty_flags_string = NULL;
gboolean test_app_options_reverse = FALSE;
gint test_app_options_scrollback_lines = 512;
gint test_app_options_transparency_percent = 0;
gboolean test_app_options_version = FALSE;
gchar* test_app_options_word_char_exceptions = NULL;
gchar* test_app_options_working_directory = NULL;

GType test_window_get_type (void) G_GNUC_CONST;
#define TEST_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TEST_TYPE_WINDOW, TestWindowPrivate))
enum  {
	TEST_WINDOW_DUMMY_PROPERTY
};
static void test_window_action_copy_cb (TestWindow* self);
static void _test_window_action_copy_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void test_window_action_copy_match_cb (TestWindow* self, GSimpleAction* action, GVariant* parameter);
static void _test_window_action_copy_match_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void test_window_action_paste_cb (TestWindow* self);
static void _test_window_action_paste_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void test_window_action_reset_cb (TestWindow* self);
static void _test_window_action_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
GType test_app_get_type (void) G_GNUC_CONST;
TestWindow* test_window_new (TestApp* app);
TestWindow* test_window_construct (GType object_type, TestApp* app);
static void test_window_clipboard_owner_change_cb (TestWindow* self, GtkClipboard* clipboard, GdkEvent* event);
static void _test_window_clipboard_owner_change_cb_gtk_clipboard_owner_change (GtkClipboard* _sender, GdkEvent* p0, gpointer self);
static gboolean test_window_button_press_event_cb (TestWindow* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _test_window_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void test_window_char_size_changed_cb (TestWindow* self, VteTerminal* terminal, guint width, guint height);
static void _test_window_char_size_changed_cb_vte_terminal_char_size_changed (VteTerminal* _sender, guint char_width, guint char_height, gpointer self);
static void test_window_child_exited_cb (TestWindow* self, VteTerminal* terminal, gint status);
static void _test_window_child_exited_cb_vte_terminal_child_exited (VteTerminal* _sender, gint status, gpointer self);
static void test_window_decrease_font_size_cb (TestWindow* self, VteTerminal* terminal);
static void _test_window_decrease_font_size_cb_vte_terminal_decrease_font_size (VteTerminal* _sender, gpointer self);
void test_window_deiconify_window_cb (TestWindow* self, VteTerminal* terminal);
static void _test_window_deiconify_window_cb_vte_terminal_deiconify_window (VteTerminal* _sender, gpointer self);
static void test_window_icon_title_changed_cb (TestWindow* self, VteTerminal* terminal);
static void _test_window_icon_title_changed_cb_vte_terminal_icon_title_changed (VteTerminal* _sender, gpointer self);
static void test_window_iconify_window_cb (TestWindow* self, VteTerminal* terminal);
static void _test_window_iconify_window_cb_vte_terminal_iconify_window (VteTerminal* _sender, gpointer self);
static void test_window_increase_font_size_cb (TestWindow* self, VteTerminal* terminal);
static void _test_window_increase_font_size_cb_vte_terminal_increase_font_size (VteTerminal* _sender, gpointer self);
static void test_window_lower_window_cb (TestWindow* self, VteTerminal* terminal);
static void _test_window_lower_window_cb_vte_terminal_lower_window (VteTerminal* _sender, gpointer self);
static void test_window_maximize_window_cb (TestWindow* self, VteTerminal* terminal);
static void _test_window_maximize_window_cb_vte_terminal_maximize_window (VteTerminal* _sender, gpointer self);
static void test_window_move_window_cb (TestWindow* self, VteTerminal* terminal, guint x, guint y);
static void _test_window_move_window_cb_vte_terminal_move_window (VteTerminal* _sender, guint x, guint y, gpointer self);
static void test_window_raise_window_cb (TestWindow* self, VteTerminal* terminal);
static void _test_window_raise_window_cb_vte_terminal_raise_window (VteTerminal* _sender, gpointer self);
static void test_window_realize_cb (TestWindow* self, GtkWidget* widget);
static void _test_window_realize_cb_gtk_widget_realize (GtkWidget* _sender, gpointer self);
static void test_window_refresh_window_cb (TestWindow* self, VteTerminal* terminal);
static void _test_window_refresh_window_cb_vte_terminal_refresh_window (VteTerminal* _sender, gpointer self);
static void test_window_resize_window_cb (TestWindow* self, VteTerminal* terminal, guint columns, guint rows);
static void _test_window_resize_window_cb_vte_terminal_resize_window (VteTerminal* _sender, guint width, guint height, gpointer self);
static void test_window_restore_window_cb (TestWindow* self, VteTerminal* terminal);
static void _test_window_restore_window_cb_vte_terminal_restore_window (VteTerminal* _sender, gpointer self);
static void test_window_selection_changed_cb (TestWindow* self, VteTerminal* terminal);
static void _test_window_selection_changed_cb_vte_terminal_selection_changed (VteTerminal* _sender, gpointer self);
static void test_window_window_title_changed_cb (TestWindow* self, VteTerminal* terminal);
static void _test_window_window_title_changed_cb_vte_terminal_window_title_changed (VteTerminal* _sender, gpointer self);
static void test_window_notify_cb (TestWindow* self, GObject* object, GParamSpec* pspec);
static void _test_window_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gint test_app_options_get_cjk_ambiguous_width (void);
VteCursorBlinkMode test_app_options_get_cursor_blink_mode (void);
VteCursorShape test_app_options_get_cursor_shape (void);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
void test_app_options_get_color_fg (GdkRGBA* result);
void test_app_options_get_color_bg (GdkRGBA* result);
GdkRGBA* test_app_options_get_color_cursor (void);
GdkRGBA* test_app_options_get_color_hl_bg (void);
GdkRGBA* test_app_options_get_color_hl_fg (void);
static void test_window_add_dingus (TestWindow* self, gchar** dingus, int dingus_length1);
static void test_window_update_paste_sensitivity (TestWindow* self);
static void test_window_update_copy_sensitivity (TestWindow* self);
static void test_window_adjust_font_size (TestWindow* self, gdouble factor);
static void test_window_update_geometry (TestWindow* self);
void test_window_apply_geometry (TestWindow* self);
static void test_window_launch_command (TestWindow* self, const gchar* command, GError** error);
VtePtyFlags test_app_options_get_pty_flags (void);
static void test_window_launch_shell (TestWindow* self, GError** error);
static void test_window_fork (TestWindow* self, GError** error);
void test_window_launch (TestWindow* self);
static void test_window_finalize (GObject* obj);
#define TEST_APP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TEST_TYPE_APP, TestAppPrivate))
enum  {
	TEST_APP_DUMMY_PROPERTY
};
TestApp* test_app_new (void);
TestApp* test_app_construct (GType object_type);
static void test_app_real_startup (GApplication* base);
static void test_app_real_activate (GApplication* base);
gint test_app_main (gchar** argv, int argv_length1);
GType test_app_options_get_type (void) G_GNUC_CONST;
TestAppOptions* test_app_options_dup (const TestAppOptions* self);
void test_app_options_free (TestAppOptions* self);
static gint test_app_options_parse_enum (GType type, const gchar* str);
static guint test_app_options_parse_flags (GType type, const gchar* str);
static GdkRGBA* test_app_options_get_color (const gchar* str);
static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self);
static void test_app_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry TEST_WINDOW_action_entries[4] = {{"copy", _test_window_action_copy_cb_gsimple_action_activate_callback}, {"copy-match", _test_window_action_copy_match_cb_gsimple_action_activate_callback, "s"}, {"paste", _test_window_action_paste_cb_gsimple_action_activate_callback}, {"reset", _test_window_action_reset_cb_gsimple_action_activate_callback}};
const GOptionEntry TEST_APP_OPTIONS_entries[34] = {{"audible-bell", 'a', 0, G_OPTION_ARG_NONE, &test_app_options_audible, "Use audible terminal bell", NULL}, {"command", 'c', 0, G_OPTION_ARG_STRING, &test_app_options_command, "Execute a command in the terminal", NULL}, {"cjk-width", (gchar) 0, 0, G_OPTION_ARG_STRING, &test_app_options_cjk_ambiguous_width_string, "Specify the cjk ambiguous width to use for UTF-8 encoding", "NARROW|WIDE"}, {"cursor-blink", (gchar) 0, 0, G_OPTION_ARG_STRING, &test_app_options_cursor_blink_mode_string, "Cursor blink mode (system|on|off)", "MODE"}, {"cursor-color", (gchar) 0, 0, G_OPTION_ARG_STRING, &test_app_options_cursor_color_string, "Enable a colored cursor", NULL}, {"cursor-shape", (gchar) 0, 0, G_OPTION_ARG_STRING, &test_app_options_cursor_shape_string, "Set cursor shape (block|underline|ibeam)", NULL}, {"dingu", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &test_app_options_dingus, "Add regex highlight", NULL}, {"debug", 'd', 0, G_OPTION_ARG_NONE, &test_app_options_debug, "Enable various debugging checks", NULL}, {"encoding", (gchar) 0, 0, G_OPTION_ARG_STRING, &test_app_options_encoding, "Specify the terminal encoding to use", NULL}, {"env", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &test_app_options_environment, "Add environment variable to the child\'s environment", "VAR=VALUE"}, {"font", 'f', 0, G_OPTION_ARG_STRING, &test_app_options_font_string, "Specify a font to use", NULL}, {"geometry", 'g', 0, G_OPTION_ARG_STRING, &test_app_options_geometry, "Set the size (in characters) and position", "GEOMETRY"}, {"highlight-background-color", (gchar) 0, 0, G_OPTION_ARG_STRING, &test_app_options_hl_bg_color_string, "Enable distinct highlight background color for selection", NULL}, {"highlight-foreground-color", (gchar) 0, 0, G_OPTION_ARG_STRING, &test_app_options_hl_fg_color_string, "Enable distinct highlight foreground color for selection", NULL}, {"icon-title", 'i', 0, G_OPTION_ARG_NONE, &test_app_options_icon_title, "Enable the setting of the icon title", NULL}, {"keep", 'k', 0, G_OPTION_ARG_NONE, &test_app_options_keep, "Live on after the command exits", NULL}, {"no-argb-visual", (gchar) 0, 0, G_OPTION_ARG_NONE, &test_app_options_no_argb_visual, "Don't use an ARGB visual", NULL}, {"no-builtin-dingus", (gchar) 0, 0, G_OPTION_ARG_NONE, &test_app_options_no_builtin_dingus, "Highlight URLs inside the terminal", NULL}, {"no-context-menu", (gchar) 0, 0, G_OPTION_ARG_NONE, &test_app_options_no_context_menu, "Disable context menu", NULL}, {"no-double-buffer", '2', 0, G_OPTION_ARG_NONE, &test_app_options_no_double_buffer, "Disable double-buffering", NULL}, {"no-geometry-hints", 'G', 0, G_OPTION_ARG_NONE, &test_app_options_no_geometry_hints, "Allow the terminal to be resized to any dimension, not constrained to " \
"fit to an integer multiple of characters", NULL}, {"no-rewrap", 'R', 0, G_OPTION_ARG_NONE, &test_app_options_no_rewrap, "Disable rewrapping on resize", NULL}, {"no-shell", 'S', 0, G_OPTION_ARG_NONE, &test_app_options_no_shell, "Disable spawning a shell inside the terminal", NULL}, {"no-toolbar", (gchar) 0, 0, G_OPTION_ARG_NONE, &test_app_options_no_toolbar, "Disable toolbar", NULL}, {"object-notifications", 'N', 0, G_OPTION_ARG_NONE, &test_app_options_object_notifications, "Print VteTerminal object notifications", NULL}, {"output-file", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &test_app_options_output_filename, "Save terminal contents to file at exit", NULL}, {"pty-flags", (gchar) 0, 0, G_OPTION_ARG_STRING, &test_app_options_pty_flags_string, "PTY flags set from default|no-utmp|no-wtmp|no-lastlog|no-helper|no-fal" \
"lback", NULL}, {"reverse", (gchar) 0, 0, G_OPTION_ARG_NONE, &test_app_options_reverse, "Reverse foreground/background colors", NULL}, {"scrollback-lines", 'n', 0, G_OPTION_ARG_INT, &test_app_options_scrollback_lines, "Specify the number of scrollback-lines", NULL}, {"transparent", 'T', 0, G_OPTION_ARG_INT, &test_app_options_transparency_percent, "Enable the use of a transparent background", "0..100"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &test_app_options_version, "Show version", NULL}, {"word-char-exceptions", (gchar) 0, 0, G_OPTION_ARG_STRING, &test_app_options_word_char_exceptions, "Specify the word char exceptions", "CHARS"}, {"working-directory", 'w', 0, G_OPTION_ARG_FILENAME, &test_app_options_working_directory, "Specify the initial working directory of the terminal", NULL}, {NULL}};

static void _test_window_action_copy_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	test_window_action_copy_cb ((TestWindow*) self);
}


static void _test_window_action_copy_match_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	test_window_action_copy_match_cb ((TestWindow*) self, action, parameter);
}


static void _test_window_action_paste_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	test_window_action_paste_cb ((TestWindow*) self);
}


static void _test_window_action_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	test_window_action_reset_cb ((TestWindow*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _test_window_clipboard_owner_change_cb_gtk_clipboard_owner_change (GtkClipboard* _sender, GdkEvent* p0, gpointer self) {
	test_window_clipboard_owner_change_cb ((TestWindow*) self, _sender, p0);
}


static gboolean _test_window_button_press_event_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = test_window_button_press_event_cb ((TestWindow*) self, _sender, event);
	return result;
}


static void _test_window_char_size_changed_cb_vte_terminal_char_size_changed (VteTerminal* _sender, guint char_width, guint char_height, gpointer self) {
	test_window_char_size_changed_cb ((TestWindow*) self, _sender, char_width, char_height);
}


static void _test_window_child_exited_cb_vte_terminal_child_exited (VteTerminal* _sender, gint status, gpointer self) {
	test_window_child_exited_cb ((TestWindow*) self, _sender, status);
}


static void _test_window_decrease_font_size_cb_vte_terminal_decrease_font_size (VteTerminal* _sender, gpointer self) {
	test_window_decrease_font_size_cb ((TestWindow*) self, _sender);
}


static void _test_window_deiconify_window_cb_vte_terminal_deiconify_window (VteTerminal* _sender, gpointer self) {
	test_window_deiconify_window_cb ((TestWindow*) self, _sender);
}


static void _test_window_icon_title_changed_cb_vte_terminal_icon_title_changed (VteTerminal* _sender, gpointer self) {
	test_window_icon_title_changed_cb ((TestWindow*) self, _sender);
}


static void _test_window_iconify_window_cb_vte_terminal_iconify_window (VteTerminal* _sender, gpointer self) {
	test_window_iconify_window_cb ((TestWindow*) self, _sender);
}


static void _test_window_increase_font_size_cb_vte_terminal_increase_font_size (VteTerminal* _sender, gpointer self) {
	test_window_increase_font_size_cb ((TestWindow*) self, _sender);
}


static void _test_window_lower_window_cb_vte_terminal_lower_window (VteTerminal* _sender, gpointer self) {
	test_window_lower_window_cb ((TestWindow*) self, _sender);
}


static void _test_window_maximize_window_cb_vte_terminal_maximize_window (VteTerminal* _sender, gpointer self) {
	test_window_maximize_window_cb ((TestWindow*) self, _sender);
}


static void _test_window_move_window_cb_vte_terminal_move_window (VteTerminal* _sender, guint x, guint y, gpointer self) {
	test_window_move_window_cb ((TestWindow*) self, _sender, x, y);
}


static void _test_window_raise_window_cb_vte_terminal_raise_window (VteTerminal* _sender, gpointer self) {
	test_window_raise_window_cb ((TestWindow*) self, _sender);
}


static void _test_window_realize_cb_gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	test_window_realize_cb ((TestWindow*) self, _sender);
}


static void _test_window_refresh_window_cb_vte_terminal_refresh_window (VteTerminal* _sender, gpointer self) {
	test_window_refresh_window_cb ((TestWindow*) self, _sender);
}


static void _test_window_resize_window_cb_vte_terminal_resize_window (VteTerminal* _sender, guint width, guint height, gpointer self) {
	test_window_resize_window_cb ((TestWindow*) self, _sender, width, height);
}


static void _test_window_restore_window_cb_vte_terminal_restore_window (VteTerminal* _sender, gpointer self) {
	test_window_restore_window_cb ((TestWindow*) self, _sender);
}


static void _test_window_selection_changed_cb_vte_terminal_selection_changed (VteTerminal* _sender, gpointer self) {
	test_window_selection_changed_cb ((TestWindow*) self, _sender);
}


static void _test_window_window_title_changed_cb_vte_terminal_window_title_changed (VteTerminal* _sender, gpointer self) {
	test_window_window_title_changed_cb ((TestWindow*) self, _sender);
}


static void _test_window_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	test_window_notify_cb ((TestWindow*) self, _sender, pspec);
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


TestWindow* test_window_construct (GType object_type, TestApp* app) {
	TestWindow * self = NULL;
	TestApp* _tmp0_ = NULL;
	GtkClipboard* _tmp1_ = NULL;
	GtkClipboard* _tmp2_ = NULL;
	GtkClipboard* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GtkBuilder* ui = NULL;
	GtkBuilder* _tmp13_ = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GtkBox* box = NULL;
	GtkBuilder* _tmp16_ = NULL;
	GObject* _tmp17_ = NULL;
	GtkBox* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	VteTerminal* _tmp24_ = NULL;
	GtkBuilder* _tmp25_ = NULL;
	GObject* _tmp26_ = NULL;
	GtkScrollbar* _tmp27_ = NULL;
	GtkScrollbar* _tmp28_ = NULL;
	VteTerminal* _tmp29_ = NULL;
	GtkAdjustment* _tmp30_ = NULL;
	VteTerminal* _tmp31_ = NULL;
	VteTerminal* _tmp32_ = NULL;
	VteTerminal* _tmp33_ = NULL;
	VteTerminal* _tmp34_ = NULL;
	VteTerminal* _tmp35_ = NULL;
	VteTerminal* _tmp36_ = NULL;
	VteTerminal* _tmp37_ = NULL;
	VteTerminal* _tmp38_ = NULL;
	VteTerminal* _tmp39_ = NULL;
	VteTerminal* _tmp40_ = NULL;
	VteTerminal* _tmp41_ = NULL;
	VteTerminal* _tmp42_ = NULL;
	VteTerminal* _tmp43_ = NULL;
	VteTerminal* _tmp44_ = NULL;
	VteTerminal* _tmp45_ = NULL;
	VteTerminal* _tmp46_ = NULL;
	VteTerminal* _tmp47_ = NULL;
	VteTerminal* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp51_ = FALSE;
	const gchar* _tmp53_ = NULL;
	const gchar* _tmp58_ = NULL;
	VteTerminal* _tmp61_ = NULL;
	gboolean _tmp62_ = FALSE;
	VteTerminal* _tmp63_ = NULL;
	gint _tmp64_ = 0;
	VteTerminal* _tmp65_ = NULL;
	VteCursorBlinkMode _tmp66_ = 0;
	VteTerminal* _tmp67_ = NULL;
	VteCursorShape _tmp68_ = 0;
	VteTerminal* _tmp69_ = NULL;
	VteTerminal* _tmp70_ = NULL;
	gboolean _tmp71_ = FALSE;
	VteTerminal* _tmp72_ = NULL;
	VteTerminal* _tmp73_ = NULL;
	VteTerminal* _tmp74_ = NULL;
	gint _tmp75_ = 0;
	const gchar* _tmp76_ = NULL;
	VteTerminal* _tmp81_ = NULL;
	GdkRGBA _tmp82_ = {0};
	GdkRGBA _tmp83_ = {0};
	VteTerminal* _tmp84_ = NULL;
	GdkRGBA* _tmp85_ = NULL;
	GdkRGBA* _tmp86_ = NULL;
	VteTerminal* _tmp87_ = NULL;
	GdkRGBA* _tmp88_ = NULL;
	GdkRGBA* _tmp89_ = NULL;
	VteTerminal* _tmp90_ = NULL;
	GdkRGBA* _tmp91_ = NULL;
	GdkRGBA* _tmp92_ = NULL;
	gboolean _tmp93_ = FALSE;
	gchar** _tmp95_ = NULL;
	gint _tmp95__length1 = 0;
	VteTerminal* _tmp97_ = NULL;
	GPropertyAction* _tmp98_ = NULL;
	GPropertyAction* _tmp99_ = NULL;
	GtkBox* _tmp100_ = NULL;
	VteTerminal* _tmp101_ = NULL;
	VteTerminal* _tmp102_ = NULL;
	VteTerminal* _tmp103_ = NULL;
	gboolean _tmp104_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	_tmp0_ = app;
	self = (TestWindow*) g_object_new (object_type, "application", _tmp0_, NULL);
	g_action_map_add_action_entries ((GActionMap*) self, TEST_WINDOW_action_entries, G_N_ELEMENTS (TEST_WINDOW_action_entries), self);
	_tmp1_ = gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->clipboard);
	self->priv->clipboard = _tmp2_;
	_tmp3_ = self->priv->clipboard;
	g_signal_connect_object (_tmp3_, "owner-change", (GCallback) _test_window_clipboard_owner_change_cb_gtk_clipboard_owner_change, self, 0);
	gtk_window_set_title ((GtkWindow*) self, "Terminal");
	_tmp4_ = test_app_options_transparency_percent;
	if (_tmp4_ != 0) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = test_app_options_no_argb_visual;
		if (!_tmp5_) {
			GdkScreen* screen = NULL;
			GdkScreen* _tmp6_ = NULL;
			GdkScreen* _tmp7_ = NULL;
			GdkVisual* visual = NULL;
			GdkScreen* _tmp8_ = NULL;
			GdkVisual* _tmp9_ = NULL;
			GdkVisual* _tmp10_ = NULL;
			GdkVisual* _tmp11_ = NULL;
			_tmp6_ = gtk_window_get_screen ((GtkWindow*) self);
			_tmp7_ = _g_object_ref0 (_tmp6_);
			screen = _tmp7_;
			_tmp8_ = screen;
			_tmp9_ = gdk_screen_get_rgba_visual (_tmp8_);
			_tmp10_ = _g_object_ref0 (_tmp9_);
			visual = _tmp10_;
			_tmp11_ = visual;
			if (_tmp11_ != NULL) {
				GdkVisual* _tmp12_ = NULL;
				_tmp12_ = visual;
				gtk_widget_set_visual ((GtkWidget*) self, _tmp12_);
			}
			_g_object_unref0 (visual);
			_g_object_unref0 (screen);
		}
		gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	}
	_tmp13_ = gtk_builder_new_from_resource ("/org/gnome/vte/test/app/ui/window.ui");
	ui = _tmp13_;
	_tmp14_ = ui;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "main-box");
	gtk_container_add ((GtkContainer*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp15_) : NULL);
	_tmp16_ = ui;
	_tmp17_ = gtk_builder_get_object (_tmp16_, "terminal-box");
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, gtk_box_get_type ()) ? ((GtkBox*) _tmp17_) : NULL);
	box = _tmp18_;
	_tmp19_ = test_app_options_no_toolbar;
	if (_tmp19_) {
		GtkWidget* toolbar = NULL;
		GtkBuilder* _tmp20_ = NULL;
		GObject* _tmp21_ = NULL;
		GtkWidget* _tmp22_ = NULL;
		GtkWidget* _tmp23_ = NULL;
		_tmp20_ = ui;
		_tmp21_ = gtk_builder_get_object (_tmp20_, "toolbar");
		_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp21_) : NULL);
		toolbar = _tmp22_;
		_tmp23_ = toolbar;
		gtk_widget_hide (_tmp23_);
		_g_object_unref0 (toolbar);
	}
	_tmp24_ = (VteTerminal*) vte_terminal_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->terminal);
	self->priv->terminal = _tmp24_;
	_tmp25_ = ui;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "scrollbar");
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, gtk_scrollbar_get_type ()) ? ((GtkScrollbar*) _tmp26_) : NULL);
	_g_object_unref0 (self->priv->scrollbar);
	self->priv->scrollbar = _tmp27_;
	_tmp28_ = self->priv->scrollbar;
	_tmp29_ = self->priv->terminal;
	_tmp30_ = gtk_scrollable_get_vadjustment ((GtkScrollable*) _tmp29_);
	gtk_range_set_adjustment ((GtkRange*) _tmp28_, _tmp30_);
	_tmp31_ = self->priv->terminal;
	g_signal_connect_object ((GtkWidget*) _tmp31_, "button-press-event", (GCallback) _test_window_button_press_event_cb_gtk_widget_button_press_event, self, 0);
	_tmp32_ = self->priv->terminal;
	g_signal_connect_object (_tmp32_, "char-size-changed", (GCallback) _test_window_char_size_changed_cb_vte_terminal_char_size_changed, self, 0);
	_tmp33_ = self->priv->terminal;
	g_signal_connect_object (_tmp33_, "child-exited", (GCallback) _test_window_child_exited_cb_vte_terminal_child_exited, self, 0);
	_tmp34_ = self->priv->terminal;
	g_signal_connect_object (_tmp34_, "decrease-font-size", (GCallback) _test_window_decrease_font_size_cb_vte_terminal_decrease_font_size, self, 0);
	_tmp35_ = self->priv->terminal;
	g_signal_connect_object (_tmp35_, "deiconify-window", (GCallback) _test_window_deiconify_window_cb_vte_terminal_deiconify_window, self, 0);
	_tmp36_ = self->priv->terminal;
	g_signal_connect_object (_tmp36_, "icon-title-changed", (GCallback) _test_window_icon_title_changed_cb_vte_terminal_icon_title_changed, self, 0);
	_tmp37_ = self->priv->terminal;
	g_signal_connect_object (_tmp37_, "iconify-window", (GCallback) _test_window_iconify_window_cb_vte_terminal_iconify_window, self, 0);
	_tmp38_ = self->priv->terminal;
	g_signal_connect_object (_tmp38_, "increase-font-size", (GCallback) _test_window_increase_font_size_cb_vte_terminal_increase_font_size, self, 0);
	_tmp39_ = self->priv->terminal;
	g_signal_connect_object (_tmp39_, "lower-window", (GCallback) _test_window_lower_window_cb_vte_terminal_lower_window, self, 0);
	_tmp40_ = self->priv->terminal;
	g_signal_connect_object (_tmp40_, "maximize-window", (GCallback) _test_window_maximize_window_cb_vte_terminal_maximize_window, self, 0);
	_tmp41_ = self->priv->terminal;
	g_signal_connect_object (_tmp41_, "move-window", (GCallback) _test_window_move_window_cb_vte_terminal_move_window, self, 0);
	_tmp42_ = self->priv->terminal;
	g_signal_connect_object (_tmp42_, "raise-window", (GCallback) _test_window_raise_window_cb_vte_terminal_raise_window, self, 0);
	_tmp43_ = self->priv->terminal;
	g_signal_connect_object ((GtkWidget*) _tmp43_, "realize", (GCallback) _test_window_realize_cb_gtk_widget_realize, self, 0);
	_tmp44_ = self->priv->terminal;
	g_signal_connect_object (_tmp44_, "refresh-window", (GCallback) _test_window_refresh_window_cb_vte_terminal_refresh_window, self, 0);
	_tmp45_ = self->priv->terminal;
	g_signal_connect_object (_tmp45_, "resize-window", (GCallback) _test_window_resize_window_cb_vte_terminal_resize_window, self, 0);
	_tmp46_ = self->priv->terminal;
	g_signal_connect_object (_tmp46_, "restore-window", (GCallback) _test_window_restore_window_cb_vte_terminal_restore_window, self, 0);
	_tmp47_ = self->priv->terminal;
	g_signal_connect_object (_tmp47_, "selection-changed", (GCallback) _test_window_selection_changed_cb_vte_terminal_selection_changed, self, 0);
	_tmp48_ = self->priv->terminal;
	g_signal_connect_object (_tmp48_, "window-title-changed", (GCallback) _test_window_window_title_changed_cb_vte_terminal_window_title_changed, self, 0);
	_tmp49_ = test_app_options_object_notifications;
	if (_tmp49_) {
		VteTerminal* _tmp50_ = NULL;
		_tmp50_ = self->priv->terminal;
		g_signal_connect_object ((GObject*) _tmp50_, "notify", (GCallback) _test_window_notify_cb_g_object_notify, self, 0);
	}
	_tmp51_ = test_app_options_no_double_buffer;
	if (_tmp51_) {
		VteTerminal* _tmp52_ = NULL;
		_tmp52_ = self->priv->terminal;
		gtk_widget_set_double_buffered ((GtkWidget*) _tmp52_, TRUE);
	}
	_tmp53_ = test_app_options_encoding;
	if (_tmp53_ != NULL) {
		{
			VteTerminal* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			_tmp54_ = self->priv->terminal;
			_tmp55_ = test_app_options_encoding;
			vte_terminal_set_encoding (_tmp54_, _tmp55_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp56_ = NULL;
			const gchar* _tmp57_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp56_ = e;
			_tmp57_ = _tmp56_->message;
			g_printerr ("Failed to set encoding: %s\n", _tmp57_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (box);
			_g_object_unref0 (ui);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp58_ = test_app_options_word_char_exceptions;
	if (_tmp58_ != NULL) {
		VteTerminal* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		_tmp59_ = self->priv->terminal;
		_tmp60_ = test_app_options_word_char_exceptions;
		vte_terminal_set_word_char_exceptions (_tmp59_, _tmp60_);
	}
	_tmp61_ = self->priv->terminal;
	_tmp62_ = test_app_options_audible;
	vte_terminal_set_audible_bell (_tmp61_, _tmp62_);
	_tmp63_ = self->priv->terminal;
	_tmp64_ = test_app_options_get_cjk_ambiguous_width ();
	vte_terminal_set_cjk_ambiguous_width (_tmp63_, _tmp64_);
	_tmp65_ = self->priv->terminal;
	_tmp66_ = test_app_options_get_cursor_blink_mode ();
	vte_terminal_set_cursor_blink_mode (_tmp65_, _tmp66_);
	_tmp67_ = self->priv->terminal;
	_tmp68_ = test_app_options_get_cursor_shape ();
	vte_terminal_set_cursor_shape (_tmp67_, _tmp68_);
	_tmp69_ = self->priv->terminal;
	vte_terminal_set_mouse_autohide (_tmp69_, TRUE);
	_tmp70_ = self->priv->terminal;
	_tmp71_ = test_app_options_no_rewrap;
	vte_terminal_set_rewrap_on_resize (_tmp70_, !_tmp71_);
	_tmp72_ = self->priv->terminal;
	vte_terminal_set_scroll_on_output (_tmp72_, FALSE);
	_tmp73_ = self->priv->terminal;
	vte_terminal_set_scroll_on_keystroke (_tmp73_, TRUE);
	_tmp74_ = self->priv->terminal;
	_tmp75_ = test_app_options_scrollback_lines;
	vte_terminal_set_scrollback_lines (_tmp74_, (glong) _tmp75_);
	_tmp76_ = test_app_options_font_string;
	if (_tmp76_ != NULL) {
		PangoFontDescription* desc = NULL;
		const gchar* _tmp77_ = NULL;
		PangoFontDescription* _tmp78_ = NULL;
		VteTerminal* _tmp79_ = NULL;
		PangoFontDescription* _tmp80_ = NULL;
		_tmp77_ = test_app_options_font_string;
		_tmp78_ = pango_font_description_from_string (_tmp77_);
		desc = _tmp78_;
		_tmp79_ = self->priv->terminal;
		_tmp80_ = desc;
		vte_terminal_set_font (_tmp79_, _tmp80_);
		__vala_PangoFontDescription_free0 (desc);
	}
	_tmp81_ = self->priv->terminal;
	test_app_options_get_color_fg (&_tmp82_);
	test_app_options_get_color_bg (&_tmp83_);
	vte_terminal_set_colors (_tmp81_, &_tmp82_, &_tmp83_, NULL, (gsize) 0);
	_tmp84_ = self->priv->terminal;
	_tmp85_ = test_app_options_get_color_cursor ();
	_tmp86_ = _tmp85_;
	vte_terminal_set_color_cursor (_tmp84_, _tmp86_);
	_g_free0 (_tmp86_);
	_tmp87_ = self->priv->terminal;
	_tmp88_ = test_app_options_get_color_hl_bg ();
	_tmp89_ = _tmp88_;
	vte_terminal_set_color_highlight (_tmp87_, _tmp89_);
	_g_free0 (_tmp89_);
	_tmp90_ = self->priv->terminal;
	_tmp91_ = test_app_options_get_color_hl_fg ();
	_tmp92_ = _tmp91_;
	vte_terminal_set_color_highlight_foreground (_tmp90_, _tmp92_);
	_g_free0 (_tmp92_);
	_tmp93_ = test_app_options_no_builtin_dingus;
	if (!_tmp93_) {
		gchar** _tmp94_ = NULL;
		gint _tmp94__length1 = 0;
		_tmp94_ = self->priv->builtin_dingus;
		_tmp94__length1 = self->priv->builtin_dingus_length1;
		test_window_add_dingus (self, _tmp94_, _tmp94__length1);
	}
	_tmp95_ = test_app_options_dingus;
	_tmp95__length1 = test_app_options_dingus_length1;
	if (_tmp95_ != NULL) {
		gchar** _tmp96_ = NULL;
		gint _tmp96__length1 = 0;
		_tmp96_ = test_app_options_dingus;
		_tmp96__length1 = test_app_options_dingus_length1;
		test_window_add_dingus (self, _tmp96_, _tmp96__length1);
	}
	_tmp97_ = self->priv->terminal;
	_tmp98_ = g_property_action_new ("input-enabled", (GObject*) _tmp97_, "input-enabled");
	_tmp99_ = _tmp98_;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp99_);
	_g_object_unref0 (_tmp99_);
	_tmp100_ = box;
	_tmp101_ = self->priv->terminal;
	gtk_box_pack_start (_tmp100_, (GtkWidget*) _tmp101_, TRUE, TRUE, (guint) 0);
	_tmp102_ = self->priv->terminal;
	gtk_widget_show ((GtkWidget*) _tmp102_);
	test_window_update_paste_sensitivity (self);
	test_window_update_copy_sensitivity (self);
	_tmp103_ = self->priv->terminal;
	gtk_widget_grab_focus ((GtkWidget*) _tmp103_);
	_tmp104_ = gtk_widget_get_realized ((GtkWidget*) self);
	_vala_assert (!_tmp104_, "!get_realized()");
	_g_object_unref0 (box);
	_g_object_unref0 (ui);
	return self;
}


TestWindow* test_window_new (TestApp* app) {
	return test_window_construct (TEST_TYPE_WINDOW, app);
}


static void test_window_add_dingus (TestWindow* self, gchar** dingus, int dingus_length1) {
	static const GdkCursorType cursors[] = {GDK_GUMBY, GDK_HAND1};
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gchar** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = dingus;
				_tmp3__length1 = dingus_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				{
					GRegex* regex = NULL;
					gint tag = 0;
					GRegex* _tmp4_ = NULL;
					gchar** _tmp5_ = NULL;
					gint _tmp5__length1 = 0;
					gint _tmp6_ = 0;
					const gchar* _tmp7_ = NULL;
					GRegex* _tmp8_ = NULL;
					GRegex* _tmp9_ = NULL;
					VteTerminal* _tmp10_ = NULL;
					GRegex* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					VteTerminal* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					GdkCursorType _tmp16_ = 0;
					_tmp5_ = dingus;
					_tmp5__length1 = dingus_length1;
					_tmp6_ = i;
					_tmp7_ = _tmp5_[_tmp6_];
					_tmp8_ = g_regex_new (_tmp7_, G_REGEX_OPTIMIZE, 0, &_inner_error_);
					_tmp4_ = _tmp8_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_regex_unref0 (regex);
						goto __catch1_g_error;
					}
					_tmp9_ = _tmp4_;
					_tmp4_ = NULL;
					_g_regex_unref0 (regex);
					regex = _tmp9_;
					_tmp10_ = self->priv->terminal;
					_tmp11_ = regex;
					_tmp12_ = vte_terminal_match_add_gregex (_tmp10_, _tmp11_, 0);
					tag = _tmp12_;
					_tmp13_ = self->priv->terminal;
					_tmp14_ = tag;
					_tmp15_ = i;
					_tmp16_ = cursors[_tmp15_ % G_N_ELEMENTS (cursors)];
					vte_terminal_match_set_cursor_type (_tmp13_, _tmp14_, _tmp16_);
					_g_regex_unref0 (_tmp4_);
					_g_regex_unref0 (regex);
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp18_ = 0;
					const gchar* _tmp19_ = NULL;
					GError* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp17_ = dingus;
					_tmp17__length1 = dingus_length1;
					_tmp18_ = i;
					_tmp19_ = _tmp17_[_tmp18_];
					_tmp20_ = e;
					_tmp21_ = _tmp20_->message;
					g_printerr ("Failed to compile regex \"%s\": %s\n", _tmp19_, _tmp21_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void test_window_adjust_font_size (TestWindow* self, gdouble factor) {
	glong columns = 0L;
	VteTerminal* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	glong rows = 0L;
	VteTerminal* _tmp2_ = NULL;
	glong _tmp3_ = 0L;
	VteTerminal* _tmp4_ = NULL;
	VteTerminal* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->terminal;
	_tmp1_ = vte_terminal_get_column_count (_tmp0_);
	columns = _tmp1_;
	_tmp2_ = self->priv->terminal;
	_tmp3_ = vte_terminal_get_row_count (_tmp2_);
	rows = _tmp3_;
	_tmp4_ = self->priv->terminal;
	_tmp5_ = self->priv->terminal;
	_tmp6_ = vte_terminal_get_font_scale (_tmp5_);
	_tmp7_ = factor;
	vte_terminal_set_font_scale (_tmp4_, _tmp6_ * _tmp7_);
	test_window_update_geometry (self);
	gtk_window_resize_to_geometry ((GtkWindow*) self, (gint) columns, (gint) rows);
}


void test_window_apply_geometry (TestWindow* self) {
	VteTerminal* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->terminal;
	gtk_widget_realize ((GtkWidget*) _tmp0_);
	_tmp1_ = test_app_options_geometry;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = test_app_options_geometry;
		_tmp3_ = gtk_window_parse_geometry ((GtkWindow*) self, _tmp2_);
		if (_tmp3_) {
			gint columns = 0;
			gint rows = 0;
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
			VteTerminal* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gtk_window_get_default_size ((GtkWindow*) self, &_tmp4_, &_tmp5_);
			columns = _tmp4_;
			rows = _tmp5_;
			_tmp6_ = self->priv->terminal;
			_tmp7_ = columns;
			_tmp8_ = rows;
			vte_terminal_set_size (_tmp6_, (glong) _tmp7_, (glong) _tmp8_);
			_tmp9_ = columns;
			_tmp10_ = rows;
			gtk_window_resize_to_geometry ((GtkWindow*) self, _tmp9_, _tmp10_);
		} else {
			const gchar* _tmp11_ = NULL;
			_tmp11_ = test_app_options_geometry;
			g_printerr ("Failed to parse geometry spec \"%s\"\n", _tmp11_);
		}
	} else {
		VteTerminal* _tmp12_ = NULL;
		glong _tmp13_ = 0L;
		VteTerminal* _tmp14_ = NULL;
		glong _tmp15_ = 0L;
		_tmp12_ = self->priv->terminal;
		_tmp13_ = vte_terminal_get_column_count (_tmp12_);
		_tmp14_ = self->priv->terminal;
		_tmp15_ = vte_terminal_get_row_count (_tmp14_);
		gtk_window_set_default_geometry ((GtkWindow*) self, (gint) _tmp13_, (gint) _tmp15_);
	}
}


static void test_window_launch_command (TestWindow* self, const gchar* command, GError** error) {
	gchar** argv = NULL;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp2_ = 0;
	VteTerminal* _tmp3_ = NULL;
	VtePtyFlags _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GPid _tmp8_ = 0;
	GPid _tmp9_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command != NULL);
	_tmp0_ = command;
	g_shell_parse_argv (_tmp0_, &_tmp2_, &_tmp1_, &_inner_error_);
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	argv = _tmp1_;
	argv_length1 = _tmp2_;
	_argv_size_ = argv_length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp3_ = self->priv->terminal;
	_tmp4_ = test_app_options_get_pty_flags ();
	_tmp5_ = test_app_options_working_directory;
	_tmp6_ = argv;
	_tmp6__length1 = argv_length1;
	_tmp7_ = test_app_options_environment;
	_tmp7__length1 = test_app_options_environment_length1;
	vte_terminal_spawn_sync (_tmp3_, _tmp4_, _tmp5_, _tmp6_, _tmp7_, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp8_, NULL, &_inner_error_);
	self->priv->child_pid = _tmp8_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp9_ = self->priv->child_pid;
	g_print ("Fork succeeded, PID %d\n", (gint) _tmp9_);
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void test_window_launch_shell (TestWindow* self, GError** error) {
	gchar* shell = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = vte_get_user_shell ();
	_g_free0 (shell);
	shell = _tmp0_;
	_tmp2_ = shell;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_ = NULL;
		gchar _tmp4_ = '\0';
		_tmp3_ = shell;
		_tmp4_ = string_get (_tmp3_, (glong) 0);
		_tmp1_ = _tmp4_ == '\0';
	}
	if (_tmp1_) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = g_getenv ("SHELL");
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (shell);
		shell = _tmp6_;
	}
	_tmp8_ = shell;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_ = NULL;
		gchar _tmp10_ = '\0';
		_tmp9_ = shell;
		_tmp10_ = string_get (_tmp9_, (glong) 0);
		_tmp7_ = _tmp10_ == '\0';
	}
	if (_tmp7_) {
		gchar* _tmp11_ = NULL;
		_tmp11_ = g_strdup ("/bin/sh");
		_g_free0 (shell);
		shell = _tmp11_;
	}
	_tmp12_ = shell;
	test_window_launch_command (self, _tmp12_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (shell);
		return;
	}
	_g_free0 (shell);
}


static void test_window_fork (TestWindow* self, GError** error) {
	VtePty* pty = NULL;
	pid_t pid = 0;
	VtePty* _tmp0_ = NULL;
	VtePtyFlags _tmp1_ = 0;
	VtePty* _tmp2_ = NULL;
	VtePty* _tmp3_ = NULL;
	pid_t _tmp4_ = 0;
	pid_t _tmp5_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = test_app_options_get_pty_flags ();
	_tmp2_ = vte_pty_new_sync (_tmp1_, NULL, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (pty);
		return;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (pty);
	pty = _tmp3_;
	_tmp4_ = fork ();
	pid = _tmp4_;
	_tmp5_ = pid;
	switch (_tmp5_) {
		case -1:
		{
			g_printerr ("Error forking: %m");
			break;
		}
		case 0:
		{
			{
				VtePty* _tmp6_ = NULL;
				_tmp6_ = pty;
				vte_pty_child_setup (_tmp6_);
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_ = 0;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = i;
								i = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = i;
							switch (_tmp9_ % 3) {
								case 0:
								case 1:
								{
									gint _tmp10_ = 0;
									_tmp10_ = i;
									g_print ("%d\n", _tmp10_);
									break;
								}
								case 2:
								{
									gint _tmp11_ = 0;
									_tmp11_ = i;
									g_printerr ("%d\n", _tmp11_);
									break;
								}
								default:
								break;
							}
							sleep ((guint) 1);
						}
					}
				}
			}
		}
		default:
		{
			VteTerminal* _tmp12_ = NULL;
			VtePty* _tmp13_ = NULL;
			VteTerminal* _tmp14_ = NULL;
			pid_t _tmp15_ = 0;
			pid_t _tmp16_ = 0;
			pid_t _tmp17_ = 0;
			_tmp12_ = self->priv->terminal;
			_tmp13_ = pty;
			vte_terminal_set_pty (_tmp12_, _tmp13_);
			_tmp14_ = self->priv->terminal;
			_tmp15_ = pid;
			vte_terminal_watch_child (_tmp14_, (GPid) _tmp15_);
			_tmp16_ = pid;
			_tmp17_ = getpid ();
			g_print ("Child PID is %d (mine is %d).\n", (gint) _tmp16_, (gint) _tmp17_);
			break;
		}
	}
	_g_object_unref0 (_tmp0_);
	_g_object_unref0 (pty);
}


void test_window_launch (TestWindow* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_ = NULL;
		_tmp0_ = test_app_options_command;
		if (_tmp0_ != NULL) {
			const gchar* _tmp1_ = NULL;
			_tmp1_ = test_app_options_command;
			test_window_launch_command (self, _tmp1_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
		} else {
			gboolean _tmp2_ = FALSE;
			_tmp2_ = test_app_options_no_shell;
			if (!_tmp2_) {
				test_window_launch_shell (self, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch2_g_error;
				}
			} else {
				test_window_fork (self, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch2_g_error;
				}
			}
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_printerr ("Error: %s\n", _tmp4_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void test_window_update_copy_sensitivity (TestWindow* self) {
	GSimpleAction* action = NULL;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	VteTerminal* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "copy");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	action = _tmp1_;
	_tmp2_ = self->priv->terminal;
	_tmp3_ = vte_terminal_get_has_selection (_tmp2_);
	g_simple_action_set_enabled (action, _tmp3_);
	_g_object_unref0 (action);
}


static void test_window_update_paste_sensitivity (TestWindow* self) {
	GdkAtom* targets = NULL;
	gint targets_length1 = 0;
	gint _targets_size_ = 0;
	gboolean can_paste = FALSE;
	GtkClipboard* _tmp0_ = NULL;
	GdkAtom* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	GSimpleAction* action = NULL;
	GAction* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clipboard;
	_tmp3_ = gtk_clipboard_wait_for_targets (_tmp0_, &_tmp1_, &_tmp2_);
	targets = (g_free (targets), NULL);
	targets = _tmp1_;
	targets_length1 = _tmp2_;
	_targets_size_ = targets_length1;
	if (_tmp3_) {
		GdkAtom* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = targets;
		_tmp4__length1 = targets_length1;
		_tmp5_ = gtk_targets_include_text (_tmp4_, _tmp4__length1);
		can_paste = _tmp5_;
	} else {
		can_paste = FALSE;
	}
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) self, "paste");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp6_) : NULL);
	action = _tmp7_;
	_tmp8_ = can_paste;
	g_simple_action_set_enabled (action, _tmp8_);
	_g_object_unref0 (action);
	targets = (g_free (targets), NULL);
}


static void test_window_update_geometry (TestWindow* self) {
	gboolean _tmp0_ = FALSE;
	VteTerminal* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	VteTerminal* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = test_app_options_no_geometry_hints;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->terminal;
	_tmp2_ = gtk_widget_get_realized ((GtkWidget*) _tmp1_);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->terminal;
	vte_terminal_set_geometry_hints_for_window (_tmp3_, (GtkWindow*) self);
}


static void test_window_action_copy_cb (TestWindow* self) {
	VteTerminal* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->terminal;
	vte_terminal_copy_clipboard (_tmp0_);
}


static void test_window_action_copy_match_cb (TestWindow* self, GSimpleAction* action, GVariant* parameter) {
	gsize len = 0UL;
	const gchar* str = NULL;
	GVariant* _tmp0_ = NULL;
	gsize _tmp1_ = 0UL;
	const gchar* _tmp2_ = NULL;
	GtkClipboard* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = parameter;
	_tmp2_ = g_variant_get_string (_tmp0_, &_tmp1_);
	len = _tmp1_;
	str = _tmp2_;
	_tmp3_ = self->priv->clipboard;
	gtk_clipboard_set_text (_tmp3_, str, (gint) len);
}


static void test_window_action_paste_cb (TestWindow* self) {
	VteTerminal* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->terminal;
	vte_terminal_paste_clipboard (_tmp0_);
}


static void test_window_action_reset_cb (TestWindow* self) {
	gboolean clear = FALSE;
	GdkModifierType modifiers = 0;
	GdkModifierType _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	VteTerminal* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = gtk_get_current_event_state (&_tmp0_);
	modifiers = _tmp0_;
	if (_tmp1_) {
		GdkModifierType _tmp2_ = 0;
		_tmp2_ = modifiers;
		clear = (_tmp2_ & GDK_CONTROL_MASK) != 0;
	} else {
		clear = FALSE;
	}
	_tmp3_ = self->priv->terminal;
	_tmp4_ = clear;
	vte_terminal_reset (_tmp3_, TRUE, _tmp4_);
}


static gboolean test_window_button_press_event_cb (TestWindow* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	GMenu* menu = NULL;
	GMenu* _tmp3_ = NULL;
	GMenu* _tmp4_ = NULL;
	gchar* match = NULL;
	VteTerminal* _tmp5_ = NULL;
	GdkEventButton* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GMenu* _tmp13_ = NULL;
	GtkMenu* popup = NULL;
	GMenu* _tmp14_ = NULL;
	GtkMenu* _tmp15_ = NULL;
	GtkMenu* _tmp16_ = NULL;
	GtkMenu* _tmp17_ = NULL;
	GdkEventButton* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	GdkEventButton* _tmp20_ = NULL;
	guint32 _tmp21_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) 3)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = test_app_options_no_context_menu;
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = g_menu_new ();
	menu = _tmp3_;
	_tmp4_ = menu;
	g_menu_append (_tmp4_, "_Copy", "win.copy");
	_tmp5_ = self->priv->terminal;
	_tmp6_ = event;
	_tmp7_ = vte_terminal_match_check_event (_tmp5_, (GdkEvent*) _tmp6_, NULL);
	match = _tmp7_;
	_tmp8_ = match;
	if (_tmp8_ != NULL) {
		GMenu* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp9_ = menu;
		_tmp10_ = match;
		_tmp11_ = g_strconcat ("win.copy-match::", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		g_menu_append (_tmp9_, "Copy _Match", _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = menu;
	g_menu_append (_tmp13_, "_Paste", "win.paste");
	_tmp14_ = menu;
	_tmp15_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) _tmp14_);
	g_object_ref_sink (_tmp15_);
	popup = _tmp15_;
	_tmp16_ = popup;
	gtk_menu_attach_to_widget (_tmp16_, (GtkWidget*) self, NULL);
	_tmp17_ = popup;
	_tmp18_ = event;
	_tmp19_ = _tmp18_->button;
	_tmp20_ = event;
	_tmp21_ = _tmp20_->time;
	gtk_menu_popup (_tmp17_, NULL, NULL, NULL, NULL, _tmp19_, _tmp21_);
	result = FALSE;
	_g_object_unref0 (popup);
	_g_free0 (match);
	_g_object_unref0 (menu);
	return result;
}


static void test_window_char_size_changed_cb (TestWindow* self, VteTerminal* terminal, guint width, guint height) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	test_window_update_geometry (self);
}


static void test_window_child_exited_cb (TestWindow* self, VteTerminal* terminal, gint status) {
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp11_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	_tmp0_ = status;
	g_printerr ("Child exited with status %x\n", (guint) _tmp0_);
	_tmp1_ = test_app_options_output_filename;
	if (_tmp1_ != NULL) {
		{
			GFile* file = NULL;
			const gchar* _tmp2_ = NULL;
			GFile* _tmp3_ = NULL;
			GFileOutputStream* stream = NULL;
			GFile* _tmp4_ = NULL;
			GFileOutputStream* _tmp5_ = NULL;
			VteTerminal* _tmp6_ = NULL;
			GFileOutputStream* _tmp7_ = NULL;
			_tmp2_ = test_app_options_output_filename;
			_tmp3_ = g_file_new_for_commandline_arg (_tmp2_);
			file = _tmp3_;
			_tmp4_ = file;
			_tmp5_ = g_file_replace (_tmp4_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
			stream = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch3_g_error;
			}
			_tmp6_ = terminal;
			_tmp7_ = stream;
			vte_terminal_write_contents_sync (_tmp6_, (GOutputStream*) _tmp7_, VTE_WRITE_DEFAULT, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (stream);
				_g_object_unref0 (file);
				goto __catch3_g_error;
			}
			_g_object_unref0 (stream);
			_g_object_unref0 (file);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp8_ = NULL;
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp8_ = test_app_options_output_filename;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_printerr ("Failed to write output to \"%s\": %s\n", _tmp8_, _tmp10_);
			_g_error_free0 (e);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp11_ = test_app_options_keep;
	if (_tmp11_) {
		return;
	}
	gtk_widget_destroy ((GtkWidget*) self);
}


static void test_window_clipboard_owner_change_cb (TestWindow* self, GtkClipboard* clipboard, GdkEvent* event) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (clipboard != NULL);
	g_return_if_fail (event != NULL);
	test_window_update_paste_sensitivity (self);
}


static void test_window_decrease_font_size_cb (TestWindow* self, VteTerminal* terminal) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	test_window_adjust_font_size (self, 1.0 / 1.2);
}


void test_window_deiconify_window_cb (TestWindow* self, VteTerminal* terminal) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	gtk_window_deiconify ((GtkWindow*) self);
}


static void test_window_icon_title_changed_cb (TestWindow* self, VteTerminal* terminal) {
	GdkWindow* _tmp0_ = NULL;
	VteTerminal* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = terminal;
	_tmp2_ = vte_terminal_get_icon_title (_tmp1_);
	gdk_window_set_icon_name (_tmp0_, _tmp2_);
}


static void test_window_iconify_window_cb (TestWindow* self, VteTerminal* terminal) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	gtk_window_iconify ((GtkWindow*) self);
}


static void test_window_increase_font_size_cb (TestWindow* self, VteTerminal* terminal) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	test_window_adjust_font_size (self, 1.2);
}


static void test_window_lower_window_cb (TestWindow* self, VteTerminal* terminal) {
	gboolean _tmp0_ = FALSE;
	GdkWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	_tmp0_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_lower (_tmp1_);
}


static void test_window_maximize_window_cb (TestWindow* self, VteTerminal* terminal) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	gtk_window_maximize ((GtkWindow*) self);
}


static void test_window_move_window_cb (TestWindow* self, VteTerminal* terminal, guint x, guint y) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	gtk_window_move ((GtkWindow*) self, (gint) _tmp0_, (gint) _tmp1_);
}


static void test_window_notify_cb (TestWindow* self, GObject* object, GParamSpec* pspec) {
	GParamSpec* _tmp0_ = NULL;
	GType _tmp1_ = 0UL;
	GValue value = {0};
	GParamSpec* _tmp2_ = NULL;
	GType _tmp3_ = 0UL;
	GValue _tmp4_ = {0};
	GObject* _tmp5_ = NULL;
	GParamSpec* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* str = NULL;
	gchar* _tmp8_ = NULL;
	GParamSpec* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = pspec;
	_tmp1_ = _tmp0_->owner_type;
	if (_tmp1_ != vte_terminal_get_type ()) {
		return;
	}
	_tmp2_ = pspec;
	_tmp3_ = _tmp2_->value_type;
	g_value_init (&_tmp4_, _tmp3_);
	value = _tmp4_;
	_tmp5_ = object;
	_tmp6_ = pspec;
	_tmp7_ = _tmp6_->name;
	g_object_get_property (_tmp5_, _tmp7_, &value);
	_tmp8_ = g_strdup_value_contents (&value);
	str = _tmp8_;
	_tmp9_ = pspec;
	_tmp10_ = _tmp9_->name;
	_tmp11_ = str;
	g_print ("NOTIFY property \"%s\" value %s\n", _tmp10_, _tmp11_);
	_g_free0 (str);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
}


static void test_window_raise_window_cb (TestWindow* self, VteTerminal* terminal) {
	gboolean _tmp0_ = FALSE;
	GdkWindow* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	_tmp0_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_raise (_tmp1_);
}


static void test_window_realize_cb (TestWindow* self, GtkWidget* widget) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	test_window_update_geometry (self);
}


static void test_window_refresh_window_cb (TestWindow* self, VteTerminal* terminal) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void test_window_resize_window_cb (TestWindow* self, VteTerminal* terminal, guint columns, guint rows) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	VteTerminal* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	_tmp1_ = columns;
	if (_tmp1_ < ((guint) 2)) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp2_ = 0U;
		_tmp2_ = rows;
		_tmp0_ = _tmp2_ < ((guint) 2);
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = terminal;
	_tmp4_ = columns;
	_tmp5_ = rows;
	vte_terminal_set_size (_tmp3_, (glong) ((gint) _tmp4_), (glong) ((gint) _tmp5_));
	_tmp6_ = columns;
	_tmp7_ = rows;
	gtk_window_resize_to_geometry ((GtkWindow*) self, (gint) _tmp6_, (gint) _tmp7_);
}


static void test_window_restore_window_cb (TestWindow* self, VteTerminal* terminal) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	gtk_window_unmaximize ((GtkWindow*) self);
}


static void test_window_selection_changed_cb (TestWindow* self, VteTerminal* terminal) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	test_window_update_copy_sensitivity (self);
}


static void test_window_window_title_changed_cb (TestWindow* self, VteTerminal* terminal) {
	VteTerminal* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	_tmp0_ = terminal;
	_tmp1_ = vte_terminal_get_window_title (_tmp0_);
	gtk_window_set_title ((GtkWindow*) self, _tmp1_);
}


static void test_window_class_init (TestWindowClass * klass) {
	test_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TestWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = test_window_finalize;
}


static void test_window_instance_init (TestWindow * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	self->priv = TEST_WINDOW_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("(((gopher|news|telnet|nntp|file|http|ftp|https)://)|(www|ftp)[-A-Za-z0" \
"-9]*\\.)[-A-Za-z0-9\\.]+(:[0-9]*)?");
	_tmp1_ = g_strdup ("(((gopher|news|telnet|nntp|file|http|ftp|https)://)|(www|ftp)[-A-Za-z0" \
"-9]*\\.)[-A-Za-z0-9\\.]+(:[0-9]*)?/[-A-Za-z0-9_\\$\\.\\+\\!\\*\\(\\),;" \
":@&=\\?/~\\#\\%]*[^]'\\.}>\\) ,\\\"]");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	self->priv->builtin_dingus = _tmp2_;
	self->priv->builtin_dingus_length1 = 2;
	self->priv->_builtin_dingus_size_ = self->priv->builtin_dingus_length1;
}


static void test_window_finalize (GObject* obj) {
	TestWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TEST_TYPE_WINDOW, TestWindow);
	_g_object_unref0 (self->priv->terminal);
	_g_object_unref0 (self->priv->scrollbar);
	_g_object_unref0 (self->priv->clipboard);
	self->priv->builtin_dingus = (_vala_array_free (self->priv->builtin_dingus, self->priv->builtin_dingus_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (test_window_parent_class)->finalize (obj);
}


GType test_window_get_type (void) {
	static volatile gsize test_window_type_id__volatile = 0;
	if (g_once_init_enter (&test_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestWindow), 0, (GInstanceInitFunc) test_window_instance_init, NULL };
		GType test_window_type_id;
		test_window_type_id = g_type_register_static (gtk_application_window_get_type (), "TestWindow", &g_define_type_info, 0);
		g_once_init_leave (&test_window_type_id__volatile, test_window_type_id);
	}
	return test_window_type_id__volatile;
}


TestApp* test_app_construct (GType object_type) {
	TestApp * self = NULL;
	self = (TestApp*) g_object_new (object_type, "application-id", "org.gnome.Vte.Test.App", "flags", G_APPLICATION_NON_UNIQUE, NULL);
	return self;
}


TestApp* test_app_new (void) {
	return test_app_construct (TEST_TYPE_APP);
}


static void test_app_real_startup (GApplication* base) {
	TestApp * self;
	TestWindow* _tmp0_ = NULL;
	TestWindow* _tmp1_ = NULL;
	self = (TestApp*) base;
	G_APPLICATION_CLASS (test_app_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = test_window_new (self);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp0_;
	_tmp1_ = self->priv->window;
	test_window_launch (_tmp1_);
}


static void test_app_real_activate (GApplication* base) {
	TestApp * self;
	TestWindow* _tmp0_ = NULL;
	TestWindow* _tmp1_ = NULL;
	self = (TestApp*) base;
	_tmp0_ = self->priv->window;
	test_window_apply_geometry (_tmp0_);
	_tmp1_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp1_);
}


gint test_app_main (gchar** argv, int argv_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	TestApp* app = NULL;
	TestApp* _tmp12_ = NULL;
	TestApp* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_getenv ("VTE_CJK_WIDTH");
	if (_tmp0_ != NULL) {
		g_printerr ("VTE_CJK_WIDTH is not supported anymore, use --cjk-width instead\n");
	}
	g_set_prgname ("vte-app");
	g_set_application_name ("Terminal");
	{
		GOptionContext* context = NULL;
		GOptionContext* _tmp1_ = NULL;
		GOptionContext* _tmp2_ = NULL;
		GOptionContext* _tmp3_ = NULL;
		GOptionContext* _tmp4_ = NULL;
		GOptionGroup* _tmp5_ = NULL;
		GOptionContext* _tmp6_ = NULL;
		_tmp1_ = g_option_context_new ("— simple VTE test application");
		context = _tmp1_;
		_tmp2_ = context;
		g_option_context_set_help_enabled (_tmp2_, TRUE);
		_tmp3_ = context;
		g_option_context_add_main_entries (_tmp3_, TEST_APP_OPTIONS_entries, NULL);
		_tmp4_ = context;
		_tmp5_ = gtk_get_option_group (TRUE);
		g_option_context_add_group (_tmp4_, _tmp5_);
		_tmp6_ = context;
		g_option_context_parse (_tmp6_, &argv_length1, &argv, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_option_context_free0 (context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch4_g_option_error;
			}
			_g_option_context_free0 (context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (context);
	}
	goto __finally4;
	__catch4_g_option_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_printerr ("Error parsing arguments: %s\n", _tmp8_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = test_app_options_version;
	if (_tmp9_) {
		g_print ("Simple VTE Test Application %s\n", VERSION);
		result = 0;
		return result;
	}
	_tmp10_ = test_app_options_debug;
	if (_tmp10_) {
		gboolean _tmp11_ = FALSE;
		_tmp11_ = test_app_options_debug;
		gdk_window_set_debug_updates (_tmp11_);
	}
	_tmp12_ = test_app_new ();
	app = _tmp12_;
	_tmp13_ = app;
	_tmp14_ = g_application_run ((GApplication*) _tmp13_, 0, NULL);
	result = _tmp14_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return test_app_main (argv, argc);
}


static gint test_app_options_parse_enum (GType type, const gchar* str) {
	gint result = 0;
	gint value = 0;
	GEnumClass* enum_klass = NULL;
	GType _tmp0_ = 0UL;
	GTypeClass* _tmp1_ = NULL;
	GEnumValue* enum_value = NULL;
	GEnumClass* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GEnumValue* _tmp4_ = NULL;
	GEnumValue* _tmp5_ = NULL;
	g_return_val_if_fail (str != NULL, 0);
	value = 0;
	_tmp0_ = type;
	_tmp1_ = g_type_class_ref (_tmp0_);
	enum_klass = (GEnumClass*) _tmp1_;
	_tmp2_ = enum_klass;
	_tmp3_ = str;
	_tmp4_ = g_enum_get_value_by_nick (_tmp2_, _tmp3_);
	enum_value = _tmp4_;
	_tmp5_ = enum_value;
	if (_tmp5_ != NULL) {
		GEnumValue* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp6_ = enum_value;
		_tmp7_ = (*_tmp6_).value;
		value = _tmp7_;
	} else {
		const gchar* _tmp8_ = NULL;
		GType _tmp9_ = 0UL;
		GQuark _tmp10_ = 0U;
		const gchar* _tmp11_ = NULL;
		_tmp8_ = str;
		_tmp9_ = type;
		_tmp10_ = g_type_qname (_tmp9_);
		_tmp11_ = g_quark_to_string (_tmp10_);
		g_printerr ("Failed to parse enum value \"%s\" as type \"%s\"\n", _tmp8_, _tmp11_);
	}
	result = value;
	_g_type_class_unref0 (enum_klass);
	return result;
}


static guint test_app_options_parse_flags (GType type, const gchar* str) {
	guint result = 0U;
	guint value = 0U;
	GFlagsClass* flags_klass = NULL;
	GType _tmp0_ = 0UL;
	GTypeClass* _tmp1_ = NULL;
	gchar** flags = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint flags_length1 = 0;
	gint _flags_size_ = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	g_return_val_if_fail (str != NULL, 0U);
	value = (guint) 0;
	_tmp0_ = type;
	_tmp1_ = g_type_class_ref (_tmp0_);
	flags_klass = (GFlagsClass*) _tmp1_;
	_tmp2_ = str;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ",|", -1);
	flags = _tmp4_;
	flags_length1 = _vala_array_length (_tmp3_);
	_flags_size_ = flags_length1;
	_tmp5_ = flags;
	_tmp5__length1 = flags_length1;
	if (_tmp5_ == NULL) {
		result = value;
		flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
		_g_type_class_unref0 (flags_klass);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_ = 0;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				GFlagsValue* flags_value = NULL;
				GFlagsClass* _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				const gchar* _tmp13_ = NULL;
				GFlagsValue* _tmp14_ = NULL;
				GFlagsValue* _tmp15_ = NULL;
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = flags;
				_tmp9__length1 = flags_length1;
				if (!(_tmp8_ < _tmp9__length1)) {
					break;
				}
				_tmp10_ = flags_klass;
				_tmp11_ = flags;
				_tmp11__length1 = flags_length1;
				_tmp12_ = i;
				_tmp13_ = _tmp11_[_tmp12_];
				_tmp14_ = g_flags_get_value_by_nick (_tmp10_, _tmp13_);
				flags_value = _tmp14_;
				_tmp15_ = flags_value;
				if (_tmp15_ != NULL) {
					guint _tmp16_ = 0U;
					GFlagsValue* _tmp17_ = NULL;
					gint _tmp18_ = 0;
					_tmp16_ = value;
					_tmp17_ = flags_value;
					_tmp18_ = _tmp17_->value;
					value = _tmp16_ | _tmp18_;
				} else {
					const gchar* _tmp19_ = NULL;
					GType _tmp20_ = 0UL;
					GQuark _tmp21_ = 0U;
					const gchar* _tmp22_ = NULL;
					_tmp19_ = str;
					_tmp20_ = type;
					_tmp21_ = g_type_qname (_tmp20_);
					_tmp22_ = g_quark_to_string (_tmp21_);
					g_printerr ("Failed to parse flags value \"%s\" as type \"%s\"\n", _tmp19_, _tmp22_);
				}
			}
		}
	}
	result = value;
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
	_g_type_class_unref0 (flags_klass);
	return result;
}


gint test_app_options_get_cjk_ambiguous_width (void) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	_tmp0_ = test_app_options_cjk_ambiguous_width_string;
	if (_tmp0_ == NULL) {
		result = 1;
		return result;
	}
	_tmp1_ = test_app_options_cjk_ambiguous_width_string;
	if (g_strcmp0 (_tmp1_, "narrow") == 0) {
		result = 1;
		return result;
	}
	_tmp2_ = test_app_options_cjk_ambiguous_width_string;
	if (g_strcmp0 (_tmp2_, "wide") == 0) {
		result = 2;
		return result;
	}
	_tmp3_ = test_app_options_cjk_ambiguous_width_string;
	g_printerr ("Failed to parse \"%s\" argument to --cjk-width. Allowed values are \"n" \
"arrow\" or \"wide\".\n", _tmp3_);
	result = 1;
	return result;
}


void test_app_options_get_color_bg (GdkRGBA* result) {
	GdkRGBA color = {0};
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	memset (&color, 0, sizeof (GdkRGBA));
	_tmp0_ = test_app_options_transparency_percent;
	_tmp1_ = CLAMP (_tmp0_, 0, 100);
	color.alpha = ((gdouble) (100 - _tmp1_)) / 100.0;
	_tmp2_ = test_app_options_reverse;
	if (_tmp2_) {
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		color.blue = 1.0;
		_tmp3_ = color.blue;
		color.green = _tmp3_;
		_tmp4_ = color.green;
		color.red = _tmp4_;
	} else {
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		color.blue = 0.0;
		_tmp5_ = color.blue;
		color.green = _tmp5_;
		_tmp6_ = color.green;
		color.red = _tmp6_;
	}
	*result = color;
	return;
}


void test_app_options_get_color_fg (GdkRGBA* result) {
	GdkRGBA color = {0};
	gboolean _tmp0_ = FALSE;
	memset (&color, 0, sizeof (GdkRGBA));
	color.alpha = 1.0;
	_tmp0_ = test_app_options_reverse;
	if (_tmp0_) {
		gdouble _tmp1_ = 0.0;
		gdouble _tmp2_ = 0.0;
		color.blue = 0.0;
		_tmp1_ = color.blue;
		color.green = _tmp1_;
		_tmp2_ = color.green;
		color.red = _tmp2_;
	} else {
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		color.blue = 1.0;
		_tmp3_ = color.blue;
		color.green = _tmp3_;
		_tmp4_ = color.green;
		color.red = _tmp4_;
	}
	*result = color;
	return;
}


static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self) {
	GdkRGBA* dup;
	dup = g_new0 (GdkRGBA, 1);
	memcpy (dup, self, sizeof (GdkRGBA));
	return dup;
}


static gpointer __gdk_rgba_dup0 (gpointer self) {
	return self ? _gdk_rgba_dup (self) : NULL;
}


static GdkRGBA* test_app_options_get_color (const gchar* str) {
	GdkRGBA* result = NULL;
	const gchar* _tmp0_ = NULL;
	GdkRGBA color = {0};
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GdkRGBA* _tmp4_ = NULL;
	_tmp0_ = str;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	memset (&color, 0, sizeof (GdkRGBA));
	_tmp1_ = str;
	_tmp2_ = gdk_rgba_parse (&color, _tmp1_);
	if (!_tmp2_) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = str;
		g_printerr ("Failed to parse \"%s\" as color.\n", _tmp3_);
		result = NULL;
		return result;
	}
	_tmp4_ = __gdk_rgba_dup0 (&color);
	result = _tmp4_;
	return result;
}


GdkRGBA* test_app_options_get_color_cursor (void) {
	GdkRGBA* result = NULL;
	const gchar* _tmp0_ = NULL;
	GdkRGBA* _tmp1_ = NULL;
	_tmp0_ = test_app_options_cursor_color_string;
	_tmp1_ = test_app_options_get_color (_tmp0_);
	result = _tmp1_;
	return result;
}


GdkRGBA* test_app_options_get_color_hl_bg (void) {
	GdkRGBA* result = NULL;
	const gchar* _tmp0_ = NULL;
	GdkRGBA* _tmp1_ = NULL;
	_tmp0_ = test_app_options_hl_bg_color_string;
	_tmp1_ = test_app_options_get_color (_tmp0_);
	result = _tmp1_;
	return result;
}


GdkRGBA* test_app_options_get_color_hl_fg (void) {
	GdkRGBA* result = NULL;
	const gchar* _tmp0_ = NULL;
	GdkRGBA* _tmp1_ = NULL;
	_tmp0_ = test_app_options_hl_fg_color_string;
	_tmp1_ = test_app_options_get_color (_tmp0_);
	result = _tmp1_;
	return result;
}


VteCursorBlinkMode test_app_options_get_cursor_blink_mode (void) {
	VteCursorBlinkMode result = 0;
	VteCursorBlinkMode value = 0;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = test_app_options_cursor_blink_mode_string;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = test_app_options_cursor_blink_mode_string;
		_tmp2_ = test_app_options_parse_enum (vte_cursor_blink_mode_get_type (), _tmp1_);
		value = (VteCursorBlinkMode) _tmp2_;
	} else {
		value = VTE_CURSOR_BLINK_SYSTEM;
	}
	result = value;
	return result;
}


VteCursorShape test_app_options_get_cursor_shape (void) {
	VteCursorShape result = 0;
	VteCursorShape value = 0;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = test_app_options_cursor_shape_string;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = test_app_options_cursor_shape_string;
		_tmp2_ = test_app_options_parse_enum (vte_cursor_shape_get_type (), _tmp1_);
		value = (VteCursorShape) _tmp2_;
	} else {
		value = VTE_CURSOR_SHAPE_BLOCK;
	}
	result = value;
	return result;
}


VtePtyFlags test_app_options_get_pty_flags (void) {
	VtePtyFlags result = 0;
	VtePtyFlags flags = 0;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = test_app_options_pty_flags_string;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		_tmp1_ = test_app_options_pty_flags_string;
		_tmp2_ = test_app_options_parse_flags (vte_cursor_shape_get_type (), _tmp1_);
		flags = (VtePtyFlags) _tmp2_;
	} else {
		flags = VTE_PTY_DEFAULT;
	}
	result = flags;
	return result;
}


TestAppOptions* test_app_options_dup (const TestAppOptions* self) {
	TestAppOptions* dup;
	dup = g_new0 (TestAppOptions, 1);
	memcpy (dup, self, sizeof (TestAppOptions));
	return dup;
}


void test_app_options_free (TestAppOptions* self) {
	g_free (self);
}


GType test_app_options_get_type (void) {
	static volatile gsize test_app_options_type_id__volatile = 0;
	if (g_once_init_enter (&test_app_options_type_id__volatile)) {
		GType test_app_options_type_id;
		test_app_options_type_id = g_boxed_type_register_static ("TestAppOptions", (GBoxedCopyFunc) test_app_options_dup, (GBoxedFreeFunc) test_app_options_free);
		g_once_init_leave (&test_app_options_type_id__volatile, test_app_options_type_id);
	}
	return test_app_options_type_id__volatile;
}


static void test_app_class_init (TestAppClass * klass) {
	test_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TestAppPrivate));
	((GApplicationClass *) klass)->startup = test_app_real_startup;
	((GApplicationClass *) klass)->activate = test_app_real_activate;
	G_OBJECT_CLASS (klass)->finalize = test_app_finalize;
}


static void test_app_instance_init (TestApp * self) {
	self->priv = TEST_APP_GET_PRIVATE (self);
}


static void test_app_finalize (GObject* obj) {
	TestApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TEST_TYPE_APP, TestApp);
	_g_object_unref0 (self->priv->window);
	G_OBJECT_CLASS (test_app_parent_class)->finalize (obj);
}


GType test_app_get_type (void) {
	static volatile gsize test_app_type_id__volatile = 0;
	if (g_once_init_enter (&test_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestApp), 0, (GInstanceInitFunc) test_app_instance_init, NULL };
		GType test_app_type_id;
		test_app_type_id = g_type_register_static (gtk_application_get_type (), "TestApp", &g_define_type_info, 0);
		g_once_init_leave (&test_app_type_id__volatile, test_app_type_id);
	}
	return test_app_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



