/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <string.h>


/* black n white(0/1) are bad colors for nicks, and we'll use color 2 for us */
/* also light/dark gray (14/15) */
/* 5,7,8 are all shades of yellow which happen to look dman near the same */
char rcolors[16]={0,0,0,1,1,0,1,0,1,1,1,1,1,1,0,0};

struct _color_age {
   char nick[64];
   int age;
} color_age[16];


int color_of(char *name)
{
   int i, oldest, already_has_color;
   oldest = 0;
   already_has_color = 0;
   for (i = 0; i < 16; i++)
   {
      if (!rcolors[i]) continue;
      if (strcasecmp(color_age[i].nick, name) == 0) 
      {
	 color_age[i].age = 0;
	 already_has_color = i;
      }
      if (color_age[i].age < 1000) color_age[i].age++;
      if (color_age[i].age > color_age[oldest].age) oldest = i;
   }
   if (already_has_color) return already_has_color;
   strcpy(color_age[oldest].nick, name);
   color_age[oldest].age = 0;
   return oldest;
}
