/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#undef USE_GNOME
#include "style.h"
#include "xchat.h"
#include "gtkutil.h"
#include <time.h>
#include <sys/time.h>
#include <arpa/inet.h>
#include <fcntl.h>


extern GSList *sess_list;
extern GSList *dialog_list;
extern struct xchatprefs prefs;
extern GdkFont *dialog_font_normal;
extern GdkFont *dialog_font_bold;
extern GdkColor colors[];
extern GtkStyle *channelwin_style;
extern GtkStyle *dialogwin_style;
extern GtkWidget *main_window;
extern GtkWidget *main_book;

extern int handle_command(char *cmd, struct session *sess, int history);
extern unsigned char *strip_color(unsigned char *text);
extern void end_logging (int fd);
extern int open_log_file (char *servname, char *channame);
extern GtkStyle *my_widget_get_style(GtkStyle *oldstyle, char *bg_pic, int bg_color);
extern struct sockaddr_in *dcc_write_chat(char *nick, char *text);
struct dialog *new_dialog(struct server *serv, char *nick);
extern void dcc_send_filereq(struct session *sess, char *nick);
extern void PrintTextRaw(GtkWidget *textwidget, unsigned char *text, char, char, GdkFont *normal, GdkFont *bold);
extern void PrintTextRawZvt(GtkWidget *textwidget, unsigned char *text);
extern void zvt_set_style(GtkWidget *zvt, char *bg_pic, int trans, int tint,
		   GdkFont *norm_font, GdkFont *bold_font);


struct dialog *find_dialog(struct server *serv, char *nick)
{
   GSList *list = dialog_list;
   struct dialog *dial;
   while(list)
   {
      dial = (struct dialog *)list -> data;
      if(dial->serv == serv)
      {
	 if(!strcasecmp(nick, dial->nick)) return(dial);
      }
      list = list -> next;
   }
   return 0;
}

void dialog_print(struct dialog *dial, char *text)
{
   /*if(dial->zvt)
     PrintTextRawZvt( dial->listgad, outbuf );
    else*/
   if (dial->logfd != -1) {
   	char *temp = strip_color(text);
	write (dial->logfd, temp, strlen(temp));
	free(temp);
   }
   PrintTextRaw( dial->listgad, text,
		prefs.dialog_bg_color, prefs.dialog_fg_color,
		dialog_font_normal, dialog_font_bold );
}

void dialog_change_nick(struct server *serv, char *nick, char *newnick)
{
   struct dialog *dial = find_dialog(serv, nick);
   if(dial)
   {
      strcpy(dial->nick, newnick);
      gtk_window_set_title(GTK_WINDOW(dial->window), newnick);
   }
}

int add_to_dialog(struct server *serv, char *outbuf, char *nick, char *text, char *ip, int type)
{
   struct dialog *dial = find_dialog(serv, nick);
   if(!dial)
   {
      if((prefs.autodialog) && type==0) dial = new_dialog(serv, nick);
   }
   if(!dial) return(FALSE);

   if (!strncmp(text, "\001ACTION",7 ))
   {
      char *po;
      text += 8;
      type = 2;
      po = strchr(text, 1);
      if(po) *po = 0;
   }

   switch(type)
   {
    case 0:
      sprintf(outbuf, CHANNEL_MSG, nick, text);
      break;
    case 1:
      sprintf(outbuf, "\00312-\00313%s\00312- \003 %s\n", nick, text);
      break;
    case 2:
      sprintf(outbuf, ACTION_TEXT, nick, text);
      break;
    case 3:
      dialog_print(dial, text);
      return TRUE;
   }

   dialog_print(dial, outbuf);

   if(dial->ip[0] == 0)
   {
      strcpy(dial->ip, ip);
      gtk_entry_set_text(GTK_ENTRY(dial->ipgad), ip);
   }

   return(TRUE);
}

void dialog_add_line(struct dialog *dial, char *text)
{
   struct sockaddr_in *ip;
   char outbuf[2356];
   char *actionText = 0;

   if(*text == 0) return;

   history_add(&dial->history, text);

   if(!strncasecmp(text, "/ME ", 4))
   {
      actionText = malloc(strlen(text) + 10);
      sprintf(actionText, "\001ACTION %s\001\r\n", text + 4);
   }

   if(*text == '/' && !actionText)
   {
      struct session *sess = dial->serv->front_session;
      GtkWidget *win;

      if(sess->is_tab)
      {
	 gint n;
	 win = main_window;
	 n = gtk_notebook_page_num((GtkNotebook*)main_book, sess->window);
	 gtk_notebook_set_page((GtkNotebook*)main_book, n);
      } else
	win = sess->window;
      gdk_window_raise(win->window);
      handle_command(text, sess, FALSE);

   } else {
      if(actionText)
	ip = dcc_write_chat(dial->nick, actionText);
      else
	ip = dcc_write_chat(dial->nick, text);
      if(ip)
      {
	 if(dial->ip[0] == 0)
         {
	    strcpy(dial->ip, inet_ntoa(ip->sin_addr));
	    gtk_entry_set_text(GTK_ENTRY(dial->ipgad), dial->ip);
	 }
      } else {
	 if(!dial->serv->connected)
	 {
	    dialog_print(dial, "Not Connected.\n");
	    if(actionText) free(actionText);
	    return;
	 }
	 if(actionText)
	   sprintf(outbuf, "PRIVMSG %s :%s", dial->nick, actionText);
	 else
	   sprintf(outbuf, "PRIVMSG %s :%s\r\n", dial->nick, text);
	 send(dial->serv->sok, outbuf, strlen(outbuf), 0);
      }

      if (actionText)
	sprintf(outbuf, ACTION_TEXT, dial->serv->nick, text + 4);
      else
	sprintf(outbuf, CHANNEL_MSG_FROM_USER, dial->serv->nick, text);
      dialog_print(dial, outbuf);

      if(actionText) free(actionText);
   }
}

void handle_dialog(GtkWidget *igad, struct dialog *dial)
{
   char *cr;
   char *cmd = gtk_entry_get_text((GtkEntry *)igad);

   if(cmd[0] == 0) return;

   cr = strchr(cmd, '\n');
   if(cr)
   {
      while(1)
      {
	 if(cr) *cr = 0;
	 dialog_add_line(dial, cmd);
	 if(!cr) break;
	 cmd = cr + 1;
	 if(*cmd == 0) break;
	 cr = strchr(cmd, '\n');
      }
   } else
     dialog_add_line(dial, cmd);

   gtk_entry_set_text((GtkEntry *)igad, "");
}

void dialog_whois(GtkWidget *wid, struct dialog *dial)
{
   char tbuf[256];
   sprintf(tbuf, "WHOIS %s\r\n", dial->nick);
   send(dial->serv->sok, tbuf, strlen(tbuf), 0);
}

void dialog_send(GtkWidget *wid, struct dialog *dial)
{
   GSList *list = sess_list;
   struct session *sess;
   while(list)
   {
      sess = (struct session *)list->data;
      if(sess->server == dial->serv)
      {
	 dcc_send_filereq(sess, dial->nick);
	 return;
      }
      list = list->next;
   }
}

void dialog_ping(GtkWidget *wid, struct dialog *dial)
{
   if(dial->serv->connected)
   {
      char tbuf[256];
      unsigned long tim;
      struct timeval timev;

      gettimeofday(&timev, 0);
      tim = (timev.tv_sec - 50000) * 1000000 + timev.tv_usec;

      sprintf(tbuf, "PRIVMSG %s :\001PING %lu\001\r\n", dial->nick, tim);
      send(dial->serv->sok, tbuf, strlen(tbuf), 0); 
   }
}

void dialog_clear(GtkWidget *wid, struct dialog *dial)
{
   /*if(!dial->zvt)*/
     gtk_text_backward_delete((GtkText *)dial->listgad,
			    gtk_text_get_length((GtkText *)dial->listgad));
}

void close_dialog(GtkWidget *wid, struct dialog *dial)
{
   gtk_widget_destroy(dial->window);
   dialog_list = g_slist_remove(dialog_list, dial);
   history_free(&dial->history);
   if (dial->logfd != -1)
   	end_logging(dial->logfd);
   free(dial);
}

/* this server is being removed, close all dialogs associated with it */

void dialog_notify_kill(struct server *serv)
{
   GSList *list = dialog_list;
   struct dialog *dial;

   while(list)
   {
      dial = (struct dialog *)list->data;
      if(dial->serv == serv)
      {
	 gtk_signal_disconnect_by_data(GTK_OBJECT(dial->window), dial);
	 close_dialog(0, dial);
	 dialog_notify_kill(serv);
	 return;
      }
      list = list -> next;
   }
}

void open_dialog_window(struct dialog *dial)
{
   GtkWidget *hbox, *vbox, *wid;

   dial->window = gtkutil_window_new(dial->nick, 300, 100,
				     close_dialog, dial);
   
   vbox = gtk_vbox_new(FALSE, 0);
   gtk_container_border_width(GTK_CONTAINER(vbox), 3);
   gtk_container_add(GTK_CONTAINER(dial->window), vbox);
   gtk_widget_show(vbox);
   
   hbox = gtk_hbox_new(FALSE, 0);
   gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
   gtk_widget_show(hbox);

   wid = gtk_button_new_with_label("WhoIs");
   gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(dialog_whois), dial);
   gtk_widget_show(wid);
   
   wid = gtk_button_new_with_label("Send");
   gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(dialog_send), dial);
   gtk_widget_show(wid);

   dial->ipgad = gtk_entry_new();
   gtk_entry_set_editable((GtkEntry *)dial->ipgad, FALSE);
   gtk_container_add(GTK_CONTAINER(hbox), dial->ipgad);
   gtk_widget_show(dial->ipgad);

   wid = gtk_button_new_with_label("Ping");
   gtk_box_pack_end(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(dialog_ping), dial); 
   gtk_widget_show(wid);

   wid = gtk_button_new_with_label("Clear");
   gtk_box_pack_end(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(dialog_clear), dial);
   gtk_widget_show(wid);

   hbox = gtk_hbox_new(FALSE, 0);
   gtk_container_add(GTK_CONTAINER(vbox), hbox);
   gtk_widget_show(hbox);

/*   if(prefs.dialogzvt)
   {
      dial->zvt = TRUE;
      dial->listgad = zvt_term_new();
      zvt_set_style(dial->listgad, prefs.background_dialog, prefs.transparent_dialog,
		    prefs.tint_dialog, dialog_font_normal, dialog_font_bold);
      gtk_container_add(GTK_CONTAINER(hbox), dial->listgad);
      gtk_widget_show(dial->listgad);

      wid = gtk_vscrollbar_new (ZVT_TERM(dial->listgad)->adjustment);
   } else {*/
      dial->listgad = gtk_text_new(0, 0);
      if(!dialogwin_style)
	dialogwin_style = my_widget_get_style(0, prefs.background_dialog, prefs.dialog_bg_color);
      gtk_widget_set_style(dial->listgad, dialogwin_style);
      gtk_text_set_word_wrap(GTK_TEXT(dial->listgad), TRUE);
      /*gtk_text_set_editable(GTK_TEXT(dial->listgad), FALSE);*/
      gtk_container_add(GTK_CONTAINER(hbox), dial->listgad);
      gtk_widget_show(dial->listgad);
   
      wid = gtk_vscrollbar_new(GTK_TEXT(dial->listgad)->vadj);
   /*}*/
   gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
   gtk_widget_show(wid);

   gtk_widget_realize(dial->listgad);

   dial->inputgad = gtk_entry_new_with_max_length( 2048 );
   gtk_box_pack_end(GTK_BOX(vbox), dial->inputgad, FALSE, FALSE, 0);
   gtk_signal_connect(GTK_OBJECT(dial->inputgad), "activate",
		      GTK_SIGNAL_FUNC(handle_dialog), dial);
   gtk_signal_connect(GTK_OBJECT(dial->inputgad), "key_press_event",
		      GTK_SIGNAL_FUNC(history_keypress), &dial->history);
   gtk_widget_show(dial->inputgad);
   gtk_widget_grab_focus(dial->inputgad);

   gtk_widget_show(dial->window);
}

struct dialog *new_dialog(struct server *serv, char *nick)
{
   struct dialog *dial;

   dial = malloc(sizeof(struct dialog));
   if(!dial) return 0;
   memset(dial, 0, sizeof(struct dialog));
   dial->serv = serv;
   if (prefs.logging)
   	dial->logfd = open_log_file(serv->servername, nick);
   else
   	dial->logfd = -1;
   strcpy(dial->nick, nick);
   open_dialog_window(dial);

   dialog_list = g_slist_append(dialog_list, dial);

   return(dial);
}
