/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

/* LASTLOG by Erik Scrafford <eriks@chilisoft.com>. */

#undef USE_GNOME
#include "style.h"
#include "xchat.h"
#include "gtkutil.h"


extern GdkFont *dialog_font_normal;
extern GdkColor colors[];
extern GtkStyle *dialogwin_style;
extern struct xchatprefs prefs;

extern char *nocasestrstr(char *text, char *tofind);
extern GtkStyle *my_widget_get_style(GtkStyle *oldstyle, char *bg_pic, int bg_color);


GtkWidget *lastlog_window, *lastlog_text;
struct session *lastlog_last_sess = 0;


void search_lastlog(struct session *_sess, char *search)
{
   char title[270];
   char line[512];
   char *start, *realstart, *end;
   struct session *sess;

   if (_sess == NULL) { sess = lastlog_last_sess; } else { sess = _sess; lastlog_last_sess = _sess; }
   gtk_text_backward_delete(GTK_TEXT(lastlog_text), gtk_text_get_length(GTK_TEXT(lastlog_text)));
   if (search == NULL) return;

   if(sess->zvt)
   {
      gtkutil_simpledialog("Lastlog doesn't work with zvt.");
      return;
   }

   realstart = start = gtk_editable_get_chars((GtkEditable*)sess->textgad, 0, -1);
   gtk_text_freeze(GTK_TEXT(lastlog_text));
   while ((end = strchr(start, '\n')) && ((end - start) <= GTK_TEXT(sess->textgad)->gap_position))
   {
      strncpy(line, start, end-start);
      line[end-start] = 0;
      if (nocasestrstr(line, search))   
      {
	 strcat(line, "\n");
	 gtk_text_insert(GTK_TEXT(lastlog_text), dialog_font_normal, &colors[prefs.dialog_fg_color], &colors[prefs.dialog_bg_color], line, strlen(line));
      }
      start=++end;
   }
   g_free(realstart);
   gtk_text_thaw(GTK_TEXT(lastlog_text));

   {
     GtkAdjustment *adj = (GTK_TEXT(lastlog_text))->vadj;
     gtk_adjustment_set_value(adj, adj->upper - adj->lower - adj->page_size);
   }

   sprintf(title, "Lastlog - %s", search);
   gtk_window_set_title(GTK_WINDOW(lastlog_window), title);
}

void hide_lastlog(GtkWidget *wid, gpointer *data)
{
   if(lastlog_window)
   {
      gtk_widget_destroy(lastlog_window);
      lastlog_window = NULL;
   }
}

void lastlog_entry(GtkWidget *wid, gpointer *data)
{
   /*search_lastlog(NULL, GTK_ENTRY(wid)->text);*/
   search_lastlog(NULL, gtk_entry_get_text(GTK_ENTRY(wid)));
   gtk_entry_set_text(GTK_ENTRY(wid), "");
   /*gtk_editable_delete_text(GTK_EDITABLE(wid), 0, 255);*/
   /*   gtk_editable_delete_selection(GTK_EDITABLE(wid));*/
}

void show_lastlog_window(void)
{
   GtkWidget *hbox, *vbox, *wid, *lastlog_input;

   if (lastlog_window == NULL)
   {
      lastlog_window = gtkutil_window_new("Lastlog", 400, 500,
					  hide_lastlog, lastlog_window);
      gtk_window_set_policy(GTK_WINDOW(lastlog_window), TRUE, TRUE, FALSE);

      vbox = gtk_vbox_new(FALSE, 0);
      gtk_container_border_width(GTK_CONTAINER(vbox), 3);
      gtk_container_add(GTK_CONTAINER(lastlog_window), vbox);
      gtk_widget_show(vbox);
      
      hbox = gtk_hbox_new(FALSE, 0);
      gtk_container_add(GTK_CONTAINER(vbox), hbox);
      gtk_widget_show(hbox);

      lastlog_text = gtk_text_new(0, 0);
      if(!dialogwin_style)
	dialogwin_style = my_widget_get_style(0, prefs.background_dialog, prefs.dialog_bg_color); 
      gtk_widget_set_style(lastlog_text, dialogwin_style);
      gtk_text_set_word_wrap(GTK_TEXT(lastlog_text), TRUE);
      gtk_text_set_editable(GTK_TEXT(lastlog_text), FALSE);
      gtk_container_add(GTK_CONTAINER(hbox), lastlog_text);
      gtk_widget_show(lastlog_text);
      
      wid = gtk_vscrollbar_new(GTK_TEXT(lastlog_text)->vadj);
      gtk_box_pack_start(GTK_BOX(hbox), wid, FALSE, FALSE, 0);
      gtk_widget_show(wid);
      
      lastlog_input = gtk_entry_new_with_max_length( 255 );
      gtk_box_pack_end(GTK_BOX(vbox), lastlog_input, FALSE, FALSE, 0);
      gtk_signal_connect(GTK_OBJECT(lastlog_input), "activate", GTK_SIGNAL_FUNC(lastlog_entry), NULL);
      gtk_widget_show(lastlog_input);
      gtk_widget_grab_focus(lastlog_input);

      gtk_widget_show(lastlog_window);
   }
}
