/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "xchat.h"
#include <ctype.h>
#ifdef USE_GNOME
#include <zvt/zvtterm.h>
#endif
#include <time.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>

/*extern int log_file;*/
extern GSList *sess_list;
extern GdkColor colors[];
extern GdkFont *font_normal;
extern GdkFont *font_bold;
extern GdkFont *dialog_font_normal;
extern GdkFont *dialog_font_bold;
extern GtkStyle *normaltab_style;
extern GtkStyle *redtab_style;
extern struct xchatprefs prefs;
extern struct session *current_tab;


long timecat(char *buf)
{
   time_t timval = time(0);
   char *tim = ctime(&timval) + 11;
   tim[9] = 0;
   strcat(buf, tim);
   return strlen(buf);
}

unsigned char *strip_color(unsigned char *text)
{
   int comma, done;
   int j = 0, i = 0, len = strlen(text);
   char *buf = malloc(len + 2);

   while(i < len)
   {
      switch(text[i])
      {
       case 2:
	 break;
       case 3:
	 comma = FALSE;
	 done = FALSE;
	 while(i < len && !done)
	 {
	    i++;
	    if(!isdigit(text[i]))
	    {
	       switch(text[i])
	       {
		case ',':
		  if(comma) done = TRUE; else comma = TRUE;
		  break;
		case ' ':
		  done = TRUE;
		  i++;
		  break;
		default:
		  done = TRUE;
	       }
	    }
	 }
	 i--;
	 break;
       default:
	 buf[j] = text[i];
	 j++;
      }
      i++;
   }
   buf[j] = 0;
   
   return buf;
}


#ifdef USE_GNOME

/*                0  1  2  3  4  5  6  7  8     9     10 11    12    13    14 */
int colconv[] = { 7, 0, 4, 2, 1, 3, 5, 3, 3+10, 2+10, 6, 6+10, 4+10, 5+10, 10+0, 0 };

void PrintTextRawZvt(GtkWidget *textwidget, unsigned char *text)
{
   int dotime = FALSE;
   char num[8];
   int comma, k, i = 0, j = 0, len = strlen(text);
   unsigned char *newtext = malloc(len + 1024);
/*
   if(log_file != -1)
   {
      char *temp = strip_color(text);
      write(log_file, temp, strlen(temp));
      free(temp);
   }*/

   if(prefs.timestamp)
   {
      newtext[0] = 0;
      j = timecat(newtext);
   }

   while(i < len)
   {
      if(dotime && text[i] != 0)
      {
	 dotime = FALSE;
	 newtext[j] = 0;
	 j = timecat(newtext);
      }
      switch(text[i])
      {
       case 3:
	 i++;
	 if(text[i] == ' ')
	 {
	    newtext[j] = 27; j++;
	    newtext[j] = '['; j++;
	    newtext[j] = '0'; j++;
	    newtext[j] = 'm'; j++;
	    goto jump2;
	 }
	 k = 0;
	 comma = FALSE;
	 while(i < len)
	 {
	    if(text[i] >= '0' && text[i] <= '9' && k < 2)
	    {
	       num[k] = text[i];
	       k++;
	    } else {
	       int col, mirc;
	       num[k] = 0;
	       newtext[j] = 27; j++;
	       newtext[j] = '['; j++;
	       if(k == 0)
	       {
		  newtext[j] = '0'; j++;
		  newtext[j] = 'm'; j++;
	       } else {
		  if(comma) col = 40; else col = 30;
		  mirc = atoi(num);
		  mirc = colconv[mirc];
		  if(mirc > 9)
	          {
		     mirc -= 10;
		     sprintf((char *)&newtext[j], "1;%dm", mirc + col);
		  } else {
		     sprintf((char *)&newtext[j], "0;%dm", mirc + col);
		  }
		  j = strlen(newtext);
	       }
	       switch(text[i])
	       {
		case ',': comma = TRUE; break;
		default: goto jump;
	       }
	       k = 0;
	    }
	    i++;
	 }
	 break;
       case '\007':
	 if(!prefs.filterbeep)
	 {
	    newtext[j] = text[i];
	    j++;
	 }
	 break;
       case '\n':
	 newtext[j] = '\r';
	 j++;
	 if(prefs.timestamp) dotime = TRUE;
       default:
	 newtext[j] = text[i];
	 j++;
      }
      jump2:
      i++;
      jump:
   }
   newtext[j] = 0;
   zvt_term_feed((ZvtTerm*)textwidget, newtext, j);
   free(newtext);
}

#else

void PrintTextRawZvt(GtkWidget *textwidget, unsigned char *text)
{
}

#endif

void cut_down_text(GtkWidget *textwidget)
{
   if(prefs.bufsize > 0)
   {
      long n = gtk_text_get_length((GtkText*)textwidget);			 
      if(n > prefs.bufsize)
      {
	 gtk_text_set_point((GtkText*)textwidget, n - prefs.bufsize);
	 gtk_text_backward_delete((GtkText*)textwidget, n - prefs.bufsize);
	 gtk_text_set_point((GtkText*)textwidget, gtk_text_get_length((GtkText*)textwidget));
      }
   }
}

void PrintTextRaw(GtkWidget *textwidget, unsigned char *text,
		  char bg, char fg,
		  GdkFont *fontnorm,
		  GdkFont *fontbold)
{
   int dotime = FALSE;
   int esc = FALSE;
   int comma = FALSE;
   unsigned char buf[4096];
   unsigned char num[4];
   int bcol = bg, col = fg, j = 0, i = 0, k = 0;
   int scroll = FALSE;
   GtkAdjustment *adj;
   GdkFont *font = fontnorm;
   int bold = FALSE;

   adj = (GTK_TEXT(textwidget))->vadj;
   if(adj->value == adj->upper - adj->lower - adj->page_size) scroll = TRUE;

   if(prefs.timestamp)
   {
      buf[0] = 0;
      j = timecat(buf);
   }

   gtk_text_freeze (GTK_TEXT(textwidget));
   while(1)
   {
      if(dotime && text[i] != 0)
      {
	 dotime = FALSE;
	 buf[j] = 0;
	 j = timecat(buf);
      }
      if(esc)
      {
	 if(text[i] == ' ')
	 {
	    esc = FALSE; bcol = bg; col = fg;
	 } else {
	    while(text[i] >= '0' && text[i] <= '9' && k < 2)
	    {
	       num[k] = text[i];
	       k++; i++;
	    }
	    num[k] = 0; k = 0;
	    switch(text[i])
	    {
	     case ',':
	       comma = TRUE;
	       col = atoi(num);
	       if(col < 0 || col > 15) col = 1;
	       break;
	     default:
	       if(comma)
	       {
		  comma = FALSE;
		  bcol = atoi(num);
		  if(bcol < 0 || bcol > 15) bcol = bg;
	       } else {
		  col = atoi(num);
		  if(col < 0 || col > 15) col = fg;
	       }
	       if(bcol == 1 && col == 1) col = 0;
	       if(bcol == 0 && col == 0) col = 1;
	       goto norm;
	    }
	 }
      } else {
norm:
	 switch(text[i])
	 {
	  case 0:
	    goto jump;
	  case 3: /* CTRL-C */
	    buf[j] = 0;
	    if(j>0)
	    {
	       gtk_text_insert(GTK_TEXT(textwidget), font, &colors[col], &colors[bcol],  buf, j);
	       j = 0;
	    }
	    esc = TRUE; k = 0;
	    break;
	  case '\007': /* beep */
	    if(!prefs.filterbeep)
	    {
	       buf[j] = 7; j++;
	       buf[j] = 0;
	       gtk_text_insert(GTK_TEXT(textwidget), font, &colors[col], &colors[bcol],  buf, j);
	       j = 0;
	       gdk_beep();
	    }
	    break;
	  case '\026': /* REVERSE */
	  case '\037': /* UNDERLINE */
	  case '\002': /* BOLD */
	    buf[j] = 0;
	    if(j>0)
	    {
	       gtk_text_insert(GTK_TEXT(textwidget), font, &colors[col], &colors[bcol],  buf, j);
	       j = 0;
	    }
	    if(bold)
	    {
	       bold = FALSE;
	       font = fontnorm;
	    } else {
	       bold = TRUE;
	       font = fontbold;
	    }
	    break;
	  case '\017': /* ALL OFF */
	    buf[j] = 0;
	    if(j>0)
	    {
	       gtk_text_insert(GTK_TEXT(textwidget), font, &colors[col], &colors[bcol],  buf, j);
	       j = 0;
	    }
	    font = fontnorm;
	    break;
	  default:
	    esc = FALSE;
	    comma = FALSE;
	    buf[j] = text[i];
	    j++;
	    if(j == 4095) j = 4094;
	    if(text[i] == '\n' && prefs.timestamp) dotime = TRUE;
	 }
      }
      i++;
   }
   jump:
   if(j)
   {
      gtk_text_insert(GTK_TEXT(textwidget), font, &colors[col], &colors[bcol], buf, j);
      cut_down_text(textwidget);
      gtk_text_thaw(GTK_TEXT(textwidget));
      if(scroll)
	gtk_adjustment_set_value(adj, adj->upper - adj->lower - adj->page_size);
   } else {
      cut_down_text(textwidget);
      gtk_text_thaw(GTK_TEXT(textwidget));
   }
}

void PrintText(struct session *sess, unsigned char *text)
{
   if(!sess) sess = (struct session *)sess_list->data;

   if(sess->logfd != -1 && prefs.logging)
   {
      char *temp = strip_color(text);
      write(sess->logfd, temp, strlen(temp));
      free(temp);
   }

   if(sess->zvt)
     PrintTextRawZvt(sess->textgad, text);
   else  
     PrintTextRaw(sess->textgad, text, prefs.bg_color, prefs.fg_color,
		font_normal, font_bold);

   if(!sess->new_data && sess != current_tab && sess->is_tab)
   {
      sess->new_data = TRUE;
      gtk_widget_set_style(sess->changad, redtab_style);
   }
}

void	end_logging (int fd)
{
	char	obuf[512];
	time_t	currenttime;
	
	currenttime = time(NULL);
	write(fd, obuf, snprintf(obuf, 510, "**** ENDING LOGGING AT %s\n", ctime(&currenttime)));
	close(fd);
}

int	open_log_file (char *servname, char *channame)
{
	char	buf[512];
	int	fd;
	time_t	currenttime;
        struct  stat st;

        snprintf(buf, 510, "%s/.xchat/logs", getenv("HOME"));
        if(stat(buf, &st) < 0)
                mkdir(buf, S_IRUSR | S_IWUSR | S_IXUSR);

	snprintf(buf, 510, "%s/.xchat/logs/%s-%s.xchatlog", getenv("HOME"), servname, channame);
	fd = open(buf, O_CREAT | O_APPEND | O_WRONLY, 0x180);
	if (fd < 0)
		return -1;
	currenttime = time(NULL);
	write(fd, buf, snprintf(buf, 510, "**** BEGIN LOGGING AT %s\n", ctime(&currenttime)));

	return fd;
}

void	setup_logging (struct session *sess)
{
	if (sess->logfd != -1)
		end_logging(sess->logfd);
	sess->logfd = open_log_file(sess->server->servername, sess->channel);
}
