/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "xchat.h"
#include <fcntl.h>
#include <pwd.h>
#include <sys/stat.h>
#include "cfgfiles.h"
#include "gtkutil.h"


extern struct xchatprefs prefs;


char *
cfg_get_str (char *cfg, char *var, char *dest)
{
   *dest = 0;
   while (1)
   {
      if (!strncasecmp (var, cfg, strlen (var)))
      {
         char *value, t;
         cfg += strlen (var);
         while (*cfg == ' ' || *cfg == '=')
            cfg++;
         value = cfg;
         while (*cfg != 0 && *cfg != '\n')
            cfg++;
         t = *cfg;
         *cfg = 0;
         strcpy (dest, value);
         *cfg = t;
         return cfg;
      }
      while (*cfg != 0 && *cfg != '\n')
         cfg++;
      if (*cfg == 0)
         return 0;
      cfg++;
      if (*cfg == 0)
         return 0;
   }
}

static void
cfg_put_str (int fh, char *var, char *value)
{
   char buf[512];

   snprintf (buf, sizeof buf, "%s= %s\n", var, value);
   write (fh, buf, strlen (buf));
}

static void
cfg_put_int (int fh, int value, char *var)
{
   char buf[400];

   if (value == -1)
      value = 1;

   snprintf (buf, sizeof buf, "%s= %d\n", var, value);
   write (fh, buf, strlen (buf));
}

static int
cfg_get_int (char *cfg, char *var)
{
   char str[128];

   cfg_get_str (cfg, var, str);

   return atoi (str);
}

char *
get_xdir (void)
{
   static char xdir[128];
   snprintf (xdir, sizeof xdir, "%s/.xchat", g_get_home_dir ());
   return (xdir);
}

void
check_prefs_dir (void)
{
   struct stat st;
   char *xdir = get_xdir ();
   if (stat (xdir, &st) < 0)
   {
      if (mkdir (xdir, S_IRUSR | S_IWUSR | S_IXUSR) != 0)
         gtkutil_simpledialog ("Cannot create ~/.xchat");
   }
}

static char *
default_file (void)
{
   static char file[142];
   snprintf (file, sizeof file, "%s/.xchat/xchat.conf", g_get_home_dir ());
   return (file);
}

void
load_config (void)
{
   GtkWidget *dialog;
   struct stat st;
   char *cfg, *username;
   int fh, am_root = 0;

   memset (&prefs, 0, sizeof (struct xchatprefs));

   check_prefs_dir ();
   username = g_get_user_name ();

   fh = open (default_file (), O_RDONLY);
   if (fh != -1)
   {
      fstat (fh, &st);
      cfg = malloc (st.st_size);
      if (cfg)
      {
         read (fh, cfg, st.st_size);

         /* strings */
         cfg_get_str (cfg, "nickname1 ", prefs.nick1);
         cfg_get_str (cfg, "nickname2 ", prefs.nick2);
         cfg_get_str (cfg, "nickname3 ", prefs.nick3);
         cfg_get_str (cfg, "realname ", prefs.realname);
         cfg_get_str (cfg, "username ", prefs.username);
         cfg_get_str (cfg, "awayreason ", prefs.awayreason);
         cfg_get_str (cfg, "quitreason ", prefs.quitreason);
         cfg_get_str (cfg, "font_normal ", prefs.font_normal);
         cfg_get_str (cfg, "font_bold ", prefs.font_bold);
         cfg_get_str (cfg, "font_dialog_normal ", prefs.dialog_font_normal);
         cfg_get_str (cfg, "font_dialog_bold ", prefs.dialog_font_bold);
         cfg_get_str (cfg, "sounddir ", prefs.sounddir);
         cfg_get_str (cfg, "soundcmd ", prefs.soundcmd);
         cfg_get_str (cfg, "background_pic ", prefs.background);
         cfg_get_str (cfg, "background_dialog_pic ", prefs.background_dialog);
         cfg_get_str (cfg, "dccdir ", prefs.dccdir);
         cfg_get_str (cfg, "doubleclickuser ", prefs.doubleclickuser);
         cfg_get_str (cfg, "bluestring ", prefs.bluestring);

         /* booleans */
         prefs.autosave = cfg_get_int (cfg, "autosave ");
         prefs.autodialog = cfg_get_int (cfg, "autodialog ");
         prefs.autoreconnect = cfg_get_int (cfg, "autoreconnect ");
         prefs.invisible = cfg_get_int (cfg, "invisible ");
         prefs.servernotice = cfg_get_int (cfg, "servernotice ");
         prefs.wallops = cfg_get_int (cfg, "wallops ");
         prefs.skipmotd = cfg_get_int (cfg, "skipmotd ");
         prefs.autorejoin = cfg_get_int (cfg, "autorejoin ");
         prefs.colorednicks = cfg_get_int (cfg, "colorednicks ");
         prefs.nochanmodebuttons = cfg_get_int (cfg, "nochanmodebuttons ");
         prefs.nouserlistbuttons = cfg_get_int (cfg, "nouserlistbuttons ");
         prefs.nickcompletion = cfg_get_int (cfg, "nickcompletion ");
         prefs.tabnicks = cfg_get_int (cfg, "tabnicks ");
         prefs.tabchannels = cfg_get_int (cfg, "tabchannels ");
         prefs.nopaned = cfg_get_int (cfg, "nopaned ");
         prefs.autodccchat = cfg_get_int (cfg, "autodccchat ");
         prefs.autodccsend = cfg_get_int (cfg, "autodccsend ");
         prefs.noautoopendccsendwindow = cfg_get_int (cfg, "noautoopendccsendwindow ");
         prefs.noautoopendccrecvwindow = cfg_get_int (cfg, "noautoopendccrecvwindow ");
         prefs.transparent = cfg_get_int (cfg, "transparent ");
         prefs.tint = cfg_get_int (cfg, "tint ");
         prefs.zvt = cfg_get_int (cfg, "zvt ");
         prefs.dialog_transparent = cfg_get_int (cfg, "dialog_transparent ");
         prefs.dialog_tint = cfg_get_int (cfg, "dialog_tint ");
         prefs.dialog_zvt = cfg_get_int (cfg, "dialog_zvt ");
         prefs.stripcolor = cfg_get_int (cfg, "stripcolor ");
         prefs.timestamp = cfg_get_int (cfg, "timestamp ");
         prefs.fastdccsend = cfg_get_int (cfg, "fastdccsend ");
         prefs.skipserverlist = cfg_get_int (cfg, "skipserverliset ");
         prefs.filterbeep = cfg_get_int (cfg, "filterbeep ");
         prefs.bg_color = cfg_get_int (cfg, "bg_color ");
         prefs.fg_color = cfg_get_int (cfg, "fg_color ");
         prefs.dialog_bg_color = cfg_get_int (cfg, "bg_dialog_color ");
         prefs.dialog_fg_color = cfg_get_int (cfg, "fg_dialog_color ");
         prefs.dccwithnick = cfg_get_int (cfg, "dccwithnick ");
         prefs.hilitenotify = cfg_get_int (cfg, "hilight_notify ");
         prefs.tabsatbottom = cfg_get_int (cfg, "tabsatbottom ");
         prefs.beepmsg = cfg_get_int (cfg, "beep_msg ");
         prefs.privmsgtab = cfg_get_int (cfg, "priv_msg_tabs ");
         prefs.logging = cfg_get_int (cfg, "logging ");
         prefs.newtabstofront = cfg_get_int (cfg, "newtabs_to_front ");
         prefs.hidever = cfg_get_int (cfg, "hide_version ");
         prefs.get_ip_from_server = cfg_get_int (cfg, "get_ip_from_server ");
         prefs.panelize_hide = cfg_get_int (cfg, "panelize_hide ");
         prefs.panel_vbox = cfg_get_int (cfg, "panel_vbox ");
         prefs.raw_modes = cfg_get_int (cfg, "raw_modes ");
         prefs.no_server_logs = cfg_get_int (cfg, "no_server_logs ");
         prefs.show_away_once = cfg_get_int (cfg, "show_away_once ");
         prefs.emacs_key_bindings = cfg_get_int (cfg, "emacs_key_bindings ");

         /* numbers */
         prefs.bufsize = cfg_get_int (cfg, "buffer_size ");
         prefs.notify_timeout = cfg_get_int (cfg, "notify_timeout ");
         prefs.bg_color = cfg_get_int (cfg, "bg_color ");
         prefs.fg_color = cfg_get_int (cfg, "fg_color ");
         prefs.dialog_bg_color = cfg_get_int (cfg, "bg_dialog_color ");
         prefs.dialog_fg_color = cfg_get_int (cfg, "fg_dialog_color ");
         prefs.nu_color = cfg_get_int (cfg, "nu_color ");
         prefs.dcctimeout = cfg_get_int (cfg, "dcc_timeout ");
         prefs.dccstalltimeout = cfg_get_int (cfg, "dcc_stall_timeout ");
         prefs.mainwindow_left = cfg_get_int (cfg, "mainwindow_left ");
         prefs.mainwindow_top = cfg_get_int (cfg, "mainwindow_top ");
         prefs.mainwindow_width = cfg_get_int (cfg, "mainwindow_width ");
         prefs.mainwindow_height = cfg_get_int (cfg, "mainwindow_height ");
         prefs.zvt_lines = cfg_get_int (cfg, "zvt_lines ");
         prefs.dccpermissions = cfg_get_int (cfg, "dcc_permissions ");
         prefs.bt_color = cfg_get_int (cfg, "bt_color ");
         free (cfg);
      }
      close (fh);
#ifndef USE_GNOME
      prefs.zvt = prefs.dialog_zvt = FALSE;
#endif
   } else
   {
#ifndef __EMX__
      if (getuid () == 0)
      {
         am_root = TRUE;
         dialog = gtkutil_simpledialog ("* Running IRC as root is stupid! You should\n"
                                        "  create a User Account and use that to login.\n\n"
                                        "* The default DCC receive directory is your\n"
                                        "  home dir, you should change this at some stage.");
	   gtk_signal_connect(GTK_OBJECT(dialog), "destroy", gtkutil_null_this_var, &dialog);
         while (dialog) gtk_main_iteration ();
      }
#endif
      if (!am_root)
      {
         dialog = gtkutil_simpledialog ("The default DCC receive directory is your\n"
                                        "home dir, you should change this at some stage.");	
	   gtk_signal_connect(GTK_OBJECT(dialog), "destroy", gtkutil_null_this_var, &dialog);
         while (dialog) gtk_main_iteration ();
      }
      /* put in default values */
      prefs.fastdccsend = 1;
      prefs.autosave = 1;
      prefs.autodialog = 1;
      prefs.autorejoin = 1;
      prefs.autoreconnect = 1;
      prefs.tabchannels = 1;
      prefs.privmsgtab = 1;
      prefs.nickcompletion = 1;
      prefs.bg_color = 1;
      prefs.dialog_bg_color = 1;
      prefs.nu_color = 4;
      prefs.bt_color = 8;
      prefs.dccpermissions = 0600;
      prefs.zvt_lines = 200;
      prefs.bufsize = 32768;
      prefs.mainwindow_width = 599;
      prefs.mainwindow_height = 422;
      strcpy (prefs.nick1, username);
      strcpy (prefs.nick2, username);
      strcat (prefs.nick2, "_");
      strcpy (prefs.nick3, username);
      strcat (prefs.nick3, "__");
      strcpy (prefs.realname, username);
      strcpy (prefs.username, username);
      strcpy (prefs.dccdir, g_get_home_dir ());
      strcpy (prefs.doubleclickuser, "/QUOTE WHOIS %s");
      strcpy (prefs.awayreason, "I'm busy");
      strcpy (prefs.quitreason, "X-Chat!");
      strcpy (prefs.font_normal, "-misc-fixed-medium-r-semicondensed-*-*-100-*-*-c-*-iso8859-1");
      strcpy (prefs.font_bold, "-misc-fixed-bold-r-semicondensed-*-*-100-*-*-c-*-iso8859-1");
      strcpy (prefs.dialog_font_normal, prefs.font_normal);
      strcpy (prefs.dialog_font_bold, prefs.font_bold);
      strcpy (prefs.sounddir, g_get_home_dir ());
      strcpy (prefs.soundcmd, "play");
   }
   if (prefs.mainwindow_height < 106)
      prefs.mainwindow_height = 106;
   if (prefs.mainwindow_width < 116)
      prefs.mainwindow_width = 116;
}

int
save_config (void)
{
   int fh;

   check_prefs_dir ();

   fh = open (default_file (), O_TRUNC | O_WRONLY | O_CREAT, 0600);
   if (fh != -1)
   {
      /* strings */
      cfg_put_str (fh, "version ", VERSION);
      cfg_put_str (fh, "nickname1 ", prefs.nick1);
      cfg_put_str (fh, "nickname2 ", prefs.nick2);
      cfg_put_str (fh, "nickname3 ", prefs.nick3);
      cfg_put_str (fh, "realname ", prefs.realname);
      cfg_put_str (fh, "username ", prefs.username);
      cfg_put_str (fh, "awayreason ", prefs.awayreason);
      cfg_put_str (fh, "quitreason ", prefs.quitreason);
      cfg_put_str (fh, "font_normal ", prefs.font_normal);
      cfg_put_str (fh, "font_bold ", prefs.font_bold);
      cfg_put_str (fh, "font_dialog_normal ", prefs.dialog_font_normal);
      cfg_put_str (fh, "font_dialog_bold ", prefs.dialog_font_bold);
      cfg_put_str (fh, "sounddir ", prefs.sounddir);
      cfg_put_str (fh, "soundcmd ", prefs.soundcmd);
      cfg_put_str (fh, "background_pic ", prefs.background);
      cfg_put_str (fh, "background_dialog_pic ", prefs.background_dialog);
      cfg_put_str (fh, "dccdir ", prefs.dccdir);
      cfg_put_str (fh, "doubleclickuser ", prefs.doubleclickuser);
      cfg_put_str (fh, "bluestring ", prefs.bluestring);

      /* booleans */
      cfg_put_int (fh, prefs.autosave, "autosave ");
      cfg_put_int (fh, prefs.autodialog, "autodialog ");
      cfg_put_int (fh, prefs.autoreconnect, "autoreconnect ");
      cfg_put_int (fh, prefs.invisible, "invisible ");
      cfg_put_int (fh, prefs.servernotice, "servernotice ");
      cfg_put_int (fh, prefs.wallops, "wallops ");
      cfg_put_int (fh, prefs.skipmotd, "skipmotd ");
      cfg_put_int (fh, prefs.autorejoin, "autorejoin ");
      cfg_put_int (fh, prefs.colorednicks, "colorednicks ");
      cfg_put_int (fh, prefs.nochanmodebuttons, "nochanmodebuttons ");
      cfg_put_int (fh, prefs.nouserlistbuttons, "nouserlistbuttons ");
      cfg_put_int (fh, prefs.nickcompletion, "nickcompletion ");
      cfg_put_int (fh, prefs.tabnicks, "tabnicks ");
      cfg_put_int (fh, prefs.tabchannels, "tabchannels ");
      cfg_put_int (fh, prefs.nopaned, "nopaned ");
      cfg_put_int (fh, prefs.autodccchat, "autodccchat ");
      cfg_put_int (fh, prefs.autodccsend, "autodccsend ");
      cfg_put_int (fh, prefs.noautoopendccsendwindow, "noautoopendccsendwindow ");
      cfg_put_int (fh, prefs.noautoopendccrecvwindow, "noautoopendccrecvwindow ");
      cfg_put_int (fh, prefs.transparent, "transparent ");
      cfg_put_int (fh, prefs.tint, "tint ");
      cfg_put_int (fh, prefs.zvt, "zvt ");
      cfg_put_int (fh, prefs.dialog_transparent, "dialog_transparent ");
      cfg_put_int (fh, prefs.dialog_tint, "dialog_tint ");
      cfg_put_int (fh, prefs.dialog_zvt, "dialog_zvt ");
      cfg_put_int (fh, prefs.stripcolor, "stripcolor ");
      cfg_put_int (fh, prefs.timestamp, "timestamp ");
      cfg_put_int (fh, prefs.fastdccsend, "fastdccsend ");
      cfg_put_int (fh, prefs.skipserverlist, "skipserverliset ");
      cfg_put_int (fh, prefs.filterbeep, "filterbeep ");
      cfg_put_int (fh, prefs.dccwithnick, "dccwithnick ");
      cfg_put_int (fh, prefs.hilitenotify, "hilight_notify ");
      cfg_put_int (fh, prefs.tabsatbottom, "tabsatbottom ");
      cfg_put_int (fh, prefs.beepmsg, "beep_msg ");
      cfg_put_int (fh, prefs.privmsgtab, "priv_msg_tabs ");
      cfg_put_int (fh, prefs.logging, "logging ");
      cfg_put_int (fh, prefs.newtabstofront, "newtabs_to_front ");
      cfg_put_int (fh, prefs.hidever, "hide_version ");
      cfg_put_int (fh, prefs.get_ip_from_server, "get_ip_from_server ");
      cfg_put_int (fh, prefs.panelize_hide, "panelize_hide ");
      cfg_put_int (fh, prefs.panel_vbox, "panel_vbox ");
      cfg_put_int (fh, prefs.raw_modes, "raw_modes ");
      cfg_put_int (fh, prefs.no_server_logs, "no_server_logs ");
      cfg_put_int (fh, prefs.show_away_once, "show_away_once ");
      cfg_put_int (fh, prefs.emacs_key_bindings, "emacs_key_bindings ");

      /* numbers */
      cfg_put_int (fh, prefs.bufsize, "buffer_size ");
      cfg_put_int (fh, prefs.notify_timeout, "notify_timeout ");
      cfg_put_int (fh, prefs.bg_color, "bg_color ");
      cfg_put_int (fh, prefs.fg_color, "fg_color ");
      cfg_put_int (fh, prefs.dialog_bg_color, "bg_dialog_color ");
      cfg_put_int (fh, prefs.dialog_fg_color, "fg_dialog_color ");
      cfg_put_int (fh, prefs.nu_color, "nu_color ");
      cfg_put_int (fh, prefs.dcctimeout, "dcc_timeout ");
      cfg_put_int (fh, prefs.dccstalltimeout, "dcc_stall_timeout ");
      cfg_put_int (fh, prefs.mainwindow_left, "mainwindow_left ");
      cfg_put_int (fh, prefs.mainwindow_top, "mainwindow_top ");
      cfg_put_int (fh, prefs.mainwindow_width, "mainwindow_width ");
      cfg_put_int (fh, prefs.mainwindow_height, "mainwindow_height ");
      cfg_put_int (fh, prefs.zvt_lines, "zvt_lines ");
      cfg_put_int (fh, prefs.dccpermissions, "dcc_permissions ");
      cfg_put_int (fh, prefs.bt_color, "bt_color ");

      close (fh);
      return 1;
   }
   return 0;
}
