/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* 
 * Copyright (C) 2001 Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Hans Petter Jansson <hpj@ximian.com>
 */

#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <gnome.h>

#include "xst-report-line.h"

/* printf, perl style, with a 1024 char limit. Gets the job done. */
static gchar *
xst_report_sprintf (gchar *fmt, gchar **argv)
{
	char *orig_fmt;
	char str[1024], ret[1024];
	char *c, *fmt_p, *fmt_p2;
	int i;

	orig_fmt = g_strdup (fmt);
 	if (!argv[0])
		return orig_fmt;
	
	ret[0] = 0;
	fmt_p = orig_fmt;
	c = strchr (orig_fmt, '%');
	if (!c)
		return orig_fmt;
	
	for (i = 0; argv[i]; i++) {
		if (c)
			*c = '%';
		c = strchr (c + 1, '%');
		if (c)
			*c = 0;
		fmt_p2 = c;
		
		snprintf (str, 1023, fmt_p, argv[i]);
		fmt_p = fmt_p2;
		strncpy (ret + strlen (ret), str, 1023 - strlen (ret));
	}

	g_free (orig_fmt);
	return g_strdup (ret);
}

XstReportLine *
xst_report_line_new (gchar *key, gchar *fmt, gchar **argv)
{
	XstReportLine *xrl;
	gchar *str;

	xrl = g_new0 (XstReportLine, 1);
	xrl->key = g_strdup (key);
	xrl->fmt = g_strdup (fmt);

	str = g_strjoinv ("::", argv);
	xrl->argv = g_strsplit (str, "::", 0);
	g_free (str);
	
	xrl->message = xst_report_sprintf (fmt, argv);
	xrl->handled = FALSE;

	return xrl;
}

XstReportLine *
xst_report_line_new_from_string (gchar *string)
{
	XstReportLine *xrl;
	gchar **parts;

	g_return_val_if_fail (strlen (string) > 1, NULL);

	parts = g_strsplit (string, "::", 0);

	g_return_val_if_fail (parts[0], NULL);
	g_return_val_if_fail (parts[1], NULL);
	
	xrl = xst_report_line_new (parts[0], parts[1], &parts[2]);
	g_strfreev (parts);

	return xrl;
}

void
xst_report_line_free (XstReportLine *line)
{
	g_free (line->message);
	g_free (line->key);
	g_free (line->fmt);
	if (line->argv)
		g_strfreev (line->argv);
	g_free (line);
}

const gchar *
xst_report_line_get_key (XstReportLine *line)
{
	g_return_val_if_fail (line != NULL, 0);
	return (line->key);
}

const gchar **
xst_report_line_get_argv (XstReportLine *line)
{
	g_return_val_if_fail (line != NULL, 0);
	return (const gchar **) (line->argv);
}

const gchar *
xst_report_line_get_message (XstReportLine *line)
{
	g_return_val_if_fail (line != NULL, NULL);
	return (line->message);
}

gboolean
xst_report_line_get_handled (XstReportLine *line)
{
	g_return_val_if_fail (line != NULL, FALSE);
	return (line->handled);
}

void
xst_report_line_set_handled (XstReportLine *line, gboolean handled)
{
	g_return_if_fail (line != NULL);

	line->handled = handled;
}
