/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* Copyright (C) 2000-2001 Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Hans Petter Jansson <hpj@ximian.com> and Arturo Espinosa <arturo@ximian.com>.
 */

/* Functions for transferring information between XML tree and UI */

#include <gnome.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>
#include <glade/glade.h>

#include "xst.h"

#include "transfer.h"
#include "callbacks.h"
#include "ishare.h"

static void
transfer_misc_xml_to_tool (XstTool *xst_tool, xmlNodePtr root)
{
	XstIshareTool *tool = XST_ISHARE_TOOL (xst_tool);

	tool->ipforward_installed = xst_xml_element_get_boolean (root, "ip_forwarding_installed");
}


void
transfer_xml_to_gui (XstTool *tool, gpointer data)
{
	xmlNode *root = xst_xml_doc_get_root (tool->config);

	transfer_misc_xml_to_tool (tool, root);
}


void
transfer_gui_to_xml (XstTool *tool, gpointer data)
{
#if 0	
	xmlNode *root = xst_xml_doc_get_root (tool->config);

	transfer_string_entry_gui_to_xml (tool, root);
	transfer_string_list_gui_to_xml (tool, root);
	transfer_string_clist2_gui_to_xml (tool, root);
	transfer_interfaces_to_xml (tool, root);
#endif
}
