/* vim: ts=4 sw=4
 */
/*
 * zenity-tree-column-view.c
 *
 * Copyright © 2023 Logan Rathbone
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#pragma once

#include <gtk/gtk.h>

#include "zenity-tree-column-view-enums.h"	/* auto-generated by build system */

G_BEGIN_DECLS

typedef enum
{
	ZENITY_TREE_LIST_NONE,
	ZENITY_TREE_LIST_CHECK,
	ZENITY_TREE_LIST_RADIO,
	ZENITY_TREE_LIST_IMAGE
} ZenityTreeListType;

/* ZenityTreeItem */

#define ZENITY_TREE_TYPE_ITEM (zenity_tree_item_get_type ())
G_DECLARE_FINAL_TYPE (ZenityTreeItem, zenity_tree_item, ZENITY_TREE, ITEM, GObject)

ZenityTreeItem * zenity_tree_item_new (const char *text, GtkWidget *child);
GtkWidget * zenity_tree_item_get_child (ZenityTreeItem *item);
const char * zenity_tree_item_get_text (ZenityTreeItem *item);
void zenity_tree_item_set_text (ZenityTreeItem *item, const char *text);
void zenity_tree_item_set_child (ZenityTreeItem *item, GtkWidget *child);

/* ZenityTreeRow */

#define ZENITY_TREE_TYPE_ROW (zenity_tree_row_get_type ())
G_DECLARE_FINAL_TYPE (ZenityTreeRow, zenity_tree_row, ZENITY_TREE, ROW, GObject)

ZenityTreeRow * zenity_tree_row_new (void);
void zenity_tree_row_add (ZenityTreeRow *row, ZenityTreeItem *item);
guint zenity_tree_row_get_n_items (ZenityTreeRow *row);
ZenityTreeItem * zenity_tree_row_get_item (ZenityTreeRow *row, guint index);

/* ZenityTreeColumnView */

#define ZENITY_TREE_TYPE_COLUMN_VIEW (zenity_tree_column_view_get_type ())
G_DECLARE_FINAL_TYPE (ZenityTreeColumnView, zenity_tree_column_view, ZENITY_TREE, COLUMN_VIEW, GtkWidget)

void zenity_tree_column_view_set_model (ZenityTreeColumnView *self, GListModel *model);
GListModel * zenity_tree_column_view_get_model (ZenityTreeColumnView *self);
void zenity_tree_column_view_set_list_type (ZenityTreeColumnView *self, ZenityTreeListType type);
ZenityTreeListType zenity_tree_column_view_get_list_type (ZenityTreeColumnView *self);
void zenity_tree_column_view_add_column (ZenityTreeColumnView *self, const char *col_name);
void zenity_tree_column_view_foreach_item (ZenityTreeColumnView *self, GFunc func, gpointer user_data);
void zenity_tree_column_view_foreach_row (ZenityTreeColumnView *self, GFunc func, gpointer user_data);
int zenity_tree_column_view_get_n_columns (ZenityTreeColumnView *self);
gboolean zenity_tree_column_view_get_editable (ZenityTreeColumnView *self);
gboolean zenity_tree_column_view_get_multi (ZenityTreeColumnView *self);
gboolean zenity_tree_column_view_is_selected (ZenityTreeColumnView *self, guint pos);
void zenity_tree_column_view_set_search (ZenityTreeColumnView *self, const char *search_str);
void zenity_tree_column_view_show_column (ZenityTreeColumnView *self, guint pos, gboolean show);

G_END_DECLS
