.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XFillRectangle __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XFillRectangle, XFillRectangles, XFillPolygon, XFillArc, XFillArcs \- fill rectangles, polygons, or arcs
.SH SYNTAX
.HP
int XFillRectangle\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC
\fIgc\fP\^, int \fIx\fP\^, int \fIy\fP\^, unsigned int \fIwidth\fP\^, unsigned
int \fIheight\fP\^);
.HP
int XFillRectangles\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC
\fIgc\fP\^, XRectangle *\fIrectangles\fP\^, int \fInrectangles\fP\^);
.HP
int XFillPolygon\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC
\fIgc\fP\^, XPoint *\fIpoints\fP\^, int \fInpoints\fP\^, int \fIshape\fP\^,
int \fImode\fP\^);
.HP
int XFillArc\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC \fIgc\fP\^,
int \fIx\fP\^, int \fIy\fP\^, unsigned int \fIwidth\fP\^, unsigned int
\fIheight\fP\^, int \fIangle1\fP\^, int \fIangle2\fP\^);
.HP
int XFillArcs\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC \fIgc\fP\^,
XArc *\fIarcs\fP\^, int \fInarcs\fP\^);
.SH ARGUMENTS
.IP \fIangle1\fP 1i
Specifies the start of the arc relative to the three-o'clock position
from the center, in units of degrees * 64.
.IP \fIangle2\fP 1i
Specifies the path and extent of the arc relative to the start of the
arc, in units of degrees * 64.
.IP \fIarcs\fP 1i
Specifies an array of arcs.
.IP \fId\fP 1i
Specifies the drawable.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIgc\fP 1i
Specifies the GC.
.IP \fImode\fP 1i
Specifies the coordinate mode.
You can pass
.B CoordModeOrigin
or
.BR CoordModePrevious .
.IP \fInarcs\fP 1i
Specifies the number of arcs in the array.
.IP \fInpoints\fP 1i
Specifies the number of points in the array.
.IP \fInrectangles\fP 1i
Specifies the number of rectangles in the array.
.IP \fIpoints\fP 1i
Specifies an array of points.
.IP \fIrectangles\fP 1i
Specifies an array of rectangles.
.IP \fIshape\fP 1i
Specifies a shape that helps the server to improve performance.
You can pass
.BR Complex ,
.BR Convex ,
or
.BR Nonconvex .
.ds Wh
.IP \fIwidth\fP 1i
.br
.ns
.IP \fIheight\fP 1i
Specify the width and height, which are the dimensions of the
rectangle to be filled or the major and minor axes of the arc.
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates, which are relative to the origin of the drawable \
and specify the upper-left corner of the rectangle.
.SH DESCRIPTION
The
.B XFillRectangle
and
.B XFillRectangles
functions fill the specified rectangle or rectangles
as if a four-point
.B FillPolygon
protocol request were specified for each rectangle:
.LP
.EX
[x,y] [x+width,y] [x+width,y+height] [x,y+height]
.EE
.LP
Each function uses the x and y coordinates,
width and height dimensions, and GC you specify.
.LP
.B XFillRectangles
fills the rectangles in the order listed in the array.
For any given rectangle,
.B XFillRectangle
and
.B XFillRectangles
do not draw a pixel more than once.
If rectangles intersect, the intersecting pixels are
drawn multiple times.
.LP
Both functions use these GC components:
function, plane-mask, fill-style, subwindow-mode,
clip-x-origin, clip-y-origin, and clip-mask.
They also use these GC mode-dependent components:
foreground, background, tile, stipple, tile-stipple-x-origin,
and tile-stipple-y-origin.
.LP
.B XFillRectangle
and
.B XFillRectangles
can generate
.BR BadDrawable ,
.BR BadGC ,
and
.B BadMatch
errors.
.LP
.B XFillPolygon
fills the region closed by the specified path.
The path is closed
automatically if the last point in the list does not coincide with the
first point.
.B XFillPolygon
does not draw a pixel of the region more than once.
.B CoordModeOrigin
treats all coordinates as relative to the origin,
and
.B CoordModePrevious
treats all coordinates after the first as relative to the previous point.
.LP
Depending on the specified shape, the following occurs:
.IP \(bu 5
If shape is
.BR Complex ,
the path may self-intersect.
Note that contiguous coincident points in the path are not treated
as self-intersection.
.IP \(bu 5
If shape is
.BR Convex ,
for every pair of points inside the polygon,
the line segment connecting them does not intersect the path.
If known by the client,
specifying
.B Convex
can improve performance.
If you specify
.B Convex
for a path that is not convex,
the graphics results are undefined.
.IP \(bu 5
If shape is
.BR Nonconvex ,
the path does not self-intersect, but the shape is not
wholly convex.
If known by the client,
specifying
.B Nonconvex
instead of
.B Complex
may improve performance.
If you specify
.B Nonconvex
for a self-intersecting path, the graphics results are undefined.
.LP
The fill-rule of the GC controls the filling behavior of
self-intersecting polygons.
.LP
This function uses these GC components:
function, plane-mask, fill-style, fill-rule, subwindow-mode, clip-x-origin,
clip-y-origin, and clip-mask.
It also uses these GC mode-dependent components:
foreground, background, tile, stipple, tile-stipple-x-origin,
and tile-stipple-y-origin.
.LP
.B XFillPolygon
can generate
.BR BadDrawable ,
.BR BadGC ,
.BR BadMatch ,
and
.B BadValue
errors.
.LP
For each arc,
.B XFillArc
or
.B XFillArcs
fills the region closed by the infinitely thin path
described by the specified arc and, depending on the
arc-mode specified in the GC, one or two line segments.
For
.BR ArcChord ,
the single line segment joining the endpoints of the arc is used.
For
.BR ArcPieSlice ,
the two line segments joining the endpoints of the arc with the center
point are used.
.B XFillArcs
fills the arcs in the order listed in the array.
For any given arc,
.B XFillArc
and
.B XFillArcs
do not draw a pixel more than once.
If regions intersect,
the intersecting pixels are drawn multiple times.
.LP
Both functions use these GC components:
function, plane-mask, fill-style, arc-mode, subwindow-mode, clip-x-origin,
clip-y-origin, and clip-mask.
They also use these GC mode-dependent components:
foreground, background, tile, stipple, tile-stipple-x-origin,
and tile-stipple-y-origin.
.LP
.B XFillArc
and
.B XFillArcs
can generate
.BR BadDrawable ,
.BR BadGC ,
and
.B BadMatch
errors.
.SH DIAGNOSTICS
.TP 1i
.B BadDrawable
A value for a Drawable argument does not name a defined Window or Pixmap.
.TP 1i
.B BadGC
A value for a GContext argument does not name a defined GContext.
.TP 1i
.B BadMatch
An
.B InputOnly
window is used as a Drawable.
.TP 1i
.B BadMatch
Some argument or pair of arguments has the correct type and range but fails
to match in some other way required by the request.
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XDrawArc(__libmansuffix__),
XDrawPoint(__libmansuffix__),
XDrawRectangle(__libmansuffix__)
.br
\fI\*(xL\fP
