/* -*-C++-*-	$NetBSD: window.h,v 1.4 2008/04/28 20:23:20 martin Exp $	*/

/*-
 * Copyright (c) 2001 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by UCHIYAMA Yasushi.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _HPCBOOT_WINDOW_H_
#define	_HPCBOOT_WINDOW_H_

class Window {
public:
	HWND _window;
	HWND _parent_window;
	HpcBootApp &_app;
	RECT _rect;

public:
	explicit Window(HpcBootApp &app)
		: _app(app), _parent_window(0) { /* NO-OP */ }
	explicit Window(HpcBootApp &app, HWND parent)
		: _app(app), _parent_window(parent) { /* NO-OP */ }
	virtual ~Window(void) { /* NO-OP */ }

	// Window Procedure callback
	static LRESULT CALLBACK _wnd_proc(HWND, UINT, WPARAM, LPARAM);
	// Dialog Procedure callback
	static BOOL CALLBACK _dlg_proc(HWND, UINT, WPARAM, LPARAM);
	// Window dependent Window Procedure
	virtual BOOL proc(HWND w, UINT msg, WPARAM wparam, LPARAM lparam);
};

#endif //_HPCBOOT_WINDOW_H_
