#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "critbit.h"

static int
p(const char *key, void *arg, size_t namelen)
{
	size_t	 size;

	memcpy(&size, key, sizeof(size));
	printf("p - tree '%.*s' with prefix '%.*s'\n", (int)size,
		&key[sizeof(size)], (int)namelen, (char *)arg);
	return 1;
}

int
main(int argc, char **argv)
{
	critbit_t	 tree;
	size_t		 kc;
	char		 buf[BUFSIZ];

	memset(&tree, 0x0, sizeof(tree));
	while (fgets(buf, sizeof(buf), stdin) != NULL) {
		switch(buf[0]) {
		case 'i':
			kc = strlen(buf) - 2;
			critbit_insert(&tree, &buf[1], kc);
			break;
		case 'd':
			critbit_delete(&tree, &buf[1], strlen(buf) - 2);
			break;
		case '/':
			if (critbit_contains(&tree, &buf[1], kc = strlen(buf) - 2)) {
				printf("\'%.*s\' found\n", (int)kc, &buf[1]);
			}
			break;
		case 'p':
			critbit_allprefixed(&tree, &buf[1], strlen(buf) - 2, p, &buf[1]);
			break;
		case '#':
			printf("count: %d\n", critbit_length(&tree));
			break;
		}
	}
	critbit_clear(&tree);
	exit(EXIT_SUCCESS);
}
