/*	$NetBSD: mloop.c,v 1.8 2003/08/07 11:17:27 agc Exp $	*/

/*
 * Copyright (c) 1983, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Edward Wang at The University of California, Berkeley.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>

#ifndef lint
__RCSID("$NetBSD: mloop.c,v 1.8 2003/08/07 11:17:27 agc Exp $");
#endif /* not lint */

#include <sys/param.h>
#include <unistd.h>

#include "defs.h"

void
mloop(winvars_t *winvars)
{
	int	inesc;

	for (inesc = 0 ; !winvars->quit ; ) {
		if (winvars->incmd) {
			docmd(winvars);
		} else if (winvars->wwcurwin->ww_state != WWS_HASPROC) {
			if (!ISSET(winvars->wwcurwin->frameflags, WWU_KEEPOPEN))
				closewin(winvars, winvars->wwcurwin);
			setcmd(winvars, 1);
			if (WWPEEKC(winvars) == winvars->escapec) {
				/* LINTED */
				(void) WWGETC(winvars);
			}
			error("Process died.");
		} else {
			ww_t *w = winvars->wwcurwin;
#if 0
#else
			char	cooked[256];
			char *cp;
#endif
			char *p;
			int n;

			if (winvars->wwibp >= winvars->wwibq) {
				winvars->wwibp = winvars->wwibq = winvars->wwib;
				wwiomux(winvars);
			}
#if 0
                       for (p = winvars->wwibp; p < winvars->wwibq && WWMASKC(*p) != winvars->escapec;
                            p++)
                               ;
			if ((n = (int)(p - winvars->wwibp)) > 0) {
				if (w->ww_type != WWT_PTY &&
				    ISSET(w->processflags, WWP_STOPPED)) {
					startwin(w);
				}
				(void) write(w->ww_pty, winvars->wwibp, (unsigned) n);
				winvars->wwibp = p;
			}
#else
			for (cp = cooked, p = winvars->wwibp ; p < winvars->wwibq ; p++, cp++) {
				if ((*cp = *p) == winvars->escapec) {
					inesc = 1;
					if (WWPEEKC(winvars) == winvars->literalc) {
						*cp = winvars->escapec;
						p++;
					} else {
						break;
					}
				} else {
					inesc = 0;
				}
			}
			if ((n = (int)(cp - cooked)) > 0) {
				if (w->ww_type != WWT_PTY &&
				    ISSET(w->processflags, WWP_STOPPED)) {
					startwin(w);
				}
				(void) write(w->ww_pty, cooked, (unsigned) n);
				winvars->wwibp = p;
			}
#endif
			if (WWPEEKC(winvars) == winvars->escapec) {
				/* LINTED */
				(void) WWGETC(winvars);
				setcmd(winvars, 1);
			}
		}
	}
}
