/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 4 -*- 
 *
 * Copyright (C) 1995-2007, Hewlett-Packard Development Company, L.P.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _SKI_SYSCALL_HPUX_H
#define _SKI_SYSCALL_HPUX_H

#define	SYS_NOSYS	0
#define	SYS_nosys	0
#define	SYS_EXIT	1
#define	SYS_exit	1
#define	SYS_FORK	2
#define	SYS_fork	2
#define	SYS_READ	3
#define	SYS_read	3
#define	SYS_WRITE	4
#define	SYS_write	4
#define	SYS_OPEN	5
#define	SYS_open	5
#define	SYS_CLOSE	6
#define	SYS_close	6
#define	SYS_WAIT	7
#define	SYS_wait	7
#define	SYS_CREAT	8
#define	SYS_creat	8
#define	SYS_LINK	9
#define	SYS_link	9
#define	SYS_UNLINK	10
#define	SYS_unlink	10
#define	SYS_EXECV	11
#define	SYS_execv	11
#define	SYS_CHDIR	12
#define	SYS_chdir	12
#define	SYS_TIME	13
#define	SYS_time	13
#define	SYS_MKNOD	14
#define	SYS_mknod	14
#define	SYS_CHMOD	15
#define	SYS_chmod	15
#define	SYS_CHOWN	16
#define	SYS_chown	16
#define	SYS_BRK	17
#define	SYS_brk	17
#define	SYS_LCHMOD	18
#define	SYS_lchmod	18
#define	SYS_LSEEK	19
#define	SYS_lseek	19
#define	SYS_GETPID	20
#define	SYS_getpid	20
#define	SYS_MOUNT	21
#define	SYS_mount	21
#define	SYS_UMOUNT	22
#define	SYS_umount	22
#define	SYS_SETUID	23
#define	SYS_setuid	23
#define	SYS_GETUID	24
#define	SYS_getuid	24
#define	SYS_STIME	25
#define	SYS_stime	25
#define	SYS_PTRACE	26
#define	SYS_ptrace	26
#define	SYS_ALARM	27
#define	SYS_alarm	27
#define	SYS_PAUSE	29
#define	SYS_pause	29
#define	SYS_UTIME	30
#define	SYS_utime	30
#define	SYS_STTY	31
#define	SYS_stty	31
#define	SYS_GTTY	32
#define	SYS_gtty	32
#define	SYS_ACCESS	33
#define	SYS_access	33
#define	SYS_NICE	34
#define	SYS_nice	34
#define	SYS_FTIME	35
#define	SYS_ftime	35
#define	SYS_SYNC	36
#define	SYS_sync	36
#define	SYS_KILL	37
#define	SYS_kill	37
#define	SYS_STAT	38
#define	SYS_stat	38
#define	SYS_SETPGRP3	39
#define	SYS_setpgrp3	39
#define	SYS_LSTAT	40
#define	SYS_lstat	40
#define	SYS_DUP	41
#define	SYS_dup	41
#define	SYS_PIPE	42
#define	SYS_pipe	42
#define	SYS_TIMES	43
#define	SYS_times	43
#define	SYS_PROFIL	44
#define	SYS_profil	44
#define	SYS_KI_CALL	45
#define	SYS_ki_call	45
#define	SYS_SETGID	46
#define	SYS_setgid	46
#define	SYS_GETGID	47
#define	SYS_getgid	47
#define	SYS_ACCT	51
#define	SYS_acct	51
#define	SYS_SET_USERTHREADID	52
#define	SYS_set_userthreadid	52
#define	SYS_IOCTL	54
#define	SYS_ioctl	54
#define	SYS_REBOOT	55
#define	SYS_reboot	55
#define	SYS_SYMLINK	56
#define	SYS_symlink	56
#define	SYS_UTSSYS	57
#define	SYS_utssys	57
#define	SYS_READLINK	58
#define	SYS_readlink	58
#define	SYS_EXECVE	59
#define	SYS_execve	59
#define	SYS_UMASK	60
#define	SYS_umask	60
#define	SYS_CHROOT	61
#define	SYS_chroot	61
#define	SYS_FCNTL	62
#define	SYS_fcntl	62
#define	SYS_ULIMIT	63
#define	SYS_ulimit	63
#define	SYS_VFORK	66
#define	SYS_vfork	66
#define	SYS_LWP_GETPRIVATE	67
#define	SYS_lwp_getprivate	67
#define	SYS_LWP_SETPRIVATE	68
#define	SYS_lwp_setprivate	68
#define	SYS_MMAP	71
#define	SYS_mmap	71
#define	SYS_MUNMAP	73
#define	SYS_munmap	73
#define	SYS_MPROTECT	74
#define	SYS_mprotect	74
#define	SYS_MADVISE	75
#define	SYS_madvise	75
#define	SYS_VHANGUP	76
#define	SYS_vhangup	76
#define	SYS_SWAPOFF	77
#define	SYS_swapoff	77
#define	SYS_GETGROUPS	79
#define	SYS_getgroups	79
#define	SYS_SETGROUPS	80
#define	SYS_setgroups	80
#define	SYS_GETPGRP2	81
#define	SYS_getpgrp2	81
#define	SYS_SETPGID	82
#define	SYS_setpgid	82
#define	SYS_SETPGRP2	82
#define	SYS_setpgrp2	82
#define	SYS_SETITIMER	83
#define	SYS_setitimer	83
#define	SYS_WAIT3	84
#define	SYS_wait3	84
#define	SYS_SWAPON	85
#define	SYS_swapon	85
#define	SYS_GETITIMER	86
#define	SYS_getitimer	86
#define	SYS_DUP2	90
#define	SYS_dup2	90
#define	SYS_FSTAT	92
#define	SYS_fstat	92
#define	SYS_SELECT	93
#define	SYS_select	93
#define	SYS_FSYNC	95
#define	SYS_fsync	95
#define	SYS_SETPRIORITY	96
#define	SYS_setpriority	96
#define	SYS_GETPRIORITY	100
#define	SYS_getpriority	100
#define	SYS_LF_SEND	103
#define	SYS_lf_send	103
#define	SYS_SIGVECTOR	108
#define	SYS_sigvector	108
#define	SYS_SIGBLOCK	109
#define	SYS_sigblock	109
#define	SYS_SIGSETMASK	110
#define	SYS_sigsetmask	110
#define	SYS_SIGPAUSE	111
#define	SYS_sigpause	111
#define	SYS_SIGSTACK	112
#define	SYS_sigstack	112
#define	SYS_GETTIMEOFDAY	116
#define	SYS_gettimeofday	116
#define	SYS_GETRUSAGE	117
#define	SYS_getrusage	117
#define	SYS_READV	120
#define	SYS_readv	120
#define	SYS_WRITEV	121
#define	SYS_writev	121
#define	SYS_SETTIMEOFDAY	122
#define	SYS_settimeofday	122
#define	SYS_FCHOWN	123
#define	SYS_fchown	123
#define	SYS_FCHMOD	124
#define	SYS_fchmod	124
#define	SYS_SETRESUID	126
#define	SYS_setresuid	126
#define	SYS_SETRESGID	127
#define	SYS_setresgid	127
#define	SYS_RENAME	128
#define	SYS_rename	128
#define	SYS_TRUNCATE	129
#define	SYS_truncate	129
#define	SYS_FTRUNCATE	130
#define	SYS_ftruncate	130
#define	SYS_SYSCONF	132
#define	SYS_sysconf	132
#define	SYS_MKDIR	136
#define	SYS_mkdir	136
#define	SYS_RMDIR	137
#define	SYS_rmdir	137
#define	SYS_SIGCLEANUP	139
#define	SYS_sigcleanup	139
#define	SYS_SETCORE	140
#define	SYS_setcore	140
#define	SYS_GETRLIMIT	144
#define	SYS_getrlimit	144
#define	SYS_SETRLIMIT	145
#define	SYS_setrlimit	145
#define	SYS_LWP_SELF	147
#define	SYS_lwp_self	147
#define	SYS_QUOTACTL	148
#define	SYS_quotactl	148
#define	SYS_GET_SYSINFO	149
#define	SYS_get_sysinfo	149
#define	SYS_PRIVGRP	151
#define	SYS_privgrp	151
#define	SYS_RTPRIO	152
#define	SYS_rtprio	152
#define	SYS_PLOCK	153
#define	SYS_plock	153
#define	SYS_LF_NEXT_SCN	154
#define	SYS_lf_next_scn	154
#define	SYS_LOCKF	155
#define	SYS_lockf	155
#define	SYS_SEMGET	156
#define	SYS_semget	156
#define	SYS_SEMOP	158
#define	SYS_semop	158
#define	SYS_MSGGET	159
#define	SYS_msgget	159
#define	SYS_MSGSND	161
#define	SYS_msgsnd	161
#define	SYS_MSGRCV	162
#define	SYS_msgrcv	162
#define	SYS_SHMGET	163
#define	SYS_shmget	163
#define	SYS_SHMAT	165
#define	SYS_shmat	165
#define	SYS_SHMDT	166
#define	SYS_shmdt	166
#define	SYS_NSP_INIT	168
#define	SYS_nsp_init	168
#define	SYS_MKRNOD	170
#define	SYS_mkrnod	170
#define	SYS_TEST	171
#define	SYS_test	171
#define	SYS_UNSP_OPEN	172
#define	SYS_unsp_open	172
#define	SYS_OGETCONTEXT	174
#define	SYS_ogetcontext	174
#define	SYS_OSETCONTEXT	175
#define	SYS_osetcontext	175
#define	SYS_BIGIO	176
#define	SYS_bigio	176
#define	SYS_PIPENODE	177
#define	SYS_pipenode	177
#define	SYS_LSYNC	178
#define	SYS_lsync	178
#define	SYS_MYSITE	180
#define	SYS_mysite	180
#define	SYS_SITELS	181
#define	SYS_sitels	181
#define	SYS_SWAPCLIENTS	182
#define	SYS_swapclients	182
#define	SYS_RMTPROCESS	183
#define	SYS_rmtprocess	183
#define	SYS_DSKLESS_STATS	184
#define	SYS_dskless_stats	184
#define	SYS_SIGPROCMASK	185
#define	SYS_sigprocmask	185
#define	SYS_SIGPENDING	186
#define	SYS_sigpending	186
#define	SYS_SIGSUSPEND	187
#define	SYS_sigsuspend	187
#define	SYS_SIGACTION	188
#define	SYS_sigaction	188
#define	SYS_LW_GET_THREAD_TIMES	189
#define	SYS_lw_get_thread_times	189
#define	SYS_NFSSVC	190
#define	SYS_nfssvc	190
#define	SYS_GETFH	191
#define	SYS_getfh	191
#define	SYS_GETDOMAINNAME	192
#define	SYS_getdomainname	192
#define	SYS_SETDOMAINNAME	193
#define	SYS_setdomainname	193
#define	SYS_ASYNC_DAEMON	194
#define	SYS_async_daemon	194
#define	SYS_GETDIRENTRIES	195
#define	SYS_getdirentries	195
#define	SYS_STATFS	196
#define	SYS_statfs	196
#define	SYS_FSTATFS	197
#define	SYS_fstatfs	197
#define	SYS_VFSMOUNT	198
#define	SYS_vfsmount	198
#define	SYS_QMML	199
#define	SYS_qmml	199
#define	SYS_WAITPID	200
#define	SYS_waitpid	200
#define	SYS_SIGSETRETURN	224
#define	SYS_sigsetreturn	224
#define	SYS_SIGSETSTATEMASK	225
#define	SYS_sigsetstatemask	225
#define	SYS_CS	227
#define	SYS_cs	227
#define	SYS_CDS	228
#define	SYS_cds	228
#define	SYS_SET_NO_TRUNC	229
#define	SYS_set_no_trunc	229
#define	SYS_PATHCONF	230
#define	SYS_pathconf	230
#define	SYS_FPATHCONF	231
#define	SYS_fpathconf	231
#define	SYS_NFS_FCNTL	234
#define	SYS_nfs_fcntl	234
#define	SYS_OGETACL	235
#define	SYS_ogetacl	235
#define	SYS_OFGETACL	236
#define	SYS_ofgetacl	236
#define	SYS_OSETACL	237
#define	SYS_osetacl	237
#define	SYS_OFSETACL	238
#define	SYS_ofsetacl	238
#define	SYS_PSTAT	239
#define	SYS_pstat	239
#define	SYS_GETAUDID	240
#define	SYS_getaudid	240
#define	SYS_SETAUDID	241
#define	SYS_setaudid	241
#define	SYS_GETAUDPROC	242
#define	SYS_getaudproc	242
#define	SYS_SETAUDPROC	243
#define	SYS_setaudproc	243
#define	SYS_GETEVENT	244
#define	SYS_getevent	244
#define	SYS_SETEVENT	245
#define	SYS_setevent	245
#define	SYS_AUDWRITE	246
#define	SYS_audwrite	246
#define	SYS_AUDSWITCH	247
#define	SYS_audswitch	247
#define	SYS_AUDCTL	248
#define	SYS_audctl	248
#define	SYS_OGETACCESS	249
#define	SYS_ogetaccess	249
#define	SYS_FSCTL	250
#define	SYS_fsctl	250
#define	SYS_SWAPFS	259
#define	SYS_swapfs	259
#define	SYS_FSS	260
#define	SYS_fss	260
#define	SYS_TSYNC	267
#define	SYS_tsync	267
#define	SYS_GETNUMFDS	268
#define	SYS_getnumfds	268
#define	SYS_POLL	269
#define	SYS_poll	269
#define	SYS_GETMSG	270
#define	SYS_getmsg	270
#define	SYS_PUTMSG	271
#define	SYS_putmsg	271
#define	SYS_FCHDIR	272
#define	SYS_fchdir	272
#define	SYS_GETMOUNT_CNT	273
#define	SYS_getmount_cnt	273
#define	SYS_GETMOUNT_ENTRY	274
#define	SYS_getmount_entry	274
#define	SYS_ACCEPT	275
#define	SYS_accept	275
#define	SYS_BIND	276
#define	SYS_bind	276
#define	SYS_CONNECT	277
#define	SYS_connect	277
#define	SYS_GETPEERNAME	278
#define	SYS_getpeername	278
#define	SYS_GETSOCKNAME	279
#define	SYS_getsockname	279
#define	SYS_GETSOCKOPT	280
#define	SYS_getsockopt	280
#define	SYS_LISTEN	281
#define	SYS_listen	281
#define	SYS_RECV	282
#define	SYS_recv	282
#define	SYS_RECVFROM	283
#define	SYS_recvfrom	283
#define	SYS_RECVMSG	284
#define	SYS_recvmsg	284
#define	SYS_SEND	285
#define	SYS_send	285
#define	SYS_SENDMSG	286
#define	SYS_sendmsg	286
#define	SYS_SENDTO	287
#define	SYS_sendto	287
#define	SYS_SETSOCKOPT	288
#define	SYS_setsockopt	288
#define	SYS_SHUTDOWN	289
#define	SYS_shutdown	289
#define	SYS_SOCKET	290
#define	SYS_socket	290
#define	SYS_SOCKETPAIR	291
#define	SYS_socketpair	291
#define	SYS_PROC_OPEN	292
#define	SYS_proc_open	292
#define	SYS_PROC_CLOSE	293
#define	SYS_proc_close	293
#define	SYS_PROC_SEND	294
#define	SYS_proc_send	294
#define	SYS_PROC_RECV	295
#define	SYS_proc_recv	295
#define	SYS_PROC_SENDRECV	296
#define	SYS_proc_sendrecv	296
#define	SYS_PROC_SYSCALL	297
#define	SYS_proc_syscall	297
#define	SYS_SEMCTL	312
#define	SYS_semctl	312
#define	SYS_MSGCTL	313
#define	SYS_msgctl	313
#define	SYS_SHMCTL	314
#define	SYS_shmctl	314
#define	SYS_MPCTL	315
#define	SYS_mpctl	315
#define	SYS_EXPORTFS	316
#define	SYS_exportfs	316
#define	SYS_GETPMSG	317
#define	SYS_getpmsg	317
#define	SYS_PUTPMSG	318
#define	SYS_putpmsg	318
#define	SYS_MSYNC	320
#define	SYS_msync	320
#define	SYS_MSLEEP	321
#define	SYS_msleep	321
#define	SYS_MWAKEUP	322
#define	SYS_mwakeup	322
#define	SYS_MSEM_INIT	323
#define	SYS_msem_init	323
#define	SYS_MSEM_REMOVE	324
#define	SYS_msem_remove	324
#define	SYS_ADJTIME	325
#define	SYS_adjtime	325
#define	SYS_KLOAD	326
#define	SYS_kload	326
#define	SYS_FATTACH	327
#define	SYS_fattach	327
#define	SYS_FDETACH	328
#define	SYS_fdetach	328
#define	SYS_SERIALIZE	329
#define	SYS_serialize	329
#define	SYS_STATVFS	330
#define	SYS_statvfs	330
#define	SYS_FSTATVFS	331
#define	SYS_fstatvfs	331
#define	SYS_LCHOWN	332
#define	SYS_lchown	332
#define	SYS_GETSID	333
#define	SYS_getsid	333
#define	SYS_SYSFS	334
#define	SYS_sysfs	334
#define	SYS_SCHED_SETPARAM	337
#define	SYS_sched_setparam	337
#define	SYS_SCHED_GETPARAM	338
#define	SYS_sched_getparam	338
#define	SYS_SCHED_SETSCHEDULER	339
#define	SYS_sched_setscheduler	339
#define	SYS_SCHED_GETSCHEDULER	340
#define	SYS_sched_getscheduler	340
#define	SYS_SCHED_YIELD	341
#define	SYS_sched_yield	341
#define	SYS_SCHED_GET_PRIORITY_MAX	342
#define	SYS_sched_get_priority_max	342
#define	SYS_SCHED_GET_PRIORITY_MIN	343
#define	SYS_sched_get_priority_min	343
#define	SYS_SCHED_RR_GET_INTERVAL	344
#define	SYS_sched_rr_get_interval	344
#define	SYS_CLOCK_SETTIME	345
#define	SYS_clock_settime	345
#define	SYS_CLOCK_GETTIME	346
#define	SYS_clock_gettime	346
#define	SYS_CLOCK_GETRES	347
#define	SYS_clock_getres	347
#define	SYS_TIMER_CREATE	348
#define	SYS_timer_create	348
#define	SYS_TIMER_DELETE	349
#define	SYS_timer_delete	349
#define	SYS_TIMER_SETTIME	350
#define	SYS_timer_settime	350
#define	SYS_TIMER_GETTIME	351
#define	SYS_timer_gettime	351
#define	SYS_TIMER_GETOVERRUN	352
#define	SYS_timer_getoverrun	352
#define	SYS_NANOSLEEP	353
#define	SYS_nanosleep	353
#define	SYS_TOOLBOX	354
#define	SYS_toolbox	354
#define	SYS_GETDENTS	356
#define	SYS_getdents	356
#define	SYS_GETCONTEXT	357
#define	SYS_getcontext	357
#define	SYS_SYSINFO	358
#define	SYS_sysinfo	358
#define	SYS_FCNTL64	359
#define	SYS_fcntl64	359
#define	SYS_FTRUNCATE64	360
#define	SYS_ftruncate64	360
#define	SYS_FSTAT64	361
#define	SYS_fstat64	361
#define	SYS_GETDIRENTRIES64	362
#define	SYS_getdirentries64	362
#define	SYS_GETRLIMIT64	363
#define	SYS_getrlimit64	363
#define	SYS_LOCKF64	364
#define	SYS_lockf64	364
#define	SYS_LSEEK64	365
#define	SYS_lseek64	365
#define	SYS_LSTAT64	366
#define	SYS_lstat64	366
#define	SYS_MMAP64	367
#define	SYS_mmap64	367
#define	SYS_SETRLIMIT64	368
#define	SYS_setrlimit64	368
#define	SYS_STAT64	369
#define	SYS_stat64	369
#define	SYS_TRUNCATE64	370
#define	SYS_truncate64	370
#define	SYS_ULIMIT64	371
#define	SYS_ulimit64	371
#define	SYS_PREAD	372
#define	SYS_pread	372
#define	SYS_PREADV	373
#define	SYS_preadv	373
#define	SYS_PWRITE	374
#define	SYS_pwrite	374
#define	SYS_PWRITEV	375
#define	SYS_pwritev	375
#define	SYS_PREAD64	376
#define	SYS_pread64	376
#define	SYS_PREADV64	377
#define	SYS_preadv64	377
#define	SYS_PWRITE64	378
#define	SYS_pwrite64	378
#define	SYS_PWRITEV64	379
#define	SYS_pwritev64	379
#define	SYS_SETCONTEXT	380
#define	SYS_setcontext	380
#define	SYS_SIGALTSTACK	381
#define	SYS_sigaltstack	381
#define	SYS_WAITID	382
#define	SYS_waitid	382
#define	SYS_SETPGRP	383
#define	SYS_setpgrp	383
#define	SYS_RECVMSG2	384
#define	SYS_recvmsg2	384
#define	SYS_SENDMSG2	385
#define	SYS_sendmsg2	385
#define	SYS_SOCKET2	386
#define	SYS_socket2	386
#define	SYS_SOCKETPAIR2	387
#define	SYS_socketpair2	387
#define	SYS_SETREGID	388
#define	SYS_setregid	388
#define	SYS_LWP_CREATE	389
#define	SYS_lwp_create	389
#define	SYS_LWP_TERMINATE	390
#define	SYS_lwp_terminate	390
#define	SYS_LWP_WAIT	391
#define	SYS_lwp_wait	391
#define	SYS_LWP_SUSPEND	392
#define	SYS_lwp_suspend	392
#define	SYS_LWP_RESUME	393
#define	SYS_lwp_resume	393
#define	SYS_LWP_ABORT_SYSCALL	395
#define	SYS_lwp_abort_syscall	395
#define	SYS_LWP_INFO	396
#define	SYS_lwp_info	396
#define	SYS_LWP_KILL	397
#define	SYS_lwp_kill	397
#define	SYS_KSLEEP	398
#define	SYS_ksleep	398
#define	SYS_KWAKEUP	399
#define	SYS_kwakeup	399
#define	SYS_PSTAT_GETLWP	401
#define	SYS_pstat_getlwp	401
#define	SYS_LWP_EXIT	402
#define	SYS_lwp_exit	402
#define	SYS_LWP_CONTINUE	403
#define	SYS_lwp_continue	403
#define	SYS_GETACL	404
#define	SYS_getacl	404
#define	SYS_FGETACL	405
#define	SYS_fgetacl	405
#define	SYS_SETACL	406
#define	SYS_setacl	406
#define	SYS_FSETACL	407
#define	SYS_fsetacl	407
#define	SYS_GETACCESS	408
#define	SYS_getaccess	408
#define	SYS_LWP_MUTEX_INIT	409
#define	SYS_lwp_mutex_init	409
#define	SYS_LWP_MUTEX_LOCK_SYS	410
#define	SYS_lwp_mutex_lock_sys	410
#define	SYS_LWP_MUTEX_UNLOCK	411
#define	SYS_lwp_mutex_unlock	411
#define	SYS_LWP_COND_INIT	412
#define	SYS_lwp_cond_init	412
#define	SYS_LWP_COND_SIGNAL	413
#define	SYS_lwp_cond_signal	413
#define	SYS_LWP_COND_BROADCAST	414
#define	SYS_lwp_cond_broadcast	414
#define	SYS_LWP_COND_WAIT_SYS	415
#define	SYS_lwp_cond_wait_sys	415
#define	SYS_LWP_GETSCHEDULER	416
#define	SYS_lwp_getscheduler	416
#define	SYS_LWP_SETSCHEDULER	417
#define	SYS_lwp_setscheduler	417
#define	SYS_LWP_GETSTATE	418
#define	SYS_lwp_getstate	418
#define	SYS_LWP_SETSTATE	419
#define	SYS_lwp_setstate	419
#define	SYS_LWP_DETACH	420
#define	SYS_lwp_detach	420
#define	SYS_MLOCK	421
#define	SYS_mlock	421
#define	SYS_MUNLOCK	422
#define	SYS_munlock	422
#define	SYS_MLOCKALL	423
#define	SYS_mlockall	423
#define	SYS_MUNLOCKALL	424
#define	SYS_munlockall	424
#define	SYS_SHM_OPEN	425
#define	SYS_shm_open	425
#define	SYS_SHM_UNLINK	426
#define	SYS_shm_unlink	426
#define	SYS_SIGQUEUE	427
#define	SYS_sigqueue	427
#define	SYS_SIGWAITINFO	428
#define	SYS_sigwaitinfo	428
#define	SYS_SIGTIMEDWAIT	429
#define	SYS_sigtimedwait	429
#define	SYS_SIGWAIT	430
#define	SYS_sigwait	430
#define	SYS_AIO_READ	431
#define	SYS_aio_read	431
#define	SYS_AIO_WRITE	432
#define	SYS_aio_write	432
#define	SYS_LIO_LISTIO	433
#define	SYS_lio_listio	433
#define	SYS_AIO_ERROR	434
#define	SYS_aio_error	434
#define	SYS_AIO_RETURN	435
#define	SYS_aio_return	435
#define	SYS_AIO_CANCEL	436
#define	SYS_aio_cancel	436
#define	SYS_AIO_SUSPEND	437
#define	SYS_aio_suspend	437
#define	SYS_AIO_FSYNC	438
#define	SYS_aio_fsync	438
#define	SYS_MQ_OPEN	439
#define	SYS_mq_open	439
#define	SYS_MQ_CLOSE	440
#define	SYS_mq_close	440
#define	SYS_MQ_UNLINK	441
#define	SYS_mq_unlink	441
#define	SYS_MQ_SEND	442
#define	SYS_mq_send	442
#define	SYS_MQ_RECEIVE	443
#define	SYS_mq_receive	443
#define	SYS_MQ_NOTIFY	444
#define	SYS_mq_notify	444
#define	SYS_MQ_SETATTR	445
#define	SYS_mq_setattr	445
#define	SYS_MQ_GETATTR	446
#define	SYS_mq_getattr	446
#define	SYS_KSEM_OPEN	447
#define	SYS_ksem_open	447
#define	SYS_KSEM_UNLINK	448
#define	SYS_ksem_unlink	448
#define	SYS_KSEM_CLOSE	449
#define	SYS_ksem_close	449
#define	SYS_KSEM_POST	450
#define	SYS_ksem_post	450
#define	SYS_KSEM_WAIT	451
#define	SYS_ksem_wait	451
#define	SYS_KSEM_READ	452
#define	SYS_ksem_read	452
#define	SYS_KSEM_TRYWAIT	453
#define	SYS_ksem_trywait	453
#define	SYS_LWP_RWLOCK_INIT	454
#define	SYS_lwp_rwlock_init	454
#define	SYS_LWP_RWLOCK_DESTROY	455
#define	SYS_lwp_rwlock_destroy	455
#define	SYS_LWP_RWLOCK_RDLOCK_SYS	456
#define	SYS_lwp_rwlock_rdlock_sys	456
#define	SYS_LWP_RWLOCK_WRLOCK_SYS	457
#define	SYS_lwp_rwlock_wrlock_sys	457
#define	SYS_LWP_RWLOCK_TRYRDLOCK	458
#define	SYS_lwp_rwlock_tryrdlock	458
#define	SYS_LWP_RWLOCK_TRYWRLOCK	459
#define	SYS_lwp_rwlock_trywrlock	459
#define	SYS_LWP_RWLOCK_UNLOCK	460
#define	SYS_lwp_rwlock_unlock	460
#define	SYS_TTRACE	461
#define	SYS_ttrace	461
#define	SYS_TTRACE_WAIT	462
#define	SYS_ttrace_wait	462
#define	SYS_LF_WIRE_MEM	463
#define	SYS_lf_wire_mem	463
#define	SYS_LF_UNWIRE_MEM	464
#define	SYS_lf_unwire_mem	464
#define	SYS_LF_SEND_PIN_MAP	465
#define	SYS_lf_send_pin_map	465
#define	SYS_LF_FREE_BUF	466
#define	SYS_lf_free_buf	466
#define	SYS_LF_WAIT_NQ	467
#define	SYS_lf_wait_nq	467
#define	SYS_LF_WAKEUP_CONN_Q	468
#define	SYS_lf_wakeup_conn_q	468
#define	SYS_LF_UNUSED	469
#define	SYS_lf_unused	469
#define	SYS_LWP_SEMA_INIT	470
#define	SYS_lwp_sema_init	470
#define	SYS_LWP_SEMA_POST	471
#define	SYS_lwp_sema_post	471
#define	SYS_LWP_SEMA_WAIT	472
#define	SYS_lwp_sema_wait	472
#define	SYS_LWP_SEMA_TRYWAIT	473
#define	SYS_lwp_sema_trywait	473
#define	SYS_LWP_SEMA_DESTROY	474
#define	SYS_lwp_sema_destroy	474
#define	SYS_STATVFS64	475
#define	SYS_statvfs64	475
#define	SYS_FSTATVFS64	476
#define	SYS_fstatvfs64	476
#define	SYS_MSH_REGISTER	477
#define	SYS_msh_register	477
#define	SYS_PTRACE64	478
#define	SYS_ptrace64	478
#define	SYS_SENDFILE	479
#define	SYS_sendfile	479
#define	SYS_SENDPATH	480
#define	SYS_sendpath	480
#define	SYS_SENDFILE64	481
#define	SYS_sendfile64	481
#define	SYS_SENDPATH64	482
#define	SYS_sendpath64	482
#define	SYS_MODLOAD	483
#define	SYS_modload	483
#define	SYS_MODULOAD	484
#define	SYS_moduload	484
#define	SYS_MODPATH	485
#define	SYS_modpath	485
#define	SYS_GETKSYM	486
#define	SYS_getksym	486
#define	SYS_MODADM	487
#define	SYS_modadm	487
#define	SYS_MODSTAT	488
#define	SYS_modstat	488
#define	SYS_LWP_DETACHED_EXIT	489
#define	SYS_lwp_detached_exit	489
#define	SYS_CRASHCONF	490
#define	SYS_crashconf	490
#define	SYS_SIGINHIBIT	491
#define	SYS_siginhibit	491
#define	SYS_SIGENABLE	492
#define	SYS_sigenable	492
#define	SYS_SPUCTL	493
#define	SYS_spuctl	493
#define	SYS_ZEROKERNELSUM	494
#define	SYS_zerokernelsum	494
#define	SYS_NFS_KSTAT	495
#define	SYS_nfs_kstat	495
#define	SYS_AIO_READ64	496
#define	SYS_aio_read64	496
#define	SYS_AIO_WRITE64	497
#define	SYS_aio_write64	497
#define	SYS_AIO_ERROR64	498
#define	SYS_aio_error64	498
#define	SYS_AIO_RETURN64	499
#define	SYS_aio_return64	499
#define	SYS_AIO_CANCEL64	500
#define	SYS_aio_cancel64	500
#define	SYS_AIO_SUSPEND64	501
#define	SYS_aio_suspend64	501
#define	SYS_AIO_FSYNC64	502
#define	SYS_aio_fsync64	502
#define	SYS_LIO_LISTIO64	503
#define	SYS_lio_listio64	503
#define	SYS_RECV2	504
#define	SYS_recv2	504
#define	SYS_RECVFROM2	505
#define	SYS_recvfrom2	505
#define	SYS_SEND2	506
#define	SYS_send2	506
#define	SYS_SENDTO2	507
#define	SYS_sendto2	507

#endif	/* _SKI_SYSCALL_HPUX_H */
