/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ELogFormatter
extends Formatter {
    private static final MessageFormat s_tsFormatter = new MessageFormat("{0,date,dd MMM yy} {0,time,HH:mm:ss} {1} {2}");
    private static final String s_lineSeparator = System.getProperty("line.separator");
    private final Date m_timestamp = new Date();
    private final Object[] m_args = new Object[]{this.m_timestamp, null, null};
    private final StringBuffer m_buffer = new StringBuffer();

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = this.m_buffer;
        sb.setLength(0);
        this.m_timestamp.setTime(record.getMillis());
        String tmp = record.getSourceClassName();
        this.m_args[1] = tmp == null ? record.getLoggerName() : tmp;
        this.m_args[2] = this.formatMessage(record);
        s_tsFormatter.format(this.m_args, sb, (FieldPosition)null);
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            sb.append(s_lineSeparator);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            record.getThrown().printStackTrace(pw);
            pw.close();
            sb.append(sw.toString());
        }
        return sb.toString();
    }
}

