/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.management;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.postgresql.pljava.management.Command;

public class SQLDeploymentDescriptor {
    private final ArrayList<Command> m_installCommands = new ArrayList();
    private final ArrayList<Command> m_removeCommands = new ArrayList();
    private final StringBuffer m_buffer = new StringBuffer();
    private final char[] m_image;
    private final Logger m_logger;
    private int m_position = 0;

    public SQLDeploymentDescriptor(String descImage) throws ParseException {
        this.m_image = descImage.toCharArray();
        this.m_logger = Logger.getAnonymousLogger();
        this.readDescriptor();
    }

    public void install(Connection conn) throws SQLException {
        this.executeArray(this.m_installCommands, conn);
    }

    public void remove(Connection conn) throws SQLException {
        this.executeArray(this.m_removeCommands, conn);
    }

    public String toString() {
        return new String(this.m_image);
    }

    private void executeArray(ArrayList<Command> array, Connection conn) throws SQLException {
        this.m_logger.entering("org.postgresql.pljava.management.SQLDeploymentDescriptor", "executeArray");
        for (Command c : array) {
            c.execute(conn);
        }
        this.m_logger.exiting("org.postgresql.pljava.management.SQLDeploymentDescriptor", "executeArray");
    }

    private ParseException parseError(String msg) {
        return new ParseException(msg, this.m_position);
    }

    private void readDescriptor() throws ParseException {
        this.m_logger.entering("org.postgresql.pljava.management.SQLDeploymentDescriptor", "readDescriptor");
        if (!"SQLACTIONS".equals(this.readIdentifier())) {
            throw this.parseError("Excpected keyword 'SQLActions'");
        }
        this.readToken('[');
        this.readToken(']');
        this.readToken('=');
        this.readToken('{');
        do {
            this.readActionGroup();
        } while (this.readToken("},") != '}');
        int c = this.skipWhite();
        if (c >= 0) {
            throw this.parseError("Extraneous characters at end of descriptor");
        }
        this.m_logger.exiting("org.postgresql.pljava.management.SQLDeploymentDescriptor", "readDescriptor");
    }

    private void readActionGroup() throws ParseException {
        ArrayList<Command> commands;
        this.m_logger.entering("org.postgresql.pljava.management.SQLDeploymentDescriptor", "readActionGroup");
        this.readToken('\"');
        if (!"BEGIN".equals(this.readIdentifier())) {
            throw this.parseError("Expected keyword 'BEGIN'");
        }
        String actionType = this.readIdentifier();
        if ("INSTALL".equals(actionType)) {
            commands = this.m_installCommands;
        } else if ("REMOVE".equals(actionType)) {
            commands = this.m_removeCommands;
        } else {
            throw this.parseError("Expected keyword 'INSTALL' or 'REMOVE'");
        }
        while (true) {
            String implementorName;
            String cmd;
            int top;
            if ((top = (cmd = this.readCommand()).length()) >= 15 && "BEGIN ".equalsIgnoreCase(cmd.substring(0, 6)) && Character.isJavaIdentifierStart(cmd.charAt(6))) {
                int pos;
                for (pos = 7; pos < top && Character.isJavaIdentifierPart(cmd.charAt(pos)); ++pos) {
                }
                if (cmd.charAt(pos) != ' ') {
                    throw this.parseError("Expected whitespace after <implementor name>");
                }
                implementorName = cmd.substring(6, pos);
                int iLen = implementorName.length();
                int endNamePos = top - iLen;
                int endPos = endNamePos - 4;
                if (!implementorName.equalsIgnoreCase(cmd.substring(endNamePos)) || !"END ".equalsIgnoreCase(cmd.substring(endPos, endNamePos))) {
                    throw this.parseError("Implementor block must end with END <implementor name>");
                }
                cmd = cmd.substring(pos + 1, endPos);
            } else {
                implementorName = null;
            }
            commands.add(new Command(cmd.trim(), implementorName));
            int savePos = this.m_position;
            try {
                String tmp = this.readIdentifier();
                if ("END".equals(tmp) && actionType.equals(tmp = this.readIdentifier())) break;
                this.m_position = savePos;
            }
            catch (ParseException e) {
                this.m_position = savePos;
            }
        }
        this.readToken('\"');
        this.m_logger.exiting("org.postgresql.pljava.management.SQLDeploymentDescriptor", "readActionGroup");
    }

    private String readCommand() throws ParseException {
        this.m_logger.entering("org.postgresql.pljava.management.SQLDeploymentDescriptor", "readCommand");
        int startQuotePos = -1;
        int inQuote = 0;
        int c = this.skipWhite();
        this.m_buffer.setLength(0);
        block5: while (c != -1) {
            switch (c) {
                case 92: {
                    this.m_buffer.append((char)c);
                    c = this.read();
                    if (c == -1) continue block5;
                    this.m_buffer.append((char)c);
                    c = this.read();
                    continue block5;
                }
                case 34: 
                case 39: {
                    if (inQuote == 0) {
                        startQuotePos = this.m_position;
                        inQuote = c;
                    } else if (inQuote == c) {
                        startQuotePos = -1;
                        inQuote = 0;
                    }
                    this.m_buffer.append((char)c);
                    c = this.read();
                    continue block5;
                }
                case 59: {
                    if (inQuote == 0) {
                        String cmd = this.m_buffer.toString();
                        this.m_logger.exiting("org.postgresql.pljava.management.SQLDeploymentDescriptor", "readCommand", cmd);
                        return cmd;
                    }
                    this.m_buffer.append((char)c);
                    c = this.read();
                    continue block5;
                }
            }
            if (inQuote == 0 && Character.isWhitespace((char)c)) {
                this.m_buffer.append(' ');
                c = this.skipWhite();
                continue;
            }
            this.m_buffer.append((char)c);
            c = this.read();
        }
        if (inQuote != 0) {
            throw this.parseError("Untermintated " + (char)inQuote + " starting at position " + startQuotePos);
        }
        throw this.parseError("Unexpected EOF. Expecting ';' to end command");
    }

    private int skipWhite() throws ParseException {
        int c;
        block11: while (true) {
            if ((c = this.read()) >= 0 && Character.isWhitespace((char)c)) {
                continue;
            }
            if (c != 47) break;
            switch (this.peek()) {
                case 47: {
                    this.skip();
                    while (true) {
                        c = this.read();
                        switch (c) {
                            case -1: 
                            case 10: 
                            case 13: {
                                continue block11;
                            }
                        }
                    }
                }
                case 42: {
                    this.skip();
                    block13: while (true) {
                        c = this.read();
                        switch (c) {
                            case -1: {
                                throw this.parseError("Unexpected EOF when expecting end of multi line comment");
                            }
                            case 42: {
                                if (this.peek() != 47) continue block13;
                                this.skip();
                                continue block11;
                            }
                        }
                    }
                }
            }
            break;
        }
        return c;
    }

    private String readIdentifier() throws ParseException {
        int c = this.skipWhite();
        if (c < 0) {
            throw this.parseError("Unexpected EOF when expecting start of identifier");
        }
        char ch = (char)c;
        if (!Character.isJavaIdentifierStart(ch)) {
            throw this.parseError("Syntax error at '" + ch + "', expected identifier");
        }
        this.m_buffer.setLength(0);
        this.m_buffer.append(ch);
        while ((c = this.peek()) >= 0 && Character.isJavaIdentifierPart(ch = (char)c)) {
            this.m_buffer.append(ch);
            this.skip();
        }
        return this.m_buffer.toString().toUpperCase();
    }

    private char readToken(String tokens) throws ParseException {
        int c = this.skipWhite();
        if (c < 0) {
            throw this.parseError("Unexpected EOF when expecting one of \"" + tokens + '\"');
        }
        char ch = (char)c;
        if (tokens.indexOf(ch) < 0) {
            throw this.parseError("Syntax error at '" + ch + "', expected one of '" + tokens + "'");
        }
        return ch;
    }

    private char readToken(char token) throws ParseException {
        int c = this.skipWhite();
        if (c < 0) {
            throw this.parseError("Unexpected EOF when expecting token '" + token + '\'');
        }
        char ch = (char)c;
        if (ch != token) {
            throw this.parseError("Syntax error at '" + ch + "', expected '" + token + "'");
        }
        return ch;
    }

    private int peek() {
        return this.m_position >= this.m_image.length ? -1 : this.m_image[this.m_position];
    }

    private void skip() {
        ++this.m_position;
    }

    private int read() {
        int pos;
        return (pos = this.m_position++) >= this.m_image.length ? -1 : this.m_image[pos];
    }
}

