/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.log.Log;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResource;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.apache.velocity.util.ClassUtils;

public class StringResourceLoader
extends ResourceLoader {
    public static final String REPOSITORY_CLASS = "repository.class";
    public static final String REPOSITORY_CLASS_DEFAULT = (class$org$apache$velocity$runtime$resource$util$StringResourceRepositoryImpl == null ? (class$org$apache$velocity$runtime$resource$util$StringResourceRepositoryImpl = StringResourceLoader.class$("org.apache.velocity.runtime.resource.util.StringResourceRepositoryImpl")) : class$org$apache$velocity$runtime$resource$util$StringResourceRepositoryImpl).getName();
    public static final String REPOSITORY_ENCODING = "repository.encoding";
    public static final String REPOSITORY_ENCODING_DEFAULT = "UTF-8";
    static /* synthetic */ Class class$org$apache$velocity$runtime$resource$util$StringResourceRepositoryImpl;

    public static StringResourceRepository getRepository() {
        return RepositoryFactory.getRepository();
    }

    public void init(ExtendedProperties configuration) {
        this.log.info("StringResourceLoader : initialization starting.");
        String repositoryClass = configuration.getString(REPOSITORY_CLASS, REPOSITORY_CLASS_DEFAULT);
        String encoding = configuration.getString(REPOSITORY_ENCODING, REPOSITORY_ENCODING_DEFAULT);
        RepositoryFactory.setRepositoryClass(repositoryClass);
        RepositoryFactory.setEncoding(encoding);
        RepositoryFactory.init(this.log);
        this.log.info("StringResourceLoader : initialization complete.");
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        if (StringUtils.isEmpty((String)name)) {
            throw new ResourceNotFoundException("No template name provided");
        }
        StringResource resource = StringResourceLoader.getRepository().getStringResource(name);
        if (resource == null) {
            throw new ResourceNotFoundException("Could not locate resource '" + name + "'");
        }
        byte[] byteArray = null;
        try {
            byteArray = resource.getBody().getBytes(resource.getEncoding());
            return new ByteArrayInputStream(byteArray);
        }
        catch (UnsupportedEncodingException ue) {
            throw new VelocityException("Could not convert String using encoding " + resource.getEncoding(), ue);
        }
    }

    public boolean isSourceModified(Resource resource) {
        StringResource original = null;
        boolean result = true;
        original = StringResourceLoader.getRepository().getStringResource(resource.getName());
        if (original != null) {
            result = original.getLastModified() != resource.getLastModified();
        }
        return result;
    }

    public long getLastModified(Resource resource) {
        StringResource original = null;
        original = StringResourceLoader.getRepository().getStringResource(resource.getName());
        return original != null ? original.getLastModified() : 0L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class RepositoryFactory {
        private static boolean isInitialized = false;
        private static StringResourceRepository repository = null;

        private RepositoryFactory() {
        }

        public static void setRepositoryClass(String className) {
            if (isInitialized) {
                throw new IllegalStateException("The RepositoryFactory has already been initialized!");
            }
            try {
                repository = (StringResourceRepository)ClassUtils.getNewInstance(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new VelocityException("Could not find '" + className + "'", cnfe);
            }
            catch (IllegalAccessException iae) {
                throw new VelocityException("Could not access '" + className + "'", iae);
            }
            catch (InstantiationException ie) {
                throw new VelocityException("Could not instantiante '" + className + "'", ie);
            }
        }

        public static void setEncoding(String encoding) {
            if (repository == null) {
                throw new IllegalStateException("The Repository class has not yet been set!");
            }
            repository.setEncoding(encoding);
        }

        public static synchronized void init(Log log) throws VelocityException {
            if (isInitialized) {
                throw new IllegalStateException("Attempted to re-initialize Factory!");
            }
            if (log.isInfoEnabled()) {
                log.info("Using " + repository.getClass().getName() + " as repository implementation");
                log.info("Current repository encoding is " + repository.getEncoding());
            }
            isInitialized = true;
        }

        public static StringResourceRepository getRepository() {
            if (!isInitialized) {
                throw new IllegalStateException("RepositoryFactory was not properly set up");
            }
            return repository;
        }
    }
}

