/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaDataTest {
    private String m_methodName;
    private Object[] m_methodArgs;
    private Class<?>[] m_methodArgTypes;
    private ArrayList<String> m_results;

    public static Iterator<String> callMetaDataMethod(String methodCall) throws SQLException {
        return new MetaDataTest(methodCall).iterator();
    }

    public MetaDataTest(String methodCall) throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        DatabaseMetaData md = conn.getMetaData();
        this.m_results = new ArrayList();
        this.parseMethodCall(methodCall);
        try {
            Method m = DatabaseMetaData.class.getMethod(this.m_methodName, this.m_methodArgTypes);
            if (!m.getReturnType().equals(ResultSet.class)) {
                throw new NoSuchMethodException("Unexpected return type");
            }
            ResultSet rs = (ResultSet)m.invoke((Object)md, this.m_methodArgs);
            ResultSetMetaData rsmd = rs.getMetaData();
            int cnt = rsmd.getColumnCount();
            StringBuffer result = new StringBuffer();
            for (int i = 1; i <= cnt; ++i) {
                result.append((rsmd.getColumnName(i) + "(" + rsmd.getColumnClassName(i) + ")").replaceAll("(\\\\|;)", "\\$1") + ";");
            }
            this.m_results.add(result.toString());
            while (rs.next()) {
                result = new StringBuffer();
                Object rsObject = null;
                for (int i = 1; i <= cnt; ++i) {
                    rsObject = rs.getObject(i);
                    if (rsObject == null) {
                        rsObject = "<NULL>";
                    }
                    result.append(rsObject.toString().replaceAll("(\\\\|;)", "\\$1") + ";");
                }
                this.m_results.add(result.toString());
            }
            rs.close();
        }
        catch (NoSuchMethodException nme) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.m_methodArgTypes.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(this.m_methodArgTypes[i].getName());
            }
            throw new SQLException("No such method or non-resultset return type: " + this.m_methodName + "(" + sb.toString() + ")");
        }
        catch (InvocationTargetException ite) {
            throw new SQLException(ite.getTargetException().toString());
        }
        catch (Exception e) {
            throw new SQLException("Method error: " + e.toString());
        }
    }

    public void close() {
    }

    private Iterator<String> iterator() {
        return this.m_results.iterator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseMethodCall(String methodCall) throws SQLException {
        try {
            Pattern p = Pattern.compile("^\\s*([a-zA-Z_][a-zA-Z0-9_]*)\\s*\\((.*)\\)\\s*$");
            Matcher m = p.matcher(methodCall);
            ArrayList<Object> objects = new ArrayList<Object>();
            ArrayList<Class<Object>> types = new ArrayList<Class<Object>>();
            if (!m.matches()) throw new SQLException("Syntax error");
            this.m_methodName = m.group(1);
            String paramString = m.group(2).trim();
            p = Pattern.compile("^\\s*(\\(\\s*(?:String|int)\\s*(?:\\[\\s*\\])?\\s*\\)\\s*null|TRUE|FALSE|(?:\\-|\\+)?[0-9]+|\\[((?:[^\\[\\]])*)\\]|\"((?:[^\\\\\"]|\\\\.)*)\"|\\{((?:[^\\{\\}]|\"(?:[^\\\\\"]|\\\\.)*\")*)\\})\\s*(?:,|$)(.*)$");
            String auxParamString = paramString;
            while (!auxParamString.equals("")) {
                Matcher marr;
                String auxParamArr;
                Pattern parr;
                m = p.matcher(auxParamString);
                if (!m.matches()) {
                    throw new SQLException("Invalid parameter list: " + paramString);
                }
                String param = m.group(1);
                if (param.startsWith("\"")) {
                    param = m.group(3);
                    objects.add(param);
                    types.add(String.class);
                } else if (param.startsWith("{")) {
                    param = m.group(4);
                    parr = Pattern.compile("^\\s*\"((?:[^\\\\\"]|\\\\.)*)\"\\s*(?:,|$)(.*)$");
                    auxParamArr = param.trim();
                    ArrayList<String> strList = new ArrayList<String>();
                    while (!auxParamArr.equals("")) {
                        marr = parr.matcher(auxParamArr);
                        if (!marr.matches()) {
                            throw new SQLException("Invalid string array: " + param);
                        }
                        strList.add(marr.group(1));
                        auxParamArr = marr.group(2).trim();
                    }
                    objects.add(strList.toArray(new String[0]));
                    types.add(String[].class);
                } else if (param.equals("TRUE") || param.equals("FALSE")) {
                    objects.add(new Boolean(param));
                    types.add(Boolean.TYPE);
                } else if (param.startsWith("(")) {
                    Pattern pnull = Pattern.compile("^\\(\\s*(String|int)\\s*(\\[\\s*\\])?\\s*\\)\\s*null\\s*$");
                    Matcher mnull = pnull.matcher(param);
                    if (!mnull.matches()) throw new SQLException("Invalid null value: " + param);
                    objects.add(null);
                    if (mnull.group(2) == null) {
                        if (!mnull.group(1).equals("String")) throw new SQLException("Primitive 'int' cannot be null");
                        types.add(String.class);
                    } else if (mnull.group(1).equals("String")) {
                        types.add(String[].class);
                    } else {
                        types.add(int[].class);
                    }
                } else if (param.startsWith("[")) {
                    param = m.group(2);
                    parr = Pattern.compile("^\\s*(\\d+)\\s*(?:,|$)(.*)$");
                    auxParamArr = param.trim();
                    ArrayList<Integer> intList = new ArrayList<Integer>();
                    while (!auxParamArr.equals("")) {
                        marr = parr.matcher(auxParamArr);
                        if (!marr.matches()) {
                            throw new SQLException("Invalid int array: " + param);
                        }
                        intList.add(new Integer(marr.group(1)));
                        auxParamArr = marr.group(2).trim();
                    }
                    objects.add(intList.toArray(new Integer[0]));
                    types.add(int[].class);
                } else {
                    objects.add(new Integer(param));
                    types.add(Integer.TYPE);
                }
                auxParamString = m.group(5).trim();
            }
            this.m_methodArgs = objects.toArray(new Object[0]);
            this.m_methodArgTypes = types.toArray(new Class[0]);
            return;
        }
        catch (Exception e) {
            throw new SQLException("Invalid method call: " + methodCall + ". Cause: " + e.toString());
        }
    }
}

