/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

public class RandomInts
implements Iterator<Integer> {
    private final int m_rowCount;
    private final Random m_random;
    private int m_currentRow;

    public static Iterator<Integer> createIterator(int rowCount) throws SQLException {
        return new RandomInts(rowCount);
    }

    public RandomInts(int rowCount) throws SQLException {
        this.m_rowCount = rowCount;
        this.m_random = new Random(System.currentTimeMillis());
    }

    @Override
    public boolean hasNext() {
        return this.m_currentRow < this.m_rowCount;
    }

    @Override
    public Integer next() {
        if (this.m_currentRow < this.m_rowCount) {
            ++this.m_currentRow;
            return this.m_random.nextInt();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

