/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.postgresql.pljava.ResultSetProvider;
import org.postgresql.pljava.annotation.Function;

public class UsingProperties
implements ResultSetProvider {
    private static Logger s_logger = Logger.getAnonymousLogger();
    private final Iterator m_propertyIterator;

    public UsingProperties() throws IOException {
        Properties v = new Properties();
        InputStream propStream = this.getClass().getResourceAsStream("example.properties");
        if (propStream == null) {
            s_logger.fine("example.properties was null");
            this.m_propertyIterator = Collections.EMPTY_SET.iterator();
        } else {
            v.load(propStream);
            propStream.close();
            s_logger.fine("example.properties has " + v.size() + " entries");
            this.m_propertyIterator = v.entrySet().iterator();
        }
    }

    public boolean assignRowValues(ResultSet receiver, int currentRow) throws SQLException {
        if (!this.m_propertyIterator.hasNext()) {
            s_logger.fine("no more rows, returning false");
            return false;
        }
        Map.Entry propEntry = (Map.Entry)this.m_propertyIterator.next();
        receiver.updateString(1, (String)propEntry.getKey());
        receiver.updateString(2, (String)propEntry.getValue());
        return true;
    }

    @Function(type="javatest._properties")
    public static ResultSetProvider propertyExampleAnno() throws SQLException {
        try {
            return new UsingProperties();
        }
        catch (IOException e) {
            throw new SQLException("Error reading properties", e.getMessage());
        }
    }

    public void close() {
    }
}

