/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractCompileMojo;
import com.github.maven_nar.IncludePath;
import com.github.maven_nar.NarProperties;
import com.github.maven_nar.NarUtil;
import com.github.maven_nar.Test;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.CompilerDef;
import com.github.maven_nar.cpptasks.CompilerEnum;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.types.CompilerArgument;
import com.github.maven_nar.cpptasks.types.ConditionalFileSet;
import com.github.maven_nar.cpptasks.types.DefineArgument;
import com.github.maven_nar.cpptasks.types.DefineSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public abstract class Compiler {
    @Parameter
    private String name;
    @Parameter
    private String toolPath;
    @Parameter(defaultValue="${basedir}/src/main", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${basedir}/src/test", required=true)
    private File testSourceDirectory;
    @Parameter(required=true)
    private Set<String> includes = new HashSet<String>();
    @Parameter(required=true)
    private Set<String> excludes = new HashSet<String>();
    @Parameter(required=true)
    private Set<String> testIncludes = new HashSet<String>();
    @Parameter(required=true)
    private Set<String> testExcludes = new HashSet<String>();
    @Parameter(required=true)
    private boolean debug = false;
    @Parameter(defaultValue="true", required=true)
    private boolean exceptions = true;
    @Parameter(defaultValue="true", required=true)
    private boolean rtti = true;
    @Parameter(defaultValue="none", required=true)
    private String optimize = "none";
    @Parameter(required=true)
    private boolean multiThreaded = false;
    @Parameter
    private List<String> defines;
    @Parameter
    private String defineSet;
    @Parameter(required=true)
    private boolean clearDefaultDefines;
    @Parameter
    private List<String> undefines;
    @Parameter
    private String undefineSet;
    @Parameter
    private boolean clearDefaultUndefines;
    @Parameter
    private List<IncludePath> includePaths;
    @Parameter
    private List<IncludePath> testIncludePaths;
    @Parameter
    private List<String> systemIncludePaths;
    @Parameter
    private List<String> options;
    @Parameter
    private List<String> testOptions;
    @Parameter
    private String optionSet;
    @Parameter(required=true)
    private boolean clearDefaultOptions;
    @Parameter
    private String compileOrder;
    private AbstractCompileMojo mojo;
    public static final String MAIN = "main";
    public static final String TEST = "test";

    protected Compiler() {
    }

    public String getName() throws MojoFailureException, MojoExecutionException {
        if (this.name == null) {
            this.name = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(this.getPrefix() + "compiler");
        }
        return this.name;
    }

    public final void setAbstractCompileMojo(AbstractCompileMojo mojo) {
        this.mojo = mojo;
    }

    public final List<File> getSourceDirectories() {
        return this.getSourceDirectories("dummy");
    }

    private List<File> getSourceDirectories(String type) {
        Iterator i;
        ArrayList<File> sourceDirectories = new ArrayList<File>();
        File baseDir = this.mojo.getMavenProject().getBasedir();
        if (type.equals(TEST)) {
            if (this.testSourceDirectory == null) {
                this.testSourceDirectory = new File(baseDir, "/src/test");
            }
            if (this.testSourceDirectory.exists()) {
                sourceDirectories.add(this.testSourceDirectory);
            }
            i = this.mojo.getMavenProject().getTestCompileSourceRoots().iterator();
            while (i.hasNext()) {
                File extraTestSourceDirectory = new File((String)i.next());
                if (!extraTestSourceDirectory.exists()) continue;
                sourceDirectories.add(extraTestSourceDirectory);
            }
        } else {
            if (this.sourceDirectory == null) {
                this.sourceDirectory = new File(baseDir, "src/main");
            }
            if (this.sourceDirectory.exists()) {
                sourceDirectories.add(this.sourceDirectory);
            }
            i = this.mojo.getMavenProject().getCompileSourceRoots().iterator();
            while (i.hasNext()) {
                File extraSourceDirectory = new File((String)i.next());
                if (!extraSourceDirectory.exists()) continue;
                sourceDirectories.add(extraSourceDirectory);
            }
        }
        if (this.mojo.getLog().isDebugEnabled()) {
            i = sourceDirectories.iterator();
            while (i.hasNext()) {
                this.mojo.getLog().debug((CharSequence)("Added to sourceDirectory: " + ((File)i.next()).getPath()));
            }
        }
        return sourceDirectories;
    }

    protected final List<IncludePath> getIncludePaths(String type) {
        List<IncludePath> includeList;
        List<IncludePath> list = includeList = type.equals(TEST) ? this.testIncludePaths : this.includePaths;
        if (includeList != null && includeList.size() != 0) {
            return includeList;
        }
        includeList = new ArrayList<IncludePath>();
        Iterator<File> i = this.getSourceDirectories(type).iterator();
        while (i.hasNext()) {
            File file = new File(i.next(), "include");
            if (!file.isDirectory()) continue;
            IncludePath includePath = new IncludePath();
            includePath.setPath(file.getPath());
            includeList.add(includePath);
        }
        return includeList;
    }

    public final Set<String> getIncludes() throws MojoFailureException, MojoExecutionException {
        return this.getIncludes(MAIN);
    }

    protected final Set<String> getIncludes(String type) throws MojoFailureException, MojoExecutionException {
        HashSet<String> result = new HashSet<String>();
        if (!type.equals(TEST) && !this.includes.isEmpty()) {
            result.addAll(this.includes);
        } else if (type.equals(TEST) && !this.testIncludes.isEmpty()) {
            result.addAll(this.testIncludes);
        } else {
            String defaultIncludes = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(this.getPrefix() + "includes");
            if (defaultIncludes != null) {
                String[] include = defaultIncludes.split(" ");
                for (int i = 0; i < include.length; ++i) {
                    result.add(include[i].trim());
                }
            }
        }
        return result;
    }

    public final Set<String> getExcludes() throws MojoFailureException, MojoExecutionException {
        return this.getExcludes(MAIN);
    }

    protected final Set<String> getExcludes(String type) throws MojoFailureException, MojoExecutionException {
        HashSet<String> result = new HashSet<String>();
        if (type.equals(TEST) && !this.testExcludes.isEmpty()) {
            result.addAll(this.testExcludes);
        } else if (!this.excludes.isEmpty()) {
            result.addAll(this.excludes);
        } else {
            String defaultExcludes = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(this.getPrefix() + "excludes");
            if (defaultExcludes != null) {
                String[] exclude = defaultExcludes.split(" ");
                for (int i = 0; i < exclude.length; ++i) {
                    result.add(exclude[i].trim());
                }
            }
        }
        return result;
    }

    protected final String getPrefix() throws MojoFailureException, MojoExecutionException {
        return this.mojo.getAOL().getKey() + "." + this.getLanguage() + ".";
    }

    public final CompilerDef getTestCompiler(String type, String output) throws MojoFailureException, MojoExecutionException {
        CompilerDef compiler = this.getCompiler(type, output);
        if (this.testOptions != null) {
            Iterator<String> i = this.testOptions.iterator();
            while (i.hasNext()) {
                CompilerArgument arg = new CompilerArgument();
                arg.setValue(i.next());
                compiler.addConfiguredCompilerArg(arg);
            }
        }
        return compiler;
    }

    public final CompilerDef getCompiler(String type, String output) throws MojoFailureException, MojoExecutionException {
        DefineSet us;
        String[] pair;
        DefineSet ds;
        String optionsProperty;
        String name = this.getName();
        if (name == null) {
            return null;
        }
        CompilerDef compiler = new CompilerDef();
        compiler.setProject(this.mojo.getAntProject());
        CompilerEnum compilerName = new CompilerEnum();
        compilerName.setValue(name);
        compiler.setName(compilerName);
        if (this.toolPath != null) {
            compiler.setToolPath(this.toolPath);
        }
        compiler.setDebug(this.debug);
        compiler.setExceptions(this.exceptions);
        compiler.setRtti(this.rtti);
        compiler.setMultithreaded(this.mojo.getOS().equals("Windows") ? true : this.multiThreaded);
        OptimizationEnum optimization = new OptimizationEnum();
        optimization.setValue(this.optimize);
        compiler.setOptimize(optimization);
        if (this.options != null) {
            Iterator<Object> i = this.options.iterator();
            while (i.hasNext()) {
                CompilerArgument arg = new CompilerArgument();
                arg.setValue(i.next());
                compiler.addConfiguredCompilerArg(arg);
            }
        }
        if (this.optionSet != null) {
            String[] opts = this.optionSet.split("\\s");
            for (int i = 0; i < opts.length; ++i) {
                CompilerArgument arg = new CompilerArgument();
                arg.setValue(opts[i]);
                compiler.addConfiguredCompilerArg(arg);
            }
        }
        compiler.setClearDefaultOptions(this.clearDefaultOptions);
        if (!this.clearDefaultOptions && (optionsProperty = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(this.getPrefix() + "options")) != null) {
            String[] option = optionsProperty.split(" ");
            for (int i = 0; i < option.length; ++i) {
                CompilerArgument arg = new CompilerArgument();
                arg.setValue(option[i]);
                compiler.addConfiguredCompilerArg(arg);
            }
        }
        if (this.defines != null) {
            ds = new DefineSet();
            Iterator<String> i = this.defines.iterator();
            while (i.hasNext()) {
                DefineArgument define = new DefineArgument();
                pair = i.next().split("=", 2);
                define.setName(pair[0]);
                define.setValue(pair.length > 1 ? pair[1] : null);
                ds.addDefine(define);
            }
            compiler.addConfiguredDefineset(ds);
        }
        if (this.defineSet != null) {
            String[] defList = this.defineSet.split(",");
            DefineSet defSet = new DefineSet();
            for (int i = 0; i < defList.length; ++i) {
                pair = defList[i].trim().split("=", 2);
                DefineArgument def = new DefineArgument();
                def.setName(pair[0]);
                def.setValue(pair.length > 1 ? pair[1] : null);
                defSet.addDefine(def);
            }
            compiler.addConfiguredDefineset(defSet);
        }
        if (!this.clearDefaultDefines) {
            ds = new DefineSet();
            String defaultDefines = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(this.getPrefix() + "defines");
            if (defaultDefines != null) {
                ds.setDefine(new CUtil.StringArrayBuilder(defaultDefines));
            }
            compiler.addConfiguredDefineset(ds);
        }
        if (this.undefines != null) {
            us = new DefineSet();
            Iterator<String> i = this.undefines.iterator();
            while (i.hasNext()) {
                DefineArgument undefine = new DefineArgument();
                pair = i.next().split("=", 2);
                undefine.setName(pair[0]);
                undefine.setValue(pair.length > 1 ? pair[1] : null);
                us.addUndefine(undefine);
            }
            compiler.addConfiguredDefineset(us);
        }
        if (this.undefineSet != null) {
            String[] undefList = this.undefineSet.split(",");
            DefineSet undefSet = new DefineSet();
            for (int i = 0; i < undefList.length; ++i) {
                pair = undefList[i].trim().split("=", 2);
                DefineArgument undef = new DefineArgument();
                undef.setName(pair[0]);
                undef.setValue(pair.length > 1 ? pair[1] : null);
                undefSet.addUndefine(undef);
            }
            compiler.addConfiguredDefineset(undefSet);
        }
        if (!this.clearDefaultUndefines) {
            us = new DefineSet();
            String defaultUndefines = NarProperties.getInstance(this.mojo.getMavenProject()).getProperty(this.getPrefix() + "undefines");
            if (defaultUndefines != null) {
                us.setUndefine(new CUtil.StringArrayBuilder(defaultUndefines));
            }
            compiler.addConfiguredDefineset(us);
        }
        for (IncludePath includePath : this.getIncludePaths(type)) {
            if (!includePath.exists()) {
                throw new MojoFailureException("NAR: Include path not found: " + includePath);
            }
            compiler.createIncludePath().setPath(includePath.getPath());
        }
        if (this.systemIncludePaths != null) {
            for (String path : this.systemIncludePaths) {
                compiler.createSysIncludePath().setPath(path);
            }
        }
        List<File> srcDirs = this.getSourceDirectories(type);
        Set<String> includeSet = this.getIncludes(type);
        Set<String> excludeSet = this.getExcludes(type);
        for (Test test : this.mojo.getTests()) {
            if (test.getName().equals(output)) continue;
            excludeSet.add("**/" + test.getName() + ".*");
        }
        for (File srcDir : srcDirs) {
            this.mojo.getLog().debug((CharSequence)("Checking for existence of " + this.getLanguage() + " source directory: " + srcDir));
            if (!srcDir.exists()) continue;
            if (this.compileOrder != null) {
                compiler.setOrder(Arrays.asList(StringUtils.split((String)this.compileOrder, (String)", ")));
            }
            ConditionalFileSet fileSet = new ConditionalFileSet();
            fileSet.setProject(this.mojo.getAntProject());
            fileSet.setIncludes(StringUtils.join(includeSet.iterator(), (String)","));
            fileSet.setExcludes(StringUtils.join(excludeSet.iterator(), (String)","));
            fileSet.setDir(srcDir);
            compiler.addFileset(fileSet);
        }
        return compiler;
    }

    protected abstract String getLanguage();

    public final void copyIncludeFiles(MavenProject mavenProject, File targetDirectory) throws IOException {
        for (IncludePath includePath : this.getIncludePaths("dummy")) {
            if (!includePath.exists()) continue;
            NarUtil.copyDirectoryStructure(includePath.getFile(), targetDirectory, includePath.getIncludes(), "**/*~,**/#*#,**/.#*,**/%*%,**/._*,**/CVS,**/CVS/**,**/.cvsignore,**/SCCS,**/SCCS/**,**/vssver.scc,**/.svn,**/.svn/**,**/.DS_Store");
        }
    }
}

