/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.msvc;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.TargetMatcher;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinker;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.platforms.WindowsPlatform;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public abstract class MsvcCompatibleLinker
extends CommandLineLinker {
    public MsvcCompatibleLinker(String command, String identifierArg, String outputSuffix) {
        super(command, identifierArg, new String[]{".obj", ".lib", ".res"}, new String[]{".map", ".pdb", ".lnk", ".dll", ".tlb", ".rc", ".h"}, outputSuffix, false, null);
    }

    @Override
    protected void addBase(CCTask task, long base, Vector<String> args) {
        if (base >= 0L) {
            String baseAddr = Long.toHexString(base);
            args.addElement("/BASE:0x" + baseAddr);
        }
    }

    @Override
    protected void addFixed(CCTask task, Boolean fixed, Vector<String> args) {
        if (fixed != null) {
            if (fixed.booleanValue()) {
                args.addElement("/FIXED");
            } else {
                args.addElement("/FIXED:NO");
            }
        }
    }

    @Override
    protected void addImpliedArgs(CCTask task, boolean debug, LinkType linkType, Vector<String> args) {
        args.addElement("/NOLOGO");
        if (debug) {
            args.addElement("/DEBUG");
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("/DLL");
        }
        if (linkType.isSubsystemGUI()) {
            args.addElement("/SUBSYSTEM:WINDOWS");
        } else if (linkType.isSubsystemConsole()) {
            args.addElement("/SUBSYSTEM:CONSOLE");
        }
    }

    @Override
    protected void addIncremental(CCTask task, boolean incremental, Vector<String> args) {
        if (incremental) {
            args.addElement("/INCREMENTAL:YES");
        } else {
            args.addElement("/INCREMENTAL:NO");
        }
    }

    @Override
    protected void addMap(CCTask task, boolean map, Vector<String> args) {
        if (map) {
            args.addElement("/MAP");
        }
    }

    @Override
    protected void addStack(CCTask task, int stack, Vector<String> args) {
        if (stack >= 0) {
            String stackStr = Integer.toHexString(stack);
            args.addElement("/STACK:0x" + stackStr);
        }
    }

    @Override
    protected void addEntry(CCTask task, String entry, Vector<String> args) {
        if (entry != null) {
            args.addElement("/ENTRY:" + entry);
        }
    }

    @Override
    public String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    @Override
    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    @Override
    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        StringBuffer buf = new StringBuffer();
        String[] patterns = new String[libnames.length];
        for (int i = 0; i < libnames.length; ++i) {
            buf.setLength(0);
            buf.append(libnames[i]);
            buf.append(".lib");
            patterns[i] = buf.toString();
        }
        return patterns;
    }

    @Override
    public int getMaximumCommandLength() {
        return 32000;
    }

    @Override
    public String[] getOutputFileSwitch(String outputFile) {
        return new String[]{"/OUT:" + outputFile};
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public void addVersionFiles(VersionInfo versionInfo, LinkType linkType, File outputFile, boolean isDebug, File objDir, TargetMatcher matcher) throws IOException {
        WindowsPlatform.addVersionFiles(versionInfo, linkType, outputFile, isDebug, objDir, matcher);
    }
}

