/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.os390;

import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.CompilerDef;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.compiler.AbstractCompiler;
import com.github.maven_nar.cpptasks.compiler.CommandLineCCompiler;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.os390.OS390Linker;
import com.github.maven_nar.cpptasks.os390.OS390Processor;
import com.github.maven_nar.cpptasks.types.DefineArgument;
import com.github.maven_nar.cpptasks.types.UndefineArgument;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.types.Environment;

public class OS390CCompiler
extends CommandLineCCompiler {
    private static final AbstractCompiler instance = new OS390CCompiler(false, null);

    public static AbstractCompiler getInstance() {
        return instance;
    }

    private OS390CCompiler(boolean newEnvironment, Environment env) {
        super("cxx", null, new String[]{".c", ".cc", ".cpp", ".cxx", ".c++", ".s"}, new String[]{".h", ".hpp"}, ".o", false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector<String> args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("-c");
        args.addElement("-W");
        args.addElement("c,NOEXPMAC,NOSHOWINC");
        if (debug) {
            args.addElement("-g");
            args.addElement("-D");
            args.addElement("_DEBUG");
        } else {
            args.addElement("-D");
            args.addElement("NEBUG");
        }
    }

    @Override
    protected void addWarningSwitch(Vector<String> args, int level) {
        OS390Processor.addWarningSwitch(args, level);
    }

    @Override
    protected void buildDefineArguments(CompilerDef[] defs, Vector<String> args) {
        UndefineArgument[] merged = defs[0].getActiveDefines();
        for (int i = 1; i < defs.length; ++i) {
            merged = DefineArgument.merge(defs[i].getActiveDefines(), merged);
        }
        StringBuffer buf = new StringBuffer(30);
        for (int i = 0; i < merged.length; ++i) {
            buf.setLength(0);
            UndefineArgument current = merged[i];
            if (current.isDefine()) {
                args.addElement("-D");
                buf.append(current.getName());
                if (current.getValue() != null && current.getValue().length() > 0) {
                    buf.append('=');
                    buf.append(current.getValue());
                }
                args.addElement(buf.toString());
                continue;
            }
            args.addElement("-U");
            args.addElement(current.getName());
        }
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new OS390CCompiler(newEnvironment, env);
        }
        return this;
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ":");
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return OS390Processor.getIncludeDirSwitch(includeDir);
    }

    @Override
    public Linker getLinker(LinkType type) {
        return OS390Linker.getInstance().getLinker(type);
    }

    @Override
    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getMaximumInputFilesPerCommand() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
    }
}

