/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.os390;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.CUtil;
import com.github.maven_nar.cpptasks.VersionInfo;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinker;
import com.github.maven_nar.cpptasks.compiler.CommandLineLinkerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.os390.OS390Processor;
import com.github.maven_nar.cpptasks.types.LibrarySet;
import com.github.maven_nar.cpptasks.types.LibraryTypeEnum;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;

public final class OS390Linker
extends CommandLineLinker {
    private static final OS390Linker datasetLinker = new OS390Linker();
    private static final OS390Linker dllLinker = new OS390Linker("", ".dll");
    private static final OS390Linker instance = new OS390Linker("", "");
    private boolean isADatasetLinker;
    File outputFile;
    private String outputPrefix;
    CCTask task;

    public static OS390Linker getDataSetInstance() {
        return datasetLinker;
    }

    public static OS390Linker getInstance() {
        return instance;
    }

    private OS390Linker() {
        super("cxx", "/bogus", new String[]{".o", ".a", ".lib", ".xds"}, new String[]{".dll", ".x"}, ".xds", false, null);
        this.outputPrefix = "";
        this.isADatasetLinker = true;
    }

    private OS390Linker(String outputPrefix, String outputSuffix) {
        super("cxx", "/bogus", new String[]{".o", ".a", ".lib", ".x"}, new String[]{".dll"}, outputSuffix, false, null);
        this.outputPrefix = outputPrefix;
        this.isADatasetLinker = false;
    }

    protected void addBase(long base, Vector<String> args) {
    }

    protected void addFixed(Boolean fixed, Vector<String> args) {
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector<String> args) {
        if (linkType.isSharedLibrary()) {
            args.addElement("-W");
            args.addElement("l,DLL");
        }
    }

    protected void addIncremental(boolean incremental, Vector<String> args) {
    }

    @Override
    protected String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector<String> preargs, Vector<String> midargs, Vector<String> endargs) {
        if (libsets != null) {
            for (int i = 0; i < libsets.length; ++i) {
                String[] libs = libsets[i].getLibs();
                for (int j = 0; j < libs.length; ++j) {
                    if (libs[j].startsWith("//")) {
                        endargs.addElement("-l");
                        endargs.addElement(libs[j]);
                        continue;
                    }
                    if (libsets[i].getDataset() == null) continue;
                    String ds = libsets[i].getDataset();
                    endargs.addElement("//'" + ds + "(" + libs[j] + ")'");
                }
            }
        }
        return super.addLibrarySets(task, libsets, preargs, midargs, endargs);
    }

    protected void addMap(boolean map, Vector<String> args) {
    }

    protected void addStack(int stack, Vector<String> args) {
    }

    protected void addEntry(String entry, Vector<String> args) {
    }

    @Override
    public String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    @Override
    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    @Override
    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        StringBuffer buf = new StringBuffer();
        String[] patterns = new String[libnames.length * 3];
        int offset = OS390Linker.addLibraryPatterns(libnames, buf, "lib", ".a", patterns, 0);
        offset = OS390Linker.addLibraryPatterns(libnames, buf, "", ".x", patterns, offset);
        offset = OS390Linker.addLibraryPatterns(libnames, buf, "", ".o", patterns, offset);
        return patterns;
    }

    private static int addLibraryPatterns(String[] libnames, StringBuffer buf, String prefix, String extension, String[] patterns, int offset) {
        for (int i = 0; i < libnames.length; ++i) {
            buf.setLength(0);
            buf.append(prefix);
            buf.append(libnames[i]);
            buf.append(extension);
            patterns[offset + i] = buf.toString();
        }
        return offset + libnames.length;
    }

    @Override
    public Linker getLinker(LinkType linkType) {
        if (this == datasetLinker) {
            return datasetLinker;
        }
        if (linkType.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }

    @Override
    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String[] getOutputFileNames(String baseName, VersionInfo versionInfo) {
        String[] baseNames = super.getOutputFileNames(baseName, versionInfo);
        if (this.outputPrefix.length() > 0) {
            for (int i = 0; i < baseNames.length; ++i) {
                baseNames[i] = this.outputPrefix + baseNames[i];
            }
        }
        return baseNames;
    }

    @Override
    protected String[] getOutputFileSwitch(CCTask task, String outputFile) {
        if (this.isADatasetLinker && task.getDataset() != null) {
            String ds = task.getDataset();
            outputFile = "//'" + ds + "(" + outputFile + ")'";
        }
        return this.getOutputFileSwitch(outputFile);
    }

    @Override
    public String[] getOutputFileSwitch(String outputFile) {
        return new String[]{"-o", outputFile};
    }

    @Override
    public boolean isCaseSensitive() {
        return OS390Processor.isCaseSensitive();
    }

    @Override
    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        int p;
        this.task = task;
        this.outputFile = outputFile;
        if (this.isADatasetLinker && (p = outputFile.getName().indexOf(".")) >= 0) {
            String newname = outputFile.getName().substring(0, p);
            outputFile = new File(outputFile.getParent(), newname);
        }
        super.link(task, outputFile, sourceFiles, config);
    }

    @Override
    protected int runCommand(CCTask task, File workingDir, String[] cmdline) throws BuildException {
        int rc = super.runCommand(task, workingDir, cmdline);
        if (rc == 0) {
            try {
                this.outputFile.delete();
                new FileOutputStream(this.outputFile).close();
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage());
            }
        }
        return rc;
    }
}

