/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.mappers;

import java.io.File;
import java.nio.file.Path;
import sbt.internal.inc.Stamper$;
import sbt.internal.inc.mappers.MapperUtils;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import xsbti.compile.analysis.Stamp;

public final class MapperUtils$ {
    public static MapperUtils$ MODULE$;
    private final int MARKER_LENGTH;

    static {
        new MapperUtils$();
    }

    public File rebase(File target, Path from, Path to) {
        return to.resolve(from.relativize(target.toPath())).toFile();
    }

    private final String RELATIVE_MARKER() {
        return "\u2603\u2603\u2603";
    }

    private final int MARKER_LENGTH() {
        return this.MARKER_LENGTH;
    }

    private final String relativeReadError(String path) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected path ", " was not written by a relative write mapper. Paths have to start with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, "\u2603\u2603\u2603"}));
    }

    public File makeRelative(File file, Path from) {
        Path relativePath = from.relativize(file.toPath());
        return new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"\u2603\u2603\u2603", relativePath})));
    }

    public File reconstructRelative(File file, Path from) {
        String filePath = ((Object)file.toPath()).toString();
        if (!filePath.startsWith("\u2603\u2603\u2603")) {
            throw new MapperUtils.RelativePathAssumptionBroken(this.relativeReadError(filePath));
        }
        String cleanPath = (String)new StringOps(Predef$.MODULE$.augmentString(filePath)).drop(this.MARKER_LENGTH());
        return from.resolve(cleanPath).toFile();
    }

    public Stamp recomputeModificationDate(File previouslyStampedFile) {
        return (Stamp)Stamper$.MODULE$.forLastModified().apply((Object)previouslyStampedFile);
    }

    private MapperUtils$() {
        MODULE$ = this;
        this.MARKER_LENGTH = "\u2603\u2603\u2603".length();
    }
}

