/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BugReporterObserver;
import edu.umd.cs.findbugs.DelegatingBugReporter;
import java.util.HashSet;
import java.util.Set;

public class ErrorCountingBugReporter
extends DelegatingBugReporter {
    private int bugCount = 0;
    private final HashSet<String> errors = new HashSet();
    private final Set<String> missingClassSet = new HashSet<String>();

    public ErrorCountingBugReporter(BugReporter realBugReporter) {
        super(realBugReporter);
        realBugReporter.addObserver(new BugReporterObserver(){

            @Override
            public void reportBug(BugInstance bugInstance) {
                ++ErrorCountingBugReporter.this.bugCount;
            }
        });
    }

    public int getBugCount() {
        return this.bugCount;
    }

    public int getMissingClassCount() {
        return this.missingClassSet.size();
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    @Override
    public void logError(String message) {
        if (this.errors.add(message)) {
            super.logError(message);
        }
    }

    @Override
    public void reportMissingClass(ClassNotFoundException ex) {
        String missing = AbstractBugReporter.getMissingClassName(ex);
        if (missing == null || missing.startsWith("[") || "java.lang.Synthetic".equals(missing)) {
            return;
        }
        if (this.missingClassSet.add(missing)) {
            super.reportMissingClass(ex);
        }
    }
}

