/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.SIPUSH;

public class AssertionMethods
implements Constants {
    private static final boolean DEBUG = SystemProperties.getBoolean("assertionmethods.debug");
    private final BitSet assertionMethodRefSet = new BitSet();
    @StaticConstant
    private static final List<UserAssertionMethod> userAssertionMethodList = new ArrayList<UserAssertionMethod>();

    public AssertionMethods(JavaClass jclass) {
        this.init(jclass);
    }

    private void init(JavaClass jclass) {
        ConstantPool cp = jclass.getConstantPool();
        int numConstants = cp.getLength();
        for (int i = 0; i < numConstants; ++i) {
            try {
                Constant c = cp.getConstant(i);
                if (!(c instanceof ConstantMethodref)) continue;
                ConstantMethodref cmr = (ConstantMethodref)c;
                ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex(), (byte)12);
                String methodName = ((ConstantUtf8)cp.getConstant(cnat.getNameIndex(), (byte)1)).getBytes();
                String className = cp.getConstantString(cmr.getClassIndex(), (byte)7).replace('/', '.');
                String methodSig = ((ConstantUtf8)cp.getConstant(cnat.getSignatureIndex(), (byte)1)).getBytes();
                String classNameLC = className.toLowerCase();
                String methodNameLC = methodName.toLowerCase();
                boolean voidReturnType = methodSig.endsWith(")V");
                boolean boolReturnType = methodSig.endsWith(")Z");
                if (DEBUG) {
                    System.out.print("Is " + className + "." + methodName + " assertion method: " + voidReturnType);
                }
                if (AssertionMethods.isUserAssertionMethod(className, methodName) || className.endsWith("Assert") && methodName.startsWith("is") || (voidReturnType || boolReturnType) && (classNameLC.indexOf("assert") >= 0 || methodNameLC.startsWith("throw") || methodName.startsWith("affirm") || methodName.startsWith("panic") || "logTerminal".equals(methodName) || methodName.startsWith("logAndThrow") || "insist".equals(methodNameLC) || "usage".equals(methodNameLC) || "exit".equals(methodNameLC) || methodNameLC.startsWith("fail") || methodNameLC.startsWith("fatal") || methodNameLC.indexOf("assert") >= 0 || methodNameLC.indexOf("legal") >= 0 || methodNameLC.indexOf("error") >= 0 || methodNameLC.indexOf("abort") >= 0 || methodNameLC.indexOf("failed") >= 0) || "addOrThrowException".equals(methodName)) {
                    this.assertionMethodRefSet.set(i);
                    if (!DEBUG) continue;
                    System.out.println("==> YES");
                    continue;
                }
                if (!DEBUG) continue;
                System.out.println("==> NO");
                continue;
            }
            catch (ClassFormatException e) {
                // empty catch block
            }
        }
    }

    private static boolean isUserAssertionMethod(String className, String methodName) {
        for (UserAssertionMethod uam : userAssertionMethodList) {
            if (!className.equals(uam.getClassName()) || !methodName.equals(uam.getMethodName())) continue;
            return true;
        }
        return false;
    }

    public boolean isAssertionHandle(InstructionHandle handle, ConstantPoolGen cpg) {
        Instruction next;
        int v;
        Instruction ins = handle.getInstruction();
        if (this.isAssertionInstruction(ins, cpg)) {
            return true;
        }
        if (ins instanceof SIPUSH && (v = ((SIPUSH)ins).getValue().intValue()) == 500 && (next = handle.getNext().getInstruction()) instanceof INVOKEINTERFACE) {
            INVOKEINTERFACE iInterface = (INVOKEINTERFACE)next;
            String className = iInterface.getClassName(cpg);
            String fieldName = iInterface.getMethodName(cpg);
            if ("javax.servlet.http.HttpServletResponse".equals(className) && "setStatus".equals(fieldName)) {
                return true;
            }
        }
        return false;
    }

    public boolean isAssertionInstruction(Instruction ins, ConstantPoolGen cpg) {
        if (ins instanceof InvokeInstruction) {
            return this.isAssertionCall((InvokeInstruction)ins);
        }
        if (ins instanceof GETSTATIC) {
            GETSTATIC getStatic = (GETSTATIC)ins;
            String className = getStatic.getClassName(cpg);
            String fieldName = getStatic.getFieldName(cpg);
            if ("java.util.logging.Level".equals(className) && "SEVERE".equals(fieldName)) {
                return true;
            }
            return "org.apache.log4j.Level".equals(className) && ("ERROR".equals(fieldName) || "FATAL".equals(fieldName));
        }
        return false;
    }

    public boolean isAssertionCall(InvokeInstruction inv) {
        boolean isAssertionMethod = this.assertionMethodRefSet.get(inv.getIndex());
        return isAssertionMethod;
    }

    static {
        String userProperty = SystemProperties.getProperty("findbugs.assertionmethods");
        if (userProperty != null) {
            StringTokenizer tok = new StringTokenizer(userProperty, ",");
            while (tok.hasMoreTokens()) {
                String fullyQualifiedName = tok.nextToken();
                int lastDot = fullyQualifiedName.lastIndexOf(46);
                if (lastDot < 0) continue;
                String className = fullyQualifiedName.substring(0, lastDot);
                String methodName = fullyQualifiedName.substring(lastDot + 1);
                userAssertionMethodList.add(new UserAssertionMethod(className, methodName));
            }
        }
    }

    private static class UserAssertionMethod {
        private final String className;
        private final String methodName;

        public UserAssertionMethod(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }
}

