/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.interproc;

import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabase;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabaseFormatException;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.IOException;
import java.io.Writer;

public abstract class MethodPropertyDatabase<Property>
extends PropertyDatabase<MethodDescriptor, Property> {
    @Override
    protected MethodDescriptor parseKey(String methodStr) throws PropertyDatabaseFormatException {
        String[] tuple = methodStr.split(",");
        if (tuple.length != 4) {
            throw new PropertyDatabaseFormatException("Invalid method tuple: " + methodStr);
        }
        try {
            int accessFlags = Integer.parseInt(tuple[3]);
            String className = XFactory.canonicalizeString(tuple[0]);
            String methodName = XFactory.canonicalizeString(tuple[1]);
            String methodSig = XFactory.canonicalizeString(tuple[2]);
            return DescriptorFactory.instance().getMethodDescriptor(ClassName.toSlashedClassName(className), methodName, methodSig, (accessFlags & 8) != 0);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    protected void writeKey(Writer writer, MethodDescriptor method) throws IOException {
        writer.write(method.getClassDescriptor().toDottedClassName());
        writer.write(",");
        writer.write(method.getName());
        writer.write(",");
        writer.write(method.getSignature());
        writer.write(",");
        XMethod xMethod = XFactory.createXMethod(method);
        writer.write(Integer.toString(xMethod.getAccessFlags() & 0xF));
    }
}

