/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class CallToUnconditionalThrower
extends PreorderVisitor
implements Detector {
    static boolean DEBUG = false;
    BugReporter bugReporter;
    AnalysisContext analysisContext;
    private final boolean testingEnabled;

    public CallToUnconditionalThrower(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.testingEnabled = SystemProperties.getBoolean("report_TESTING_pattern_in_standard_detectors");
    }

    @Override
    public void report() {
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        if (BCELUtil.isSynthetic((FieldOrMethod)method) || (method.getAccessFlags() & 0x40) == 64) {
            return;
        }
        CFG cfg = classContext.getCFG(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        Iterator<BasicBlock> i = cfg.blockIterator();
        while (i.hasNext()) {
            boolean newResult;
            InstructionHandle thrower;
            Instruction ins;
            BasicBlock basicBlock = i.next();
            if (!basicBlock.isExceptionThrower() || !((ins = (thrower = basicBlock.getExceptionThrower()).getInstruction()) instanceof InvokeInstruction)) continue;
            InvokeInstruction inv = (InvokeInstruction)ins;
            boolean foundThrower = false;
            boolean foundNonThrower = false;
            if (inv instanceof INVOKEINTERFACE) continue;
            String className = inv.getClassName(cpg);
            Location loc = new Location(thrower, basicBlock);
            TypeFrame typeFrame = (TypeFrame)typeDataflow.getFactAtLocation(loc);
            XMethod primaryXMethod = XFactory.createXMethod(inv, cpg);
            Set<XMethod> targetSet = null;
            try {
                String methodSig;
                if (className.startsWith("[") || !(methodSig = inv.getSignature(cpg)).endsWith("V")) continue;
                targetSet = Hierarchy2.resolveMethodCallTargets(inv, typeFrame, cpg);
                for (XMethod xMethod : targetSet) {
                    boolean isUnconditionalThrower;
                    if (DEBUG) {
                        System.out.println("\tFound " + xMethod);
                    }
                    boolean bl = isUnconditionalThrower = xMethod.isUnconditionalThrower() && !xMethod.isUnsupported() && !xMethod.isSynthetic();
                    if (isUnconditionalThrower) {
                        foundThrower = true;
                        if (!DEBUG) continue;
                        System.out.println("Found thrower");
                        continue;
                    }
                    foundNonThrower = true;
                    if (!DEBUG) continue;
                    System.out.println("Found non thrower");
                }
            }
            catch (ClassNotFoundException e) {
                this.analysisContext.getLookupFailureCallback().reportMissingClass(e);
            }
            if (!(newResult = foundThrower && !foundNonThrower)) continue;
            this.bugReporter.reportBug(new BugInstance(this, "TESTING", 2).addClassAndMethod(classContext.getJavaClass(), method).addString("Call to method that always throws Exception").addMethod(primaryXMethod).describe("METHOD_CALLED").addSourceLine(classContext, method, loc));
        }
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        if (!this.testingEnabled) {
            return;
        }
        this.analysisContext = AnalysisContext.currentAnalysisContext();
        for (Method method : methodList = classContext.getJavaClass().getMethods()) {
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error checking for infinite recursive loop in " + SignatureConverter.convertMethodSignature(classContext.getJavaClass(), method), e);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error checking for infinite recursive loop in " + SignatureConverter.convertMethodSignature(classContext.getJavaClass(), method), e);
            }
        }
    }
}

