/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.charsets.UTF8;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.bcel.classfile.Code;

public class Noise
extends OpcodeStackDetector {
    final BugAccumulator accumulator;
    final HashQueue hq;
    byte[] primer;

    public Noise(BugReporter bugReporter) throws NoSuchAlgorithmException {
        this.accumulator = new BugAccumulator(bugReporter);
        this.hq = new HashQueue(24);
    }

    @Override
    public void visit(Code code) {
        this.primer = UTF8.getBytes(this.getFullyQualifiedMethodName());
        super.visit(code);
        this.accumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawInt(int i) {
        this.hq.push(i);
    }

    @Override
    public void sawLong(long x) {
        this.hq.push((int)(x >> 0));
        this.hq.push((int)(x >> 32));
    }

    @Override
    public void sawString(String s) {
        this.hq.pushHash(s);
    }

    @Override
    public void sawClass() {
        this.hq.push(this.getClassConstantOperand());
    }

    @Override
    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                this.hq.pushHash(this.getClassConstantOperand());
                if (this.getNameConstantOperand().indexOf(36) == -1) {
                    this.hq.pushHash(this.getNameConstantOperand());
                }
                this.hq.pushHash(this.getSigConstantOperand());
                int priority = this.hq.getPriority();
                if (priority > 3) break;
                this.accumulator.accumulateBug(new BugInstance(this, "NOISE_METHOD_CALL", priority).addClassAndMethod(this).addCalledMethod(this), this);
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                this.hq.pushHash(this.getClassConstantOperand());
                if (this.getNameConstantOperand().indexOf(36) == -1) {
                    this.hq.pushHash(this.getNameConstantOperand());
                }
                this.hq.pushHash(this.getSigConstantOperand());
                int priority = this.hq.getPriority();
                if (priority > 3) break;
                this.accumulator.accumulateBug(new BugInstance(this, "NOISE_FIELD_REFERENCE", priority).addClassAndMethod(this).addReferencedField(this), this);
                break;
            }
            case 187: 
            case 192: 
            case 193: {
                this.hq.pushHash(this.getClassConstantOperand());
                break;
            }
            case 46: 
            case 50: 
            case 51: 
            case 79: 
            case 83: 
            case 84: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 112: 
            case 116: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 148: 
            case 153: 
            case 154: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 170: 
            case 171: 
            case 172: 
            case 176: 
            case 177: 
            case 188: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                this.hq.push(seen);
                int priority = this.hq.getPriority();
                if (priority > 3) break;
                this.accumulator.accumulateBug(new BugInstance(this, "NOISE_OPERATION", priority).addClassAndMethod(this).addString(OPCODE_NAMES[seen]), this);
                break;
            }
        }
    }

    class HashQueue {
        MessageDigest md = MessageDigest.getInstance("SHA");
        final int size;
        int next = 0;
        final byte[] data;

        HashQueue(int size) throws NoSuchAlgorithmException {
            this.size = size;
            this.data = new byte[size];
        }

        public void push(byte b) {
            this.data[this.next++] = b;
            if (this.next == this.size) {
                this.next = 0;
            }
        }

        public void reset() {
            this.next = 0;
            for (int i = 0; i < this.size; ++i) {
                this.data[i] = 0;
            }
        }

        public void push(String s) {
            for (byte b : UTF8.getBytes(s)) {
                this.push(b);
            }
        }

        public void pushHash(Object x) {
            this.push(x.hashCode());
        }

        public void push(int x) {
            this.push((byte)x);
            this.push((byte)(x >> 8));
            this.push((byte)(x >> 16));
            this.push((byte)(x >> 24));
        }

        public int getHash() {
            this.md.update(Noise.this.primer);
            this.md.update(this.data, this.next, this.size - this.next);
            this.md.update(this.data, 0, this.next);
            byte[] hash = this.md.digest();
            int result = hash[0] & 0xFF | (hash[1] & 0xFF) << 8 | (hash[2] & 0xFF) << 16 | (hash[3] & 0x7F) << 24;
            return result;
        }

        public int getPriority() {
            int hash = this.getHash();
            if ((hash & 0x1FF0) == 0) {
                if ((hash &= 0xF) < 1) {
                    return 1;
                }
                if (hash < 3) {
                    return 2;
                }
                if (hash < 7) {
                    return 3;
                }
                return 5;
            }
            return 6;
        }
    }
}

