/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.ValueRangeAnalysisFactory;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IfInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class RedundantConditions
implements Detector {
    private final BugAccumulator bugAccumulator;
    private final BugReporter bugReporter;

    public RedundantConditions(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        for (Method method : classContext.getJavaClass().getMethods()) {
            ValueRangeAnalysisFactory.ValueRangeAnalysis analysis;
            MethodDescriptor methodDescriptor = BCELUtil.getMethodDescriptor(classContext.getJavaClass(), method);
            try {
                analysis = Global.getAnalysisCache().getMethodAnalysis(ValueRangeAnalysisFactory.ValueRangeAnalysis.class, methodDescriptor);
            }
            catch (CheckedAnalysisException e) {
                this.bugReporter.logError("ValueRangeAnalysis failed for " + methodDescriptor, e);
                continue;
            }
            if (analysis == null) continue;
            for (ValueRangeAnalysisFactory.RedundantCondition condition : analysis.getRedundantConditions()) {
                int priority = this.getPriority(methodDescriptor, condition);
                SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, method, condition.getLocation().getHandle().getPosition());
                BugInstance bug = new BugInstance(condition.isByType() ? "UC_USELESS_CONDITION_TYPE" : "UC_USELESS_CONDITION", priority).addClassAndMethod(methodDescriptor).add(new StringAnnotation(this.normalize(condition.getTrueCondition())));
                if (condition.isByType()) {
                    bug.addType(condition.getSignature());
                }
                if (condition.isDeadCodeUnreachable() && condition.getDeadCodeLocation() != null && priority == 1) {
                    bug.addSourceLine(methodDescriptor, condition.getDeadCodeLocation()).describe("SOURCE_UNREACHABLE_CODE");
                }
                this.bugAccumulator.accumulateBug(bug, sourceLineAnnotation);
            }
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    private String normalize(String condition) {
        if (condition.startsWith("this.this$")) {
            return condition.substring("this.".length());
        }
        if (condition.startsWith("this.val$")) {
            return condition.substring("this.val$".length());
        }
        return condition;
    }

    private int getPriority(MethodDescriptor methodDescriptor, ValueRangeAnalysisFactory.RedundantCondition condition) {
        int priority;
        if (condition.isByType()) {
            long number = condition.getNumber().longValue();
            switch (condition.getSignature()) {
                case "I": {
                    if (number != Integer.MIN_VALUE && number != Integer.MAX_VALUE) break;
                    return 5;
                }
                case "C": {
                    if (number > 0L) break;
                    return 5;
                }
                case "B": {
                    if (number >= -128L && number < 127L) break;
                    return 5;
                }
            }
        }
        int n = condition.isDeadCodeUnreachable() ? 1 : (priority = condition.isBorder() || condition.getSignature().equals("Z") ? 3 : 2);
        if (condition.getDeadCodeLocation() != null && condition.getLiveCodeLocation() != null && condition.isDeadCodeUnreachable()) {
            InstructionHandle deadHandle = condition.getDeadCodeLocation().getHandle();
            InstructionHandle liveHandle = condition.getLiveCodeLocation().getHandle();
            int deadValue = this.getIntValue(deadHandle);
            int liveValue = this.getIntValue(liveHandle);
            if (deadValue == 0 && liveValue == 1 || deadValue == 1 && liveValue == 0) {
                InstructionHandle deadNext = deadHandle.getNext();
                InstructionHandle liveNext = liveHandle.getNext();
                if (deadNext != null && liveNext != null) {
                    short opcode;
                    Instruction consumerInst;
                    MethodGen methodGen;
                    InstructionHandle after;
                    InstructionHandle middle;
                    if (deadNext.getNext() == liveHandle) {
                        middle = deadNext;
                        after = liveNext;
                    } else if (liveNext.getNext() == deadHandle) {
                        middle = liveNext;
                        after = deadNext;
                    } else {
                        return priority;
                    }
                    if (!(middle.getInstruction() instanceof GOTO) || ((GOTO)middle.getInstruction()).getTarget() != after) {
                        return priority;
                    }
                    try {
                        methodGen = Global.getAnalysisCache().getMethodAnalysis(MethodGen.class, methodDescriptor);
                    }
                    catch (CheckedAnalysisException e) {
                        return priority;
                    }
                    InstructionHandle consumer = this.getConsumer(methodGen, after);
                    Instruction instruction = consumerInst = consumer == null ? null : consumer.getInstruction();
                    if (consumerInst != null && ((opcode = consumerInst.getOpcode()) == 96 || opcode == 100 || opcode == 104 || opcode == 122 || opcode == 120 || opcode == 124)) {
                        return priority;
                    }
                    if (condition.getSignature().equals("Z")) {
                        return 5;
                    }
                    int n2 = priority = condition.isBorder() ? 3 : 2;
                    if (consumerInst instanceof InvokeInstruction) {
                        ConstantPoolGen constantPool = methodGen.getConstantPool();
                        String methodName = ((InvokeInstruction)consumerInst).getMethodName(constantPool);
                        if (methodName.equals("assertTrue") || methodName.equals("checkArgument") || methodName.equals("isLegal") || methodName.equals("isTrue")) {
                            return liveValue == 1 ? (condition.isBorder() ? 5 : 3) : 1;
                        }
                        if (methodName.equals("assertFalse") || methodName.equals("isFalse")) {
                            return liveValue == 0 ? (condition.isBorder() ? 5 : 3) : 1;
                        }
                    }
                }
            }
        }
        return priority;
    }

    private InstructionHandle getConsumer(MethodGen methodGen, InstructionHandle start) {
        int depth = 1;
        InstructionHandle cur = start;
        while (cur != null) {
            Instruction inst = cur.getInstruction();
            if ((depth -= inst.consumeStack(methodGen.getConstantPool())) <= 0) {
                return cur;
            }
            depth += inst.produceStack(methodGen.getConstantPool());
            if (inst instanceof BranchInstruction) {
                if (inst instanceof GotoInstruction) {
                    cur = ((GotoInstruction)inst).getTarget();
                    continue;
                }
                if (!(inst instanceof IfInstruction)) {
                    return null;
                }
            }
            cur = cur.getNext();
        }
        return null;
    }

    private int getIntValue(InstructionHandle handle) {
        Instruction instruction = handle.getInstruction();
        if (instruction instanceof ICONST) {
            return ((ICONST)instruction).getValue().intValue();
        }
        return -1;
    }

    @Override
    public void report() {
    }
}

