/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.TypeAnnotation;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.NameMatch;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class TypeMatcher
implements Matcher {
    private final NameMatch descriptor;
    private final String role;
    private final String typeParameters;

    public String toString() {
        return "Type(descriptor=\"" + this.descriptor.getValue() + "\")";
    }

    public TypeMatcher(String descriptor, String role, String typeParameters) {
        this.descriptor = new NameMatch(descriptor);
        this.role = role;
        this.typeParameters = typeParameters;
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        TypeAnnotation typeAnnotation = bugInstance.getPrimaryType();
        if (this.role != null && !"".equals(this.role)) {
            for (BugAnnotation bugAnnotation : bugInstance.getAnnotations()) {
                if (!(bugAnnotation instanceof TypeAnnotation) || !this.role.equals(bugAnnotation.getDescription())) continue;
                typeAnnotation = (TypeAnnotation)bugAnnotation;
                break;
            }
        }
        if (typeAnnotation == null) {
            return false;
        }
        String typeDesctiptor = typeAnnotation.getTypeDescriptor();
        if (!this.descriptor.match(typeDesctiptor)) {
            return false;
        }
        return this.typeParameters == null || this.typeParameters.equals(typeAnnotation.getTypeParameters());
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("descriptor", this.descriptor.getSpec());
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        attributes.addOptionalAttribute("typeParameters", this.typeParameters);
        attributes.addOptionalAttribute("role", this.role);
        xmlOutput.openCloseTag("Type", attributes);
    }
}

