/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.BugSet;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.WideComboBox;
import edu.umd.cs.findbugs.util.Util;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED", "SE_BAD_FIELD", "SE_BAD_FIELD_STORE"})
public abstract class CloudCommentsPane
extends JPanel {
    private static final String MSG_REVIEW = L10N.getLocalString("dlg.cloud.add_review", "Click to add review...");
    private static final String MSG_REVIEW_MULTI = L10N.getLocalString("dlg.cloud.add_review_multi", "Click to add review to {0} bugs...");
    private static final String MSG_OVERWRITE_REVIEW = L10N.getLocalString("dlg.cloud.ovwrt_review_multi", "Click to overwrite {0} reviews...");
    private JTextArea cloudReportPane;
    protected JComponent cancelLink;
    protected JComponent signInOutLink;
    private JTextArea commentBox;
    private JButton submitCommentButton;
    private WideComboBox<String> designationCombo;
    private JPanel mainPanel;
    private JScrollPane _cloudReportScrollPane;
    protected JLabel titleLabel;
    protected JTextArea cloudDetailsLabel;
    private JPanel dumbPanelSignInOutLink;
    private JLabel lastSavedLabel;
    private JPanel cards;
    private JButton bulkReviewButton;
    private JLabel warningLabel;
    protected BugCollection _bugCollection;
    protected BugInstance _bugInstance;
    private BugAspects _bugAspects;
    private final Executor backgroundExecutor = Executors.newCachedThreadPool();
    private final Cloud.CloudStatusListener _cloudStatusListener = new MyCloudStatusListener();
    private Cloud lastCloud = null;
    private Font plainCommentFont;
    private String lastCommentText = null;
    private Set<BugInstance> lastBugsEdited = Collections.emptySet();
    private boolean clickedBulkReview = false;
    private boolean updatingHeader = false;

    private void addNotInCloudCard() {
        JPanel panel5 = new JPanel();
        this.cards.add((Component)panel5, "NOT_IN_CLOUD");
    }

    public CloudCommentsPane() {
        this.$$$setupUI$$$();
        this.addNotInCloudCard();
        this.cloudReportPane.setBackground(this.getBackground());
        this.cloudReportPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this._cloudReportScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.commentBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CloudCommentsPane.this.commentBoxClicked();
            }
        });
        this.commentBox.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            private void changed() {
                CloudCommentsPane.this.updateSaveButton();
            }
        });
        this.commentBox.setBorder(new EtchedBorder(1));
        this.dumbPanelSignInOutLink.setPreferredSize(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.designationCombo.removeAllItems();
        final List<String> userDesignationKeys = I18N.instance().getUserDesignationKeys(true);
        for (String designation : userDesignationKeys) {
            this.designationCombo.addItem(I18N.instance().getUserDesignation(designation));
        }
        this.designationCombo.addItem(null);
        this.designationCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component real = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    return real;
                }
                if (index == -1) {
                    return real;
                }
                JPanel panel = new JPanel(new GridBagLayout());
                panel.setBorder(new EmptyBorder(3, 3, 3, 3));
                int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.fill = 1;
                gbc.weightx = 1.0;
                gbc.anchor = 17;
                panel.add(real, gbc);
                gbc.weightx = 0.0;
                gbc.anchor = 13;
                gbc.insets = new Insets(0, 10, 0, 0);
                JLabel label = new JLabel(KeyEvent.getKeyModifiersText(mask) + "-" + (index + 1));
                label.setForeground(Color.GRAY);
                panel.add((Component)label, gbc);
                panel.setBackground(real.getBackground());
                return panel;
            }
        });
        this.designationCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex;
                if (!CloudCommentsPane.this.updatingHeader && (selectedIndex = CloudCommentsPane.this.designationCombo.getSelectedIndex()) >= 0) {
                    CloudCommentsPane.this.setDesignation((String)userDesignationKeys.get(selectedIndex));
                }
            }
        });
        this.submitCommentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudCommentsPane.this.submitComment(CloudCommentsPane.this.getSelectedBugs());
            }
        });
        this.cloudDetailsLabel.setBackground(null);
        this.cloudDetailsLabel.setBorder(null);
        this.plainCommentFont = this.commentBox.getFont().deriveFont(0);
        this.cloudReportPane.setFont(this.plainCommentFont);
        this.setDefaultComment(MSG_REVIEW);
        this.commentBox.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CloudCommentsPane.this.commentBox.setForeground(null);
                CloudCommentsPane.this.commentBox.setFont(CloudCommentsPane.this.plainCommentFont);
                if (CloudCommentsPane.this.isDefaultComment(CloudCommentsPane.this.commentBox.getText())) {
                    CloudCommentsPane.this.resetCommentBoxFont();
                    CloudCommentsPane.this.setCommentText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                String text = CloudCommentsPane.this.commentBox.getText();
                if (CloudCommentsPane.this.isDefaultComment(text)) {
                    CloudCommentsPane.this.refresh();
                } else if (text.equals(CloudCommentsPane.this.lastCommentText)) {
                    if (text.trim().length() == 0) {
                        CloudCommentsPane.this.refresh();
                    }
                } else {
                    CloudCommentsPane.this.submitComment(CloudCommentsPane.this.getSelectedBugs());
                    CloudCommentsPane.this.resetCommentBoxFont();
                }
            }
        });
        this.commentBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    CloudCommentsPane.this.cancelClicked();
                } else if (e.getKeyCode() == 10 && (e.getModifiersEx() & 0x80) != 0) {
                    CloudCommentsPane.this.submitComment(CloudCommentsPane.this.getSelectedBugs());
                }
            }
        });
        this.submitCommentButton.setToolTipText("Submit review [Enter]");
        this.cancelLink.setToolTipText("Cancel [Esc]");
        this.bulkReviewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudCommentsPane.this.clickedBulkReview = true;
                CloudCommentsPane.this.refresh();
            }
        });
        this.setCanAddComments(false, false);
        this.setLastSaved(0L);
        this.updateBugCommentsView();
    }

    private boolean isDefaultComment(String text) {
        if (text.equals(MSG_REVIEW)) {
            return true;
        }
        try {
            new MessageFormat(MSG_REVIEW_MULTI).parse(text);
            return true;
        }
        catch (ParseException e) {
            try {
                new MessageFormat(MSG_OVERWRITE_REVIEW).parse(text);
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
    }

    private void updateSaveButton() {
        boolean changed = this.commentWasChanged();
        this.submitCommentButton.setEnabled(changed);
        this.submitCommentButton.setText(changed ? L10N.getLocalString("dlg.save_btn", "Save") : L10N.getLocalString("dlg.saved_btn", "Saved"));
        this.cancelLink.setEnabled(false);
    }

    private void setCommentText(String t) {
        this.lastCommentText = t;
        if (!this.commentBox.getText().equals(t)) {
            this.commentBox.setText(t);
        }
    }

    private void resetCommentBoxFont() {
        this.commentBox.setFont(this.plainCommentFont);
        this.commentBox.setForeground(null);
    }

    private void setDefaultComment(String defaultComment) {
        this.setCommentText(defaultComment);
        this.commentBox.setForeground(Color.DARK_GRAY);
        this.commentBox.setFont(this.plainCommentFont.deriveFont(2));
    }

    private void createUIComponents() {
        this.setupLinksOrButtons();
    }

    protected abstract void setupLinksOrButtons();

    private void applyToBugs(final BugAction bugAction) {
        Executor executor = this.backgroundExecutor;
        final AtomicInteger shownErrorMessages = new AtomicInteger(0);
        for (final BugInstance bug : this.getSelectedBugs()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (shownErrorMessages.get() > 5) {
                        return;
                    }
                    try {
                        bugAction.execute(bug);
                    }
                    catch (Throwable e) {
                        if (shownErrorMessages.addAndGet(1) > 5) {
                            return;
                        }
                        JOptionPane.showMessageDialog(CloudCommentsPane.this, "Error while submitting cloud reviews:\n" + e.getClass().getSimpleName() + ": " + e.getMessage(), "Review Submission Error", 0);
                    }
                }
            });
        }
    }

    protected void signInOrOutClicked() {
        if (this._bugCollection != null) {
            Cloud.SigninState state;
            final Cloud cloud = this._bugCollection.getCloud();
            if ("edu.umd.cs.findbugs.cloud.doNothingCloud".equals(cloud.getPlugin().getId())) {
                this.changeClicked();
            }
            if ((state = cloud.getSigninState()) == Cloud.SigninState.SIGNED_IN) {
                this.backgroundExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        cloud.signOut();
                        CloudCommentsPane.this.refresh();
                    }
                });
                this.refresh();
            } else if (state.couldSignIn()) {
                this.backgroundExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            cloud.signIn();
                        }
                        catch (Exception e) {
                            CloudCommentsPane.this._bugCollection.getProject().getGuiCallback().showMessageDialog("The FindBugs Cloud could not be contacted at this time.\n\n" + Util.getNetworkErrorMessage(e));
                        }
                        CloudCommentsPane.this.refresh();
                    }
                });
                this.refresh();
            }
        }
    }

    protected void commentBoxClicked() {
        if (this.commentWasChanged()) {
            return;
        }
        this.setCanAddComments(false, true);
        CommentInfo commentInfo = new CommentInfo().invoke();
        boolean sameText = commentInfo.isSameText();
        String txt = commentInfo.getTxt();
        if (!sameText) {
            txt = "";
        }
        if (txt == null || txt.trim().length() == 0) {
            txt = "";
        }
        this.resetCommentBoxFont();
        boolean sameTextInBox = this.commentBox.getText().equals(txt);
        this.setCommentText(txt);
        int start = this.commentBox.getSelectionStart();
        int end = this.commentBox.getSelectionEnd();
        if (!(this.commentBox.hasFocus() || sameTextInBox && start == 0 && end == txt.length())) {
            this.commentBox.setSelectionStart(0);
            this.commentBox.setSelectionEnd(txt.length());
        }
        this.updateSaveButton();
    }

    private boolean commentWasChanged() {
        String text = this.commentBox.getText();
        boolean b = !this.isDefaultComment(text);
        boolean b3 = text.equals(this.lastCommentText);
        return b && !b3;
    }

    public boolean canSetDesignations() {
        Cloud plugin;
        List<BugInstance> bugs = this.getSelectedBugs();
        if (bugs.isEmpty()) {
            return true;
        }
        Cloud cloud = plugin = this._bugCollection != null ? this._bugCollection.getCloud() : null;
        if (plugin == null) {
            return false;
        }
        for (BugInstance b : bugs) {
            if (!plugin.canStoreUserAnnotation(b)) continue;
            return true;
        }
        return false;
    }

    public void setDesignation(final String designationKey) {
        final AtomicBoolean stop = new AtomicBoolean(false);
        this.applyToBugs(new BugAction(){

            @Override
            public void execute(BugInstance bug) {
                String claimedBy;
                Cloud plugin;
                if (stop.get()) {
                    return;
                }
                String key = designationKey;
                String oldValue = bug.getUserDesignationKey();
                if (key.equals(oldValue)) {
                    return;
                }
                Cloud cloud = plugin = CloudCommentsPane.this._bugCollection != null ? CloudCommentsPane.this._bugCollection.getCloud() : null;
                if (plugin != null && "I_WILL_FIX".equals(key) && plugin.supportsClaims() && (claimedBy = plugin.claimedBy(bug)) != null && !plugin.getUser().equals(claimedBy)) {
                    int result = JOptionPane.showConfirmDialog(null, bug.getMessage() + "\n" + claimedBy + " has already said they will fix this issue\n" + "Do you want to also be listed as fixing this issue?\n" + "If so, please coordinate with " + claimedBy, "Issue already claimed", 1);
                    if (result == 2) {
                        stop.set(true);
                        return;
                    }
                    if (result != 0) {
                        key = "MUST_FIX";
                    }
                }
                CloudCommentsPane.this.changeDesignationOfBugRightNow(bug, key);
                CloudCommentsPane.this.refresh();
            }
        });
    }

    private void submitComment(List<BugInstance> selectedBugs) {
        String comment = this.commentBox.getText();
        if (this.isDefaultComment(comment)) {
            comment = "";
        }
        if (this.designationCombo.getSelectedItem() != null) {
            int index = this.designationCombo.getSelectedIndex();
            String choice = index == -1 ? Cloud.UserDesignation.UNCLASSIFIED.name() : I18N.instance().getUserDesignationKeys(true).get(index);
            this.setDesignation(choice);
        }
        final String finalComment = comment;
        this.applyToBugs(new BugAction(){

            @Override
            public void execute(BugInstance bug) {
                bug.setAnnotationText(finalComment, CloudCommentsPane.this._bugCollection);
                CloudCommentsPane.this.refresh();
                CloudCommentsPane.this.setLastSaved(System.currentTimeMillis());
            }
        });
        this.refresh();
        this.setCanAddComments(true, false);
        this.commentBox.requestFocus();
    }

    private void setLastSaved(long date) {
        if (date > 0L) {
            this.lastSavedLabel.setText("saved " + DateFormat.getDateTimeInstance(3, 3).format(new Date(date)));
        } else {
            this.lastSavedLabel.setText("");
        }
    }

    protected void cancelClicked() {
        this.setDefaultComment(this.lastCommentText);
        this.setCanAddComments(true, false);
    }

    private List<BugInstance> getSelectedBugs() {
        if (this._bugInstance != null) {
            return Collections.singletonList(this._bugInstance);
        }
        if (this._bugAspects != null) {
            ArrayList<BugInstance> set = new ArrayList<BugInstance>();
            for (BugLeafNode node : this._bugAspects.getMatchingBugs(BugSet.getMainBugSet())) {
                if (BugSet.suppress(node)) continue;
                set.add(node.getBug());
            }
            return set;
        }
        return Collections.emptyList();
    }

    private boolean hasSelectedBugs() {
        return this._bugInstance != null || this._bugAspects != null;
    }

    protected void changeClicked() {
        ArrayList<CloudPlugin> plugins = new ArrayList<CloudPlugin>();
        ArrayList<String> descriptions = new ArrayList<String>();
        ArrayList<CloudPlugin> clouds = new ArrayList<CloudPlugin>(DetectorFactoryCollection.instance().getRegisteredClouds().values());
        Collections.sort(clouds, new Comparator<CloudPlugin>(){

            @Override
            public int compare(CloudPlugin o1, CloudPlugin o2) {
                return o1.getDescription().compareToIgnoreCase(o2.getDescription());
            }
        });
        for (CloudPlugin plugin : clouds) {
            boolean disabled = this.isDisabled(plugin);
            if (disabled || plugin.isHidden()) continue;
            descriptions.add(plugin.getDescription());
            plugins.add(plugin);
        }
        this.showCloudChooser(plugins, descriptions);
    }

    protected abstract boolean isDisabled(CloudPlugin var1);

    protected abstract void showCloudChooser(List<CloudPlugin> var1, List<String> var2);

    protected void changeCloud(String newCloudId) {
        String oldCloudId = this._bugCollection.getCloud().getPlugin().getId();
        if (!oldCloudId.equals(newCloudId)) {
            this._bugCollection.getProject().setCloudId(newCloudId);
            MainFrame.getInstance().setProjectChanged(true);
            this.backgroundExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    CloudCommentsPane.this._bugCollection.reinitializeCloud();
                    Cloud cloud = CloudCommentsPane.this._bugCollection.getCloud();
                    if (cloud != null) {
                        cloud.waitUntilIssueDataDownloaded();
                    }
                    CloudCommentsPane.this.updateCloudListeners(CloudCommentsPane.this._bugCollection);
                    CloudCommentsPane.this.refresh();
                }
            });
            this.refresh();
        }
    }

    public void setBugCollection(BugCollection bugCollection) {
        this.updateCloudListeners(bugCollection);
        this._bugCollection = bugCollection;
        this._bugInstance = null;
        this._bugAspects = null;
        this.refresh();
    }

    public void setBugInstance(BugInstance bugInstance) {
        this.setBugs(bugInstance, null);
    }

    public void setBugAspects(BugAspects aspects) {
        this.setBugs(null, aspects);
    }

    private void setBugs(BugInstance bugInstance, BugAspects bugAspects) {
        if (this._bugInstance == bugInstance && this._bugAspects == bugAspects) {
            return;
        }
        if (!this.canNavigateAway()) {
            return;
        }
        this._bugInstance = bugInstance;
        this._bugAspects = bugAspects;
        this.refresh();
    }

    public boolean canNavigateAway() {
        if (this.commentWasChanged()) {
            this.submitComment(this.getSelectedBugs());
            return true;
        }
        return true;
    }

    protected void changeDesignationOfBugRightNow(BugInstance bug, String designationKey) {
        String oldValue = bug.getUserDesignationKey();
        if (designationKey.equals(oldValue)) {
            return;
        }
        bug.setUserDesignationKey(designationKey, this._bugCollection);
    }

    public void refresh() {
        this.updateBugCommentsView();
    }

    public void updateCloud() {
        this.updateCloudListeners(this._bugCollection);
        this.refresh();
    }

    private void updateCloudListeners(BugCollection newBugCollection) {
        Cloud newCloud;
        Cloud cloud = newCloud = newBugCollection == null ? null : newBugCollection.getCloud();
        if (this._bugCollection != null && this.lastCloud != newCloud && this.lastCloud != null) {
            this.lastCloud.removeStatusListener(this._cloudStatusListener);
        }
        if (this.lastCloud != newCloud && newCloud != null) {
            this.lastCloud = newCloud;
            newCloud.addStatusListener(this._cloudStatusListener);
        }
    }

    private boolean inCloud(Collection<BugInstance> bugs) {
        Cloud cloud = this._bugCollection.getCloud();
        for (BugInstance b : bugs) {
            if (!cloud.isInCloud(b)) continue;
            return true;
        }
        return false;
    }

    private void updateBugCommentsView() {
        String report;
        List<BugInstance> bugs = this.getSelectedBugs();
        if (this._bugCollection == null) {
            this.signInOutLink.setVisible(false);
            this.cloudDetailsLabel.setText("");
            this.cloudReportPane.setText("");
            this.titleLabel.setText("<html>Reviews");
            return;
        }
        this.updateHeader();
        Cloud cloud = this._bugCollection.getCloud();
        CloudPlugin plugin = cloud.getPlugin();
        String details = plugin.getDetails();
        this.cloudDetailsLabel.setText(details);
        if (bugs.isEmpty()) {
            this.setCanAddComments(false, false);
            return;
        }
        long lastSaved = -1L;
        if (bugs.size() > 1) {
            int totalReviews = 0;
            int bugsWithReviews = 0;
            for (BugInstance bug : bugs) {
                int reviewers;
                long newTs = cloud.getUserTimestamp(bug);
                if (bug.hasSomeUserAnnotation() && newTs > 0L && (lastSaved == -1L || lastSaved < newTs)) {
                    lastSaved = newTs;
                }
                if ((reviewers = cloud.getNumberReviewers(bug)) > 0) {
                    ++bugsWithReviews;
                }
                totalReviews += reviewers;
            }
            report = bugs.size() + " bug" + (bugs.size() == 1 ? "" : "s") + " selected\n";
            report = report + bugsWithReviews + " reviewed bug" + (bugsWithReviews == 1 ? "" : "s") + " / " + totalReviews + " total review" + (totalReviews == 1 ? "" : "s");
        } else {
            BugInstance bug = bugs.get(0);
            if (bug.hasSomeUserAnnotation()) {
                lastSaved = bug.getUserTimestamp();
            }
            report = cloud.getCloudReportWithoutMe(bug);
        }
        this.setLastSaved(lastSaved);
        this.cloudReportPane.setText(report);
        CommentInfo commentInfo = new CommentInfo().invoke();
        boolean sameText = commentInfo.isSameText();
        String txt = commentInfo.getTxt();
        CardLayout cl = (CardLayout)this.cards.getLayout();
        HashSet<BugInstance> newBugSet = new HashSet<BugInstance>(bugs);
        boolean sameBugs = newBugSet.equals(this.lastBugsEdited);
        if (!sameBugs) {
            this.lastBugsEdited = newBugSet;
            this.clickedBulkReview = false;
        }
        if (!this.inCloud(bugs)) {
            cl.show(this.cards, "NOT_IN_CLOUD");
        } else if (bugs.size() > 1 && !this.clickedBulkReview) {
            this.warningLabel.setText("<HTML>" + bugs.size() + " bugs are selected.<BR>Click to review them all at once.");
            cl.show(this.cards, "WARNING");
        } else {
            cl.show(this.cards, "COMMENTS");
        }
        if (!sameText) {
            txt = MessageFormat.format(MSG_OVERWRITE_REVIEW, bugs.size());
            this.setDefaultComment(txt);
        } else if (txt == null || txt.trim().length() == 0) {
            txt = bugs.size() > 1 ? MessageFormat.format(MSG_REVIEW_MULTI, bugs.size()) : MSG_REVIEW;
            this.setDefaultComment(txt);
        } else {
            this.resetCommentBoxFont();
            this.setCommentText(txt);
        }
        this.setCanAddComments(cloud.canStoreUserAnnotation(bugs.get(0)), false);
        this.updateSaveButton();
    }

    private void updateHeader() {
        String userStr;
        Cloud cloud = this._bugCollection.getCloud();
        CloudPlugin plugin = cloud.getPlugin();
        if (this.hasSelectedBugs()) {
            CommentInfo commentInfo = new CommentInfo().invoke();
            boolean sameDesignation = commentInfo.isSameDesignation();
            String designation = commentInfo.getDesignation();
            if (!sameDesignation) {
                designation = null;
            }
            this.updatingHeader = true;
            this.designationCombo.setSelectedIndex(I18N.instance().getUserDesignationKeys(true).indexOf(designation));
            this.updatingHeader = false;
            this.setCanAddComments(true, true);
        } else {
            this.setCanAddComments(false, false);
        }
        Cloud.SigninState state = cloud.getSigninState();
        String stateStr = state == Cloud.SigninState.NO_SIGNIN_REQUIRED ? "" : "" + (Object)((Object)state);
        String string = userStr = cloud.getUser() == null ? "" : cloud.getUser();
        if ("edu.umd.cs.findbugs.cloud.doNothingCloud".equals(plugin.getId())) {
            this.titleLabel.setText("<html><b>No cloud selected");
        } else {
            this.titleLabel.setText("<html><b>Reviews - " + cloud.getCloudName() + "</b>" + "<br><font style='font-size: x-small;color:darkgray'>" + stateStr + (userStr.length() > 0 ? " - " + userStr : ""));
        }
        switch (state) {
            case NO_SIGNIN_REQUIRED: 
            case SIGNING_IN: {
                this.signInOutLink.setVisible(false);
                break;
            }
            case SIGNED_IN: {
                this.setSignInOutText("sign out");
                this.signInOutLink.setVisible(true);
                break;
            }
            default: {
                if (!state.couldSignIn()) break;
                this.setSignInOutText("sign in");
                this.signInOutLink.setVisible(true);
            }
        }
        if ("edu.umd.cs.findbugs.cloud.doNothingCloud".equals(cloud.getPlugin().getId())) {
            this.setSignInOutText("enable cloud plugin...");
            this.signInOutLink.setVisible(true);
        }
    }

    private void setCanAddComments(boolean canClick, boolean canEnter) {
        this.submitCommentButton.setEnabled(canClick || canEnter);
        this.designationCombo.setEnabled(canClick || canEnter);
        this.commentBox.setEnabled(canClick || canEnter);
    }

    protected abstract void setSignInOutText(String var1);

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), null));
        this._cloudReportScrollPane = new JScrollPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 6;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this._cloudReportScrollPane, gbc);
        this.cloudReportPane = new JTextArea();
        this.cloudReportPane.setEditable(false);
        this.cloudReportPane.setLineWrap(true);
        this.cloudReportPane.setText("<html>\r\n  <head>\r\n    \r\n  </head>\r\n  <body>\r\n  </body>\r\n</html>\r\n");
        this.cloudReportPane.setWrapStyleWord(true);
        this._cloudReportScrollPane.setViewportView(this.cloudReportPane);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new GridBagLayout());
        panel1.setBackground(new Color(-3355444));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 6;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.mainPanel.add((Component)panel1, gbc);
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-16751002)), null));
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(new Font(this.titleLabel.getFont().getName(), 1, 14));
        this.titleLabel.setForeground(new Color(-16777216));
        this.titleLabel.setText("FindBugs Cloud - signed in");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        panel1.add((Component)this.titleLabel, gbc);
        this.dumbPanelSignInOutLink = new JPanel();
        this.dumbPanelSignInOutLink.setLayout(new GridBagLayout());
        this.dumbPanelSignInOutLink.setOpaque(false);
        this.dumbPanelSignInOutLink.setPreferredSize(new Dimension(50, 10));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.fill = 1;
        panel1.add((Component)this.dumbPanelSignInOutLink, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        this.dumbPanelSignInOutLink.add((Component)this.signInOutLink, gbc);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        panel2.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)panel2, gbc);
        this.cloudDetailsLabel = new JTextArea();
        this.cloudDetailsLabel.setEditable(false);
        this.cloudDetailsLabel.setFont(new Font(this.cloudDetailsLabel.getFont().getName(), 2, 10));
        this.cloudDetailsLabel.setForeground(new Color(-10066330));
        this.cloudDetailsLabel.setLineWrap(true);
        this.cloudDetailsLabel.setMaximumSize(new Dimension(100, 50));
        this.cloudDetailsLabel.setMinimumSize(new Dimension(50, 16));
        this.cloudDetailsLabel.setOpaque(false);
        this.cloudDetailsLabel.setPreferredSize(new Dimension(100, 31));
        this.cloudDetailsLabel.setText("Comments are stored on the FindBugs Cloud at http://findbugs-cloud.appspot.com");
        this.cloudDetailsLabel.setWrapStyleWord(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel2.add((Component)this.cloudDetailsLabel, gbc);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.mainPanel.add((Component)panel3, gbc);
        this.cards = new JPanel();
        this.cards.setLayout(new CardLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.mainPanel.add((Component)this.cards, gbc);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new GridBagLayout());
        this.cards.add((Component)panel4, "COMMENTS");
        this.designationCombo = new WideComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(5, 0, 0, 0);
        panel4.add(this.designationCombo, gbc);
        JScrollPane scrollPane1 = new JScrollPane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.gridheight = 4;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel4.add((Component)scrollPane1, gbc);
        scrollPane1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null));
        this.commentBox = new JTextArea();
        this.commentBox.setLineWrap(true);
        this.commentBox.setRows(5);
        this.commentBox.setText(" ");
        this.commentBox.setWrapStyleWord(true);
        scrollPane1.setViewportView(this.commentBox);
        this.submitCommentButton = new JButton();
        this.submitCommentButton.setText("Save");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        panel4.add((Component)this.submitCommentButton, gbc);
        this.lastSavedLabel = new JLabel();
        this.lastSavedLabel.setFont(new Font(this.lastSavedLabel.getFont().getName(), 2, 9));
        this.lastSavedLabel.setText("saved at");
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        panel4.add((Component)this.lastSavedLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 1;
        panel4.add((Component)this.cancelLink, gbc);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new GridBagLayout());
        this.cards.add((Component)panel5, "WARNING");
        this.warningLabel = new JLabel();
        this.warningLabel.setHorizontalAlignment(0);
        this.warningLabel.setHorizontalTextPosition(0);
        this.warningLabel.setText("<HTML>Multiple bugs are selected.<BR>Click to review them all at once.");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(10, 10, 10, 10);
        panel5.add((Component)this.warningLabel, gbc);
        this.bulkReviewButton = new JButton();
        this.bulkReviewButton.setText("Bulk Review");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 10, 10);
        panel5.add((Component)this.bulkReviewButton, gbc);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private class CommentInfo {
        private String txt;
        private boolean sameText;
        private String designation;
        private boolean sameDesignation;

        private CommentInfo() {
        }

        public String getTxt() {
            return this.txt;
        }

        public boolean isSameText() {
            return this.sameText;
        }

        public String getDesignation() {
            return this.designation;
        }

        public boolean isSameDesignation() {
            return this.sameDesignation;
        }

        public CommentInfo invoke() {
            this.txt = null;
            this.sameText = true;
            this.designation = null;
            this.sameDesignation = true;
            for (BugInstance bug : CloudCommentsPane.this.getSelectedBugs()) {
                String newText = bug.getAnnotationText();
                if (this.txt == null) {
                    this.txt = newText;
                } else if (!Util.nullSafeEquals(this.txt, newText)) {
                    this.sameText = false;
                }
                String newDesignation = bug.getUserDesignationKey();
                if (this.designation == null) {
                    this.designation = newDesignation;
                    continue;
                }
                if (Util.nullSafeEquals(this.designation, newDesignation)) continue;
                this.sameDesignation = false;
            }
            return this;
        }
    }

    private static interface BugAction {
        public void execute(BugInstance var1);
    }

    private class MyCloudStatusListener
    implements Cloud.CloudStatusListener {
        private MyCloudStatusListener() {
        }

        @Override
        public void handleIssueDataDownloadedEvent() {
            CloudCommentsPane.this.refresh();
        }

        @Override
        public void handleStateChange(Cloud.SigninState oldState, Cloud.SigninState state) {
            CloudCommentsPane.this.updateHeader();
            CloudCommentsPane.this.refresh();
        }
    }
}

