/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.tools;

import edu.umd.cs.findbugs.tools.FilterAndCombineBitfieldPropertyDatabase;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.WillClose;

public class FilterPropertyDatabase {
    static final int FLAGS = 5;

    public static void main(String[] args) throws IOException {
        InputStream inSource = System.in;
        if (args.length > 0) {
            inSource = new FileInputStream(args[0]);
        }
        FilterPropertyDatabase.process(inSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void process(@WillClose InputStream inSource) throws UnsupportedEncodingException, IOException {
        BufferedReader in = null;
        try {
            String s;
            in = new BufferedReader(Util.getReader(inSource));
            Pattern p = Pattern.compile("^(([^,]+),.+),([0-9]+)\\|(.+)$");
            while ((s = in.readLine()) != null) {
                int accFlags;
                String className;
                Matcher m = p.matcher(s);
                if (!m.find() || FilterAndCombineBitfieldPropertyDatabase.getStatus(className = m.group(2)) == FilterAndCombineBitfieldPropertyDatabase.Status.UNEXPOSED || ((accFlags = Integer.parseInt(m.group(3))) & 5) == 0) continue;
                System.out.println(s);
            }
        }
        catch (Throwable throwable) {
            Util.closeSilently(in);
            throw throwable;
        }
        Util.closeSilently(in);
    }
}

