/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;

public class DefectDensity {
    private static void printRow(Object ... values) {
        for (Object s : values) {
            System.out.print(s);
            System.out.print("\t");
        }
        System.out.println();
    }

    public static double density(int bugs, int ncss) {
        if (ncss == 0) {
            return Double.NaN;
        }
        long bugsPer10KNCSS = Math.round(10000.0 * (double)bugs / (double)ncss);
        return (double)bugsPer10KNCSS / 10.0;
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 1 || args.length > 0 && "-help".equals(args[0])) {
            System.err.println("Usage: " + DefectDensity.class.getName() + " [<infile>]");
            System.exit(1);
        }
        FindBugs.setNoAnalysis();
        SortedBugCollection origCollection = new SortedBugCollection();
        int argCount = 0;
        if (argCount == args.length) {
            origCollection.readXML(System.in);
        } else {
            origCollection.readXML(args[argCount]);
        }
        ProjectStats stats = origCollection.getProjectStats();
        DefectDensity.printRow("kind", "name", "density/KNCSS", "bugs", "NCSS");
        double projectDensity = DefectDensity.density(stats.getTotalBugs(), stats.getCodeSize());
        DefectDensity.printRow("project", origCollection.getCurrentAppVersion().getReleaseName(), projectDensity, stats.getTotalBugs(), stats.getCodeSize());
        for (PackageStats p : stats.getPackageStats()) {
            double packageDensity;
            if (p.getTotalBugs() <= 4 || Double.isNaN(packageDensity = DefectDensity.density(p.getTotalBugs(), p.size())) || packageDensity < projectDensity) continue;
            DefectDensity.printRow("package", p.getPackageName(), packageDensity, p.getTotalBugs(), p.size());
            for (PackageStats.ClassStats c : p.getSortedClassStats()) {
                double density;
                if (c.getTotalBugs() <= 4 || Double.isNaN(density = DefectDensity.density(c.getTotalBugs(), c.size())) || density < packageDensity) continue;
                DefectDensity.printRow("class", c.getName(), density, c.getTotalBugs(), c.size());
            }
        }
    }
}

