/*
 * Decompiled with CFR 0.152.
 */
package com.jsuereth.pgp;

import com.jsuereth.pgp.KeyNotFoundException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Security;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M4q!\u0001\u0002\u0011\u0002\u0007\u0005\u0011BA\u0007Qk\nd\u0017nY&fs2K7.\u001a\u0006\u0003\u0007\u0011\t1\u0001]4q\u0015\t)a!\u0001\u0005kgV,'/\u001a;i\u0015\u00059\u0011aA2p[\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\")\u0011\u0003\u0001C\u0001%\u00051A%\u001b8ji\u0012\"\u0012a\u0005\t\u0003\u0017QI!!\u0006\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u0006/\u00011\t\u0001G\u0001\u0014m\u0016\u0014\u0018NZ=NKN\u001c\u0018mZ3TiJ,\u0017-\u001c\u000b\u00043q1\u0003CA\u0006\u001b\u0013\tYBBA\u0004C_>dW-\u00198\t\u000bu1\u0002\u0019\u0001\u0010\u0002\u000b%t\u0007/\u001e;\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013AA5p\u0015\u0005\u0019\u0013\u0001\u00026bm\u0006L!!\n\u0011\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\u0006OY\u0001\r\u0001K\u0001\u0007_V$\b/\u001e;\u0011\u0005}I\u0013B\u0001\u0016!\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u0015a\u0003\u0001\"\u0002.\u0003E1XM]5gs6+7o]1hK\u001aKG.\u001a\u000b\u000439\u0012\u0004\"B\u000f,\u0001\u0004y\u0003CA\u00101\u0013\t\t\u0004E\u0001\u0003GS2,\u0007\"B\u0014,\u0001\u0004y\u0003\"\u0002\u001b\u0001\t\u000b)\u0014a\u0005<fe&4\u00170T3tg\u0006<Wm\u0015;sS:<GC\u0001\u001cB!\t9dH\u0004\u00029yA\u0011\u0011\bD\u0007\u0002u)\u00111\bC\u0001\u0007yI|w\u000e\u001e \n\u0005ub\u0011A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n11\u000b\u001e:j]\u001eT!!\u0010\u0007\t\u000bu\u0019\u0004\u0019\u0001\u001c\t\u000b\r\u0003a\u0011\u0001#\u0002-Y,'/\u001b4z'&<g.\u0019;ve\u0016\u001cFO]3b[N$2!G#H\u0011\u00151%\t1\u0001\u001f\u0003\ri7o\u001a\u0005\u0006\u0011\n\u0003\rAH\u0001\ng&<g.\u0019;ve\u0016DQA\u0013\u0001\u0005\u0006-\u000b1C^3sS\u001aL8+[4oCR,(/\u001a$jY\u0016$2!\u0007'O\u0011\u0015i\u0015\n1\u00010\u0003\r\u0011\u0018m\u001e\u0005\u0006\u0011&\u0003\ra\f\u0005\u0006!\u0002!)!U\u0001\u0016m\u0016\u0014\u0018NZ=TS\u001et\u0017\r^;sKN#(/\u001b8h)\rI\"k\u0015\u0005\u0006\r>\u0003\rA\u000e\u0005\u0006\u0011>\u0003\rA\u000e\u0005\u0006+\u0002!\tBV\u0001\u001am\u0016\u0014\u0018NZ=NKN\u001c\u0018mZ3TiJ,\u0017-\u001c%fYB,'\u000fF\u0002XU.$\"!\u0007-\t\u000be#\u0006\u0019\u0001.\u0002\r\u001d,GoS3z!\u0011Y1,\u00181\n\u0005qc!!\u0003$v]\u000e$\u0018n\u001c82!\tYa,\u0003\u0002`\u0019\t!Aj\u001c8h!\t\t\u0007.D\u0001c\u0015\t\u0019G-A\u0004pa\u0016t\u0007o\u001a9\u000b\u0005\u00154\u0017\u0001\u00042pk:\u001c\u0017pY1ti2,'\"A4\u0002\u0007=\u0014x-\u0003\u0002jE\na\u0001k\u0012)Qk\nd\u0017nY&fs\")Q\u0004\u0016a\u0001=!)q\u0005\u0016a\u0001Q!)Q\u000e\u0001C\t]\u0006ab/\u001a:jMf\u001c\u0016n\u001a8biV\u0014Xm\u0015;sK\u0006l7\u000fS3ma\u0016\u0014HcA8reR\u0011\u0011\u0004\u001d\u0005\u000632\u0004\rA\u0017\u0005\u0006\r2\u0004\rA\b\u0005\u0006\u00112\u0004\rA\b")
public interface PublicKeyLike {
    public boolean verifyMessageStream(InputStream var1, OutputStream var2);

    public static /* synthetic */ boolean verifyMessageFile$(PublicKeyLike $this, File input, File output) {
        return $this.verifyMessageFile(input, output);
    }

    default public boolean verifyMessageFile(File input, File output) {
        boolean bl;
        FileInputStream in = new FileInputStream(input);
        FileOutputStream out = new FileOutputStream(output);
        try {
            bl = this.verifyMessageStream(in, out);
        }
        finally {
            in.close();
            out.close();
        }
        return bl;
    }

    public static /* synthetic */ String verifyMessageString$(PublicKeyLike $this, String input) {
        return $this.verifyMessageString(input);
    }

    default public String verifyMessageString(String input) {
        ByteArrayInputStream in = new ByteArrayInputStream(input.getBytes());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Predef$.MODULE$.assert(this.verifyMessageStream(in, out));
        return out.toString(Charset.defaultCharset().name());
    }

    public boolean verifySignatureStreams(InputStream var1, InputStream var2);

    public static /* synthetic */ boolean verifySignatureFile$(PublicKeyLike $this, File raw, File signature) {
        return $this.verifySignatureFile(raw, signature);
    }

    default public boolean verifySignatureFile(File raw, File signature) {
        boolean bl;
        FileInputStream in = new FileInputStream(raw);
        FileInputStream in2 = new FileInputStream(signature);
        try {
            bl = this.verifySignatureStreams(in, in2);
        }
        finally {
            in.close();
            in2.close();
        }
        return bl;
    }

    public static /* synthetic */ boolean verifySignatureString$(PublicKeyLike $this, String msg, String signature) {
        return $this.verifySignatureString(msg, signature);
    }

    default public boolean verifySignatureString(String msg, String signature) {
        boolean bl;
        ByteArrayInputStream in = new ByteArrayInputStream(msg.getBytes());
        ByteArrayInputStream in2 = new ByteArrayInputStream(signature.getBytes());
        try {
            bl = this.verifySignatureStreams(in, in2);
        }
        finally {
            in.close();
            in2.close();
        }
        return bl;
    }

    public static /* synthetic */ boolean verifyMessageStreamHelper$(PublicKeyLike $this, InputStream input, OutputStream output, Function1 getKey) {
        return $this.verifyMessageStreamHelper(input, output, (Function1<Object, PGPPublicKey>)getKey);
    }

    default public boolean verifyMessageStreamHelper(InputStream input, OutputStream output, Function1<Object, PGPPublicKey> getKey) {
        InputStream in = PGPUtil.getDecoderStream((InputStream)input);
        JcaPGPObjectFactory tmp = new JcaPGPObjectFactory(in);
        PGPCompressedData c1 = (PGPCompressedData)tmp.nextObject();
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(c1.getDataStream());
        PGPOnePassSignatureList sigList = (PGPOnePassSignatureList)pgpFact.nextObject();
        PGPOnePassSignature ops = sigList.get(0);
        PGPLiteralData p2 = (PGPLiteralData)pgpFact.nextObject();
        InputStream dIn = p2.getInputStream();
        PGPPublicKey key = (PGPPublicKey)getKey.apply((Object)BoxesRunTime.boxToLong((long)ops.getKeyID()));
        ops.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider(Security.getProvider("BC")), key);
        int ch = dIn.read();
        while (ch >= 0) {
            ops.update((byte)ch);
            output.write(ch);
            ch = dIn.read();
        }
        PGPSignatureList p3 = (PGPSignatureList)pgpFact.nextObject();
        return ops.verify(p3.get(0));
    }

    public static /* synthetic */ boolean verifySignatureStreamsHelper$(PublicKeyLike $this, InputStream msg, InputStream signature, Function1 getKey) {
        return $this.verifySignatureStreamsHelper(msg, signature, (Function1<Object, PGPPublicKey>)getKey);
    }

    default public boolean verifySignatureStreamsHelper(InputStream msg, InputStream signature, Function1<Object, PGPPublicKey> getKey) {
        Tuple2 tuple2;
        InputStream in = PGPUtil.getDecoderStream((InputStream)signature);
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(in);
        Object o = pgpFact.nextObject();
        Object object = o;
        if (object instanceof PGPCompressedData) {
            PGPCompressedData pGPCompressedData = (PGPCompressedData)object;
            tuple2 = new Tuple2((Object)((PGPSignatureList)pgpFact.nextObject()), (Object)new JcaPGPObjectFactory(pGPCompressedData.getDataStream()));
        } else if (object instanceof PGPSignatureList) {
            PGPSignatureList pGPSignatureList = (PGPSignatureList)object;
            tuple2 = new Tuple2((Object)pGPSignatureList, (Object)pgpFact);
        } else {
            throw new MatchError(object);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        PGPSignatureList sigList = (PGPSignatureList)tuple22._1();
        JcaPGPObjectFactory pgpFact2 = (JcaPGPObjectFactory)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)sigList, (Object)pgpFact2);
        Tuple2 tuple24 = tuple23;
        PGPSignatureList sigList2 = (PGPSignatureList)tuple24._1();
        JcaPGPObjectFactory pgpFact3 = (JcaPGPObjectFactory)tuple24._2();
        BufferedInputStream dIn = new BufferedInputStream(msg);
        PGPSignature sig = sigList2.get(0);
        PGPPublicKey pGPPublicKey = (PGPPublicKey)getKey.apply((Object)BoxesRunTime.boxToLong((long)sig.getKeyID()));
        if (pGPPublicKey == null) {
            throw new KeyNotFoundException(sig.getKeyID());
        }
        sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider(Security.getProvider("BC")), pGPPublicKey);
        int ch = dIn.read();
        while (ch >= 0) {
            sig.update((byte)ch);
            ch = dIn.read();
        }
        dIn.close();
        boolean bl = sig.verify();
        return bl;
    }

    public static void $init$(PublicKeyLike $this) {
    }
}

