/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FriendlyParamsTranslator$ {
    public static FriendlyParamsTranslator$ MODULE$;
    private final Map<String, String> validConfigMap;

    static {
        new FriendlyParamsTranslator$();
    }

    public Map<String, String> validConfigMap() {
        return this.validConfigMap;
    }

    public String extractContentInBracket(String raw, Iterator<String> it, String expected) {
        if (!raw.startsWith("(")) {
            throw new IllegalArgumentException("Invalid configuration, example valid configuration: " + expected);
        }
        String withBrackets = raw.endsWith(")") ? raw : this.parseUntilFound(raw, ")", it);
        return withBrackets.substring(1, withBrackets.length() - 1);
    }

    public String parseUntilFound(String value, String endsWith, Iterator<String> it) {
        String next;
        block2: {
            while (it.hasNext()) {
                next = (String)it.next();
                if (!next.endsWith(endsWith)) {
                    value = value + next;
                    continue;
                }
                break block2;
            }
            throw new IllegalArgumentException("Unable to find '" + endsWith + "'");
        }
        return value + next;
    }

    public String[] parseCompoundParams(String rawParamsStr, Iterator<String> it, String expected) {
        String[] rawClassArr = this.extractContentInBracket(rawParamsStr, it, expected).split(",");
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rawClassArr)).map((Function1 & Serializable & scala.Serializable)rawClass -> {
            void var1_1;
            String trimmed = rawClass.trim();
            return trimmed.length() > 1 && trimmed.startsWith("\"") && trimmed.endsWith("\"") ? trimmed.substring(1, trimmed.length() - 1) : var1_1;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public String translateCompoundParams(String rawParamsStr, Iterator<String> it, String expected) {
        String[] paramsArr = this.parseCompoundParams(rawParamsStr, it, expected);
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paramsArr)).mkString(" ");
    }

    public Map<String, String> parseParams(String rawParamsStr, Iterator<String> it, Set<String> validParamSet, String expected) {
        Map map;
        if (rawParamsStr.length() > 0) {
            String paramsStr = this.extractContentInBracket(rawParamsStr, it, expected);
            String[] configsArr = paramsStr.split(",");
            Tuple2[] tuples = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configsArr)).map((Function1 & Serializable & scala.Serializable)configStr -> {
                String key;
                String[] keyValueArr = configStr.trim().split("=");
                if (keyValueArr.length == 2) {
                    key = keyValueArr[0].trim();
                    if (!validParamSet.contains((Object)key)) {
                        throw new IllegalArgumentException("Invalid configuration: " + key);
                    }
                } else {
                    throw new IllegalArgumentException("Invalid configuration: " + configStr);
                }
                String rawValue = keyValueArr[1].trim();
                String value = rawValue.startsWith("\"") && rawValue.endsWith("\"") && rawValue.length() > 1 ? rawValue.substring(1, rawValue.length() - 1) : rawValue;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            map = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tuples)));
        } else {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return map;
    }

    public String translateConfigs(String rawConfigs) {
        String[] configArr = rawConfigs.split(" ");
        String[] translatedArr = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configArr)).map((Function1 & Serializable & scala.Serializable)config -> {
            String translated;
            Option translatedOpt = MODULE$.validConfigMap().get(config);
            Option option = translatedOpt;
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException("Invalid config value: " + config);
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            String string = translated = (String)some.value();
            return string;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])translatedArr)).mkString();
    }

    public String getTranslatedConfig(Map<String, String> paramsMap) {
        String string;
        Option configOpt = paramsMap.get((Object)"config");
        Option option = configOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String configStr = (String)some.value();
            string = this.translateConfigs(configStr);
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    public List<String> translateCompound(String inputString, String friendlyName, String dash, Iterator<String> it) {
        ListBuffer translatedList = new ListBuffer();
        String[] elements = this.parseCompoundParams(inputString.substring(friendlyName.length()), it, friendlyName + "(a, b, c)");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])elements)).foreach((Function1 & Serializable & scala.Serializable)element -> {
            translatedList.$plus$eq((Object)dash);
            return translatedList.$plus$eq(element);
        });
        return translatedList.toList();
    }

    public List<String> parseDashAndArgument(String dash, String replaceDeprecated, Iterator<String> it) {
        ListBuffer translatedList = new ListBuffer();
        translatedList.$plus$eq((Object)dash);
        Object object = it.hasNext() ? translatedList.$plus$eq(it.next()) : BoxedUnit.UNIT;
        return translatedList.toList();
    }

    public String showDeprecated(String inputString, String replaceDeprecated) {
        return inputString;
    }

    public List<String> translateKeyValue(String value, String elementName, String translated, List<String> requiredAttrList, List<String> optionalAttrList, String exampleValid, Iterator<String> it) {
        List<String> list = requiredAttrList;
        Map<String, String> paramsMap = this.parseParams(value.substring(elementName.length()), it, (Set<String>)optionalAttrList.$colon$colon$colon(list).toSet(), exampleValid);
        ListBuffer translatedList = new ListBuffer();
        translatedList.$plus$eq((Object)(translated + this.getTranslatedConfig(paramsMap)));
        ((List)requiredAttrList.filter((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)FriendlyParamsTranslator$.$anonfun$translateKeyValue$1(attr)))).foreach((Function1 & Serializable & scala.Serializable)attr -> {
            Option option = paramsMap.get(attr);
            Option option2 = option;
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new IllegalArgumentException(elementName + " requires " + attr + " to be specified, example: " + exampleValid);
                }
                throw new MatchError((Object)option2);
            }
            Some some = (Some)option2;
            String value = (String)some.value();
            ListBuffer listBuffer = translatedList.$plus$eq((Object)value);
            return listBuffer;
        });
        ((List)optionalAttrList.filter((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)FriendlyParamsTranslator$.$anonfun$translateKeyValue$3(attr)))).foreach((Function1 & Serializable & scala.Serializable)attr -> {
            BoxedUnit boxedUnit;
            Option option = paramsMap.get(attr);
            Option option2 = option;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String value = (String)some.value();
                boxedUnit = translatedList.$plus$eq((Object)value);
            } else if (None$.MODULE$.equals(option2)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option2);
            }
            return boxedUnit;
        });
        return translatedList.toList();
    }

    public String[] translateArguments(String[] args) {
        ListBuffer newArgs = new ListBuffer();
        Iterator it = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).iterator();
        while (it.hasNext()) {
            ListBuffer listBuffer;
            String s = (String)it.next();
            if (s.startsWith("include")) {
                Predef$.MODULE$.println((Object)"WARNING: Argument 'include' has been deprecated and will be removed in a future version of ScalaTest.  Please use -n instead.");
                listBuffer = newArgs.$plus$plus$eq((TraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-n", this.translateCompoundParams(s.substring("include".length()), (Iterator<String>)it, "include(a, b, c)")})));
                continue;
            }
            if (s.startsWith("exclude")) {
                Predef$.MODULE$.println((Object)"WARNING: Argument 'exclude' has been deprecated and will be removed in a future version of ScalaTest.  Please use -l instead.");
                listBuffer = newArgs.$plus$plus$eq((TraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-l", this.translateCompoundParams(s.substring("exclude".length()), (Iterator<String>)it, "exclude(a, b, c)")})));
                continue;
            }
            if (s.startsWith("stdout")) {
                Predef$.MODULE$.println((Object)"WARNING: Argument 'stdout' has been deprecated and will be removed in a future version of ScalaTest.  Please use -o instead.");
                listBuffer = newArgs.$plus$eq((Object)("-o" + this.getTranslatedConfig(this.parseParams(s.substring("stdout".length()), (Iterator<String>)it, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"config"}))), "stdout"))));
                continue;
            }
            if (s.startsWith("stderr")) {
                Predef$.MODULE$.println((Object)"WARNING: Argument 'stderr' has been deprecated and will be removed in a future version of ScalaTest.  Please use -e instead.");
                listBuffer = newArgs.$plus$eq((Object)("-e" + this.getTranslatedConfig(this.parseParams(s.substring("stderr".length()), (Iterator<String>)it, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"config"}))), "stderr"))));
                continue;
            }
            if (s.startsWith("file")) {
                Predef$.MODULE$.println((Object)"WARNING: Argument 'file' has been deprecated and will be removed in a future version of ScalaTest.  Please use -f instead.");
                listBuffer = newArgs.$plus$plus$eq(this.translateKeyValue(s, "file", "-f", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"filename"})), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"config"})), "file(directory=\"xxx\")", (Iterator<String>)it));
                continue;
            }
            if (s.startsWith("junitxml")) {
                Predef$.MODULE$.println((Object)"WARNING: Argument 'junitxml' has been deprecated and will be removed in a future version of ScalaTest.  Please use -u instead.");
                listBuffer = newArgs.$plus$plus$eq(this.translateKeyValue(s, "junitxml", "-u", (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"directory"})), (List<String>)Nil$.MODULE$, "junitxml(directory=\"xxx\")", (Iterator<String>)it));
                continue;
            }
            if (s.startsWith("html")) {
                BoxedUnit boxedUnit;
                Option cssOpt;
                Option directoryOpt;
                Predef$.MODULE$.println((Object)"WARNING: Argument 'html' has been deprecated and will be removed in a future version of ScalaTest.  Please use -h instead.");
                newArgs.$plus$eq((Object)"-h");
                Map<String, String> paramsMap = this.parseParams(s.substring("html".length()), (Iterator<String>)it, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"directory", "css"}))), "html(directory=\"xxx\", css=\"xxx\")");
                Option option = directoryOpt = paramsMap.get((Object)"directory");
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalArgumentException("html requires directory to be specified, example: html(directory=\"xxx\", css=\"xxx\")");
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                String dir = (String)some.value();
                ListBuffer listBuffer2 = newArgs.$plus$eq((Object)dir);
                Option option2 = cssOpt = paramsMap.get((Object)"css");
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    String css = (String)some2.value();
                    if (css.length() == 0) {
                        throw new IllegalArgumentException("html's css value cannot be empty string, example: html(directory=\"xxx\", css=\"xxx\")");
                    }
                    newArgs.$plus$eq((Object)"-Y");
                    boxedUnit = newArgs.$plus$eq((Object)css);
                } else if (None$.MODULE$.equals(option2)) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option2);
                }
                listBuffer = boxedUnit;
                continue;
            }
            if (s.startsWith("reporterclass")) {
                String clazzname;
                Option classnameOpt;
                Predef$.MODULE$.println((Object)"WARNING: Argument 'reporterclass' has been deprecated and will be removed in a future version of ScalaTest.  Please use -g instead.");
                Map<String, String> paramsMap = this.parseParams(s.substring("reporterclass".length()), (Iterator<String>)it, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"classname", "config"}))), "reporterclass(classname=\"xxx\")");
                Option option = classnameOpt = paramsMap.get((Object)"classname");
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalArgumentException("reporterclass requires classname to be specified, example: reporterclass(classname=\"xxx\")");
                    }
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                String string = clazzname = (String)some.value();
                String classname = string;
                String dashR = "-C" + this.getTranslatedConfig(paramsMap);
                if (dashR.indexOf("S") >= 0) {
                    throw new IllegalArgumentException("Cannot specify an 'shortstacks' (present short stack traces) configuration parameter for a custom reporter: " + dashR + " " + classname);
                }
                if (dashR.indexOf("F") >= 0) {
                    throw new IllegalArgumentException("Cannot specify an 'fullstacks' (present full stack traces) configuration parameter for a custom reporter: " + dashR + " " + classname);
                }
                if (dashR.indexOf("W") >= 0) {
                    throw new IllegalArgumentException("Cannot specify an 'nocolor' (present without color) configuration parameter for a custom reporter: " + dashR + " " + classname);
                }
                if (dashR.indexOf("D") >= 0) {
                    throw new IllegalArgumentException("Cannot specify an 'durations' (present all durations) configuration parameter for a custom reporter: " + dashR + " " + classname);
                }
                newArgs.$plus$eq((Object)dashR);
                listBuffer = newArgs.$plus$eq((Object)classname);
                continue;
            }
            listBuffer = s.startsWith("membersonly") ? newArgs.$plus$plus$eq(this.translateCompound(s, "membersonly", "-m", (Iterator<String>)it)) : (s.startsWith("wildcard") ? newArgs.$plus$plus$eq(this.translateCompound(s, "wildcard", "-w", (Iterator<String>)it)) : newArgs.$plus$eq((Object)s));
        }
        return (String[])newArgs.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public static final /* synthetic */ boolean $anonfun$translateKeyValue$1(String attr) {
        String string = attr;
        String string2 = "config";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$translateKeyValue$3(String attr) {
        String string = attr;
        String string2 = "config";
        return string == null ? string2 != null : !string.equals(string2);
    }

    private FriendlyParamsTranslator$() {
        MODULE$ = this;
        this.validConfigMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dropteststarting"), (Object)"N"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"droptestsucceeded"), (Object)"C"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"droptestignored"), (Object)"X"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"droptestpending"), (Object)"E"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dropsuitestarting"), (Object)"H"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dropsuitecompleted"), (Object)"L"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dropinfoprovided"), (Object)"O"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nocolor"), (Object)"W"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"shortstacks"), (Object)"S"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fullstacks"), (Object)"F"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"durations"), (Object)"D")}));
    }
}

