/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import org.xerial.core.ErrorCode;
import org.xerial.core.XerialError;
import org.xerial.core.XerialErrorCode;

public class DSNumber
implements Comparable<DSNumber> {
    private int[] index;

    public DSNumber(int n) {
        this.index = new int[1];
        this.index[0] = n;
    }

    public DSNumber(DSNumber dSNumber, int n) {
        if (dSNumber == null) {
            this.index = new int[1];
            this.index[0] = n;
        } else {
            this.index = new int[dSNumber.size() + 1];
            for (int i = 0; i < dSNumber.size(); ++i) {
                this.index[i] = dSNumber.get(i);
            }
            this.index[dSNumber.size()] = n;
        }
    }

    public static DSNumber root() {
        return new DSNumber(0);
    }

    public static DSNumber parse(String string) {
        if (string == null) {
            throw new NullPointerException("indexStr");
        }
        String[] stringArray = string.split("\\.");
        if (stringArray == null) {
            throw new XerialError((ErrorCode)XerialErrorCode.INVALID_INPUT, "invalid format:" + string);
        }
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return new DSNumber(nArray);
    }

    private DSNumber(int[] nArray) {
        this.index = nArray;
    }

    public DSNumber parent() {
        if (this.index.length <= 1) {
            return null;
        }
        int[] nArray = new int[this.index.length - 1];
        for (int i = 0; i < this.index.length - 1; ++i) {
            nArray[i] = this.index[i];
        }
        return new DSNumber(nArray);
    }

    public DSNumber tail() {
        if (this.index.length < 2) {
            return null;
        }
        int[] nArray = new int[this.index.length - 1];
        for (int i = 1; i < this.index.length; ++i) {
            nArray[i - 1] = this.index[i];
        }
        return new DSNumber(nArray);
    }

    public DSNumber sibling() {
        int[] nArray = new int[this.index.length];
        for (int i = 0; i < this.index.length; ++i) {
            nArray[i] = this.index[i];
        }
        int n = this.index.length - 1;
        nArray[n] = nArray[n] + 1;
        return new DSNumber(nArray);
    }

    public int size() {
        return this.index.length;
    }

    public boolean hasParent() {
        return this.index.length > 1;
    }

    public boolean hasTail() {
        return this.index.length > 1;
    }

    public int get(int n) {
        return this.index[n];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.index.length; ++i) {
            if (i != 0) {
                stringBuilder.append(".");
            }
            stringBuilder.append(this.index[i]);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        DSNumber dSNumber = (DSNumber)DSNumber.class.cast(object);
        if (this.index.length != dSNumber.index.length) {
            return false;
        }
        for (int i = 0; i < this.index.length; ++i) {
            if (this.index[i] == dSNumber.index[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(DSNumber dSNumber) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n2 < this.index.length && n < dSNumber.index.length; ++n2, ++n) {
            int n4 = this.index[n2];
            int n5 = dSNumber.index[n];
            n3 = n4 - n5;
            if (n3 == 0) continue;
            return n3;
        }
        if (n2 < this.index.length) {
            return 1;
        }
        if (n < dSNumber.index.length) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int n = 3;
        for (int i = 0; i < this.index.length; ++i) {
            n += 137 * this.index[i];
        }
        return n / 1987;
    }
}

