/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class RedBlackTree<Key extends Comparable<Key>, Value>
implements Map<Key, Value> {
    private static final boolean RED = true;
    private static final boolean BLACK = false;
    private Node root;
    private int size = 0;
    private Value previousValue;

    public RedBlackTree() {
        this.clear();
    }

    @Override
    public Value get(Object object) {
        return this.get(this.root, (Comparable)object);
    }

    public Value get(Node node, Key Key) {
        if (node == null) {
            return null;
        }
        int n = Key.compareTo(node.key);
        if (n == 0) {
            return node.value;
        }
        if (n < 0) {
            return this.get(node.left, Key);
        }
        return this.get(node.right, Key);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public Value put(Key Key, Value Value) {
        this.previousValue = null;
        this.root = this.insert(this.root, Key, Value);
        this.root.color = false;
        return this.previousValue;
    }

    private Node insert(Node node, Key Key, Value Value) {
        int n;
        if (node == null) {
            this.previousValue = null;
            ++this.size;
            return new Node(this, Key, Value);
        }
        if (this.isRed(node.left) && this.isRed(node.right)) {
            this.flipColor(node);
        }
        if ((n = Key.compareTo(node.key)) == 0) {
            this.previousValue = node.value;
            node.value = Value;
        } else if (n < 0) {
            node.left = this.insert(node.left, Key, Value);
        } else {
            node.right = this.insert(node.right, Key, Value);
        }
        if (this.isRed(node.right)) {
            node = this.rotateLeft(node);
        }
        if (this.isRed(node.left) && this.isRed(node.left.left)) {
            node = this.rotateRight(node);
        }
        return node;
    }

    private boolean isRed(Node node) {
        return node == null ? false : node.color;
    }

    private void flipColor(Node node) {
        node.color = !node.color;
        node.left.color = !node.left.color;
        node.right.color = !node.right.color;
    }

    private Node rotateLeft(Node node) {
        Node node2 = node.right;
        node.right = node2.left;
        node2.left = node;
        node2.color = node2.left.color;
        node.color = true;
        return node2;
    }

    private Node rotateRight(Node node) {
        Node node2 = node.left;
        node.left = node2.right;
        node2.right = node;
        node2.color = node.color;
        node.color = true;
        return node2;
    }

    private Node fixUp(Node node) {
        if (this.isRed(node.right)) {
            node = this.rotateLeft(node);
        }
        if (this.isRed(node.left) && this.isRed(node.left.left)) {
            node = this.rotateRight(node);
        }
        if (this.isRed(node.left) && this.isRed(node.right)) {
            this.flipColor(node);
        }
        return node;
    }

    @Override
    public void clear() {
        this.root = null;
        this.previousValue = null;
        this.size = 0;
    }

    public Node delete(Node node, Key Key) {
        int n = Key.compareTo(node.key);
        if (n < 0) {
            node.left = this.delete(node.left, Key);
        }
        return null;
    }

    private Node deleteMin(Node node) {
        if (node.left == null) {
            return null;
        }
        if (this.isRed(node.left) || !this.isRed(node.left.left)) {
            // empty if block
        }
        return null;
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Set<Key> keySet() {
        return null;
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> map) {
        for (Map.Entry<Key, Value> entry : map.entrySet()) {
            this.put((Key)((Comparable)entry.getKey()), entry.getValue());
        }
    }

    @Override
    public Value remove(Object object) {
        this.root = this.delete(this.root, (Comparable)object);
        this.root.color = false;
        return this.previousValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsValue(Object object) {
        return false;
    }

    @Override
    public Collection<Value> values() {
        return null;
    }

    private class Node {
        Key key;
        Value value;
        Node left;
        Node right;
        boolean color;
        final /* synthetic */ RedBlackTree this$0;

        public Node(Key Key, Value Value) {
            this.this$0 = var1_1;
            this.key = Key;
            this.value = Value;
            this.color = true;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public Node(Key Key, Value Value, boolean bl) {
            this.this$0 = (RedBlackTree)n;
            this.key = Key;
            this.value = Value;
            this.color = bl;
        }
    }
}

