/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.graph;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialError;
import org.xerial.core.XerialErrorCode;
import org.xerial.util.IndexedSet;
import org.xerial.util.StringUtil;
import org.xerial.util.graph.AutomatonCursor;
import org.xerial.util.graph.AutomatonListener;
import org.xerial.util.graph.GraphvizHelper;

public class Automaton<State, Symbol> {
    private List<AutomatonListener<State, Symbol>> listenerList = new ArrayList<AutomatonListener<State, Symbol>>();
    private IndexedSet<State> stateSet = new IndexedSet();
    private Set<State> terminalState = new HashSet<State>();
    private HashMap<State, HashMap<Symbol, State>> transition = new HashMap();
    private HashMap<State, State> transitionForOtherInput = new HashMap();

    private Map<Symbol, State> getTransitionTableOf(State State2) {
        HashMap<Object, Object> hashMap = this.transition.get(State2);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.transition.put(State2, hashMap);
        }
        return hashMap;
    }

    public AutomatonCursor<State, Symbol> cursor(State State2) {
        return new CursorImpl(State2);
    }

    public Set<State> getStateSet() {
        return this.stateSet;
    }

    public Set<Symbol> getAcceptableSymbolSetOf(State State2) {
        if (!this.hasState(State2)) {
            throw new XerialError((ErrorCode)XerialErrorCode.INVALID_INPUT, String.format("state %s not found", State2));
        }
        return this.getTransitionTableOf(State2).keySet();
    }

    public Set<State> getAdjacentStates(State State2) {
        HashSet<State> hashSet = new HashSet<State>();
        if (this.transitionForOtherInput.containsKey(State2)) {
            hashSet.add(this.transitionForOtherInput.get(State2));
        }
        hashSet.addAll(this.getTransitionTableOf(State2).values());
        return hashSet;
    }

    public void addState(State State2) {
        this.stateSet.add(State2);
    }

    public void addTerminalState(State State2) {
        this.addState(State2);
        this.terminalState.add(State2);
    }

    public void addTransition(State State2, Symbol Symbol, State State3) {
        this.addState(State2);
        this.addState(State3);
        this.getTransitionTableOf(State2).put(Symbol, State3);
    }

    public void addStarTransition(State State2, State State3) {
        this.addState(State2);
        this.addState(State3);
        this.transitionForOtherInput.put(State2, State3);
    }

    public void addListener(AutomatonListener<State, Symbol> automatonListener) {
        this.listenerList.add(automatonListener);
    }

    public void remvoeListener(AutomatonListener<State, Symbol> automatonListener) {
        this.listenerList.remove(automatonListener);
    }

    public void clearListner() {
        this.listenerList.clear();
    }

    public boolean hasState(State State2) {
        return this.stateSet.contains(State2);
    }

    public String toString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (State State2 : this.transition.keySet()) {
            int n = this.stateSet.getID(State2);
            for (Map.Entry<Symbol, State> entry : this.getTransitionTableOf(State2).entrySet()) {
                arrayList.add(String.format("%s -> %s [%s]", State2, entry.getValue(), entry.getKey()));
            }
            if (!this.transitionForOtherInput.containsKey(State2)) continue;
            arrayList.add(String.format("%s -> %s [*]", State2, this.transitionForOtherInput.get(State2)));
        }
        return String.format("node:\n%s\nedge:\n%s", StringUtil.join(this.stateSet, ",\n"), StringUtil.join(arrayList, ",\n"));
    }

    public String toGraphviz() {
        StringWriter stringWriter = new StringWriter();
        GraphvizHelper graphvizHelper = new GraphvizHelper(stringWriter);
        graphvizHelper.beginDigraph("G");
        for (State State2 : this.stateSet) {
            graphvizHelper.node(this.stateSet.getID(State2), State2.toString());
        }
        for (State State2 : this.transition.keySet()) {
            int n = this.stateSet.getID(State2);
            for (Map.Entry<Symbol, State> entry : this.getTransitionTableOf(State2).entrySet()) {
                graphvizHelper.edge(n, this.stateSet.getID(entry.getValue()), entry.getKey().toString());
            }
            if (!this.transitionForOtherInput.containsKey(State2)) continue;
            graphvizHelper.edge(Integer.toString(n), this.transitionForOtherInput.get(State2).toString(), "*");
        }
        graphvizHelper.endDigraph();
        return stringWriter.toString();
    }

    private class CursorImpl
    implements AutomatonCursor<State, Symbol> {
        State currentState;

        public CursorImpl(State State2) {
            this.currentState = State2;
        }

        @Override
        public boolean canAccept(Symbol Symbol) {
            if (this.canAcceptAnySymbol()) {
                return true;
            }
            if (Symbol == null) {
                return false;
            }
            return Automaton.this.getTransitionTableOf(this.currentState).containsKey(Symbol);
        }

        @Override
        public Set<Symbol> getAcceptableSymbolSet() {
            return Automaton.this.getAcceptableSymbolSetOf(this.currentState);
        }

        @Override
        public boolean canAcceptAnySymbol() {
            return Automaton.this.transitionForOtherInput.containsKey(this.currentState);
        }

        @Override
        public State getState() {
            return this.currentState;
        }

        @Override
        public boolean isTerminal() {
            return Automaton.this.terminalState.contains(this.currentState);
        }

        @Override
        public AutomatonCursor<State, Symbol> reset(State State2) {
            if (!Automaton.this.hasState(State2)) {
                throw new XerialError((ErrorCode)XerialErrorCode.INVALID_INPUT, "no such state found: " + State2);
            }
            this.currentState = State2;
            return this;
        }

        @Override
        public State transit(Symbol Symbol) {
            Map map = Automaton.this.getTransitionTableOf(this.currentState);
            Object v = map.get(Symbol);
            if (v == null) {
                return this.otherTransit(Symbol);
            }
            for (AutomatonListener automatonListener : Automaton.this.listenerList) {
                automatonListener.onTansit(this.currentState, Symbol, v);
            }
            this.currentState = v;
            return this.currentState;
        }

        private State otherTransit(Symbol Symbol) {
            if (Automaton.this.transitionForOtherInput.containsKey(this.currentState)) {
                this.currentState = Automaton.this.transitionForOtherInput.get(this.currentState);
                return this.currentState;
            }
            throw new XerialError((ErrorCode)XerialErrorCode.INVALID_INPUT, "cannot accept the symbol:" + Symbol);
        }
    }
}

