/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.xerial.util.io.Base64;

public class Base64OutputStream
extends FilterOutputStream {
    private final boolean doEncode;
    private final Base64 base64;
    private final byte[] singleByte = new byte[1];

    public Base64OutputStream(OutputStream outputStream) {
        this(outputStream, true);
    }

    public Base64OutputStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        this.doEncode = bl;
        this.base64 = new Base64();
    }

    public Base64OutputStream(OutputStream outputStream, boolean bl, int n, byte[] byArray) {
        super(outputStream);
        this.doEncode = bl;
        this.base64 = new Base64(n, byArray);
    }

    @Override
    public void write(int n) throws IOException {
        this.singleByte[0] = (byte)n;
        this.write(this.singleByte, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n > byArray.length || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 > 0) {
            if (this.doEncode) {
                this.base64.encode(byArray, n, n2);
            } else {
                this.base64.decode(byArray, n, n2);
            }
            this.flush(false);
        }
    }

    private void flush(boolean bl) throws IOException {
        byte[] byArray;
        int n;
        int n2 = this.base64.avail();
        if (n2 > 0 && (n = this.base64.readResults(byArray = new byte[n2], 0, n2)) > 0) {
            this.out.write(byArray, 0, n);
        }
        if (bl) {
            this.out.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(true);
    }

    @Override
    public void close() throws IOException {
        if (this.doEncode) {
            this.base64.encode(this.singleByte, 0, -1);
        } else {
            this.base64.decode(this.singleByte, 0, -1);
        }
        this.flush();
        this.out.close();
    }
}

