/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.lens.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialError;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.ReflectionUtil;
import org.xerial.util.TypeConverter;
import org.xerial.util.TypeInfo;
import org.xerial.util.lens.ObjectLens;
import org.xerial.util.lens.impl.MapEntry;
import org.xerial.util.log.Logger;

public abstract class ParameterSetter {
    private static Logger _logger = Logger.getLogger(ParameterSetter.class);
    private final Class<?> parameterType;
    private final String cParamName;

    public ParameterSetter(Class<?> clazz, String string) {
        this.parameterType = clazz;
        this.cParamName = ObjectLens.getCanonicalParameterName(string);
    }

    public abstract void bind(Object var1, Object var2) throws XerialException;

    public abstract void bind(Object var1, Object var2, Object var3) throws XerialException;

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    public boolean acceptKeyAndValue() {
        return TypeInfo.isMap(this.getParameterType());
    }

    public String toString() {
        return String.format("%s[%s]", this.cParamName, this.parameterType.getSimpleName());
    }

    public String getCanonicalParameterName() {
        return this.cParamName;
    }

    public boolean equals(Object object) {
        ParameterSetter parameterSetter = (ParameterSetter)ParameterSetter.class.cast(object);
        if (parameterSetter == null) {
            return false;
        }
        return this.cParamName.equals(parameterSetter.cParamName);
    }

    public int hashCode() {
        return this.cParamName.hashCode();
    }

    public static ParameterSetter newSetter(Class<?> clazz, String string, Field field) {
        return new FieldSetter(clazz, string, field);
    }

    public static ParameterSetter newSetter(Class<?> clazz, String string, Method method) {
        return new MethodSetter(clazz, string, method);
    }

    public static ParameterSetter newKeySetter(Class<?> clazz) {
        return new MapEntryBinder(clazz, "key");
    }

    public static ParameterSetter newValueSetter(Class<?> clazz) {
        return new MapEntryBinder(clazz, "value");
    }

    public static ParameterSetter newMapEntrySetter(Class<?> clazz, Class<?> clazz2) {
        return new MapEntrySetter(clazz, clazz2);
    }

    private static class MapEntrySetter
    extends ParameterSetter {
        final Class<?> keyType;
        final Class<?> valueType;

        public MapEntrySetter(Class<?> clazz, Class<?> clazz2) {
            super(MapEntry.class, "entry");
            this.keyType = clazz;
            this.valueType = clazz2;
        }

        @Override
        public void bind(Object object, Object object2, Object object3) throws XerialException {
            if (object == null) {
                _logger.warn(String.format("cannot set (key, value) to null instance: (key:%s, value:%s)", object2, object3));
                return;
            }
            Map map = (Map)Map.class.cast(object);
            map.put(TypeConverter.convertType(this.keyType, object2), TypeConverter.convertType(this.valueType, object3));
        }

        @Override
        public void bind(Object object, Object object2) throws XerialException {
            Map map = (Map)Map.class.cast(object);
            if (map == null) {
                _logger.warn("not a map type: " + object);
                return;
            }
            MapEntry mapEntry = (MapEntry)MapEntry.class.cast(object2);
            if (mapEntry == null) {
                _logger.warn("not a map entry type: " + object2);
                return;
            }
            try {
                if (mapEntry.key != null) {
                    map.put(this.keyType.cast(mapEntry.key), this.valueType.cast(mapEntry.value));
                }
            }
            catch (ClassCastException classCastException) {
                _logger.warn("cannot convert type: " + classCastException);
                return;
            }
        }
    }

    public static class MapEntryBinder
    extends ParameterSetter {
        private final Field targetField;

        public MapEntryBinder(Class<?> clazz, String string) {
            super(clazz, string);
            try {
                this.targetField = MapEntry.class.getField(string);
            }
            catch (Exception exception) {
                throw new XerialError((ErrorCode)XerialErrorCode.INVALID_STATE, (Throwable)exception);
            }
        }

        @Override
        public void bind(Object object, Object object2) throws XerialException {
            ReflectionUtil.setFieldValue(object, this.targetField, object2);
        }

        @Override
        public void bind(Object object, Object object2, Object object3) throws XerialException {
            ReflectionUtil.setMapEntry(object, this.targetField, object2, object3);
        }
    }

    private static class MethodSetter
    extends ParameterSetter {
        private final Method setterMethod;

        public MethodSetter(Class<?> clazz, String string, Method method) {
            super(clazz, string);
            this.setterMethod = method;
        }

        @Override
        public void bind(Object object, Object object2) throws XerialException {
            ReflectionUtil.setValue(object, this.setterMethod, object2);
        }

        @Override
        public void bind(Object object, Object object2, Object object3) throws XerialException {
            throw new XerialException((ErrorCode)XerialErrorCode.UNSUPPORTED, "bind (key, value) is not supported for " + this.setterMethod);
        }
    }

    private static class FieldSetter
    extends ParameterSetter {
        private final Field targetField;

        public FieldSetter(Class<?> clazz, String string, Field field) {
            super(clazz, string);
            this.targetField = field;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
        }

        @Override
        public void bind(Object object, Object object2) throws XerialException {
            ReflectionUtil.setFieldValue(object, this.targetField, object2);
        }

        @Override
        public void bind(Object object, Object object2, Object object3) throws XerialException {
            ReflectionUtil.setMapEntry(object, this.targetField, object2, object3);
        }

        public Object get(Object object) throws XerialException {
            return ReflectionUtil.getFieldValue(object, this.targetField);
        }
    }
}

