/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.opt.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.xerial.core.XerialException;
import org.xerial.util.TypeInfo;
import org.xerial.util.opt.Option;
import org.xerial.util.opt.OptionParserException;
import org.xerial.util.opt.impl.OptionSetter;
import org.xerial.util.opt.impl.OptionSetterViaField;
import org.xerial.util.opt.impl.OptionSetterViaMethod;

public class OptionItem {
    private final Option optionDescriptor;
    private final OptionSetter optionSetter;

    public OptionItem(Method method) {
        Option option = method.getAnnotation(Option.class);
        if (option == null) {
            throw new IllegalArgumentException(method + " is not an option item");
        }
        this.optionDescriptor = option;
        this.optionSetter = new OptionSetterViaMethod(method);
    }

    public OptionItem(Field field) {
        Option option = field.getAnnotation(Option.class);
        if (option == null) {
            throw new IllegalArgumentException(field + " is not an option item");
        }
        this.optionDescriptor = option;
        this.optionSetter = new OptionSetterViaField(field);
    }

    public boolean equals(Object object) {
        if (object instanceof OptionItem) {
            OptionItem optionItem = (OptionItem)object;
            return this.optionDescriptor.equals(optionItem.optionDescriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.optionDescriptor.hashCode();
    }

    public boolean needsArgument() {
        return this.optionSetter.takesArgument();
    }

    public boolean hasSymbol() {
        return this.optionDescriptor.symbol() != null && this.optionDescriptor.symbol().length() > 0;
    }

    public boolean hasLongName() {
        return this.optionDescriptor.longName() != null && this.optionDescriptor.longName().length() > 0;
    }

    public Option getOption() {
        return this.optionDescriptor;
    }

    public boolean takesMultipleArguments() {
        return TypeInfo.isCollection(this.optionSetter.getOptionDataType());
    }

    public void setOption(Object object, String string) throws XerialException {
        this.optionSetter.setOption(object, string);
    }

    public void initialize(Object object) throws OptionParserException {
        this.optionSetter.initialize(object);
    }

    public String toString() {
        return String.format("-%s, --%s :%s", this.optionDescriptor.symbol(), this.optionDescriptor.longName(), this.optionDescriptor.description());
    }
}

