/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.circular;

import java.util.HashSet;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;

public final class CircularDependencyHelper {
    private CircularDependencyHelper() {
    }

    public static String formatMessage(ModuleRevisionId[] moduleRevisionIdArray) {
        HashSet<ModuleRevisionId> hashSet = new HashSet<ModuleRevisionId>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(moduleRevisionIdArray[0]);
        hashSet.add(moduleRevisionIdArray[0]);
        for (int i = 1; i < moduleRevisionIdArray.length; ++i) {
            stringBuffer.append("->");
            if (!hashSet.add(moduleRevisionIdArray[i])) {
                stringBuffer.append("...");
                break;
            }
            stringBuffer.append(moduleRevisionIdArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String formatMessage(ModuleDescriptor[] moduleDescriptorArray) {
        return CircularDependencyHelper.formatMessage(CircularDependencyHelper.toMrids(moduleDescriptorArray));
    }

    public static String formatMessageFromDescriptors(List list) {
        ModuleRevisionId[] moduleRevisionIdArray = new ModuleRevisionId[list.size()];
        int n = 0;
        for (ModuleDescriptor moduleDescriptor : list) {
            moduleRevisionIdArray[n] = moduleDescriptor.getModuleRevisionId();
            ++n;
        }
        return CircularDependencyHelper.formatMessage(moduleRevisionIdArray);
    }

    public static ModuleRevisionId[] toMrids(ModuleDescriptor[] moduleDescriptorArray) {
        ModuleRevisionId[] moduleRevisionIdArray = new ModuleRevisionId[moduleDescriptorArray.length];
        for (int i = 0; i < moduleDescriptorArray.length; ++i) {
            moduleRevisionIdArray[i] = moduleDescriptorArray[i].getModuleRevisionId();
        }
        return moduleRevisionIdArray;
    }
}

